package com.geoway.landteam.landcloud.service.customtask.task;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.repository.task.TaskNoticeRepository;
import com.geoway.landteam.customtask.repository.task.TaskNoticeUserRepository;
import com.geoway.landteam.customtask.task.entity.TaskNotice;
import com.geoway.landteam.customtask.task.entity.TaskNoticeUser;
import com.geoway.landteam.landcloud.common.util.orm.QuerySpecification;
import com.geoway.landteam.landcloud.core.model.pub.constants.TaskNoticeConstants;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;


@Service
@Transactional(rollbackFor = Exception.class)
public class MTaskNoticeServiceBg {
	
	@Autowired
	TaskNoticeRepository taskNoticeDao;
	 
	@Autowired
	TaskNoticeUserRepository taskNoticeUserDao;
	
	public void addAssignDataNotice(Long sendUser,Long wyry,
   		 List<String> ids,String xzqdm,Integer action){
		 if(ids == null || ids.size() == 0){
			 return;
		 }
	   	 TaskNotice notice = new TaskNotice();
	   	 String title = "指派任务通知";
	   	 if(action == TaskNoticeConstants.ACTION_CONFIRMED){
	   		 title = "区县已确认通知";
	   	 }else if(action == TaskNoticeConstants.ACTION_REVOKE){
	   		 title = "任务撤销通知";
	   	 } else if(action == TaskNoticeConstants.ACTION_REPROOF){
	   		 title = "重新举证通知";
	   	 }else if(action == TaskNoticeConstants.ACTION_CONFIRMED_CANCEL){
	   		 title = "区县确认取消通知";
	   	 }else if(action == TaskNoticeConstants.ACTION_AFTER_SUBMIT){
	   		 title = "成果数据提交返回通知";
	   	 }
   	 
		 notice.setTitle(title);
		 
		 Date now = new Date();
		 notice.setSendTime(now);
		 notice.setSendUser(sendUser);
		 notice.setState(1);
		 notice.setType(TaskNoticeConstants.TYPE_SYS);
		 notice.setRegion(xzqdm);
		 notice.setAction(action);
		 

		JSONObject jsonObject = new JSONObject();
		if(action == TaskNoticeConstants.ACTION_CONFIRMED){
			jsonObject.put("tag", 88);
		}else if(action == TaskNoticeConstants.ACTION_ASSIGN){
			jsonObject.put("tag", 99);
		}else if(action == TaskNoticeConstants.ACTION_REPROOF){
			jsonObject.put("tag", 99);
		}else if(action == TaskNoticeConstants.ACTION_REVOKE){
			jsonObject.put("tag", 1);
		}
		jsonObject.put("time", now.getTime());
		jsonObject.put("data", ids);
		notice.setContent(jsonObject.toString());
		
		TaskNotice taskNotice = taskNoticeDao.save(notice);
		
		TaskNoticeUser noticeUser = new TaskNoticeUser();
		noticeUser.setNoticeId(taskNotice.getId());
		noticeUser.setUserId(String.valueOf(wyry));
		noticeUser.setState(0);
		taskNoticeUserDao.save(noticeUser);
    }
	 
    public void addAssignNotice2User(Long sendUser,Long wyry,String title,String content,String xzqdm,Integer action){
		 
		 TaskNotice notice = new TaskNotice();
		 notice.setTitle(title);
		 
		 Date now = new Date();
		 notice.setSendTime(now);
		 notice.setSendUser(sendUser);
		 notice.setState(1);
		 notice.setType(TaskNoticeConstants.TYPE_NOTICE);
		 notice.setContent(content);
		 notice.setRegion(xzqdm);
		 notice.setAction(action);

		TaskNotice taskNotice = taskNoticeDao.save(notice);
		
		TaskNoticeUser noticeUser = new TaskNoticeUser();
		noticeUser.setNoticeId(taskNotice.getId());
		noticeUser.setUserId(String.valueOf(wyry));
		noticeUser.setState(0);
		taskNoticeUserDao.save(noticeUser);
	 }
    
    public List<String> combineAssginNotice(Long wyry,String xzqdm,Integer action){
		 List<String> results = new ArrayList<String>();
		 String filterParam = "Q_notice.action_N_EQ="+action+";Q_notice.region_S_EQ="+xzqdm;
		 filterParam += ";(Q_state_N_EQ=0;QOR_state_N_EQ=NULL);Q_userId_N_EQ=" + wyry;

  	 	List<TaskNoticeUser> userNotices = taskNoticeUserDao.findAll(new QuerySpecification<TaskNoticeUser>(filterParam));
  	 	for(TaskNoticeUser userNotice:userNotices){
  	 		TaskNotice notice = userNotice.getNotice();
  	 		if(notice.getType() == TaskNoticeConstants.TYPE_NOTICE ){
  	 			taskNoticeDao.deleteById(userNotice.getNoticeId());
  	 			taskNoticeUserDao.deleteById(userNotice.getId());
  	 		}else if(notice.getType() == TaskNoticeConstants.TYPE_SYS){
  	 			String jsonContent = notice.getContent();
  	 			JSONObject jsonObject =JSONObject.parseObject(JSONObject.toJSONString(jsonContent));

  	 			results.addAll(jsonObject.getJSONArray("data").toJavaList(String.class));
  	 			taskNoticeDao.deleteById(userNotice.getNoticeId());
  	 			taskNoticeUserDao.deleteById(userNotice.getId());
  	 		}
  	 	}
  	 	return results;
	}
    
    public List<TaskNoticeUser> findUserNoticeByFilter(String filterParam){
    	
      List<TaskNoticeUser> userNotices = taskNoticeUserDao.findAll(new QuerySpecification<TaskNoticeUser>(filterParam));
     
      return userNotices;
    }
    
    public TaskNotice addTaskNotice(String title,String content,String param,long sendUserId,
			int type,long receiveUserId,String xzqdm,int action){
		Date time = new Date();
		TaskNotice taskNotice = null;
		
		TaskNotice notice = new TaskNotice();
		notice.setTitle(title);
		notice.setSendTime(time);
		notice.setSendUser(sendUserId);
		notice.setState(1);
		notice.setType(type);
		notice.setRegion(xzqdm);
		notice.setAction(action);
		notice.setData(param);
		notice.setContent(content);
		taskNotice = taskNoticeDao.save(notice);
		
		TaskNoticeUser noticeUser = new TaskNoticeUser();
		noticeUser.setNoticeId(taskNotice.getId());
		noticeUser.setUserId(String.valueOf(receiveUserId));
		noticeUser.setState(0);
		taskNoticeUserDao.save(noticeUser);
			
		return taskNotice;
	}
}

