package com.geoway.landteam.landcloud.service.customtask.task;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.pub.entity.TaskRecord;
import com.geoway.landteam.customtask.pub.entity.TaskRecordTemp;
import com.geoway.landteam.customtask.repository.task.TaskRecordRepository;
import com.geoway.landteam.customtask.repository.task.TaskRecordTempRepository;
import com.geoway.landteam.customtask.repository.task.TskAssignRecordRepository;
import com.geoway.landteam.customtask.task.dto.AssignRecordDTO;
import com.geoway.landteam.customtask.task.entity.TskAssignRecord;
import com.geoway.landteam.landcloud.common.util.orm.QueryParamUtil;
import com.geoway.landteam.landcloud.common.util.orm.QuerySpecification;
import com.geoway.landteam.landcloud.core.model.pub.constants.JobConstants;
import com.geoway.landteam.landcloud.core.model.user.entity.LandUser;
import com.geoway.landteam.landcloud.core.repository.user.LandUserRepository;
import com.gw.base.log.GwLoger;
import com.gw.base.log.GiLoger;
import com.gw.base.data.GwValidateException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import java.util.*;

@Service
@Transactional(rollbackFor = Exception.class)
public class MTaskRecordService {

    private final GiLoger logger = GwLoger.getLoger(MTaskRecordService.class);
    @Autowired
    TaskRecordRepository taskRecordRepository;

    @Autowired
    TaskRecordTempRepository taskRecordTempRepository;

    @Autowired
    LandUserRepository landUserRepository;

    @Autowired
    TskAssignRecordRepository tskAssignRecordRepository;

    public List<TaskRecord> findByTypeAndState(Integer type, Integer state) {
        return taskRecordRepository.findByTypeAndState(type, state,"v2");
    }

    public int findByTypeAndParamAndStarttime(Integer type, String params, Date starttime) {
        return taskRecordRepository.findByTypeAndParamAndStarttime(type, params, starttime);
    }

    public void state2Success(String id) {
        taskRecordRepository.updateState(JobConstants.JOB_STATE_SUCCESS, id);
    }

    public void state2Fail(String id,String error) {
        taskRecordRepository.updateStateAndRemark(JobConstants.JOB_STATE_FAILED, error,id);
    }

    public void state2FailAndRemarkError(String id, String error) {
        taskRecordRepository.updateStateAndRemark(JobConstants.JOB_STATE_FAILED, error, id);
    }
    public void stateSuccess(String id) {
        taskRecordRepository.updateStateAndTime(JobConstants.JOB_STATE_SUCCESS,new Date(), id);
    }

    public TaskRecord save(TaskRecord taskRecord) {
        taskRecord.setVersion("v2");
        TaskRecord record = taskRecordRepository.save(taskRecord);
        return record;
    }

    public TaskRecord findOne(String id) {
        return taskRecordRepository.findById(id).orElse(null);
    }

    public Iterable<TaskRecordTemp> saveTaskRecordTemp(List<TaskRecordTemp> list) {
        return taskRecordTempRepository.saveAll(list);
    }

    public List<String> getDataIdListByRecordId(String recordId) {
        return taskRecordTempRepository.getDataIdByRecordId(recordId);
    }

    public List<TaskRecord> findByTypeAndStateAndBizId(Integer type, Integer state, String bizId) {
        return taskRecordRepository.findByTypeAndStateAndBizId(type, state, "v1", bizId);
    }

    public Page<TaskRecord> findByUseridAndTasktypeAndBizId(Long userid, String taskType, String bizId, Integer page, Integer size) throws Exception {
        String filterParam = String.format("Q_userid_N_EQ=%s;Q_tasktype_N_IN=%s;Q_bizId_S_EQ=%s",userid,taskType,bizId);
        String sortParam = "SORT_starttime_DESC";
        Page<TaskRecord> result = null;
        try {
            result = taskRecordRepository.findAll(new QuerySpecification<TaskRecord>(filterParam),
                    PageRequest.of(page, size, QueryParamUtil.parseSortParams(sortParam)));
        }
        catch (Exception e){
            logger.error(e.getMessage());
            throw new GwValidateException("查询出错:findByUseridAndTasktypeAndBizId");
        }
        return result;
    }

    //获取任务列表数据
    public Page<TaskRecord> findByTasktypeAndBizId(Long userId,String taskType,String bizId,Integer page,Integer size){
        Page<TaskRecord> result = null;
        //匿名内部类,实现接口方法
        Specification<TaskRecord> spec = new Specification() {
            @Override
            public Predicate toPredicate(Root root, CriteriaQuery cq, CriteriaBuilder cb) {
                //创建集合,用于存放拼接的条件
                List<Predicate> list = new ArrayList<>();
                if(taskType != null){
                    Predicate p2 = cb.equal(root.get("tasktype"), taskType);
                    list.add(p2);
                }
                if(userId != null){
                    list.add(cb.equal(root.get("userid"), userId));
                }
                if(bizId != null){
                    Predicate p2 = cb.equal(root.get("bizId"), bizId);
                    list.add(p2);
                }
                return cb.and(list.toArray(new Predicate[list.size()]));
            }
        };
        result = taskRecordRepository.findAll(spec,PageRequest.of(page-1, size));
        return result;
    }

    //获取任务下发人员记录
    public Map<String,Object> queryAssignUserRecord(String taskId, String dataId, int page, int rows){
        Map<String,Object> map=new HashMap<>();
        List<AssignRecordDTO> list=new ArrayList<>();
        List<Object[]> taskRecords = taskRecordRepository.queryByTaskIdAndDataId(taskId, dataId, (page - 1) * rows, rows);
        for (Object[] tskAssignRecord : taskRecords) {
            AssignRecordDTO assignRecordDTO=new AssignRecordDTO();
            //作业人员信息
            LandUser assignTo = landUserRepository.findById(Long.valueOf(tskAssignRecord[0].toString())).orElse(null);
            assignRecordDTO.setAssignUser(assignTo!=null?assignTo.getName():null);
            //下发人员信息
            LandUser optUser = landUserRepository.findById(Long.valueOf(tskAssignRecord[1].toString())).orElse(null);
            assignRecordDTO.setOptUser(optUser!=null?optUser.getName():null);
            assignRecordDTO.setAssignDate((Date) tskAssignRecord[2]);
            list.add(assignRecordDTO);
        }
        Long count=0L;
        count = taskRecordRepository.queryByTaskIdAndDataIdCount(taskId,dataId);
        map.put("list",list);
        map.put("count",count);
        return map;
    }

    //获取任务下发人员记录
    public Map<String,Object> getAssignRecordList(String taskId, String dataId, int page, int rows){
        Map<String,Object> map=new HashMap<>();
        List<AssignRecordDTO> list=new ArrayList<>();
        List<TskAssignRecord>  taskRecords =  tskAssignRecordRepository.getTaskIdAndDataId(taskId, dataId, (page - 1) * rows,rows);
        JSONArray jsonArray = new JSONArray();
        for (TskAssignRecord tskAssignRecord : taskRecords) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("id", tskAssignRecord.getId());
            jsonObject.put("assignto", tskAssignRecord.getAssignto());//作业人员
            jsonObject.put("assignUserName", getUserName(tskAssignRecord.getAssignto()!= null ? tskAssignRecord
                    .getAssignto() : "0"));
            jsonObject.put("dataId", tskAssignRecord.getDataId());
            jsonObject.put("taskId", tskAssignRecord.getTaskId());
            jsonObject.put("createTime", tskAssignRecord.getCreateTime().getTime());
            jsonObject.put("optUserId", tskAssignRecord.getOptUserId());//操作人员
            jsonObject.put("optUserName", getUserName(tskAssignRecord.getOptUserId()!= null ? tskAssignRecord
                    .getOptUserId() : "0"));
            jsonObject.put("sourceId", tskAssignRecord.getSourceId());
            jsonObject.put("sourceType", tskAssignRecord.getSourceType());
            jsonObject.put("status", tskAssignRecord.getStatus());
            jsonObject.put("tableId", tskAssignRecord.getTableId());
            jsonObject.put("pasteUserId", tskAssignRecord.getPasteUserId());//撤销人员
            jsonObject.put("pasteUserName", getUserName(tskAssignRecord.getPasteUserId()!= null ? tskAssignRecord
                    .getPasteUserId() : "0"));
            jsonObject.put("updateTime", tskAssignRecord.getUpdateTime() != null ?tskAssignRecord.getUpdateTime().getTime():null);
            jsonArray.add(jsonObject);
        }
       Integer count = tskAssignRecordRepository.getCountByTaskIdAndDataId(taskId,dataId);
        map.put("list",jsonArray);
        map.put("count",count);
        return map;
    }

    /**
     * 根据用户ID获取用户名称
     * @param userId
     * @return
     */
    public  String getUserName(String userId){
        String name = "";
        LandUser  landUser =  landUserRepository.queryUserById(Long.parseLong(userId));
        if(landUser != null){
            name = landUser.getName();
        }
        return name;
    }

    /**
     * 根据用户id查询对应任务数据
     * @param userId
     * @param param
     * @param page
     * @param size
     * @return
     * @throws Exception
     */
    public Page<TaskRecord> findByUserId(Long userId, String param,Integer page, Integer size) throws Exception {
        String filterParam = String.format("Q_userid_N_EQ=%s",userId);
        if(org.apache.commons.lang3.StringUtils.isNotEmpty(param)){
            filterParam +=  ";"+param;
        }
        String sortParam = "SORT_starttime_DESC";
        Page<TaskRecord> result = null;
        try {
            result = taskRecordRepository.findAll(new QuerySpecification<TaskRecord>(filterParam),
                     PageRequest.of(page, size, QueryParamUtil.parseSortParams(sortParam)));
        }
        catch (Exception e){
            logger.error(e.getMessage());
            throw new GwValidateException("查询出错");
        }
        return result;
    }

    public void updateRecordRead(String ids){
        List<String> idList = Arrays.asList(ids.split(","));
        taskRecordRepository.updateRecordRead(1,idList);
    }

}
