package com.geoway.landteam.landcloud.service.customtask.task;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.pub.entity.TaskNoticeUserNew;
import com.geoway.landteam.customtask.pub.entity.TaskRecord;
import com.geoway.landteam.customtask.repository.task.TskAssignRecordRepository;
import com.geoway.landteam.customtask.servface.task.TaskAssignJobService;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.service.util.TaskDBUtils;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskAssignRecord;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.landcloud.core.service.util.message.MixPushServer;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.File;
import java.sql.Connection;
import java.sql.Statement;
import java.util.*;

/**
 * @author panzhiguang
 * @Package com.geoway.landteam.landcloud.service.customtask.task
 * @date 2023/10/8 16:18
 */
@Service
public class MTaskSplitMergeService {

    private final GiLoger logger = GwLoger.getLoger(MTaskSplitMergeService.class);

    @Autowired
    MTskTaskBizService mTskTaskBizService;
    @Autowired
    DefaultOssOperatorService ossOperatorService;
    @Autowired
    TaskAssignJobService taskAssignJobService;

    @Autowired
    TskTaskBizService MTskTaskBizService;

    @Autowired
    MTbtskObjectinfoService mTbtskObjectinfoService;
    @Autowired
    TskAssignRecordRepository tskAssignRecordRepository;
    @Autowired
    MDataBizService mDataBizService;
    @Autowired
    MTaskNoticeNewService mTaskNoticeNewService;


    public void syncTaskSplitMergeData(TaskRecord record) throws Exception {
        //解析参数，执行数据分割合并
        JSONObject paramsObject = JSONObject.parseObject(record.getParam());
        String bizId = paramsObject.getString("bizId");
        String tbId = paramsObject.getString("tbId");
        String type = paramsObject.getString("type");
        Long userId = paramsObject.getLongValue("userId");
        TskTaskBiz tskTaskBiz = mTskTaskBizService.findByTaskId(bizId);
        TbtskObjectinfo tbtskObjectinfo = mTbtskObjectinfoService.getObjectbyID(tskTaskBiz.getTableId());
        if(StringUtils.isNotBlank(tbtskObjectinfo.getSplitTableName())){
            List<Map> maps =  mDataBizService.queryDataBySql("select * from "+ tbtskObjectinfo.getfTablename()+" where f_id = " +"'"+tbId+"'");
            //生成数据db
            Connection conn = null;
            Statement statement = null;
            SqlliteConnTool tool = null;
            // 01.先根据 taskids 生成数据db
            String fileName = UUID.randomUUID().toString() + ".db";
            String  uploadDir = (String) ProjectConfig.getConfig(ProjectConfigEnum.UPLOAD_DIR.getKey());
            String filePath = uploadDir + File.separator + fileName;
            tool = new SqlliteConnTool(filePath);
            conn = tool.getConnection();
            statement = conn.createStatement();
            // 生产表信息和字段信息
            TaskDBUtils.createInfo(MTskTaskBizService, tbtskObjectinfo, tskTaskBiz, statement, "sendApp");
            // 生成图斑表
            TaskDBUtils.createTable(MTskTaskBizService, tbtskObjectinfo, tskTaskBiz,statement);
            // 导入图斑数据
            Set<String> set = taskAssignJobService.insertData(maps, statement, tbtskObjectinfo, tskTaskBiz.getMode()!=null?String.valueOf(tskTaskBiz.getMode()):null);
            // 关闭连接
            tool.closeAll(conn, statement, null);

            // 上传db包到oss上
            Long date = System.currentTimeMillis();
            String key = String.format("taskManagerDB/%s/%s.db", userId, date.toString());
            String dbUrl = ossOperatorService.sendObject2Oss(key, new File(filePath));

            //获取下发记录
            List<TskAssignRecord> tskAssignRecords = tskAssignRecordRepository.findOrderByCreateTime(bizId,tbId);
            if (tskAssignRecords.size() > 0 ) {
                //对数据进行去重
                List<TskAssignRecord> tskAssignRecordsNew =  new ArrayList<>();
                 Set<String> set1 = new HashSet<>();
                 for(TskAssignRecord tskAssignRecord1 : tskAssignRecords){
                       String assignto = tskAssignRecord1.getAssignto();
                       if(!set1.contains(assignto)){
                           tskAssignRecordsNew.add(tskAssignRecord1);
                           set1.add(assignto);
                       }
                 }
                //查询具体任务数据
                String sql = "select tb.f_id,tb.f_status,tb.f_xzqdmsys from " +tbtskObjectinfo.getfTablename() +" tb  where tb.f_id = '" +tbId+"'";
                List<Map>  dataList = mDataBizService.queryDataBySql(sql);
                String xzqdmsys ="";
                if(dataList.size() > 0){
                    for(Map map:dataList){
                        xzqdmsys = map.get("f_xzqdmsys").toString();
                    }
                }
                String title = "任务数据分割合并通知";
                String content = String.format("【任务数据分割合并通知】。任务名称：%s；图斑数据:%s，已进行%s;", tskTaskBiz.getName(),tbId,type.equals("splitGeom") ?"分割":"合并");
                List<String> userIds = new ArrayList<>();
                for(TskAssignRecord tskAssignRecord : tskAssignRecordsNew){
                    TaskNoticeUserNew taskNoticeUserNew = new TaskNoticeUserNew();
                    taskNoticeUserNew.setId(UUID.randomUUID().toString());
                    taskNoticeUserNew.setSenduser(userId.toString());
                    taskNoticeUserNew.setTitle(title);
                    taskNoticeUserNew.setContent(content);
                    taskNoticeUserNew.setAction(32);
                    taskNoticeUserNew.setTaskmode(tskTaskBiz.getMode());
                    taskNoticeUserNew.setBizid(tskTaskBiz.getId());
                    taskNoticeUserNew.setCount(1);
                    taskNoticeUserNew.setReceiveuser(tskAssignRecord.getAssignto());
                    taskNoticeUserNew.setData(dbUrl);
                    taskNoticeUserNew.setXzqdmsys(converXzqdmsysByGr(tskTaskBiz,xzqdmsys));
                    taskNoticeUserNew.setSenddate(new Date());
                    mTaskNoticeNewService.addTaskNoticeUserNew(taskNoticeUserNew);
                    userIds.add(tskAssignRecord.getAssignto());
                }

                Map<String, Object> message = new HashMap<String, Object>();
                message.put("type", 3);
                // 推送消息
                try {
                    if (userIds.size() > 0) {
                        MixPushServer.sendNotifyToAlias(userIds, title, content, JSON.toJSONString(message));
                    }
                } catch (Exception e) {

                }
            }
        }else{
            throw new Exception("任务没有分割子图斑表");
        }
    }


    private String  converXzqdmsysByGr(TskTaskBiz task,String xzqdmsys){
        String xzqdm = "";
        if(task.getGranularity()!=null  && task.getGranularity() == 3){
            xzqdm = xzqdmsys.substring(0, 6);
        }else if(task.getGranularity()!=null  && task.getGranularity() == 4){
            xzqdm = xzqdmsys.substring(0, 9);
        }else if(task.getGranularity()!=null  && task.getGranularity() == 5){
            xzqdm = xzqdmsys.substring(0, 12);
        }else{
            xzqdm = xzqdmsys.substring(0, 6);
        }
        return xzqdm;
    }

}
