package com.geoway.landteam.landcloud.service.customtask.task;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.pub.entity.TaskTransformData;
import com.geoway.landteam.customtask.pub.entity.TaskTransformMedia;
import com.geoway.landteam.customtask.pub.entity.TaskTransformMediaMetaImg;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.model.base.entity.AppMedia;
import com.geoway.landteam.landcloud.core.repository.base.AppMediaRepository;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.landcloud.core.service.user.LandUserRoleinfoService;
import com.gw.base.log.GwLoger;
import com.gw.base.log.GiLoger;

import org.apache.commons.io.FileUtils;
import com.geoway.landteam.landcloud.common.util.base.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.io.File;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * @Author: zhenkaining
 * @Date: 2019/11/20 18:18
 * @Description:
 */
@Service
public class MTaskTransMediaService {
    /**
     * 正式与测试环境 用户名不一样，因云盘邮箱唯一，这里用用户名区分
     */
    @Value("${jfunbox.userName:}")
    protected String adminLoginName;

    @Value("${obsSignatureEnable:false}")
    protected boolean obsSignatureEnable;

    protected String tempDir;
    @Autowired
    AppMediaRepository appMediaRepository;
    @Autowired
    LandUserRoleinfoService landUserRoleinfoService;
    @Autowired
    DefaultOssOperatorService defaultOssOperatorService;

    private final GiLoger logger = GwLoger.getLoger(MTaskTransMediaService.class);

    @Autowired
    TemporarySignedUrlService temporarySignedUrlService;

    /**
     * 从JSON转换为照片的7要素对象
     *
     * @param mediaMetaObj
     * @return
     */
    public static TaskTransformMediaMetaImg getTaskTransMetaImgFromJson(JSONObject mediaMetaObj) {
        TaskTransformMediaMetaImg sevenFeatures = new TaskTransformMediaMetaImg();
        if (mediaMetaObj.containsKey("psry")) {
            sevenFeatures.setPsry(mediaMetaObj.get("psry").toString());
        }
        if (mediaMetaObj.containsKey("pssj")) {
            String time = mediaMetaObj.get("pssj").toString();
            if (StringUtils.isNotBlank(time)) {
                Long timeLong = null;
                try {
                    timeLong = Long.valueOf(time);
                } catch (NumberFormatException e) {
                    try {
                        Date date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(time);
                        timeLong = date.getTime();
                    } catch (ParseException parseException) {

                    }
                }
                if (timeLong != null) {
                    sevenFeatures.setPssj(String.valueOf(timeLong));
                }
            }
        }
        if (mediaMetaObj.containsKey("psjd")) {
            if (StringUtils.isNotBlank(mediaMetaObj.get("psjd").toString())) {
                try {
                    sevenFeatures.setPsjd(Double.valueOf(mediaMetaObj.get("psjd").toString()));
                } catch (NumberFormatException e) {
                    //sevenFeatures.setPsjd(0d);
                }
            }
        }
        if (mediaMetaObj.containsKey("longitude")) {
            if (StringUtils.isNotBlank(mediaMetaObj.get("longitude").toString())) {
                try {
                    sevenFeatures.setLongitude(Double.valueOf(mediaMetaObj.get("longitude").toString()));
                } catch (NumberFormatException e) {
                    //sevenFeatures.setLongitude(0d);
                }
            }
        }
        if (mediaMetaObj.containsKey("latitude")) {
            if (StringUtils.isNotBlank(mediaMetaObj.get("latitude").toString())) {
                try {
                    sevenFeatures.setLatitude(Double.valueOf(mediaMetaObj.get("latitude").toString()));
                } catch (NumberFormatException e) {
                    //sevenFeatures.setLatitude(0d);
                }
            }
        }
        if (mediaMetaObj.containsKey("height")) {
            if (StringUtils.isNotBlank(mediaMetaObj.get("height").toString())) {
                try {
                    sevenFeatures.setHeight(Double.valueOf(mediaMetaObj.get("height").toString()));
                } catch (NumberFormatException e) {
                    //sevenFeatures.setHeight(0d);
                }
            }
        }
        if (mediaMetaObj.containsKey("psfyj")) {
            if (StringUtils.isNotBlank(mediaMetaObj.get("psfyj").toString())) {
                try {
                    sevenFeatures.setPsfyj(Double.valueOf(mediaMetaObj.get("psfyj").toString()));
                } catch (NumberFormatException e) {
                    //sevenFeatures.setPsfyj(0d);
                }
            }
        }
        return sevenFeatures;
    }

    /**
     * 将Json对象转换为任务转换图斑数据
     *
     * @param json
     * @return
     */
    public static TaskTransformData convertToTaskTransDataFromJson(Object json) {
        TaskTransformData taskTransformData = new TaskTransformData();
        JSONObject jsonRecord = JSONObject.parseObject(JSONObject.toJSONString(json));
        if (jsonRecord != null) {
            if (jsonRecord.containsKey("tbid")) {
                taskTransformData.setTbId(jsonRecord.getString("tbid"));
            }
            if (jsonRecord.containsKey("tbname")) {
                taskTransformData.setTbName(jsonRecord.getString("tbname"));
            }
            if (jsonRecord.containsKey("prjnum")) {
                taskTransformData.setPrjNum(jsonRecord.getString("prjnum"));
            }
            if (jsonRecord.containsKey("prjname")) {
                taskTransformData.setPrjName(jsonRecord.getString("prjname"));
            }
            if (jsonRecord.containsKey("regioncode")) {
                taskTransformData.setRegionCode(jsonRecord.getString("regioncode"));
            }
            if (jsonRecord.containsKey("extent")) {
                taskTransformData.setExtent(jsonRecord.getString("extent"));
            } else {
                if (jsonRecord.containsKey("tbname")) {
                    throw new RuntimeException(String.format("%s图斑的图形数据(shape)为空，不能进行转换", jsonRecord.getString("tbname")));
                } else {
                    throw new RuntimeException(String.format("图斑的图形数据(shape)为空，不能进行转换"));
                }
            }

            if (jsonRecord.containsKey("md5")) {
                taskTransformData.setMd5(jsonRecord.getString("md5"));
            }
            if (jsonRecord.containsKey("requestid")) {
                taskTransformData.setRequestId(jsonRecord.getString("requestid"));
            }
            if (jsonRecord.containsKey("analysisid")) {
                taskTransformData.setAnalysisId(jsonRecord.getString("analysisid"));
            }
            if (jsonRecord.containsKey("tbmj") && StringUtils.isNotBlank(jsonRecord.get("tbmj").toString())) {
                try {
                    taskTransformData.setTbmj(Double.valueOf(jsonRecord.get("tbmj").toString()));
                } catch (NumberFormatException e) {
                    taskTransformData.setTbmj(0d);
                }
            }
            if (jsonRecord.containsKey("tbbh")) {
                taskTransformData.setTbbh(jsonRecord.getString("tbbh"));
            }
            List<TaskTransformMedia> mediaList = new ArrayList<>();
            if (jsonRecord.containsKey("medias")) {
                JSONArray jsonArray = JSONArray.parseArray(jsonRecord.getString("medias"));
                if (jsonArray != null) {
                    for (Object obj : jsonArray) {
                        JSONObject jsonObject = JSONObject.parseObject(JSONObject.toJSONString(obj));
                        if (jsonObject != null) {
                            TaskTransformMedia taskTransformMedia = convertTaskTransMediaFromJson(jsonObject);
                            mediaList.add(taskTransformMedia);
                        }
                    }
                }
            }
            if (mediaList.size() > 0) {
                taskTransformData.setMedias(JSONArray.parseArray( JSONObject.toJSONString(mediaList)));
            } else {
                taskTransformData.setMedias(JSONArray.parseArray("[]"));
            }
        }
        return taskTransformData;
    }

    /**
     * JSON对象转换为转换任务的附件
     *
     * @param jsonMedia
     * @return
     */
    public static TaskTransformMedia convertTaskTransMediaFromJson(JSONObject jsonMedia) {
        TaskTransformMedia taskTransformMedia = new TaskTransformMedia();
        if (jsonMedia != null) {
            if (jsonMedia.containsKey("attachid")) {
                taskTransformMedia.setAttachId(jsonMedia.getString("attachid"));
            } else if (jsonMedia.containsKey("attachId")) {
                taskTransformMedia.setAttachId(jsonMedia.getString("attachId"));
            }
            if (jsonMedia.containsKey("mediasource")) {
                try {
                    taskTransformMedia.setMediaSource(Integer.valueOf(jsonMedia.getString("mediasource")));
                } catch (NumberFormatException e) {
                    e.printStackTrace();
                    //throw new RuntimeException("附件数据类型(mediasource)错误");
                }
            } else if (jsonMedia.containsKey("mediaSource")) {
                try {
                    taskTransformMedia.setMediaSource(Integer.valueOf(jsonMedia.getString("mediaSource")));
                } catch (NumberFormatException e) {
                    e.printStackTrace();
                    //throw new RuntimeException("附件数据类型(mediaSource)错误");
                }
            }
            if (jsonMedia.containsKey("mediaformat")) {
                taskTransformMedia.setMediaFormat(jsonMedia.getString("mediaformat"));
            } else if (jsonMedia.containsKey("mediaFormat")) {
                taskTransformMedia.setMediaFormat(jsonMedia.getString("mediaFormat"));
            }
            if (jsonMedia.containsKey("mediatype")) {
                taskTransformMedia.setMediaType(jsonMedia.getString("mediatype"));
            } else if (jsonMedia.containsKey("mediaType")) {
                taskTransformMedia.setMediaType(jsonMedia.getString("mediaType"));
            }
            if (jsonMedia.containsKey("url")) {
                taskTransformMedia.setUrl(jsonMedia.getString("url"));
            }
            if (jsonMedia.containsKey("viewurl")) {
                taskTransformMedia.setViewUrl(jsonMedia.getString("viewurl"));
            } else if (jsonMedia.containsKey("viewUrl")) {
                taskTransformMedia.setViewUrl(jsonMedia.getString("viewUrl"));
            }
            if (jsonMedia.containsKey("mediameta")) {
                taskTransformMedia.setMediaMeta(jsonMedia.getString("mediameta"));
            } else if (jsonMedia.containsKey("mediaMeta")) {
                taskTransformMedia.setMediaMeta(jsonMedia.getString("mediaMeta"));
            }
            if (jsonMedia.containsKey("jym")) {
                taskTransformMedia.setJym(jsonMedia.getString("jym"));
            }
            if (jsonMedia.containsKey("status")) {
                taskTransformMedia.setStatus(jsonMedia.getString("status"));
            }
            if (jsonMedia.containsKey("othermetadata")) {
                taskTransformMedia.setOtherMetaData(jsonMedia.getString("othermetadata"));
            } else if (jsonMedia.containsKey("otherMetaData")) {
                taskTransformMedia.setOtherMetaData(jsonMedia.getString("otherMetaData"));
            }
            if (jsonMedia.containsKey("username")) {
                taskTransformMedia.setUserName(jsonMedia.getString("username"));
            } else if (jsonMedia.containsKey("userName")) {
                taskTransformMedia.setUserName(jsonMedia.getString("userName"));
            }
        }
        return taskTransformMedia;
    }


    /**
     * 将手机附件转换成任务转换格式的附件
     *
     * @param appMedia
     * @return
     */
    public static TaskTransformMedia convertAppMediaToTaskTranMedia(AppMedia appMedia) {
        TaskTransformMedia taskTransformMedia = new TaskTransformMedia();
        taskTransformMedia.setAttachId(appMedia.getId() != null ? appMedia.getId() : "");
        taskTransformMedia.setMediaSource(appMedia.getDeviceSource());
        if (appMedia.getType() == 1) {
            taskTransformMedia.setMediaFormat("jpg");
            taskTransformMedia.setMediaMeta(get7FeaturesFromAppMedia(appMedia));
            JSONObject json4Points = new JSONObject();
            json4Points.put("xmin", "");
            json4Points.put("ymin", "");
            json4Points.put("xmax", "");
            json4Points.put("ymax", "");
            taskTransformMedia.setOtherMetaData(json4Points.toString());
        } else if (appMedia.getType() == 2) {
            taskTransformMedia.setMediaFormat("mp4");
            taskTransformMedia.setMediaMeta(getVideoMediaMetaFromAppMedia(appMedia));
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("psry", "");
            taskTransformMedia.setOtherMetaData(jsonObject.toString());
        } else if (appMedia.getType() == 3) {
            taskTransformMedia.setMediaFormat("mp3");
            taskTransformMedia.setMediaMeta(JSONArray.parseArray("[]"));
            taskTransformMedia.setOtherMetaData(appMedia.getMediatimelength().toString());
        } else if (appMedia.getType() == 4) {
            taskTransformMedia.setMediaFormat("osgb");
            taskTransformMedia.setMediaMeta(get7FeaturesFromAppMedia(appMedia));
        }


        if (appMedia.getDeviceSource().equals(0)) {
            taskTransformMedia.setMediaType("J");
        } else if (appMedia.getDeviceSource().equals(1)) {
            taskTransformMedia.setMediaType("Y");
        }
        taskTransformMedia.setUrl(appMedia.getServerpath() != null ? appMedia.getServerpath() : "");
        taskTransformMedia.setViewUrl(StringUtils.isNotBlank(appMedia.getViewUrl()) ? appMedia.getViewUrl() : "");
        taskTransformMedia.setJym(StringUtils.isNotBlank(appMedia.getJym()) ? appMedia.getJym() : "");
        taskTransformMedia.setUserName(appMedia.getUsername() != null ? appMedia.getUsername() : "");
        if (appMedia.getTypetype() == 0) {
            taskTransformMedia.setStatus("-1");
        } else if (appMedia.getTypetype() == 101) {
            taskTransformMedia.setStatus("0");
        } else if (appMedia.getTypetype() == 102) {
            taskTransformMedia.setStatus("1");
        }

        return taskTransformMedia;
    }

    public static Object getVideoMediaMetaFromAppMedia(AppMedia appMedia) {
        if (StringUtils.isBlank(appMedia.getVideorecord())) {
            return null;
        }
         JSONArray jsonArray = new  JSONArray();
        try {
            JSONObject jsonObject = JSONObject.parseObject(appMedia.getVideorecord());
            if (jsonObject != null) {
                if (jsonObject.containsKey("starttime")) {
                    String startTimeStr = jsonObject.get("starttime").toString();
                    if (StringUtils.isNotBlank(startTimeStr) && jsonObject.containsKey("items")) {
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        Calendar calendar = Calendar.getInstance();
                        try {
                            // 视频开始时间
                            Date startTime = new Date(new Long(startTimeStr));
                             JSONArray itemsArrary =  JSONArray.parseArray(JSONArray.toJSONString(jsonObject.get("items")));
                            if (itemsArrary != null && itemsArrary.size() > 0) {
                                for (Object o : itemsArrary) {
                                    JSONObject itemJsonObj = JSONObject.parseObject(JSONObject.toJSONString(o));
                                    if (itemJsonObj != null) {
                                        if (itemJsonObj.containsKey("position")) {
                                            int position = new Integer(itemJsonObj.get("position").toString());
                                            calendar.setTime(startTime);
                                            // 计算时间位置
                                            calendar.add(Calendar.SECOND, position);
                                            JSONObject newItem = new JSONObject();
                                            newItem.put("position", sdf.format(calendar.getTime()));
                                            newItem.put("x", itemJsonObj.get("x"));
                                            newItem.put("y", itemJsonObj.get("y"));
                                            newItem.put("angle", itemJsonObj.get("angel"));
                                            // 设置默认高度
                                            newItem.put("height", 1.7);
                                            // 设置默认俯仰角
                                            newItem.put("pitch", 0);
                                            jsonArray.add(newItem);
                                        }
                                    }
                                }
                            }
                        } catch (NumberFormatException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        } catch (Exception e) {
            return JSONArray.parse(appMedia.getVideorecord());
        }
        return jsonArray;
    }

    /**
     * 从手机附件获取7要素
     *
     * @param appMedia
     * @return
     */
    public static com.alibaba.fastjson.JSONObject get7FeaturesFromAppMedia(AppMedia appMedia) {
        com.alibaba.fastjson.JSONObject json7Features;
        json7Features = new com.alibaba.fastjson.JSONObject();
        json7Features.put("psry", "");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        json7Features.put("pssj", sdf.format(new Date()));
        json7Features.put("psjd", appMedia.getAzimuth());
        json7Features.put("longitude", appMedia.getLon());
        json7Features.put("latitude", appMedia.getLat());
        json7Features.put("height", 1.7);
        if (StringUtils.isBlank(appMedia.getPitch())) {
            json7Features.put("psfyj", "0");
        } else {
            json7Features.put("psfyj", appMedia.getPitch());
        }
        return json7Features;
    }


    private long getUserIdParma(long userId) {
        List<String> roles = landUserRoleinfoService.findRoleIdsByUserId(userId);
        long userIdParma = userId;
        if (!roles.contains("10012")) {
            // 所有非国家级用户的个人云盘信息 都用管理员101创建的个人云盘，存储
            userIdParma = Long.valueOf(adminLoginName);
        } else {
            userIdParma = userId;
        }
        return userIdParma;
    }

    /**
     * 保存附件
     *
     * @param userId
     * @param tbId
     * @param tbShape
     * @param mediaList
     * @return
     */
    public Object saveAttach(long userId, String tbId, String tbShape, List<TaskTransformMedia> mediaList, String token) {
        // 附件保存在Obs中文件夹的路径
        String folderName = "AppBasicFiles";
        List<AppMedia> attachList = new ArrayList<>();
        if (mediaList != null && mediaList.size() > 0) {
            for (TaskTransformMedia media : mediaList) {
                if (media != null) {

                    AppMedia appMedia = new AppMedia();
                    appMedia.setId(media.getAttachId());
                    appMedia.setGalleryid(tbId);
                    appMedia.setShape(tbShape);
                    if (media.getMediaSource().equals(1)) {
                        appMedia.setDeviceSource(0);
                    } else if (media.getMediaSource().equals(1)) {
                        appMedia.setDeviceSource(1);
                    }
                    if (StringUtils.isNotBlank(media.getMediaFormat())) {
                        if (media.getMediaFormat().equalsIgnoreCase("jpg")) {
                            appMedia.setType(1);
                            try {
                                JSONObject mediaMetaObj = JSONObject.parseObject(JSONObject.toJSONString(media.getMediaMeta()));
                                if (mediaMetaObj != null) {
                                    TaskTransformMediaMetaImg sevenFeatures = getTaskTransMetaImgFromJson(mediaMetaObj);
                                    if (sevenFeatures != null) {
                                        appMedia.setLon(sevenFeatures.getLongitude());
                                        appMedia.setLat(sevenFeatures.getLatitude());
                                        appMedia.setAzimuth(sevenFeatures.getPsjd().toString());
                                        appMedia.setUsername(StringUtils.isNotBlank(sevenFeatures.getPsry()) ? sevenFeatures.getPsry() : "");
                                        appMedia.setTime(StringUtils.isNotBlank(sevenFeatures.getPssj()) ? sevenFeatures.getPssj() : String.valueOf(System.currentTimeMillis()));
                                        if (StringUtils.isNotBlank(sevenFeatures.getPsfyj().toString())) {
                                            appMedia.setPitch(sevenFeatures.getPsfyj().toString());
                                        }
                                    }
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                                logger.error(e.getMessage());
                            }
                        } else if (media.getMediaFormat().equalsIgnoreCase("mp4")) {
                            appMedia.setType(2);
                            if (media.getMediaMeta() != null) {
                                appMedia.setVideorecord(media.getMediaMeta().toString());
                            }
                            appMedia.setTime(StringUtils.isNotBlank(appMedia.getTime()) ? appMedia.getTime() : String.valueOf(System.currentTimeMillis()));

                        } else if (media.getMediaFormat().equalsIgnoreCase("osgb")) {
                            appMedia.setType(4);
                            appMedia.setTime(StringUtils.isNotBlank(appMedia.getTime()) ? appMedia.getTime() : String.valueOf(System.currentTimeMillis()));
                            appMedia.setServerpath(StringUtils.isNotBlank(media.getViewUrl()) ? media.getViewUrl() : "");
                        } else if (media.getMediaFormat().equalsIgnoreCase("mp3")) {
                            appMedia.setType(3);
                            appMedia.setTime(StringUtils.isNotBlank(appMedia.getTime()) ? appMedia.getTime() : String.valueOf(System.currentTimeMillis()));
                            if (media.getOtherMetaData() != null) {
                                try {
                                    appMedia.setMediatimelength(Integer.valueOf(media.getOtherMetaData()));
                                } catch (NumberFormatException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    } else {
                        throw new RuntimeException("图斑id：" + tbId + " 附件id：" + media.getAttachId() + " 附件类型字段mediaFormat为空，保存失败");
                    }
                    if (StringUtils.isNotBlank(media.getStatus())) {
                        if (media.getStatus().equalsIgnoreCase("-1")) {
                            appMedia.setTypetype(0);
                        } else if (media.getStatus().equalsIgnoreCase("0")) {
                            appMedia.setTypetype(101);
                        } else if (media.getStatus().equalsIgnoreCase("1")) {
                            appMedia.setTypetype(102);
                        }
                    } else {
                        throw new RuntimeException("图斑id：" + tbId + " 附件id：" + media.getAttachId() + " 附件状态字段status为空，保存失败");
                    }
                    appMedia.setCreateTime(String.valueOf(System.currentTimeMillis()));
                    // 拍摄人员
                    appMedia.setUsername(media.getUserName());
                    if (StringUtils.isNotBlank(media.getStatus())) {
                        if (media.getStatus().equalsIgnoreCase("-1")) {
                            appMedia.setTypetype(0);
                        } else if (media.getStatus().equalsIgnoreCase("0")) {
                            appMedia.setTypetype(101);
                        } else if (media.getStatus().equalsIgnoreCase("1")) {
                            appMedia.setTypetype(102);
                        }
                    } else {
                        throw new RuntimeException("图斑id：" + tbId + " 附件id：" + media.getAttachId() + " 附件状态字段status为空，保存失败");
                    }
                    appMedia.setJym(StringUtils.isNotBlank(media.getJym()) ? media.getJym() : "");
                    File tempFile = null;
                    try {
                        tempDir = (String) ProjectConfig.getConfig(ProjectConfigEnum.UPLOAD_DIR.getKey());
                        String tempUrl = getSignedUrl(token, media.getUrl());
                        tempFile = new File(tempDir + File.separator + UUID.randomUUID().toString() + media.getMediaFormat());
                        FileUtils.copyURLToFile(new URL(tempUrl), tempFile);
                        //tempFile = getFileFromUrl(tempUrl);
                        String url = defaultOssOperatorService.sendObject2Oss("media/" + userId + "/" + UUID.randomUUID().toString() + media.getMediaFormat(), tempFile);
                        if (StringUtils.isNotBlank(url)) {
                            appMedia.setServerpath(url);
                            appMedia.setViewUrl(url);
                        }
                        // 删除临时文件
                        try {
                            if (tempFile != null) {
                                tempFile.delete();
                            }
                        } catch (Exception ex) {
                        }
                    } catch (Exception e) {
                        logger.error(e);
                        throw new RuntimeException("复制文件异常！" + e.getMessage());
                    }

                    attachList.add(appMedia);
                }
            }
        }

        if (attachList.size() > 0) {
            appMediaRepository.saveAll(attachList);
        }
        return null;
    }

    private String getSignedUrl(String token, String downloadPath) {
        if (obsSignatureEnable) {
            return temporarySignedUrlService.getTemporarySignedUrl(defaultOssOperatorService.getServerId().toString(), downloadPath, new HashMap<>());
        } else {
            if (StringUtils.isNotBlank(downloadPath)) {
                String newUrl = downloadPath;
                if (newUrl.startsWith("https") || newUrl.startsWith("HTTPS")) {

                } else if (newUrl.startsWith("http")) {
                    newUrl = newUrl.replace("http", "https");
                } else if (newUrl.startsWith("HTTP")) {
                    newUrl = newUrl.replace("HTTP", "https");
                }
                return newUrl;
            } else {
                return "";
            }
        }
    }

    private File getFileFromUrl(String url) throws Exception {
        String fileName = url.substring(url.lastIndexOf("/") + 1);
        tempDir = (String) ProjectConfig.getConfig(ProjectConfigEnum.UPLOAD_DIR.getKey());
        File file = new File(tempDir + File.separator + fileName);
        FileUtils.copyURLToFile(new URL(url), file);
        return file;
    }
}
