package com.geoway.landteam.landcloud.service.customtask.task;

import com.geoway.landteam.customtask.pub.enm.ByteOperator;
import com.geoway.landteam.customtask.pub.entity.TbSyncStatus;
import com.geoway.landteam.customtask.repository.pub.TbSyncStatusRepository;
import com.geoway.landteam.landcloud.servface.customtask.task.MTbSyncStatusService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.validation.constraints.NotNull;
import java.util.*;
import java.util.concurrent.TimeUnit;

/**
 * @Author Waves
 * @Date 2023/9/14
 * @Description
 **/
@Service
public class MTbSyncStatusServiceImpl implements MTbSyncStatusService {
    private static final String SYNC_STATUS = "sync.status";

    @Autowired
    RedisTemplate redisTemplate;
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    TbSyncStatusRepository tbSyncStatusRepository;

    @Override
    public void changeStatus(@NotNull Integer objectType, @NotNull String taskId, @NotNull String tbid, @NotNull Integer status,@NotNull  ByteOperator operator){
        String key = String.format("%s.%s.%s",objectType,taskId,tbid);
        String optString = "f_status";
        if(redisTemplate.opsForHash().hasKey(SYNC_STATUS,key)){
            Integer i = (Integer) redisTemplate.opsForHash().get(SYNC_STATUS,key);
            optString = String.valueOf(operator.applyAsInt(i,status));
        }else {
            optString = operator.getOptString("EXCLUDED.f_status",status.toString());
        }
        String insertValues =  String.format("('%s',%s,'%s','%s',%s)", UUID.randomUUID().toString(),objectType,taskId,tbid,optString);
        // 需要约束 ALTER TABLE "public"."tb_sync_status" ADD CONSTRAINT "tb_sync_status_union" UNIQUE ("f_objectid", "f_object_type", "f_tbid");
        String sql = "INSERT INTO  tb_sync_status (f_id,f_object_type,f_objectid,f_tbid,f_status) VALUES " + insertValues +
                " ON CONFLICT (f_object_type,f_objectid,f_tbid) DO UPDATE SET f_status = " + optString + ";";
        jdbcTemplate.update(sql);
        redisTemplate.opsForHash().put(SYNC_STATUS,key,status);
        redisTemplate.expire(SYNC_STATUS,10, TimeUnit.MINUTES);
    }

    @Override
    public void changeStatus(@NotNull Integer objectType, @NotNull String taskId, @NotNull List<String> tbids, @NotNull Integer status,@NotNull  ByteOperator operator){
        List<String> batchList = new ArrayList<>();
        int batchNum = 0;
        for(int i = 0 ; i < tbids.size(); i++){
            batchList.add(tbids.get(i));
            batchNum += 1;
            if(batchNum >= 5000){
                batchChangeStatus(objectType, taskId, tbids, status, operator);
                batchList.clear();
                batchNum = 0;
            }
        }
        if (!batchList.isEmpty()){
            batchChangeStatus(objectType, taskId, tbids, status, operator);
        }
    }

    @Transactional
    public void batchChangeStatus(@NotNull Integer objectType, @NotNull String taskId, @NotNull List<String> tbids, @NotNull Integer status, @NotNull ByteOperator operator) {
        StringBuilder sb = new StringBuilder();
        Map<String,Integer> chche = new HashMap<>();
        for(String tbid:tbids){
            String key = String.format("%s.%s.%s",objectType,taskId,tbid);
            String valueString = "";
            //有缓存的更新缓存没有的直接更新数据库
            if(redisTemplate.opsForHash().hasKey(SYNC_STATUS,key)){
                Integer i = (Integer) redisTemplate.opsForHash().get(SYNC_STATUS,key);
                valueString = String.valueOf(operator.applyAsInt(i,status));
                chche.put(key,i);
            }else {
                valueString = operator.getOptString("EXCLUDED.f_status",status.toString());
            }
            String insertValues =  String.format("('%s',%s,'%s','%s',%s)", UUID.randomUUID().toString(),objectType,taskId,tbid,status);
            // 需要约束 ALTER TABLE "public"."tb_sync_status" ADD CONSTRAINT "tb_sync_status_union" UNIQUE ("f_objectid", "f_object_type", "f_tbid");
            sb.append("INSERT INTO  tb_sync_status (f_id,f_object_type,f_objectid,f_tbid,f_status) VALUES ")
                    .append(insertValues)
                    .append(" ON CONFLICT (f_object_type,f_objectid,f_tbid) DO UPDATE SET f_status = ")
                    .append(valueString)
                    .append(";");
        }
        jdbcTemplate.update(sb.toString());
        redisTemplate.opsForHash().putAll(SYNC_STATUS,chche);
        redisTemplate.expire(SYNC_STATUS,12, TimeUnit.HOURS);
    }

    public List<TbSyncStatus> getStatusByObjectIdAndTbids(Integer objectType,String objectId,List<String> tbids){
        return tbSyncStatusRepository.findByObjectIdAndTbids(objectType,objectId,tbids);
    }
    //单独查询会关联到
    public Integer getStatusByTbid(@NotNull Integer objectType, @NotNull String objectId, @NotNull String tbid){
        String key = String.format("%s.%s.%s",objectType,objectId,tbid);
        if(redisTemplate.opsForHash().hasKey(SYNC_STATUS,key)){
            Integer i = (Integer) redisTemplate.opsForHash().get(SYNC_STATUS,key);
            redisTemplate.expire(SYNC_STATUS,10, TimeUnit.MINUTES);
            return i;
        }else {
            Integer i= tbSyncStatusRepository.findByTbid(objectType,objectId,tbid);
            redisTemplate.opsForHash().put(SYNC_STATUS,key,i);
            redisTemplate.expire(SYNC_STATUS,10, TimeUnit.MINUTES);
            return i;
        }
    }

    public List<TbSyncStatus> getStatusByTaskAndMask(@NotNull Integer objectType, @NotNull String objectid, @NotNull Integer status,@NotNull ByteOperator operator){
        if(operator.equals(ByteOperator.ADD)){
            return tbSyncStatusRepository.findByObjectidAndIncludeMask(objectType,objectid,status);
        }else if(operator.equals(ByteOperator.ERASE)){
            return tbSyncStatusRepository.findByObjectidAndExcludeMask(objectType,objectid,status);
        }else {
            return tbSyncStatusRepository.findByObjectidAndStatus(objectType,objectid,status);
        }
    }

}
