package com.geoway.landteam.landcloud.service.customtask.task;

import com.geoway.landteam.customtask.pub.dto.FlowStep;
import com.geoway.landteam.customtask.repository.task.*;
import com.geoway.landteam.customtask.task.enm.ReviewStageEnum;
import com.geoway.landteam.customtask.task.entity.*;
import com.geoway.landteam.landcloud.common.util.base.StringUtils;
import com.geoway.landteam.landcloud.core.model.base.enm.TbStatusEnum;
import com.geoway.landteam.landcloud.servface.customtask.task.MTbtskRejectDefService;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author panzhiguang
 * @Package com.geoway.landteam.landcloud.service.customtask.task
 * @date 2024/7/17 14:30
 */

@Service
@Transactional(rollbackFor = Exception.class)
public class MTbtskAuditService {

    private static final GiLoger log = GwLoger.getLoger();

    @Autowired
    MTbtskRejectDefService mTbtskRejectDefService;
    @Autowired
    TbtskTaskFlowRepository tbtskTaskFlowRepository;
    @Autowired
    TbtskAuditRecordRepository tbtskAuditRecordRepository;
    @Autowired
    TskTaskBizRepository tskTaskBizRepository;
    @Autowired
    TbtskObjectinfoRepository tbtskObjectinfoRepository;
    @Autowired
    MDataBizService dataBizService;
    @Autowired
    TbtskAuditAssignRecordRepository tbtskAuditAssignRecordRepository;
    @Autowired
    TbtskTaskUserAreaRepository tbtskTaskUserAreaRepository;

    public  List<TbtskTaskFlow> findTaskFlowByTaskId(String taskId){
        List<TbtskTaskFlow> taskFlowByTaskId = tbtskTaskFlowRepository.findTaskFlowByTaskId(taskId);
        return  taskFlowByTaskId;
    }

    public  TbtskTaskFlow findByTaskIdAndAndIndex(String taskId,Integer index){
        TbtskTaskFlow taskFlow = tbtskTaskFlowRepository.findByTaskIdAndAndIndex(taskId,index);
        return  taskFlow;
    }

    public   List<TbtskAuditRecord> findAuditRecordsByTaskIdAndTbId(String taskId,String tbId){
        List<TbtskAuditRecord> auditRecordsByTaskIdAndTbId = tbtskAuditRecordRepository.findAuditRecordsByTaskIdAndTbId(taskId, tbId);
        return  auditRecordsByTaskIdAndTbId;
    }

    public   List<TbtskAuditRecord> findAuditRecordsByTaskIdAndTbIdAndType(String taskId, String tbId, Integer type){
        List<TbtskAuditRecord> auditRecordsByTaskIdAndTbId = tbtskAuditRecordRepository .findAuditRecordsByTaskIdAndTbIdAndType(taskId, tbId,type);
        return  auditRecordsByTaskIdAndTbId;
    }


    public Map checkAuditPermission(Long userId ,String taskId,String tbId,String childTbId,String type) {
        Map resultMap = new HashMap();
        resultMap.put("hasPermission", false);
        TskTaskBiz tskTaskBiz = tskTaskBizRepository.findById(taskId).orElse(null);
        if (null == tskTaskBiz) {
            resultMap.put("hasPermission", false);
            resultMap.put("error", "业务不存在或已被删除");
            return resultMap;
        }
        TbtskObjectinfo tbtskObjectinfo = tbtskObjectinfoRepository.getObjectByTableId(tskTaskBiz.getTableId());
        if (null == tbtskObjectinfo) {
            resultMap.put("hasPermission", false);
            resultMap.put("error", "业务数据表不存在或已被删除");
            return resultMap;
        }
        List<String> fieldNameList = getAuditFieldNameCollection();
        Map data = dataBizService.selectFieldByID(tbtskObjectinfo.getfTablename(), fieldNameList, "f_id", "'" + tbId + "'");
        if (null == data) {
            resultMap.put("hasPermission", false);
            resultMap.put("error", "图斑不存在");
            return resultMap;
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank(childTbId) && org.apache.commons.lang3.StringUtils.isNotBlank(tbtskObjectinfo.getSplitTableName()) && dataBizService.isExistTableName(tbtskObjectinfo.getSplitTableName())) {
            data = dataBizService.selectFieldByID(tbtskObjectinfo.getSplitTableName(), fieldNameList, "f_id", "'" + childTbId + "'");
            if (null == data) {
                resultMap.put("hasPermission", false);
                resultMap.put("error", "图斑不存在");
                return resultMap;
            }
        }
        Integer status = MapUtils.getInteger(data, "f_status", null);
        String xzqdm = MapUtils.getString(data, "f_xzqdmsys", "");
        Integer reviewStage = MapUtils.getInteger(data, "f_review_stage", null);
        Integer rejectCount = MapUtils.getInteger(data, "f_reject_count", 0);
        Integer rejectStatus = MapUtils.getInteger(data, "f_reject_status", null);

        if (status == null || status < TbStatusEnum.WAITING_VERIFY.getCode()) {
            resultMap.put("hasPermission", false);
            resultMap.put("error", "未提报，不能审核");
            return resultMap;
        }
        if (reviewStage != null && reviewStage.equals(ReviewStageEnum.OVER_VERIFY)) {
            resultMap.put("hasPermission", false);
            resultMap.put("error", "审核已结束，不能审核");
            return resultMap;
        }

        List<TbtskTaskFlow> taskFlowByTaskId = tbtskTaskFlowRepository.findTaskFlowByTaskId(taskId);
        TbtskTaskFlow currentStep = null;
        for(TbtskTaskFlow taskFlow : taskFlowByTaskId){
            if(taskFlow.getPreStages().contains(status.toString()) && taskFlow.getPreStages().contains(reviewStage.toString())){
                currentStep = taskFlow;
                break;
            }
        }
        if (currentStep == null) {
            resultMap.put("hasPermission", false);
            resultMap.put("error", "图斑未找到对应审核阶段");
            return resultMap;
        }
        //定制按照审核数据分配逻辑
        boolean flag = false;
        Pair<Integer, String> levelAndRegion = processRegionCode(xzqdm,currentStep.getName());
        List<TbtskTaskUserArea> byTaskIdAndUserId = tbtskTaskUserAreaRepository.findByTaskIdAndUserId(taskId, userId);
        for(TbtskTaskUserArea taskUserArea : byTaskIdAndUserId){
            if(taskUserArea.getLevel() == levelAndRegion.getLeft()){
                flag = true;
                break;
            }
        }
        if(flag){
            resultMap.put("hasPermission", true);
            resultMap.put("stepIndex", currentStep.getIndex());
            resultMap.put("stepName", currentStep.getName());
            resultMap.put("flowId", currentStep.getId());
            TbtskRejectDef rejectDef = mTbtskRejectDefService.selectByTaskId(taskId);
            if (rejectDef != null) {
                resultMap.put("canReject", rejectDef.getRejectType() != 0);
                resultMap.put("rejectType", rejectDef.getRejectType());
            } else {
                resultMap.put("canReject", false);
            }
        }
        return resultMap;
    }


    public Pair<Integer, String> processRegionCode(String dataRegionCode, String name) {
        String result = "";
        Integer level = 1;
        if (StringUtils.isNotBlank(dataRegionCode)) {
            result = dataRegionCode;
            switch (name) {
                case "村级审核":
                case "村级复核":
                    result = dataRegionCode;
                    level = 5;
                    break;
                case "乡镇审核":
                case "乡镇复核":
                    result = dataRegionCode.substring(0, 9);
                    level = 4;
                    break;
                case "区县审核":
                case "区县复核":
                    result = dataRegionCode.substring(0, 6);
                    level = 3;
                    break;
                case "市级审核":
                case "市级复核":
                    result = dataRegionCode.substring(0, 4) + "00";
                    level = 2;
                    break;
                case "省级审核":
                case "省级复核":
                    result = dataRegionCode.substring(0, 2) + "0000";
                    level = 1;
                    break;
                case "国家审核":
                case "国家复核":
                    result = "1";
                    level = 0;
                    break;
                default:
                    break;
            }
        }
          return Pair.of(level, result);
    }

    private List<String> getAuditFieldNameCollection() {
        List<String> fieldNameList = new ArrayList<>();
        fieldNameList.add("f_id");
        fieldNameList.add("f_status");
        fieldNameList.add("f_xzqdmsys");
        fieldNameList.add("f_reject_status");
        fieldNameList.add("f_review_stage");
        fieldNameList.add("f_reject_count");
        return fieldNameList;
    }

}
