package com.geoway.landteam.landcloud.service.customtask.task;

import com.geoway.landteam.customtask.repository.task.TbtskConfigRepository;
import com.geoway.landteam.customtask.repository.task.TbtskObjectinfoRepository;
import com.geoway.landteam.customtask.task.entity.TbtskConfig;
import com.geoway.landteam.landcloud.common.util.orm.QuerySpecification;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Service
@Transactional
public class MTbtskConfigService {

    @Autowired
    TbtskConfigRepository tbtskConfigRepository;

    @Autowired
    TbtskObjectinfoRepository tbtskObjectinfoRepository;

//    @Autowired
//    TbtskAuditConfigRepository tbtskAuditConfigRepository;

    /**
     * 获取默认配置
     * @return
     */
    public TbtskConfig getDefaultConfig(){
        List<TbtskConfig> list = tbtskConfigRepository.getDefaultConfig();
        if(list==null || list.size()<1) {
            return null;
        }
        return list.get(0);
    }

    public List<TbtskConfig> getList(String filter){
        List<TbtskConfig> list = tbtskConfigRepository.findAll(new QuerySpecification<TbtskConfig>(filter));
        return list;
    }

    public TbtskConfig findById(String bizid){
        List<TbtskConfig> tbtskConfigs = tbtskConfigRepository.findbyId(bizid);
        if(tbtskConfigs==null||tbtskConfigs.size()<1) {
            return null;
        }
        return tbtskConfigs.get(0);
    }

    public TbtskConfig findByObjectId(String objectid){
        List<TbtskConfig> tbtskConfigs = tbtskConfigRepository.findByObjectId(objectid);
        if(tbtskConfigs==null||tbtskConfigs.size()<1) {
            return null;
        }
        return tbtskConfigs.get(0);
    }

    public List<TbtskConfig> findAll() {
        return tbtskConfigRepository.findAll();
    }

    public TbtskConfig findByName(String name){
        List<TbtskConfig> configs = tbtskConfigRepository.findByName(name);
        if(configs.size()>=1){
            return configs.get(0);
        }
        else{
            return null;
        }
    }

//    public TbtskConfig save(TbtskConfig tbtskConfig){
//        Integer isdefault = tbtskConfig.getfIsdefault();
//        if(isdefault!=null && isdefault == 1){
//            tbtskConfigRepository.setAllNotDefault();
//        }
//        List<TbtskConfig> oldConfig = tbtskConfigRepository.findbyId(tbtskConfig.getfId());
//        String newName = tbtskConfig.getfTypename();
//        if(oldConfig.size()>0 && !oldConfig.get(0).getfTypename().equals(newName)){
//            tbtskObjectinfoRepository.updateOnBizNameChange(newName, oldConfig.get(0).getfTypename());
//            tbtskAuditConfigRepository.updateOnBizNameChange(newName, oldConfig.get(0).getfTypename());
//        }
//        return tbtskConfigRepository.save(tbtskConfig);
//    }
}
