package com.geoway.landteam.landcloud.service.customtask.task;

import com.geoway.landteam.customtask.repository.task.TbtskDataLogRepository;
import com.geoway.landteam.customtask.task.entity.TbtskDataLog;
import com.gw.base.util.GutilStr;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @ClassName TbtskDataLogService
 * @Description TODO
 * @Author tiankunrui
 * @Date 2020-08-10 17:13
 * @ModifyDate 2020-08-10 17:13
 * @Version 1.0
 */
@Service
public class MTbtskDataLogService {
    @Autowired
    TbtskDataLogRepository tbtskDataLogRepository;

  /*  @Transactional(rollbackFor = Exception.class)*/
    public TbtskDataLog saveDataLog(TbtskDataLog tbtskDataLog) {
        return tbtskDataLogRepository.save(tbtskDataLog);
    }

    public List<TbtskDataLog> findTbtskDataLog(String taskId,String type,Long userId) {
        if(StringUtils.isNotBlank(type)){
            return tbtskDataLogRepository.findByTaskIdAndTypeAndUserIdOrderByCreateTimeDesc(taskId,type,userId.toString());
        }else{
            return tbtskDataLogRepository.findByTaskIdAndUserIdOrderByCreateTimeDesc(taskId,userId.toString());
        }
    }

    public List<TbtskDataLog> findTbtskDataLogByName(String taskId,String name) {
        if(GutilStr.isBlank(name)){
            name = "%%";
        }else{
            name = "%"+name+"%";
        }
        return tbtskDataLogRepository.findByTaskIdAndNameOrderByCreateTimeDesc(taskId,name);
    }
}
