package com.geoway.landteam.landcloud.service.customtask.task;


import com.geoway.landteam.customtask.repository.task.*;
import com.geoway.landteam.customtask.task.dto.AppConfigDTO;
import com.geoway.landteam.customtask.task.dto.FieldDisPlay;
import com.geoway.landteam.customtask.task.dto.FieldGroup;
import com.geoway.landteam.customtask.task.entity.*;
import com.gw.base.data.GwValidateException;
import com.gw.base.util.GutilAssert;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

@Service
@Transactional
public class MTbtskFieldsService {

    @Autowired
    TbtskFieldsRepository tbtskFieldsRepository;
    @Autowired
    TbtskSysFieldsRepository tbtskSysFieldsRepository;

    @Autowired
    TbtskFieldsGroupViewRepository tbtskFieldsGroupViewRepository;

    @Autowired
    TskTaskBizRepository tskTaskBizRepository;


    @Autowired
    TbtskGroupRepository tbtskGroupRepository;

//    @Autowired
//    TbtskImportRelRepository tbtskImportRelRepository;

    @Autowired
    TbtskObjectinfoRepository tbtskObjectinfoRepository;

    @Autowired
    TbtskTemplateRepository tbtskTemplateDao;

    public List<TbtskFields> getAllFieldsByTableID(String tableid) {
        List<TbtskFields> tbtskFields = tbtskFieldsRepository.getTbtskFieldsByTableid(tableid);
        return tbtskFields;
    }

    public List<TbtskSysFields> getAllSysFields() {
        List<TbtskSysFields> tbtskSysFields = tbtskSysFieldsRepository.findAllOrder();
        return tbtskSysFields;
    }

    public List<TbtskFields> getAllFieldsByTables(String tableNames) {
        List<String> tableList = Arrays.asList(tableNames.split(","));
        List<TbtskFields> tbtskFields = tbtskFieldsRepository.getTbtskFieldsByTables(tableList);
        return tbtskFields;
    }

    public List<TbtskFieldGroupView> getTbtskViewFields(String sysCode, String tableid, String groupCode) {
        List<TbtskFieldGroupView> tbtskFields = tbtskFieldsGroupViewRepository.getTbtskFieldsBySysCodeAndGroupCode(tableid, sysCode, groupCode);
        return tbtskFields;
    }

    /**
     * 是否包含审核字段
     *
     * @param tableid
     * @param groupCode
     * @return
     */
    public List<TbtskGroup> getAuditField(String sysCode, String tableid, String groupCode) {
        List<TbtskGroup> tbtskGroups = null;
        TbtskObjectinfo tbtskObjectinfo = tbtskObjectinfoRepository.findById(tableid).orElse(null);
        if (tbtskObjectinfo != null) {
            tbtskGroups = tbtskGroupRepository.selectAuditFields(sysCode, tbtskObjectinfo.getfTablename(), groupCode);
        }
        return tbtskGroups;
    }

    public List<TbtskGroup> getTbtskGroupFields(String sysCode, String tableid, String groupCode) {
        List<TbtskGroup> tbtskFields = null;
        TbtskObjectinfo tbtskObjectinfo = tbtskObjectinfoRepository.findById(tableid).orElse(null);
        if (tbtskObjectinfo != null) {
            tbtskFields = tbtskGroupRepository.selectByTableNameAndGroupcode(sysCode, tbtskObjectinfo.getfTablename(), groupCode);
        }
        return tbtskFields;
    }

    public List<String> getTbtskGroupFieldsName(String sysCode, String tableid, String groupCode) {
        List<String> tbtskFields = null;
        TbtskObjectinfo tbtskObjectinfo = tbtskObjectinfoRepository.findById(tableid).orElse(null);
        if (tbtskObjectinfo != null) {
            tbtskFields = tbtskGroupRepository.selectFieldNameByTableNameAndGroupcode(tableid, sysCode, groupCode);
        }
        return tbtskFields;
    }

    public List<String> getTbtskFieldsNameListBySysCodeAndGroupCode(String sysCode, String tableid, String groupCode) {
        List<String> tbtskFieldsNameList = tbtskFieldsGroupViewRepository.getTbtskFieldsNameListBySysCodeAndGroupCode(tableid, sysCode, groupCode);
        return tbtskFieldsNameList;
    }

    public List<TbtskGroup> selectFieldGroupByTbId(String tableId) {
        List<TbtskFields> fields = tbtskFieldsRepository.getTbtskFieldsByTableid(tableId);
        List<String> fieldIdList = new ArrayList<String>();
        for (TbtskFields field : fields) {
            fieldIdList.add(field.getfId());
        }
        return tbtskGroupRepository.selectByFieldList(fieldIdList);
    }

    public List<TbtskGroup> getFieldbyTableNameAndGroupCode(String tableName, String groupCode, String sysCode) {
        return tbtskGroupRepository.getFieldByTbnameGroupSys(tableName, groupCode, sysCode);
    }

    @Transactional
    public Iterable<TbtskGroup> saveGroupCode(List<TbtskGroup> list) {
        if (list == null || list.size() < 1) {
            return null;
        }
        String tableName = list.get(0).getfTablename();
        String groupcode = list.get(0).getfGroupcode();
        String sysCode = list.get(0).getfSyscode();
        List<String> ids = new ArrayList<>();
        for (TbtskGroup group : list) {
            if (group.getfId() != null) {
                ids.add(group.getfId());
            } else {
                tbtskGroupRepository.deleteByTbnameGroupSys(tableName, groupcode, sysCode);
            }
        }
        if (ids.size() > 0) {
            tbtskGroupRepository.deleteNotInList(tableName, groupcode, ids);
        }
        return tbtskGroupRepository.saveAll(list);
    }

//    @Transactional
//    public Iterable<TbtskImportRel> saveTbtskImportRel(List<TbtskImportRel> list) {
//        if (list == null || list.size() == 0) {
//            return null;
//        }
//        List<String> ids = new ArrayList<>();
//        for (TbtskImportRel item : list) {
//            if (item.getfId() != null) {
//                ids.add(item.getfId());
//            }
//        }
//        if (ids.size() > 0) {
//            String tableId = list.get(0).getfObjectid();
//            tbtskImportRelRepository.deleteIdNotInList(ids, tableId);
//        }
//        return tbtskImportRelRepository.save(list);
//    }


    /**
     * @author liupeng
     * 下面的方法为模板管理相关功能
     */

    final String LISTCODE = "100"; //图斑列表展示配置
    final String FILTERCODE = "101"; //业务字段筛选配置
    final String DETAILCODE = "202"; //图斑详情展示配置
    final String SEARCHCODE = "102"; //关键字搜索配置
    final String MAINCODE = "103"; // 详情主显示字段
    final String FILTERSYSCODE = "104"; //系统字段筛选配置
    final String ORDERCODE = "105";//业务字段排序配置
    final String AUDITQXCODE = "301";//区县审核字段配置
    final String AUDITCITYCODE = "302";//市级审核字段配置
    final String AUDITSJCODE = "303";//省级审核字段配置
    public void deleteById(String id) {
        tbtskFieldsRepository.deleteById(id);
        tbtskGroupRepository.deleteInFieldIds(Arrays.asList(id));
    }


    public TbtskFields saveField(TbtskFields field) {
        return tbtskFieldsRepository.save(field);
    }

    public List<TbtskFields> sortTbtskFields(String id, String type) {
        TbtskFields one = tbtskFieldsRepository.findById(id).orElse(null);
        switch (type) {
            case "up": {
                List<TbtskFields> before = tbtskFieldsRepository.findBefore(one.getfTableid(), one.getfOrder());
                if (before != null && before.size() > 0) {
                    TbtskFields beforeField = before.get(0);
                    beforeField.setfOrder(beforeField.getfOrder() + 1);
                    one.setfOrder(one.getfOrder() - 1);
                    tbtskFieldsRepository.save(one);
                    tbtskFieldsRepository.save(beforeField);
                } else {
                    throw new RuntimeException("该字段已位于第一行");
                }
                break;
            }
            case "down": {
                List<TbtskFields> before = tbtskFieldsRepository.findAfter(one.getfTableid(), one.getfOrder());
                if (before != null && before.size() > 0) {
                    TbtskFields afterField = before.get(0);
                    afterField.setfOrder(afterField.getfOrder() - 1);
                    one.setfOrder(one.getfOrder() + 1);
                    tbtskFieldsRepository.save(one);
                    tbtskFieldsRepository.save(afterField);
                } else {
                    throw new RuntimeException("该字段已位于最后一行");
                }
                break;
            }
            case "bottom": {
                List<TbtskFields> after = tbtskFieldsRepository.findAfter(one.getfTableid(), one.getfOrder());
                if (after != null && after.size() > 0) {
                    TbtskFields bottom = after.get(after.size() - 1);
                    one.setfOrder(bottom.getfOrder());
                    bottom.setfOrder(bottom.getfOrder() - 1);
                    tbtskFieldsRepository.save(one);
                    tbtskFieldsRepository.save(bottom);
                } else {
                    throw new RuntimeException("该字段已位于最后一行");
                }
                break;
            }
            case "top": {
                List<TbtskFields> before = tbtskFieldsRepository.findBefore(one.getfTableid(), one.getfOrder());
                if (before != null && before.size() > 0) {
                    TbtskFields top = before.get(before.size() - 1);
                    top.setfOrder(top.getfOrder() + 1);
                    one.setfOrder(top.getfOrder());
                    tbtskFieldsRepository.save(one);
                    tbtskFieldsRepository.save(top);
                } else {
                    throw new RuntimeException("该字段已位于第一行");
                }
                break;
            }
        }
        return this.getAllFieldsByTableID(one.getfTableid());
    }

    @Transactional(rollbackFor = Exception.class)
    public void saveAppConfigByTableId(AppConfigDTO appConfig, String tableId, String sysCode,Integer isApprove) {
        TbtskObjectinfo table = tbtskObjectinfoRepository.getObjectByTableId(tableId);
        if(table!=null){
            //任务字段更新需将版本加1
            tbtskObjectinfoRepository.updateTableVersion(table.getfTableversion()==null?1:table.getfTableversion()+1,table.getfId());
        }
        tbtskGroupRepository.deleteByTbIdSys(tableId, sysCode);
        List<String> fieldInList = appConfig.getFieldInList();
        List<TbtskGroup> groupTotal = new ArrayList<>();
        String tableName = Optional.ofNullable(table.getfTablename()).orElse("");
//        添加列表中显示字段的配置
        if (fieldInList.size() > 0)
            IntStream.range(0, fieldInList.size()).forEach(i -> {
                TbtskFields field = tbtskFieldsRepository.findById(fieldInList.get(i)).orElse(null);
                TbtskGroup group = new TbtskGroup();
                group.setfSyscode(sysCode);
                group.setfGroupcode(LISTCODE);
                group.setfTablename(tableName);
                group.setfFieldname(field.getfFieldname());
                group.setfFieldid(field.getfId());
                group.setfAlias(field.getfAlias());
                group.setfFieldorder(i);
                if ("1".equalsIgnoreCase(field.getRuleReg())) {
                    // 身份证号正则
                    group.setfRegexp("(^[1-9]\\d{5}(18|19|([23]\\d))\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{3}[0-9Xx]$)|(^[1-9]\\d{5}\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{2}[0-9Xx]$)");
                } else if ("2".equalsIgnoreCase(field.getRuleReg())) {
                    // 手机号正则
                    group.setfRegexp("^1(3|4|5|6|7|8|9)\\d{9}$");
                }
                groupTotal.add(group);
            });
        List<String> fieldInFilter = appConfig.getFieldInFilter();
        if (fieldInFilter.size() > 0)
            IntStream.range(0, fieldInFilter.size()).forEach(i -> {
                TbtskFields field = tbtskFieldsRepository.findById(fieldInFilter.get(i)).orElse(null);
                TbtskGroup group = new TbtskGroup();
                group.setfSyscode(sysCode);
                group.setfGroupcode(FILTERCODE);
                group.setfTablename(tableName);
                group.setfFieldname(field.getfFieldname());
                group.setfFieldid(field.getfId());
                group.setfAlias(field.getfAlias());
                group.setfFieldorder(i);
                groupTotal.add(group);
            });

//        添加搜索中配置的字段
        List<String> fieldInSearch = appConfig.getFieldInSearch();
        if (fieldInSearch.size() > 0)
            IntStream.range(0, fieldInSearch.size()).forEach(i -> {
                TbtskFields field = tbtskFieldsRepository.findById(fieldInSearch.get(i)).orElse(null);
                TbtskGroup group = new TbtskGroup();
                group.setfSyscode(sysCode);
                group.setfGroupcode(SEARCHCODE);
                group.setfTablename(tableName);
                group.setfFieldname(field.getfFieldname());
                group.setfFieldid(field.getfId());
                group.setfAlias(field.getfAlias());
                group.setfFieldorder(i);
                groupTotal.add(group);
            });
//        添加区县审核字段配置
        if(appConfig.getFieldInQxAudit() != null){
            for (int j = 0; j < appConfig.getFieldInQxAudit().size(); j++) {
                FieldGroup group = appConfig.getFieldGroup().get(j);
                List<FieldDisPlay> fields = group.getFields();
                for (int i = 0; i < fields.size(); i++) {
                    FieldDisPlay fieldDisPlay = fields.get(i);
                    TbtskFields field = tbtskFieldsRepository.findById(fieldDisPlay.getFieldId()).orElse(null);
                    //不能为null的字段，不能配置为不显示
                    if(field.getfNullable()!=null && field.getfNullable() == 0 && fieldDisPlay.getVisible() == 0){
                        throw new GwValidateException(field.getfFieldname()+"字段信息配置是必填项，不能配置为不显示，请重新配置！");
                    }
                    TbtskGroup tbtskGroup = new TbtskGroup();
                    tbtskGroup.setfSyscode(sysCode);
                    tbtskGroup.setfTablename(tableName);
                    tbtskGroup.setfFieldname(field.getfFieldname());
                    tbtskGroup.setfFieldid(field.getfId());
                    tbtskGroup.setfAlias(field.getfAlias());
                    tbtskGroup.setfFieldorder(i);
                    tbtskGroup.setfGrouporder(j);
                    tbtskGroup.setfGroupcode(AUDITQXCODE);
                    tbtskGroup.setfSubgroupname(group.getTitle());
                    tbtskGroup.setfControltype(fieldDisPlay.getDisplayType());
                    tbtskGroup.setfTip(fieldDisPlay.getTips());
                    tbtskGroup.setfCode(fieldDisPlay.getEditAble());
                    tbtskGroup.setNotNull(fieldDisPlay.getNotNull());
                    tbtskGroup.setConnection(fieldDisPlay.getConnection());
                    tbtskGroup.setVisible(fieldDisPlay.getVisible());
                    tbtskGroup.setItemGroupName(fieldDisPlay.getItemGroupName());
                    tbtskGroup.setfRegexp(fieldDisPlay.getRuleReg());
                    String regEx = "/[#\\\\$%\\\\^&\\\\*【】@!！￥?|‘；：”“\\'<>+=:]+/g";
                    if(sysCode.equals("web")  && (field.getfFieldtype().equals("1") || field.getfFieldtype().equals("2"))
                            && (field.getfCodetableid() == null || field.getfCodetableid().equals("")) ){
                        tbtskGroup.setfRegexp(regEx);
                    }
                    if ("1".equalsIgnoreCase(field.getRuleReg())) {
                        // 身份证号正则
                        tbtskGroup.setfRegexp("(^[1-9]\\d{5}(18|19|([23]\\d))\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{3}[0-9Xx]$)|(^[1-9]\\d{5}\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{2}[0-9Xx]$)");
                    } else if ("2".equalsIgnoreCase(field.getRuleReg())) {
                        // 手机号正则
                        tbtskGroup.setfRegexp("^1(3|4|5|6|7|8|9)\\d{9}$");
                    }
                    groupTotal.add(tbtskGroup);
                }
            }
        }

//        添加区市审核字段配置
        if(appConfig.getFieldInCityAudit()!=null){
            for (int j = 0; j < appConfig.getFieldInCityAudit().size(); j++) {
                FieldGroup group = appConfig.getFieldGroup().get(j);
                List<FieldDisPlay> fields = group.getFields();
                for (int i = 0; i < fields.size(); i++) {
                    FieldDisPlay fieldDisPlay = fields.get(i);
                    TbtskFields field = tbtskFieldsRepository.findById(fieldDisPlay.getFieldId()).orElse(null);
                    //不能为null的字段，不能配置为不显示
                    if(field.getfNullable()!=null && field.getfNullable() == 0 && fieldDisPlay.getVisible() == 0){
                        throw new GwValidateException(field.getfFieldname()+"字段信息配置是必填项，不能配置为不显示，请重新配置！");
                    }
                    TbtskGroup tbtskGroup = new TbtskGroup();
                    tbtskGroup.setfSyscode(sysCode);
                    tbtskGroup.setfTablename(tableName);
                    tbtskGroup.setfFieldname(field.getfFieldname());
                    tbtskGroup.setfFieldid(field.getfId());
                    tbtskGroup.setfAlias(field.getfAlias());
                    tbtskGroup.setfFieldorder(i);
                    tbtskGroup.setfGrouporder(j);
                    tbtskGroup.setfGroupcode(AUDITCITYCODE);
                    tbtskGroup.setfSubgroupname(group.getTitle());
                    tbtskGroup.setfControltype(fieldDisPlay.getDisplayType());
                    tbtskGroup.setfTip(fieldDisPlay.getTips());
                    tbtskGroup.setfCode(fieldDisPlay.getEditAble());
                    tbtskGroup.setNotNull(fieldDisPlay.getNotNull());
                    tbtskGroup.setConnection(fieldDisPlay.getConnection());
                    tbtskGroup.setVisible(fieldDisPlay.getVisible());
                    tbtskGroup.setItemGroupName(fieldDisPlay.getItemGroupName());
                    tbtskGroup.setfRegexp(fieldDisPlay.getRuleReg());
                    String regEx = "/[#\\\\$%\\\\^&\\\\*【】@!！￥?|‘；：”“\\'<>+=:]+/g";
                    if(sysCode.equals("web")  && (field.getfFieldtype().equals("1") || field.getfFieldtype().equals("2"))
                            && (field.getfCodetableid() == null || field.getfCodetableid().equals("")) ){
                        tbtskGroup.setfRegexp(regEx);
                    }
                    if ("1".equalsIgnoreCase(field.getRuleReg())) {
                        // 身份证号正则
                        tbtskGroup.setfRegexp("(^[1-9]\\d{5}(18|19|([23]\\d))\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{3}[0-9Xx]$)|(^[1-9]\\d{5}\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{2}[0-9Xx]$)");
                    } else if ("2".equalsIgnoreCase(field.getRuleReg())) {
                        // 手机号正则
                        tbtskGroup.setfRegexp("^1(3|4|5|6|7|8|9)\\d{9}$");
                    }
                    groupTotal.add(tbtskGroup);
                }
            }
        }

       // 添加区省级审核字段配置
        if(appConfig.getFieldInSJAudit()!=null){
            for (int j = 0; j < appConfig.getFieldInSJAudit().size(); j++) {
                FieldGroup group = appConfig.getFieldGroup().get(j);
                List<FieldDisPlay> fields = group.getFields();
                for (int i = 0; i < fields.size(); i++) {
                    FieldDisPlay fieldDisPlay = fields.get(i);
                    TbtskFields field = tbtskFieldsRepository.findById(fieldDisPlay.getFieldId()).orElse(null);
                    //不能为null的字段，不能配置为不显示
                    if(field.getfNullable()!=null && field.getfNullable() == 0 && fieldDisPlay.getVisible() == 0){
                        throw new GwValidateException(field.getfFieldname()+"字段信息配置是必填项，不能配置为不显示，请重新配置！");
                    }
                    TbtskGroup tbtskGroup = new TbtskGroup();
                    tbtskGroup.setfSyscode(sysCode);
                    tbtskGroup.setfTablename(tableName);
                    tbtskGroup.setfFieldname(field.getfFieldname());
                    tbtskGroup.setfFieldid(field.getfId());
                    tbtskGroup.setfAlias(field.getfAlias());
                    tbtskGroup.setfFieldorder(i);
                    tbtskGroup.setfGrouporder(j);
                    tbtskGroup.setfGroupcode(AUDITSJCODE);
                    tbtskGroup.setfSubgroupname(group.getTitle());
                    tbtskGroup.setfControltype(fieldDisPlay.getDisplayType());
                    tbtskGroup.setfTip(fieldDisPlay.getTips());
                    tbtskGroup.setfCode(fieldDisPlay.getEditAble());
                    tbtskGroup.setNotNull(fieldDisPlay.getNotNull());
                    tbtskGroup.setConnection(fieldDisPlay.getConnection());
                    tbtskGroup.setVisible(fieldDisPlay.getVisible());
                    tbtskGroup.setItemGroupName(fieldDisPlay.getItemGroupName());
                    tbtskGroup.setfRegexp(fieldDisPlay.getRuleReg());
                    String regEx = "/[#\\\\$%\\\\^&\\\\*【】@!！￥?|‘；：”“\\'<>+=:]+/g";
                    if(sysCode.equals("web")  && (field.getfFieldtype().equals("1") || field.getfFieldtype().equals("2"))
                            && (field.getfCodetableid() == null || field.getfCodetableid().equals("")) ){
                        tbtskGroup.setfRegexp(regEx);
                    }
                    if ("1".equalsIgnoreCase(field.getRuleReg())) {
                        // 身份证号正则
                        tbtskGroup.setfRegexp("(^[1-9]\\d{5}(18|19|([23]\\d))\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{3}[0-9Xx]$)|(^[1-9]\\d{5}\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{2}[0-9Xx]$)");
                    } else if ("2".equalsIgnoreCase(field.getRuleReg())) {
                        // 手机号正则
                        tbtskGroup.setfRegexp("^1(3|4|5|6|7|8|9)\\d{9}$");
                    }
                    groupTotal.add(tbtskGroup);
                }
            }
        }
//        添加详情主显字段
        List<String> fieldInDetailMain = appConfig.getFieldInDetailMain();
        if(fieldInDetailMain != null && fieldInDetailMain.size() > 0){
            IntStream.range(0, fieldInDetailMain.size()).forEach(i -> {
                TbtskFields field = tbtskFieldsRepository.findById(fieldInDetailMain.get(i)).orElse(null);
                TbtskGroup group = new TbtskGroup();
                group.setfSyscode(sysCode);
                group.setfGroupcode(MAINCODE);
                group.setfTablename(tableName);
                group.setfFieldname(field.getfFieldname());
                group.setfFieldid(field.getfId());
                group.setfAlias(field.getfAlias());
                group.setfFieldorder(i);
                groupTotal.add(group);
            });
        }
//       系统字段筛选配置
        tbtskGroupRepository.deleteByTbnameGroupSys(StringUtils.isNotBlank(tableName)?tableName:tableId, FILTERSYSCODE,sysCode);
        List<String> fieldInSysFilter = appConfig.getFieldInSysFilter();
        if(fieldInSysFilter != null && fieldInSysFilter.size() > 0){
            fieldInSysFilter = fieldInSysFilter.stream().distinct().collect(Collectors.toList());
            for (int i = 0; i < fieldInSysFilter.size(); i++) {
                TbtskSysFields field = tbtskSysFieldsRepository.findById(fieldInSysFilter.get(i)).orElse(null);
                if (isApprove == 0 && field.getfAlias().contains("审核")) {
                    continue;
                }
                TbtskGroup group = new TbtskGroup();
                group.setfSyscode(sysCode);
                group.setfGroupcode(FILTERSYSCODE);
                group.setfTablename(tableName);
                group.setfFieldname(field.getfFieldname());
                group.setfFieldid(field.getfId());
                group.setfFieldtype(field.getfFieldtype());
                group.setfAlias(field.getfAlias());
                group.setfFieldorder(i);
                groupTotal.add(group);
            }
        }
//       业务字段排序配置
        List<String> fieldInOrder = appConfig.getFieldInOrder();
        if(fieldInOrder != null && fieldInOrder.size() > 0){
            IntStream.range(0, fieldInOrder.size()).forEach(i -> {
                TbtskFields field = tbtskFieldsRepository.findById(fieldInOrder.get(i)).orElse(null);
                TbtskGroup group = new TbtskGroup();
                group.setfSyscode(sysCode);
                group.setfGroupcode(ORDERCODE);
                group.setfTablename(tableName);
                group.setfFieldname(field.getfFieldname());
                group.setfFieldid(field.getfId());
                group.setfAlias(field.getfAlias());
                group.setfFieldorder(i);
                groupTotal.add(group);
            });
        }
//        添加显示详情中展示的字段
        for (int j = 0; j < appConfig.getFieldGroup().size(); j++) {
            FieldGroup group = appConfig.getFieldGroup().get(j);
            List<FieldDisPlay> fields = group.getFields();
            for (int i = 0; i < fields.size(); i++) {
                FieldDisPlay fieldDisPlay = fields.get(i);
                TbtskFields field = tbtskFieldsRepository.findById(fieldDisPlay.getFieldId()).orElse(null);
                //不能为null的字段，不能配置为不显示
                if(field.getfNullable()!=null && field.getfNullable() == 0 && fieldDisPlay.getVisible() == 0){
                    throw new GwValidateException(field.getfFieldname()+"字段信息配置是必填项，不能配置为不显示，请重新配置！");
                }
                TbtskGroup tbtskGroup = new TbtskGroup();
                tbtskGroup.setfSyscode(sysCode);
                tbtskGroup.setfTablename(tableName);
                tbtskGroup.setfFieldname(field.getfFieldname());
                tbtskGroup.setfFieldid(field.getfId());
                tbtskGroup.setfAlias(field.getfAlias());
                tbtskGroup.setfFieldorder(i);
                tbtskGroup.setfGrouporder(j);
                tbtskGroup.setfGroupcode(DETAILCODE);
                tbtskGroup.setfSubgroupname(group.getTitle());
                tbtskGroup.setfControltype(fieldDisPlay.getDisplayType());
                tbtskGroup.setfTip(fieldDisPlay.getTips());
                tbtskGroup.setfCode(fieldDisPlay.getEditAble());
                tbtskGroup.setNotNull(fieldDisPlay.getNotNull());
                tbtskGroup.setConnection(fieldDisPlay.getConnection());
                tbtskGroup.setVisible(fieldDisPlay.getVisible());
                tbtskGroup.setItemGroupName(fieldDisPlay.getItemGroupName());
                tbtskGroup.setfRegexp(fieldDisPlay.getRuleReg());
                String regEx = "/[#\\\\$%\\\\^&\\\\*【】@!！￥?|‘；：”“\\'<>+=:]+/g";
                if(sysCode.equals("web")  && (field.getfFieldtype().equals("1") || field.getfFieldtype().equals("2"))
                        && (field.getfCodetableid() == null || field.getfCodetableid().equals("")) ){
                    tbtskGroup.setfRegexp(regEx);
                }
                if ("1".equalsIgnoreCase(field.getRuleReg())) {
                    // 身份证号正则
                    tbtskGroup.setfRegexp("(^[1-9]\\d{5}(18|19|([23]\\d))\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{3}[0-9Xx]$)|(^[1-9]\\d{5}\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{2}[0-9Xx]$)");
                } else if ("2".equalsIgnoreCase(field.getRuleReg())) {
                    // 手机号正则
                    tbtskGroup.setfRegexp("^1(3|4|5|6|7|8|9)\\d{9}$");
                }
                groupTotal.add(tbtskGroup);
            }
            //保存按钮功能
            tbtskGroupRepository.deleteBySysAndTablename(tableName,sysCode,DETAILCODE);
            if (group.getButton() != null) {
                TbtskGroup tbtskGroup = new TbtskGroup();
                tbtskGroup.setfSyscode(sysCode);
                tbtskGroup.setfTablename(tableName);
                tbtskGroup.setfFieldname(group.getButton());
                tbtskGroup.setfGroupcode(DETAILCODE);
                tbtskGroup.setfSubgroupname(group.getTitle());
                groupTotal.add(tbtskGroup);
            }
        }
        tbtskGroupRepository.saveAll(groupTotal);
    }

    @Transactional(rollbackFor = Exception.class)
    public void saveAppConfigByTemplate(AppConfigDTO appConfig, String sysCode) {
        TbtskTemplate taskTemplate = tbtskTemplateDao.findById(appConfig.getBizId()).orElse(null);
        saveAppConfigByTableId(appConfig, taskTemplate.getTableId(), sysCode,1);
    }

    @Transactional(rollbackFor = Exception.class)
    public void saveAppConfigByTaskId(AppConfigDTO appConfig, String sysCode) {
        GutilAssert.hasLength(appConfig.getBizId(), "不能为空");
        TskTaskBiz one = tskTaskBizRepository.findById(appConfig.getBizId()).orElse(null);
        GutilAssert.isTrue(one != null, "任务查找失败");
        if(StringUtils.isBlank(appConfig.getTableId())){
            appConfig.setTableId(one.getTableId());
        }
        if(StringUtils.isNotBlank(one.getStructDbUrl())){
            one.setStructDbUrl(null);
            tskTaskBizRepository.save(one);
        }
        saveAppConfigByTableId(appConfig, appConfig.getTableId(), sysCode,one.getIsApprove() == null ? 0:one.getIsApprove());
    }

    public AppConfigDTO findGroupFieldByTaskIdAndSysCode(String taskId, String sys,String tableId) {
        GutilAssert.hasLength(taskId, "不能为空");
        String tableName = "";
        if(StringUtils.isNotBlank(tableId)){
            TbtskObjectinfo tbtskObjectinfo = tbtskObjectinfoRepository.findById(tableId).orElse(null);
            GutilAssert.isTrue(tbtskObjectinfo != null, "任务查找失败");
            tableName = tbtskObjectinfo.getfTablename();
        }else{
            TskTaskBiz tskTaskBiz = tskTaskBizRepository.findById(taskId).orElse(null);
            TbtskObjectinfo tbtskObjectinfo = tbtskObjectinfoRepository.findById(tskTaskBiz.getTableId()).orElse(null);
            GutilAssert.isTrue(tbtskObjectinfo != null, "任务查找失败");
            tableId = tskTaskBiz.getTableId();
            tableName = tbtskObjectinfo.getfTablename();
        }
        AppConfigDTO appconfigDTO = getAppconfigDTO(tableId,StringUtils.isNotBlank(tableName)?tableName:tableId, sys);
        appconfigDTO.setBizId(taskId);
        return appconfigDTO;
    }

    public AppConfigDTO findGroupFieldBySysCode(String templateId, String sys) {
        TbtskTemplate template = tbtskTemplateDao.findById(templateId).orElse(null);
        String tableId = template.getTableId();
        AppConfigDTO appconfigDTO = getAppconfigDTO(tableId,tableId, sys);
        appconfigDTO.setBizId(templateId);
        return appconfigDTO;
    }

    private AppConfigDTO getAppconfigDTO(String tableId,String tableName, String sys) {
        GutilAssert.hasLength(tableId, "表不能为空");
        GutilAssert.hasLength(sys, "sys不能为空");
        List<TbtskGroup> listGroup = tbtskGroupRepository.selectByTableIdAndGroupcode(sys, tableId, LISTCODE);
        List<TbtskGroup> filterGroup = tbtskGroupRepository.selectByTableIdAndGroupcode(sys, tableId, FILTERCODE);
        List<TbtskGroup> searchGroup = tbtskGroupRepository.selectByTableIdAndGroupcode(sys, tableId, SEARCHCODE);
        List<TbtskGroup> fieldInQxAudit = tbtskGroupRepository.selectByTableIdAndGroupcode(sys, tableId, AUDITQXCODE);
        List<TbtskGroup> fieldInCityAudit = tbtskGroupRepository.selectByTableIdAndGroupcode(sys, tableId, AUDITCITYCODE);
        List<TbtskGroup> fieldInSjAudit = tbtskGroupRepository.selectByTableIdAndGroupcode(sys, tableId, DETAILCODE);
        List<TbtskGroup> detailGroup = tbtskGroupRepository.selectByTableIdAndGroupcode(sys, tableId, DETAILCODE);
        List<TbtskGroup> detailMainGroup = tbtskGroupRepository.selectByTableIdAndGroupcode(sys, tableId, MAINCODE);
        List<TbtskGroup>   fieldInSysFilter = tbtskGroupRepository.selectSysByTableNameAndGroupcode(sys, tableName, FILTERSYSCODE);
        List<TbtskGroup>  fieldInOrder = tbtskGroupRepository.selectByTableIdAndGroupcode(sys, tableName, ORDERCODE);

        AppConfigDTO appConfigDTO = new AppConfigDTO();
        appConfigDTO.setFieldInList(listGroup.stream().map(r -> r.getfFieldid()).collect(Collectors.toList()));
        appConfigDTO.setFieldInFilter(filterGroup.stream().map(r -> r.getfFieldid()).collect(Collectors.toList()));
        appConfigDTO.setFieldInSearch(searchGroup.stream().map(r -> r.getfFieldid()).collect(Collectors.toList()));
        appConfigDTO.setFieldInDetailMain(detailMainGroup.stream().map(r -> r.getfFieldid()).collect(Collectors.toList()));
        appConfigDTO.setFieldInSysFilter(fieldInSysFilter.stream().map(r -> r.getfFieldid()).collect(Collectors.toList()));
        appConfigDTO.setFieldInOrder(fieldInOrder.stream().map(r -> r.getfFieldid()).collect(Collectors.toList()));

        //区县
        List<FieldGroup> fieldGroupsQx = new ArrayList<>();
        HashMap<String, List<FieldDisPlay>> mapQx = new HashMap();
        fieldInQxAudit.stream().filter(r -> r.getfFieldid() != null).forEach(group -> {
            String title = group.getfSubgroupname();
            if (!mapQx.containsKey(title)) {
                ArrayList<FieldDisPlay> fields = new ArrayList<>();
                mapQx.put(title, fields);
                FieldGroup fieldGroup = new FieldGroup();
                fieldGroup.setTitle(title);
                fieldGroupsQx.add(fieldGroup);
            }
            FieldDisPlay field = new FieldDisPlay();
            field.setDisplayType(group.getfControltype());
            field.setEditAble(group.getfCode());
            field.setFieldId(group.getfFieldid());
            field.setNotNull(group.getNotNull());
            field.setEditAble(group.getfCode());
            field.setTips(group.getfTip());
            field.setId(group.getfId());
            field.setConnection(group.getConnection());
            field.setVisible(group.getVisible());
            field.setItemGroupName(group.getItemGroupName());
            mapQx.get(title).add(field);
        });

        for (FieldGroup fieldGroup : fieldGroupsQx) {
            String key = fieldGroup.getTitle();
            fieldGroup.setFields(mapQx.get(key));
        }
        appConfigDTO.setFieldInQxAudit(fieldGroupsQx);
        //市级
        List<FieldGroup> fieldGroupsCity = new ArrayList<>();
        HashMap<String, List<FieldDisPlay>> mapCity = new HashMap();
        fieldInCityAudit.stream().filter(r -> r.getfFieldid() != null).forEach(group -> {
            String title = group.getfSubgroupname();
            if (!mapCity.containsKey(title)) {
                ArrayList<FieldDisPlay> fields = new ArrayList<>();
                mapCity.put(title, fields);
                FieldGroup fieldGroup = new FieldGroup();
                fieldGroup.setTitle(title);
                fieldGroupsCity.add(fieldGroup);
            }
            FieldDisPlay field = new FieldDisPlay();
            field.setDisplayType(group.getfControltype());
            field.setEditAble(group.getfCode());
            field.setFieldId(group.getfFieldid());
            field.setNotNull(group.getNotNull());
            field.setEditAble(group.getfCode());
            field.setTips(group.getfTip());
            field.setId(group.getfId());
            field.setConnection(group.getConnection());
            field.setVisible(group.getVisible());
            field.setItemGroupName(group.getItemGroupName());
            mapCity.get(title).add(field);
        });

        for (FieldGroup fieldGroup : fieldGroupsCity) {
            String key = fieldGroup.getTitle();
            fieldGroup.setFields(mapCity.get(key));
        }
        appConfigDTO.setFieldInCityAudit(fieldGroupsCity);
        //省级
        List<FieldGroup> fieldGroupsSJ = new ArrayList<>();
        HashMap<String, List<FieldDisPlay>> mapSJ = new HashMap();
        fieldInSjAudit.stream().filter(r -> r.getfFieldid() != null).forEach(group -> {
            String title = group.getfSubgroupname();
            if (!mapSJ.containsKey(title)) {
                ArrayList<FieldDisPlay> fields = new ArrayList<>();
                mapSJ.put(title, fields);
                FieldGroup fieldGroup = new FieldGroup();
                fieldGroup.setTitle(title);
                fieldGroupsSJ.add(fieldGroup);
            }
            FieldDisPlay field = new FieldDisPlay();
            field.setDisplayType(group.getfControltype());
            field.setEditAble(group.getfCode());
            field.setFieldId(group.getfFieldid());
            field.setNotNull(group.getNotNull());
            field.setEditAble(group.getfCode());
            field.setTips(group.getfTip());
            field.setId(group.getfId());
            field.setConnection(group.getConnection());
            field.setVisible(group.getVisible());
            field.setItemGroupName(group.getItemGroupName());
            mapSJ.get(title).add(field);
        });

        for (FieldGroup fieldGroup : fieldGroupsSJ) {
            String key = fieldGroup.getTitle();
            fieldGroup.setFields(mapSJ.get(key));
        }
        appConfigDTO.setFieldInSJAudit(fieldGroupsSJ);
        //详情
        List<FieldGroup> fieldGroups = new ArrayList<>();
        HashMap<String, List<FieldDisPlay>> map = new HashMap();
        HashMap<String, String> btnMap = new HashMap();
        detailGroup.stream().filter(r -> r.getfFieldid() != null).forEach(group -> {
            String title = group.getfSubgroupname();
            if (!map.containsKey(title)) {
                ArrayList<FieldDisPlay> fields = new ArrayList<>();
                map.put(title, fields);
                FieldGroup fieldGroup = new FieldGroup();
                fieldGroup.setTitle(title);
                fieldGroups.add(fieldGroup);
            }
            FieldDisPlay field = new FieldDisPlay();
            field.setDisplayType(group.getfControltype());
            field.setEditAble(group.getfCode());
            field.setFieldId(group.getfFieldid());
            field.setNotNull(group.getNotNull());
            field.setEditAble(group.getfCode());
            field.setTips(group.getfTip());
            field.setId(group.getfId());
            field.setConnection(group.getConnection());
            field.setVisible(group.getVisible());
            field.setItemGroupName(group.getItemGroupName());
            map.get(title).add(field);
        });

        if(detailGroup.size()>0){
            //查询功能按钮button
            List<TbtskGroup> detailGroupAuditFields = tbtskGroupRepository.selectAuditFields(sys, detailGroup.get(0).getfTablename(),DETAILCODE);
            if(detailGroupAuditFields.size()>0){
                detailGroupAuditFields.stream().filter(r -> r.getfFieldid() == null).forEach(button -> {
                    btnMap.put(button.getfSubgroupname(), button.getfFieldname());
                });
            }
        }
        for (FieldGroup fieldGroup : fieldGroups) {
            String key = fieldGroup.getTitle();
            fieldGroup.setFields(map.get(key));
            if (btnMap.containsKey(key))
                fieldGroup.setButton(btnMap.get(key));
        }
        appConfigDTO.setFieldGroup(fieldGroups);
        return appConfigDTO;
    }
    public List<TbtskFields> getNyFields(String bizId) {
        return null;
    }

    public List<TbtskFieldGroupView> getTaskFieldsMateWeb(String taskId,String tableId, String groupCode) {
        if(StringUtils.isBlank(tableId)){
            TskTaskBiz task = tskTaskBizRepository.findById(taskId).orElse(null);
            tableId = task.getTableId();
        }
        return tbtskFieldsGroupViewRepository.getTbtskFieldsBySysCodeAndGroupCode(tableId, "web", groupCode);
    }

    public List<TbtskFieldGroupView> getTaskFieldsMateWebByTableId(String tableId, String groupCode) {
        return tbtskFieldsGroupViewRepository.getTbtskFieldsBySysCodeAndGroupCode(tableId, "web", groupCode);
    }


    public List<TbtskGroup> selectSysByTableNameAndGroupcode(String taskId,String tableId, String groupCode) {
        String tableName = "";
        if(StringUtils.isNotBlank(tableId)){
            TbtskObjectinfo tbtskObjectinfo = tbtskObjectinfoRepository.findById(tableId).orElse(null);
             tableName = tbtskObjectinfo.getfTablename();
        }else{
            TskTaskBiz task = tskTaskBizRepository.findById(taskId).orElse(null);
            TbtskObjectinfo tbtskObjectinfo = tbtskObjectinfoRepository.findById(task.getTableId()).orElse(null);
            tableId = tbtskObjectinfo.getfId();
            tableName = tbtskObjectinfo.getfTablename();
        }
        return tbtskGroupRepository.selectSysByTableNameAndGroupcode("web", StringUtils.isNotBlank(tableName)?tableName:tableId, groupCode);
    }

    public List<TbtskGroup> selectSysByTableIdAndGroupcode(String tableId, String groupCode) {
        TbtskObjectinfo tbtskObjectinfo = tbtskObjectinfoRepository.findById(tableId).orElse(null);
        String tableName = tbtskObjectinfo.getfTablename();
        return tbtskGroupRepository.selectSysByTableNameAndGroupcode("web", StringUtils.isNotBlank(tableName)?tableName:tableId, groupCode);
    }

}
