package com.geoway.landteam.landcloud.service.customtask.task;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.mapper.task.TbtskRejectDefMapper;
import com.geoway.landteam.customtask.mapper.task.TbtskTaskBizFlowMapper;
import com.geoway.landteam.customtask.pub.dto.ApproveRecordDTO;
import com.geoway.landteam.customtask.pub.dto.FlowDefInfoDTO;
import com.geoway.landteam.customtask.pub.dto.FlowStep;
import com.geoway.landteam.customtask.pub.entity.TaskQueryParameter;
import com.geoway.landteam.customtask.pub.entity.TaskRecord;
import com.geoway.landteam.customtask.repository.task.*;
import com.geoway.landteam.customtask.servface.task.*;
import com.geoway.landteam.customtask.task.enm.FlowTypeEnum;
import com.geoway.landteam.customtask.task.entity.*;
import com.geoway.landteam.customtask.util.ExcelUtil;
import com.geoway.landteam.landcloud.core.model.base.enm.ReviewStageEnum;
import com.geoway.landteam.landcloud.core.model.base.enm.TbStatusEnum;
import com.geoway.landteam.landcloud.core.model.base.entity.TaskBasicRelation;
import com.geoway.landteam.landcloud.core.model.pub.constants.BizIdConstants;
import com.geoway.landteam.landcloud.core.model.pub.constants.JobConstants;
import com.geoway.landteam.landcloud.core.model.pub.constants.NumberConst;
import com.geoway.landteam.landcloud.core.repository.base.AppMediaRepository;
import com.geoway.landteam.landcloud.core.repository.base.RegionTownRepository;
import com.geoway.landteam.landcloud.core.repository.base.TaskBasicRelationRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandUser2AreaRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandUserRepository;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.pub.impl.SystemConfigCacheService;
import com.geoway.landteam.landcloud.core.servface.user.UserNameService;
import com.geoway.landteam.landcloud.core.service.util.message.MixPushServer;
import com.geoway.landteam.landcloud.servface.customtask.task.MTbtskRejectDefService;
import com.geoway.landteam.landcloud.servface.customtask.task.MTbtskRevokeRecordService;
import com.geoway.landteam.landcloud.servface.customtask.task.MTbtskUserAuditAreaService;
import com.geoway.landteam.landcloud.servface.customtask.task.MTbtskUserReviewAreaService;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.gw.base.log.GwLoger;
import com.gw.base.log.GiLoger;


/*import com.gw.base.data.GwValidateException;*/
import com.gw.base.util.GutilAssert;
import com.gw.base.util.GutilCollection;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import com.geoway.landteam.landcloud.common.util.base.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.core.util.KeyValuePair;
import org.javatuples.Triplet;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

import static com.geoway.landteam.landcloud.core.model.base.enm.TbStatusEnum.*;


/***
 * 业务流
 */

@Service
@Transactional(rollbackFor = Exception.class)
public class MTbtskFlowService {
    private static final GiLoger log = GwLoger.getLoger();
    private static final int BATCH_COMMIT_COUNT = 100;

    private static final String TABLE_NAME_LZGD_FW = "tb_app_task_lzgd_zd";
    private static final String TABLE_NAME_LZGD_TB = "tb_app_task_lzgd_prj";
    public static final String TASK_ID_LZGD = "gxlzgd";
    public static final String TYPE_TB = "TB";
    public static final String TYPE_FW = "FW";
    private final ReviewStageEnum[] AuditStageArray = new ReviewStageEnum[]{
            ReviewStageEnum.VILLAGE_VERIFY,
            ReviewStageEnum.TOWN_VERIFY,
            ReviewStageEnum.COUNTY_VERIFY,
            ReviewStageEnum.CITY_VERIFY,
            ReviewStageEnum.PROVINCE_VERIFY,
            ReviewStageEnum.COUNTRY_VERIFY,
            ReviewStageEnum.OVER_VERIFY
    };
    private final ReviewStageEnum[] AuditReviewStageArray = new ReviewStageEnum[]{
            ReviewStageEnum.VILLAGE_VERIFY,
            ReviewStageEnum.VILLAGE_VERIFY,
            ReviewStageEnum.TOWN_VERIFY,
            ReviewStageEnum.TOWN_VERIFY,
            ReviewStageEnum.COUNTY_VERIFY,
            ReviewStageEnum.COUNTY_VERIFY,
            ReviewStageEnum.CITY_VERIFY,
            ReviewStageEnum.CITY_VERIFY,
            ReviewStageEnum.PROVINCE_VERIFY,
            ReviewStageEnum.PROVINCE_VERIFY,
            ReviewStageEnum.COUNTRY_VERIFY,
            ReviewStageEnum.COUNTRY_VERIFY,
            ReviewStageEnum.OVER_VERIFY
    };
    @Autowired
    SystemConfigCacheService systemConfigCacheService;

    @Autowired
    TbtskFlowDefRepository tbtskFlowDefRepository;
    @Autowired
    TbtskTaskBizFlowService tbtskTaskBizFlowService;
    @Autowired
    TbtskTaskBizFlowMapper tbtskTaskBizFlowMapper;
    @Autowired
    TbtskRejectDefMapper tbtskRejectDefMapper;
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    TbtskApproveRecordRepository tbtskApproveRecordRepository;
    @Autowired
    TbtskSubmitReportRecordRepository tbtskSubmitReportRecordRepository;
    @Autowired
    MDataBizService mDataBizService;
    @Autowired
    MTbtskObjectinfoService mTbtskObjectinfoService;
    @Autowired
    MTskTaskBizService mTskTaskBizService;
    @Autowired
    LandUser2AreaRepository landUser2AreaRepository;
    @Autowired
    TaskBasicRelationRepository taskBasicRelationRepository;
    @Autowired
    LandUserRepository landUserRepository;
    @Autowired
    LandUser2AreaRepository landUser2AreaDao;
    @Autowired
    TbtskRejectRecordRepository tbtskRejectRecordRepository;
    @Autowired
    RegionTownRepository regionTownRepository;
    @Autowired
    MTaskNoticeService mTaskNoticeService;
    @Autowired
    UserBiz2Repository userBiz2Repository;
    @Autowired
    TskAssignRecordRepository tskAssignRecordRepository;
    @Autowired
    DefaultOssOperatorService defaultOssOperatorService;
    @Autowired
    MTbtskRejectDefService mTbtskRejectDefService;
    @Autowired
    AppMediaRepository appMediaRepository;
    @Autowired
    RedisTemplate redisTemplate;
    @Autowired
    MTaskRecordService mTaskRecordService;
    @Autowired
    TskTaskBizRepository tskTaskBizRepository;
    @Autowired
    TbtskObjectinfoRepository tbtskObjectinfoRepository;
    @Autowired
    TbtskFieldsRepository tbtskFieldsRepository;
    @Autowired
    MTbtskUserReviewAreaService tbtskUserReviewAreaService;
    @Autowired
    MTbtskUserAuditAreaService tbtskUserAuditAreaService;
    @Autowired
    MTbtskRevokeRecordService tbtskRevokeRecordService;
    @Autowired
    UserNameService userNameService;
    @Autowired
    MConfigTaskReviewService mConfigTaskReviewService;

    /**
     * 查询业务流程
     */
    public List<TbtskFlowDef> findFlow(String taskId, Integer type) {
        return tbtskFlowDefRepository.findTbtskFlowByTaskId(taskId, type);
    }

    /**
     * 查询业务流程对应步骤信息
     */
    public List<FlowStep> findFlowSteps(String taskId, FlowTypeEnum flowType) {
        List<TbtskFlowDef> flows = tbtskFlowDefRepository.findTbtskFlowByTaskId(taskId, flowType.getCode());
        if (flows == null || flows.size() == 0) {
            return null;
        }
        Gson gson = new Gson();
        List<FlowStep> steps = gson.fromJson(flows.get(0).getSteps(), new TypeToken<List<FlowStep>>() {
        }.getType());
        return steps;
    }

    /**
     * 查找流程节点
     *
     * @param tbtskFlowDef
     * @param name
     * @param returnFirstStepIfNX，如果流程节点不存在，是否返回第一个流程节点
     * @return
     */
    public FlowStep getFlowStep(TbtskFlowDef tbtskFlowDef, String name, boolean returnFirstStepIfNX) {
        JSONArray steps = JSONArray.parseArray(tbtskFlowDef.getSteps());
        for (int i = 0; i < steps.size(); i++) {
            FlowStep flowStep = new Gson().fromJson(String.valueOf(steps.getJSONObject(i)), FlowStep.class);
            if (flowStep.getName().equals(name)) {
                return flowStep;
            }
        }
        if (returnFirstStepIfNX) {
            if (steps != null && steps.size() > 0) {
                return new Gson().fromJson(String.valueOf(steps.getJSONObject(0)), FlowStep.class);
            } else {
                return null;
            }
        } else {
            return null;
        }
    }

    /**
     * 查询业务流程对应步骤信息
     */
    public FlowStep findFlow(String taskId, Integer type, Integer step) {
        List<TbtskFlowDef> flows = tbtskFlowDefRepository.findTbtskFlowByTaskId(taskId, type);
        if (flows == null || flows.size() == 0) {
            return null;
        }
        JSONArray steps =   JSONArray.parseArray(flows.get(0).getSteps());
        FlowStep flowStep = new Gson().fromJson(String.valueOf(steps.getJSONObject(step)), FlowStep.class);
        flowStep.setContainReview(flows.get(0).getContainsReview().equals(NumberConst.ONE));
        return flowStep;
    }

    /**
     * 作业员提报
     *
     * @param taskId 业务id
     * @param tbIds  图斑/房屋编号，多个图斑/房屋编号之间以英文逗号隔开
     * @param type   类型，TB/FW
     * @param userId
     * @return
     */
    public String operatorSubmit(String taskId, String tbIds, String type, Long userId) {
        String result = "提报成功";
        GutilAssert.state(StringUtils.isNoneBlank(taskId), "taskId 参数不能为空.");
        GutilAssert.state(StringUtils.isNoneBlank(tbIds), "tbIds 参数不能为空.");
        result = mConfigTaskReviewService.operatorSubmit(taskId, tbIds, type, userId);
        return result;
    }

    /**
     * 作业员按政区提报
     *
     * @param taskId 业务id
     * @param userId
     * @param ywzp
     * @return
     */
    public String operatorSubmitFwByFilter(String taskId, String xzqdm, String fwbh, Integer jslx, String xfzt, String tjzt, String tbzt, String xmhj, String shfh, String sfdh, Date startTime, Date endTime, Long userId, String ywzp) throws Exception {
        String result = "提报成功";
        GutilAssert.state(StringUtils.isNoneBlank(taskId), "taskId 参数不能为空.");
        GutilAssert.state(StringUtils.isNoneBlank(xzqdm) && xzqdm.length() >= 6 && xzqdm.length() <= 12, "regionCode 参数不能为空且长度6-12位.");

        result = "提报失败，暂不支持配置任务业务类型";

        return result;
    }

    public String submitByConditionFilter(String taskId, Long userId, TaskQueryParameter taskQueryParameter) throws Exception {
        String result = "提报成功";
        GutilAssert.state(StringUtils.isNoneBlank(taskId), "taskId 参数不能为空.");
        //将参数添加到任务记录中进行后台处理
        JSONObject params = new JSONObject();
        params.put("filterType", "conditionFilter");
        params.put("userId", userId);
        params.put("taskQueryParameter", taskQueryParameter);
        addTaskRecord(params, userId, JobConstants.JOB_TYPE_CONFIG_TASK_SUBMIT_BATCH, taskId);
        return result;
    }

    /**
     * 添加定时任务记录
     *
     * @param params
     * @param userId
     * @param taskType
     * @param bizId
     */
    public void addTaskRecord(JSONObject params, Long userId, Integer taskType, String bizId) {
        TaskRecord record = new TaskRecord();
        record.setId(UUID.randomUUID().toString());
        record.setParam(JSONObject.toJSONString(params));
        record.setTasktype(taskType);
        record.setStarttime(new Date());
        record.setState(1);
        record.setUserid(userId);
        record.setBizId(bizId);
        mTaskRecordService.save(record);
    }

    /**
     * 房屋状态更新
     *
     * @param taskId
     * @param xzqdm
     * @param fwbh
     * @param jslx
     * @param xfzt
     * @param tjzt
     * @param tbzt
     * @param xmhj
     * @param shfh
     * @param sfdh
     * @param startTime
     * @param endTime
     * @param userId
     * @param ywzp
     * @return
     * @throws Exception
     */
    public String statusUpdateFwByFilter(String taskId, String xzqdm, String fwbh, Integer jslx, String xfzt, String tjzt, String tbzt, String xmhj, String shfh, String sfdh, Date startTime, Date endTime, Long userId, String ywzp) throws Exception {
        String result = "";
        GutilAssert.state(StringUtils.isNoneBlank(taskId), "taskId 参数不能为空.");
        /* GutilAssert.state(StringUtils.isNoneBlank(xzqdm) && xzqdm.length() >= 6 && xzqdm.length() <= 12, "regionCode 参数不能为空且长度6-12位.");*/

        result = "状态刷新失败，暂不支持配置任务业务类型";

        return result;
    }

    private JSONObject getJsonObject(List<String> idList) {
        JSONObject jsonObject = new JSONObject();
        if (!GutilCollection.isEmpty(idList)) {
            jsonObject.put("total", idList.size());
            jsonObject.put("idList", StringUtils.join(idList, ","));
        } else {
            jsonObject.put("total", 0);
            jsonObject.put("idList", "");
        }
        return jsonObject;
    }

    /**
     * 根据筛选条件查询是否有未下发的数据
     *
     * @param taskId
     * @param taskQueryParameter
     * @return
     * @throws Exception
     */
    public String queryCountOfNotSubmitByFilter(String taskId, TaskQueryParameter taskQueryParameter) throws Exception {
        String result = "查询完成,没有查询到符合条件的图斑数据或未下发给当前用户";
        GutilAssert.state(StringUtils.isNoneBlank(taskId), "taskId 参数不能为空.");
        /*  GutilAssert.state(StringUtils.isNoneBlank(xzqdm) && xzqdm.length() >= 6 && xzqdm.length() <= 12, "regionCode 参数不能为空且长度6-12位.");*/
        List<Map> dataList = getConfigTaskDataList(taskQueryParameter);
        if (dataList.size() > 0) {
            List<String> idList = new ArrayList<>();
            for (Map data : dataList) {
                if (data.get("f_status") == null || Integer.parseInt(data.get("f_status").toString()) < SUBMIT.getCode()) {
                    idList.add(StringUtils.isNotBlank(data.get("f_tbbh").toString()) ? data.get("f_tbbh").toString() : "");
                }
            }
            JSONObject jsonObject = getJsonObject(idList);
            result = jsonObject.toString();
        } else {
            result = "查询完成,没有查询到符合条件的图斑数据或未下发给当前用户";
        }
        return result;
    }

    public String queryCountOfNotSubmitByIds(String taskId, String tbIds, Long userId) throws Exception {
        String result = "查询完成,没有查询到符合条件的图斑数据或未下发给当前用户";
        GutilAssert.state(StringUtils.isNoneBlank(taskId), "taskId 参数不能为空.");
        GutilAssert.state(StringUtils.isNoneBlank(tbIds), "tbIds 参数不能为空.");
        List<String> idList = Arrays.asList(tbIds.split(","));
        TskTaskBiz tskTaskBiz = tskTaskBizRepository.findById(taskId).orElse(null);
        if (null == tskTaskBiz) {
            throw new RuntimeException("提报失败，业务不存在或已被删除");
        }
        TbtskObjectinfo tbtskObjectinfo = tbtskObjectinfoRepository.getObjectByTableId(tskTaskBiz.getTableId());
        if (null == tbtskObjectinfo) {
            throw new RuntimeException("提报失败，业务数据表不存在或已被删除");
        }
        List<String> fieldNameList = getAuditFieldNameCollection();
        fieldNameList.add("f_tbbh");
        List<Map> dataList = mDataBizService.selectFieldByIds(tbtskObjectinfo.getfTablename(), fieldNameList, "f_id", idList);
        if (dataList.size() > 0) {
            List<String> idLists = new ArrayList<>();
            for (Map data : dataList) {
                if (data.get("f_status") == null || Integer.parseInt(data.get("f_status").toString()) < SUBMIT.getCode()) {
                    idLists.add(StringUtils.isNotBlank(data.get("f_tbbh").toString()) ? data.get("f_tbbh").toString() : "");
                }
            }
            //整理数据
            JSONObject jsonObject = getJsonObject(idLists);
            result = jsonObject.toString();
        } else {
            result = "查询完成,没有查询到符合条件的图斑数据或未下发给当前用户";
        }
        return result;
    }

    public String exportSubmitData(Long userId, List<Map<String, Object>> resultData) {
        // 结果集数据
        String resultUrl = "";
        try {
            // Excel储存路径
            String tempDir = System.getProperty("java.io.tmpdir");
            // Excel文件名称
            String fileName = UUID.randomUUID().toString() + ".xls";
            // 表头信息
            List<KeyValuePair> headers = new ArrayList<>();
            // 表头信息
            List<KeyValuePair> headersOne = new ArrayList<>();
            headersOne.add(KeyValuePair.newBuilder().setKey("totalNum").setValue("总数").build());
            headersOne.add(KeyValuePair.newBuilder().setKey("successNum").setValue("提报成功总数").build());
            headersOne.add(KeyValuePair.newBuilder().setKey("failNum").setValue("提报失败总数").build());
            headersOne.add(KeyValuePair.newBuilder().setKey("fwbh").setValue(resultData.get(0).get("uniqueFieldName").toString()).build());
            headersOne.add(KeyValuePair.newBuilder().setKey("result").setValue("提报结果").build());
            headersOne.add(KeyValuePair.newBuilder().setKey("userId").setValue("提报人").build());
            headersOne.add(KeyValuePair.newBuilder().setKey("uploadDate").setValue("提报时间").build());
            List<String> fieldNamesOne = headersOne.stream().map(KeyValuePair::getKey).collect(Collectors.toList());
            List<String> fieldAliasOne = headersOne.stream().map(KeyValuePair::getValue).collect(Collectors.toList());

            //将导出的数据字段转换成新的字段
            List<Map<String, Object>> resultDataOne = resultDataConversion(resultData, userId);
            String excelPath = null;
            excelPath = ExcelUtil.CreateExcel(resultDataOne, tempDir, fileName, String.join(",",
                    fieldNamesOne), String.join(",", fieldAliasOne), "批量提报结果");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            String dateString = sdf.format(new Date());
            String obsFilePath = "submitTaskData/" + userId + "/" + dateString + "/" + fileName.replace(".xls",
                    "_提报信息结果.xls");
            resultUrl = defaultOssOperatorService.sendObject2Oss(obsFilePath, excelPath);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return resultUrl;
    }

    //数据转换成新的集合
    private List<Map<String, Object>> resultDataConversion(List<Map<String, Object>> resultData, Long userId) {
        // 结果集数据  将数据转到新的数据集合
        List<Map<String, Object>> resultDataOne = new ArrayList<>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateString = sdf.format(new Date());
        for (int i = 0; i < resultData.size(); i++) {
            Map<String, Object> oldMap = resultData.get(i);
            Map<String, Object> tmpMap = new HashMap<>();
            if (resultDataOne.size() > 0) {
                boolean isContain = false;
                for (int j = 0; j < resultDataOne.size(); j++) {
                    Map<String, Object> newMap = resultDataOne.get(j);
                    //判断行政区码和返回结果是否一致，不一致，新增一条记录
                    if (newMap.get("result").equals(oldMap.get("result")) && "提报成功".equals(newMap.get("result"))) {
                        resultDataOne.get(j).put("totalNum", Integer.parseInt(newMap.get("totalNum").toString()) + 1);
                        resultDataOne.get(j).put("successNum", oldMap.get("result").toString().contains("成功") ? Integer
                                .parseInt(newMap.get("successNum").toString()) + 1 : Integer.parseInt(newMap.get("successNum").toString()) + 0);
                        isContain = true;
                        break;
                    }
                }
                if (!isContain) {
                    tmpMap.put("totalNum", 1);
                    tmpMap.put("successNum", oldMap.get("result").toString().contains("成功") ? 1 : 0);
                    tmpMap.put("failNum", oldMap.get("result").toString().contains("失败") ? 1 : 0);
                    tmpMap.put("fwbh", oldMap.get("result").toString().contains("失败") ? oldMap.get("fwbh").toString() : "");
                    tmpMap.put("result", oldMap.get("result").toString());
                    tmpMap.put("userId", userId);
                    tmpMap.put("uploadDate", dateString);
                    resultDataOne.add(tmpMap);
                }

            } else {
                tmpMap.put("totalNum", 1);
                tmpMap.put("successNum", oldMap.get("result").toString().contains("成功") ? 1 : 0);
                tmpMap.put("failNum", oldMap.get("result").toString().contains("失败") ? 1 : 0);
                tmpMap.put("fwbh", oldMap.get("result").toString().contains("失败") ? oldMap.get("fwbh").toString() : "");
                tmpMap.put("result", oldMap.get("result").toString());
                tmpMap.put("userId", userId);
                tmpMap.put("uploadDate", dateString);
                resultDataOne.add(tmpMap);
            }
        }
        return resultDataOne;
    }


    private TbtskSubmitReportRecord saveSubmitReportRecord(String taskId, String id, String xzqdm, Integer rejectCount, Long userId) {
        TbtskSubmitReportRecord submitReportRecord = new TbtskSubmitReportRecord();
        submitReportRecord.setTaskid(taskId);
        submitReportRecord.setDataid(id);
        submitReportRecord.setSubmitTime(new Date());
        submitReportRecord.setSubmitUserid(userId);
        submitReportRecord.setXzqdm(xzqdm);
        submitReportRecord.setRejectCount(rejectCount != null ? rejectCount : 0);
        return submitReportRecord;
    }

    /**
     * 四川查询举办线索审核数据接口
     *
     * @param basicId
     * @return
     */

    public List<ApproveRecordDTO> findApproveRecordBySC(String basicId) {
        List<ApproveRecordDTO> resultList = new ArrayList<>();
        TaskBasicRelation taskBasicRelation = taskBasicRelationRepository.queryByBasicId(basicId);
        if (taskBasicRelation != null) {
            resultList = getApproveRecordsAndRejectRecords(taskBasicRelation.getBizId(), taskBasicRelation.getDataId());
        }
        if (!GutilCollection.isEmpty(resultList)) {
            Collections.sort(resultList, new Comparator<ApproveRecordDTO>() {
                @Override
                public int compare(ApproveRecordDTO o1, ApproveRecordDTO o2) {
                    int flag = o2.getApproveTime().compareTo(o1.getApproveTime());
                    return flag;
                }
            });
            // Collections.sort(resultList, (e1, e2) -> e1.getApproveTime().compareTo(e2.getApproveTime()));
        }
        return resultList;
    }

    public List<Map<String, Object>> findApproveRecordBySCBasicIds(String basicIds) {
        List<Map<String, Object>> mapList = new ArrayList<>();
        String[] basiclist = basicIds.split(",");
        for (String basicId : basiclist) {
            Map map = new HashMap();
            map.put("basicId", basicId);
            List<ApproveRecordDTO> temp = this.findApproveRecordBySC(basicId);
            if (!temp.isEmpty()) {
                //查找该任务的结束节点flow
                TbtskTaskBizFlow tbtskTaskBizFlow = tbtskTaskBizFlowService.selectByTaskId(temp.get(0).getTaskid());
                //获取任务结束节点
                TbtskFlowDef flowDef = tbtskFlowDefRepository.findById(tbtskTaskBizFlow.getFlowId()).orElse(null);
                //判断下一步是否为结束节点
                if (flowDef.getStepcount().equals(temp.get(0).getNextstep())) {
                    temp.get(0).setStepindex(flowDef.getStepcount());
                }
                //获取最新的记录
                map.put("record", temp.get(0));

            } else {
                ApproveRecordDTO approveRecordDTO = new ApproveRecordDTO();
                approveRecordDTO.setStepindex(-1);
                map.put("record", approveRecordDTO);
            }

            mapList.add(map);
        }
        return mapList;
    }

    /**
     * 查询获取对应图斑的审核记录
     */
    public List<ApproveRecordDTO> findApproveRecord(String taskId, String tbId, String type, Long UserId, Integer userRole) {
        GutilAssert.state(StringUtils.isNoneBlank(taskId), "taskId 参数不能为空.");

        List<ApproveRecordDTO> resultList = new ArrayList<>();
        resultList = mConfigTaskReviewService.findApproveRecord(taskId, tbId, type, UserId, userRole);

        if (!GutilCollection.isEmpty(resultList)) {
            Collections.sort(resultList, new Comparator<ApproveRecordDTO>() {
                @Override
                public int compare(ApproveRecordDTO o1, ApproveRecordDTO o2) {
                    int flag = o2.getApproveTime().compareTo(o1.getApproveTime());
                    return flag;
                }
            });
        }
        return resultList;
    }

    /**
     * 获取打回记录
     *
     * @param taskId
     * @param tbId
     * @return
     */
    private List<ApproveRecordDTO> getRejectRecords(String taskId, String tbId) {
        List<ApproveRecordDTO> resultList = new ArrayList<>();
        List<TbtskRejectRecord> rejectRecords = tbtskRejectRecordRepository.findByTaskIdAndTbId(taskId, tbId);
        if (!GutilCollection.isEmpty(rejectRecords)) {
            for (TbtskRejectRecord rejectRecord : rejectRecords) {
                if (rejectRecord.getTargetStage().equals(ReviewStageEnum.OPERATOR_VERIFY.getCode())) {
                    ApproveRecordDTO approveRecord = convertRejectRecord2ApproveRecord(rejectRecord);
                    resultList.add(approveRecord);
                }
            }
        }

        return resultList;
    }

    /**
     * 所有的审核记录和打回记录及撤回的记录
     *
     * @param taskId
     * @param tbId
     * @return
     */
    private List<ApproveRecordDTO> getApproveRecordsAndRejectRecords(String taskId, String tbId) {
        // 如果用户是审核员或者复核员，则返回所有的审核记录和打回记录及撤回的记录
        List<ApproveRecordDTO> resultList = new ArrayList<>();

        List<TbtskApproveRecord> approveRecords = tbtskApproveRecordRepository.findApproveRecordOrderByTime(taskId, tbId);
        if (!GutilCollection.isEmpty(approveRecords)) {
            for (TbtskApproveRecord tbtskApproveRecord : approveRecords) {
                ApproveRecordDTO approveRecord = convertApproveRecord2ApproveRecordDTO(tbtskApproveRecord);
                resultList.add(approveRecord);
            }
        }

        List<TbtskRejectRecord> rejectRecords = tbtskRejectRecordRepository.findByTaskIdAndTbId(taskId, tbId);
        if (!GutilCollection.isEmpty(rejectRecords)) {
            for (TbtskRejectRecord rejectRecord : rejectRecords) {
                ApproveRecordDTO approveRecord = convertRejectRecord2ApproveRecord(rejectRecord);
                resultList.add(approveRecord);
            }
        }

        List<TbtskRevokeRecord> revokeRecords = tbtskRevokeRecordService.selectByTaskIdAndTbId(taskId, tbId);
        if (!GutilCollection.isEmpty(revokeRecords)) {
            for (TbtskRevokeRecord revokeRecord : revokeRecords) {
                ApproveRecordDTO approveRecord = convertRevokeRecord2ApproveRecord(revokeRecord);
                resultList.add(approveRecord);
            }
        }
        return resultList;
    }

    private ApproveRecordDTO convertApproveRecord2ApproveRecordDTO(TbtskApproveRecord approveRecord) {
        ApproveRecordDTO dto = new ApproveRecordDTO();
        dto.setStatus(approveRecord.getStatus());
        dto.setOption(approveRecord.getOption());
        dto.setApproveUserId(approveRecord.getApproveUserId());
        dto.setApproveUser(approveRecord.getApproveUser());
        dto.setApproveTime(approveRecord.getApproveTime());
        dto.setDescription(approveRecord.getDescription());
        dto.setId(approveRecord.getId());
        dto.setRemark(approveRecord.getRemark());
        dto.setTaskid(approveRecord.getTaskid());
        dto.setTbid(approveRecord.getTbid());
        dto.setStepname(approveRecord.getStepname());
        dto.setStepindex(approveRecord.getStepindex());
        dto.setNextstep(approveRecord.getNextstep());
        dto.setWflx(approveRecord.getWflx());
        dto.setType(1);
        return dto;
    }

    private ApproveRecordDTO convertRevokeRecord2ApproveRecord(TbtskRevokeRecord revokeRecord) {
        ApproveRecordDTO dto = new ApproveRecordDTO();
        dto.setStatus(1);
        dto.setOption(1);
        dto.setApproveUserId(revokeRecord.getUserId());
        dto.setApproveUser(revokeRecord.getUserName());
        dto.setApproveTime(revokeRecord.getRevokeTime());
        dto.setDescription("");
        dto.setId(revokeRecord.getId());
        dto.setRemark(revokeRecord.getRemark());
        dto.setTaskid(revokeRecord.getTaskId());
        dto.setTbid(revokeRecord.getTbId());
        dto.setStepname(revokeRecord.getStepName());
        dto.setStepindex(0);
        dto.setNextstep(1);
        dto.setType(3);
        return dto;
    }

    private ApproveRecordDTO convertRejectRecord2ApproveRecord(TbtskRejectRecord rejectRecord) {
        ApproveRecordDTO dto = new ApproveRecordDTO();
        dto.setStatus(1);
        dto.setOption(2);
        dto.setApproveUserId(rejectRecord.getUserId());
        dto.setApproveUser(rejectRecord.getUserName());
        dto.setApproveTime(rejectRecord.getRejectTime());
        dto.setDescription(rejectRecord.getDescription());
        dto.setId(rejectRecord.getId());
        dto.setRemark(rejectRecord.getRemark());
        dto.setTaskid(rejectRecord.getTaskid());
        dto.setTbid(rejectRecord.getTbid());
        dto.setStepname(rejectRecord.getStepName());
        dto.setStepindex(0);
        dto.setNextstep(1);
        dto.setType(2);
        return dto;
    }

    /**
     * 根据userid获取用户角色
     *
     * @param taskId
     * @param userId
     * @return 返回用户角色信息
     */
    public List<Integer> getUserRole(String taskId, Long userId) {
        GutilAssert.state(StringUtils.isNoneBlank(taskId), "taskId 参数不能为空.");
        List<Integer> result = new ArrayList<>();

        result = mConfigTaskReviewService.getUserRole(taskId, userId);

        return result;
    }

    /**
     * 检查用户是否有该图斑审核权限
     *
     * @return
     */
    public Map checkApprovePermission(String taskId, String tbId, String type, Long userId) {
        Map resultMap = new HashMap();
        resultMap.put("hasPermission", false);
        Integer rejectCount = 0;

        resultMap = mConfigTaskReviewService.checkAuditPermission(taskId, tbId, userId);

        return resultMap;
    }


    private Map getPermissionByFilter(String taskId, String tbId, String type, Long userId, Integer rejectCount) {
        Map resultMap = new HashMap();
        resultMap.put("hasPermission", false);
        List<FlowStep> flowSteps = findFlowSteps(taskId, FlowTypeEnum.AUDIT);
        if (flowSteps == null || flowSteps.size() == 0) {
            return resultMap;
        }
        Triplet triplet = getRegionCodeAndStatus(tbId, type);
        if (triplet.getValue0() == null || triplet.getValue1() == null || triplet.getValue2() == null) {
            return resultMap;
        }
        String dataRegionCode = triplet.getValue0().toString();
        Integer status = (Integer) triplet.getValue1();
        Integer stage = (Integer) triplet.getValue2();
        resultMap = mConfigTaskReviewService.validateFlowStage(taskId, tbId, userId, dataRegionCode, status, stage, rejectCount, resultMap, flowSteps);

        return resultMap;
    }

    /**
     * 获取行政区代码及状态
     *
     * @param tbId
     * @param type
     * @return
     */
    private Triplet getRegionCodeAndStatus(String tbId, String type) {
        String regionCode = "";
        Integer status = null;
        Integer stage = null;

        return new Triplet<String, Integer, Integer>(regionCode, status, stage);
    }

    /**
     * 提交审核记录
     */
    public TbtskApproveRecord submitApproveRecord(TbtskApproveRecord approveRecord, String type, Long userId) throws Exception {
        TbtskApproveRecord result = null;
        if (approveRecord == null) {
            return null;
        }

        if (StringUtils.isBlank(approveRecord.getTaskid())) {
            throw new RuntimeException("taskId不能为空");
        }

        result = mConfigTaskReviewService.submitApproveRecord(approveRecord, type, userId);

        return result;
    }

    public List<TbtskFlowDef> getAllFlow() {
        return this.tbtskFlowDefRepository.getAll();
    }

    /**
     * 打回
     *
     * @param taskId      任务id
     * @param tbId        图斑id
     * @param userId      打回人员id
     * @param remark      打回备注
     * @param description 打回描述
     * @param userName    打回人员
     * @param stepName
     * @return
     */
    public String reject(String taskId, String tbId, Long userId, String remark, String description, String userName, String stepName, String targetStepName) throws Exception {
        String result = "打回失败";

        result = mConfigTaskReviewService.reject(taskId, tbId, userId, remark, description, userName, stepName, result, targetStepName);

        return result;
    }

    public String rejectBatch(Integer type, String taskId, String tbIds, Long userId, String remark, String description,
                              String userName, String stepName) {
        String result = "打回成功";
        try {
            TskTaskBiz tskTaskBiz = tskTaskBizRepository.findById(taskId).orElse(null);
            if (tskTaskBiz.getIsApprove() == 0) {
                return "该任务没有审核复核流程";
            } else {
                TbtskRejectDef tbtskRejectDef = mTbtskRejectDefService.selectByTaskId(taskId);
                if (tbtskRejectDef.getRejectType() == 0) {
                    return "该任务无打回配置，不能打回";
                }
            }
            //将参数添加到任务记录中进行后台处理
            JSONObject params = new JSONObject();
            params.put("filterType", "checkFilter");
            params.put("tbIds", tbIds);
            params.put("taskId", taskId);
            params.put("type", type);
            params.put("description", description);
            params.put("remark", remark);
            params.put("userName", userName);
            params.put("stepName", stepName);
            params.put("userId", userId);
            params.put("result", result);
            addTaskRecord(params, userId, TASK_ID_LZGD.equalsIgnoreCase(taskId) ?
                            JobConstants.JOB_TYPE_LZGD_BATCH_REJECT : JobConstants.JOB_TYPE_CONFIG_TASK_REJECT_BATCH,
                    TASK_ID_LZGD.equalsIgnoreCase(taskId) ? "7" : taskId);
        } catch (Exception e) {
            result = "打回失败";
            e.printStackTrace();
        }
        return result;
    }

    /**
     * 国土调查云升级版本批量打回
     *
     * @param type
     * @param taskId
     * @param userId
     * @param remark
     * @param description
     * @param userName
     * @param stepName
     * @param parameter
     * @return
     * @throws Exception
     */
    public String rejectBatchByConditionFilter(Integer type, String taskId, Long userId, String remark, String
            description, String userName, String stepName, TaskQueryParameter parameter) {
        String result = "打回成功";
        try {
            TskTaskBiz tskTaskBiz = tskTaskBizRepository.findById(taskId).orElse(null);
            if (tskTaskBiz.getIsApprove() == 0) {
                return "该任务没有审核复核流程";
            } else {
                TbtskRejectDef tbtskRejectDef = mTbtskRejectDefService.selectByTaskId(taskId);
                if (tbtskRejectDef == null || tbtskRejectDef.getRejectType() == 0) {
                    return "该任务无打回配置，不能打回";
                }
            }
            //将参数添加到任务记录中进行后台处理
            JSONObject params = new JSONObject();
            params.put("filterType", "conditionFilter");
            params.put("userId", userId);
            params.put("taskQueryParameter", parameter);
            params.put("taskId", taskId);
            params.put("type", type);
            params.put("description", description);
            params.put("remark", remark);
            params.put("userName", userName);
            params.put("stepName", stepName);
            params.put("result", result);
            addTaskRecord(params, userId, JobConstants.JOB_TYPE_CONFIG_TASK_REJECT_BATCH, taskId);
        } catch (Exception e) {
            result = "打回异常";
            e.printStackTrace();
        }
        return result;
    }

    public String rejectBatchByFilter(Integer type, String taskId, Long userId, String remark, String description,
                                      String userName, String stepName, String xzqdm, String fwbh, Integer jslx, String xfzt, String tjzt,
                                      Date startTime, Date endTime, String tbzt, String xmhj, String shfh, String sfdh, String ywzp) throws Exception {
        String result = "打回成功";

        result = mConfigTaskReviewService.rejectBatchByFilter(type, taskId, userId, remark, description, userName, stepName,
                xzqdm, fwbh, jslx, xfzt, tjzt, startTime, endTime, tbzt, xmhj, shfh, sfdh, ywzp);

        return result;
    }


    private TbtskRejectRecord saveRejectRecordNew(String taskId, Long userId, String remark, String description, String
            userName, String stepName, String id, Integer reviewStage) {
        TbtskRejectRecord rejectRecord = new TbtskRejectRecord();
        rejectRecord.setTaskid(taskId);
        rejectRecord.setTbid(id);
        rejectRecord.setUserId(userId);
        rejectRecord.setRejectTime(new Date());
        rejectRecord.setRemark(remark);
        rejectRecord.setDescription(description);
        rejectRecord.setUserName(userName);
        rejectRecord.setSourceStage(reviewStage);
        rejectRecord.setTargetStage(ReviewStageEnum.OPERATOR_VERIFY.getCode());
        rejectRecord.setStepName(stepName);
        return rejectRecord;
    }


    private TbtskRejectRecord saveRejectRecord(String taskId, Long userId, String remark, String description,
                                               String userName, String stepName, String id, Integer sourceStage, Integer targetStage) {
        TbtskRejectRecord rejectRecord = new TbtskRejectRecord();
        rejectRecord.setTaskid(taskId);
        rejectRecord.setTbid(id);
        rejectRecord.setUserId(userId);
        rejectRecord.setRejectTime(new Date());
        rejectRecord.setRemark(remark);
        rejectRecord.setDescription(description);
        rejectRecord.setUserName(userName);
        rejectRecord.setSourceStage(sourceStage);
        rejectRecord.setTargetStage(targetStage);
        rejectRecord.setStepName(stepName);
        return tbtskRejectRecordRepository.save(rejectRecord);
    }

    /**
     * 平台任务打回发送消息给app
     *
     * @param ids
     * @param userId
     * @param submitUserIds
     * @param description
     * @param remark
     * @param id2RejectIdArray
     * @param tableInfo
     * @param taskId
     */
    public void sendRejectMessageToAPPByPlatform(List<String> ids, Long userId, List<String> submitUserIds, String
            description, String remark ,JSONArray id2RejectIdArray, TbtskObjectinfo tableInfo, String
                                                         taskId) {
        String content = String.format("【任务图斑打回通知】。任务名称：" + tableInfo.getfTablealias() + "；打回了%s个图斑", ids.size());
        if (StringUtils.isNotBlank(description)) {
            content += "  原因：" + description + "";
        }
        if (StringUtils.isNotBlank(remark)) {
            content += "  备注：" + remark;
        }
        // 任务通知
        TaskNotice taskNotice = new TaskNotice();
        taskNotice.setData(StringUtils.join(ids.toArray(), ','));
        taskNotice.setContent(content);
        taskNotice.setId(UUID.randomUUID().toString());
        taskNotice.setState(1);
        taskNotice.setSendUser(null);
        taskNotice.setTitle("任务图斑打回通知");
        taskNotice.setSendTime(new Date());
        taskNotice.setType(2); // 任务函
        taskNotice.setAction(19); // app自动接收消息
        taskNotice.setRegion("");
        taskNotice.setRegion1("");
        taskNotice.setMsgtype("0");
        taskNotice.setBizId(taskId);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("count", ids.size());
        if (id2RejectIdArray != null) {
            jsonObject.put("rejectIds", id2RejectIdArray);
        }
        taskNotice.setAddition(jsonObject.toString());
        //保存任务通知
        taskNotice = mTaskNoticeService.save(taskNotice);
        List<String> alias = new ArrayList<String>();
        // 下发通知到个人
        for (int i = 0; i < submitUserIds.size(); i++) {
            String userid = submitUserIds.get(i);
            TaskNoticeUser taskNoticeUser = new TaskNoticeUser();
            taskNoticeUser.setId(UUID.randomUUID().toString());
            taskNoticeUser.setData(StringUtils.join(ids.toArray(), ','));
            taskNoticeUser.setState(0);
            taskNoticeUser.setCreatetime(new Date());
            taskNoticeUser.setNoticeId(taskNotice.getId());
            taskNoticeUser.setUserId(userid);
            mTaskNoticeService.save(taskNoticeUser);
            alias.add(userid);
        }
        Map<String, Object> message = new HashMap<String, Object>();
        message.put("type", 2); // 2表明是任务消息
        message.put("bizid", taskId);
        try {
            // 推送消息
            MixPushServer.sendNotifyToAlias(alias, taskNotice.getTitle(), taskNotice.getContent(), JSON.toJSONString(message));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    /**
     * 查询最新的审核记录或符合记录
     *
     * @param taskId
     * @param tbId
     * @param userId
     * @param type   0：审核记录；1：复核记录;2：审核记录+复核记录
     * @return
     */
    public List<TbtskApproveRecord> queryLatestApproveRecord(String taskId, String tbId, Long userId, Integer type) {
        List<TbtskApproveRecord> resultList = null;
        List<TbtskApproveRecord> approveRecordList = tbtskApproveRecordRepository.findApproveRecordOrderByTime(taskId, tbId);
        if (!GutilCollection.isEmpty(approveRecordList)) {
            if (type != null) {
                if (type.equals(0) || type.equals(1)) {
                    TbtskApproveRecord latestRecord = getTbtskApproveRecord(type, approveRecordList, userId);
                    if (latestRecord != null) {
                        if (resultList == null) {
                            resultList = new ArrayList<>();
                        }
                        resultList.add(latestRecord);
                    }
                    return resultList;
                } else if (type.equals(2)) {
                    // 审核记录+复核记录
                    TbtskApproveRecord latestRecord = getTbtskApproveRecord(0, approveRecordList, userId);
                    if (latestRecord != null) {
                        if (resultList == null) {
                            resultList = new ArrayList<>();
                        }
                        resultList.add(latestRecord);
                    }
                    TbtskApproveRecord latestRecord2 = getTbtskApproveRecord(1, approveRecordList, userId);
                    if (latestRecord2 != null) {
                        if (resultList == null) {
                            resultList = new ArrayList<>();
                        }
                        resultList.add(latestRecord2);
                    }
                    return resultList;
                }
            } else {
                return null;
            }
        }
        return resultList;
    }

    /**
     * 获取审核记录或复核记录
     *
     * @param type              0：审核记录；1：复核记录
     * @param approveRecordList
     * @param userId
     * @return
     */
    private TbtskApproveRecord getTbtskApproveRecord(Integer type, List<TbtskApproveRecord> approveRecordList, Long userId) {
        if (!GutilCollection.isEmpty(approveRecordList)) {
            for (TbtskApproveRecord approveRecord : approveRecordList) {
                if (type.equals(NumberConst.ZERO)) {
                    if (approveRecord.getStepname().contains("审核")
                            && approveRecord.getApproveUserId() != null
                            && approveRecord.getApproveUserId().equals(userId)) {
                        return approveRecord;
                    }
                } else if (type.equals(NumberConst.ONE)) {
                    if (approveRecord.getStepname().contains("复核")
                            && approveRecord.getApproveUserId() != null
                            && approveRecord.getApproveUserId().equals(userId)) {
                        return approveRecord;
                    }
                }
            }
        }

        return null;
    }

    /**
     * 批量审核/复核
     *
     * @param taskId      任务id
     * @param tbId        图斑列表，多个图斑id之间用英文逗号隔开
     * @param option      审核意见 1：通过；2不通过
     * @param description 审核描述
     * @param remark      备注
     * @param userId      审核用户id
     * @param approveUser 审核用户名
     * @param type        类型 0：审核；1：复核
     * @return
     */
    public Object submitApproveRecordBatch(String taskId, String tbId, Integer option, String description, String remark, Long userId, String approveUser, Integer type) {

        String result = "批量审核/复核成功";

        result = mConfigTaskReviewService.submitApproveRecordBatch(taskId, tbId, option, description,
                remark, userId, approveUser, type);

        return result;
    }

    /**
     * @param taskId      业务id
     * @param option      1：通过；2：不通过
     * @param description 描述
     * @param remark      备注
     * @param userId      审核人id
     * @param approveUser 审核人员名称
     * @param type        0：审核；1:复核
     * @param xzqdm       政区代码
     * @param fwbh        房屋编号
     * @param jslx        建设类型
     * @param xfzt        下发状态
     * @param tjzt        提交状态
     * @param startTime   起始提交时间
     * @param endTime     结束提交时间
     * @param tbzt        提报状态
     * @param xmhj        项目环节
     * @param shfh        审核复核
     * @param sfdh        是否打回
     * @param ywzp        有无照片
     * @return
     * @throws Exception
     */
    public Object submitApproveRecordBatchByFilter(String taskId, Integer option, String description, String remark, Long userId,
                                                   String approveUser, Integer type, String xzqdm, String fwbh, Integer jslx,
                                                   String xfzt, String tjzt, Date startTime, Date endTime, String tbzt, String xmhj,
                                                   String shfh, String sfdh, String ywzp) throws Exception {
        String result = "批量审核/复核成功";

        result = mConfigTaskReviewService.submitApproveRecordBatchByFilter(taskId, option, description, remark, userId, approveUser,
                type, xzqdm, fwbh, jslx, xfzt, tjzt, startTime, endTime, tbzt, xmhj, shfh, sfdh, ywzp);


        return result;
    }

    /**
     * 批量审核复核
     *
     * @param taskId
     * @param option
     * @param description
     * @param remark
     * @param userId
     * @param approveUser
     * @param type
     * @param xzqdm
     * @param taskQueryParameter
     * @return
     */
    public Object submitApproveRecordBatchByConditionFilter(String taskId, Integer option, String description, String remark, Long userId,
                                                            String approveUser, Integer type, String xzqdm, TaskQueryParameter taskQueryParameter) {
        String result = "批量审核/复核成功";
        try {
            TskTaskBiz tskTaskBiz = tskTaskBizRepository.findById(taskId).orElse(null);
            if (tskTaskBiz.getIsApprove() == 0) {
                return "该任务没有审核复核流程";
            }
            //将参数添加到任务记录中进行后台处理
            JSONObject params = new JSONObject();
            params.put("filterType", "conditionFilter");
            params.put("xzqdm", xzqdm);
            params.put("userId", userId);
            params.put("taskQueryParameter", taskQueryParameter);
            params.put("taskId", taskId);
            params.put("option", option);
            params.put("description", description);
            params.put("remark", remark);
            params.put("approveUser", approveUser);
            params.put("type", type);
            addTaskRecord(params, userId, JobConstants.JOB_TYPE_CONFIG_TASK_AUDIT_BATCH, taskId);
        } catch (Exception e) {
            result = "批量审核/复核失败";
            e.printStackTrace();
        }
        return result;
    }


    /**
     * 创建流程
     *
     * @param taskId       任务id
     * @param flowName     流程名称
     * @param nodes        流程节点
     * @param flowTypeEnum 流程类型
     * @param onlyAudit    是否是仅审核，true：仅审核， fasle：审核+复核
     * @param rejectType   打回类型 0：不打回，1：打回到作业员，2：逐级打回3：自定义打回阶段;
     * @param canRevoke    是否支持打回 0：不支持打回，1：支持打回
     * @return
     */
    @Transactional
    public Pair<Boolean, String> createFlowDefine(String taskId, String flowName, String nodes, FlowTypeEnum flowTypeEnum,
                                                  boolean onlyAudit, String rejectType, Integer canRevoke) throws Exception {
        GutilAssert.state(StringUtils.isNotBlank(taskId), "parameter [taskId] can not be null or empty.");
        GutilAssert.state(StringUtils.isNotBlank(flowName), "parameter [flowName] can not be null or empty.");
        GutilAssert.state(StringUtils.isNotBlank(nodes), "parameter [nodes] can not be null or empty.");
        String[] nodeArray = nodes.split(",");
        if (ArrayUtils.isEmpty(nodeArray)) {
            throw new RuntimeException("流程节点不能为空");
        }

        List<TbtskFlowDef> tbtskFlowDefs = tbtskFlowDefRepository.findTbtskFlowByTaskId(taskId, flowTypeEnum.getCode());
        if (!GutilCollection.isEmpty(tbtskFlowDefs)) {
            throw new RuntimeException("此任务已经创建过审核流程，不能在重复定义流程");
        }

        Object[] sortedNodes = Arrays.stream(nodeArray).sorted().toArray();
        JSONArray flowStepsArray = getFlowSteps(onlyAudit, sortedNodes);

        TbtskFlowDef flowDef = new TbtskFlowDef();
        flowDef.setId(UUID.randomUUID().toString());
        flowDef.setName(flowName);
        flowDef.setFlowtype(flowTypeEnum.getCode());
        flowDef.setStepcount(onlyAudit ? nodeArray.length : nodeArray.length * 2);
        flowDef.setSteps(flowStepsArray.toString());
        flowDef.setContainsReview(onlyAudit ? 0 : 1);
        flowDef = tbtskFlowDefRepository.save(flowDef);

        TbtskTaskBizFlow bizFlow = new TbtskTaskBizFlow();
        bizFlow.setId(UUID.randomUUID().toString());
        bizFlow.setFlowId(flowDef.getId());
        bizFlow.setTaskId(taskId);
        tbtskTaskBizFlowService.insert(bizFlow);

        TbtskRejectDef rejectDef = new TbtskRejectDef();
        rejectDef.setId(UUID.randomUUID().toString());
        rejectDef.setTaskid(taskId);
        rejectDef.setRejectType(Integer.parseInt(rejectType));
        rejectDef.setCustomSetting("");
        tbtskRejectDefMapper.insert(rejectDef);

        mTskTaskBizService.updateCanRevoke(taskId, canRevoke);

        JSONObject resultJson = new JSONObject();
        resultJson.put("id", flowDef.getId());
        resultJson.put("name", flowDef.getName());
        return Pair.of(true, resultJson.toJSONString());
    }

    private JSONArray getFlowSteps(boolean onlyAudit, Object[] sortedNodes) throws Exception {
        JSONArray nodesJsonArray = new JSONArray();
        JSONObject auditNodeJsonObj = null;
        int auditNodeIndex = 0;
        if (onlyAudit) {
            for (Object sortedNode : sortedNodes) {
                auditNodeJsonObj = getAuditNodeJsonObj(sortedNodes, auditNodeIndex, sortedNode,
                        auditNodeIndex == 0, auditNodeIndex == sortedNodes.length - 1, true, false);
                auditNodeIndex++;
                nodesJsonArray.add(auditNodeJsonObj);
            }
        } else {
            JSONObject reviewNodeJsonObj = null;
            int reviewNodeIndex = 1;

            for (Object currentNode : sortedNodes) {
                auditNodeJsonObj = getAuditNodeJsonObj(sortedNodes, auditNodeIndex, currentNode,
                        auditNodeIndex == 0, auditNodeIndex == sortedNodes.length * 2 - 1, true, true);
                nodesJsonArray.add(auditNodeJsonObj);

                reviewNodeJsonObj = getReviewNodeJsonObj(sortedNodes, reviewNodeIndex, currentNode,
                        auditNodeIndex == sortedNodes.length * 2 - 2, false);
                nodesJsonArray.add(reviewNodeJsonObj);

                auditNodeIndex = auditNodeIndex + 2;
                reviewNodeIndex = reviewNodeIndex + 2;

            }
        }
        return nodesJsonArray;
    }

    private JSONObject getAuditNodeJsonObj(Object[] sortedNodes, int auditNodeIndex, Object sortedNode,
                                           boolean isFirstStep, boolean isLastStep, boolean isAudit, boolean containsReview) throws Exception {
        JSONObject auditNodeJsonObj;
        auditNodeJsonObj = new JSONObject();
        auditNodeJsonObj.put("index", auditNodeIndex);
        auditNodeJsonObj.put("name", getNodeAuditName(sortedNode));
        auditNodeJsonObj.put("is_start", isFirstStep);
        auditNodeJsonObj.put("is_end", isLastStep);
        auditNodeJsonObj.put("pre_status", getPreStatus(isAudit));
        if (!containsReview) {
            auditNodeJsonObj.put("post_status", String.valueOf(WAITING_VERIFY.getCode()));
        } else {
            auditNodeJsonObj.put("post_status", String.valueOf(isAudit ? WAITING_REVIEW.getCode() : WAITING_VERIFY.getCode()));
        }
        auditNodeJsonObj.put("pre_stages", getAuditPreStage(sortedNodes, sortedNode, isFirstStep, isAudit));
        auditNodeJsonObj.put("post_stage", getPostStage(sortedNode, isLastStep, containsReview, isAudit));
        auditNodeJsonObj.put("filter", getNodeFilter(true));
        return auditNodeJsonObj;
    }

    private JSONObject getReviewNodeJsonObj(Object[] sortedNodes, int reviewNodeIndex, Object currentNode,
                                            boolean isLastStep, boolean isAuditNode) throws Exception {
        JSONObject reviewNodeJsonObj;
        reviewNodeJsonObj = new JSONObject();
        reviewNodeJsonObj.put("index", reviewNodeIndex);
        reviewNodeJsonObj.put("name", getNodeReviewName(currentNode));
        reviewNodeJsonObj.put("is_start", false);
        reviewNodeJsonObj.put("is_end", isLastStep);
        reviewNodeJsonObj.put("pre_status", WAITING_REVIEW.getCode() + "," + REVIEW_NOT_PASS.getCode());
        reviewNodeJsonObj.put("post_status", String.valueOf(WAITING_VERIFY.getCode()));
        reviewNodeJsonObj.put("pre_stages", getReviewPreStage(sortedNodes, currentNode, isAuditNode));
        reviewNodeJsonObj.put("post_stage", getPostStage(currentNode, isLastStep, true, isAuditNode));
        reviewNodeJsonObj.put("filter", getNodeFilter(false));
        return reviewNodeJsonObj;
    }

    private String getNodeAuditName(Object currentNode) {
        switch (currentNode.toString()) {
            case "1":
                return "村级审核";
            case "2":
                return "乡镇审核";
            case "3":
                return "区县审核";
            case "4":
                return "市级审核";
            case "5":
                return "省级审核";
            case "6":
                return "国家审核";
            default:
                return "";
        }
    }

    private String getNodeReviewName(Object currentNode) {
        switch (currentNode.toString()) {
            case "1":
                return "村级复核";
            case "2":
                return "乡镇复核";
            case "3":
                return "区县复核";
            case "4":
                return "市级复核";
            case "5":
                return "省级复核";
            case "6":
                return "国家复核";
            default:
                return "";
        }
    }

    private String getPreStatus(boolean isAudit) {
        String result = "";
        if (isAudit) {
            result = WAITING_VERIFY.getCode() + "," + VERIFY_NOT_PASS.getCode();
        } else {
            result = WAITING_REVIEW.getCode() + "," + REVIEW_NOT_PASS.getCode();
        }
        return result;
    }

    private String getNodeStage(Object currentNode) {
        switch (currentNode.toString()) {
            case "1":
                return String.valueOf(ReviewStageEnum.VILLAGE_VERIFY.getCode());
            case "2":
                return String.valueOf(ReviewStageEnum.TOWN_VERIFY.getCode());
            case "3":
                return String.valueOf(ReviewStageEnum.COUNTY_VERIFY.getCode());
            case "4":
                return String.valueOf(ReviewStageEnum.CITY_VERIFY.getCode());
            case "5":
                return String.valueOf(ReviewStageEnum.PROVINCE_VERIFY.getCode());
            case "6":
                return String.valueOf(ReviewStageEnum.COUNTRY_VERIFY.getCode());
            default:
                return "";
        }
    }

    private String getAuditPreStage(Object[] sortedNodes, Object currentNode, boolean currentIsFirstStep,
                                    boolean isOnlyAudit) throws Exception {
        String result = "";
        if (currentIsFirstStep) {
            result = ReviewStageEnum.OPERATOR_VERIFY.getCode() + "," + getNodeStage(currentNode);
        } else {
            int index = -1;
            Object preNode = "";
            if (ArrayUtils.isNotEmpty(sortedNodes)) {
                for (int i = 0; i < sortedNodes.length; i++) {
                    if (sortedNodes[i].equals(currentNode)) {
                        index = i;
                        break;
                    }
                }
                if (index == -1) {
                    throw new RuntimeException("当前节点不在节点数据集合中。");
                }
                if (isOnlyAudit) {
                    preNode = index > 0 ? sortedNodes[index - 1] : sortedNodes[0];
                    result = getNodeStage(preNode) + "," + getNodeStage(currentNode);
                } else {
                    if (index > 0) {
                        //preNode = sortedNodes[index - 1];
                        result = getNodeStage(currentNode);
                    } else {
                        preNode = sortedNodes[0];
                        result = getNodeStage(preNode) + "," + getNodeStage(currentNode);
                    }
                }
            } else {
                throw new RuntimeException("节点数据集合不能为空。");
            }
        }

        return result;
    }

    /**
     * 获取后阶段
     *
     * @param currentNode      当前节点
     * @param isLastNode       是否是最后一个节点
     * @param isContainsReview 是否包含复核模式
     * @param isAuditNode      是否是审核节点
     * @return
     */
    private String getPostStage(Object currentNode, boolean isLastNode, boolean isContainsReview, boolean isAuditNode) {
        String result = "";
        if (isLastNode) {
            result = String.valueOf(ReviewStageEnum.OVER_VERIFY.getCode());//最后一步
        } else {
            if (!isContainsReview) {
                result = String.valueOf(AuditStageArray[Integer.parseInt(currentNode.toString())].getCode());
            } else {
                if (isAuditNode) {
                    result = String.valueOf(AuditReviewStageArray[Integer.parseInt(currentNode.toString()) * 2 - 1].getCode());
                } else {
                    result = String.valueOf(AuditReviewStageArray[Integer.parseInt(currentNode.toString()) * 2].getCode());
                }
            }
        }
        return result;
    }

    private String getReviewPreStage(Object[] sortedNodes, Object currentNode, boolean isAuditNode) throws Exception {
        String result = "";

        int index = -1;
        Object preNode = "";
        if (ArrayUtils.isNotEmpty(sortedNodes)) {
            for (int i = 0; i < sortedNodes.length; i++) {
                if (sortedNodes[i].equals(currentNode)) {
                    index = i;
                    break;
                }
            }
            if (index == -1) {
                throw new RuntimeException("当前节点不在节点数据集合中。");
            }
            if (isAuditNode) {
                preNode = index > 0 ? sortedNodes[index - 1] : sortedNodes[0];
                result = getNodeStage(preNode);
            } else {
                if (index > 0) {
                    //preNode = sortedNodes[index - 1] ;
                    result = getNodeStage(currentNode);
                } else {
                    preNode = sortedNodes[0];
                    result = getNodeStage(preNode);
                }

            }
        } else {
            throw new RuntimeException("节点数据集合不能为空。");
        }
        return result;
    }

    private String getNodeFilter(boolean isAudit) {
        StringBuilder sb = new StringBuilder();
        sb.append(" LEFT JOIN tbsys_user_biz2 b on u.f_userid = b.f_userid ");
        if (isAudit) {
            sb.append(" LEFT JOIN tbtsk_user_audit_area a on CAST (u.f_userid AS text) = a.f_userid ");
        } else {
            sb.append(" LEFT JOIN tbtsk_user_review_area a on CAST (u.f_userid AS text) = a.f_userid ");
        }
        sb.append(" WHERE b.f_role = ").append(isAudit ? 2 : 4).append(" ");
        sb.append(" AND b.f_bizid = '%TaskId%' ");
        sb.append(" AND a.f_taskid = '%TaskId%' AND a.f_regioncode = '%DataRegionCode%';");
        return sb.toString();
    }

    /**
     * 更新流程
     *
     * @param flowId       任务id
     * @param flowName     流程名称
     * @param nodes        流程节点
     * @param flowTypeEnum 流程类型
     * @param rejectType   打回类型 0：不打回，1：打回到作业员，2：逐级打回3：自定义打回阶段;
     * @param canRevoke    是否支持打回 0：不支持打回，1：支持打回
     * @return
     */
    public Pair<Boolean, String> updateFlowDefine(String flowId, String flowName, String nodes, FlowTypeEnum flowTypeEnum, boolean onlyAudit, String rejectType, Integer canRevoke) throws Exception {
        GutilAssert.state(StringUtils.isNotBlank(flowId), "parameter [flowId] can not be null or empty.");
        GutilAssert.state(StringUtils.isNotBlank(flowName), "parameter [flowName] can not be null or empty.");
        GutilAssert.state(StringUtils.isNotBlank(nodes), "parameter [nodes] can not be null or empty.");
        String[] nodeArray = nodes.split(",");
        if (ArrayUtils.isEmpty(nodeArray)) {
            throw new RuntimeException("流程节点不能为空");
        }
        TbtskFlowDef flowDef = tbtskFlowDefRepository.findById(flowId).orElse(null);
        if (flowDef == null) {
            return Pair.of(false, "不存在Id为[" + flowId + "]的流程");
        }
        if (flowTypeEnum == FlowTypeEnum.AUDIT) {
            if (flowDef.getFlowtype() != null && flowDef.getFlowtype().intValue() == flowTypeEnum.getCode()) {
                boolean isUsing = false;
                List<TbtskTaskBiz> tskTaskBizs = flowDef.getTskTaskBizs();
                TbtskTaskBiz taskBiz = null;
                if (!GutilCollection.isEmpty(tskTaskBizs)) {
                    taskBiz = tskTaskBizs.get(0);
                    //验证是否已经存在审核记录，可以修改流程定义
                    for (TbtskTaskBiz biz : tskTaskBizs) {
                        TbtskApproveRecord approveRecord = tbtskApproveRecordRepository.findOneByTaskId(biz.getId());
                        if (approveRecord != null) {
                            isUsing = true;
                            break;
                        }
                    }
                }

                if (isUsing) {
                    return Pair.of(false, "此流程存在审核记录，不允许修改");
                } else {

                    Object[] sortedNodes = Arrays.stream(nodeArray).sorted().toArray();
                    JSONArray flowStepsArray = getFlowSteps(onlyAudit, sortedNodes);

                    flowDef.setName(flowName);
                    flowDef.setStepcount(onlyAudit ? nodeArray.length : nodeArray.length * 2);
                    flowDef.setSteps(flowStepsArray.toString());
                    flowDef.setContainsReview(onlyAudit ? 0 : 1);
                    tbtskFlowDefRepository.save(flowDef);

                    if (taskBiz != null) {
                        List<TbtskRejectDef> rejectDefList = tbtskRejectDefMapper.queryByTaskid(taskBiz.getId());
                        if (!GutilCollection.isEmpty(rejectDefList)) {
                            TbtskRejectDef rejectDef = rejectDefList.get(0);
                            rejectDef.setRejectType(Integer.parseInt(rejectType));
                            rejectDef.setCustomSetting("");
                            tbtskRejectDefMapper.updateByPrimaryKeySelective(rejectDef);
                        }

                        mTskTaskBizService.updateCanRevoke(taskBiz.getId(), canRevoke);
                    }

                    JSONObject resultJson = new JSONObject();
                    resultJson.put("id", flowDef.getId());
                    resultJson.put("name", flowDef.getName());
                    return Pair.of(true, resultJson.toJSONString());

                }
            } else {
                return Pair.of(false, "不存在Id为[" + flowId + "]的审核流程");
            }
        } else {
            return Pair.of(false, "下发流程修改暂未实现");
        }
    }

    /**
     * 删除流程并删除流程与任务的关联记录
     *
     * @param flowId       任务id
     * @param flowTypeEnum 流程类型
     * @param userId       用户id
     * @return
     */
    public Pair<Boolean, String> deleteFlowDefine(String flowId, FlowTypeEnum flowTypeEnum, Long userId) {
        GutilAssert.state(StringUtils.isNotBlank(flowId), "parameter [flowId] can not be null or empty.");

        TbtskFlowDef flowDef = tbtskFlowDefRepository.findById(flowId).orElse(null);
        if (flowDef == null) {
            return Pair.of(false, "不存在Id为[" + flowId + "]的流程");
        }
        if (flowTypeEnum == FlowTypeEnum.AUDIT) {
            if (flowDef.getFlowtype() != null && flowDef.getFlowtype().intValue() == flowTypeEnum.getCode()) {
                boolean isUsing = false;
                List<TbtskTaskBiz> tskTaskBizs = flowDef.getTskTaskBizs();
                for (TbtskTaskBiz taskBiz : tskTaskBizs) {
                    TbtskApproveRecord approveRecord = tbtskApproveRecordRepository.findOneByTaskId(taskBiz.getId());
                    if (approveRecord != null) {
                        isUsing = true;
                        break;
                    }
                }

                if (isUsing) {
                    return Pair.of(false, "此流程存在审核记录，不能删除");
                } else {
                    tbtskFlowDefRepository.deleteById(flowId);
                    tbtskTaskBizFlowService.deleteByFlowId(flowId);
                }
            } else {
                return Pair.of(false, "不存在Id为[" + flowId + "]的审核流程");
            }
        } else {
            // TODO:检查下发流程是否被使用
            tbtskFlowDefRepository.deleteById(flowId);
            tbtskTaskBizFlowService.deleteByFlowId(flowId);
        }
        return Pair.of(true, "删除流程成功");
    }

    /**
     * 查询流程
     *
     * @param taskId       任务id
     * @param flowTypeEnum 流程类型
     * @param userId       用户id
     * @return 一个任务有多个审核流程时，返回第一个审核流程
     */
    public Pair<Boolean, Object> findOneFlowDefine(String taskId, FlowTypeEnum flowTypeEnum, Long userId) {
        GutilAssert.state(StringUtils.isNotBlank(taskId), "parameter [taskId] can not be null or empty.");
        GutilAssert.state(flowTypeEnum != FlowTypeEnum.UNDEFINED, "parameter [flowTypeEnum] undefined.");

        List<TbtskFlowDef> flowDefs = tbtskFlowDefRepository.findTbtskFlowByTaskId(taskId, new Integer(flowTypeEnum.getCode()));
        if (!GutilCollection.isEmpty(flowDefs)) {
            return Pair.of(true, flowDefs.get(0));
        } else {
            return Pair.of(false, "未查询到流程");
        }
    }

    /**
     * 查询流程
     *
     * @param flowId       流程id
     * @param flowTypeEnum 流程类型
     * @param userId       用户id
     */
    public Pair<Boolean, Object> findOneFlowDefineById(String flowId, FlowTypeEnum flowTypeEnum, Long userId) {
        GutilAssert.state(StringUtils.isNotBlank(flowId), "parameter [taskId] can not be null or empty.");
        GutilAssert.state(flowTypeEnum != FlowTypeEnum.UNDEFINED, "parameter [flowTypeEnum] undefined.");

        TbtskFlowDef tbtskFlowDef = tbtskFlowDefRepository.findById(flowId).orElse(null);
        if (tbtskFlowDef != null) {
            return Pair.of(true, tbtskFlowDef);
        } else {
            return Pair.of(false, "未查询到流程");
        }
    }

    /**
     * 查询配置任务数据
     *
     * @param queryParameter
     * @return
     */
    public List<Map> getConfigTaskDataList(TaskQueryParameter queryParameter) {
        List<Map> dataList = new ArrayList<>();
        try {
            TskTaskBiz tskTaskBiz = tskTaskBizRepository.findById(queryParameter.getTaskId()).orElse(null);
            if (null == tskTaskBiz) {
                throw new RuntimeException("提报失败，业务不存在或已被删除");
            }
            TbtskObjectinfo tbtskObjectinfo = tbtskObjectinfoRepository.getObjectByTableId(tskTaskBiz.getTableId());
            if (null == tbtskObjectinfo) {
                throw new RuntimeException("提报失败，业务数据表不存在或已被删除");
            }

            Pair<String, String> queryParamPair = mTskTaskBizService.parseQueryParameter(queryParameter);
            String tableName = queryParamPair.getLeft();
            String where = queryParamPair.getRight();

            List<String> fieldNameList = getAuditFieldNameCollection();

            fieldNameList.add("f_tbbh");
            // 必有字段集合
            List<TbtskFields> mustFields = tbtskFieldsRepository.queryNotNullFieldsByTableId(tbtskObjectinfo.getfId());
            if (mustFields != null && mustFields.size() > 0) {
                mustFields.forEach(a -> fieldNameList.add(a.getfFieldname()));
            }
            dataList = mDataBizService.queryAllData(tableName, fieldNameList, where);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }
        return dataList;
    }


    /**
     * 按条件下发数据获取数据
     *
     * @param queryParameter
     * @return
     */
    public List<Map> getConfigTaskDataListNew(TaskQueryParameter queryParameter) {
        List<Map> dataList = new ArrayList<>();
        try {
            TskTaskBiz tskTaskBiz = tskTaskBizRepository.findById(queryParameter.getTaskId()).orElse(null);
            if (null == tskTaskBiz) {
                throw new RuntimeException("提报失败，业务不存在或已被删除");
            }
            TbtskObjectinfo tbtskObjectinfo = tbtskObjectinfoRepository.getObjectByTableId(tskTaskBiz.getTableId());
            if (null == tbtskObjectinfo) {
                throw new RuntimeException("提报失败，业务数据表不存在或已被删除");
            }

            Pair<String, String> queryParamPair = mTskTaskBizService.parseQueryParameter(queryParameter);
            String tableName = queryParamPair.getLeft();
            String where = queryParamPair.getRight();

            //查找全部字段
            List<TbtskFields> fields = tbtskFieldsRepository.getTbtskFieldsByTableid(tskTaskBiz.getTableId());
            List<String> fieldNameList = new ArrayList<>();
            fields.forEach(a -> fieldNameList.add(a.getfFieldname()));
           /* // 必有字段集合
            List<TbtskFields> mustFields = tbtskFieldsRepository.getTbtskMustFieldsByTableid(tbtskObjectinfo.getfId(), 1);
            if (mustFields != null && mustFields.size() > 0) {
                mustFields.forEach(a -> fieldNameList.add(a.getfFieldname()));
            }*/
            dataList = mDataBizService.queryAllData(tableName, fieldNameList, where);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }
        return dataList;
    }

    /**
     * 作业员批量提报图斑(配置任务)
     *
     * @param taskId
     * @param dataList
     * @param userid
     * @return
     */
    public String operatorSubmitReportBatch(String taskId, List<Map> dataList, Long userid) {
        String result = "";
        int successNum = 0;
        int failNum = 0;
        if (!GutilCollection.isEmpty(dataList)) {
            String msg = "";
            StringBuilder sb = new StringBuilder();
            List<TbtskSubmitReportRecord> tbtskSubmitReportRecords = new ArrayList<>();
            List<Map<String, Object>> resultData = new ArrayList<>();
            String id = "";
            Integer status = null;
            String xzqdm = "";
            Integer rejectCount = 0;
            Integer rejectStatus = null;
            TskTaskBiz taskBiz = mTskTaskBizService.findByTaskId(taskId);
            TbtskObjectinfo tableInfo = mTbtskObjectinfoService.getObjectbyID(taskBiz.getTableId());
            for (Map data : dataList) {
                if (data != null) {
                    id = MapUtils.getString(data, "f_id", "");
                    status = MapUtils.getInteger(data, "f_status", null);
                    xzqdm = MapUtils.getString(data, "f_xzqdmsys", "");
                    rejectCount = MapUtils.getInteger(data, "f_reject_count", 0);
                    rejectStatus = MapUtils.getInteger(data, "f_reject_status", null);

                    if (status != null) {
                        if ((status >= TbStatusEnum.SUBMIT.getCode()
                                && status < TbStatusEnum.WAITING_VERIFY.getCode())
                                || status == TbStatusEnum.INIT.getCode()) {
                            Triplet checkResult = mConfigTaskReviewService.checkDataBeforeSubmit(data, tableInfo, taskId);
                            if ((Boolean) checkResult.getValue0()) {
                                ReviewStageEnum reviewStage = getFirstStageOfFlow(taskId);
                                // 更新为提报状态并将打回状态设置为未打回
                                Map<String, Object> updateMap = new HashMap<>();
                                updateMap.put("f_status", TbStatusEnum.WAITING_VERIFY.getCode());
                                updateMap.put("f_reject_status", 0);
                                updateMap.put("f_review_stage", reviewStage.getCode());
                                updateMap.put("f_updatetime", System.currentTimeMillis());
                                mDataBizService.updateData(tableInfo.getfTablename(), updateMap, "f_id='" + id + "'");

                                msg = "提报成功";
                                successNum++;
                                // 保存提报记录表
                                tbtskSubmitReportRecords.add(saveSubmitReportRecord(taskId, id, xzqdm, rejectCount, userid));
                                if (tbtskSubmitReportRecords.size() >= BATCH_COMMIT_COUNT) {
                                    //保存提报记录
                                    tbtskSubmitReportRecordRepository.saveAll(tbtskSubmitReportRecords);
                                    tbtskSubmitReportRecords.clear();
                                }
                            } else {
                                String error = (String) checkResult.getValue2();
                                if (StringUtils.isNotBlank(error)) {
                                    msg = "提报失败:" + error;
                                } else {
                                    msg = "提报失败";
                                }
                            }
                        } else if (status < TbStatusEnum.SUBMIT.getCode()) {
                            msg = "提报失败，未提交的图斑不支持提报";
                        } else if (status >= TbStatusEnum.WAITING_VERIFY.getCode()) {
                            msg = "提报失败，图斑已提报，不能重复提报";
                        }
                    }
                } else {
                    msg = "提报失败，图斑不存在";
                }
                if (StringUtils.isNotBlank(msg) && msg.startsWith("提报失败")) {
                    sb.append("图斑id：").append(id).append(" ").append(msg);
                    failNum++;
                }
                // 唯一值字段集合
                List<TbtskFields> uniqueFields = tbtskFieldsRepository.getTbtskUniqueFieldsByTableid(tableInfo.getfId(), 1);
                //添加数据导出提报结果
                Map<String, Object> map = new HashMap<>();
                map.put("fwbh", uniqueFields.size() > 0 ? data.get(uniqueFields.get(0).getfFieldname()).toString() : id);
                map.put("uniqueFieldName", uniqueFields.size() > 0 ? uniqueFields.get(0).getfAlias() : "");
                map.put("result", msg);
                resultData.add(map);
            }
            if (!tbtskSubmitReportRecords.isEmpty()) {
                //保存提报记录
                tbtskSubmitReportRecordRepository.saveAll(tbtskSubmitReportRecords);
                tbtskSubmitReportRecords.clear();
            }

            if (StringUtils.isNotBlank(sb.toString())) {
                result = sb.toString();
            } else {
                result = "提报成功";
            }
            //导出提报结果
            result = exportSubmitData(userid, resultData);
        }
        return "提报成功," + successNum + "," + failNum + "," + result;
    }

    /**
     * 获取流程的第一个审核阶段
     *
     * @param taskId 任务id
     * @return
     */
    private ReviewStageEnum getFirstStageOfFlow(String taskId) {
        List<TbtskFlowDef> flowDefList = tbtskFlowDefRepository.findTbtskFlowByTaskId(taskId, FlowTypeEnum.AUDIT.getCode());
        if (!GutilCollection.isEmpty(flowDefList)) {
            TbtskFlowDef flowDef = flowDefList.get(0);
            if (StringUtils.isNotBlank(flowDef.getSteps())) {
                JSONArray jsonArray = JSONArray.parseArray(flowDef.getSteps());
                if (jsonArray != null && !jsonArray.isEmpty()) {
                    Object firstStepObj = jsonArray.get(0);
                    if (firstStepObj != null) {
                        JSONObject jsonObject = JSONObject.parseObject(JSONObject.toJSONString(firstStepObj));
                        if (jsonObject != null && jsonObject.containsKey("name") && StringUtils.isNotBlank(jsonObject.get("name").toString())) {
                            switch (jsonObject.get("name").toString()) {
                                case "村级审核":
                                    return ReviewStageEnum.VILLAGE_VERIFY;
                                case "乡镇审核":
                                    return ReviewStageEnum.TOWN_VERIFY;
                                case "区县审核":
                                    return ReviewStageEnum.COUNTY_VERIFY;
                                case "市级审核":
                                    return ReviewStageEnum.CITY_VERIFY;
                                case "省级审核":
                                    return ReviewStageEnum.PROVINCE_VERIFY;
                                case "国家审核":
                                    return ReviewStageEnum.COUNTRY_VERIFY;
                                default:
                                    return ReviewStageEnum.VILLAGE_VERIFY;
                            }
                        }
                    }
                }
            }
        }

        return ReviewStageEnum.VILLAGE_VERIFY;
    }

    /**
     * 批量审核/复核
     *
     * @param dataList
     * @param taskId
     * @param option
     * @param description
     * @param remark
     * @param userId
     * @param approveUser
     * @param type
     * @return
     */
    public String submitAuditRecordBatch(List<Map> dataList, String taskId, Integer option, String
            description, String remark, Long userId, String approveUser, Integer type) {
        String result = "批量审核/复核失败";
        if (dataList == null || dataList.size() == 0) {
            result = "图斑数据不能为空";
            return result;
        }

        int userLevel = 0;
        //仅仅考虑一个用户有一个区域情形，如果多个会有bug,需要完善。
        List<String> userRegions = landUser2AreaRepository.queryAreas(userId);
        if (!GutilCollection.isEmpty(userRegions)) {
            String regionCode = userRegions.get(0);
            if ("1".equalsIgnoreCase(regionCode)) {
                userLevel = 1;
            } else if (regionCode.endsWith("0000")) {
                userLevel = 2;
            } else if (regionCode.endsWith("00")) {
                userLevel = 3;
            } else {
                userLevel = 4;
            }
        } else {
            result = "用户无工作区，无法审核/复核";
            return result;
        }
        String ynbgdcBizId = systemConfigCacheService.querySysConfig(BizIdConstants.YN_BGDC_BIZ_ID, "");

        List<TbtskApproveRecord> approveRecordCacheList = new ArrayList<>();
        String id = "";
        Integer status = null;
        String xzqdm = "";
        Integer reviewStage = null;
        Integer rejectCount = 0;
        TskTaskBiz taskBiz = mTskTaskBizService.findByTaskId(taskId);
        if (null == taskBiz) {
            result = "业务不存在或已被删除，无法审核/复核";
            return result;
        }
        TbtskObjectinfo tableInfo = mTbtskObjectinfoService.getObjectbyID(taskBiz.getTableId());
        if (null == tableInfo) {
            result = "业务数据表不存在或已被删除，无法审核/复核";
            return result;
        }
        for (Map data : dataList) {
            id = MapUtils.getString(data, "f_id", "");
            status = MapUtils.getInteger(data, "f_status", null);
            xzqdm = MapUtils.getString(data, "f_xzqdmsys", "");
            reviewStage = MapUtils.getInteger(data, "f_review_stage", null);
            rejectCount = MapUtils.getInteger(data, "f_reject_count", 0);

            if (data != null && status >= WAITING_VERIFY.getCode()) {
                TbtskApproveRecord approveRecord = new TbtskApproveRecord();
                approveRecord.setApproveUserId(userId);
                approveRecord.setApproveTime(new Date());
                approveRecord.setStatus(1);
                approveRecord.setTaskid(taskId);
                approveRecord.setXzqdm(xzqdm);
                approveRecord.setDescription(description);
                approveRecord.setRemark(remark);
                approveRecord.setOption(option);
                approveRecord.setTbid(id);
                approveRecord.setApproveUser(approveUser);
                approveRecord.setRejectCount(rejectCount != null ? rejectCount : 0);

                Integer index = null;
                //获取最新审批记录
                List<TbtskApproveRecord> recordList = tbtskApproveRecordRepository.findApproveRecordOrderByTime(approveRecord.getTaskid(), approveRecord.getTbid());
                //获取最新打回记录
                TbtskRejectRecord tbtskRejectRecord = tbtskRejectRecordRepository.findTopOneByTbIdOrderByRejectTime(approveRecord.getTaskid(), approveRecord.getTbid());
                if (recordList.size() > 0) {
                    index = recordList.get(0).getStepindex();
                }
                if (tbtskRejectRecord != null) {
                    if (tbtskRejectRecord.getRejectTime().compareTo(recordList.get(0).getApproveTime()) == 1) {
                        index = null;
                    }
                }
                //获取审核复核流程
                List<FlowStep> flowSteps = findFlowSteps(taskId, FlowTypeEnum.AUDIT);
                //获取最新节点
                index = index == null ? 0 : index + 1;
                FlowStep flowStep = flowSteps.get(index);
                boolean isAudit = false;
                if (reviewStage != null) {
                    if (type == 0) {
                        //审核
                        if (flowStep.getName().equalsIgnoreCase("村级审核")) {
                            if (reviewStage.equals(ReviewStageEnum.VILLAGE_VERIFY.getCode()) && userLevel == 4) {
                                isAudit = true;
                            }
                        } else if (flowStep.getName().equalsIgnoreCase("乡镇审核")) {
                            if ((reviewStage.equals(ReviewStageEnum.TOWN_VERIFY.getCode()) || reviewStage.equals(ReviewStageEnum.OPERATOR_VERIFY.getCode())) && userLevel == 4) {
                                isAudit = true;
                            }
                        } else if (flowStep.getName().equalsIgnoreCase("区县审核")) {
                            if (reviewStage.equals(ReviewStageEnum.COUNTY_VERIFY.getCode()) && userLevel == 4) {
                                isAudit = true;
                            }
                        } else if (flowStep.getName().equalsIgnoreCase("市级审核")) {
                            if (reviewStage.equals(ReviewStageEnum.CITY_VERIFY.getCode()) && userLevel == 3) {
                                isAudit = true;
                            }
                        } else if (flowStep.getName().equalsIgnoreCase("省级审核")) {
                            if (reviewStage.equals(ReviewStageEnum.PROVINCE_VERIFY.getCode()) && userLevel == 2) {
                                isAudit = true;
                            }
                        }
                      /*  if (reviewStage.equals(ReviewStageEnum.OPERATOR_VERIFY.getCode()) && userLevel == 4) {
                            approveRecord.setStepindex(0);
                            approveRecord.setStepname("操作员审核");
                            approveRecord.setNextstep(1);
                        } */
                    } else {
                        // 复核
                        if (flowStep.getName().equalsIgnoreCase("村级复核")) {
                            if (reviewStage.equals(ReviewStageEnum.VILLAGE_VERIFY.getCode()) && userLevel == 4) {
                                isAudit = true;
                            }
                        } else if (flowStep.getName().equalsIgnoreCase("乡镇复核")) {
                            if ((reviewStage.equals(ReviewStageEnum.TOWN_VERIFY.getCode()) || reviewStage.equals(ReviewStageEnum.OPERATOR_VERIFY.getCode())) && userLevel == 4) {
                                isAudit = true;
                            }
                        } else if (flowStep.getName().equalsIgnoreCase("区县复核")) {
                            if (reviewStage.equals(ReviewStageEnum.COUNTY_VERIFY.getCode()) && userLevel == 4) {
                                isAudit = true;
                            }
                        } else if (flowStep.getName().equalsIgnoreCase("市级复核")) {
                            if (reviewStage.equals(ReviewStageEnum.CITY_VERIFY.getCode()) && userLevel == 3) {
                                isAudit = true;
                            }
                        } else if (flowStep.getName().equalsIgnoreCase("省级复核")) {
                            if (reviewStage.equals(ReviewStageEnum.PROVINCE_VERIFY.getCode()) && userLevel == 2) {
                                isAudit = true;
                            }
                        }
                       /* if (reviewStage.equals(ReviewStageEnum.OPERATOR_VERIFY.getCode()) && userLevel == 4) {//可省略 不存在该情况
                            approveRecord.setStepindex(1);
                            approveRecord.setStepname("操作员复核");
                            approveRecord.setNextstep(2);
                        } */
                    }
                    if (isAudit) {
                        approveRecord.setStepindex(flowStep.getIndex());
                        approveRecord.setStepname(flowStep.getName());
                        approveRecord.setNextstep(flowStep.getIndex() + 1);
                    }
                }
                if (approveRecord.getStepindex() != null && approveRecord.getStepname() != null) {
                    if ((type == 0 && (status >= 10 && !status.equals(WAITING_REVIEW.getCode()) && !status.equals(REVIEW_NOT_PASS.getCode()))) ||
                            //已审核通过不可以再进行审核带下一级复核后进行审核
                            (type == 1 && (status.equals(WAITING_REVIEW.getCode()) || status.equals(REVIEW_NOT_PASS
                                    .getCode())))) { //已复核核通过不可以再进行复核，待审核后进行复核
                        //增加审核记录
                        approveRecordCacheList.add(approveRecord);
                        // 更新图斑数据状态
                        if (!GutilCollection.isEmpty(flowSteps)) {
                            for (int i = 0; i < flowSteps.size(); i++) {
                                FlowStep flowStep1 = flowSteps.get(i);
                                if (index.equals(flowStep1.getIndex())) {
                                    String stage = flowStep1.getPost_stage();
                                    if (approveRecord.getStepindex() % 2 == 0) {
                                        // 审核
                                        if (approveRecord.getOption().equals(1)) {
                                            data.put("f_status", WAITING_REVIEW.getCode());
                                            // 更新阶段
                                            /*  data.put("f_review_stage", Integer.valueOf(stage));*/
                                        } else if (approveRecord.getOption().equals(3) && approveRecord.getTaskid().equalsIgnoreCase(ynbgdcBizId)) {
                                            data.put("f_status", WAITING_REVIEW.getCode());
                                        } else {
                                            data.put("f_status", VERIFY_NOT_PASS.getCode());
                                        }
                                    } else {
                                        // 复核
                                        if (approveRecord.getOption().equals(1)) {
                                            if (StringUtils.isNotBlank(stage)) {
                                                data.put("f_status", WAITING_VERIFY.getCode());
                                                // 更新阶段
                                                data.put("f_review_stage", Integer.valueOf(stage));
                                            }
                                        } else if (approveRecord.getOption().equals(3) && approveRecord.getTaskid().equalsIgnoreCase(ynbgdcBizId)) {
                                            if (StringUtils.isNotBlank(stage)) {
                                                data.put("f_status", WAITING_VERIFY.getCode());
                                                // 更新阶段
                                                data.put("f_review_stage", Integer.valueOf(stage));
                                            }
                                        } else {
                                            data.put("f_status", REVIEW_NOT_PASS.getCode());
                                        }
                                    }
                                }
                            }
                        }
                        data.put("f_updatetime", System.currentTimeMillis());
                        mDataBizService.updateData(tableInfo.getfTablename(), data, "f_id='" + id + "'");
                    }
                }
            }
            if (approveRecordCacheList.size() == BATCH_COMMIT_COUNT) {
                //批量提交审批记录
                tbtskApproveRecordRepository.saveAll(approveRecordCacheList);
                approveRecordCacheList.clear();
            }
        }
        //批量提交剩余数据
        if (!approveRecordCacheList.isEmpty()) {
            //批量提交审批记录
            tbtskApproveRecordRepository.saveAll(approveRecordCacheList);
            approveRecordCacheList.clear();
        }
        result = "批量审核/复核完成";
        return result;
    }

    /**
     * 批量打回
     *
     * @param taskId
     * @param userId
     * @param remark
     * @param description
     * @param userName
     * @param stepName
     * @param result
     * @return
     */
    public String rejectBatchByList(List<Map> dataList, Integer type, String taskId, Long userId, String remark, String description, String userName, String stepName, String result) {
        result = "打回失败";
        if (dataList == null || dataList.size() == 0) {
            result = "图斑数据不能为空";
            return result;
        }
        int userLevel = 0;
        //获取用户审核或者是复核区
        List<String> areaList = new ArrayList<>();
        if (type == 0) {//审核
            List<TbtskUserAuditArea> list = tbtskUserAuditAreaService.listAuditAreas(taskId, userId.toString());
            areaList = list.stream().map(a -> a.getRegionCode()).collect(Collectors.toList());
        } else if (type == 1) { //复核
            List<TbtskUserReviewArea> list = tbtskUserReviewAreaService.listReviewAreas(taskId, userId.toString());
            areaList = list.stream().map(a -> a.getRegionCode()).collect(Collectors.toList());
        }

        List<String> submitUserIds = new ArrayList<>();
        List<String> ids = new ArrayList<>();
        List<TbtskRejectRecord> tbtskRejectRecordCacheData = new ArrayList<>();
        if (dataList != null && dataList.size() > 0) {
            // 存储房屋id对应打回记录id的数组
            JSONArray id2RejectIdArray = new JSONArray();
            String id = "";
            Integer status = null;
            Integer reviewStage = null;
            Integer rejectCount = 0;
            String xzqdm = "";
            String submitUserId = null;
            TskTaskBiz taskBiz = mTskTaskBizService.findByTaskId(taskId);
            if (taskBiz.getIsApprove() == 1) {
                TbtskRejectDef tbtskRejectDef = mTbtskRejectDefService.selectByTaskId(taskId);
                TbtskObjectinfo tableInfo = mTbtskObjectinfoService.getObjectbyID(taskBiz.getTableId());
                for (Map data : dataList) {
                    if (data != null) {
                        id = MapUtils.getString(data, "f_id", "");
                        status = MapUtils.getInteger(data, "f_status", null);
                        reviewStage = MapUtils.getInteger(data, "f_review_stage", null);
                        rejectCount = MapUtils.getInteger(data, "f_reject_count", 0);
                        submitUserId = MapUtils.getString(data, "f_submit_userid", "");
                        xzqdm = MapUtils.getString(data, "f_xzqdmsys", "");

                        boolean booleanarea = false;
                        for (String s : areaList) {
                            if (s.endsWith("0000")) {
                                if (s.substring(0, 2).equals(xzqdm.substring(0, 2))) {
                                    booleanarea = true;
                                    break;
                                }
                            } else if (s.endsWith("00")) {
                                if (s.substring(0, 4).equals(xzqdm.substring(0, 4))) {
                                    booleanarea = true;
                                    break;
                                }
                            } else {
                                if (s.equals(xzqdm.substring(0, s.length()))) {
                                    booleanarea = true;
                                    break;
                                }
                            }
                        }
                        Integer index = null;
                        //获取最新审批记录
                        List<TbtskApproveRecord> recordList = tbtskApproveRecordRepository.findApproveRecordOrderByTime(taskId, id);
                        //获取最新打回记录
                        TbtskRejectRecord tbtskRejectRecord = tbtskRejectRecordRepository.findTopOneByTbIdOrderByRejectTime(taskId, id);
                        if (recordList.size() > 0) {
                            index = recordList.get(0).getStepindex();
                        }
                        if (tbtskRejectRecord != null) {
                            if (tbtskRejectRecord.getRejectTime().compareTo(recordList.get(0).getApproveTime()) == 1) {
                                index = null;
                            }
                        }
                        //获取审核复核流程
                        List<FlowStep> flowSteps = findFlowSteps(taskId, FlowTypeEnum.AUDIT);
                        //获取最新节点
                        index = index == null ? 0 : index + 1;
                        FlowStep flowStep = flowSteps.get(index);
                        if (status != null) {
                            if (status < WAITING_VERIFY.getCode()) {
                            } else {
                                int currentCount = rejectCount != null ? rejectCount : 0;
                                boolean isReject = false;
                                if ((type == 0 && (status >= WAITING_VERIFY.getCode() && !status.equals(WAITING_REVIEW.getCode()) && !status.equals(REVIEW_NOT_PASS.getCode()))) ||
                                        //已审核通过不可以再进行审核带下一级复核后进行审核
                                        (type == 1 && (status.equals(WAITING_REVIEW.getCode()) || status.equals(REVIEW_NOT_PASS.getCode())))) { //已复核核通过不可以再进行复核，待审核后进行复核
                                    // 是否有权限打回
                                    if (type == 0) {
                                        //审核
                                        if (flowStep.getPre_stages().contains(reviewStage.toString()) && booleanarea && flowStep.getName().contains("审核")) {
                                            isReject = true;
                                        }
                                    } else {
                                        if (flowStep.getPre_stages().contains(reviewStage.toString()) && booleanarea && flowStep.getName().contains("复核")) {
                                            isReject = true;
                                        }
                                    }
                                        if (isReject) {
                                            if (tbtskRejectDef != null && tbtskRejectDef.getRejectType() == 1) { //1 打回到作业员
                                                Map<String, Object> updateMap = new HashMap<>();
                                                updateMap.put("f_reject_count", currentCount + 1);
                                                updateMap.put("f_status", SUBMIT.getCode());
                                                updateMap.put("f_review_stage", ReviewStageEnum.OPERATOR_VERIFY.getCode());
                                                updateMap.put("f_updatetime", System.currentTimeMillis());
                                                mDataBizService.updateData(tableInfo.getfTablename(), updateMap, "f_id='" + id + "'");
                                                ids.add(id);
                                                //获取打回记录信息
                                                tbtskRejectRecordCacheData.add(saveRejectRecordNew(taskId, userId, remark, description, userName, flowStep.getName(), id, reviewStage));
                                                //获取填报人
                                                submitUserIds.add(submitUserId != null ? submitUserId : "");
                                            } else if (tbtskRejectDef != null && tbtskRejectDef.getRejectType() == 2) {//2逐级打回(打回到前一节点)
                                                //查询最新的审核记录
                                                List<TbtskApproveRecord> tbtskApproveRecords = tbtskApproveRecordRepository
                                                        .findApproveRecordOrderByStepAndTime(taskId, id);
                                                if (tbtskApproveRecords.size() > 0) {
                                                    //获取审核流程节点,将审批流程打回到上一个节点
                                                    FlowStep flow = findFlow(taskId, 1, tbtskApproveRecords.get(0).getStepindex() - 1);
                                                    Map<String, Object> updateMap = new HashMap<>();
                                                    updateMap.put("f_reject_count", currentCount + 1);
                                                    updateMap.put("f_status", flow.getPost_status());
                                                    updateMap.put("f_review_stage", flow.getPost_stage());
                                                    updateMap.put("f_updatetime", System.currentTimeMillis());
                                                    mDataBizService.updateData(tableInfo.getfTablename(), updateMap, "f_id='" + id + "'");
                                                    ids.add(id);
                                                    //获取打回记录信息
                                                    tbtskRejectRecordCacheData.add(saveRejectRecordNew(taskId, userId, remark, description, userName, flowStep.getName(), id, reviewStage));
                                                    //获取填报人
                                                    submitUserIds.add(submitUserId != null ? submitUserId : "");
                                                }
                                            }
                                        }
                                }
                            }
                        }
                        if (tbtskRejectRecordCacheData.size() >= BATCH_COMMIT_COUNT) {
                            //批量新增打回记录
                            Iterable<TbtskRejectRecord> tbtskRejectRecords = tbtskRejectRecordRepository.saveAll(tbtskRejectRecordCacheData);
                            for (TbtskRejectRecord tbtskRejectRecord1 : tbtskRejectRecords) {
                                id2RejectIdArray.add(tbtskRejectRecord1.getTbid() + ":" + tbtskRejectRecord1.getId());
                            }
                            tbtskRejectRecordCacheData.clear();
                        }
                    }
                }
                    //剩余数据一起提交
                    if (tbtskRejectRecordCacheData.size() > 0) {
                        Iterable<TbtskRejectRecord> tbtskRejectRecords = tbtskRejectRecordRepository.saveAll(tbtskRejectRecordCacheData);
                        for (TbtskRejectRecord tbtskRejectRecord : tbtskRejectRecords) {
                            id2RejectIdArray.add(tbtskRejectRecord.getTbid() + ":" + tbtskRejectRecord.getId());
                        }
                        tbtskRejectRecordCacheData.clear();
                    }
                    if (submitUserIds.size() > 0) {
                        sendRejectMessageToAPPByPlatform(ids, userId, submitUserIds, description, remark, id2RejectIdArray,tableInfo, taskId);
                    }
                    result = "打回成功";
                }
            }
            return result;
    }

    public static String getNodeAuditNum(Object currentNode) {
        switch (currentNode.toString()) {
            case "村级审核":
                return "1";
            case "乡镇审核":
                return "2";
            case "区县审核":
                return "3";
            case "市级审核":
                return "4";
            case "省级审核":
                return "5";
            case "国家审核":
                return "6";
            default:
                return "";
        }
    }

    public Pair<Boolean, Object> queryTaskFlowInfo(String taskId, FlowTypeEnum audit, Long userId) {
        FlowDefInfoDTO flowDefInfoDTO = new FlowDefInfoDTO();
        if (StringUtils.isNotBlank(taskId)) {
            flowDefInfoDTO.setTaskId(taskId);
            List<TbtskFlowDef> tbtskFlowDefs = tbtskFlowDefRepository.findTbtskFlowByTaskId(taskId, FlowTypeEnum.AUDIT.getCode());
            if (!GutilCollection.isEmpty(tbtskFlowDefs)) {
                TbtskFlowDef flowDef = tbtskFlowDefs.get(0);
                flowDefInfoDTO.setFlowId(flowDef.getId());
                flowDefInfoDTO.setFlowName(flowDef.getName());
                flowDefInfoDTO.setFlowAuditType(1);
                if (StringUtils.isNotBlank(flowDef.getSteps())) {
                    flowDefInfoDTO.setFlowAuditType(1);
                    List<String> nodes = new ArrayList<>();
                    com.alibaba.fastjson.JSONArray stepsArray = JSON.parseArray(flowDef.getSteps());
                    if (stepsArray != null && !stepsArray.isEmpty()) {
                        for (Object o : stepsArray) {
                            JSONObject jsonObject = JSONObject.parseObject(o.toString());
                            if (jsonObject != null) {
                                if (jsonObject.containsKey("name")
                                        && StringUtils.isNotBlank(jsonObject.get("name").toString())) {
                                    if (jsonObject.get("name").toString().contains("复核")) {
                                        flowDefInfoDTO.setFlowAuditType(2);
                                    }
                                    String num = getNodeAuditNum(jsonObject.get("name").toString());
                                    if (StringUtils.isNotBlank(num)) {
                                        nodes.add(num);
                                    }
                                }
                            }
                        }
                    }
                    flowDefInfoDTO.setFlowNodes(StringUtils.join(nodes, ","));
                }
            }

            List<TbtskRejectDef> tbtskRejectDefs = tbtskRejectDefMapper.queryByTaskid(taskId);
            if (!GutilCollection.isEmpty(tbtskRejectDefs)) {
                TbtskRejectDef rejectDef = tbtskRejectDefs.get(0);
                flowDefInfoDTO.setRejectId(rejectDef.getId());
                flowDefInfoDTO.setFlowAuditType(rejectDef.getRejectType());
            }
            TskTaskBiz tskTaskBiz = mTskTaskBizService.findOne(taskId);
            if (tskTaskBiz != null) {
                flowDefInfoDTO.setCanRevoke(tskTaskBiz.getCanRevoke());
            }
        }
        return Pair.of(false, null);
    }

    private List<String> getAuditFieldNameCollection() {
        List<String> fieldNameList = new ArrayList<>();
        fieldNameList.add("f_id");
        fieldNameList.add("f_status");
        fieldNameList.add("f_xzqdmsys");
        fieldNameList.add("f_reject_status");
        fieldNameList.add("f_review_stage");
        fieldNameList.add("f_reject_count");
        return fieldNameList;
    }

    public JSONArray queryCustomRejectAvailableStages(String taskId, String tbId, String currentStepName, Long userId) {
        JSONArray resultArray = new JSONArray();
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("index", -1);
        jsonObj.put("name", "作业员");
        resultArray.add(jsonObj);
        List<TbtskFlowDef> tbtskFlowDefs = tbtskFlowDefRepository.findTbtskFlowByTaskId(taskId, FlowTypeEnum.AUDIT.getCode());
        if (!GutilCollection.isEmpty(tbtskFlowDefs)) {
            TbtskFlowDef flowDef = tbtskFlowDefs.get(0);
            if (flowDef != null && StringUtils.isNotBlank(flowDef.getSteps())) {
                JSONArray jsonArray = JSONArray.parseArray(flowDef.getSteps());
                if (jsonArray != null) {
                    for (int i = 0; i < jsonArray.size(); i++) {
                        JSONObject jsonObject = JSONObject.parseObject(JSONObject.toJSONString(jsonArray.get(i)));
                        if (jsonObject.get("name").toString().equals(currentStepName)) {
                            break;
                        } else {
                            JSONObject stepJsonObj = new JSONObject();
                            stepJsonObj.put("index", jsonObject.get("index"));
                            stepJsonObj.put("name", jsonObject.get("name"));
                            resultArray.add(stepJsonObj);
                        }
                    }
                }
            }
        }
        return resultArray;
    }
}