package com.geoway.landteam.landcloud.service.customtask.task;

import com.geoway.landteam.customtask.repository.task.TbtskImageScreenshotRepository;
import com.geoway.landteam.customtask.servface.multitask.DataBizService;
import com.geoway.landteam.customtask.servface.multitask.TbtskObjectinfoService;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.task.entity.TbtskImageScreenshot;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;

import javax.servlet.http.HttpServletRequest;
import java.io.*;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

/**
 * @author panzhiguang
 * @Package com.geoway.land.core.cloud.service
 * @date 2024/5/21 15:23
 */
@Slf4j
@Service
@Transactional(rollbackFor = Exception.class)
public class MTbtskImageScreenshotService {

    @Autowired
    TbtskImageScreenshotRepository tbtskImageScreenshotRepository;
    @Autowired
    TskTaskBizService tskTaskBizService;
    @Autowired
    DefaultOssOperatorService ossOperatorService;
    @Autowired
    TbtskObjectinfoService tbtskObjectinfoService;
    @Autowired
    TemporarySignedUrlService temporarySignedUrlService;

    @Value("${project.uploadDir}")
    protected String uploadDir;

    @Autowired
    DataBizService dataBizService;


    /**
     * 导入影像截图数据
     * @param request
     * @param taskId
     * @param userId
     * @throws Exception
     */
    public void importTaskScreenshotData(HttpServletRequest request, String taskId, Long userId) throws Exception {
        CommonsMultipartResolver multipartResolver = new CommonsMultipartResolver(request.getSession().getServletContext());
        TskTaskBiz tskTaskBiz = tskTaskBizService.findByTaskId(taskId);
        TbtskObjectinfo tableInfo = tbtskObjectinfoService.getObjectbyID(tskTaskBiz.getTableId());
        List<TbtskImageScreenshot> tbtskImageScreenshots = new ArrayList<>();
        if (multipartResolver.isMultipart(request)) {
            MultipartHttpServletRequest multiRequest = (MultipartHttpServletRequest) request;
            Iterator<String> iter = multiRequest.getFileNames();
            while (iter.hasNext()) {
                MultipartFile imageFile = multiRequest.getFile(iter.next());
                if (imageFile != null) {
                    File zipFile = null;
                    File dir = new File(uploadDir);
                    if (!dir.exists()) {
                        dir.mkdirs();
                    }
                    zipFile = File.createTempFile("tmp", ".zip", dir);
                    FileUtils.copyInputStreamToFile(imageFile.getInputStream(), zipFile);
                    String zipName = zipFile.getAbsolutePath();
                    String unzipFileDir = zipName.substring(0, zipName.lastIndexOf("."));
                   // Zip4jUtils.unzip(zipName, unzipFileDir, "gtdcy2019");
                    unzip(zipName, unzipFileDir);
                    File file = new File(unzipFileDir);
                    if(file.isDirectory()){
                        File[] oldfiles = file.listFiles();
                        if (oldfiles != null) {
                            // 遍历文件数组
                            for (File f : oldfiles) {
                                String tbbh = f.getName();
                                // 如果是文件夹，获取文件夹内的文件
                                File[] files = f.listFiles();
                                if (files != null) {
                                    // 遍历文件数组
                                    for (File f1 : files) {
                                        if(f1.isDirectory()){
                                            String type = f1.getName();
                                            // 如果是文件夹，获取文件夹内的文件
                                            File[] imagefiles = f1.listFiles();
                                            if(files != null){
                                                for (File image : imagefiles) {
                                                    String fileName = image.getName();
                                                     String ext =  fileName.substring(fileName.lastIndexOf("."),fileName.length());
                                                     if(ext.equals(".tif")){
                                                         SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                                                         String dateString = sdf.format(new Date());
                                                         String obsFilePath = "taskScreenshot/" + taskId + "/" + tbbh+"/"+dateString+"/"+fileName;

                                                         List<Map> dataList = dataBizService.queryAllData(tableInfo.getfTablename(), Arrays.asList("f_id"), "f_dkbh='" +  tbbh + "'");
                                                         if(dataList !=null && dataList.size() > 0){

                                                             List<TbtskImageScreenshot> tbtskImageScreenshotList = tbtskImageScreenshotRepository.findByTaskIdAndTbIdAndType(taskId, dataList.get(0).get("f_id").toString(), Integer.valueOf(type));
                                                              if(tbtskImageScreenshotList.size()>0){
                                                                  //将文件上传至对象存储
                                                                  FileInputStream fileInputStream = new FileInputStream(image);
                                                                  //返回的地址不能显示
                                                                  String imgUrl = ossOperatorService.sendObject2Oss(obsFilePath, fileInputStream);
                                                                  tbtskImageScreenshotList.get(0).setUrl(imgUrl);
                                                                  tbtskImageScreenshotList.get(0).setUpdateTime(new Date());
                                                                  tbtskImageScreenshots.add(tbtskImageScreenshotList .get(0));
                                                              }else{
                                                                  TbtskImageScreenshot tbtskImageScreenshot = new TbtskImageScreenshot();
                                                                  tbtskImageScreenshot.setTaskId(taskId);
                                                                  tbtskImageScreenshot.setTbId(dataList.get(0).get("f_id").toString());
                                                                  tbtskImageScreenshot.setType(Integer.valueOf(type));
                                                                  tbtskImageScreenshot.setCreateTime(new Date());
                                                                  //将文件上传至对象存储
                                                                  FileInputStream fileInputStream = new FileInputStream(image);
                                                                  //返回的地址不能显示
                                                                  String imgUrl = ossOperatorService.sendObject2Oss(obsFilePath, fileInputStream);
                                                                  tbtskImageScreenshot.setUrl(imgUrl);
                                                                  tbtskImageScreenshot.setUserId(userId);
                                                                  tbtskImageScreenshot.setName(fileName);
                                                                  tbtskImageScreenshots.add(tbtskImageScreenshot);
                                                              }
                                                         }
                                                     }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    //处理完成后删除临时路径数据
                    FileUtils.deleteQuietly(new File(unzipFileDir));
                    FileUtils.deleteQuietly(zipFile);
                }
            }
        }
        tbtskImageScreenshotRepository.saveAll(tbtskImageScreenshots);

    }


    public  List<TbtskImageScreenshot> findImageScreenshots(String taskId, String tbId){
        List<TbtskImageScreenshot> tbtskImageScreenshots = tbtskImageScreenshotRepository.findByTaskIdAndTbIdOrderByCreateTime(taskId, tbId);
            for(TbtskImageScreenshot tbtskImageScreenshot : tbtskImageScreenshots){
                if (tbtskImageScreenshot.getUrl() != null &&  !tbtskImageScreenshot.getUrl().contains("AccessKeyId")) {
                    String temporarySignedUrl=temporarySignedUrlService.getTemporarySignedUrl ("", tbtskImageScreenshot.getUrl(), null);
                    tbtskImageScreenshot.setTemporaryUrl(temporarySignedUrl);
                }
            }
        return tbtskImageScreenshots;
    }


    public static void unzip(String zipFilePath, String destDir) throws IOException {
        File dir = new File(destDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }

        ZipFile zipFile = new ZipFile(zipFilePath);
        Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();

        while (zipEntries.hasMoreElements()) {
            ZipEntry entry = zipEntries.nextElement();
            String entryName = entry.getName();

            String fileDestPath = destDir + File.separator + entryName;
            if (!entry.isDirectory()) {
                File destFile = new File(fileDestPath);
                destFile.getParentFile().mkdirs();

                InputStream inputStream = zipFile.getInputStream(entry);
                FileOutputStream outputStream = new FileOutputStream(destFile);

                byte[] buffer = new byte[1024];
                int bytesRead;
                while ((bytesRead = inputStream.read(buffer)) > 0) {
                    outputStream.write(buffer, 0, bytesRead);
                }

                outputStream.close();
                inputStream.close();
            } else {
                File dirToCreate = new File(fileDestPath);
                dirToCreate.mkdirs();
            }
        }

        zipFile.close();
    }


}
