package com.geoway.landteam.landcloud.service.customtask.task;

import com.geoway.landteam.customtask.repository.task.TbtskTaskLayerRepository;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.task.entity.*;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.persistence.Column;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author panzhiguang
 * @Package com.geoway.landteam.landcloud.service.customtask.task
 * @date 2024/7/17 14:30
 */

@Service
@Transactional(rollbackFor = Exception.class)
public class MTbtskLayerService {

    private static final GiLoger log = GwLoger.getLoger();

    @Autowired
    TbtskTaskLayerRepository tbtskTaskLayerRepository;
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    TskTaskBizService tskTaskBizService;
    @Autowired
    MTbtskObjectinfoService tbtskObjectinfoService;
    @Autowired
    MDataBizService mDataBizService;

    public List<TbtskTaskLayer> findLayerByTaskId(String taskId){
        return tbtskTaskLayerRepository.findLayerByTaskId(taskId);
    }


    public List<Map> getLayerByTaskId(String taskId,String tbId){
        List<Map> maps = new ArrayList<>();
        List<TbtskTaskLayer> layerByTaskId = tbtskTaskLayerRepository.findLayerByTaskId(taskId);
//        if(layerByTaskId.size() > 0){
//             String soucefield = layerByTaskId.get(0).getSoucefield();
//             String targetField = layerByTaskId.get(0).getSoucefield();
//             String sourceTaskId = layerByTaskId.get(0).getSourceTaskId();
//             String targetTaskId = layerByTaskId.get(0).getTargetTaskId();
//             //源任务数据
//            TskTaskBiz sourcetskTaskBiz = tskTaskBizService.findByTaskId(sourceTaskId);
//            TbtskObjectinfo sourcetableInfo = tbtskObjectinfoService.getObjectbyID(sourcetskTaskBiz.getTableId());
//            List<TbtskFields> sourcefieldsList = tskTaskBizService.getFieldsByTableId(sourcetableInfo.getfId());
//           List<String> fieldNameList = sourcefieldsList.stream().map(b -> b.getfFieldname()).collect(Collectors.toList());
//
//           //目标任务数据
//            TskTaskBiz targettskTaskBiz = tskTaskBizService.findByTaskId(targetTaskId);
//            TbtskObjectinfo targettableInfo = tbtskObjectinfoService.getObjectbyID(targettskTaskBiz.getTableId());
//            Map data = mDataBizService.selectFieldByID(targettableInfo.getfTablename(),  Arrays.asList("f_id",targetField), "f_id", "'" + tbId + "'");
//            if(data != null){
//                String where = soucefield+" = '"+data.get(targetField)+"'";
//               maps = mDataBizService.queryAllData(sourcetableInfo.getfTablename(), fieldNameList, where);
//            }
//            if(maps!=null&& !maps.isEmpty()){
//                for(Map temp : maps){
//                    temp.put("task_id",sourceTaskId);
//                }
//            }
//
//        }
        if(layerByTaskId !=null&& !layerByTaskId.isEmpty()){
            for(TbtskTaskLayer taskLayer : layerByTaskId){
                String soucefield = taskLayer.getSoucefield();
                String targetField = taskLayer.getSoucefield();
                String sourceTaskId = taskLayer.getSourceTaskId();
                String targetTaskId = taskLayer.getTargetTaskId();
                //源任务数据
                TskTaskBiz sourcetskTaskBiz = tskTaskBizService.findByTaskId(sourceTaskId);
                TbtskObjectinfo sourcetableInfo = tbtskObjectinfoService.getObjectbyID(sourcetskTaskBiz.getTableId());
                List<TbtskFields> sourcefieldsList = tskTaskBizService.getFieldsByTableId(sourcetableInfo.getfId());
                List<String> fieldNameList = sourcefieldsList.stream().map(b -> b.getfFieldname()).collect(Collectors.toList());

                //目标任务数据
                TskTaskBiz targettskTaskBiz = tskTaskBizService.findByTaskId(targetTaskId);
                TbtskObjectinfo targettableInfo = tbtskObjectinfoService.getObjectbyID(targettskTaskBiz.getTableId());
                Map data = mDataBizService.selectFieldByID(targettableInfo.getfTablename(),  Arrays.asList("f_id",targetField), "f_id", "'" + tbId + "'");
                if(data != null){
                    String where = soucefield+" = '"+data.get(targetField)+"'";
                    List<Map> resMap = mDataBizService.queryAllData(sourcetableInfo.getfTablename(), fieldNameList, where);
                    if(resMap!=null&& !resMap.isEmpty()){
                        for(Map temp : resMap){
                            temp.put("task_id",sourceTaskId);
                        }
                        maps.addAll(resMap);
                    }
                }
            }
        }
       return maps;
    }

}
