package com.geoway.landteam.landcloud.service.customtask.task;

import com.geoway.landteam.customtask.repository.task.TbtskTaskMenuRepository;
import com.geoway.landteam.customtask.repository.task.TbtskTaskRoleRepository;
import com.geoway.landteam.customtask.task.entity.TbtskTaskMenu;
import com.geoway.landteam.customtask.task.entity.TbtskTaskRole;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;

/**
 * @author panzhiguang
 * @Package com.geoway.landteam.landcloud.service.customtask.task
 * @date 2024/7/17 14:30
 */

@Service
@Transactional(rollbackFor = Exception.class)
public class MTbtskMenuService {

    private static final GiLoger log = GwLoger.getLoger();

    @Autowired
    TbtskTaskMenuRepository tbtskTaskMenuRepository;
    @Autowired
    TbtskTaskRoleRepository tbtskTaskRoleRepository;
    @Autowired
    JdbcTemplate jdbcTemplate;

    public List<TbtskTaskMenu> findMenuByTaskId(String taskId){
        return tbtskTaskMenuRepository.findMenuByTaskId(taskId);
    }

    public List<TbtskTaskMenu> findMenuByTaskId(String taskId,Long userId){
        List<TbtskTaskMenu> menuByTaskId = tbtskTaskMenuRepository.findMenuByTaskId(taskId);
        List<TbtskTaskMenu> taskMenus = new ArrayList<>();
        if(menuByTaskId.size() > 0){
          /*  //BBB替换任务id UUU 替换用户id
             for(TbtskTaskMenu taskMenu : menuByTaskId){
                 String sql = taskMenu.getOption().replaceAll("BBB",taskId).replaceAll("UUU",userId.toString());
                 Integer count = jdbcTemplate.queryForObject(sql, Integer.class);
                 if(count > 0){
                     taskMenus.add(taskMenu);
                 }
             }*/
            List<TbtskTaskRole> byTaskId = tbtskTaskRoleRepository.findByTaskId(taskId, userId);
            for(TbtskTaskMenu taskMenu : menuByTaskId){
                  for(TbtskTaskRole tbtskTaskRole : byTaskId){
                      if(taskMenu.getRoleId().contains(tbtskTaskRole.getId())){
                          taskMenus.add(taskMenu);
                      }
                  }
            }
        }
        return taskMenus;
    }
}
