package com.geoway.landteam.landcloud.service.customtask.task;

import com.geoway.landteam.customtask.repository.task.TbtskObjectinfoRepository;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Service
@Transactional
public class MTbtskObjectinfoService {

    @Autowired
    TbtskObjectinfoRepository tbtskObjectinfoDao;

//    @Autowired
//    TbtskImportRelRepository tbtskImportRelRepository;

    @Autowired
    MTbtskConfigService mTbtskConfigService;

    public TbtskObjectinfo getObjectbyID(String id) {
        TbtskObjectinfo objectinfo = tbtskObjectinfoDao.findById(id).orElse(null);
        return objectinfo;
    }

    public TbtskObjectinfo getObjectbyName(String name) {
        List<TbtskObjectinfo> list = tbtskObjectinfoDao.getObjectbyName(name);
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public List<TbtskObjectinfo> getObjectList(String bizName) {
        List<TbtskObjectinfo> objectList = tbtskObjectinfoDao.getObjectListByConfigType(bizName);
        return objectList;
    }

//    public List<TbtskObjectinfo> getImportObjectList(String bizName) {
//        List<String> importObjIDs = tbtskImportRelRepository.getImportObjIDs(SystemHelper.getSysCode());
//        if(importObjIDs.size()==0){
//            return null;
//        }
//        List<TbtskObjectinfo> objectList = tbtskObjectinfoDao.getObjectListByIds(bizName, importObjIDs);
//        return objectList;
//    }

    public List<TbtskObjectinfo> getObjectListByBizid(String bizid) {
        String typename = mTbtskConfigService.findById(bizid).getfTypename();
        List<TbtskObjectinfo> objectList = tbtskObjectinfoDao.getObjectListByConfigType(typename);
        return objectList;
    }

    public List<TbtskObjectinfo> getObjectbyTaskId(String taskId) {
        List<TbtskObjectinfo> objectList = tbtskObjectinfoDao.getObjectbyTaskId(taskId);
        return objectList;
    }

    public TbtskObjectinfo getObjectByTableId(String tableId) {
        return tbtskObjectinfoDao.getObjectByTableId(tableId);
    }

    public List<TbtskObjectinfo> getObjectByParentObjId(String parentObjId){
        return tbtskObjectinfoDao.queryTbtskObjectinfosByParentObjId(parentObjId);
    }

}
