package com.geoway.landteam.landcloud.service.customtask.task;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.repository.task.*;
import com.geoway.landteam.customtask.task.constants.FieldGroupTypeConstant;
import com.geoway.landteam.customtask.task.entity.*;
import com.geoway.landteam.customtask.util.TskTaskBizDBUtil;
import com.geoway.landteam.landcloud.common.util.PinYinUtil;
import com.geoway.landteam.landcloud.common.util.orm.QueryParamUtil;
import com.geoway.landteam.landcloud.common.util.orm.QuerySpecification;
/*import com.gw.base.data.GwValidateException;*/
import com.gw.base.data.GwValidateException;
import com.gw.base.util.GutilStr;
import com.geoway.landteam.landcloud.common.util.bean.BeanUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;
import java.util.stream.Collectors;

@Service
public class MTbtskTemplateService {

    @Autowired
    TbtskTemplateRepository tbtskTemplateDao;

    @Autowired
    BizAreaRepository bizAreaRepository;

    @Autowired
    TbtskObjectinfoRepository objectDao;

    @Autowired
    TbtskFieldsRepository fieldsDao;

    @Autowired
    TbtskGroupRepository groupDao;

    @Autowired
    TskTaskBizRepository taskBizDao;

    @Autowired
    TbtskTemplateAreaRepository templateAreaDao;
    @Autowired
    MDataBizService mDataBizService;

    @Autowired
    TbtskObjectinfoRepository tbtskObjectinfoRepository;

    @Autowired
    TbtskFieldsRepository tbtskFieldsRepository;

    @Autowired
    TbtskGroupRepository tbtskGroupRepository;

    @Autowired
    TbtskTemplateAreaRepository tbtskTemplateAreaRepository;

    @Autowired
    JdbcTemplate jdbcTemplate;


    final String LISTCODE = "100"; //图斑列表展示配置
    final String FILTERCODE = "101"; //业务字段筛选配置
    final String DETAILCODE = "202"; //图斑详情展示配置
    final String SEARCHCODE = "102"; //关键字搜索配置
    final String MAINCODE = "103"; // 详情主显示字段
    final String FILTERSYSCODE = "104"; //系统字段筛选配置
    final String ORDERCODE = "105";//业务字段排序配置

    @Transactional(rollbackFor = Exception.class)
    public TbtskTemplate save(TbtskTemplate template, String regions, String username, Long userId) {
        if (GutilStr.isEmpty(template.getId())) {
            template.setFinish(0);
            template.setCreateTime(new Date());
            template.setCreator(userId.toString());
            TbtskObjectinfo table = new TbtskObjectinfo();
            table = objectDao.save(table);
            template.setTableId(table.getfId());
            template = tbtskTemplateDao.save(template);
            table.setParentId(template.getId());
            table.setfTablename(table.getfId());
            objectDao.save(table);
            addDefaultFieldsToTemplate(template);
        } else {
            TbtskTemplate oldTemplate = tbtskTemplateDao.findById(template.getId()).orElse(null);
            oldTemplate.setDesc(template.getDesc());
            oldTemplate.setName(template.getName());
            oldTemplate.setScope(template.getScope());
            oldTemplate.setEnable(template.getEnable());
            oldTemplate.setClassId(template.getClassId());
            oldTemplate.setProjectType(template.getProjectType());
            tbtskTemplateDao.save(oldTemplate);
        }

        final String id = template.getId();
        if (regions != null) {
            JSONArray regionJson = JSONArray.parseArray(regions);
            List<TbtskTemplateArea> templateAreas = new ArrayList<>();
            for (int i = 0; i < regionJson.size(); i++) {
                JSONObject jsonObject = regionJson.getJSONObject(i);
                templateAreas.add(new TbtskTemplateArea(jsonObject.getString("code"), id, jsonObject.getInteger("type")));
            }
            templateAreaDao.deleteByTemplateId(id);
            templateAreaDao.saveAll(templateAreas);
        }
        return template;
    }

    @Transactional
    public TbtskTemplate save(TbtskTemplate template) {
        template = tbtskTemplateDao.save(template);
        return template;
    }

    public TbtskTemplate findById(String id) {
         return tbtskTemplateDao.findById(id).orElse(null);
    }

    public Page<TbtskTemplate> findPages(String filterParam, String sortParam, int page, int limit) {
        return tbtskTemplateDao.findAll(new QuerySpecification<TbtskTemplate>(filterParam),
                 PageRequest.of(page, limit,QueryParamUtil.parseSortParams(sortParam)));
}

    public List<TbtskTemplateArea> getTemplateAreas(String id) {
        return templateAreaDao.getAllByTemplateId(id);
    }

    @Transactional(rollbackFor = Exception.class)
    public void deleteTemplate(String id) throws Exception {
        TbtskTemplate template = tbtskTemplateDao.findById(id).orElse(null);
        if(template==null){
            throw new RuntimeException("模板不存在");
        }
        TbtskObjectinfo tbtskObjectinfo = objectDao.findById(template.getId()).orElse(null);
        if (tbtskObjectinfo != null) {
            List<String> ids = new ArrayList<>();
            ids.add(tbtskObjectinfo.getfId());
            fieldsDao.deleteInTableIds(ids);
            groupDao.deleteByFTablename(tbtskObjectinfo.getfTablename());
            objectDao.delete(tbtskObjectinfo);
        }
        tbtskTemplateDao.deleteById(id);
        templateAreaDao.deleteByTemplateId(id);
    }

    /**
     * 生成表信息
     * 保存字段信息
     *
     * @param task
     * @param templateId
     */
    @Transactional(rollbackFor = Exception.class)
    public void instantiateTemplate(TskTaskBiz task, String templateId) {
        if (task.getTemplateId() == null || !task.getTemplateId().equals(templateId)) {
            TbtskTemplate template = tbtskTemplateDao.findById(templateId).orElse(null);
            TbtskObjectinfo tableTemplate = objectDao.findById(template.getTableId()).orElse(null);
            TbtskObjectinfo table = null;
            // 新增或者更新 object信息
            if (GutilStr.isBlank(task.getTableId())) {
                TbtskObjectinfo tbtskObjectinfo = new TbtskObjectinfo();
                //     tbtskObjectinfo.setfTablename();
                tbtskObjectinfo.setfTablealias(task.getName());
                tbtskObjectinfo.setfIsspatial(tableTemplate.getfIsspatial());
                tbtskObjectinfo.setfState("1");
                tbtskObjectinfo.setfVersion("1");
                tbtskObjectinfo.setfTableversion(0);
                tbtskObjectinfo.setParentId("-1");
                tbtskObjectinfo.setTemplateId(templateId);
                table = objectDao.save(tbtskObjectinfo);

            } else {
                table = objectDao.findById(task.getTableId()).orElse(null);
                if (GutilStr.isNotBlank(table.getfTablename())) {
                    boolean existTableName = mDataBizService.isExistTableName(table.getfTablename());
                    // 表已经创建并且修改模板
                    if (existTableName && mDataBizService.getCount(table.getfTablename(), " 1=1 ") > 0 && !task.getTemplateId().equals(templateId)) {
                        throw new GwValidateException("任务表已经创建,并且已经存在数据，不允许修改任务模板");
                    }
                }
                table.setParentId("-1");
                table.setTemplateId(templateId);
                table.setfVersion((Integer.valueOf(table.getfVersion()) + 1) + "");
                table.setfTableversion(table.getfTableversion()==null?1:table.getfTableversion()+1);
                objectDao.save(table);
            }
            task.setTemplateId(templateId);
            String tableId = table.getfId();
            String tableName = Optional.ofNullable(table.getfTablename()).orElse("");
            task.setTableId(table.getfId());
            task.setStatus("0");
            taskBizDao.save(task);

            List<TbtskFields> fields = fieldsDao.getTbtskFieldsByTableid(template.getTableId());

            List<TbtskFields> oldfields = fieldsDao.getTbtskFieldsByTableid(table.getfId());
            List<String> fieldIds = oldfields.stream().map(r -> {
                return r.getfId();
            }).collect(Collectors.toList());
            //增加是否自己图斑（app端使用）
            List<TbtskFields> listTemp = fields.stream().filter(t -> t.getfFieldname().equalsIgnoreCase("f_ismy")).collect(Collectors.toList());
            List<TbtskFields> tbtskFields = new ArrayList<>();
            if (listTemp == null || listTemp.size() < 1) {
                TbtskFields temp = new TbtskFields();
                temp.setfId(UUID.randomUUID().toString());
                temp.setfFieldname("f_ismy");
                temp.setfTableid(tableId);
                temp.setfAlias("是否自己图斑（app端使用）");
                temp.setfFieldtype("8");
                temp.setfNullable(0);
                temp.setfDefaultvalue("0");
                temp.setfIsBase(0);
                temp.setfIsOutwork(0);
                temp.setfIsListShow(0);
                temp.setfIsWebCheck(0);
                temp.setfIsStatis(0);
                temp.setfIsWebEdit(0);
                temp.setfIsMust(0);
                temp.setfFieldInnerOuterSys(FieldGroupTypeConstant.SYSTEM_FIELD);
                tbtskFields.add(temp);
            }
            //判断是否选择图斑分割功能 {"isCancelOperArea":0,"splitFields":"f_tbbh,f_dczt","allowAppSplitSpot":0,"allowWebSplitSpot":1}
            if(StringUtils.isNotBlank(task.getConfigArgs())) {
                JSONObject configArgsObject = JSONObject.parseObject(task.getConfigArgs());
                if((configArgsObject.getInteger("allowWebSplitSpot") != null && configArgsObject.getInteger("allowWebSplitSpot")==1)
                        || (configArgsObject.getInteger("allowAppSplitSpot") != null && configArgsObject.getInteger("allowAppSplitSpot")==1)) {

                    listTemp = fields.stream().filter(t -> t.getfFieldname().equalsIgnoreCase("f_issplitted")).collect(Collectors.toList());
                    if (listTemp == null || listTemp.size() < 1) {
                        TbtskFields temp = new TbtskFields();
                        temp.setfId(UUID.randomUUID().toString());
                        temp.setfFieldname("f_issplitted");
                        temp.setfTableid(tableId);
                        temp.setfAlias("是否分割(系统)");
                        temp.setfFieldtype("8");
                        temp.setfNullable(1);
                        temp.setfDefaultvalue("0");
                        temp.setfIsBase(0);
                        temp.setfIsOutwork(0);
                        temp.setfIsListShow(0);
                        temp.setfIsWebCheck(0);
                        temp.setfIsStatis(0);
                        temp.setfIsWebEdit(0);
                        temp.setfIsMust(0);
                        temp.setfFieldInnerOuterSys(FieldGroupTypeConstant.SYSTEM_FIELD);
                        fields.add(temp);
                    }
                    listTemp = fields.stream().filter(t -> t.getfFieldname().equalsIgnoreCase("f_splitedid")).collect(Collectors.toList());
                    if (listTemp == null || listTemp.size() < 1) {
                        TbtskFields temp = new TbtskFields();
                        temp.setfId(UUID.randomUUID().toString());
                        temp.setfFieldname("f_splitedid");
                        temp.setfTableid(tableId);
                        temp.setfAlias("被分割原始图斑id(系统)");
                        temp.setfFieldtype("1");
                        temp.setfNullable(1);
                        temp.setfIsBase(0);
                        temp.setfIsOutwork(0);
                        temp.setfIsListShow(0);
                        temp.setfIsWebCheck(0);
                        temp.setfIsStatis(0);
                        temp.setfIsWebEdit(0);
                        temp.setfIsMust(0);
                        temp.setfFieldInnerOuterSys(FieldGroupTypeConstant.SYSTEM_FIELD);
                        fields.add(temp);
                    }
                    listTemp = fields.stream().filter(t -> t.getfFieldname().equalsIgnoreCase("f_mergeid")).collect(Collectors.toList());
                    if (listTemp == null || listTemp.size() < 1) {
                        TbtskFields temp = new TbtskFields();
                        temp.setfId(UUID.randomUUID().toString());
                        temp.setfFieldname("f_mergeid");
                        temp.setfTableid(tableId);
                        temp.setfAlias("合并的图斑id(系统)");
                        temp.setfFieldtype("1");
                        temp.setfNullable(1);
                        temp.setfIsBase(0);
                        temp.setfIsOutwork(0);
                        temp.setfIsListShow(0);
                        temp.setfIsWebCheck(0);
                        temp.setfIsStatis(0);
                        temp.setfIsWebEdit(0);
                        temp.setfIsMust(0);
                        temp.setfFieldInnerOuterSys(FieldGroupTypeConstant.SYSTEM_FIELD);
                        fields.add(temp);
                    }
                    listTemp = fields.stream().filter(t -> t.getfFieldname().equalsIgnoreCase("f_pid")).collect(Collectors.toList());
                    if (listTemp == null || listTemp.size() < 1) {
                        TbtskFields temp = new TbtskFields();
                        temp.setfId(UUID.randomUUID().toString());
                        temp.setfFieldname("f_pid");
                        temp.setfTableid(tableId);
                        temp.setfAlias("多部件上级图斑id(系统)");
                        temp.setfFieldtype("1");
                        temp.setfNullable(1);
                        temp.setfIsBase(0);
                        temp.setfIsOutwork(0);
                        temp.setfIsListShow(0);
                        temp.setfIsWebCheck(0);
                        temp.setfIsStatis(0);
                        temp.setfIsWebEdit(0);
                        temp.setfIsMust(0);
                        temp.setfFieldInnerOuterSys(FieldGroupTypeConstant.SYSTEM_FIELD);
                        fields.add(temp);
                    }
                    listTemp = fields.stream().filter(t -> t.getfFieldname().equalsIgnoreCase("f_ismultipart")).collect(Collectors.toList());
                    if (listTemp == null || listTemp.size() < 1) {
                        TbtskFields temp = new TbtskFields();
                        temp.setfId(UUID.randomUUID().toString());
                        temp.setfFieldname("f_ismultipart");
                        temp.setfTableid(tableId);
                        temp.setfAlias("是否多部件(系统)");
                        temp.setfFieldtype("1");
                        temp.setfNullable(1);
                        temp.setfIsBase(0);
                        temp.setfIsOutwork(0);
                        temp.setfIsListShow(0);
                        temp.setfIsWebCheck(0);
                        temp.setfIsStatis(0);
                        temp.setfIsWebEdit(0);
                        temp.setfIsMust(0);
                        temp.setfFieldInnerOuterSys(FieldGroupTypeConstant.SYSTEM_FIELD);
                        fields.add(temp);
                    }
                }
            }

            // 删除之前存在的字段
            fieldsDao.deleteInTableIds(Arrays.asList(table.getfId()));
            if (!fieldIds.isEmpty()) {
                groupDao.deleteInFieldIds(fieldIds);
            }
            //删除所有group配置
            groupDao.deleteByFTablename(StringUtils.isNotBlank(table.getfTablename())?table.getfTablename():table.getfId());
            for (TbtskFields r : fields) {
                TbtskFields field = new TbtskFields();
                BeanUtil.copyProperties(r, field, "fId", "fTableid", "fTablename");

                field.setfTableid(tableId);
                field.setfTablename(StringUtils.isNotBlank(table.getfTablename())?table.getfTablename():table.getfId());
                tbtskFields.add(field);

                fieldsDao.save(field);

                List<TbtskGroup> groups = groupDao.findByFFieldid(r.getfId());
                for (TbtskGroup g : groups) {
                    TbtskGroup tg = new TbtskGroup();

                    BeanUtil.copyProperties(g, tg, "fId", "fFieldid");
                    tg.setfFieldid(field.getfId());
                    tg.setfTablename(StringUtils.isNotBlank(table.getfTablename())?table.getfTablename():table.getfId());
                    tg.setConnection(changeConnectionFomat(g.getConnection(), r));
                    tg.setVisible(g.getVisible());
                    groupDao.save(tg);
                }
            }
            List<TbtskGroup> groups = groupDao.getFiledIdIsNull(template.getTableId());
            for (TbtskGroup g : groups) {
                TbtskGroup tg = new TbtskGroup();
                BeanUtil.copyProperties(g, tg, "fId");
                tg.setfTablename(StringUtils.isNotBlank(table.getfTablename())?table.getfTablename():table.getfId());
                groupDao.save(tg);
            }
            //获取系统字段配置
            List<TbtskGroup> sysFieldGroups = groupDao.selectByTableNameAndGroupcode("web", template.getTableId(), FILTERSYSCODE);
            for (TbtskGroup g1 : sysFieldGroups) {
                TbtskGroup tg = new TbtskGroup();
                BeanUtil.copyProperties(g1, tg, "fId");
                tg.setfTablename(StringUtils.isNotBlank(table.getfTablename())?table.getfTablename():table.getfId());
                groupDao.save(tg);
            }
            // 加入新的模板字段

        } else {
            taskBizDao.save(task);
        }
    }
    /**
     * 生成表信息
     * 保存字段信息
     *
     * @param task
     * @param param
     */
    @Transactional(rollbackFor = Exception.class)
    public void saveTaksTemplateConfig(TskTaskBiz task, JSONObject param) {
        String templateId = param.getString("templateId");
        if (task.getTemplateId() == null || !task.getTemplateId().equals(templateId)) {
            TbtskTemplate template = tbtskTemplateDao.findById(templateId).orElse(null);
            TbtskObjectinfo tableTemplate = objectDao.findById(template.getTableId()).orElse(null);
            TbtskObjectinfo table = null;
            // 新增或者更新 object信息
            if (GutilStr.isBlank(task.getTableId())) {
                TbtskObjectinfo tbtskObjectinfo = new TbtskObjectinfo();
                //     tbtskObjectinfo.setfTablename();
                tbtskObjectinfo.setfTablealias(task.getName());
                tbtskObjectinfo.setfIsspatial(tableTemplate.getfIsspatial());
                tbtskObjectinfo.setfState("1");
                tbtskObjectinfo.setfVersion("1");
                tbtskObjectinfo.setfTableversion(0);
                tbtskObjectinfo.setParentId("-1");
                tbtskObjectinfo.setTaskId(task.getId());
                tbtskObjectinfo.setTemplateId(task.getTemplateId());
                table = objectDao.save(tbtskObjectinfo);
            } else {
                table = objectDao.findById(task.getTableId()).orElse(null);
                if (GutilStr.isNotBlank(table.getfTablename())) {
                    boolean existTableName = mDataBizService.isExistTableName(table.getfTablename());
                    // 表已经创建并且修改模板
                    if (existTableName && mDataBizService.getCount(table.getfTablename(), " 1=1 ") > 0 && !task.getTemplateId().equals(templateId)) {
                        throw new GwValidateException("任务表已经创建,并且已经存在数据，不允许修改任务模板");
                    }
                }
                table.setParentId("-1");
                table.setTemplateId(templateId);
                table.setfVersion((Integer.valueOf(table.getfVersion()) + 1) + "");
                table.setfTableversion(table.getfTableversion()==null?1:table.getfTableversion()+1);
                objectDao.save(table);
            }
            task.setTemplateId(templateId);
            String tableId = table.getfId();
            String tableName = Optional.ofNullable(table.getfTablename()).orElse("");
            task.setTableId(table.getfId());
            task.setStatus("0");
            task.setFinish(0);
            taskBizDao.save(task);

            List<TbtskFields> fields = fieldsDao.getTbtskFieldsByTableid(template.getTableId());

            List<TbtskFields> oldfields = fieldsDao.getTbtskFieldsByTableid(table.getfId());
            List<String> fieldIds = oldfields.stream().map(r -> { return r.getfId();
            }).collect(Collectors.toList());
            //增加是否自己图斑（app端使用）
            List<TbtskFields> listTemp = fields.stream().filter(t -> t.getfFieldname().equalsIgnoreCase("f_ismy")).collect(Collectors.toList());
            List<TbtskFields> tbtskFields = new ArrayList<>();
            if (listTemp == null || listTemp.size() < 1) {
                TbtskFields temp = filedObject(tableId,"f_ismy","是否自己图斑（app端使用)","8",0,"0");
                tbtskFields.add(temp);
            }
            //判断是否选择图斑分割功能 {"isCancelOperArea":0,"splitFields":"f_tbbh,f_dczt","allowAppSplitSpot":0,"allowWebSplitSpot":1}
            if(StringUtils.isNotBlank(task.getConfigArgs())) {
                JSONObject configArgsObject = JSONObject.parseObject(task.getConfigArgs());
                if((configArgsObject.getInteger("allowWebSplitSpot") != null && configArgsObject.getInteger("allowWebSplitSpot")==1)
                        || (configArgsObject.getInteger("allowAppSplitSpot") != null && configArgsObject.getInteger("allowAppSplitSpot")==1)) {

                    listTemp = fields.stream().filter(t -> t.getfFieldname().equalsIgnoreCase("f_issplitted")).collect(Collectors.toList());
                    if (listTemp == null || listTemp.size() < 1) {
                        TbtskFields temp = filedObject(tableId,"f_issplitted","是否分割(系统)","8",1,null);
                        fields.add(temp);
                    }
                    listTemp = fields.stream().filter(t -> t.getfFieldname().equalsIgnoreCase("f_splitedid")).collect(Collectors.toList());
                    if (listTemp == null || listTemp.size() < 1) {
                        TbtskFields temp = filedObject(tableId,"f_splitedid","被分割原始图斑id(系统)","1",1,null);
                        fields.add(temp);
                    }
                    listTemp = fields.stream().filter(t -> t.getfFieldname().equalsIgnoreCase("f_mergeid")).collect(Collectors.toList());
                    if (listTemp == null || listTemp.size() < 1) {
                        TbtskFields temp = filedObject(tableId,"f_mergeid","合并的图斑id(系统)","1",1,null);
                        fields.add(temp);
                    }
                    listTemp = fields.stream().filter(t -> t.getfFieldname().equalsIgnoreCase("f_pid")).collect(Collectors.toList());
                    if (listTemp == null || listTemp.size() < 1) {
                        TbtskFields temp = filedObject(tableId,"f_pid","多部件上级图斑id(系统)","1",1,null);
                        fields.add(temp);
                    }
                    listTemp = fields.stream().filter(t -> t.getfFieldname().equalsIgnoreCase("f_ismultipart")).collect(Collectors.toList());
                    if (listTemp == null || listTemp.size() < 1) {
                        TbtskFields temp = filedObject(tableId,"f_ismultipart","是否多部件(系统)","1",1,null);
                        fields.add(temp);
                    }
                }
            }

            // 删除之前存在的字段
            fieldsDao.deleteInTableIds(Arrays.asList(table.getfId()));
            if (!fieldIds.isEmpty()) {
                groupDao.deleteInFieldIds(fieldIds);
            }
            //删除所有group配置
            groupDao.deleteByFTablename(StringUtils.isNotBlank(table.getfTablename())?table.getfTablename():table.getfId());
            for (TbtskFields r : fields) {
                TbtskFields field = new TbtskFields();
                BeanUtil.copyProperties(r, field, "fId", "fTableid", "fTablename");

                field.setfTableid(tableId);
                field.setfTablename(StringUtils.isNotBlank(table.getfTablename())?table.getfTablename():table.getfId());
                tbtskFields.add(field);

                fieldsDao.save(field);

                List<TbtskGroup> groups = groupDao.findByFFieldid(r.getfId());
                for (TbtskGroup g : groups) {
                    TbtskGroup tg = new TbtskGroup();

                    BeanUtil.copyProperties(g, tg, "fId", "fFieldid");
                    tg.setfFieldid(field.getfId());
                    tg.setfTablename(StringUtils.isNotBlank(table.getfTablename())?table.getfTablename():table.getfId());
                    tg.setConnection(changeConnectionFomat(g.getConnection(), r));
                    tg.setVisible(g.getVisible());
                    groupDao.save(tg);
                }
            }
            List<TbtskGroup> groups = groupDao.getFiledIdIsNull(template.getTableId());
            for (TbtskGroup g : groups) {
                TbtskGroup tg = new TbtskGroup();
                BeanUtil.copyProperties(g, tg, "fId");
                tg.setfTablename(StringUtils.isNotBlank(table.getfTablename())?table.getfTablename():table.getfId());
                groupDao.save(tg);
            }
            //获取系统字段配置
            List<TbtskGroup> sysFieldGroups = groupDao.selectByTableNameAndGroupcode("web", template.getTableId(), FILTERSYSCODE);
            for (TbtskGroup g1 : sysFieldGroups) {
                TbtskGroup tg = new TbtskGroup();
                BeanUtil.copyProperties(g1, tg, "fId");
                tg.setfTablename(StringUtils.isNotBlank(table.getfTablename())?table.getfTablename():table.getfId());
                groupDao.save(tg);
            }
        } else {
            taskBizDao.save(task);
        }
        //删除子地块配置,重新加载
        JSONArray dkParam = param.getJSONArray("dkParam");
        List<TbtskObjectinfo> objectbyTaskId = tbtskObjectinfoRepository.getObjectbyTaskId(task.getId());
        if(objectbyTaskId.size() > 0){
            for(TbtskObjectinfo tbtskObjectinfo: objectbyTaskId){
                if(!tbtskObjectinfo.getfId().equals(task.getTableId())){
                    //删除字段
                    // 删除之前存在的字段
                    fieldsDao.deleteInTableIds(Arrays.asList(tbtskObjectinfo.getfId()));
                    //删除所有group配置
                    groupDao.deleteByFTablename(StringUtils.isNotBlank(tbtskObjectinfo.getfTablename())?tbtskObjectinfo.getfTablename():tbtskObjectinfo.getfId());
                    //删除图斑表
                    if (GutilStr.isNotBlank(tbtskObjectinfo.getfTablename())) {
                        boolean existTableName = mDataBizService.isExistTableName(tbtskObjectinfo.getfTablename());
                        // 表已经创建并且修改模板
                     if(existTableName){
                         String sql1 = "DROP TABLE IF EXISTS " + tbtskObjectinfo.getfTablename() + ";";
                         jdbcTemplate.execute(sql1);
                       }
                    }
                    //删除tbtskObjectinfo记录
                    tbtskObjectinfoRepository.deleteById(tbtskObjectinfo.getfId());
                }
            }
        }
        //处理地块模板
        if(dkParam.size() > 0 ){
            for (Object o : dkParam) {
                JSONObject item = JSONObject.parseObject(JSONObject.toJSONString(o));
                handlyDkTemplateConfig(task,item);
            }
        }
    }

    @Transactional(rollbackFor = Exception.class)
    public void saveTaskConfig(TskTaskBiz task,String configArgs){
        TbtskObjectinfo tbtskObjectinfo = objectDao.findById(task.getTableId()).orElse(null);
        List<TbtskFields> fields = fieldsDao.getTbtskFieldsByTableid(tbtskObjectinfo.getfId());
        List<TbtskFields> listTemp = new ArrayList<>();
        List<TbtskFields> newFields = new ArrayList<>();
//判断是否选择图斑分割功能 {"isCancelOperArea":0,"splitFields":"f_tbbh,f_dczt","allowAppSplitSpot":0,"allowWebSplitSpot":1}
        if(StringUtils.isNotBlank(configArgs)) {
            JSONObject configArgsObject = JSONObject.parseObject(configArgs);
            JSONObject configArgsObject1 = JSONObject.parseObject(task.getConfigArgs());
            if(configArgsObject1 == null || (configArgsObject.getInteger("allowWebSplitSpot") != null &&
                    configArgsObject1.getInteger("allowWebSplitSpot") != null && configArgsObject.getInteger("allowWebSplitSpot")!= configArgsObject1.getInteger("allowWebSplitSpot"))
                    || (configArgsObject.getInteger("allowAppSplitSpot") != null && configArgsObject1.getInteger("allowAppSplitSpot") != null  && configArgsObject.getInteger("allowAppSplitSpot")!= configArgsObject1.getInteger("allowAppSplitSpot"))) {
                if (GutilStr.isNotBlank(tbtskObjectinfo.getfTablename())) {
                    boolean existTableName = mDataBizService.isExistTableName(tbtskObjectinfo.getfTablename());
                    // 表已经创建并且修改模板
                    if (existTableName && mDataBizService.getCount(tbtskObjectinfo.getfTablename(), " 1=1 ") > 0 ) {
                        throw new GwValidateException("任务表已经创建,并且已经存在数据，不允许修改任务配置");
                    }
                }
            }
            task.setConfigArgs(configArgs);
            if((configArgsObject.getInteger("allowWebSplitSpot") != null && configArgsObject.getInteger("allowWebSplitSpot")==1)
                    || (configArgsObject.getInteger("allowAppSplitSpot") != null && configArgsObject.getInteger("allowAppSplitSpot")==1)) {
                listTemp = fields.stream().filter(t -> t.getfFieldname().equalsIgnoreCase("f_issplitted")).collect(Collectors.toList());
                if (listTemp == null || listTemp.size() < 1) {
                    TbtskFields temp = filedObject(tbtskObjectinfo.getfId(),"f_issplitted","是否分割(系统)","8",1,null);
                    temp.setfTablename(tbtskObjectinfo.getfTablename());
                    newFields.add(temp);
                }
                listTemp = fields.stream().filter(t -> t.getfFieldname().equalsIgnoreCase("f_splitedid")).collect(Collectors.toList());
                if (listTemp == null || listTemp.size() < 1) {
                    TbtskFields temp = filedObject(tbtskObjectinfo.getfId(),"f_splitedid","被分割原始图斑id(系统)","1",1,null);
                    temp.setfTablename(tbtskObjectinfo.getfTablename());
                    newFields.add(temp);
                }
                listTemp = fields.stream().filter(t -> t.getfFieldname().equalsIgnoreCase("f_mergeid")).collect(Collectors.toList());
                if (listTemp == null || listTemp.size() < 1) {
                    TbtskFields temp = filedObject(tbtskObjectinfo.getfId(),"f_mergeid","合并的图斑id(系统)","1",1,null);
                    temp.setfTablename(tbtskObjectinfo.getfTablename());
                    newFields.add(temp);
                }
                listTemp = fields.stream().filter(t -> t.getfFieldname().equalsIgnoreCase("f_pid")).collect(Collectors.toList());
                if (listTemp == null || listTemp.size() < 1) {
                    TbtskFields temp = filedObject(tbtskObjectinfo.getfId(),"f_pid","多部件上级图斑id(系统)","1",1,null);
                    temp.setfTablename(tbtskObjectinfo.getfTablename());
                    newFields.add(temp);
                }
                listTemp = fields.stream().filter(t -> t.getfFieldname().equalsIgnoreCase("f_ismultipart")).collect(Collectors.toList());
                if (listTemp == null || listTemp.size() < 1) {
                    TbtskFields temp = filedObject(tbtskObjectinfo.getfId(),"f_ismultipart","是否多部件(系统)","1",1,null);
                    temp.setfTablename(tbtskObjectinfo.getfTablename());
                    newFields.add(temp);
                }
                //任务配置重新生成
                task.setFinish(0);
            }
        }
        task.setStructDbUrl(null);
        //字段结构变更版本加1
        tbtskObjectinfo.setfVersion((Integer.valueOf(tbtskObjectinfo.getfVersion()) + 1) + "");
        tbtskObjectinfo.setfTableversion(tbtskObjectinfo.getfTableversion()==null?1:tbtskObjectinfo.getfTableversion()+1);
        objectDao.save(tbtskObjectinfo);
        taskBizDao.save(task);
        fieldsDao.gwAccessSelective(newFields);
    }

    public void handlyDkTemplateConfig(TskTaskBiz task, JSONObject item){
        String templateId = item.get("templateId").toString();
        String tableId = item.containsKey("tableId")?item.get("tableId").toString():"";
        String name = item.get("name").toString();
        String spatialType = item.get("spatialType").toString();
        JSONObject relfield = item.getJSONObject("relfield");
        TbtskTemplate template = tbtskTemplateDao.findById(templateId).orElse(null);
        TbtskObjectinfo tableTemplate = objectDao.findById(template.getTableId()).orElse(null);
        TbtskObjectinfo table = null;
        if(StringUtils.isNotBlank(tableId)){
            table = objectDao.findById(task.getTableId()).orElse(null);
            if (GutilStr.isNotBlank(table.getfTablename())) {
                boolean existTableName = mDataBizService.isExistTableName(table.getfTablename());
                // 表已经创建并且修改模板
                if (existTableName && mDataBizService.getCount(table.getfTablename(), " 1=1 ") > 0 && !task.getTemplateId().equals(templateId)) {
                    throw new GwValidateException("任务表已经创建,并且已经存在数据，不允许修改任务模板");
                }
            }
            if (table.getTemplateId() == null || !table.getTemplateId().equals(templateId)) {
                table.setParentId(task.getTableId());
                table.setParentObjId(task.getTableId());
                table.setTaskId(task.getId());
                table.setTemplateId(templateId);
                table.setfTablealias(name);
                table.setfSpatialtype(spatialType);
                table.setRelfield(relfield.toJSONString());
                table.setfVersion((Integer.valueOf(table.getfVersion()) + 1) + "");
                table.setfTableversion(table.getfTableversion()==null?1:table.getfTableversion()+1);
                objectDao.save(table);
            }
        }else{
            TbtskObjectinfo tbtskObjectinfo = new TbtskObjectinfo();
            tbtskObjectinfo.setfTablealias(name);
            tbtskObjectinfo.setfIsspatial(tableTemplate.getfIsspatial());
            tbtskObjectinfo.setfState("1");
            tbtskObjectinfo.setfVersion("1");
            tbtskObjectinfo.setfTableversion(0);
            tbtskObjectinfo.setParentId(task.getTableId());
            tbtskObjectinfo.setParentObjId(task.getTableId());
            tbtskObjectinfo.setTaskId(task.getId());
            tbtskObjectinfo.setRelfield(relfield.toJSONString());
            tbtskObjectinfo.setfSpatialtype(spatialType);
            tbtskObjectinfo.setTemplateId(templateId);
            table = objectDao.save(tbtskObjectinfo);
        }
        tableId = table.getfId();
            List<TbtskFields> fields = fieldsDao.getTbtskFieldsByTableid(template.getTableId());
            List<TbtskFields> oldfields = fieldsDao.getTbtskFieldsByTableid(table.getfId());
            List<String> fieldIds = oldfields.stream().map(r -> { return r.getfId();
            }).collect(Collectors.toList());
            //增加是否自己图斑（app端使用）
            List<TbtskFields> listTemp = fields.stream().filter(t -> t.getfFieldname().equalsIgnoreCase("f_ismy")).collect(Collectors.toList());
            List<TbtskFields> tbtskFields = new ArrayList<>();
            if (listTemp == null || listTemp.size() < 1) {
                TbtskFields temp = filedObject(tableId,"f_ismy","是否自己图斑（app端使用)","8",0,"0");
                tbtskFields.add(temp);
            }
            //判断是否选择图斑分割功能 {"isCancelOperArea":0,"splitFields":"f_tbbh,f_dczt","allowAppSplitSpot":0,"allowWebSplitSpot":1}
            if(StringUtils.isNotBlank(task.getConfigArgs())) {
                JSONObject configArgsObject = JSONObject.parseObject(task.getConfigArgs());
                if((configArgsObject.getInteger("allowWebSplitSpot") != null && configArgsObject.getInteger("allowWebSplitSpot")==1)
                        || (configArgsObject.getInteger("allowAppSplitSpot") != null && configArgsObject.getInteger("allowAppSplitSpot")==1)) {

                    listTemp = fields.stream().filter(t -> t.getfFieldname().equalsIgnoreCase("f_issplitted")).collect(Collectors.toList());
                    if (listTemp == null || listTemp.size() < 1) {
                        TbtskFields temp = filedObject(tableId,"f_issplitted","是否分割(系统)","8",1,null);
                        fields.add(temp);
                    }
                    listTemp = fields.stream().filter(t -> t.getfFieldname().equalsIgnoreCase("f_splitedid")).collect(Collectors.toList());
                    if (listTemp == null || listTemp.size() < 1) {
                        TbtskFields temp = filedObject(tableId,"f_splitedid","被分割原始图斑id(系统)","1",1,null);
                        fields.add(temp);
                    }
                    listTemp = fields.stream().filter(t -> t.getfFieldname().equalsIgnoreCase("f_mergeid")).collect(Collectors.toList());
                    if (listTemp == null || listTemp.size() < 1) {
                        TbtskFields temp = filedObject(tableId,"f_mergeid","合并的图斑id(系统)","1",1,null);
                        fields.add(temp);
                    }
                    listTemp = fields.stream().filter(t -> t.getfFieldname().equalsIgnoreCase("f_pid")).collect(Collectors.toList());
                    if (listTemp == null || listTemp.size() < 1) {
                        TbtskFields temp = filedObject(tableId,"f_pid","多部件上级图斑id(系统)","1",1,null);
                        fields.add(temp);
                    }
                    listTemp = fields.stream().filter(t -> t.getfFieldname().equalsIgnoreCase("f_ismultipart")).collect(Collectors.toList());
                    if (listTemp == null || listTemp.size() < 1) {
                        TbtskFields temp = filedObject(tableId,"f_ismultipart","是否多部件(系统)","1",1,null);
                        fields.add(temp);
                    }
                }
            }

            // 删除之前存在的字段
            fieldsDao.deleteInTableIds(Arrays.asList(table.getfId()));
            if (!fieldIds.isEmpty()) {
                groupDao.deleteInFieldIds(fieldIds);
            }
            //删除所有group配置
            groupDao.deleteByFTablename(StringUtils.isNotBlank(table.getfTablename())?table.getfTablename():table.getfId());
            //地块增加自己的字段
            for (TbtskFields r : fields) {
                TbtskFields field = new TbtskFields();
                BeanUtil.copyProperties(r, field, "fId", "fTableid", "fTablename");
                field.setfTableid(tableId);
                field.setfTablename(StringUtils.isNotBlank(table.getfTablename())?table.getfTablename():table.getfId());
                tbtskFields.add(field);
                fieldsDao.save(field);

                List<TbtskGroup> groups = groupDao.findByFFieldid(r.getfId());
                for (TbtskGroup g : groups) {
                    TbtskGroup tg = new TbtskGroup();

                    BeanUtil.copyProperties(g, tg, "fId", "fFieldid");
                    tg.setfFieldid(field.getfId());
                    tg.setfTablename(StringUtils.isNotBlank(table.getfTablename())?table.getfTablename():table.getfId());
                    tg.setConnection(changeConnectionFomat(g.getConnection(), r));
                    tg.setVisible(g.getVisible());
                    groupDao.save(tg);
                }
            }
            List<TbtskGroup> groups = groupDao.getFiledIdIsNull(template.getTableId());
            for (TbtskGroup g : groups) {
                TbtskGroup tg = new TbtskGroup();
                BeanUtil.copyProperties(g, tg, "fId");
                tg.setfTablename(StringUtils.isNotBlank(table.getfTablename())?table.getfTablename():table.getfId());
                groupDao.save(tg);
            }
            //获取系统字段配置
            List<TbtskGroup> sysFieldGroups = groupDao.selectByTableNameAndGroupcode("web", template.getTableId(), FILTERSYSCODE);
            for (TbtskGroup g1 : sysFieldGroups) {
                TbtskGroup tg = new TbtskGroup();
                BeanUtil.copyProperties(g1, tg, "fId");
                tg.setfTablename(StringUtils.isNotBlank(table.getfTablename())?table.getfTablename():table.getfId());
                groupDao.save(tg);
            }
        }

    //字段预处理
    public TbtskFields filedObject(String tableId,String fFieldname,String fAlias,String fFieldtype,Integer  fNullable,String fDefaultvalue){
        TbtskFields temp = new TbtskFields();
        temp.setfId(UUID.randomUUID().toString());
        temp.setfFieldname(fFieldname);
        temp.setfTableid(tableId);
        temp.setfAlias(fAlias);
        temp.setfFieldtype(fFieldtype);
        temp.setfNullable(fNullable);
        if(StringUtils.isNotBlank(fDefaultvalue)){
            temp.setfDefaultvalue(fDefaultvalue);
        }
        temp.setfIsBase(0);
        temp.setfIsOutwork(0);
        temp.setfIsListShow(0);
        temp.setfIsWebCheck(0);
        temp.setfIsStatis(0);
        temp.setfIsWebEdit(0);
        temp.setfIsMust(0);
        temp.setfFieldInnerOuterSys(FieldGroupTypeConstant.SYSTEM_FIELD);
        return temp;
    }

    /**
     * 生成表信息
     * 保存字段信息
     *
     * @param task
     * @param templateId
     */
    @Transactional(rollbackFor = Exception.class)
    public void instantiateTemplateByXC(TskTaskBiz task, String templateId) {
        if (task.getTemplateId() == null || !task.getTemplateId().equals(templateId)) {
            TbtskTemplate template = tbtskTemplateDao.findById(templateId).orElse(null);
            TbtskObjectinfo tableTemplate = objectDao.findById(template.getTableId()).orElse(null);
            TbtskObjectinfo table = null;
            // 新增或者更新 object信息
            if (GutilStr.isBlank(task.getTableId())) {
                TbtskObjectinfo tbtskObjectinfo = new TbtskObjectinfo();
                //     tbtskObjectinfo.setfTablename();
                tbtskObjectinfo.setfTablealias(task.getName());
                tbtskObjectinfo.setfIsspatial(tableTemplate.getfIsspatial());
                tbtskObjectinfo.setfState("1");
                tbtskObjectinfo.setfVersion("1");
                tbtskObjectinfo.setfTableversion(0);
                tbtskObjectinfo.setParentId(templateId);
                tbtskObjectinfo.setTaskId(task.getId());
                table = objectDao.save(tbtskObjectinfo);
            } else {
                table = objectDao.findById(task.getTableId()).orElse(null);
                if (GutilStr.isNotBlank(table.getfTablename())) {
                    boolean existTableName = mDataBizService.isExistTableName(table.getfTablename());
                    // 表已经创建并且修改模板
                    if (existTableName && mDataBizService.getCount(table.getfTablename(), " 1=1 ") > 0 && !task.getTemplateId().equals(templateId)) {
                        throw new GwValidateException("任务表已经创建,并且已经存在数据，不允许修改任务模板");
                    }
                    if (existTableName) {
                        // 删除表
                        String sql = "DROP TABLE IF EXISTS " + table.getfTablename() + ";";
                        jdbcTemplate.execute(sql);
                    }
                    //删除字图斑表
                    if (mDataBizService.isExistTableName(table.getfTablename() + "_gzqk")) {
                        // 删除表
                        String sql1 = "DROP TABLE IF EXISTS " + table.getfTablename() + "_gzqk" + ";";
                        jdbcTemplate.execute(sql1);
                    }
                    if (mDataBizService.isExistTableName(table.getfTablename() + "_wtsj")) {
                        // 删除表
                        String sql1 = "DROP TABLE IF EXISTS " + table.getfTablename() + "_wtsj" + ";";
                        jdbcTemplate.execute(sql1);
                    }
                    groupDao.deleteByFTablename(table.getfTablename());
                }
                table.setParentId(templateId);
                table.setfVersion((Integer.valueOf(table.getfVersion()) + 1) + "");
                table.setfTableversion(table.getfTableversion()==null?1:table.getfTableversion()+1);
                table.setTaskId(task.getId());
                table.setfTablename(null);
                objectDao.save(table);
            }
            task.setTemplateId(templateId);
            String tableId = table.getfId();
            String tableName = Optional.ofNullable(table.getfTablename()).orElse("");
            task.setTableId(table.getfId());
            task.setStatus("0");
            task.setFinish(0);
            taskBizDao.save(task);

            List<TbtskFields> fields = fieldsDao.getTbtskFieldsByTableid(template.getTableId());

            List<TbtskFields> oldfields = fieldsDao.getTbtskFieldsByTableid(table.getfId());
            List<String> fieldIds = oldfields.stream().map(r -> { return r.getfId();}).collect(Collectors.toList());
            //增加是否自己图斑（app端使用）
            List<TbtskFields> listTemp = fields.stream().filter(t -> t.getfFieldname().equalsIgnoreCase("f_ismy")).collect(Collectors.toList());
            List<TbtskFields> tbtskFields = new ArrayList<>();
            if (listTemp == null || listTemp.size() < 1) {
                TbtskFields temp = new TbtskFields();
                temp.setfId(UUID.randomUUID().toString());
                temp.setfFieldname("f_ismy");
                temp.setfTableid(tableId);
                temp.setfAlias("是否自己图斑（app端使用）");
                temp.setfFieldtype("8");
                temp.setfNullable(0);
                temp.setfDefaultvalue("0");
                temp.setfIsBase(0);
                temp.setfIsOutwork(0);
                temp.setfIsListShow(0);
                temp.setfIsWebCheck(0);
                temp.setfIsStatis(0);
                temp.setfIsWebEdit(0);
                temp.setfIsMust(0);
                temp.setfFieldInnerOuterSys(FieldGroupTypeConstant.SYSTEM_FIELD);
                tbtskFields.add(temp);
            }
            //判断模板是否存在问题类型和工作情况字段
            boolean isExist2 = false;boolean isExist3 = false;
            for(TbtskFields fields1 : fields){
               if(StringUtils.isNotBlank(fields1.getfFieldAttribution()) && "2".equals(fields1.getfFieldAttribution())){
                   isExist2= true;
               }else if(StringUtils.isNotBlank(fields1.getfFieldAttribution()) && "3".equals(fields1.getfFieldAttribution())){
                   isExist3= true;
               }
            }
            if(isExist2){
                TbtskFields temp = new TbtskFields();
                temp.setfId(UUID.randomUUID().toString());
                temp.setfFieldname("f_title");
                temp.setfTableid(tableId);
                temp.setfAlias("标题");
                temp.setfFieldtype("1");
                temp.setfNullable(0);
                temp.setfDefaultvalue("0");
                temp.setfIsBase(0);
                temp.setfIsOutwork(0);
                temp.setfIsListShow(0);
                temp.setfIsWebCheck(0);
                temp.setfIsStatis(0);
                temp.setfIsWebEdit(0);
                temp.setfIsMust(0);
                temp.setfFieldInnerOuterSys(FieldGroupTypeConstant.SYSTEM_FIELD);
                temp.setfFieldAttribution("2");
                tbtskFields.add(temp);

                TbtskFields temp1 = new TbtskFields();
                temp1.setfId(UUID.randomUUID().toString());
                temp1.setfFieldname("f_desc");
                temp1.setfTableid(tableId);
                temp1.setfAlias("说明");
                temp1.setfFieldtype("1");
                temp1.setfNullable(0);
                temp1.setfDefaultvalue("0");
                temp1.setfIsBase(0);
                temp1.setfIsOutwork(0);
                temp1.setfIsListShow(0);
                temp1.setfIsWebCheck(0);
                temp1.setfIsStatis(0);
                temp1.setfIsWebEdit(0);
                temp1.setfIsMust(0);
                temp1.setfFieldInnerOuterSys(FieldGroupTypeConstant.SYSTEM_FIELD);
                temp1.setfFieldAttribution("2");
                tbtskFields.add(temp1);
            }
            // 删除之前存在的字段
            fieldsDao.deleteInTableIds(Arrays.asList(table.getfId()));
            if (!fieldIds.isEmpty()) {
                groupDao.deleteInFieldIds(fieldIds);
            }
            if (StringUtils.isNotBlank(table.getfId())) {
                groupDao.deleteByFTablename(table.getfId());
            }
            //查询是否有问题和工作情况字段
            List<TbtskObjectinfo> objectbyTaskId = tbtskObjectinfoRepository.getObjectbyTaskId(task.getId());
            if(objectbyTaskId.size() > 0 ){
                for(TbtskObjectinfo objectinfo : objectbyTaskId){
                    if(!objectinfo.getfId().equals(task.getTableId())){
                        fieldsDao.deleteInTableIds(Arrays.asList(objectinfo.getfId()));
                        List<TbtskFields> fields1 = fieldsDao.getTbtskFieldsByTableid(objectinfo.getfId());
                        List<String>  ids = fields1.stream().map(r -> { return r.getfId();}).collect(Collectors.toList());
                        if (!ids.isEmpty()) {
                            groupDao.deleteInFieldIds(ids);
                        }
                        tbtskObjectinfoRepository.deleteById(objectinfo.getfId());
                    }
                }
            }
            for (TbtskFields r : fields) {
                TbtskFields field = new TbtskFields();
                BeanUtil.copyProperties(r, field, "fId", "fTableid", "fTablename");

                field.setfTableid(tableId);
                field.setfTablename(tableName);
            /*    tbtskFields.add(field);*/
                fieldsDao.save(field);
                List<TbtskGroup> groups = groupDao.findByFFieldid(r.getfId());
                for (TbtskGroup g : groups) {
                    TbtskGroup tg = new TbtskGroup();
                    BeanUtil.copyProperties(g, tg, "fId", "fFieldid");
                    tg.setfFieldid(field.getfId());
                    tg.setfTablename(table.getfId());
                    tg.setConnection(changeConnectionFomat(g.getConnection(), r));
                    tg.setVisible(g.getVisible());
                    groupDao.save(tg);
                }
            }
           /* fieldsDao.saveAll(tbtskFields);*/
        /*    List<TbtskGroup> groups = groupDao.findByFTablename(template.getTableId());
            for (TbtskGroup g : groups) {
                TbtskGroup tg = new TbtskGroup();
                BeanUtil.copyProperties(g, tg, "fId");
                tg.setfTablename(table.getfId());
                groupDao.save(tg);
            }*/
            // 加入新的模板字段
        } else {
            taskBizDao.save(task);
        }
    }


    /**
     * 转换condition的格式符合app的需求
     * [ { "condition":{ "jugde":"=", "type":"number", "value":100 },
     * "effects":[ { "targetFiled":"f_tblx", "editable":-1, "visiable":1, "value":"" } ]
     * }]
     *
     * @param oldStr
     * @param field
     * @return
     */
    private String changeConnectionFomat(String oldStr, TbtskFields field) {

        try {
            if (GutilStr.isBlank(oldStr)) {
                return null;
            }
            //关联字段为条件时，将其转存到新的任务表中
            if(oldStr.contains("conditionsName")){
              /*  return oldStr.replaceAll("'","''");*/
                return oldStr;
            }
            JSONObject object = JSONObject.parseObject(oldStr);
            if (object.containsKey("type") && new Integer(1).equals(object.getInteger("type"))) {
                JSONArray refs = object.getJSONArray("ref");
                JSONArray triggers = new JSONArray();
                for (int i = 0; i < refs.size(); i++) {
                    JSONObject ref = refs.getJSONObject(i);
                    JSONObject condition = new JSONObject();
                    condition.put("judge", ref.getString("case"));
                    // type app这里只需要text 和 number 两种类型
                    condition.put("type", TskTaskBizDBUtil.getDBAppType(field.getfFieldtype()));
                    condition.put("value", ref.getString("val"));
                    JSONObject effect = new JSONObject();
                    TbtskFields connectedField = fieldsDao.findById(ref.getString("field")).orElse(null);
                    effect.put("targetFiled", connectedField.getfFieldname());
                    String originEffect = ref.getString("effect");
                    switch (originEffect) {
                        case "uneditshow": {
                            effect.put("editable", 0);
                            effect.put("visiable", 1);
                            break;
                        }
                        case "unedithide": {
                            effect.put("editable", 0);
                            effect.put("visiable", 0);
                            break;
                        }
                        case "edithide": {
                            effect.put("editable", 1);
                            effect.put("visiable", 0);
                            break;
                        }
                        case "editshow": {
                            effect.put("editable", 1);
                            effect.put("visiable", 1);
                            break;
                        }
                    }

                    JSONObject trigger = new JSONObject();
                    trigger.put("condition", condition);
                    trigger.put("effects", new JSONArray());
                    trigger.getJSONArray("effects").add(effect);
                    triggers.add(trigger);
                }
                return triggers.toString();
            } else {
                return null;
            }
        } catch (Exception e) {
            return null;
        }
    }

    @Transactional(rollbackFor = Exception.class)
    public TbtskFields saveField(TbtskFields field) {
        //判断是否是任务进行更改字段
        if(!field.getfTableid().equalsIgnoreCase(field.getfTablename()) && StringUtils.isNotBlank(field.getfTablename())){
          return saveTaskField(field);
        }
        //       当字段为新增字段或者当字段别称变化时重新生成字段名
        String oldName = "";
        if (!GutilStr.isEmpty(field.getfId())) {
            TbtskFields oldField = fieldsDao.findById(field.getfId()).orElse(null);
            oldName = oldField.getfFieldname();
            if (!oldField.getfAlias().equals(field.getfAlias())) {
                field = changeFileName(field);
            }
        } else {
            field = changeFileName(field);
        }
//        更新group表
        if (!GutilStr.isEmpty(field.getfId())) {
            List<TbtskGroup> groups = groupDao.findByFFieldid(field.getfId());
            for (TbtskGroup g : groups) {
                g.setfFieldname(field.getfFieldname());
                g.setfAlias(field.getfAlias());
                g.setfFieldtype(field.getfFieldtype());

                if("1".equalsIgnoreCase(field.getRuleReg())){
                    // 身份证号正则
                    g.setfRegexp("(^[1-9]\\d{5}(18|19|([23]\\d))\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{3}[0-9Xx]$)|(^[1-9]\\d{5}\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{2}[0-9Xx]$)");
                }
                else if("2".equalsIgnoreCase(field.getRuleReg())){
                    // 手机号正则
                    g.setfRegexp("^1(3|4|5|6|7|8|9)\\d{9}$");
                }
            }
            groupDao.saveAll(groups);
        }
        //新增tablename字段值
        TbtskObjectinfo objectByTableId = objectDao.getObjectByTableId(field.getfTableid());
        field.setfTablename(objectByTableId.getfTablename());
        //查询 如果有fId则走更新 如果没有则走新增
        if(mDataBizService.isExistTableName(objectByTableId.getfTablename())){
            if(StringUtils.isNotBlank(field.getfId())){
                List<TbtskFields> tbtskFields = fieldsDao.queryFieldInIds(Arrays.asList(field.getfId()), objectByTableId.getfTablename());
                if(!tbtskFields.isEmpty()){
                    //更新字段名称
                    if(!oldName.equals(field.getfFieldname())) {
                        String update = "ALTER TABLE " + objectByTableId.getfTablename() + " RENAME COLUMN " + oldName + " TO " + field.getfFieldname()  ;
                        jdbcTemplate.execute(update);
                    }
                    //更新字段类型 有风险暂时不处理
                }
            }else{
                //获取字段类型
                String ftype = conType(field.getfFieldtype());
                if(ftype.equals("decimal")){
                    String sql = "alter table " + objectByTableId.getfTablename() + " add  " + field.getfFieldname() + " " + ftype + "("+field.getfLength()+","+field.getfPrecision()+") NULL";
                    jdbcTemplate.execute(sql);
                }else{
                    if(field.getfLength()!=null) {
                        String sql = "alter table " + objectByTableId.getfTablename() + " add  " + field.getfFieldname() + " " + ftype + "(" + field.getfLength() + ") NULL";
                        jdbcTemplate.execute(sql);
                    }else{
                        String sql = "alter table " + objectByTableId.getfTablename() + " add " + field.getfFieldname() + " " + ftype +" NULL" ;
                        jdbcTemplate.execute(sql);
                    }
                }
            }
        }
        field = fieldsDao.save(field);
        //
        TskTaskBiz task = taskBizDao.findByTableId(field.getfTableid());
        if(task !=null && StringUtils.isNotBlank(task.getStructDbUrl())){
            //任务配置重新生成
            task.setStructDbUrl(null);
            taskBizDao.save(task);
            TbtskObjectinfo tbtskObjectinfo = objectDao.getObjectByTableId(field.getfTableid());
            //字段结构变更版本加1
            tbtskObjectinfo.setfVersion((Integer.valueOf(tbtskObjectinfo.getfVersion()) + 1) + "");
            tbtskObjectinfo.setfTableversion(tbtskObjectinfo.getfTableversion()==null?1:tbtskObjectinfo.getfTableversion()+1);
            objectDao.save(tbtskObjectinfo);
        }
        return field;
    }

    public String conType(String fieldType){
        Map<String,String> FIELD_TYPE_DIC = new HashMap<>();
        FIELD_TYPE_DIC.put("1","text");
        FIELD_TYPE_DIC.put("2","varchar");
        FIELD_TYPE_DIC.put("3","decimal");
        FIELD_TYPE_DIC.put("4","timestamp");
        FIELD_TYPE_DIC.put("5", "timestamp");
        FIELD_TYPE_DIC.put("6", "varchar");
        FIELD_TYPE_DIC.put("7", "decimal");
        FIELD_TYPE_DIC.put("8","int4");
        FIELD_TYPE_DIC.put("9","geometry");
        FIELD_TYPE_DIC.put("10","text");
        return  FIELD_TYPE_DIC.getOrDefault(fieldType,"varchar");
    }
    

    @Transactional(rollbackFor = Exception.class)
    public TbtskFields saveTaskField(TbtskFields field){
        String temStr = " ADD COLUMN ";
        if(!GutilStr.isEmpty(field.getfTableid())){
            TbtskObjectinfo table = tbtskObjectinfoRepository.findById(field.getfTableid()).orElse(null);
            if(table!=null){
                field.setfTablename(table.getfTablename());
                //任务字段更新版本加1
                tbtskObjectinfoRepository.updateTableVersion(table.getfTableversion()==null?1:table.getfTableversion
                        ()+1,table.getfId());
            }
        }
//       当字段为新增字段或者当字段别称变化时重新生成字段名
        if (!GutilStr.isEmpty(field.getfId())) {
            TbtskFields oldField = fieldsDao.findById(field.getfId()).orElse(null);
            if (!oldField.getfAlias().equals(field.getfAlias())) {
                field = changeFileName(field);
                //变更表字段名称
                jdbcTemplate.execute("ALTER TABLE "+field.getfTablename() + " RENAME "+oldField.getfFieldname()+" to " +
                        field.getfFieldname());
            }
            temStr = " alter  COLUMN ";
        } else {
            field = changeFileName(field);
        }

//        更新group表
        if (!GutilStr.isEmpty(field.getfId())) {
            List<TbtskGroup> groups = groupDao.findByFFieldid(field.getfId());
            for (TbtskGroup g : groups) {
                g.setfFieldname(field.getfFieldname());
                g.setfAlias(field.getfAlias());
                g.setfFieldtype(field.getfFieldtype());

                if("1".equalsIgnoreCase(field.getRuleReg())){
                    // 身份证号正则
                    g.setfRegexp("(^[1-9]\\d{5}(18|19|([23]\\d))\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{3}[0-9Xx]$)|(^[1-9]\\d{5}\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{2}[0-9Xx]$)");
                }
                else if("2".equalsIgnoreCase(field.getRuleReg())){
                    // 手机号正则
                    g.setfRegexp("^1(3|4|5|6|7|8|9)\\d{9}$");
                }
            }
            groupDao.saveAll(groups);
        }
        field = fieldsDao.save(field);
        //字段更新
        List<TbtskFields> fields = new ArrayList<>();
        fields.add(field);
        StringBuilder sbSql = new StringBuilder();
        sbSql.append(" ALTER TABLE ");
        sbSql.append(field.getfTablename());
        sbSql.append(temStr);
        String sql = TskTaskBizDBUtil.generateFieldSql(null,fields);
        if(temStr.equals(" alter  COLUMN ")){
            sql = field.getfFieldname() +" TYPE "+sql.replace(field.getfFieldname(),"")+"  USING ( "
                    +field.getfFieldname()+"::"+sql.replace(field.getfFieldname(),"")+")";
        }
        sbSql.append(sql);
        //更改数据库字段
        jdbcTemplate.execute(sbSql.toString());
        return field;
    }


    private TbtskFields changeFileName(TbtskFields field) {
        // 规则：默认字段名为“f_”加上字段别名的前8位中文首字母，长度最大为10个长度，
        // 如果同一张表，存在相同的字段名
        //      如“f_mj”这种长度不超过7个的，则直接在字段后补充“_n1”，1为存在相同的字段的个数，最终字段名为“f_mj_n1”
        //      如果“f_qmlmjzd”这种长度超过7个的，则截取前7位补充“_n1”，1为存在相同的字段的个数（一般来说不会超过两位数的相同字段名），最终字段名为“f_qmlmj_n1”
        String alias = field.getfAlias();
        String pinYin = PinYinUtil.getFirstSpell(alias);
        if(pinYin.length()>8){
            pinYin = pinYin.substring(0,8);
        }
        pinYin = "f_" + pinYin;
        //同名第一种情况
        Long count = fieldsDao.countStartWithPinyin(field.getfTableid(), pinYin+"%");
        //如果有第一种情况 才执行 同名第二种情况
        if (count > 0) {
            if (pinYin.length() > 7) {
                count += fieldsDao.countStartWithPinyin(field.getfTableid(), pinYin.substring(0, pinYin.length() - 3) + "_n%");
            }
        }
        if (count > 0) {
            if(pinYin.length()+3<=10) {
                pinYin = pinYin + "_n" + count;
            }
            else{
                pinYin = pinYin.substring(0,pinYin.length()-3) + "_n" + count;
            }
        }
        field.setfFieldname(pinYin);
        return field;
    }


    public TbtskTemplate finishTemplate(String taskId) {
        TbtskTemplate template = tbtskTemplateDao.findById(taskId).orElse(null);
        template.setFinish(1);
        template = tbtskTemplateDao.save(template);
        return template;
    }

    void addDefaultFieldsToTemplate(TbtskTemplate template) {
        TbtskObjectinfo table = objectDao.findById(template.getTableId()).orElse(null);
        addField(table, "f_id", "主键", "2", 100, null, 0, FieldGroupTypeConstant.SYSTEM_FIELD);
        addField(table, "f_status", "状态(系统)", "8", null, null, 1, FieldGroupTypeConstant.SYSTEM_FIELD);
        addField(table, "f_ismycreate", "是否自己创建(系统)", "8", null, null, 1, FieldGroupTypeConstant.SYSTEM_FIELD);
        addField(table, "f_jhid", "计划id(系统)", "2", 100, null, 1, FieldGroupTypeConstant.SYSTEM_FIELD);
        addField(table, "f_xsrwid", "线索任务id(系统)", "2", 100, null, 1, FieldGroupTypeConstant.SYSTEM_FIELD);
        addField(table, "f_xmid", "项目id(系统)", "2", 100, null, 1, FieldGroupTypeConstant.SYSTEM_FIELD);
        addField(table, "f_sfzdsx", "是否重大事项(系统)", "2", 100, null, 1, FieldGroupTypeConstant.SYSTEM_FIELD);
        addField(table, "f_requestid", "云查询id(系统)", "2", 100, null, 1, FieldGroupTypeConstant.SYSTEM_FIELD);
        addField(table, "f_ismy", "是否自己图斑（app端使用）", "8", null, null, 1, FieldGroupTypeConstant.SYSTEM_FIELD);
        addField(table, "f_xzqdmcity", "行政区代码市(系统)", "2", 20, null, 1, FieldGroupTypeConstant.SYSTEM_FIELD);
        addField(table, "f_xzqdmcounty", "行政区代码县(系统)", "2", 20, null, 1, FieldGroupTypeConstant.SYSTEM_FIELD);
        addField(table, "f_xzqdmtown", "行政区代码镇(系统)", "2", 20, null, 1, FieldGroupTypeConstant.SYSTEM_FIELD);
        addField(table, "f_xzqdmsys", "行政区代码村(系统)", "2", 20, null, 1, FieldGroupTypeConstant.SYSTEM_FIELD);
        addField(table, "f_submit_userid", "提交人员(系统)", "2", 32, null, 1, FieldGroupTypeConstant.SYSTEM_FIELD );
        addField(table, "f_reject_count", "打回次数(系统)", "8", null, null, 1, FieldGroupTypeConstant.SYSTEM_FIELD);
        addField(table, "f_review_stage", "审核阶段(系统)", "8", null, null, 1, FieldGroupTypeConstant.SYSTEM_FIELD);
        addField(table, "f_reject_status", "打回状态(系统)", "8", null, null, 1, FieldGroupTypeConstant.SYSTEM_FIELD);

        // 1 + 4 内业 + 系统
        addField(table, "f_shape", "shape(系统)", "9", null, null, 0, FieldGroupTypeConstant.INNER_FIELD + FieldGroupTypeConstant.SYSTEM_FIELD);
        addField(table, "f_shape1", "shape1(系统)", "9", null, null, 0, FieldGroupTypeConstant.INNER_FIELD + FieldGroupTypeConstant.SYSTEM_FIELD);
        addField(table, "f_lat", "中心点Y坐标(系统)", "3", 12, 6, 0, FieldGroupTypeConstant.INNER_FIELD + FieldGroupTypeConstant.SYSTEM_FIELD);
        addField(table, "f_lon", "中心点X坐标(系统)", "3", 12, 6, 0, FieldGroupTypeConstant.INNER_FIELD + FieldGroupTypeConstant.SYSTEM_FIELD);
        addField(table, "f_shape_b", "百度shape(系统)", "9", null, null, 1, FieldGroupTypeConstant.INNER_FIELD + FieldGroupTypeConstant.SYSTEM_FIELD);
        addField(table, "f_lat_b", "百度中心点Y坐标(系统)", "3", 12, 6, 1, FieldGroupTypeConstant.INNER_FIELD + FieldGroupTypeConstant.SYSTEM_FIELD);
        addField(table, "f_lon_b", "百度中心点X坐标(系统)", "3", 12, 6, 1, FieldGroupTypeConstant.INNER_FIELD + FieldGroupTypeConstant.SYSTEM_FIELD);
        addField(table, "f_shape_g", "谷歌shape(系统)", "9", null, null, 1, FieldGroupTypeConstant.INNER_FIELD + FieldGroupTypeConstant.SYSTEM_FIELD);


        addField(table, "f_tbmc", "图斑名称", "2", 100, null, 1, FieldGroupTypeConstant.INNER_FIELD);
        addField(table, "f_tbbh", "图斑编号", "2", 100, null, 1, FieldGroupTypeConstant.INNER_FIELD);
        addField(table, "f_xzqdm", "行政区代码", "2", 20, null, 1, FieldGroupTypeConstant.INNER_FIELD );
        addField(table, "f_tbmj", "图斑面积(亩)", "3", 12, 2, 1, FieldGroupTypeConstant.INNER_FIELD );
        addField(table, "f_xzqmc", "行政区名称", "2", 100, null, 1, FieldGroupTypeConstant.INNER_FIELD);
        addField(table, "f_xzqmc1", "行政区名称(系统)", "2", 100, null, 1, FieldGroupTypeConstant.INNER_FIELD + FieldGroupTypeConstant.SYSTEM_FIELD);

        addField(table, "f_lat_g", "谷歌中心点Y坐标(系统)", "3", 12, 6, 1, FieldGroupTypeConstant.INNER_FIELD + FieldGroupTypeConstant.SYSTEM_FIELD);
        addField(table, "f_lon_g", "谷歌中心点X坐标(系统)", "3", 12, 6, 1, FieldGroupTypeConstant.INNER_FIELD + FieldGroupTypeConstant.SYSTEM_FIELD);
        addField(table, "f_userid", "操作人(系统)", "2", 100, null, 1, FieldGroupTypeConstant.SYSTEM_FIELD + FieldGroupTypeConstant.INNER_FIELD);
        addField(table, "f_createtime", "创建时间(系统)", "2", 100, null, 1, FieldGroupTypeConstant.SYSTEM_FIELD + FieldGroupTypeConstant.INNER_FIELD);
        addField(table, "f_updatetime", "更新时间(系统)", "2", 100, null, 1, FieldGroupTypeConstant.SYSTEM_FIELD +  FieldGroupTypeConstant.INNER_FIELD);
        addField(table, "f_committime", "提交时间(系统)", "2", 100, null, 1, FieldGroupTypeConstant.SYSTEM_FIELD + FieldGroupTypeConstant.OUTER_FIELD);
        addField(table, "f_upload_userid", "执行人员(系统)", "2", 100, null, 1, FieldGroupTypeConstant.SYSTEM_FIELD + FieldGroupTypeConstant.OUTER_FIELD);
        addField(table, "f_approvetime", "审核时间(系统)", "2", 100, null, 1, FieldGroupTypeConstant.SYSTEM_FIELD + FieldGroupTypeConstant.INNER_FIELD);
        addField(table, "f_typical", "典型问题(系统)", "2", 100, null, 1, FieldGroupTypeConstant.SYSTEM_FIELD + FieldGroupTypeConstant.INNER_FIELD);
    }



    private void addField(TbtskObjectinfo tableInfo, String name, String alias, String fieldType, Integer length, Integer pricies, Integer nullAble, Integer code) {
        TbtskFields tbField = new TbtskFields();
        tbField.setfAlias(alias);
        tbField.setfFieldname(name);
        tbField.setfFieldtype(fieldType);
        tbField.setfLength(length);
        tbField.setfPrecision(pricies);
        tbField.setfNullable(nullAble);
        tbField.setfFieldInnerOuterSys(1);
        tbField.setfTableid(tableInfo.getfId());
        tbField.setfTablename(tableInfo.getfTablename());
        tbField.setfFieldInnerOuterSys(code);
        fieldsDao.save(tbField);
    }

    public boolean findNameExist(String id, String name) {
        TbtskTemplate template = tbtskTemplateDao.findFirstByName(name);
        if (template != null) {
            return !template.getId().equals(id);
        } else {
            return false;
        }
    }

    /**
     * 根据用户区域获取区域内的模板
     * 支持模糊搜索name name为空则获取全部
     *
     * @param regionCode
     * @param name
     * @return
     */
    public List<TbtskTemplate> getTbtskTemplateListByRegionCodeAndNameLike(String regionCode, String name, String classId,Integer projectType) {
        if("1".equals(regionCode)){
            regionCode = "%%";
        }else{
            if(regionCode.length() <= 6){
                if(regionCode.endsWith("0000")){
                    regionCode = regionCode.substring(0,2)+"%";
                }else if(regionCode.endsWith("00")){
                    regionCode = regionCode.substring(0,4)+"%";
                }else{
                    regionCode = regionCode+"%";
                }
            }else{
                regionCode = regionCode+"%";
            }
        }
        if(StringUtils.isNotBlank(name)){
            name = name+"%";
        }else{
            name ="%%";
        }
        if(StringUtils.isNotBlank(classId)){
            if(projectType != null){
                return tbtskTemplateDao.getAllByCodeAndNameAndClassIdAndProjectType(regionCode,name,Long.parseLong(classId),projectType);
            }else{
                return tbtskTemplateDao.getAllByCodeAndNameAndClassId(regionCode,name,Long.parseLong(classId));
            }
        }else{
            if(projectType != null){
                return tbtskTemplateDao.getAllByCodeAndNameAndProjectType(regionCode,name,projectType);
            }else{
                return tbtskTemplateDao.getAllByCodeAndName(regionCode,name);
            }
        }

       /* if (GutilStr.isBlank(name)) {
            if ("1".equals(regionCode)) {
                if (classId != null) {
                    return tbtskTemplateDao.getAllByCountryByClassId(Long.valueOf(classId));
                }
                return tbtskTemplateDao.getAllByCountry();
            } else {
                if (classId != null) {
                    return tbtskTemplateDao.getAllByRegionCodeByClassId(regionCode, Long.valueOf(classId));
                }
                return tbtskTemplateDao.getAllByRegionCode(regionCode);
            }
        } else {
            if ("1".equals(regionCode)) {
                if(classId != null){
                    return tbtskTemplateDao.getAllByCountryAndNameAndClassId("%" + name + "%",Long.valueOf(classId));
                }
                return tbtskTemplateDao.getAllByCountryAndName("%" + name + "%");
            } else {
                if(classId != null){
                    return tbtskTemplateDao.getAllByRegionCodeAndNameAndClassId(regionCode,"%" + name + "%",Long.valueOf(classId));
                }
                return tbtskTemplateDao.getAllByRegionCodeAndName(regionCode, "%" + name + "%");
            }
        }*/
    }
    public List<String> queryTemplateIdsByUserRegionCode(String userRegionCode)
    {
          String sql = "select distinct(f_templateid) from tbtsk_template_area where f_code ='"+userRegionCode+"'";
        if(userRegionCode.length() <= 6){
            if(userRegionCode.endsWith("0000")){

            }else if(userRegionCode.endsWith("00")){
                sql +=" or (f_type = 1 and  f_code = '"+userRegionCode.substring(0,2)+"0000')";
            }else{
                sql +=" or (f_type = 1 and  f_code = '"+userRegionCode.substring(0,2)+"0000')" + " or (f_type = 1 and  f_code = '"+userRegionCode.substring(0,4)+"00')";
            }
        }else if(userRegionCode.length()==9)
        {

            sql +=" or (f_type = 1 and  f_code = '"+userRegionCode.substring(0,2)+"0000')" + " or (f_type = 1 and  f_code = '"+userRegionCode.substring(0,4)+"00')" + " or (f_type = 1 and  f_code = '"+userRegionCode.substring(0,6)+"')";
        }
        else if(userRegionCode.length()==12)
        {

            sql +=" or (f_type = 1 and  f_code = '"+userRegionCode.substring(0,2)+"0000')" + " or (f_type = 1 and  f_code = '"+userRegionCode.substring(0,4)+"00')" + " or (f_type = 1 and  f_code = '"+userRegionCode.substring(0,6)+"')"+ " or (f_type = 1 and  f_code = '"+userRegionCode.substring(0,9)+"')";
        }
        List<Map<String,Object>>maps =  jdbcTemplate.queryForList(sql);
        List<String>ids = new ArrayList<>();
        if(maps!=null)
        {
            for (Map m:maps) {
            ids.add(m.get("f_templateid").toString());
            }
        }
        return ids;

    }
    /**
     * 修改任务模板tab名称
     * 李密浩
     * @param tempId 模板id
     * @param oldName 旧tab名称
     * @param newName 新tab名称
     * @param sys 类型
     */
    @Transactional(rollbackFor = Exception.class)
    public void changeTabName(String tempId,String oldName,String newName,String sys){
        TbtskTemplate tbtskTemplate = tbtskTemplateDao.findById(tempId).orElse(null);
        if (tbtskTemplate == null){
            throw new RuntimeException("无该任务模板");
        }
        //获取任务所有tab及tab中包含字段
        List<TbtskGroup> tbtskGroups = groupDao.selectByTableIdAndGroupcode(sys, tbtskTemplate.getTableId(), DETAILCODE);
        //获取tab名字
        List<String> tabNames=tbtskGroups.stream().map(r->r.getfSubgroupname()).distinct().collect(Collectors.toList());
        //校验新名字是否重复
        if(tabNames.indexOf(newName)>-1){
            throw new RuntimeException("当前模板存在重复tab名称");
        }
        //校验旧名字是否正确
        if(tabNames.indexOf(oldName)<0){
            throw new RuntimeException("无名字为"+oldName+"的tab页");
        }
        //获取所有需要修改的group字段id
        List<String> groupIds=tbtskGroups.stream().filter(r->r.getfSubgroupname().equals(oldName)).map(r->r.getfId()).collect(Collectors.toList());
        if(!groupIds.isEmpty()){
            groupDao.updateGroupNameByName(groupIds,newName);
        }
    }

    public void copyTaskTemplate(Long userId,String templateId,String newName){
        TbtskTemplate one = tbtskTemplateDao.findById(templateId).orElse(null);
        if(one == null){
            throw new RuntimeException("未找到该模板");
        }
        TbtskTemplate firstByName = tbtskTemplateDao.findFirstByName(newName);
        if(firstByName != null){
            throw new RuntimeException("已存在【"+newName+"】的模板");
        }
        List<TbtskFields> sourceFields = tbtskFieldsRepository.getTbtskFieldsByTableid(one.getTableId());
        if(sourceFields.isEmpty()){
            throw new RuntimeException("未找到字段信息");
        }
        List<TbtskGroup> sourceGroup = tbtskGroupRepository.findByFTablename(one.getTableId());
        if(sourceGroup.isEmpty()){
            throw new RuntimeException("未找到展示信息");
        }
        List<TbtskTemplateArea> allTemplateAreas = tbtskTemplateAreaRepository.getAllByTemplateId(templateId);
        if(allTemplateAreas.isEmpty()){
            throw new RuntimeException("模板没有区域信息");
        }
        //table id
        TbtskObjectinfo tbtskObjectinfo = new TbtskObjectinfo();
        tbtskObjectinfo = tbtskObjectinfoRepository.save(tbtskObjectinfo);
        String newTableId = tbtskObjectinfo.getfId();
        //模板id
        TbtskTemplate newTemplate = new TbtskTemplate();
        newTemplate = tbtskTemplateDao.save(newTemplate);
        String newTempId = newTemplate.getId();

        //todo 创建objinfo对应记录
        tbtskObjectinfo.setfTablename(newTableId);
        //设置版本号2为新版本
        tbtskObjectinfo.setfTableversion(2);
        tbtskObjectinfo.setParentId(newTempId);
        tbtskObjectinfoRepository.save(tbtskObjectinfo);


        //todo 创建模板
        BeanUtil.copyProperties(one,newTemplate);
        //对应的在objInfo的id
        newTemplate.setId(newTempId);
        newTemplate.setName(newName);
        newTemplate.setCreateTime(new Date());
        newTemplate.setCreator(userId.toString());
        newTemplate.setTableId(newTableId);
        tbtskTemplateDao.save(newTemplate);

        //todo 设置模板区域
        List<TbtskTemplateArea> newTemplateAreas = new ArrayList<>();
        for (TbtskTemplateArea templateArea : allTemplateAreas) {
            TbtskTemplateArea area = new TbtskTemplateArea();
            BeanUtil.copyProperties(templateArea,area);
            area.setId(UUID.randomUUID().toString());
            area.setTemplateId(newTempId);
            newTemplateAreas.add(area);
        }
        tbtskTemplateAreaRepository.saveAll(newTemplateAreas);


        //todo 复制并创建fields字段信息
        List<TbtskFields> newFields = new ArrayList<>();
        for (TbtskFields sourceField : sourceFields) {
            TbtskFields tempFields = new TbtskFields();
            BeanUtil.copyProperties(sourceField,tempFields);
            tempFields.setfId(UUID.randomUUID().toString());
            tempFields.setfTablename(newTableId);
            tempFields.setfTableid(newTableId);
            newFields.add(tempFields);
        }
        tbtskFieldsRepository.saveAll(newFields);

        //todo 复制并创建app/web配置展示的字段信息
        //遍历app展示字段
        List<TbtskGroup> newGroups = new ArrayList<>();
        newFields = tbtskFieldsRepository.getTbtskFieldsByTableid(newTableId);
        for (TbtskGroup group : sourceGroup) {
            //找到新生成字段包含app/web配置字段项
            List<TbtskFields> collect = newFields.stream().filter(r -> r.getfFieldname().equals(group.getfFieldname())).collect(Collectors.toList());
            if(!collect.isEmpty()){
                TbtskGroup tbtskGroup = new TbtskGroup();
                BeanUtil.copyProperties(group,tbtskGroup);
                tbtskGroup.setfId(UUID.randomUUID().toString());
                tbtskGroup.setfFieldid(collect.get(0).getfId());
                tbtskGroup.setfTablename(newTableId);
                newGroups.add(tbtskGroup);
            }
        }
        tbtskGroupRepository.saveAll(newGroups);
    }

    public TbtskTemplate getByBizId(String bizId) {

        TskTaskBiz tskTaskBiz = taskBizDao.findById(bizId).orElse(null);
        if(tskTaskBiz==null) return new TbtskTemplate();
        TbtskTemplate list = tbtskTemplateDao.findById(tskTaskBiz.getTemplateId()).orElse(null);
        return list;
    }
}
