package com.geoway.landteam.landcloud.service.customtask.task;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.dps.GPSUtil.GPSInfo;
import com.dps.GPSUtil.GPSUtil;
import com.geoway.landteam.customtask.pub.dto.DataDownloadRecord;
import com.geoway.landteam.customtask.pub.dto.DownloadParameter;
import com.geoway.landteam.customtask.pub.dto.FlowStep;
import com.geoway.landteam.customtask.pub.enm.DataDownloadStateEnum;
import com.geoway.landteam.customtask.pub.entity.*;
import com.geoway.landteam.customtask.repository.pub.DataDownloadRecordRepository;
import com.geoway.landteam.customtask.repository.pub.TbgstRepository;
import com.geoway.landteam.customtask.repository.task.*;

import com.geoway.landteam.customtask.servface.task.TbtskUserReviewAreaService;
import com.geoway.landteam.customtask.servface.task.TbtskUserUploadAreaService;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.service.util.TaskDBUtils;
import com.geoway.landteam.customtask.task.constants.FieldGroupTypeConstant;
import com.geoway.landteam.customtask.task.constants.UpResultEnum;
import com.geoway.landteam.customtask.task.constants.UpResultErrorEnum;
import com.geoway.landteam.customtask.task.dto.TskUploadLogDTO;
import com.geoway.landteam.customtask.task.dto.UserBizAreaDTO;
import com.geoway.landteam.customtask.task.enm.FlowTypeEnum;
import com.geoway.landteam.customtask.task.enm.UserRoleEnum;
import com.geoway.landteam.customtask.task.entity.*;
import com.geoway.landteam.customtask.taskTranslate.dto.TaskTranslateTargetTaskDTO;
import com.geoway.landteam.customtask.util.ExcelPOIUtil;
import com.geoway.landteam.customtask.util.TskTaskBizDBUtil;
import com.geoway.landteam.landcloud.common.util.*;
import com.geoway.landteam.landcloud.common.util.base.StringUtils;
import com.geoway.landteam.landcloud.common.util.bean.BeanUtil;
import com.geoway.landteam.landcloud.common.util.geometry.WKTUtil;
import com.geoway.landteam.landcloud.common.util.orm.QueryParamUtil;
import com.geoway.landteam.landcloud.common.util.orm.QuerySpecification;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.core.model.base.dto.RegionDto;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.model.base.enm.ReviewStageEnum;
import com.geoway.landteam.landcloud.core.model.base.enm.TbStatusEnum;
import com.geoway.landteam.landcloud.core.model.base.entity.*;
import com.geoway.landteam.landcloud.core.model.coord.CoordSpheroid;
import com.geoway.landteam.landcloud.core.model.coord.GeoPoint;
import com.geoway.landteam.landcloud.core.model.coord.ZoneType;
import com.geoway.landteam.landcloud.core.model.pub.constants.BizIdConstants;
import com.geoway.landteam.landcloud.core.model.pub.constants.JobConstants;
import com.geoway.landteam.landcloud.core.model.pub.constants.NumberConst;
import com.geoway.landteam.landcloud.core.model.pub.dto.UserAddInfo;
import com.geoway.landteam.landcloud.core.model.pub.entity.ImportUserResultInfo;
import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.geoway.landteam.landcloud.core.model.pub.help.SpringContextHolder2;
import com.geoway.landteam.landcloud.core.model.user.entity.LandUser;
import com.geoway.landteam.landcloud.core.model.user.entity.LandUser2Area;
import com.geoway.landteam.landcloud.core.repository.base.*;
import com.geoway.landteam.landcloud.core.repository.pub.OssConfigRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandUser2AreaRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandUserRepository;
import com.geoway.landteam.landcloud.core.servface.base.AppMediaService;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.servface.region.RegionService;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.landcloud.core.servface.base.SysConfigService;
import com.geoway.landteam.landcloud.core.servface.user.LandUserService;
import com.geoway.landteam.landcloud.core.service.user.UserAreaServiceImpl;
import com.geoway.landteam.landcloud.core.servface.user.UserNameService;
import com.geoway.landteam.landcloud.core.service.user.impl.UserManageServiceImpl;
import com.geoway.landteam.landcloud.core.service.util.CoordTranUtil;
import com.geoway.landteam.landcloud.core.service.util.LandUserBuilder;
import com.geoway.landteam.landcloud.core.service.util.Md5Util;
import com.geoway.landteam.landcloud.core.service.util.XzqdmUtil;
import com.geoway.landteam.landcloud.multitask.mapper.pub.DataBizMapper;
import com.geoway.landteam.landcloud.servface.customtask.task.*;

import cn.hutool.core.collection.ListUtil;
import com.geoway.landteam.landcloud.service.pub.TbsysBhmanagerService;
import com.geoway.landteam.patrolclue.dao.cluelibrary.JcClueFilterDao;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueFilter;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.gw.base.log.GwLoger;
import com.gw.base.log.GiLoger;
/*import com.gw.base.data.GwValidateException;*/
import com.gw.base.data.GwValidateException;
import com.gw.base.util.GutilAssert;
import com.gw.base.util.GutilCollection;
import com.gw.base.util.GutilStr;
import jxl.CellType;
import lombok.val;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.poi.ss.usermodel.*;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.javatuples.Triplet;
import org.locationtech.jts.geom.*;
import org.locationtech.jts.io.ParseException;

import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.jexl3.*;
import org.apache.commons.lang3.tuple.Pair;
import org.geotools.data.FeatureSource;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.locationtech.jts.io.WKTReader;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletRequest;
import java.io.*;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.sql.*;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;


/**
 * @ClassName TskTaskBizService
 * @Description @TODO
 * @Author songzongqiang
 * @Date 2019/10/18 17:53
 * @Version v1.0
 **/
@Service
public class MTskTaskBizService {
    private final GiLoger logger = GwLoger.getLoger(MTskTaskBizService.class);

    private final static String SHAPE_APPEND = "0";
    private final static String SHAPE_UPDATE = "1";
    private static final Integer MAX_SUBTB_INDEX = 99;
    private final GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory(null);
    // 批量提交数量
    private final int BATCH_COMMIT_COUNT = 100;
    @Value("${project.uploadDir}")
    protected String uploadDir;

    @Value("${traffic-light.green:1}")
    Integer greenDay;

    @Value("${traffic-light.yellow:2}")
    Integer yellowDay;

    @Autowired
    TskTaskBizRepository tskTaskBizRepository;
    @Autowired
    TbsysBhmanagerService tbsysBhmanagerService;
    @Autowired
    TbtskAuditAssignRecordRepository tbtskAuditAssignRecordRepository;
    @Autowired
    User2BizRepository user2BizRepository;
    @Autowired
    TbtskTaskMenuRepository tbtskTaskMenuRepository;

    @Autowired
    DataBizMapper dataBizMapper;
    @Autowired
    TskTaskBizService tskTaskBizService;
    @Autowired
    TbtskUserReviewAreaService tbtkUserReviewAreaService;
    @Autowired
    TskAssignRecordRepository tskAssignRecordRepository;
    @Autowired
    RegionVersionRepository regionVersionRepository;
    @Autowired
    TbtskObjectinfoRepository tbtskObjectinfoRepository;
    @Autowired
    TbtskFieldsRepository tbtskFieldsRepository;
    @Autowired
    SysConfigService sysConfigService;
    @Autowired
    MTbtskTaskClassService mTbtskTaskClassService;
    @Autowired
    TbtskUserTaskClassRepository tbtskUserTaskClassRepository;
    @Autowired
    RegionRepository regionDao;
    @Autowired
    RegionTownRepository regionTownRepository;
    @Autowired
    RegionVillageRepository regionvillageDao;
    @Autowired
    TbtskTemplateRepository tbtskTemplateRepository;
    @Autowired
    TbtskApproveRecordRepository tbtskApproveRecordRepository;
    @Autowired
    TemporarySignedUrlService temporarySignedUrlService;
    @Autowired
    MTbtskFlowService MTbtskFlowService;
    @Autowired
    TbtskFieldsGroupViewRepository tbtskFieldsGroupViewRepository;
    @Autowired
    TbtskGroupRepository tbtskGroupRepository;
    @Autowired
    MDataBizService mDataBizService;
    @Autowired
    LandUser2AreaRepository userAreaDao;
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    UserBiz2Repository userBiz2Repository;
    @Autowired
    BizAreaRepository bizAreaRepository;
    @Autowired
    TskRightAreaRepository tskRightAreaRepository;
    @Autowired
    TskRightAreaRegRepository tskRightAreaRegRepository;
    @Autowired
    StringRedisTemplate redisTemplate;
    @Autowired
    RegionService regionService;
    @Autowired
    RegionDJQRepository regionDJQRepository;
    @Autowired
    MTaskNoticeService mTaskNoticeService;
    @Autowired
    MTaskNoticeNewService mTaskNoticeNewService;
    @Autowired
    NoticeSubscribeRepository noticeSubscribeRepository;
    @Autowired
    NoticeTopicRepository noticeTopicRepository;
    @Autowired
    TbtskFlowDefRepository tbtskFlowDefRepository;
    @Autowired
    MTbtskFieldsService fieldsService;
    @Autowired
    UserManageServiceImpl userManageService;
    /* @Autowired
     ElasticsearchService elasticsearchService;*/
    @Autowired
    OssConfigRepository ossConfigDao;
    @Autowired
    TaskRecordRepository taskRecordRepository;
    @Autowired
    DataDownloadRecordRepository dataDownloadRecordRepository;
    @Autowired
    TbgstRepository tbgstRepository;
    @Autowired
    DefaultOssOperatorService ossOperatorService;
    @Autowired
    MTbtskObjectinfoService mTbtskObjectinfoService;
    @Autowired
    UserNameService userNameService;
    @Autowired
    LandUserRepository landUserRepository;
    @Autowired
    UserAreaServiceImpl userAreaService;
    @Autowired
    MTbtskUserManageAreaService tbtskUserManageAreaService;
    @Autowired
    MTbtskUserUploadAreaService tbtskUserUploadAreaService;
    @Autowired
    MTbtskUserAuditAreaService tbtskUserAuditAreaService;
    @Autowired
    MTbtskSuperUserAuditAreaService tbtskSuperUserAuditAreaService;
    @Autowired
    MTbtskUserReviewAreaService tbtskUserReviewAreaService;
    @Autowired
    TbtskTaskClassRepository tbtskTaskClassRepository;
    @Autowired
    AppMediaRepository appMediaRepository;
    @Autowired
    TbtsktaskCopyRepository tbtsktaskCopyRepository;
    @Autowired
    private LandUser2AreaRepository landUser2AreaRepository;
    @Autowired
    LandUserService landUserService;

    @Autowired
    AppMediaService appMediaService;
    @Autowired
    JcClueFilterDao jcClueFilterDao;

    @Autowired
    MTskTaskSyncService mTskTaskSyncService;



    //管理区table名称
    static final String GLY_TABLE_NAME = "tbtsk_user_manage_area";
    //审核区table名称
    static final String SHY_TABLE_NAME = "tbtsk_user_audit_area";
    //作业区复核区table名称table名称
    static final String ZYY_TABLE_NAME = "tbtsk_right_area";
    //复核区table名称
    static final String FHY_TABLE_NAME = "tbtsk_user_review_area";
    //超级审核区table名称
    static final String CJSHY_TABLE_NAME = "tbtsk_super_user_audit_area";
    //超级审核区table名称
    static final String SCY_TABLE_NAME = "tbtsk_user_upload_area";


    // 字符串转二进制
    public static byte[] hex2byte(String str) {
        if (str == null) return null;
        str = str.trim();
        int len = str.length();
        if (len == 0 || len % 2 == 1) return null;
        byte[] b = new byte[len / 2];
        try {
            for (int i = 0; i < str.length(); i += 2) {
                b[i / 2] = (byte) Integer.decode("0X" + str.substring(i, i + 2)).intValue();
            }
            return b;
        } catch (Exception e) {
            return null;
        }
    }

    /**
     * 将二进制转换成图片保存
     *
     * @param imgStr  二进制流转换的字符串
     * @param imgPath 图片的保存路径
     * @param imgName 图片的名称
     * @return 1：保存正常
     * 0：保存失败
     */
    public static int saveToImgByStr(String imgStr, String imgPath, String imgName) {
        try {
            System.out.println("===imgStr.length()====>" + imgStr.length()
                    + "=====imgStr=====>" + imgStr);
        } catch (Exception e) {
            e.printStackTrace();
        }
        int stateInt = 1;
        if (imgStr != null && imgStr.length() > 0) {
            try {

                // 将字符串转换成二进制，用于显示图片
                // 将上面生成的图片格式字符串 imgStr，还原成图片显示
                byte[] imgByte = hex2byte(imgStr);

                InputStream in = new ByteArrayInputStream(imgByte);

                File file = new File(imgPath, imgName);//可以是任何图片格式.jpg,.png等
                FileOutputStream fos = new FileOutputStream(file);

                byte[] b = new byte[1024];
                int nRead = 0;
                while ((nRead = in.read(b)) != -1) {
                    fos.write(b, 0, nRead);
                }
                fos.flush();
                fos.close();
                in.close();

            } catch (Exception e) {
                stateInt = 0;
                e.printStackTrace();
            } finally {
            }
        }
        return stateInt;
    }

    /**
     * 将二进制转换成图片保存
     *
     * @param imgFile 二进制流转换的字符串
     * @param imgPath 图片的保存路径
     * @param imgName 图片的名称
     * @return 1：保存正常
     * 0：保存失败
     */
    public static int saveToImgByBytes(File imgFile, String imgPath, String imgName) {

        int stateInt = 1;
        if (imgFile.length() > 0) {
            try {
                File file = new File(imgPath, imgName);//可以是任何图片格式.jpg,.png等
                FileOutputStream fos = new FileOutputStream(file);

                FileInputStream fis = new FileInputStream(imgFile);

                byte[] b = new byte[1024];
                int nRead = 0;
                while ((nRead = fis.read(b)) != -1) {
                    fos.write(b, 0, nRead);
                }
                fos.flush();
                fos.close();
                fis.close();

            } catch (Exception e) {
                stateInt = 0;
                e.printStackTrace();
            } finally {
            }
        }
        return stateInt;
    }

    public static boolean isJson(String content) {
        try {
            JSONObject.parseObject(content);
            return true;
        } catch (Exception e) {
            return false;
        }
    }

    public Integer getBizManageLevel(Long userId, String bizId) {
        List<UserBiz2> list = userBiz2Repository.findByUserIdOrderRoleAsc(userId, bizId);
        Integer level = 10;
        if (list != null && list.size() > 0) {
            level = list.get(0).getRole();
        }
        return level;
    }

    public Boolean getUserIsManager(Long userId, String bizId) {
        List<UserBiz2> userBiz2List = userBiz2Repository.findByUserIdAndBizIdAndRole(userId, bizId, 1);
        return userBiz2List != null && userBiz2List.size() > 0;
    }

    public Boolean getUserIsCreator(Long userId, String bizId) {
        List<UserBiz2> userBiz2List = userBiz2Repository.findByUserIdAndBizIdAndRole(userId, bizId, 0);
        return userBiz2List != null && userBiz2List.size() > 0;
    }

    public Page<TskTaskBiz> findPages(String filterParam, String sortParam, int start, int limit) {
        return tskTaskBizRepository.findAll(new QuerySpecification<TskTaskBiz>(filterParam),
                PageRequest.of(start, limit, QueryParamUtil.parseSortParams(sortParam)));
    }

    public List<TskTaskBiz> findPages2(String filterParam, String sortParam) {
        return tskTaskBizRepository.findAll(new QuerySpecification<TskTaskBiz>(filterParam),
                QueryParamUtil.parseSortParams(sortParam));
    }

    public Page<TskTaskBiz> findPagesByUserId(Long userId, String sortParam, int start, int limit) {
        return tskTaskBizRepository.findBizPermissionByUserId(userId,
                PageRequest.of(start, limit, QueryParamUtil.parseSortParams(sortParam)));
    }

    public List<TskTaskBiz> findBizByDataUserId(String userId) {
        List<TskTaskBiz> list = tskTaskBizRepository.findBizByDataUserId(userId);
        for (TskTaskBiz biz : list) {
            Integer myTotal = tskAssignRecordRepository.countByAssigntoAndTaskId(userId, biz.getId());
            Integer myCommit = tskAssignRecordRepository.countByAssigntoAndTaskIdAndStatus(userId, biz.getId(), "1");
            biz.setMyCount(myTotal);
            biz.setCommitCount(myCommit);
        }
        return list;
    }

    public List<TskTaskBiz> findBizByUserId(String userId) {
        List<TskTaskBiz> list = tskTaskBizRepository.findBizByDataUserId(userId);
        return list;
    }

    public List<TskTaskBiz> findAll(String filterParam, String sortParam) {
        return tskTaskBizRepository.findAll(new QuerySpecification<TskTaskBiz>(filterParam), QueryParamUtil.parseSortParams(sortParam));
    }

    private void saveFields(TbtskObjectinfo tableInfo, String name, String type, String length, String flength,
                            String notNull, String isBase, String isOutwork, String rname, String order,
                            String isListShow, String isWebCheck, String isWebEdit, String isStatis, Integer fieldType, Boolean isSysField) {
        TbtskFields tbField = new TbtskFields();
        tbField.setfAlias(rname);
        tbField.setfFieldname(name);
        tbField.setfFieldtype(type);

        if (StringUtils.isNotBlank(order)) {
            tbField.setfOrder(Integer.parseInt(order));
        }

        if (StringUtils.isNotBlank(length)) {
            tbField.setfLength(Integer.parseInt(length));
        }
        if (StringUtils.isNotBlank(flength)) {
            tbField.setfPrecision(Integer.parseInt(flength));
        }

        if ("true".equals(notNull)) {
            tbField.setfNullable(0);
        } else {
            tbField.setfNullable(1);
        }
        if ("true".equals(isBase)) {
            tbField.setfIsBase(1);
        } else {
            tbField.setfIsBase(0);
        }
        if ("true".equals(isOutwork)) {
            tbField.setfIsOutwork(1);
        } else {
            tbField.setfIsOutwork(0);
        }
        if ("true".equals(isListShow)) {
            tbField.setfIsListShow(1);
        } else {
            tbField.setfIsListShow(0);
        }
        if ("true".equals(isWebCheck)) {
            tbField.setfIsWebCheck(1);
        } else {
            tbField.setfIsWebCheck(0);
        }
        if ("true".equals(isWebEdit)) {
            tbField.setfIsWebEdit(1);
        } else {
            tbField.setfIsWebEdit(0);
        }
        if ("true".equals(isStatis)) {
            tbField.setfIsStatis(1);
        } else {
            tbField.setfIsStatis(0);
        }

        tbField.setfFieldInnerOuterSys(fieldType);


        // 因为app更新
        if ("int4".equals(type) && isSysField) {
            tbField.setfDefaultvalue("0");
        }

        tbField.setfTablename(tableInfo.getfTablename());
        tbField.setfTableid(tableInfo.getfId());

        TbtskFields tf = tbtskFieldsRepository.save(tbField);

        //基础字段
        saveGroup(tf, "1", order, tableInfo.getfTablename());

        //web端列表展示
        if ("true".equals(isListShow)) {
            saveGroup(tf, "0", order, tableInfo.getfTablename());
        }

        //web端核查
        if ("true".equals(isWebCheck)) {
            saveGroup(tf, "3", order, tableInfo.getfTablename());
        }

        //统计字段
        if ("true".equals(isStatis)) {
            saveGroup(tf, "4", order, tableInfo.getfTablename());
        }
    }

    private String createDB(String bizId, String userId, String type) {
        TskTaskBiz task = findByTaskId(bizId);
        TbtskObjectinfo table = findTableByTaskId(bizId);
        Connection conn = null;
        Statement statement = null;
        String dbUrl = "";
        try {
            // 01.先根据 taskids 生成数据db
            String fileName = UUID.randomUUID() + ".db";
           // uploadDir = (String) ProjectConfig.getConfig(ProjectConfigEnum.UPLOAD_DIR.getKey());
            String filePath = uploadDir + File.separator + fileName;
            SqlliteConnTool tool = new SqlliteConnTool(filePath);
            conn = tool.getConnection();
            statement = conn.createStatement();

            // 生产表信息和字段信息
            TaskDBUtils.createInfo(tskTaskBizService, table, task, statement, type);
            // 生成图斑表
            TaskDBUtils.createTable(tskTaskBizService, table, task,statement);

            // 关闭连接
            tool.closeAll(conn, statement, null);

            // 上传db包到oss上
            Long date = System.currentTimeMillis();
            String key = String.format("taskManagerDB/%s/%s.db", userId, date);
            dbUrl = ossOperatorService.sendObject2Oss(key, new File(filePath));
        } catch (Exception e) {
            e.printStackTrace();
            logger.error("createDB:" + e.getMessage());
        }
        return dbUrl;
    }

    private void saveGroup(TbtskFields tf, String groupCode, String order, String tableName) {
        TbtskGroup group = new TbtskGroup();
        group.setfAlias(tf.getfAlias());
        group.setfFieldid(tf.getfId());
        group.setfFieldname(tf.getfFieldname());
        group.setfFieldtype(tf.getfFieldtype());

        if (StringUtils.isNotBlank(order)) {
            group.setfFieldorder(Integer.parseInt(order));
        }

        group.setfGroupcode(groupCode);
        group.setfSyscode("web");
        group.setfTablename(tableName);
        if (1 == tf.getfIsBase()) {
            group.setfBiztype(201);
        }
        if (1 == tf.getfIsOutwork()) {
            group.setfBiztype(202);
        }

        if (1 == tf.getfIsWebEdit()) {
            group.setfCode(3);
        } else {
            group.setfCode(0);
        }

        tbtskGroupRepository.save(group);
    }

    private void addDefField(StringBuffer sb, TbtskObjectinfo tableInfo) {
        sb.append("f_id varchar(100) NOT NULL DEFAULT NULL,");
        sb.append("f_status int4 NOT NULL DEFAULT NULL,");
        sb.append("f_shape geometry NOT NULL,");
        sb.append("f_shape1 geometry,");
        sb.append("f_ismycreate int4 NOT NULL DEFAULT NULL,");
        sb.append("f_createtime varchar(100) NOT NULL DEFAULT NULL,");
        sb.append("f_updatetime varchar(100) ,");
        sb.append("f_requestid varchar(100),");
        sb.append("f_jhid varchar(100),");
        sb.append("f_xsrwid varchar(100),");
        sb.append("f_xmid varchar(100),");
        sb.append("f_sfzdsx varchar(100),");

        sb.append("f_tbmc varchar(100) NOT NULL DEFAULT NULL,");
        sb.append("f_tbbh varchar(100) NOT NULL,");
        sb.append("f_tbmj decimal(12,2) NOT NULL,");
        sb.append("f_xzqdmsys varchar(20),"); //政区数据村
        sb.append("f_xzqdm varchar(20) NOT NULL,");//政区数据
        sb.append("f_xzqdmcity varchar(20) NOT NULL,");//政区数据市
        sb.append("f_xzqdmcounty varchar(20) NOT NULL,");//政区数据县
        sb.append("f_xzqdmtown varchar(20) NOT NULL,");//政区数据乡镇
        sb.append("f_xzqmc1 varchar(100),");
        sb.append("f_xzqmc varchar(100),");

        sb.append("f_lat decimal(12,6),");
        sb.append("f_lon decimal(12,6),");

        sb.append("f_sign text,");
        sb.append("f_committime varchar(100),");
        sb.append("f_approvetime varchar(100),");
        sb.append("f_typical varchar(100),");
        sb.append("f_userid varchar(100) NOT NULL,");
        sb.append("f_upload_userid varchar(100),");

        //是否是自己的图斑app端使用
        sb.append("f_ismy int4 NOT NULL DEFAULT NULL,");

        //百度地图坐标
        sb.append("f_shape_b geometry,");
        sb.append("f_lat_b decimal(12,6),");
        sb.append("f_lon_b decimal(12,6),");
        //谷歌地图坐标
        sb.append("f_shape_g geometry,");
        sb.append("f_lat_g decimal(12,6),");
        sb.append("f_lon_g decimal(12,6),");
        //提报时间
        sb.append("f_submittime varchar(100) ,");

        // 4
        saveFields(tableInfo, "f_id", "varchar", "100",
                null, "true", "false", "false", "主键", null,
                "false", "false", "false", "false", FieldGroupTypeConstant.SYSTEM_FIELD, true);
        saveFields(tableInfo, "f_status", "int4", null,
                null, "true", "false", "false", "状态", null,
                "true", "false", "false", "false", FieldGroupTypeConstant.SYSTEM_FIELD, true);

        saveFields(tableInfo, "f_ismycreate", "int4", null,
                null, "true", "false", "false", "是否自己创建", null,
                "false", "false", "false", "false", FieldGroupTypeConstant.SYSTEM_FIELD, true);

        saveFields(tableInfo, "f_requestid", "varchar", "100",
                null, "false", "false", "false", "云查询id", null,
                "false", "false", "false", "false", FieldGroupTypeConstant.SYSTEM_FIELD, true);
        saveFields(tableInfo, "f_sfzdsx", "varchar", "100",
                null, "false", "false", "false", "是否重大事项", null,
                "false", "false", "false", "false", FieldGroupTypeConstant.SYSTEM_FIELD, true);
        saveFields(tableInfo, "f_jhid", "varchar", "100",
                null, "false", "false", "false", "计划id", null,
                "false", "false", "false", "false", FieldGroupTypeConstant.SYSTEM_FIELD, true);
        saveFields(tableInfo, "f_xsrwid", "varchar", "100",
                null, "false", "false", "false", "线索任务id", null,
                "false", "false", "false", "false", FieldGroupTypeConstant.SYSTEM_FIELD, true);
        saveFields(tableInfo, "f_xmid", "varchar", "100",
                null, "false", "false", "false", "项目id", null,
                "false", "false", "false", "false", FieldGroupTypeConstant.SYSTEM_FIELD, true);
        saveFields(tableInfo, "f_ismy", "int4", null,
                null, "true", "false", "false", "是否自己图斑（app端使用）", null,
                "false", "false", "false", "false", FieldGroupTypeConstant.SYSTEM_FIELD, true);
        saveFields(tableInfo, "f_xzqdmsys", "varchar", "20",
                null, "false", "false", "false", "行政区代码村(系统)", "",
                "true", "false", "false", "false", FieldGroupTypeConstant.SYSTEM_FIELD, true);
        saveFields(tableInfo, "f_xzqdmcity", "varchar", "20",
                null, "false", "false", "false", "行政区代码市(系统)", "",
                "true", "false", "false", "false", FieldGroupTypeConstant.SYSTEM_FIELD, true);
        saveFields(tableInfo, "f_xzqdmcounty", "varchar", "20",
                null, "false", "false", "false", "行政区代码县(系统)", "",
                "true", "false", "false", "false", FieldGroupTypeConstant.SYSTEM_FIELD, true);
        saveFields(tableInfo, "f_xzqdmtown", "varchar", "20",
                null, "false", "false", "false", "行政区代码镇(系统)", "",
                "true", "false", "false", "false", FieldGroupTypeConstant.SYSTEM_FIELD, true);

        // 1 纯内业 (调整)
        saveFields(tableInfo, "f_tbmc", "varchar", "100",
                null, "true", "true", "false", "图斑名称", "0",
                "true", "false", "false", "false", FieldGroupTypeConstant.INNER_FIELD, true);
        saveFields(tableInfo, "f_tbbh", "varchar", "100",
                null, "true", "true", "false", "图斑编号", "1",
                "true", "false", "false", "false", FieldGroupTypeConstant.INNER_FIELD , true);
        saveFields(tableInfo, "f_xzqdm", "varchar", "20",
                null, "true", "true", "false", "行政区代码", "3",
                "true", "false", "false", "false", FieldGroupTypeConstant.INNER_FIELD , true);
        saveFields(tableInfo, "f_xzqmc1", "varchar", "100",
                null, "false", "true", "false", "行政区名称(系统)", "4",
                "true", "false", "false", "false", FieldGroupTypeConstant.INNER_FIELD+ FieldGroupTypeConstant.SYSTEM_FIELD , true);
        saveFields(tableInfo, "f_xzqmc", "varchar", "100",
                null, "false", "true", "false", "行政区名称", "4",
                "true", "false", "false", "false", FieldGroupTypeConstant.INNER_FIELD , true);
        saveFields(tableInfo, "f_tbmj", "decimal", "12",
                "2", "true", "true", "false", "图斑面积(亩)", "2",
                "true", "false", "false", "false", FieldGroupTypeConstant.INNER_FIELD , true);

        // 1 + 4 内业 + 系统
        saveFields(tableInfo, "f_shape", "geometry", null,
                null, "true", "false", "false", "shape", null,
                "false", "false", "false", "false", FieldGroupTypeConstant.INNER_FIELD + FieldGroupTypeConstant.SYSTEM_FIELD, true);
        saveFields(tableInfo, "f_shape1", "geometry", null,
                null, "false", "false", "false", "shape", null,
                "false", "false", "false", "false", FieldGroupTypeConstant.INNER_FIELD + FieldGroupTypeConstant.SYSTEM_FIELD, true);
        saveFields(tableInfo, "f_lat", "decimal", "12",
                "6", "false", "false", "false", "中心点Y坐标", null,
                "false", "false", "false", "false", FieldGroupTypeConstant.INNER_FIELD + FieldGroupTypeConstant.SYSTEM_FIELD, true);
        saveFields(tableInfo, "f_lon", "decimal", "12",
                "6", "false", "false", "false", "中心点X坐标", null,
                "false", "false", "false", "false", FieldGroupTypeConstant.INNER_FIELD + FieldGroupTypeConstant.SYSTEM_FIELD, true);
        saveFields(tableInfo, "f_shape_b", "geometry", null,
                null, "false", "false", "false", "百度shape", null,
                "false", "false", "false", "false", FieldGroupTypeConstant.INNER_FIELD + FieldGroupTypeConstant.SYSTEM_FIELD, true);
        saveFields(tableInfo, "f_lat_b", "decimal", "12",
                "6", "false", "false", "false", "百度中心点Y坐标", null,
                "false", "false", "false", "false", FieldGroupTypeConstant.INNER_FIELD + FieldGroupTypeConstant.SYSTEM_FIELD, true);
        saveFields(tableInfo, "f_lon_b", "decimal", "12",
                "6", "false", "false", "false", "百度中心点X坐标", null,
                "false", "false", "false", "false", FieldGroupTypeConstant.INNER_FIELD + FieldGroupTypeConstant.SYSTEM_FIELD, true);

        saveFields(tableInfo, "f_shape_g", "geometry", null,
                null, "false", "false", "false", "谷歌shape", null,
                "false", "false", "false", "false", FieldGroupTypeConstant.INNER_FIELD + FieldGroupTypeConstant.SYSTEM_FIELD, true);
        saveFields(tableInfo, "f_lat_g", "decimal", "12",
                "6", "false", "false", "false", "谷歌中心点Y坐标", null,
                "false", "false", "false", "false", FieldGroupTypeConstant.INNER_FIELD + FieldGroupTypeConstant.SYSTEM_FIELD, true);
        saveFields(tableInfo, "f_lon_g", "decimal", "12",
                "6", "false", "false", "false", "谷歌中心点X坐标", null,
                "false", "false", "false", "false", FieldGroupTypeConstant.INNER_FIELD + FieldGroupTypeConstant.SYSTEM_FIELD, true);
        saveFields(tableInfo, "f_userid", "varchar", "100",
                null, "true", "false", "false", "操作人", null,
                "false", "false", "false", "false", FieldGroupTypeConstant.SYSTEM_FIELD + FieldGroupTypeConstant.INNER_FIELD, true);
        saveFields(tableInfo, "f_createtime", "varchar", "100",
                null, "true", "false", "false", "创建时间", null,
                "false", "false", "false", "false", FieldGroupTypeConstant.SYSTEM_FIELD + FieldGroupTypeConstant.INNER_FIELD, true);
        saveFields(tableInfo, "f_updatetime", "varchar", "100",null, "false", "false", "false", "更新时间", null,
                "false", "false", "false", "false", FieldGroupTypeConstant.SYSTEM_FIELD + FieldGroupTypeConstant.INNER_FIELD, true);
        saveFields(tableInfo, "f_approvetime", "varchar", "100",null, "false", "false", "false", "审核时间", null,
                "false", "false", "false", "false", FieldGroupTypeConstant.SYSTEM_FIELD + FieldGroupTypeConstant.INNER_FIELD, true);
        saveFields(tableInfo, "f_typical", "varchar", "100",null, "false", "false", "false", "典型问题", null,
                "false", "false", "false", "false", FieldGroupTypeConstant.SYSTEM_FIELD + FieldGroupTypeConstant.INNER_FIELD, true);

        // 2 + 4 外业 + 系统
        saveFields(tableInfo, "f_sign", "text", null,
                null, "false", "false", "false", "签名", null,
                "false", "false", "false", "false", FieldGroupTypeConstant.SYSTEM_FIELD + FieldGroupTypeConstant.OUTER_FIELD, true);

        saveFields(tableInfo, "f_committime", "varchar", "100",
                null, "false", "false", "false", "提交时间", null,
                "true", "false", "false", "false", FieldGroupTypeConstant.SYSTEM_FIELD + FieldGroupTypeConstant.OUTER_FIELD, true);

        saveFields(tableInfo, "f_upload_userid", "varchar", "100",
                null, "true", "false", "false", "执行人员", null,
                "false", "false", "false", "false", FieldGroupTypeConstant.SYSTEM_FIELD + FieldGroupTypeConstant.OUTER_FIELD, true);
        //增加提报时间字段
        saveFields(tableInfo, "f_submittime", "varchar", "100",
                null, "true", "false", "false", "提报时间", null,
                "false", "false", "false", "false", FieldGroupTypeConstant.SYSTEM_FIELD + FieldGroupTypeConstant.INNER_FIELD, true);

    }

    @Transactional
    public TskTaskBiz editTskTaskBiz(TskTaskBiz taskBiz, Set<String> glys, Set<String> shys, Set<String> zyys, String codes) {
        TskTaskBiz biz = tskTaskBizRepository.findById(taskBiz.getId()).orElse(null);

        if (StringUtils.isNotBlank(taskBiz.getName())) {
            biz.setName(taskBiz.getName());
        }

        if (StringUtils.isNotBlank(taskBiz.getDesc())) {
            biz.setDesc(taskBiz.getDesc());
        }

        if (taskBiz.getStartTime() != null) {
            biz.setStartTime(taskBiz.getStartTime());
        }

        if (taskBiz.getEndTime() != null) {
            biz.setEndTime(taskBiz.getEndTime());
        }

        if (StringUtils.isNotBlank(taskBiz.getWorkflowType())) {
            biz.setWorkflowType(taskBiz.getWorkflowType());
        }

        if (StringUtils.isNotBlank(taskBiz.getAllowNew())) {
            biz.setAllowNew(taskBiz.getAllowNew());
        }

        if (StringUtils.isNotBlank(taskBiz.getNeedSign())) {
            biz.setNeedSign(taskBiz.getNeedSign());
        }

        if (StringUtils.isNotBlank(taskBiz.getSource())) {
            biz.setSource(taskBiz.getSource());
        }

        if (taskBiz.getMode() != null) {
            biz.setMode(taskBiz.getMode());
        }

        TskTaskBiz tb = tskTaskBizRepository.save(biz);

        // 设置任务管理员
        userBiz2Repository.deleteByBizIdAndRole(taskBiz.getId(), 1);
        for (String userIdStr : glys) {
            saveUserBiz(Long.parseLong(userIdStr), taskBiz.getId(), 1);
        }

        // 设置任务审核员
        userBiz2Repository.deleteByBizIdAndRole(taskBiz.getId(), 2);
        for (String userIdStr : shys) {
            saveUserBiz(Long.parseLong(userIdStr), taskBiz.getId(), 2);
        }

        // 设置任务作业员 只有在线监管任务和智能管理任务的领取模式才需要重新设置作业员
        if ("1".equals(taskBiz.getType()) || 2 == taskBiz.getMode()) {
            userBiz2Repository.deleteByBizIdAndRole(taskBiz.getId(), 3);
            for (String userIdStr : zyys) {
                saveUserBiz(Long.parseLong(userIdStr), taskBiz.getId(), 3);
            }
        }

        bizAreaRepository.deleteByBizId(taskBiz.getId());
        saveBizAreaData(taskBiz.getId(), "", codes);
        return tb;
    }

    public Boolean checkTaskName(String name, String taskId,String classId) {
        boolean tag = false;
        List<TskTaskBiz> list = tskTaskBizRepository.findByTaskName(name);
        if (list != null && list.size() > 0) {
            TskTaskBiz biz = list.get(0);
            if(org.apache.commons.lang3.StringUtils.isNotBlank(classId) && !biz.getClassId().toString().equals(classId)){
                tag = true;
            }else{
                if (taskId == null || !biz.getId().equals(taskId)) {
                    tag = true;

                }
            }
        }
        return tag;
    }

    public Boolean checkTaskTemplateName(String name, String taskId,String classId) {
        boolean tag = false;
        List<TskTaskBiz> list = tskTaskBizRepository.findByTemplateName(name);
        if (list != null && list.size() > 0) {
            TskTaskBiz biz = list.get(0);
            if(org.apache.commons.lang3.StringUtils.isNotBlank(classId) && !biz.getClassId().toString().equals(classId)){
                tag = true;
            }else{
                if (taskId == null || !biz.getId().equals(taskId)) {
                    tag = true;
                }
            }
        }
        return tag;
    }

    @Transactional
    public TskTaskBiz addTskTaskBiz(Long userId, String filedTmpl,
                                    TskTaskBiz taskBiz, Set<String> glys, Set<String> shys,
                                    Set<String> zyys, String codes, List<String> uniqueFields) {

        // 创建数据库表sql
        StringBuffer creatTableSql = new StringBuffer("CREATE TABLE ");

        // 表名称
        String tableName = TskTaskBizDBUtil.generateTableName(taskBiz.getType());
        creatTableSql.append(tableName).append(" (");

        // 保存‘创建数据库表’信息
        TbtskObjectinfo tableInfo = saveTableInfo(tableName, taskBiz);

        // 保存‘数据库表字段’信息

        // 使用模板
        TskTaskBiz biz = tskTaskBizRepository.findById(filedTmpl).orElse(null);
        taskBiz.setNeedSign(biz.getNeedSign());
        taskBiz.setAllowNew(biz.getAllowNew());
        taskBiz.setAllowEdit(biz.getAllowEdit());

        if (StringUtils.isNotBlank(biz.getWorkflowType())) {
            taskBiz.setWorkflowType(biz.getWorkflowType());
        }

        if (StringUtils.isNotBlank(biz.getDataUrl())) {
            taskBiz.setDataUrl(biz.getDataUrl());
        }
        String filedSql = coyeTableFileds(biz, tableInfo, uniqueFields);
        creatTableSql.append(filedSql);

        //creatTableSql.deleteCharAt(creatTableSql.length() - 1);
        creatTableSql.append("primary key(f_id));");

        //创建索引: 行政区划代码索引(B-Tree索引) shape字段索引(GiST类型) 用户id索引(B-Tree索引)
        creatTableSql.append(MessageFormat.format("CREATE INDEX {0}_xzqdm_idx ON {0} ({1});", tableName, "f_xzqdm"));
        //creatTableSql.append(MessageFormat.format("CREATE INDEX {0}_shape_idx ON {0} USING GIST ({1});", tableName, "f_shape"));
        creatTableSql.append(MessageFormat.format("CREATE INDEX {0}_userid_idx ON {0} ({1});", tableName, "f_userid"));

        // 创建数据库表
        exeCreateTable(creatTableSql.toString());

        // 保存任务
        taskBiz.setTemplateId(filedTmpl);
        taskBiz.setTableId(tableInfo.getfId());
        taskBiz.setUserId(userId.toString());
        taskBiz.setCreateTime(new Date());
        taskBiz.setStatus("1");
        taskBiz.setTotal(0);
        //taskBiz.setSource(orgName);
        taskBiz.setAssignCount(0);
        taskBiz.setIsPublic(0);
        if ("1".equals(taskBiz.getType())) {
            taskBiz.setScope("在线监管");
        } else if ("2".equals(taskBiz.getType())) {
            taskBiz.setScope("智能管理");
        }
        TskTaskBiz tskTaskBiz = tskTaskBizRepository.save(taskBiz);

        // 设置任务管理员 如果管理员json长度为0则默认为本单位下的所有管理员用户
        // 如果没有创建者 则把创建者加进管理员内
        glys.add(userId.toString());
        for (String userIdStr : glys) {
            saveUserBiz(Long.parseLong(userIdStr), taskBiz.getId(), 1);
        }


        // 设置任务审核员 如果管理员json长度为0则默认为本单位下的所有联络员用户
        for (String userIdStr : shys) {
            saveUserBiz(Long.parseLong(userIdStr), taskBiz.getId(), 2);
        }

        // 设置任务作业员 如果管理员json长度为0则默认为本单位下的所有用户
        for (String userIdStr : zyys) {
            saveUserBiz(Long.parseLong(userIdStr), taskBiz.getId(), 3);
            if ("1".equals(taskBiz.getType()) || 2 == taskBiz.getMode()) {

            }
        }


        // 设置任务创建者
        saveUserBiz(userId, taskBiz.getId(), 0);

        //saveBizAreaData(taskBiz.getId(), "", codes);

        return tskTaskBiz;
    }

    @Transactional
    public TskTaskBiz addTaskTemplate(Long userId, String codes, JSONObject data) {

        // 创建数据库表sql
        StringBuffer creatTableSql = new StringBuffer("CREATE TABLE ");

        JSONObject taskObj = data.getJSONObject("taskBiz");

        String filedTmpl = taskObj.getString("filedTmpl");
        String fileds = taskObj.getString("fileds");

        TskTaskBiz taskBiz = JSONObject.parseObject(taskObj.toString(), TskTaskBiz.class);

        // 表名称
        String tableName = TskTaskBizDBUtil.generateTableName(taskBiz.getType());
        creatTableSql.append(tableName).append(" (");

        // 保存‘创建数据库表’信息
        TbtskObjectinfo tableInfo = saveTableInfo(tableName, taskBiz);

        // 保存‘数据库表字段’信息
        if ("0".equals(filedTmpl)) {
            // 默认新增字段
            addDefField(creatTableSql, tableInfo);
            // 自定义
            String filedSql = saveTableFileds(fileds, tableInfo);
            creatTableSql.append(filedSql);
        } else {
            // 使用模板
            TskTaskBiz biz = tskTaskBizRepository.findById(filedTmpl).orElse(null);
            String filedSql = coyeTableFileds(biz, tableInfo, new ArrayList<String>());
            creatTableSql.append(filedSql);
        }
        creatTableSql.append("primary key(f_id));");

        // 模板不需要创建数据库表
        //exeCreateTable(creatTableSql.toString());

        // 保存任务
        taskBiz.setTableId(tableInfo.getfId());
        taskBiz.setUserId(userId.toString());
        taskBiz.setCreateTime(new Date());
        //taskBiz.setStatus("1");
        taskBiz.setTotal(0);
        //taskBiz.setSource(orgName);
        taskBiz.setAssignCount(0);
        taskBiz.setIsPublic(0);
        taskBiz.setIsTmpl(1);
        taskBiz.setGranularity(3);// 默认给县级
        if ("1".equals(taskBiz.getType())) {
            taskBiz.setScope("在线监管");
        } else if ("2".equals(taskBiz.getType())) {
            taskBiz.setScope("智能管理");
        }

        TskTaskBiz tskTaskBiz = tskTaskBizRepository.save(taskBiz);

        saveBizAreaData(tskTaskBiz.getId(), tskTaskBiz.getTaskArea(), codes);

        return tskTaskBiz;
    }

    private void saveBizAreaData(String bizId, String taskArea, String codes) {
        //保存区域
        if (StringUtils.isNotBlank(taskArea)) {
            String[] areas = taskArea.split(",");
            for (int i = 0; i < areas.length; i++) {
                saveBizArea(bizId, areas[i]);
            }
        }
        //默认当前用户的行政区
        if (StringUtils.isNotBlank(codes)) {
            String[] areas = codes.split(",");
            for (int i = 0; i < areas.length; i++) {
                saveBizArea(bizId, areas[i]);
            }
        }
    }

    @Transactional
    public TskTaskBiz editTaskTemplate(TskTaskBiz task, String fileds, String filedTmpl, String codes) {
        TskTaskBiz template = tskTaskBizRepository.findById(task.getId()).orElse(null);
        template.setName(task.getName());
        template.setType(task.getType());
        template.setDesc(task.getDesc());
        template.setSource(task.getSource());
        template.setStartTime(task.getStartTime());
        template.setEndTime(task.getEndTime());
        template.setNeedSign(task.getNeedSign());
        template.setAllowEdit(task.getAllowEdit());
        template.setAllowNew(task.getAllowNew());
        template.setStatus(task.getStatus());
        if (StringUtils.isNotBlank(task.getWorkflowType())) {
            template.setWorkflowType(task.getWorkflowType());
        }

        TbtskObjectinfo tableInfo = tbtskObjectinfoRepository.getObjectByTableId(template.getTableId());
        //******************************** 第一步删除任务的字段信息
        // 删除字段信息
        List<TbtskFields> fields = tbtskFieldsRepository.getTbtskFieldsByTableid(template.getTableId());
        tbtskFieldsRepository.deleteAll(fields);

        // 删除字段权限信息
        tbtskGroupRepository.deleteByFTablename(tableInfo.getfTablename());

        //******************************** 第一步重新生成任务的字段信息
        // 创建数据库表sql
        StringBuffer creatTableSql = new StringBuffer("CREATE TABLE ");
        // 保存‘数据库表字段’信息
        if ("0".equals(filedTmpl)) {
            // 默认新增字段
            addDefField(creatTableSql, tableInfo);
            // 自定义
            String filedSql = saveTableFileds(fileds, tableInfo);
            creatTableSql.append(filedSql);
        } else {
            // 使用模板
            TskTaskBiz biz = tskTaskBizRepository.findById(filedTmpl).orElse(null);
            String filedSql = coyeTableFileds(biz, tableInfo, new ArrayList<>());
            creatTableSql.append(filedSql);
        }

        //先删除任务区域数据
        bizAreaRepository.deleteByBizId(template.getId());

        saveBizAreaData(template.getId(), template.getTaskArea(), codes);

        return tskTaskBizRepository.save(template);
    }

    public void saveBizArea(String bizId, String code) {
        BizArea ba = bizAreaRepository.findByBizIdAndArea(bizId, code);
        if (ba == null) {
            BizArea ba1 = new BizArea();
            ba1.setBizId(bizId);
            ba1.setArea(code);
            bizAreaRepository.save(ba1);
        }
    }

    public void saveUserBiz(Long userId, String taskId, Integer role) {
        List<UserBiz2> ub2List = userBiz2Repository.findByUserIdAndBizIdAndRole(userId, taskId, role);
        if (ub2List == null || (ub2List != null && ub2List.size() == 0)) {
            UserBiz2 ub = new UserBiz2();
            ub.setUserId(userId);
            ub.setBizId(taskId);
            ub.setRole(role);
            userBiz2Repository.save(ub);
        }
        //添加用户业务范围
        TskTaskBiz one = tskTaskBizRepository.findById(taskId).orElse(null);
        TbtskTaskClass one1 = tbtskTaskClassRepository.queryByFId(one.getClassId());
        if (one1 != null) {
            if (one1.getParentId() != -1) {
                one1 = tbtskTaskClassRepository.queryByFId(one1.getParentId());
            }
            List<TbtskUserTaskClass> classList = tbtskUserTaskClassRepository.queryByUserIdAndClassId(userId, one1.getParentId() == -1 ? one1.getId() : one1.getParentId());
            if (classList == null || (classList != null && classList.size() == 0)) {
                TbtskUserTaskClass tbtskUserTaskClass = new TbtskUserTaskClass();
                tbtskUserTaskClass.setUserId(userId);
                tbtskUserTaskClass.setCreateDate(new Date());
                tbtskUserTaskClass.setClassId(one1.getParentId() == -1 ? one1.getId() : one1.getParentId());
                tbtskUserTaskClassRepository.save(tbtskUserTaskClass);
            }
        }

        mTaskNoticeNewService.addSubscribe(userId.toString(), "tsk|" + taskId);
        //新版本消息通知
        //如果配置管理员则根据被配置的人员的政区进行绑定
        if (role == 1) {
            LandUser2Area landUser2Area = userAreaDao.queryOneByUserId(userId);
            if (landUser2Area != null) {
/*
                userManageService.saveNoticeTopicAndNoticeSub(landUser2Area.getRegionCode(), userId.toString(), taskId, role);
*/
            }
        }
        //作业员挂接的政区与任务粒度一致时，应将挂接的政区设为作业区
        if (role == 3) {
            int userLevel = 0;
            //获取用户的行政区
            List<String> userRegions = userAreaDao.queryAreas(userId);
            if (!GutilCollection.isEmpty(userRegions)) {
                String regionCode = userRegions.get(0);
                if ("1".equalsIgnoreCase(regionCode)) {
                    userLevel = 1;
                } else if (regionCode.endsWith("0000")) {
                    userLevel = 2;
                } else if (regionCode.endsWith("00")) {
                    userLevel = 3;
                } else {
                    userLevel = 4;
                }
                TskTaskBiz tskTaskBiz = tskTaskBizRepository.findById(taskId).orElse(null);
                if (tskTaskBiz.getGranularity() == (userLevel - 1)) {
                    //获取用户关于该任务的所有作业区，防止作业区丢失
                    List<String> templist = tskRightAreaRepository.findByTaskIdAndUserId(taskId, userId.toString())
                            .stream().map(r -> r.getXzqdm()).collect(Collectors.toList());
                    String userBizRegionStr = StringUtils.join(templist, ",");
                    changeRightArea(taskId, String.valueOf(userId), userBizRegionStr);
                }
            }
        }
    }

    @Transactional
    public TskTaskBiz addOrUpdateTskTaskBiz(Long userId, TskTaskBiz taskBiz, String filedTmpl, String fileds) {

        // 创建数据库表sql
        StringBuffer creatTableSql = new StringBuffer("CREATE TABLE ");

        // 表名称
        String tableName = TskTaskBizDBUtil.generateTableName(taskBiz.getType());
        creatTableSql.append(tableName).append(" (");

        // 保存‘创建数据库表’信息
        TbtskObjectinfo tableInfo = saveTableInfo(tableName, taskBiz);

        // 保存‘数据库表字段’信息
        if ("0".equals(filedTmpl)) {
            // 默认新增字段
            addDefField(creatTableSql, tableInfo);
            // 自定义
            String filedSql = saveTableFileds(fileds, tableInfo);
            creatTableSql.append(filedSql);
        } else {
            // 使用模板
            TskTaskBiz biz = tskTaskBizRepository.findById(filedTmpl).orElse(null);
            String filedSql = coyeTableFileds(biz, tableInfo, new ArrayList<>());
            creatTableSql.append(filedSql);
        }
        creatTableSql.deleteCharAt(creatTableSql.length() - 1);
        creatTableSql.append(");");

        // 创建数据库表
        exeCreateTable(creatTableSql.toString());

        // 保存任务
        taskBiz.setTableId(tableInfo.getfId());
        TskTaskBiz tskTaskBiz = tskTaskBizRepository.save(taskBiz);

        // 任务授权给创建者
        UserBiz2 ub = new UserBiz2();
        ub.setUserId(userId);
        ub.setBizId(tskTaskBiz.getId());
        ub.setRole(0);
        userBiz2Repository.save(ub);

        return tskTaskBiz;
    }

    private void exeCreateTable(String sql) {
        jdbcTemplate.execute(sql);
    }

    private String coyeTableFileds(TskTaskBiz tskTaskBiz, TbtskObjectinfo tableInfo) {
        return coyeTableFileds(tskTaskBiz, tableInfo, Collections.EMPTY_LIST);
    }

    private String coyeTableFileds(TskTaskBiz tskTaskBiz, TbtskObjectinfo tableInfo, List<String> uniqueFields) {
        StringBuffer filedSql = new StringBuffer();
        if (tskTaskBiz != null) {
            List<TbtskFields> list = tbtskFieldsRepository.getTbtskFieldsByTableid(tskTaskBiz.getTableId());

            //if(tskTaskBiz.getMode()==2) {// 领取模式必须要f_ismy字段
            List<TbtskFields> listTemp = list.stream().filter(t -> "f_ismy".equalsIgnoreCase(t.getfFieldname())).collect(Collectors.toList());
            if (listTemp == null || listTemp.size() < 1) {
                TbtskFields temp = new TbtskFields();
                temp.setfId(UUID.randomUUID().toString());
                temp.setfFieldname("f_ismy");
                temp.setfTablename(tableInfo.getfTablename());
                temp.setfTableid(tableInfo.getfId());
                temp.setfAlias("是否自己图斑（app端使用）");
                temp.setfFieldtype("int4");
                temp.setfNullable(0);
                temp.setfDefaultvalue("0");
                temp.setfIsBase(0);
                temp.setfIsOutwork(0);
                temp.setfIsListShow(0);
                temp.setfIsWebCheck(0);
                temp.setfIsStatis(0);
                temp.setfIsWebEdit(0);
                temp.setfFieldInnerOuterSys(FieldGroupTypeConstant.SYSTEM_FIELD);
                list.add(temp);
            }
            //}
            for (TbtskFields f : list) {

                TbtskFields tbField = new TbtskFields();

                BeanUtil.copyProperties(f, tbField, "fId", "fTableid", "fTablename");
                // 唯一值
                if (uniqueFields != null && uniqueFields.contains(f.getfId())) {
                    tbField.setfUnique(1);
                } else {
                    tbField.setfUnique(0);
                }

                tbField.setfTablename(tableInfo.getfTablename());
                tbField.setfTableid(tableInfo.getfId());
                tbField.setfId(null);

                TbtskFields tf = tbtskFieldsRepository.save(tbField);

                List<TbtskGroup> groups = tbtskGroupRepository.findByFFieldid(f.getfId());
                for (TbtskGroup g : groups) {
                    TbtskGroup tg = new TbtskGroup();
                    BeanUtil.copyProperties(g, tg, "fId", "fFieldid");
                    tg.setfFieldid(tf.getfId());

                    tbtskGroupRepository.save(tg);
                }

                filedSql.append(f.getfFieldname()).append(" ");
                if (f.getfLength() == null) {
                    filedSql.append(f.getfFieldtype());
                } else {
                    if ("decimal".equals(f.getfFieldtype())) {
                        filedSql.append(f.getfFieldtype()).append("(")
                                .append(f.getfLength()).append(",")
                                .append(f.getfPrecision()).append(")");
                    } else if ("varchar".equals(f.getfFieldtype())) {
                        filedSql.append(f.getfFieldtype()).append("(").append(f.getfLength()).append(")");
                    } else {
                        filedSql.append(f.getfFieldtype());
                    }
                }
                filedSql.append(" ");

                if ("0".equals(f.getfNullable())) {
                    filedSql.append("NOT NULL ");
                }

                filedSql.append(",");

            }


        }
        return filedSql.toString();
    }

    private String saveTableFileds(String fileds, TbtskObjectinfo tableInfo) {
        StringBuffer filedSql = new StringBuffer();
        JSONArray array = JSONArray.parseArray(fileds);

        for (int i = 0; i < array.size(); i++) {
            JSONObject obj = array.getJSONObject(i);
            String name = obj.getString("name");
            String type = obj.getString("type");
            String length = obj.getString("length");
            String flength = obj.getString("flength");
            String notNull = obj.getString("notNull");
            String isBase = obj.getString("isBase");
            String isOutwork = obj.getString("isOutwork");
            String order = obj.getString("order");
            String isListShow = obj.getString("isListShow");
            String isWebCheck = obj.getString("isWebCheck");
            String isWebEdit = obj.getString("isWebEdit");
            String isStatis = obj.getString("isStatis");


            Integer fieldIOS = "true".equals(isOutwork) ? FieldGroupTypeConstant.OUTER_FIELD : FieldGroupTypeConstant.INNER_FIELD;
            // 自定义字段不赋予默认值
            saveFields(tableInfo, "f_" + PinYinUtil.getFirstSpell(name), getType(type), length, flength,
                    notNull, isBase, isOutwork, name, order, isListShow, isWebCheck, isWebEdit, isStatis, fieldIOS, false);

            filedSql.append("f_").append(PinYinUtil.getFirstSpell(name)).append(" ");
            if (StringUtils.isBlank(length)) {
                filedSql.append(getType(type));
            } else {
                if ("double".equals(type)) {
                    filedSql.append(getType(type)).append("(")
                            .append(length).append(",")
                            .append(flength).append(")");
                } else if ("string".equals(type)) {
                    filedSql.append(getType(type)).append("(").append(length).append(")");
                }
            }
            filedSql.append(" ");

            if ("true".equals(notNull) && !"1".equals(isOutwork)) {
                filedSql.append("NOT NULL ");
            }

            filedSql.append(",");
        }
        return filedSql.toString();
    }

    private String getType(String type) {
        String str = "";
        switch (type) {
            case "int":
                str = "int4";
                break;
            case "double":
                str = "decimal";
                break;
            case "string":
                str = "varchar";
                break;
            case "date":
                str = "timestamp";
                break;
            default:
                break;
        }
        return str;
    }

    private TbtskObjectinfo saveTableInfo(String tableName, TskTaskBiz taskBiz) {
        TbtskObjectinfo table = new TbtskObjectinfo();
        table.setfTablename(tableName);
        table.setfTablealias(taskBiz.getName());
        table.setfIsspatial(0);
        table.setfVersion("1");
        table.setfState("1");
        return tbtskObjectinfoRepository.save(table);
    }

    @Transactional
    public void delByTaskId(String taskId) {
        TskTaskBiz tskTaskBiz = tskTaskBizRepository.findById(taskId).orElse(null);
        tskTaskBiz.setIsDel(1);
        tskTaskBizRepository.save(tskTaskBiz);
    }

    @Transactional(rollbackFor = Exception.class)
    public void deleteByTaskId(String taskId) {
        TskTaskBiz tskTaskBiz = tskTaskBizRepository.findById(taskId).orElse(null);

        if (tskTaskBiz.getTableId() != null) {
            TbtskObjectinfo tableInfo = tbtskObjectinfoRepository.findById(tskTaskBiz.getTableId()).orElse(null);
            //删除obs数据
            if (mDataBizService.isExistTableName(tableInfo.getfTablename())) {
                Integer count = mDataBizService.getCount(tableInfo.getfTablename(), "");
                if (count > 0) {
                    int pageSize = 100;
                    int page = count / pageSize;
                    if (count % 100 > 0) {
                        page++;
                    }
                    List<String> fields = ListUtil.toList("f_id");
                    for (int i = 1; i <= page; i++) {
                        List<Map> map = mDataBizService.queryPageData(tableInfo.getfTablename(), fields, 100, i, "1=1");
                        List<String> fids = new ArrayList<>();
                        map.forEach(t -> fids.add(t.get("f_id").toString()));
                        appMediaService.deleteRecordAndStorage(fids);
                    }

                }
            }
            // 删除下发到个人的数据
            tskAssignRecordRepository.deleteByTaskId(taskId);

            // 删除字段信息
            List<TbtskFields> fields = tbtskFieldsRepository.getTbtskFieldsByTableid(tskTaskBiz.getTableId());
            tbtskFieldsRepository.deleteAll(fields);

            // 删除表信息

            tbtskObjectinfoRepository.deleteById(tskTaskBiz.getTableId());

            if (tableInfo.getfTablename() != null) {
                // 删除字段权限信息
                tbtskGroupRepository.deleteByFTablename(tableInfo.getfTablename());
                // 删除表
                String sql = "DROP TABLE IF EXISTS " + tableInfo.getfTablename() + ";";
                jdbcTemplate.execute(sql);
            }
            // 删除授权信息
            userBiz2Repository.deleteByBizId(tskTaskBiz.getId());

            // 删除任务区域信息
            tskRightAreaRepository.deleteByTaskId(tskTaskBiz.getId());

            // 删除模板区域信息
            bizAreaRepository.deleteByBizId(tskTaskBiz.getId());

            // 删除管理区信息
            // 删除审核区信息
            // 删除复核区信息
            tbtskUserManageAreaService.deleteByTaskId(tskTaskBiz.getId());
            tbtskUserUploadAreaService.deleteByTaskId(tskTaskBiz.getId());
            tbtskUserAuditAreaService.deleteByTaskId(tskTaskBiz.getId());
            tbtskSuperUserAuditAreaService.deleteByTaskId(tskTaskBiz.getId());
            tbtskUserReviewAreaService.deleteByTaskId(tskTaskBiz.getId());
        }

        tskTaskBizRepository.deleteById(taskId);
    }

    public List<TskTaskBiz> findTskTaskBizs() {
        return tskTaskBizRepository.findByTskTaskBizs();
    }

    public TskTaskBiz getTskTaskBizById(String taskId) {
        TskTaskBiz tskTaskBiz = tskTaskBizRepository.findById(taskId).orElse(null);
        if (tskTaskBiz != null) {
            if (StringUtils.isNotBlank(tskTaskBiz.getDataUrl())) {
                String name = tskTaskBiz.getDataUrl().substring(tskTaskBiz.getDataUrl().lastIndexOf("/") + 1);
                tskTaskBiz.setDataFileName(name);
            }
            if (StringUtils.isNotBlank(tskTaskBiz.getWorkflowUrl())) {
                String name = tskTaskBiz.getWorkflowUrl().substring(tskTaskBiz.getWorkflowUrl().lastIndexOf("/") + 1);
                tskTaskBiz.setWorkflowFileName(name);
            }
            if (StringUtils.isNotBlank(tskTaskBiz.getUserUrl())) {
                String name = tskTaskBiz.getUserUrl().substring(tskTaskBiz.getUserUrl().lastIndexOf("/") + 1);
                tskTaskBiz.setUserFileName(name);
            }
            List<BizArea> list = bizAreaRepository.findByBizId(tskTaskBiz.getId());

            if (list != null && list.size() > 0) {
                List<String> codes = new ArrayList<>();
                for (BizArea ba : list) {
                    codes.add(ba.getArea());
                }
                tskTaskBiz.setTaskArea(StringUtils.join(codes, ","));
            }
        }

        return tskTaskBiz;
    }

    public List<TskTaskBiz> findTskTaskBizByType(String type) {
        return tskTaskBizRepository.findByType(type);
    }

    public List<TskTaskBiz> findBizTmplByType(String type) {
        return tskTaskBizRepository.findBizTmplByType(type);
    }

    public List<TskTaskBiz> findBizTmplByTypeAndArea(String type, String codes) {
        List<TskTaskBiz> list = new ArrayList<>();
        if (StringUtils.isNotBlank(codes)) {
            list = tskTaskBizRepository.findByTypeAndIds2(type, codes);
            /*List<String> ids = bizAreaRepository.findByAreaIN(codes);
            if (ids!=null && ids.size()>0) {
                list = tskTaskBizRepository.findByTypeAndIds(type, "'" + StringUtils.join(ids, "','") + "'");
            }*/
        }
        return list;
    }

    public List<TbtskFields> findTbtskFieldsByTaskId(String taskId) {
        TskTaskBiz biz = tskTaskBizRepository.findById(taskId).orElse(null);
        List<TbtskFields> list = tbtskFieldsRepository.getTbtskFieldsByTableid(biz.getTableId());
        List<TbtskObjectinfo> objectbyTaskId = tbtskObjectinfoRepository.getObjectbyTaskId(taskId);
        if(objectbyTaskId.size() > 0){
            for(TbtskObjectinfo tbtskObjectinfo :objectbyTaskId ){
                if(!tbtskObjectinfo.getfId().equals(biz.getTableId())){
                    list.addAll(tbtskFieldsRepository.getTbtskFieldsByTableid(tbtskObjectinfo.getfId()));
                }
            }
        }
        return list;
    }
    public List<TbtskFields> findInnerTbtskFieldsByTaskId(String taskId) {
        TskTaskBiz biz = tskTaskBizRepository.findById(taskId).orElse(null);
        List<TbtskFields> list = tbtskFieldsRepository.getTbtskFieldsByTableid(biz.getTableId());
        List<TbtskObjectinfo> objectbyTaskId = tbtskObjectinfoRepository.getObjectbyTaskId(taskId);
        if(objectbyTaskId.size() > 0){
            for(TbtskObjectinfo tbtskObjectinfo :objectbyTaskId ){
                if(!tbtskObjectinfo.getfId().equals(biz.getTableId())){
                    list.addAll(tbtskFieldsRepository.getInnerTbtskFieldsByTableid(tbtskObjectinfo.getfId()));
                }
            }
        }
        return list;
    }
    public List<TbtskFields> findTbtskFieldsByTableId(String tableId) {
        List<TbtskFields> list = tbtskFieldsRepository.getTbtskFieldsByTableid(tableId);
        return list;
    }
    public List<TbtskFields> findInnserTbtskFieldsByTableId(String tableId) {
        List<TbtskFields> list = tbtskFieldsRepository.getInnerTbtskFieldsByTableid(tableId);
        return list;
    }
    public List<TbtskFields> findTbtskFieldsByTableName(String tablename) {
        List<TbtskFields> list = tbtskFieldsRepository.getTbtskFieldsByTableName(tablename);
        return list;
    }

    private CoordinateReferenceSystem createCRSByPrjFile(String filePath) {
        String prjFilePath = filePath.replace(".shp", ".prj");
        String wkt = txt2String(new File(prjFilePath));
        String wkt2 = wkt.replaceAll("[',']+", ",").replaceAll(",]", "]");

        CoordinateReferenceSystem sCRS = null;
        try {
            sCRS = CRS.parseWKT(wkt2);
        } catch (FactoryException e) {
            e.printStackTrace();
        }
        return sCRS;
    }

    private String txt2String(File file) {
        StringBuilder result = new StringBuilder();
        try {
            //构造一个BufferedReader类来读取文件
            BufferedReader br = new BufferedReader(new FileReader(file));
            String s = null;
            while ((s = br.readLine()) != null) {
                //使用readLine方法，一次读一行
                result.append(s);
            }
            br.close();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return result.toString();
    }

    /*  @Transactional(rollbackFor = Exception.class)*/
    public Map<String, List<String>> importTaskData(String unzipFileDir, String taskId, Long userId, String updateType, Map<String, TskUploadLogDTO> dataUploadLog) throws Exception {
        TskTaskBiz tskTaskBiz = tskTaskBizRepository.findById(taskId).orElse(null);

        if (tskTaskBiz.getVersion() == null) {
            RegionVersion defaultVersion = regionVersionRepository.getRegionVersionByDefault();//获取政区默认版本
            if (defaultVersion != null) {
                tskTaskBiz.setVersion(defaultVersion.getVersion());
            } else {
                tskTaskBiz.setVersion("2018");
            }
        }
        TbtskObjectinfo tableInfo = tbtskObjectinfoRepository.findById(tskTaskBiz.getTableId()).orElse(null);

        URL url = null;
        File file = null;
        file = new File(unzipFileDir);
        File[] content = file.listFiles();
        for (int j = 0, ln = content.length; j < ln; ++j) {
            if (content[j].getName().endsWith(".shp")) {
                url = content[j].toURI().toURL();
                break;
            }
        }
        ShapefileDataStore shpDataStore = new ShapefileDataStore(url);
        String chasetStr = shpDataStore.getCharset().toString();
        FeatureSource<SimpleFeatureType, SimpleFeature> featureSource = shpDataStore
                .getFeatureSource(shpDataStore.getTypeNames()[0]);
        //获取图层原始坐标系，转换目标坐标系
        CoordinateReferenceSystem sourceCRS = featureSource.getInfo().getCRS();
        if (sourceCRS == null) {
            sourceCRS = createCRSByPrjFile(url.toString());
        }
        MathTransform transform = CRS.findMathTransform(sourceCRS, DefaultGeographicCRS.WGS84, true);
        SimpleFeature sf = null;
        FeatureCollection<SimpleFeatureType, SimpleFeature> collection = featureSource.getFeatures();
        // 必有字段判断
        List<AttributeDescriptor> attributeDescriptors = collection.getSchema().getAttributeDescriptors();

        // 必有字段集合
        List<TbtskFields> mustFields = tbtskFieldsRepository.getTbtskMustFieldsByTableid(tableInfo.getfId(), 1);
        if (!mustFields.isEmpty()) {
            List<String> fieldNames = attributeDescriptors.stream().map(a -> a.getLocalName()).collect(Collectors.toList());
            for (TbtskFields mustField : mustFields) {
                if (!fieldNames.contains(mustField.getfFieldname())) {
                    TskUploadLogDTO tskUploadLogDTO = new TskUploadLogDTO();
                    tskUploadLogDTO.setUploadType("0".equals(updateType) ? "追加" : "覆盖");
                    tskUploadLogDTO.setErrorInfo("必有字段" + mustField.getfAlias() + "不存在,请检查数据。");
                    dataUploadLog.computeIfAbsent("error", k -> tskUploadLogDTO);
                    throw new RuntimeException("必有字段" + mustField.getfAlias() + "不存在,请检查数据。");
                }
            }
        }

        if (collection.size() > 20000) {
            TskUploadLogDTO tskUploadLogDTO = new TskUploadLogDTO();
            tskUploadLogDTO.setErrorInfo("加载图斑数量一次不能超过20000");
            tskUploadLogDTO.setUploadType("0".equals(updateType) ? "追加" : "覆盖");
            dataUploadLog.computeIfAbsent("error", k -> tskUploadLogDTO);
            throw new RuntimeException("加载图斑数量一次不能超过20000");
        }

        FeatureIterator<SimpleFeature> itertor = collection.features();

        int i = 0;
        List<String> ids = new ArrayList<String>();
        Map<String, List<String>> map = new HashMap<>();
        //Date timeNow = new Date();
        List<Map<String, Object>> addDataCacheList = new ArrayList<>();
        List<Map<String, Object>> updateDataCacheList = new ArrayList<>();
        List<TbtskFields> allFields = tbtskFieldsRepository.getTbtskFieldsByTableid(tableInfo.getfId());
        // 唯一值字段集合
        List<TbtskFields> uniqueFields = tbtskFieldsRepository.getTbtskUniqueFieldsByTableid(tableInfo.getfId(), 1);
        if (uniqueFields.isEmpty()) {
            TskUploadLogDTO tskUploadLogDTO = new TskUploadLogDTO();
            tskUploadLogDTO.setErrorInfo("唯一值字段不存在,请检查任务配置。");
            tskUploadLogDTO.setUploadType("0".equals(updateType) ? "追加" : "覆盖");
            dataUploadLog.computeIfAbsent("error", k -> tskUploadLogDTO);
            throw new RuntimeException("唯一值字段不存在,请检查任务配置。");
        }
        //获取任务范围
        List<BizArea> bizAreas = bizAreaRepository.queryByBizId(tskTaskBiz.getId());
        Set<String> areaCodes = bizAreas.stream().map(bizArea -> bizArea.getArea()).collect(Collectors.toSet());
        int s = 0;
        while (itertor.hasNext()) {
            s++;
            sf = itertor.next();

            Map<String, Object> result = saveData(tskTaskBiz, tableInfo, sf, chasetStr, userId.toString(), taskId,
                    updateType, addDataCacheList, updateDataCacheList, allFields, uniqueFields, areaCodes);
            UpResultEnum r = (UpResultEnum) result.get("type");
            String xzqdm = ((String) result.get("xzqdm") == null || "".equals((String) result.get("xzqdm"))) ? "政区代码" : (String) result.get("xzqdm");
            TskUploadLogDTO tskUploadLogDTO = dataUploadLog.computeIfAbsent(xzqdm, k -> new TskUploadLogDTO(xzqdm, updateType));
            tskUploadLogDTO.addTotal(1L);
            switch (r) {
                case ADD:
                    tskUploadLogDTO.addSuccessNum(1L);
                    map.computeIfAbsent("ADD", k -> new ArrayList<>()).add((String) result.get("f_id"));
                    i++;
                    break;
                case UPDATE:
                    tskUploadLogDTO.addSuccessNum(1L);
                    map.computeIfAbsent("UPDATE", k -> new ArrayList<>()).add((String) result.get("f_id"));
                    break;
                case SKIP:
                    tskUploadLogDTO.addSkipNum(1L);
                    break;
                case ERROR:
                    Map<UpResultErrorEnum, Long> errorEnumLongMap = tskUploadLogDTO.getErrorEnumLongMap();
                    UpResultErrorEnum e = (UpResultErrorEnum) result.getOrDefault("error", UpResultErrorEnum.OTHER);
                    // 统计错误的类型
                    errorEnumLongMap.merge(e, 1L, (oldValue, newValue) -> oldValue + newValue);
                    tskUploadLogDTO.addFailNum(1L).appendErrorInfo((String) result.getOrDefault("errorInfo", ""));
                    break;
                default:
                    break;
            }

            // 每达到提交数量是，提交插入数据,并清空缓存集合
            if (addDataCacheList.size() == BATCH_COMMIT_COUNT) {
                mDataBizService.insertDatasBatch(tableInfo.getfTablename(), addDataCacheList, "f_shape");
                /*elasticsearchService.createOrUpdateDocBulk(tableInfo.getfTablename(), addDataCacheList);*/
                addDataCacheList.clear();
                logger.info("数量----------------" + s);
            }
        }
        logger.info("数据加载最后一步-------------" + s);
        if (!addDataCacheList.isEmpty()) {
            // 提交插入最后一批数据
            mDataBizService.insertDatasBatch(tableInfo.getfTablename(), addDataCacheList, "f_shape");
            /*  elasticsearchService.createOrUpdateDocBulk(tableInfo.getfTablename(), addDataCacheList);*/
            addDataCacheList.clear();
        }

        if (!updateDataCacheList.isEmpty()) {

        }
        if (tskTaskBiz.getTotal() == null) {
            tskTaskBiz.setTotal(i);
        } else if (tskTaskBiz.getTotal() != null) {
            tskTaskBiz.setTotal(tskTaskBiz.getTotal() + i);
        }
        tskTaskBizRepository.save(tskTaskBiz);
        return map;
    }

    @Transactional
    public String deleteByBizIdAndUserList(String taskId, List<Long> userIdList) {

        String msg = "";

        List<String> userIds = userIdList.stream().map(r -> r.toString()).collect(Collectors.toList());
        String userIdsStr = org.sqlite.util.StringUtils.join(userIds, ",");


        // 需要移出的任务角色，管理员，审核员，作业员，复核员
        List<Integer> needDeletedRoleList = new ArrayList<>();
        needDeletedRoleList.add(1);
        needDeletedRoleList.add(2);
        needDeletedRoleList.add(3);
        needDeletedRoleList.add(4);
        needDeletedRoleList.add(5);
        needDeletedRoleList.add(6);

        List<String> skipedUserIdList = new ArrayList<>();
        for (Long userid : userIdList) {
            // 判断用户是否是任务创建者，如果是任务创建者，则跳过删除
            List<UserBiz2> creatorList = userBiz2Repository.findByUserIdAndBizIdAndRole(userid, taskId, 0);
            if (!GutilCollection.isEmpty(creatorList)) {
                skipedUserIdList.add(String.valueOf(userid));
                continue;
            }
            userBiz2Repository.deleteByBizIdAndUserIdAndByRole(userid, taskId, needDeletedRoleList);
            // 管理员
            tbtskUserManageAreaService.deleteByTaskIdAndUserId(taskId, String.valueOf(userid));
            // 审核员
            tbtskUserAuditAreaService.deleteByTaskIdAndUserId(taskId, String.valueOf(userid));
            // 超级审核员
            tbtskSuperUserAuditAreaService.deleteByTaskIdAndUserId(taskId, String.valueOf(userid));
            // 作业员
            changeRightArea(taskId, String.valueOf(userid), "");
            // 复核员
            tbtskUserReviewAreaService.deleteByTaskIdAndUserId(taskId, String.valueOf(userid));
            // 上传员
            tbtskUserUploadAreaService.deleteByTaskIdAndUserId(taskId, String.valueOf(userid));
        }

        if (!GutilCollection.isEmpty(skipedUserIdList) && skipedUserIdList.size() == 1 &&
                !GutilCollection.isEmpty(userIdList) && userIdList.size() == 1) {
            // 跳过删除的userid是传入的唯一的userid是，需要提示当前任务创建者不能被删除
            msg = "当前用户为任务创建者，不能不删除！";
        }

        return msg;
    }

    /**
     * 异步进行截图服务数据加载
     *
     * @param unzipFileDir
     * @param taskId
     * @param userId
     * @param updateType
     * @param dataUploadLog
     * @return
     * @throws Exception
     */
    @Transactional(rollbackFor = Exception.class)
    public Map<String, List<String>> importTaskGstData(String unzipFileDir, String taskId, Long userId, String updateType, Map<String, TskUploadLogDTO> dataUploadLog) throws Exception {
        TskTaskBiz tskTaskBiz = tskTaskBizRepository.findById(taskId).orElse(null);
        TbtskObjectinfo tableInfo = tbtskObjectinfoRepository.findById(tskTaskBiz.getTableId()).orElse(null);
        Map<String, List<String>> map = new HashMap<>();
        File file = null;
        file = new File(unzipFileDir);
        File[] content = file.listFiles();
        File file1 = null;
        for (int j = 0, ln = content.length; j < ln; ++j) {
            if (content[j].getName().endsWith(".db")) {
                file1 = content[j];
                break;
            }
        }
        FileInputStream fileInputStream = new FileInputStream(file1);
        File tempUploadFile = buildTempUploadFile(userId.toString());
        FileUtils.copyInputStreamToFile(fileInputStream, tempUploadFile);

        // 获取DB文件数据库连接
        SqlliteConnTool connPool = new SqlliteConnTool(tempUploadFile.getAbsolutePath());
        Connection connection = connPool.getConnection();
        Statement statement = connection.createStatement();
        ResultSet rs = null;
        String sql = "select * from TBGST";
        rs = statement.executeQuery(sql);
        List<Tbgst> tbgstList = new ArrayList<>();
        // 唯一值字段集合
        List<TbtskFields> uniqueFields = tbtskFieldsRepository.getTbtskUniqueFieldsByTableid(tableInfo.getfId(), 1);
        while (rs.next()) {
            // String tbbh = rs.getString("f_tbbh");
            // String xzqdm = rs.getString("f_xzqdm");
            String filemd5 = rs.getString("f_filemd5");
            //String filename = rs.getString("f_filename");
            String filename = UUID.randomUUID() + ".png";
            Double filesize = rs.getDouble("f_filesize");
            // String filecontent = rs.getString("f_filecontent");
            //  rs.getBlob("f_filecontent").getBinaryStream();
            byte[] filecontent = rs.getBytes("f_filecontent");
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("select t.f_id from " + tableInfo.getfTablename() + " t where 1=1 ");
            if (uniqueFields != null) {
                for (TbtskFields tbtskFields : uniqueFields) {
                    stringBuilder.append(" and ");
                    stringBuilder.append("t." + tbtskFields.getfFieldname());
                    stringBuilder.append(" = '");
                    stringBuilder.append(rs.getString(tbtskFields.getfFieldname()) + "'");
                }
            }
            TskUploadLogDTO tskUploadLogDTO = dataUploadLog.computeIfAbsent("1", k -> new TskUploadLogDTO("1", updateType));
            tskUploadLogDTO.addTotal(1L);
            // 将recordid关联的数据至为已下发状态
            List<Map> maps = mDataBizService.queryDataBySql(stringBuilder.toString());
            if (!maps.isEmpty()) {
                String tbid = maps.get(0).get("f_id").toString();
                if (!StringUtils.isEmpty(tbid)) {
                    boolean isNotExist = true;
                    //校验数据是否重复
                    List<Tbgst> tbgsts = tbgstRepository.findByBizIdAndTbId(taskId, tbid);
                    if (!tbgsts.isEmpty()) {
                        for (Tbgst t : tbgsts) {
                            if (t.getMd5().equals(filemd5) && tbid.equals(t.getTbId())) {
                                isNotExist = false;
                            }
                        }
                    }
                    if (isNotExist) {
                        Tbgst tbgst = tbgstRepository.findByBizIdAndTbIdlimit1(taskId, tbid);
                        if (updateType.equals("0") || (updateType.equals("1") && tbgst == null)) {
                            tbgst = new Tbgst();
                            tbgst.setId(UUID.randomUUID().toString());
                            tbgst.setBizId(taskId);
                            tbgst.setTbId(tbid);
                            tbgst.setCreateTime(new Date());
                            //新增
                            tskUploadLogDTO.addSuccessNum(1L);
                            map.computeIfAbsent("ADD", k -> new ArrayList<>()).add(tbgst.getId());
                        } else {
                            tbgst.setUpdateTime(new Date());
                            //更新数据
                            tskUploadLogDTO.addSuccessNum(1L);
                            map.computeIfAbsent("UPDATE", k -> new ArrayList<>()).add(tbgst.getId());
                        }
                        //将文件内容转换位obs地址
                        String imgUrl = getImgUrlByByte(filecontent, taskId, userId, filename);
                        tbgst.setUserId(userId);
                        tbgst.setMd5(filemd5);
                        tbgst.setFileSize(filesize);
                        tbgst.setUrl(imgUrl);
                        tbgst.setName(filename);
                        tbgstList.add(tbgst);
                    }
                } else {
                    tskUploadLogDTO.addSkipNum(1L);
                }
            }
            //分批进行提交数据
            if (!tbgstList.isEmpty() && tbgstList.size() >= 200) {
                tbgstRepository.saveAll(tbgstList);
                tbgstList.clear();
            }
        }
        //将剩余的数据进行提交
        if (!tbgstList.isEmpty()) {
            tbgstRepository.saveAll(tbgstList);
            tbgstList.clear();
        }
        return map;
    }

    /**
     * 将文件内容转换位obs地址
     *
     * @param imgStr
     * @param taskId
     * @param userId
     * @param fileName
     * @return
     */
    public String getImgUrlByString(String imgStr, String taskId, Long userId, String fileName) {
        String resultUrl = null;
        if (imgStr != null && imgStr.length() > 0) {
            try {
                // 将字符串转换成二进制，用于显示图片
                // 将上面生成的图片格式字符串 imgStr，还原成图片显示
                byte[] imgByte = hex2byte(imgStr);
                InputStream in = new ByteArrayInputStream(imgByte);
                String obsFilePath = "importTaskGstData/" + taskId + "/" + userId + "/" + new SimpleDateFormat("yyyyMMddHHmmss").format
                        (new Date()) + "-" + fileName;
                resultUrl = ossOperatorService.sendObject2Oss(obsFilePath, in);
                in.close();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return resultUrl;
    }

    /**
     * 将文件内容转换位obs地址
     *
     * @param filecontent
     * @param taskId
     * @param userId
     * @param fileName
     * @return
     */
    public String getImgUrl(Blob filecontent, String taskId, Long userId, String fileName) {
        String resultUrl = null;
        if (filecontent != null) {
            try {
                // 将字符串转换成二进制，用于显示图片
                // 将上面生成的图片格式字符串 imgStr，还原成图片显示
                //byte[] imgByte = hex2byte( imgStr );
                InputStream in = filecontent.getBinaryStream();
                String obsFilePath = "importTaskGstData/" + taskId + "/" + userId + "/" + new SimpleDateFormat("yyyyMMddHHmmss").format
                        (new Date()) + "-" + fileName;
                resultUrl = ossOperatorService.sendObject2Oss(obsFilePath, in);
                in.close();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return resultUrl;
    }

    /**
     * 将文件内容转换位obs地址
     *
     * @param filecontent
     * @param taskId
     * @param userId
     * @param fileName
     * @return
     */
    public String getImgUrlByByte(byte[] filecontent, String taskId, Long userId, String fileName) {
        String resultUrl = null;
        if (filecontent != null) {
            try {
                // 将字符串转换成二进制，用于显示图片
                // 将上面生成的图片格式字符串 imgStr，还原成图片显示
                //byte[] imgByte = hex2byte( imgStr );
                InputStream ins = new ByteArrayInputStream(filecontent);
                String obsFilePath = "importTaskGstData/" + taskId + "/" + userId + "/" + new SimpleDateFormat("yyyyMMddHHmmss").format
                        (new Date()) + "-" + fileName;
                resultUrl = ossOperatorService.sendObject2Oss(obsFilePath, ins);
                ins.close();
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return resultUrl;
    }

    private File buildTempUploadFile(String userid) {
        uploadDir = (String) ProjectConfig.getConfig(ProjectConfigEnum.UPLOAD_DIR.getKey());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        String fileName = String.format("task-%s-%s-%s.db", userid, sdf.format(new Date()), UUID.randomUUID());
        return new File(uploadDir, fileName);
    }    // 判断是否为乱码

    private boolean isMessyCode(String str) {
        for (int i = 0; i < str.length(); i++) {
            char c = str.charAt(i);
            // 当从Unicode编码向某个字符集转换时，如果在该字符集中没有对应的编码，则得到0x3f（即问号字符?）
            // 从其他字符集向Unicode编码转换时，如果这个二进制数在该字符集中没有标识任何的字符，则得到的结果是0xfffd
            if ((int) c == 0xfffd) {
                // 存在乱码
                return true;
            }
        }
        return false;
    }

    private String getStrValue(Object obj, String chasetStr) {
        String val = "";
        try {
            if (obj != null && !"".equals(obj)) {
                String objStr = obj.toString();
                obj = new String(objStr.getBytes(chasetStr), StandardCharsets.UTF_8);
                if (obj != null && isMessyCode(obj.toString())) {
                    obj = new String(objStr.getBytes(chasetStr), "GBK");
                }
                val = String.valueOf(obj);
            }
        } catch (Exception ex) {
        }
        return val;
    }

    private Map<String, Object> saveData(TskTaskBiz tskTaskBiz, TbtskObjectinfo table, SimpleFeature sf, String
            chasetStr, String userId, String bizId, String updateType, List<Map<String, Object>> addDataList, List<Map<String, Object>> updateDataList, List<TbtskFields> allFields, List<TbtskFields> uniqueFields, Set<String> areaCodes) throws Exception {

        HashMap<String, Object> map = new HashMap<>();
        HashMap<String, Object> updateMap = new HashMap<>();
        List<String> fieldDefault = new ArrayList<>();

        String fieldName = "";
        String fieldType = "";
        String alias = "";
        Integer outWork = -1;
        StringBuilder stringBuilder = new StringBuilder();
        Map<String, Object> result = new HashMap<>();
        //插入数据
        for (TbtskFields field : allFields) {

            fieldName = field.getfFieldname();
            fieldType = field.getfFieldtype();

            fieldType = TskTaskBizDBUtil.getDBType(fieldType);

            alias = field.getfAlias();
            outWork = field.getfIsOutwork();

            //String rname = PinYinUtil.getFirstSpell(alias);

            if ("f_lat".equals(fieldName) || "f_lon".equals(fieldName)) {
                continue;
            }

            if ("f_lat_b".equals(fieldName) || "f_lon_b".equals(fieldName)) {
                continue;
            }

            if ("f_lat_g".equals(fieldName) || "f_lon_g".equals(fieldName)) {
                continue;
            }

            if ("f_shape1".equals(fieldName)) {
                continue;
            }
            if (field.getfDefaultvalue() != null && !"".equalsIgnoreCase(field.getfDefaultvalue())) {
                fieldDefault.add(fieldName);
            }
            map.put(fieldName, field.getfDefaultvalue());
            //校验shape数据类型
            Boolean dataType = false;
            if ("f_shape".equalsIgnoreCase(fieldName)) {
                if (fieldType.equalsIgnoreCase("geometry")) {
                    Geometry geo = (Geometry) sf.getDefaultGeometry();
                    if (table.getfSpatialtype() != null && table.getfSpatialtype().equals("1")) {
                        if (geo.getGeometryType().equals("Point")) {
                            dataType = true;
                        }
                    } else if (table.getfSpatialtype() != null && table.getfSpatialtype().equals("2")) {
                        if (geo.getGeometryType().equals("LineString") || geo.getGeometryType().equals("MultiLineString")) {
                            dataType = true;
                        }
                    } else if (table.getfSpatialtype() != null && table.getfSpatialtype().equals("3")) {
                        if (geo.getGeometryType().equals("Polygon") || geo.getGeometryType().equals("MultiPolygon")) {
                            dataType = true;
                        }
                    }
                } else {
                    dataType = false;
                }
                if (!dataType) {
                    String xzqdm = (String) map.get("f_xzqdm");
                    result.put("xzqdm", xzqdm);
                    result.put("type", UpResultEnum.ERROR);
                    result.put("error", UpResultErrorEnum.DATA_TYPE_ERROR);
                    result.put("errorInfo", "数据类型不匹配");
                    return result;
                }
            }
            boolean isOut = (field.getfFieldInnerOuterSys() & FieldGroupTypeConstant.OUTER_FIELD) == FieldGroupTypeConstant.OUTER_FIELD;
            addDatatoMap(table, map, sf, fieldType, fieldName, alias, chasetStr, isOut ? 1 : field.getfNullable()
                    , field.getfOrder(), field.getfDefaultvalue());
            if (SHAPE_UPDATE.equals(updateType)) {

                // & 判断是否是内业字段  例如数字是5( 1 + 4) 与 1求&得出 1 即是内业
                if ((field.getfFieldInnerOuterSys().intValue() & FieldGroupTypeConstant.INNER_FIELD) == FieldGroupTypeConstant.INNER_FIELD) {
                    updateMap.put(fieldName, field.getfDefaultvalue());
                    addDatatoMap(table, updateMap, sf, fieldType, fieldName, alias, chasetStr, isOut ? 1 : field
                            .getfNullable(), field.getfOrder(), field.getfDefaultvalue());
                }
            }
        }
        map.put("f_id", UUID.randomUUID().toString());
        map.put("f_status", "1");
        map.put("f_createtime", System.currentTimeMillis() + "");
        map.put("f_userid", userId);
        map.put("f_ismy", "0");

         // 默认赋上村级政区代码
        List<TbtskFields> sysFields = allFields.stream().filter(t -> "f_xzqdmsys".equalsIgnoreCase(t.getfFieldname())).collect(Collectors.toList());
        if (sysFields != null && sysFields.size() > 0) {
            // 包含这个字段的表，赋上系统政区代码值
            Geometry geo = (Geometry) sf.getDefaultGeometry();
            Geometry pt = geo.getCentroid();
            int proNum = getColNum(((Point) pt).getX());
            // 获取村级政区代码
            /* String xzqdmsysStr = getXzqdmSys(pt, tskTaskBiz.getVersion());*/
            Map<String, Object> map1 = getXzqdmSys(pt, geo, proNum);
            map.put("f_xzqdmsys",  map1.get("xzqdmsys"));
            map.put("f_xzqdm",  map1.get("xzqdmsys"));


            map.put("f_xzqmc", map1.get("xzqmc"));
            map.put("f_xzqmc1", map1.get("xzqmc"));
            map.put("f_tbmj", map1.get("area"));
//                updateMap.put("f_xzqdmsys", xzqdmsysStr);
            //处理新增的市、县、镇、村
            List<String> fields = allFields.stream().map(e -> e.getfFieldname()).collect(Collectors.toList());
            if(fields.contains("f_xzqdmcity") && org.apache.commons.lang3.StringUtils.isNotBlank((String) map1.get("xzqdmsys"))){
                map.put("f_xzqdmcity", map1.get("xzqdmsys").toString().substring(0,4)+"00");
                map.put("f_xzqdmcounty", map1.get("xzqdmsys").toString().substring(0,6));
                map.put("f_xzqdmtown", map1.get("xzqdmsys").toString().substring(0,9));
            }
        }
        if (map.containsKey("f_xzqdm") && org.apache.commons.lang3.StringUtils.isNotBlank((String) map.get("f_xzqdm"))) {
            String xzqdm = (String) map.get("f_xzqdm");

            if(tskTaskBiz.getGranularity() == 3){
                map.put("f_xzqdm", map.get("f_xzqdmsys").toString().substring(0,6));
            }else  if(tskTaskBiz.getGranularity() == 4){
                map.put("f_xzqdm", map.get("f_xzqdmsys").toString().substring(0,9));
            }

            if(xzqdm.endsWith("000") || xzqdm.endsWith("000000")){
                xzqdm = xzqdm.replaceAll("000","");
            }
            result.put("xzqdm", xzqdm);
            //校验f_xzqdm 是否存在政区表中
            boolean xzqdmisExist = true;
            if (xzqdm.length() <= 6) {
                Region region = regionDao.findByCodeAndVersion(xzqdm, tskTaskBiz.getVersion() != null ? tskTaskBiz.getVersion() : "2018");
                if (region == null) {
                    xzqdmisExist = false;
                }
            } else if (xzqdm.length() == 9) {
                String name = regionTownRepository.getNameByCodeAndVersion(xzqdm, tskTaskBiz.getVersion() != null ? tskTaskBiz.getVersion() : "2018");
                if (name == null) {
                    xzqdmisExist = false;
                }
            } else if (xzqdm.length() == 12) {
                String name = regionvillageDao.getNameByCodeAndVersion(xzqdm, tskTaskBiz.getVersion() != null ? tskTaskBiz.getVersion() : "2018");
                if (name == null) {
                    xzqdmisExist = false;
                }
            }
            if (!xzqdmisExist) {
                result.put("xzqdm", xzqdm);
                result.put("type", UpResultEnum.ERROR);
                result.put("error", UpResultErrorEnum.XZQDM_ERROR);
                // 错误信息记录
                StringBuilder stringBuilder1 = new StringBuilder();
                for (TbtskFields uniqueField : uniqueFields) {
                    stringBuilder1.append(uniqueField.getfAlias())
                            .append(":").append(map.get(uniqueField.getfFieldname())).append(",");
                }
                result.put("errorInfo", stringBuilder1.toString());
                return result;
            }


            // 行政区范围不在任务定义的范围则不加入
            if (!XzqdmUtil.xzqdmInAreaCodes(areaCodes, xzqdm)) {
                result.put("xzqdm", xzqdm);
                result.put("type", UpResultEnum.ERROR);
                result.put("error", UpResultErrorEnum.NOT_IN_AREA);
                // 错误信息记录
                StringBuilder stringBuilder1 = new StringBuilder();
                for (TbtskFields uniqueField : uniqueFields) {
                    stringBuilder1.append(uniqueField.getfAlias())
                            .append(":").append(map.get(uniqueField.getfFieldname())).append(",");
                }
                result.put("errorInfo", stringBuilder1.toString());
                return result;
            }
            // 数据的xzqdm要和任务粒度需保持一致，不一致则不加入
            if (tskTaskBiz.getGranularity() != null) {
                String xzqdmCode = (String) map.get("f_xzqdm");
                if ((tskTaskBiz.getGranularity() == 3 && xzqdmCode.length() != 6)
                        || (tskTaskBiz.getGranularity() == 3 && xzqdmCode.length() == 6 && xzqdmCode.endsWith("00"))  //县级
                        || (tskTaskBiz.getGranularity() == 4 && xzqdmCode.length() != 9) //乡镇级
                        || (tskTaskBiz.getGranularity() == 5 && xzqdmCode.length() != 12)) { //村级
                    Map<String, Object> result1 = new HashMap<>();
                    result1.put("xzqdm", xzqdmCode);
                    result1.put("type", UpResultEnum.ERROR);
                    result1.put("error", UpResultErrorEnum.XZQDM__MISMATCH_TASKGRANULARITY);
                    // 错误信息记录
                    StringBuilder stringBuilder1 = new StringBuilder();
                    for (TbtskFields uniqueField : uniqueFields) {
                        stringBuilder1.append(uniqueField.getfAlias())
                                .append(":").append(map.get(uniqueField.getfFieldname())).append(",");
                    }
                    result.put("errorInfo", stringBuilder1.toString());
                    return result1;
                }
            }
            List<Map> maps = new ArrayList<>();
            if (uniqueFields != null && !uniqueFields.isEmpty()) {

                stringBuilder.delete(0, stringBuilder.length());
                stringBuilder.append("select f_id from " + table.getfTablename() + " where 1=1 ");
                List<Object> values = new ArrayList<>(uniqueFields.size());
                for (TbtskFields tbtskFields : uniqueFields) {
                    stringBuilder.append(" and ");
                    stringBuilder.append(tbtskFields.getfFieldname());
                    stringBuilder.append(" = ?");
                    values.add(map.get(tbtskFields.getfFieldname()));
                }

                maps = jdbcTemplate.query(stringBuilder.toString(), values.toArray(new Object[0]), new RowMapper<Map>() {
                    @Override
                    public Map mapRow(ResultSet rs, int rowNum) throws SQLException {
                        Map ha = new HashMap();
                        rs.getString("f_id");
                        ha.put("f_id", rs.getString("f_id"));
                        return ha;
                    }
                });
            }

            // 跳过--有重复记录且追加新增模式跳过
            if (!maps.isEmpty() && SHAPE_APPEND.equals(updateType)) {
                result.put("type", UpResultEnum.SKIP);

                // 错误信息记录
                StringBuilder stringBuilder1 = new StringBuilder();
                for (TbtskFields uniqueField : uniqueFields) {
                    stringBuilder1.append(uniqueField.getfAlias())
                            .append(":").append(map.get(uniqueField.getfFieldname())).append(",");
                }
                result.put("errorInfo", stringBuilder1.toString());
                return result;
            }
            //Map area = dataBizService.selectByID("uis_region", "f_code", xzqdm);
            String name = regionService.getName(xzqdm);
            if (StringUtils.isNotBlank(name)) {
                map.put("f_xzqmc1", name);
                if (updateMap.containsKey("f_xzqmc1")) {
                    updateMap.put("f_xzqmc1", name);
                }
                if (updateMap.containsKey("f_createtime")) {
                    updateMap.put("f_createtime", System.currentTimeMillis() + "");
                }
                if (updateMap.containsKey("f_userid")) {
                    updateMap.put("f_userid", userId);
                }
            }

            if ("zjd".equals(table.getfRemark())) {
                String zdlx = (String) map.get("f_zdlx");
                // 默认为宅基地JC
                String type = "JC";
                // 当宗地类型包含建设用地时，type=JB
                if (zdlx.contains("建设用地")) {
                    type = "JB";
                }

                Geometry geo = (Geometry) sf.getDefaultGeometry();

                List<RegionDJQ> villages = regionDJQRepository.queryContains(geo);
                if (villages != null && villages.size() > 0) {
                    String code = villages.get(0).getCode();
                    String tbbh = generatorSeqByXzqdm(bizId, type, code, table.getfId(), table);
                    map.put("f_tbbh", tbbh);
                    map.put("f_bdcdydm", tbbh + "F99990001");
                    map.put("f_zdsxh", tbbh.substring(14));
                }

                map.put("f_zdlx", type);
                map.put("f_dzwdwdm", "F99990001");

                // 宅基地不更新
                updateMap.remove("f_tbbh");
                updateMap.remove("f_bdcdydm");
                updateMap.remove("f_zdsxh");
                updateMap.remove("f_dzwdwdm");
                updateMap.remove("f_zdlx");

            }



            // 没有定义唯一值
            if (maps.isEmpty()) {
                result.put("f_id", map.get("f_id"));
                result.put("type", UpResultEnum.ADD);
                //dataBizService.insertData(table.getfTablename(), map, "f_shape");
                //解析默认值
                resolveFieldDefault(map, fieldDefault);
                addDataList.add(map);
                // 覆盖更新
            } else if (maps.size() > 0 && SHAPE_UPDATE.equals(updateType)) {
                String fid = (String) maps.get(0).get("f_id");

                result.put("f_id", fid);
                result.put("type", UpResultEnum.UPDATE);
                //解析默认值
                resolveFieldDefault(updateMap, fieldDefault);
                updateMap.remove("f_id");
                try {
                    mDataBizService.updateData(table.getfTablename(), updateMap, " f_id = '" + fid + "'");
                } catch (Exception e) {
                    result.put("type", UpResultEnum.ERROR);
                    result.put("error", UpResultErrorEnum.OTHER);
                    result.put("errorInfo", e.getMessage());
                    logger.error(e.getMessage(), e);
                }

                //updateDataList.add(map);

            }
            return result;
        } else {
            result.put("type", UpResultEnum.ERROR);
            result.put("error", UpResultErrorEnum.MISS_XZQDM_FIELD);
            return result;
        }
    }

    private String getXzqdmSys(Geometry geo, String version) {
        String xzqdmsys = "";
        RegionVillage regionVillage = new RegionVillage();
        if (version != null) {
            regionVillage = regionService.queryRegionVillageByCoor(geo, version);
        } else {
            regionVillage = regionService.queryRegionVillageByCoor(geo);
        }
        if (regionVillage != null) {
            xzqdmsys = regionVillage.getCode();
        } else {
            RegionTown regionTown = new RegionTown();
            if (version != null) {
                regionTown = regionService.queryRegionTownCotain(geo, version);
            } else {
                regionTown = regionService.queryRegionTownCotain(geo);
            }
            if (regionTown != null) {
                xzqdmsys = regionTown.getCode() + "000";
            } else {
                try {
                    String wkt = WKTUtil.geomToWkt(geo);
                    RegionDetail region = new RegionDetail();
                    if (version != null) {
                        region = regionService.queryRegionByGeomByVersion(wkt, 4490, 3, version);
                    } else {
                        region = regionService.queryRegionByGeom(wkt, 4490, 3);
                    }
                    xzqdmsys = region.getCode() + "000000";
                } catch ( Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return xzqdmsys;
    }

    private HashMap<String,Object> getXzqdmSys(Geometry pt,Geometry geo,int proNum) throws SQLException {
        HashMap<String, Object> map = new HashMap<>();
        try {
            String wkt = WKTUtil.geomToWkt(pt);
            String sql = "select * from ((select f_xzqdm as xzqdm,f_xzqmc as xzqmc,3 as level from tb_region where st_contains(shape, st_geomfromtext('" + wkt + "',4490)) and f_level =3  limit 1)\n" +
                    "union\n" +
                    "(select xzqdm,xzqmc,4 as level from tb_region_town where st_contains(geom, st_geomfromtext('" + wkt + "',4490)) limit 1)\n" +
                    "union\n" +
                    "(select xzqdm,xzqmc,5 as level from tb_region_village where st_contains(geom, st_geomfromtext('" + wkt + "',4490)) limit 1)) as q order by q.level";

            List<Map<String, Object>> maps = jdbcTemplate.queryForList(sql);

            Map<String, Object> region = null;
            Map<String, Object> regionTown = null;
            Map<String, Object> regionVillage = null;

            for(int i=0;i<maps.size();i++){
                Object xzqdm = maps.get(i).get("xzqdm");
                if(xzqdm==null)continue;

                if(xzqdm.toString().length()==12){
                    regionVillage = maps.get(i);
                }
                else if(xzqdm.toString().length()==9){
                    regionTown = maps.get(i);
                }
                else if(xzqdm.toString().length()==6){
                    region = maps.get(i);
                }
            }

            String location = "";
            String xzqdmsys = "";
            String xzqmc = "";
            if (regionVillage!=null && regionVillage.get("xzqdm") != null) {
                xzqdmsys = regionVillage.get("xzqdm").toString();
                location = regionVillage.get("xzqmc") != null ? regionVillage.get("xzqmc").toString() : "";
                xzqmc = regionVillage.get("xzqmc") != null ? regionVillage.get("xzqmc").toString() : "";
            }
            if (regionTown!=null && regionTown.get("xzqdm") != null) {
                if (org.apache.commons.lang3.StringUtils.isBlank(xzqdmsys)) {
                    xzqdmsys = regionTown.get("xzqdm").toString() + "000";
                    xzqmc = regionTown.get("xzqmc") != null ? regionTown.get("xzqmc").toString() : "";
                }
                location = (regionTown.get("xzqmc") != null ? regionTown.get("xzqmc").toString() : "") + location;
            }
            if (region!=null && region.get("xzqdm") != null) {
                if (org.apache.commons.lang3.StringUtils.isBlank(xzqdmsys)) {
                    xzqdmsys = region.get("xzqdm").toString() + "000000";
                    xzqmc = region.get("xzqmc") != null ? region.get("xzqmc").toString() : "" + location;
                }
                location = (region.get("xzqmc") != null ? region.get("xzqmc").toString() : "") + location;
            }

            String areasql = "select st_area(ST_Transform(ST_GeomFromText('" + WKTUtil.geomToWkt(geo) + "',4490)," + proNum + "))/666.6666667 as area";
            Map<String, Object> areaMap = jdbcTemplate.queryForMap(areasql);
            String area = areaMap.get("area").toString();
            BigDecimal bigDecimal = new BigDecimal(Double.valueOf(area));

            map.put("area",bigDecimal);
            map.put("xzqdmsys", xzqdmsys);
            map.put("xzqmc", xzqmc);
            map.put("location", location);
        }
        catch (Exception e){
            throw new SQLException(e.getMessage());
        }

        return map;
    }

    private int getColNum(Double xLine) {
        int proNum = 2362;
        if (xLine >= 75.5 && xLine < 78.5) {
            proNum = 2353;
        } else if (xLine >= 78.5 && xLine < 81.5) {
            proNum = 2354;
        } else if (xLine >= 81.5 && xLine < 84.5) {
            proNum = 2355;
        } else if (xLine >= 84.5 && xLine < 87.5) {
            proNum = 2356;
        } else if (xLine >= 87.5 && xLine < 90.5) {
            proNum = 2357;
        } else if (xLine >= 90.5 && xLine < 93.5) {
            proNum = 2358;
        } else if (xLine >= 93.5 && xLine < 96.5) {
            proNum = 2359;
        } else if (xLine >= 96.5 && xLine < 99.5) {
            proNum = 2360;
        } else if (xLine >= 99.5 && xLine < 112.5) {
            proNum = 2361;
        } else if (xLine >= 112.5 && xLine < 115.5) {
            proNum = 2362;
        } else if (xLine > 115.5 && xLine < 118.5) {
            proNum = 2363;
        } else if (xLine > 118.5 && xLine < 121.5) {
            proNum = 2364;
        } else if (xLine > 121.5 && xLine < 124.5) {
            proNum = 2365;
        } else if (xLine > 124.5 && xLine < 127.5) {
            proNum = 2366;
        } else if (xLine > 127.5 && xLine < 130.5) {
            proNum = 2367;
        } else if (xLine > 130.5 && xLine < 133.5) {
            proNum = 2368;
        } else if (xLine > 133.5 && xLine < 136.5) {
            proNum = 2369;
        }
        return proNum;
    }

    /**
     * 解析字段默认值
     *
     * @param map
     * @param fieldDefaults
     */
    public void resolveFieldDefault(HashMap<String, Object> map, List<String> fieldDefaults) {
        if (fieldDefaults.size() > 0) {
            for (String fieldDefault : fieldDefaults) {
                try {
                    if (map.containsKey(fieldDefault)) {
                        if (map.get(fieldDefault) != null) {
                            if (!map.get(fieldDefault).toString().contains("fields")) {
                                if ("{\"value\":null}".equalsIgnoreCase(map.get(fieldDefault).toString())) {
                                    map.put(fieldDefault, null);
                                }
                                continue;
                            } else {
                                JSONObject jsonObject = JSONObject.parseObject(map.get(fieldDefault).toString());
                                //场景一：fields为空时
                                if ("".equalsIgnoreCase(jsonObject.getString("fields")) || jsonObject.getString("fields") == null) {
                                    map.put(fieldDefault, jsonObject.getString("value"));
                                } else if (!"".equalsIgnoreCase(jsonObject.getString("fields"))) {
                                    String[] fieldArray = jsonObject.getString("fields").split(",");
                                    //根据表达式转换数据计算默认值
                                    map.put(fieldDefault, jexlConverData(map, fieldArray, jsonObject.getString("value")));
                         /*   //场景二 fields不为空时，只包含一个字段时
                            if(!jsonObject.getString("fields").contains(",")){
                                map.put(fieldDefault,map.get(jsonObject.getString("value")));
                            }else{
                                //场景三 fields不为空时，包含多个字段时
                                String [] fieldArray = jsonObject.getString("fields").split(",");
                                for(String field: fieldArray){
                                    map.put(fieldDefault,map.get(fieldDefault).toString().replace(field,map.get(field).toString()));
                                }
                            }*/
                                }
                            }
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                    map.put(fieldDefault, null);
                }
            }
        }
    }

    /**
     * 根据表达式转换数据
     *
     * @param map
     * @param fieldArray 涉及字段
     * @param jexlExp    表达式
     * @return
     */
    public Object jexlConverData(HashMap<String, Object> map, String[] fieldArray, String jexlExp) {
        JexlBuilder jexlB = new JexlBuilder();
        JexlEngine jexl = jexlB.create();
        //用ExpressionFactory类的静态方法createExpression创建一个Expression对象
        JexlExpression e = jexl.createExpression(jexlExp);
        //初始化一个JexlContext对象，它代表一个执行JEXL表达式的上下文环境
        JexlContext jc = new MapContext();
        for (String field : fieldArray) {
            //向执行JEXL表达式的上下文环境的变量字典中存入变量对应值
            jc.set(field, map.get(field));
        }
        //对这个Expression对象求值，传入执行JEXL表达式的上下文环境对象
        Object obj = e.evaluate(jc);
        return obj;
    }

    public String generatorSeqByXzqdm(String bizId, String type, String code, String tableId, TbtskObjectinfo table) throws Exception {
        String gen = "";
        String key = String.format("%s@%s@%s", bizId, code, type);
        if (redisTemplate.hasKey(key)) {
            String numStr = redisTemplate.opsForValue().get(key);
            Integer num = Integer.parseInt(numStr) + 1;
            gen = String.format("%s%s%s", code, type, generByNumDB(num));
            redisTemplate.opsForValue().set(key, num.toString());
        } else {
            if (table == null) {
                table = getTableByTableId(tableId);
            }
            Integer count = getNumDataByXzqdm(table, type, code);
            Integer num = count + 1;
            gen = String.format("%s%s%s", code, type, generByNumDB(num));
            redisTemplate.opsForValue().set(key, num.toString());
        }
        return gen;
    }

    private String generByNumDB(Integer count) throws Exception {
        int idx = count.toString().length();
        if (idx > 5) {
            throw new RuntimeException("生成编码的数量超过了5位数");
        }
        String gener = "";
        switch (idx) {
            case 1:
                gener = "0000" + count;
                break;
            case 2:
                gener = "000" + count;
                break;
            case 3:
                gener = "00" + count;
                break;
            case 4:
                gener = "0" + count;
                break;
            case 5:
                gener = count.toString();
                break;
            default:
                break;
        }
        return gener;
    }

    void addDatatoMap(TbtskObjectinfo table, Map map, SimpleFeature sf, String fieldType, String fieldName, String rname,
                      String chasetStr, Integer nullable, Integer order, String defaultValue) throws Exception {

        DecimalFormat format = new DecimalFormat("######0.0000000");

        switch (fieldType) {
            case "varchar":
                String value1 = getStrValue(sf.getAttribute(fieldName), chasetStr);
                if (value1 == null || "null".equalsIgnoreCase(value1) || "".equals(value1)) {
                    if (order != null && nullable == 0) {
                        throw new RuntimeException(rname + "不能为空");
                    } else {
                        map.put(fieldName, StringUtils.isBlank(defaultValue) ? null : defaultValue);
                    }
                } else {
                    map.put(fieldName, value1);
                }
                break;
            case "decimal":
                if (!"f_lat".equals(fieldName) && !"f_lon".equals(fieldName)) {
                    String tmp1 = getStrValue(sf.getAttribute(fieldName), chasetStr);
                    if (tmp1 == null || isMessyCode(tmp1) || "".equals(tmp1)) {
                        if (order != null && nullable == 0) {
                            throw new RuntimeException(rname + "不能为空");
                        } else {
                            /*  map.put(fieldName, StringUtils.isBlank(defaultValue) ? null : Double.valueOf(defaultValue));*/
                            map.put(fieldName, defaultValue);
                        }
                    } else {
                        Double value2 = Double.valueOf(tmp1);
                        map.put(fieldName, value2);
                    }
                }
                break;
            case "int4":
                String tmp2 = getStrValue(sf.getAttribute(fieldName), chasetStr);
                if (tmp2 == null || isMessyCode(tmp2) || "".equals(tmp2)) {
                    if (order != null && nullable == 0) {
                        throw new RuntimeException(rname + "不能为空");
                    } else {
                        /* map.put(fieldName, StringUtils.isBlank(defaultValue) ? null : Integer.valueOf(defaultValue));*/
                        map.put(fieldName, defaultValue);
                    }
                } else {
                    Integer value3 = Integer.valueOf(tmp2);
                    map.put(fieldName, value3);
                }
                break;
            case "timestamp":
                String tmp3 = getStrValue(sf.getAttribute(fieldName), chasetStr);
                if (tmp3 == null || isMessyCode(tmp3) || "".equals(tmp3)) {
                    if (order != null && nullable == 0) {
                        throw new RuntimeException(rname + "不能为空");
                    } else {
                        map.put(fieldName, null);
                    }
                } else {
                    try {
                        DateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                        Date date = df.parse(tmp3);
                        Timestamp value5 = new Timestamp(date.getTime());
                        map.put(fieldName, value5);
                    } catch (java.text.ParseException e) {
                        DateTimeFormatter df = DateTimeFormatter.ofPattern("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US);
                        LocalDateTime localDateTime = LocalDateTime.parse(tmp3, df);
                        Date date = Date.from(localDateTime.atZone(ZoneOffset.ofHours(8)).toInstant());
                        Timestamp value5 = new Timestamp(date.getTime());
                        map.put(fieldName, value5);
                    }
                }
                break;
            case "text":
                String value2 = getStrValue(sf.getAttribute(fieldName), chasetStr);
                if (value2 == null || "null".equalsIgnoreCase(value2) || "".equals(value2)) {
                    if (order != null && nullable == 0) {
                        throw new RuntimeException(rname + "不能为空");
                    } else {
                        map.put(fieldName, StringUtils.isBlank(defaultValue) ? null : defaultValue);
                    }
                } else {
                    map.put(fieldName, value2);
                }
                break;
            case "geometry":
                Geometry geo = (Geometry) sf.getDefaultGeometry();
                if ("f_shape".equalsIgnoreCase(fieldName)) {
                    if (geo == null) {
                        break;
                    } else {
                        map.put(fieldName, WKTUtil.geomToWkt(geo));
                        map.put("f_shape1", WKTUtil.geomToWkt(geo));
                        if (table.getfSpatialtype() != null && table.getfSpatialtype().equals("1")) {
                            if (geo.getGeometryType().equals("Point")) {
                                Geometry geo1 = (Point) sf.getDefaultGeometry();
                                if (geo1 != null) {
                                    map.put("f_lat", format.format(((Point) geo1).getY()));
                                    map.put("f_lon", format.format(((Point) geo1).getX()));
                                } else {
                                    map.put("f_lat", "0.0");
                                    map.put("f_lon", "0.0");
                                }
                            } else {
                                Point point = geo.getCentroid();
                                if (point != null) {
                                    map.put("f_lat", format.format(point.getY()));
                                    map.put("f_lon", format.format(point.getX()));
                                } else {
                                    map.put("f_lat", "0.0");
                                    map.put("f_lon", "0.0");
                                }
                            }
                        } else {
                            Point point = geo.getCentroid();
                            if (point != null) {
                                map.put("f_lat", format.format(point.getY()));
                                map.put("f_lon", format.format(point.getX()));
                            } else {
                                map.put("f_lat", "0.0");
                                map.put("f_lon", "0.0");
                            }
                        }

                    }
                } else if ("f_shape_g".equalsIgnoreCase(fieldName)) {
                    // google
                    if (table.getfSpatialtype() != null && table.getfSpatialtype().equals("1")) {
                        if (geo.getGeometryType().equals("Point")) {
                            Geometry geo1 = (Point) sf.getDefaultGeometry();
                            Point point = converPoint((Point) geo1, 1);
                            map.put("f_shape_g", WKTUtil.geomToWkt(point));
                            if (geo1 != null) {
                                map.put("f_lat_g", format.format(((Point) point).getY()));
                                map.put("f_lon_g", format.format(((Point) point).getX()));
                            } else {
                                map.put("f_lat_g", "0.0");
                                map.put("f_lon_g", "0.0");
                            }
                        } else {
                            Geometry geometry_g = convertGeometry(geo, 1);
                            map.put("f_shape_g", WKTUtil.geomToWkt(geometry_g));
                            Point point_g = geometry_g.getCentroid();
                            if (point_g != null) {
                                map.put("f_lat_g", format.format(point_g.getY()));
                                map.put("f_lon_g", format.format(point_g.getX()));
                            } else {
                                map.put("f_lat_g", "0.0");
                                map.put("f_lon_g", "0.0");
                            }
                        }
                    } else if (table.getfSpatialtype() != null && table.getfSpatialtype().equals("2")) {
                        if (geo.getGeometryType().equals("LineString")) {
                            Geometry geo1 = (LineString) sf.getDefaultGeometry();
                            LineString pg = (LineString) geo1;
                            LineString lineString1 = convertLineString1(pg, 1);
                            map.put("f_shape_g", WKTUtil.geomToWkt(lineString1));
                            if (lineString1 != null) {
                            	 Point centroid = lineString1.getCentroid();
                                map.put("f_lat_g", format.format(centroid.getY()));
                                map.put("f_lon_g", format.format(centroid.getX()));
                            } else {
                                map.put("f_lat_g", "0.0");
                                map.put("f_lon_g", "0.0");
                            }
                        } else if (geo.getGeometryType().equals("MultiLineString")) {
                            Geometry multiLineString = convertMultiLineString((MultiLineString) sf.getDefaultGeometry(), 2);
                            map.put("f_shape_g", WKTUtil.geomToWkt(multiLineString));
                         
                            if (multiLineString != null) {
                            	   Point centroid = multiLineString.getCentroid();
                                map.put("f_lat_g", format.format(centroid.getY()));
                                map.put("f_lon_g", format.format(centroid.getX()));
                            } else {
                                map.put("f_lat_g", "0.0");
                                map.put("f_lon_g", "0.0");
                            }
                        } else {
                            Geometry geometry_g = convertGeometry(geo, 1);
                            map.put("f_shape_g", WKTUtil.geomToWkt(geometry_g));
                            Point point_g = geometry_g.getCentroid();
                            if (point_g != null) {
                                map.put("f_lat_g", format.format(point_g.getY()));
                                map.put("f_lon_g", format.format(point_g.getX()));
                            } else {
                                map.put("f_lat_g", "0.0");
                                map.put("f_lon_g", "0.0");
                            }
                        }
                    } else {
                        Geometry geometry_g = convertGeometry(geo, 1);
                        map.put("f_shape_g", WKTUtil.geomToWkt(geometry_g));
                        Point point_g = geometry_g.getCentroid();
                        if (point_g != null) {
                            map.put("f_lat_g", format.format(point_g.getY()));
                            map.put("f_lon_g", format.format(point_g.getX()));
                        } else {
                            map.put("f_lat_g", "0.0");
                            map.put("f_lon_g", "0.0");
                        }
                    }
                /*    Geometry geometry_g = convertGeometry(geo, 1);
                    map.put("f_shape_g", WKTUtil.geomToWkt(geometry_g));
                    Point point_g = geometry_g.getCentroid();
                    if (point_g != null) {
                        map.put("f_lat_g", format.format(point_g.getY()));
                        map.put("f_lon_g", format.format(point_g.getX()));
                    } else {
                        map.put("f_lat_g", "0.0");
                        map.put("f_lon_g", "0.0");
                    }*/
                } else if ("f_shape_b".equalsIgnoreCase(fieldName)) {
                    // baidu
                    if (table.getfSpatialtype() != null && table.getfSpatialtype().equals("1")) {
                        if (geo.getGeometryType().equals("Point")) {
                            Geometry geo1 = (Point) sf.getDefaultGeometry();
                            Point point = converPoint((Point) geo1, 2);
                            map.put("f_shape_b", WKTUtil.geomToWkt(point));
                            if (geo1 != null) {
                                map.put("f_lat_b", format.format(point.getY()));
                                map.put("f_lon_b", format.format(point.getX()));
                            } else {
                                map.put("f_lat_b", "0.0");
                                map.put("f_lon_b", "0.0");
                            }
                        } else {
                            Geometry geometry_b = convertGeometry(geo, 2);
                            map.put("f_shape_b", WKTUtil.geomToWkt(geometry_b));
                            Point point_b = geometry_b.getCentroid();
                            if (point_b != null) {
                                map.put("f_lat_b", format.format(point_b.getY()));
                                map.put("f_lon_b", format.format(point_b.getX()));
                            } else {
                                map.put("f_lat_b", "0.0");
                                map.put("f_lon_b", "0.0");
                            }
                        }
                    } else if (table.getfSpatialtype() != null && table.getfSpatialtype().equals("2")) {
                        if (geo.getGeometryType().equals("LineString")) {
                            Geometry geo1 = (LineString) sf.getDefaultGeometry();
                            LineString lineString1 = convertLineString1((LineString) geo1, 2);
                            map.put("f_shape_b", WKTUtil.geomToWkt(lineString1));

                            
                            if (lineString1 != null) {
                            	Point centroid = lineString1.getCentroid();
                                map.put("f_lat_b", format.format(centroid.getY()));
                                map.put("f_lon_b", format.format(centroid.getX()));
                            } else {
                                map.put("f_lat_b", "0.0");
                                map.put("f_lon_b", "0.0");
                            }
                        } else if (geo.getGeometryType().equals("MultiLineString")) {
                            Geometry geo1 = (MultiLineString) sf.getDefaultGeometry();
                            Geometry multiLineString = convertMultiLineString((MultiLineString) geo1, 2);
                            map.put("f_shape_b", WKTUtil.geomToWkt(multiLineString));
                           
                            if (multiLineString != null) {
                            	 Point centroid = multiLineString.getCentroid();
                                map.put("f_lat_b", format.format(centroid.getY()));
                                map.put("f_lon_b", format.format(centroid.getX()));
                            } else {
                                map.put("f_lat_b", "0.0");
                                map.put("f_lon_b", "0.0");
                            }
                        } else {
                            Geometry geometry_b = convertGeometry(geo, 2);
                            map.put("f_shape_b", WKTUtil.geomToWkt(geometry_b));
                            Point point_b = geometry_b.getCentroid();
                            if (point_b != null) {
                                map.put("f_lat_b", format.format(point_b.getY()));
                                map.put("f_lon_b", format.format(point_b.getX()));
                            } else {
                                map.put("f_lat_b", "0.0");
                                map.put("f_lon_b", "0.0");
                            }
                        }
                    } else {
                        Geometry geometry_b = convertGeometry(geo, 2);
                        map.put("f_shape_b", WKTUtil.geomToWkt(geometry_b));
                        Point point_b = geometry_b.getCentroid();
                        if (point_b != null) {
                            map.put("f_lat_b", format.format(point_b.getY()));
                            map.put("f_lon_b", format.format(point_b.getX()));
                        } else {
                            map.put("f_lat_b", "0.0");
                            map.put("f_lon_b", "0.0");
                        }
                    }
                  /*  Geometry geometry_b = convertGeometry(geo, 2);
                    map.put("f_shape_b", WKTUtil.geomToWkt(geometry_b));
                    Point point_b = geometry_b.getCentroid();
                    if (point_b != null) {
                        map.put("f_lat_b", format.format(point_b.getY()));
                        map.put("f_lon_b", format.format(point_b.getX()));
                    } else {
                        map.put("f_lat_b", "0.0");
                        map.put("f_lon_b", "0.0");
                    }*/
                }

                break;
            default:
                break;
        }
    }

    private Geometry convertGeometry(Geometry geometry, int type) {
        Geometry result = null;
        if (geometry instanceof MultiPolygon) {
            MultiPolygon multiPolygon = (MultiPolygon) geometry;
            Polygon[] garray = new Polygon[multiPolygon.getNumGeometries()];
            for (int i = 0; i < multiPolygon.getNumGeometries(); i++) {
                Polygon polygon = (Polygon) multiPolygon.getGeometryN(i);
                garray[i] = convertPolygon(polygon, type);
            }
            result = geometryFactory.createMultiPolygon(garray);
        } else if (geometry instanceof Geometry) {
            result = convertPolygon(geometry, type);
        }
        return result;
    }


    private Polygon convertPolygon(Geometry geometry, int type) {
        Coordinate[] coords = new Coordinate[geometry.getCoordinates().length];
        if (geometry instanceof Polygon) {
            Polygon pg = (Polygon) geometry;

            // 外环
            LineString exteriorRing = pg.getExteriorRing();
            LinearRing lineString = convertLineString(exteriorRing, type);

            // 内环
            LinearRing[] holes = new LinearRing[pg.getNumInteriorRing()];
            for (int i = 0; i < pg.getNumInteriorRing(); i++) {
                LineString interiorRingN = pg.getInteriorRingN(i);

                LinearRing lineString1 = convertLineString(interiorRingN, type);
                holes[i] = lineString1;
            }

            Polygon polygon = geometryFactory.createPolygon(lineString, holes);
            return polygon;
        }

        return null;
    }

    private LinearRing convertLineString(LineString geometry, int type) {
        Coordinate[] coords = new Coordinate[geometry.getCoordinates().length];
        for (int i = 0; i < geometry.getCoordinates().length; i++) {
            if (type == 1) {
                // wgs84 转 gcj02
                GPSInfo gpsInfo = GPSUtil.WGS84_To_GCJ02(geometry.getCoordinates()[i].y, geometry.getCoordinates
                        ()[i].x);
                coords[i] = new Coordinate(gpsInfo.GetLon(), gpsInfo.GetLat());
            } else if (type == 2) {
                // wgs84 转 bd09
                GPSInfo gpsInfo = GPSUtil.WGS84_To_GCJ02(geometry.getCoordinates()[i].y, geometry.getCoordinates
                        ()[i].x);
                gpsInfo = GPSUtil.GCJ02_To_BD09(gpsInfo.GetLat(), gpsInfo.GetLon());
                coords[i] = new Coordinate(gpsInfo.GetLon(), gpsInfo.GetLat());
            }
        }

        return geometryFactory.createLinearRing(coords);
    }

    private LineString convertLineString1(LineString geometry, int type) {
        Coordinate[] coords = new Coordinate[geometry.getCoordinates().length];
        for (int i = 0; i < geometry.getCoordinates().length; i++) {
            if (type == 1) {
                // wgs84 转 gcj02
                GPSInfo gpsInfo = GPSUtil.WGS84_To_GCJ02(geometry.getCoordinates()[i].y, geometry.getCoordinates
                        ()[i].x);
                coords[i] = new Coordinate(gpsInfo.GetLon(), gpsInfo.GetLat());
            } else if (type == 2) {
                // wgs84 转 bd09
                GPSInfo gpsInfo = GPSUtil.WGS84_To_GCJ02(geometry.getCoordinates()[i].y, geometry.getCoordinates
                        ()[i].x);
                gpsInfo = GPSUtil.GCJ02_To_BD09(gpsInfo.GetLat(), gpsInfo.GetLon());
                coords[i] = new Coordinate(gpsInfo.GetLon(), gpsInfo.GetLat());
            }
        }
        return geometryFactory.createLineString(coords);
    }

    private Geometry convertMultiLineString(Geometry geometry, int type) {
        Geometry result = null;
        if (geometry instanceof MultiLineString) {
            MultiLineString multiPolygon = (MultiLineString) geometry;
            LineString[] array = new LineString[multiPolygon.getNumGeometries()];

            for (int i = 0; i < multiPolygon.getNumGeometries(); i++) {
                LineString LineString = (LineString) multiPolygon.getGeometryN(i);
                array[i] = convertLineString1(LineString, type);
            }
            result = geometryFactory.createMultiLineString(array);
        } else if (geometry instanceof Geometry) {
            result = convertPolygon(geometry, type);
        }
        return result;
    }

    private Point converPoint(Point geometry, int type) {
        Coordinate coord = new Coordinate();
        if (type == 1) {
            // wgs84 转 gcj02
            GPSInfo gpsInfo = GPSUtil.WGS84_To_GCJ02(geometry.getY(), geometry.getX());
            coord = new Coordinate(gpsInfo.GetLon(), gpsInfo.GetLat());
        } else if (type == 2) {
            // wgs84 转 bd09
            GPSInfo gpsInfo = GPSUtil.WGS84_To_GCJ02(geometry.getY(), geometry.getX());
            gpsInfo = GPSUtil.GCJ02_To_BD09(gpsInfo.GetLat(), gpsInfo.GetLon());
            coord = new Coordinate(gpsInfo.GetLon(), gpsInfo.GetLat());
        }
        return geometryFactory.createPoint(coord);
    }

    public TskTaskBiz findByTaskId(String taskId) {
        return tskTaskBizRepository.findById(taskId).orElse(null);
    }

    public TskTaskBiz findByTableId(String tableId) {
        return tskTaskBizRepository.findByTableId(tableId);
    }

    public List<TbtskFieldGroupView> findViewFieldsByTaskId(String taskId) {
        TskTaskBiz taskBiz = tskTaskBizRepository.findById(taskId).orElse(null);
        return tbtskFieldsGroupViewRepository.getTbtskFieldsBySysCodeAndGroupCode(taskBiz.getTableId(), "web", "1");
    }

    //@Transactional
    public void deleteByDataId(String dataId, String taskId) {
        TskTaskBiz taskBiz = tskTaskBizRepository.findById(taskId).orElse(null);
        TbtskObjectinfo tableInfo = tbtskObjectinfoRepository.findById(taskBiz.getTableId()).orElse(null);

        // 删除图斑数据
        mDataBizService.delete(tableInfo.getfTablename(), "f_id", dataId);
        // 删除下发记录
        tskAssignRecordRepository.deleteByDataId(dataId);
        //删除附件
        appMediaRepository.deleteByGalleryid(dataId);
        //删除截图服务数据
        tbgstRepository.deleteByBizIdAndTbId(taskId, dataId);
    }

    //@Transactional
    public void deleteByDataIds(List<String> dataIds, String taskId) {
        TskTaskBiz taskBiz = tskTaskBizRepository.findById(taskId).orElse(null);
        TbtskObjectinfo tableInfo = tbtskObjectinfoRepository.findById(taskBiz.getTableId()).orElse(null);

        // 删除图斑数据
        mDataBizService.deleteByCond(tableInfo.getfTablename(),"f_id in ('"+StringUtils.join(dataIds,"','")+"')");
        //如果有子图斑则删除子图斑信息
        if(StringUtils.isNotBlank(tableInfo.getSplitTableName()) && !dataIds.isEmpty()){
            mDataBizService.deleteByCond(tableInfo.getSplitTableName(),"f_splitedid in ('"+StringUtils.join(dataIds,"','")+"')");
        }
        // 删除下发记录
        tskAssignRecordRepository.deleteByDataIds(dataIds);
        //删除附件
        appMediaRepository.deleteByGalleryids(dataIds);
        //删除截图服务数据
        tbgstRepository.deleteByBizIdAndTbIds(taskId, dataIds);
    }

    private void delchildTb(TskTaskBiz biz, TbtskObjectinfo parntableInfo, String dataId) {
        TbtskObjectinfo tableInfo = tbtskObjectinfoRepository.findById(biz.getTableId()).orElse(null);
        JSONObject relfield = JSONObject.parseObject(tableInfo.getRelfield());
        List<String> fieldNameList = new ArrayList<>();
        fieldNameList.add("f_id");
        fieldNameList.add(relfield.getString("fieldName"));
        // 获取父图斑数据
        Map parentlist = mDataBizService.selectFieldByID(parntableInfo.getfTablename(), fieldNameList, "f_id", "'" + dataId + "'");
        //获取子图斑数据
        List<Map> list = mDataBizService.queryAllData(tableInfo.getfTablename(), fieldNameList, relfield.getString
                ("fieldName") + "= '" + parentlist.get(relfield.getString("fieldName")).toString() + "'");
        // 删除子图斑数据
        mDataBizService.deleteByCond(tableInfo.getfTablename(), relfield.getString("fieldName") + "= '" + parentlist.get(relfield.getString("fieldName")).toString() + "'");
        for (Map map : list) {
            // 删除下发记录
            tskAssignRecordRepository.deleteByDataId(map.get("f_id").toString());
            //删除附件
            appMediaRepository.deleteByGalleryid(map.get("f_id").toString());
        }
    }


    public TbtskObjectinfo getTableByTableId(String id) {
        return tbtskObjectinfoRepository.findById(id).orElse(null);
    }

    public TskAssignRecord getRecordByTaskIdAndExecutorId(String dataId, Long userId) {
        List<TskAssignRecord> records = tskAssignRecordRepository.findByDataIdAndOptUserId(dataId, userId.toString());
        if (records.size() > 0) {
            return records.get(0);
        } else {
            return null;
        }
    }

    public List<Map> findMapByTaskIdAndDataIds(String taskId, List<String> dataIds, TbtskObjectinfo table) {
        List<TbtskFields> flist = tbtskFieldsRepository.getTbtskFieldsByTableid(table.getfId());

        List<String> fields = new ArrayList<>();
        for (TbtskFields f : flist) {
            fields.add(f.getfFieldname());
        }
        String where = " 1=1 and f_id in ('" + StringUtils.join(dataIds, "','") + "')";

        List<Map> list = mDataBizService.queryAllData(table.getfTablename(), fields, where);
        return list;
    }

    public List<Map> findMapByTaskIdAndDate(TbtskObjectinfo table, String date) {
        List<TbtskFields> flist = tbtskFieldsRepository.getTbtskFieldsByTableid(table.getfId());

        List<String> fields = new ArrayList<>();
        for (TbtskFields f : flist) {
            fields.add(f.getfFieldname());
        }
        String where = " 1=1 and f_createtime > '" + date + "'";

        List<Map> list = mDataBizService.queryAllData(table.getfTablename(), fields, where);
        return list;
    }

    public TbtskObjectinfo findTableByTaskId(String taskId) {
        TskTaskBiz tskTaskBiz = tskTaskBizRepository.findById(taskId).orElse(null);
        if (tskTaskBiz == null) {
            return null;
        }
        TbtskObjectinfo table = tbtskObjectinfoRepository.findById(tskTaskBiz.getTableId()).orElse(null);
        return table;
    }

    public List<TbtskFields> getFieldsByTableId(String tableId) {
        return tbtskFieldsRepository.getTbtskFieldsByTableid(tableId);
    }

    public List<TbtskFields> getFieldsNotOutFields(String tableId, List<Integer> list) {
        return tbtskFieldsRepository.getFieldsNotOutFields(tableId, list);
    }

    @Transactional
    public void createRecord(List<String> taskids, JSONArray groups, JSONArray orgs, Long userId, String taskId) {
        for (int i = 0; i < taskids.size(); i++) {
            String dataId = taskids.get(i);
            for (int j = 0; j < groups.size(); j++) {
                if (isJson(groups.get(j).toString())) {
                    JSONArray uidJs = groups.getJSONObject(j).getJSONArray("userids");
                    String groupid = groups.getJSONObject(j).getString("groupid");
                    for (Long executorId : uidJs.toJavaList(Long.class)) {
                        saveRecord(dataId, executorId, taskId, userId, "group", groupid);
                    }
                }
            }
            if (orgs == null) {
                continue;
            }
            for (int k = 0; k < orgs.size(); k++) {
                JSONArray uidJs = orgs.getJSONObject(k).getJSONArray("userids");
                String org = orgs.getJSONObject(k).getString("orgid");
                for (Long executorId : uidJs.toJavaList(Long.class)) {
                    saveRecord(dataId, executorId, taskId, userId, "org", org);
                }
            }
        }
    }

    @Transactional
    public TskAssignRecord addRecord(TskAssignRecord record) throws Exception {
        List<TskAssignRecord> list = findAssignRecord(record.getTaskId(), record.getAssignto(), record.getDataId());
        if (list == null || list.size() < 1) {
            record.setCreateTime(new Timestamp(System.currentTimeMillis()));
            //设置图斑状态为未提交
            TbtskObjectinfo table = findTableByTaskId(record.getTaskId());
            Map<String, Object> map = new HashMap<>();
            map.put("f_status", "2");
            mDataBizService.updateData(table.getfTablename(), map, "f_id = '" + record.getDataId() + "'");

            return tskAssignRecordRepository.save(record);
        }
        return null;
    }

    private void saveRecord(String dataId, Long assignId, String taskId, Long userId, String type, String orgId) {
        List<TskAssignRecord> list = findAssignRecord(taskId, assignId.toString(), dataId);
        TskAssignRecord record = null;

        if (list == null || list.size() < 1) {
            record = new TskAssignRecord();
            record.setCreateTime(new Timestamp(System.currentTimeMillis()));
        } else {
            record = list.get(0);
        }
        if (record.getStatus() == null || !"1".equals(record.getStatus())) {
            record.setSourceId(orgId);
            record.setSourceType(type);
            record.setCreateTime(new Timestamp(System.currentTimeMillis()));
            record.setDataId(dataId);
            record.setOptUserId(userId.toString());
            record.setTaskId(taskId);
            record.setAssignto(assignId.toString());
            record.setStatus("1");
            record.setUpdateTime(new Timestamp(System.currentTimeMillis()));
            tskAssignRecordRepository.save(record);
        }
    }

    public List<TskAssignRecord> getRecordByDataId(Object dataId) {
        List<TskAssignRecord> records = tskAssignRecordRepository.findByDataId(dataId.toString());
        /*if (records.size() > 0) {
            return records.get(0);
        } else {
            return null;
        }*/
        return records;
    }


    public Iterable<TskTaskBiz> findTaskBiz() {
        return tskTaskBizRepository.findAll();
    }

    @Transactional
    public void deleteRecordById(String recordId, Long userId) {
        tskAssignRecordRepository.deleteByDataIdAndAssignto(recordId, userId.toString());
    }

    @Transactional
    public void deleteBatchByDataId(String ids, String taskId) {
        JSONArray array = JSONArray.parseArray(ids);
        for (int i = 0; i < array.size(); i++) {
            String obj = array.getString(i);
            deleteByDataId(obj, taskId);
        }
    }

    //@Transactional
    public void deleteBatchByDataIds(String ids, String taskId) {
        JSONArray array = JSONArray.parseArray(ids);
        deleteByDataIds(JSONObject.parseArray(array.toString(),String.class),taskId);
    }

    @Transactional
    public TskAssignRecord update(TskAssignRecord tskAssignRecord) {
        return tskAssignRecordRepository.save(tskAssignRecord);
    }

    public List<TskAssignRecord> findAssignRecord(String taskId, String userId, String dataId) {
        return tskAssignRecordRepository.findByTaskIdAndAssigntoAndDataId(taskId, userId, dataId);
    }

    public List<TskAssignRecord> findAssignRecordList(String taskId, String userId, String dataId) {
        return tskAssignRecordRepository.findByTaskIdAndAssigntoAndDataId(taskId, userId, dataId);
    }

    public List<TskAssignRecord> findByTaskIdAndDataId(String taskId, String dataId) {
        return tskAssignRecordRepository.findByTaskIdAndDataId(taskId, dataId);
    }

    public List<String> checkRecordsBytbIds(String taskId, String tbIds) {
        List<String> list = new ArrayList<>();
        JSONArray arr = JSONArray.parseArray(tbIds);
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < arr.size(); i++) {
            String tbId = arr.getString(i);
            if (i != 0) {
                str.append(",");
            }
            str.append(tbId);
        }
        if (StringUtils.isNotBlank(str.toString())) {
            list = tskAssignRecordRepository.findByTaskIdAndTbIds(taskId, str.toString());
        }
        return list;
    }

    public List<TskAssignRecord> findByStatusOrder(String taskId, String dataId) {
        return tskAssignRecordRepository.findOrderByCreateTime(taskId, dataId);
    }

    @Transactional
    public TskTaskBiz update(TskTaskBiz taskBiz) {
        return tskTaskBizRepository.save(taskBiz);
    }


    @Transactional
    public TskTaskBiz save(TskTaskBiz taskBiz, String regions, int step) {
        if (taskBiz.getFinish() == null) {
            taskBiz.setFinish(0);
        }
        // 监测表是否已经创建，并且存在数据
        if (taskBiz.getTableId() != null) {
            TbtskObjectinfo one = tbtskObjectinfoRepository.findById(taskBiz.getTableId()).orElse(null);
            if (one != null) {
                one.setfTableversion(one.getfTableversion() == null ? 1 : one.getfTableversion() + 1);
                one.setfTablealias(taskBiz.getName());
                tbtskObjectinfoRepository.save(one);
                if (one.getfTablename() != null && step > 1) {
                    Integer countDatas = getCountDatas(one);
                    if (countDatas > 0) {
                        throw new RuntimeException("表中存在数据，不允许编辑");
                    }
                }
            }
        }
        taskBiz = tskTaskBizRepository.save(taskBiz);
        final String id = taskBiz.getId();
        if (regions != null) {
            List<BizArea> bizAreas = Arrays.asList(regions.split(",")).stream().map(r -> new BizArea(r, id)).collect(Collectors.toList());
            bizAreaRepository.deleteByBizId(id);
            bizAreaRepository.saveAll(bizAreas);
        }
        return taskBiz;
    }

    public TskTaskBiz save(TskTaskBiz taskBiz) {
        return tskTaskBizRepository.save(taskBiz);
    }

    public List<BizArea> getTskTaskBizArea(String id) {
        return bizAreaRepository.findByBizId(id);
    }

    public List<BizArea> getTskTaskBizAreaByBizId(String id) {
        return bizAreaRepository.queryByBizId(id);
    }


    public List<TskTaskBiz> findByUserId(String userId) {
        return tskTaskBizRepository.findByUserId(userId);
    }

    @Transactional
    public void deleteBatchRecordById(String dataIds, Long userId) {
        JSONArray array = JSONArray.parseArray(dataIds);
        for (int i = 0; i < array.size(); i++) {
            String obj = array.getString(i);
            deleteRecordById(obj, userId);
        }
    }

    /**
     * 获得任务图斑数
     * 不存在时抛出异常
     *
     * @param obj
     * @return
     */
    public Integer getCountDatas(TbtskObjectinfo obj) {
        GutilAssert.notNull(obj,"TbtskObjectinfo不能为空 ");
        GutilAssert.notNull(obj.getfTablename(),"表不存在");
        String tableName = obj.getfTablename();
        if (mDataBizService.isExistTableName(tableName)) {
            Integer total = mDataBizService.getCount(obj.getfTablename(), "");
            return total;
        } else {
            throw new RuntimeException(tableName + "表不存在");
        }
    }

    /**
     * 获得任务作业区数量
     * 不存在时抛出异常
     *
     * @param obj
     * @return
     */
    public Integer getOperAreaCount(TbtskObjectinfo obj) {
        GutilAssert.notNull(obj,"TbtskObjectinfo不能为空 ");
        GutilAssert.notNull(obj.getfTablename(),"表不存在");
        String tableName = obj.getfTablename();
        if (mDataBizService.isExistTableName(tableName)) {
            List<Map> maps = mDataBizService.queryDataBySql("select f_xzqdm,count(1)  from " + tableName + " group by f_xzqdm");
            return maps.size();
        } else {
            throw new RuntimeException(tableName + "表不存在");
        }

    }

    public Integer getCountDatasApp(TbtskObjectinfo obj, String areas) {
        Integer total = 0;
        for (String area : areas.split(",")) {
            Integer count = 0;
            if ("1".equals(area)) {
                count = mDataBizService.getCount(obj.getfTablename(), " f_ismycreate=1 ");
            } else {
                if (area.lastIndexOf("0000") == 2) {
                    count = mDataBizService.getCount(obj.getfTablename(),
                            " f_xzqdm like '" + area.substring(0, area.indexOf("0000")) + "%' and f_ismycreate=1");
                } else if (area.lastIndexOf("00") == 4) {
                    count = mDataBizService.getCount(obj.getfTablename(),
                            " f_xzqdm like '" + area.substring(0, area.indexOf("00")) + "%' and f_ismycreate=1");
                } else {
                    count = mDataBizService.getCount(obj.getfTablename(),
                            " f_xzqdm like '" + area + "%' and f_ismycreate=1");
                }
            }
            total += count;
        }
        return total;
    }

    public Integer getCountDatasAppMy(TbtskObjectinfo obj, String userid) {
        Integer count = mDataBizService.getCount(obj.getfTablename(),
                " f_userid = '" + userid + "' and f_ismycreate=1");

        return count;
    }

    public Integer getCountDatasByArea(TbtskObjectinfo obj, String areas) {
        Integer total = 0;
        for (String area : areas.split(",")) {
            Integer count = 0;
            if ("1".equals(area)) {
                count = mDataBizService.getCount(obj.getfTablename(), "");
            } else {
                if (area.lastIndexOf("0000") == 2) {
                    count = mDataBizService.getCount(obj.getfTablename(),
                            " f_xzqdm like '" + area.substring(0, area.indexOf("0000")) + "%'");
                } else if (area.lastIndexOf("00") == 4) {
                    count = mDataBizService.getCount(obj.getfTablename(),
                            " f_xzqdm like '" + area.substring(0, area.indexOf("00")) + "%'");
                } else {
                    count = mDataBizService.getCount(obj.getfTablename(),
                            " f_xzqdm like '" + area + "%'");
                }
            }
            total += count;
        }
        return total;
    }

    public Integer getCountMyDatas(Long userId, TbtskObjectinfo obj) {
        Integer total = mDataBizService.getCount(obj.getfTablename(), " f_userid = '" + userId + "'");
        return total;
    }

    public Integer getCountMyComDatas(Long userId, TskTaskBiz biz) {
        return tskAssignRecordRepository.countByAssigntoAndTaskIdAndStatus(userId.toString(), biz.getId(), "4");
    }

    /**
     * 只查询下发给userId的已提交的图斑数量
     *
     * @param userId
     * @param biz
     * @param obj
     * @return
     */
    public Integer getCountMyStatusDatas(Long userId, TskTaskBiz biz, TbtskObjectinfo obj) {
        List<TskAssignRecord> list = tskAssignRecordRepository.findByOptUserIdAndTaskIdAndStatus(userId.toString(), biz.getId(), "1");
        //Set<String> taskIds = new HashSet<>();
        StringBuffer sb = new StringBuffer();
        for (TskAssignRecord t : list) {
            //taskIds.add(t.getTaskId());
            sb.append("'").append(t.getDataId()).append("',");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
            Integer count = mDataBizService.getCount(obj.getfTablename(), " f_id in (" + sb + ") and (f_status = '4')");
            return count;
        }
        return 0;
    }

    /**
     * 查询该任务下已提交的图斑数量
     *
     * @param obj
     * @return
     */
    public Integer getCountMyStatusDatas(TbtskObjectinfo obj, String areas) {
        Integer total = 0;
        for (String area : areas.split(",")) {
            Integer count = 0;
            if ("1".equals(area)) {
                count = mDataBizService.getCount(obj.getfTablename(), " f_status = '4' ");
            } else {
                if (area.lastIndexOf("0000") == 2) {
                    count = mDataBizService.getCount(obj.getfTablename(),
                            " f_xzqdm like '" + area.substring(0, area.indexOf("0000")) + "%' and f_status = '4'");
                } else if (area.lastIndexOf("00") == 4) {
                    count = mDataBizService.getCount(obj.getfTablename(),
                            " f_xzqdm like '" + area.substring(0, area.indexOf("00")) + "%' and f_status = '4'");
                } else {
                    count = mDataBizService.getCount(obj.getfTablename(),
                            " f_xzqdm like '" + area + "%' and f_status = '4'");
                }
            }
            total += count;
        }
        //Integer count = dataBizService.getCount(obj.getfTablename(), " (f_status = '4')");
        return total;

    }

    public Integer getCountMyStatusDatasMy(TbtskObjectinfo obj, String userid) {
        Integer count = mDataBizService.getCount(obj.getfTablename(),
                " f_userid = '" + userid + "' and f_status = '4'");

        return count;
    }

    public List<TskTaskBiz> findBizPermissionByUserId(Long userId, Integer level) {
        List<TskTaskBiz> list = tskTaskBizRepository.findBizPermissionByUserId(userId, level);
        getOtherInfo(list, userId);
        return list;
    }

    public List<TskTaskBiz> findBizPermissionByUserId3(Long userId, Integer level) {
        List<TskTaskBiz> list = tskTaskBizRepository.findBizPermissionByUserId(userId, level);
        return list;
    }

    public List<TskTaskBiz> findBizPermissionByUserId2(Long userId) {
        List<TskTaskBiz> list = tskTaskBizRepository.findBizPermissionByUserId(userId);
        return list;
    }

    public List<TskTaskBiz> findBizPermissionByUserId(Long userId) {
        List<TskTaskBiz> list = tskTaskBizRepository.findBizPermissionByUserId(userId);
        getOtherInfo(list, userId);
        return list;
    }

    public List<TskTaskBiz> findBizPermissionByUserIdAndGroupId(Long userId, Long groupId) {
        List<TskTaskBiz> list = tskTaskBizRepository.findBizPermissionByUserIdAndGroupId(userId, groupId);
        getOtherInfo(list, userId);
        return list;
    }


    public List<TskTaskBiz> findZyyBizPermissionByUserId(Long userId) {

        List<TskTaskBiz> list = tskTaskBizRepository.findBizPermissionByUserId(userId, 3);
        for (TskTaskBiz biz : list) {
            Integer myTotal = 0;
            TbtskObjectinfo table = tbtskObjectinfoRepository.findById(biz.getTableId()).orElse(null);
            if ("1".equals(biz.getType()) || 2 == biz.getMode()) {
                List<String> areas = tskRightAreaRepository.findXzqdmByTaskIdAndUserId(biz.getId(), userId.toString());
                String filter = " 1=2 ";
                if (areas != null && !areas.isEmpty()) {
                    filter = " f_xzqdm in ('" + StringUtils.join(areas, "','") + "')";
                }
                myTotal = mDataBizService.getCount(table.getfTablename(), filter);
            } else {
                myTotal = tskAssignRecordRepository.countByAssigntoAndTaskId(userId.toString(), biz.getId());
            }

            Integer myCommit = tskAssignRecordRepository.countByAssigntoAndTaskIdAndStatus(userId.toString(), biz.getId(), "1");
            Integer level = getBizManageLevel(userId, biz.getId());
            biz.setManageLevel(level);
            biz.setMyCount(myTotal);
            biz.setCommitCount(myCommit);
            biz.setTag(table.getfRemark());
        }
        return list;
    }

    /**
     * 李密浩：获取用户任务Service
     *
     * @param userId    用户ID
     * @param taskName  任务名称，模糊查询
     * @param pageIndex 页码
     * @param rows      每页行数
     * @return 任务列表
     */
    public Map<String, Object> findMyTaskBizByUserId(Long userId, String taskName, int pageIndex, int rows, Integer
            classId) {
        Map map = new HashMap();
        Long count = 0L;
        //task列表
        List<TskTaskBiz> list = new ArrayList<>();
        //通过用户Id获取taskId列表
        List<Integer> roleList = Arrays.asList(2, 3, 4);
        List<String> bizIdList = new ArrayList<>();
        if (classId != null) {
            List<Long> arr = new ArrayList<>();
            List<Long> classIds = findAllChildClass(arr, Long.valueOf(classId.toString())).stream().distinct().collect(Collectors.toList());
            bizIdList = userBiz2Repository.getUserBiz2ByUserIdAndRoleListLeftBiz(userId, roleList, classIds);
        } else {
            bizIdList = userBiz2Repository.getUserBiz2ByUserIdAndRoleListNotDel(userId, roleList);
        }
        if (!GutilCollection.isEmpty(bizIdList)) {

            StringBuffer stringBuffer = new StringBuffer();
            //分页
            Page<TskTaskBiz> tskTaskBizs = null;

            //拼接查询所用到的taskId值
            for (String string : bizIdList) {
                stringBuffer.append(string);
                stringBuffer.append(",");
            }
            String str = "Q_id_S_IN=" + stringBuffer + ";";
            //判断是否按照task名称进行模糊查询
            if (!"".equals(taskName)) {
                str += "Q_name_S_LK=" + taskName + ";";
            }
//            if (classId != null) {
//                str += "Q_classId_S_IN=" +  + ";";
//            }
            tskTaskBizs = tskTaskBizRepository.findAll(new QuerySpecification<>(str), PageRequest.of(pageIndex - 1, rows));
            list = tskTaskBizs.getContent();
            count = tskTaskBizs.getTotalElements();
            //我的
            Integer myTotal = 0;
            //总数
            Integer total = 0;
            //提交数量
            Integer commit = 0;
            //作业区区数量
            Integer areaCount = 0;
            //未提交数量
            Integer enable = 0;
            for (TskTaskBiz tskTaskBiz : list) {
                if (tskTaskBiz.getTableId() != null) {
                    TbtskObjectinfo table = tbtskObjectinfoRepository.findById(tskTaskBiz.getTableId()).orElse(null);
                    if (table != null) {
                        //分组
                        if (classId != null) {
                            // 前端需要总数判断是否可删除,使用allCount来记录
                            if (table.getfTablename() != null) {
                                tskTaskBiz.setAllCount(getCountDatas(table));
                                // 此处记录的是当前人所拥有的
                                tskTaskBiz.setTaskOperAreaCount(getOperAreaCount(table));
                            }
                        } else {
                            //任务模式1：下发模式
                            if (tskTaskBiz.getMode() == 1) {
                                //存在重复下发 对下发记录dataid进行去重
                                total = mDataBizService.getAssignCountDistinctDataId("tbtsk_assign_record", "f_taskid='" + tskTaskBiz.getId() + "' and f_assignto='" + userId + "'");
                                myTotal = total;
                                //下发给用户的dataid
                                List<String> dataIds = tskAssignRecordRepository.findByTaskIdAndAndAssignto(tskTaskBiz.getId(), userId.toString())
                                        .stream().map(r -> r.getDataId()).distinct().collect(Collectors.toList());
                                String dataIdListStr = StringUtils.join(dataIds, "','");
                                commit = mDataBizService.getCount(table.getfTablename(), " f_id in ('" + dataIdListStr + "') and f_status >= 4");
                                //下发模式未提交直接用总数-已提交
                                enable = total - commit;
                            } else {
                                //2:认领模式
                                List<String> areas = tskRightAreaRepository.findXzqdmByTaskIdAndUserId(tskTaskBiz.getId(), userId.toString());
                                String filter = " 1=2 ";
                                if (areas != null && !areas.isEmpty()) {
                                    filter = " 1=1 and (";
                                    for (int i = 0; i < areas.size(); i++) {
                                        filter += " f_xzqdmsys like ";
                                        filter += "'" + areas.get(i) + "%'";
                                        if (i < areas.size() - 1) {
                                            filter += " or ";
                                        }
                                    }
                                    filter += ")";
                                }
                                total = mDataBizService.getCount(table.getfTablename(), filter);
                                //下发给我的dataid去重
                                List<String> dataIds = tskAssignRecordRepository.findByTaskIdAndAndAssignto(tskTaskBiz.getId(), userId.toString())
                                        .stream().map(r -> r.getDataId()).distinct().collect(Collectors.toList());
                                String dataIdListStr = StringUtils.join(dataIds, "','");
//                        myTotal = dataBizService.getCount("tbtsk_assign_record", " f_taskid='" + tskTaskBiz.getId() + "' and f_assignto='" + userId + "'");
                                myTotal = dataIds.size();
                                commit = mDataBizService.getCount(table.getfTablename(), "f_id in ('" + dataIdListStr + "') and f_status >= 4 and " + filter);
                                enable = mDataBizService.getCount(table.getfTablename(), "f_id in ('" + dataIdListStr + "') and f_status <4 and " + filter);
                            }
                            areaCount = mDataBizService.getCount("tbtsk_right_area", " f_taskid='" + tskTaskBiz.getId() + "' and f_userid='" + userId + "'");
                            // 前端需要总数判断是否可删除,使用allCount来记录
                            tskTaskBiz.setAllCount(getCountDatas(table));
                            // 此处记录的是当前人所拥有的
                            tskTaskBiz.setTaskOperAreaCount(getOperAreaCount(table));
                        }
                    }
                    tskTaskBiz.setTotal(total);
                    tskTaskBiz.setMyCount(myTotal);
                    tskTaskBiz.setCommitCount(commit);
                    tskTaskBiz.setMyWorkAreaCount(areaCount);
                    tskTaskBiz.setEnable(enable);
                    //任务范围
                    List<BizArea> tskTaskBizArea = getTskTaskBizAreaByBizId(tskTaskBiz.getId());
                    if (!tskTaskBizArea.isEmpty()) {
                        List<String> collect = tskTaskBizArea.stream().map(a -> a.getArea()).collect(Collectors.toList());
                        tskTaskBiz.setTaskArea(StringUtils.join(collect, ","));
                    }
                }
            }
        }
        map.put("list", list);
        map.put("count", count);
        return map;
    }


    public JSONObject queryMyDailyTaskByUserId(Long userId, String taskName, Integer classId, int pageIndex, int rows) {
        JSONObject jsonObject = new JSONObject();
        Pageable pageable  = PageRequest.of(pageIndex - 1, rows,QueryParamUtil.parseSortParams("SORT_createTime_DESC"));
        //通过用户Id获取taskId列表
        List<Integer> roleList = Arrays.asList(2, 3, 4);
        List<Long> classIds = new ArrayList<>();
        if (classId != null) {
            List<Long> arr = new ArrayList<>();
            classIds = findAllChildClass(arr, Long.valueOf(classId.toString())).stream().distinct().collect(Collectors.toList());
        }else{
            classIds = tskTaskBizRepository.queryClassIsByUserId(userId);
        }
        if(org.apache.commons.lang3.StringUtils.isNotBlank(taskName)){
            taskName = "%"+taskName+"%";
        }else{
            taskName = "%%";
        }
        if(classIds == null && classIds.size() <= 0 ){
            jsonObject.put("total", 0);
            jsonObject.put("list",new ArrayList<>());
        }else{
            Page<TskTaskBiz> tskTaskBizs = tskTaskBizRepository.findMyBizList(userId,taskName,roleList,classIds.size() == 0 ?  null : classIds,pageable);
            List<TskTaskBiz> list = tskTaskBizs.getContent();
            Long count  = tskTaskBizs.getTotalElements();
            for(TskTaskBiz tskTaskBiz : list){
                //任务范围
                List<BizArea> tskTaskBizArea = getTskTaskBizAreaByBizId(tskTaskBiz.getId());
                if (!tskTaskBizArea.isEmpty()) {
                    List<String> collect = tskTaskBizArea.stream().map(a -> a.getArea()).collect(Collectors.toList());
                    tskTaskBiz.setTaskArea(StringUtils.join(collect, ","));
                }
                if (org.apache.commons.lang3.StringUtils.isBlank(tskTaskBiz.getTableId())) continue;
                // 我的图斑数：下发给我的图斑数
                TbtskObjectinfo table = tbtskObjectinfoRepository.getObjectByTableId(tskTaskBiz.getTableId());
                if (table == null || org.apache.commons.lang3.StringUtils.isBlank(table.getfTablename())) continue;
                 //我的作业区数量
                List<String> areas = tskRightAreaRepository.findXzqdmByTaskIdAndUserId(tskTaskBiz.getId(), userId.toString());
                tskTaskBiz.setMyWorkAreaCount(areas.size());
                //判断表是否存在
                if (mDataBizService.isExistTableName(table.getfTablename())) {
                    //获取图斑总数
                    String allCount1 = getCacheByUserId("101","allCount_"+tskTaskBiz.getId() ,0);
                    if(org.apache.commons.lang3.StringUtils.isNotBlank(allCount1)){
                        tskTaskBiz.setTotalCount(Integer.valueOf(allCount1));
                    }else{
                        String countSql = "select count(1) from " + table.getfTablename();
                        Integer allCount = jdbcTemplate.queryForObject(countSql, Integer.class);
                        tskTaskBiz.setTotalCount(allCount);
                        getCacheByUserId("101","allCount_"+tskTaskBiz.getId() ,allCount);
                    }

                    //获取下发给我的图斑数
                    String assignCount = getCacheByUserId(userId.toString(),"assignCount_"+tskTaskBiz.getId() ,0);
                    if(org.apache.commons.lang3.StringUtils.isNotBlank(assignCount)){
                        tskTaskBiz.setAssignCount(Integer.valueOf(assignCount));
                    }else{
                        String assignCountSql = "select count(distinct(tb.f_id)) from "+table.getfTablename()+" tb ,tbtsk_assign_record tar where tb.f_id = tar.f_dataid and tar.f_assignto ='"+userId+"' ";
                        Integer assignCount1 = jdbcTemplate.queryForObject(assignCountSql, Integer.class);
                        tskTaskBiz.setAssignCount(assignCount1);
                        getCacheByUserId(userId.toString(),"assignCount_"+tskTaskBiz.getId() ,assignCount1);
                    }
                    //获取已提交数据
                    String commitCount = getCacheByUserId(userId.toString(),"commitCount_"+tskTaskBiz.getId() ,0);
                    if(org.apache.commons.lang3.StringUtils.isNotBlank(commitCount)){
                        tskTaskBiz.setCommitCount(Integer.valueOf(commitCount));
                    }else{
                        String commitCountSql = "select count(distinct(tb.f_id)) from "+table.getfTablename()+" tb ,tbtsk_assign_record tar where tb.f_id = tar.f_dataid and   tb.f_status >=4 and tar.f_assignto ='"+userId+"' ";
                        Integer commitCount1 = jdbcTemplate.queryForObject(commitCountSql, Integer.class);
                        tskTaskBiz.setCommitCount(commitCount1);
                        getCacheByUserId(userId.toString(),"commitCount_"+tskTaskBiz.getId() ,commitCount1);
                    }
                }
                //查询任务对应的tbtskObjectinfos数据
                List<TbtskObjectinfo> objectbyTaskId =  mTbtskObjectinfoService.getObjectbyTaskId(tskTaskBiz.getId());
                tskTaskBiz.setTbtskObjectinfos(objectbyTaskId);
            }
            jsonObject.put("total", count);
            jsonObject.put("list",list);
        }

        return jsonObject;
    }


    public List<TskTaskBiz> findMyManageBizListByUserId(Long userId) {
        List<TskTaskBiz> list = tskTaskBizRepository.findMyManageBizListByUserId(userId);
        getOtherInfo(list, userId);
        return list;
    }


    //缓存数据
    public String getCacheByUserId(String userId,String key,Integer count) {
        Long USERNAME_LOCK_OUTTIME = 6*600L;
        String resultValue = "";
        if (StringUtils.isNotBlank(userId)) {
             key = key+"_" + userId;
            if (this.redisTemplate.hasKey(key)) {
                resultValue = this.redisTemplate.opsForValue().get(key).toString();
            } else {
                this.redisTemplate.opsForValue().set(key, count.toString(), USERNAME_LOCK_OUTTIME, TimeUnit.SECONDS);
            }
        }

        return resultValue;
    }


    private List<TskTaskBiz> getOtherInfo(List<TskTaskBiz> list, Long userId) {
        for (TskTaskBiz biz : list) {
            Integer myTotal = tskAssignRecordRepository.countByAssigntoAndTaskId(userId.toString(), biz.getId());
            Integer myCommit = tskAssignRecordRepository.countByAssigntoAndTaskIdAndStatus(userId.toString(), biz.getId(), "1");
            Integer level = getBizManageLevel(userId, biz.getId());
            biz.setManageLevel(level);
            biz.setMyCount(myTotal);
            biz.setCommitCount(myCommit);
        }
        return list;
    }

    public List<TskTaskBiz> findMyManageBizAndPublic(List<Long> userIds) {
        List<TskTaskBiz> list = new ArrayList<>();

        List<TskTaskBiz> list1 = tskTaskBizRepository.findMyManageBizListByUserIds(userIds);
        list.addAll(list1);

        List<TskTaskBiz> list2 = tskTaskBizRepository.findPublicBiz();
        list.addAll(list2);

        return list;
    }


    public List<TskTaskBiz> findByIsDel() {
        return tskTaskBizRepository.findByIsDel();
    }

    public Map findDataByBizIdAndDataId(String bizId, String tbId) {
        TskTaskBiz tskTaskBiz = findByTaskId(bizId);
        TbtskObjectinfo tableInfo = tbtskObjectinfoRepository.findById(tskTaskBiz.getTableId()).orElse(null);
        List<TbtskFields> fieldsList = getFieldsByTableId(tableInfo.getfId());
        List<String> fields = new ArrayList<>();
        for (TbtskFields f : fieldsList) {
            fields.add(f.getfFieldname());
        }
        Map currObj = mDataBizService.selectFieldByID(tableInfo.getfTablename(), fields, "f_id", "'" + tbId + "'");
        return currObj;
    }

    /**
     * 查询任务列表统计数据
     *
     * @param userId
     * @param filterParam
     * @param sortParam
     * @param page
     * @param rows
     * @return
     */
    public Page<TskTaskBiz> queryDailyTaskStatisticDataByUserId(Long userId, String filterParam, String sortParam, int page, int rows) {
        GutilAssert.state(userId > 0, "userId can not be negative number.");
        GutilAssert.notNull(filterParam, "filterParam can not be null.");
        GutilAssert.state(rows > 0, "can not be negative number.");

        if (StringUtils.isBlank(sortParam)) {
            sortParam = "SORT_createTime_DESC";
        }

        if (StringUtils.isNotBlank(filterParam)) {
            filterParam += ";";
        }
        // 下发给我的业务
        List<UserBiz2> userBiz2s = userBiz2Repository.findByUserId(userId);
        List<String> bizs1 = new ArrayList<>();
        for (UserBiz2 u : userBiz2s) {
            if (!new Integer(3).equals(u.getRole())) {
                continue;// 只显示作业员的
            }
            bizs1.add(u.getBizId());
        }
        String sqlIds = StringUtils.join(bizs1, ",");

        filterParam += "(Q_isDel_N_NE=1;QOR_isDel_N_EQ=null);Q_id_S_IN=" + (StringUtils.isNotBlank(sqlIds) ? sqlIds : "-1");
        Page<TskTaskBiz> list = findPages(filterParam, sortParam, page, rows);
        List<TskTaskBiz> bizs = list.getContent();
        if (bizs != null && bizs.size() > 0) {
            for (TskTaskBiz biz : bizs) {

                if (StringUtils.isBlank(biz.getTableId())) {
                    continue;
                }
                // 我的图斑数：下发给我的图斑数
                TbtskObjectinfo table = tbtskObjectinfoRepository.findById(biz.getTableId()).orElse(null);
                if (table == null || StringUtils.isBlank(table.getfTablename())) {
                    continue;
                }
                Integer myTotal = 0;

                List<String> areas = tskRightAreaRepository.findXzqdmByTaskIdAndUserId(biz.getId(), userId.toString());
                biz.setMyWorkAreaCount(areas.size());

                if ("2".equals(biz.getType())) {
                    //智能管理
                    String sql = "";
                    if (2 == biz.getMode()) {
                        //认领模式
                        sql = "select count(1) from " + table.getfTablename() + " a where exists (select null from tbtsk_right_area b where a.f_xzqdm=b.f_xzqdm and b.f_userid ='" + userId + "' and b.f_taskid='" + biz.getId() + "')";
                    } else {
                        //下发模式
                        sql = "select count(distinct a.f_dataid) from tbtsk_assign_record a where a.f_taskid='" + biz.getId() + "' and a.f_assignto=''||" + userId;
                    }
                    SqlRowSet row = jdbcTemplate.queryForRowSet(sql);
                    while (row.next()) {
                        myTotal = row.getInt(1);
                        break;
                    }
                } else {
                    if ("1".equals(biz.getType()) || 2 == biz.getMode()) {


                        String filter = " 1=2 ";
                        if (areas != null && !areas.isEmpty()) {
                            filter = " f_xzqdm in ('" + StringUtils.join(areas, "','") + "')";
                        }
                        myTotal = mDataBizService.getCount(table.getfTablename(), filter);
                    } else {
                        myTotal = tskAssignRecordRepository.countByAssigntoAndTaskId(userId.toString(), biz.getId());
                    }
                }
                //Integer myCount = tskAssignRecordRepository.countByAssigntoAndTaskId(userId.toString(), biz.getId());
                // 已提交：图斑数据表中已提交的 状态为4
//                Integer myCommitCount = dataBizService.getCount(table.getfTablename(), " f_status='4'");//2020-06-21 刘鹏修改
                // 统计对图斑id进行了过滤
                Integer myCommitCount = tskAssignRecordRepository.countDataIdByAssigntoAndTaskIdAndStatus(userId.toString(), biz.getId(), "1");//原来版本
                biz.setMyCount(myTotal);
                biz.setCommitCount(myCommitCount);
                biz.setTag(table.getfRemark());
            }
        }
        return list;
    }

    public boolean hasManageAuthority(Long userId) {
        List<UserBiz2> userBiz2s = userBiz2Repository.queryMyManageTaskByUserId(userId);
        return userBiz2s != null && userBiz2s.size() > 0;
    }

    public Integer getTemplateUseState(String templateId) {
        Integer result = 0;
        List<TskTaskBiz> list = tskTaskBizRepository.findByTemplateIdUnDel(templateId);
        if (list != null && list.size() > 0) {
            result = 1;
        }
        return result;
    }


    @Transactional
    public void updateTemplateFileUrl(String dataName, String workflowName, String userFileName, String taskId) {
        TskTaskBiz template = tskTaskBizRepository.findById(taskId).orElse(null);
        if (StringUtils.isNotBlank(dataName)) {
            template.setDataUrl(dataName);
        }
        if (StringUtils.isNotBlank(workflowName)) {
            template.setWorkflowUrl(workflowName);
        }
        if (StringUtils.isNotBlank(userFileName)) {
            template.setUserUrl(userFileName);
        }
        tskTaskBizRepository.save(template);
    }

    @Transactional
    public void updateTemplateDataFileUrl(String dataName, String taskId) {
        TskTaskBiz template = tskTaskBizRepository.findById(taskId).orElse(null);
        if (StringUtils.isNotBlank(dataName)) {
            template.setDataUrl(dataName);
        }
        tskTaskBizRepository.save(template);
    }

    public List<String> findUserIdsByBizId(String bizId) {
        List<String> userIds = new ArrayList<>();
        Set<String> set = new HashSet<>();
        //3 表示作业员
        /* List<UserBiz2> list = userBiz2Repository.findByBizIdAndRole(bizId, 3);*/
        List<UserBiz2> list = userBiz2Repository.findByBizId(bizId);
        for (UserBiz2 ub : list) {
            set.add(ub.getUserId().toString());
        }
        userIds.addAll(set);
        return userIds;
    }

    public List findUserBiz2ByBizId(String bizId) {
        return userBiz2Repository.findUserBiz2DTOByBizId2(bizId);
    }

    public List findUserBiz2ByBizId(String bizId, Integer roleId) {
        return userBiz2Repository.findUserBiz2DTOByBizId2AndRoleId(bizId, roleId);
    }

    @Transactional
    public void saveRightAreas(List<String> areas, String taskId, String userId) {
        for (String area : areas) {
            TskRightArea ra = new TskRightArea();
            ra.setTaskId(taskId);
            ra.setUserId(userId);
            if (area.length() == 6 && area.lastIndexOf("00") == -1) {
                ra.setXzqdm(area);
            } else if (area.length() == 9 && area.lastIndexOf("000") == -1) {
                ra.setXzqdm(area);
            } else if (area.length() == 12 && area.lastIndexOf("000") == -1) {
                ra.setXzqdm(area);
            } else {
                continue;
            }
            saveRightArea(ra, userId);
        }
    }

    public void saveRightAreasNew(List<String> areas, String taskId, String userId) {
        for (String area : areas) {
            TskRightArea ra = new TskRightArea();
            ra.setTaskId(taskId);
            ra.setUserId(userId);
            ra.setXzqdm(area);
            saveRightArea(ra, userId);
        }
    }

    @Transactional
    public TskRightArea saveRightArea(TskRightArea rightArea, String userId) {
        List<TskRightArea> raList = tskRightAreaRepository.findByTaskIdAndUserIdAndXzqdm(rightArea.getTaskId(),
                rightArea.getUserId(), rightArea.getXzqdm());

        TskRightArea ra = null;
        if (raList == null || raList.size() < 1) {
            ra = tskRightAreaRepository.save(rightArea);

            TskTaskBiz tskTaskBiz = tskTaskBizRepository.findById(rightArea.getTaskId()).orElse(null);

            if (tskTaskBiz.getMode() == 2) {
                // 领取模式，订阅作业区消息
                mTaskNoticeNewService.addSubscribe(rightArea.getUserId(), "tsk|" + rightArea.getTaskId() + "|" + rightArea.getXzqdm());
            }
        }
        // 授权之前的业务消息
        //taskNoticeService.createNoticeForUser(rightArea.getXzqdm(),rightArea.getTaskId(),userId);

        return ra;
    }

    @Transactional
    public void deleteRightAreaByTaskId(String taskId, String userid) {
        tskRightAreaRepository.deleteByTaskIdAndUserId(taskId, userid);
    }

    public List<String> findRightAreas(String taskId, String userId) {
        return tskRightAreaRepository.findXzqdmByTaskIdAndUserId(taskId, userId);
    }

    /**
     * 获取用户管理区、审核区、复核区、作业区
     *
     * @param taskId
     * @param userId
     * @return
     */
    public UserBizAreaDTO findUserBizArea(String taskId, String userId) {
        UserBizAreaDTO userBizAreaDTO = new UserBizAreaDTO();
        userBizAreaDTO.setTaskId(taskId);
        //获取用户审核区域
        List<TbtskUserAuditArea> userAuditAreas = tbtskUserAuditAreaService.listAuditAreas(taskId, userId);
        if (userAuditAreas.size() > 0) {
            userAuditAreas.forEach(a -> a.setRegionName(getRegionName(a.getRegionCode())));
        }
        userBizAreaDTO.setUserAuditAreas(userAuditAreas);
        //获取用户超级审核区域
        List<TbtskSuperUserAuditArea> superUserAuditAreas = tbtskSuperUserAuditAreaService.listAuditAreas(taskId, userId);
        if (superUserAuditAreas.size() > 0) {
            superUserAuditAreas.forEach(a -> a.setRegionName(getRegionName(a.getRegionCode())));
        }
        userBizAreaDTO.setSuperUserAuditAreas(superUserAuditAreas);
        //获取用户复核区域
        List<TbtskUserReviewArea> userReviewAreas = tbtskUserReviewAreaService.listReviewAreas(taskId, userId);
        if (userReviewAreas.size() > 0) {
            userReviewAreas.forEach(a -> a.setRegionName(getRegionName(a.getRegionCode())));
        }
        userBizAreaDTO.setUserReviewAreas(userReviewAreas);
        //获取用户管理区
        List<TbtskUserManageArea> userManageAreas = tbtskUserManageAreaService.listManageAreas(taskId, userId);
        if (userManageAreas.size() > 0) {
            userManageAreas.forEach(a -> a.setRegionName(getRegionName(a.getRegioncode())));
        }
        userBizAreaDTO.setUserManageAreas(userManageAreas);
        List<String> areas = findRightAreas(taskId, userId);
        //获取用户作业区数据
        TskTaskBiz taskBiz = findByTaskId(taskId);
        GutilAssert.isTrue(taskBiz != null, "未查到对应任务");
        //选出县级作业区
        List<String> regions = areas.stream().filter(r -> r.length() == 6).collect(Collectors.toList());
        //选出乡级作业区
        List<String> towns = areas.stream().filter(r -> r.length() == 9).collect(Collectors.toList());
        //选出村级作业区
        List<String> villages = areas.stream().filter(r -> r.length() == 12).collect(Collectors.toList());
        //作业区详情列表
        List<Object> workLists = new ArrayList<>();

        if (!regions.isEmpty()) {
            List<Region> regs = regionService.findRegionsByXzqdms(regions);
            workLists.addAll(regs);
        }
        if (!towns.isEmpty()) {
            List<RegionTown> regs = regionService.findRegionsTownByXzqdms(towns);
            workLists.addAll(regs);
        }
        if (!villages.isEmpty()) {
            List<RegionVillage> regs = regionService.findRegionsVillageByXzqdms(villages);
            workLists.addAll(regs);
        }
        userBizAreaDTO.setUserOperAreas(workLists);

        //无需对粒度进行判断
//        if (taskBiz.getGranularity() != null && 5 == taskBiz.getGranularity()) {
//            // 5表示人物图斑下发粒度是村
//            List<RegionVillage> regs = regionService.findRegionsVillageByXzqdms(areas);
//            userBizAreaDTO.setUserOperAreas(regs);
//        } else if (taskBiz.getGranularity() != null && 4 == taskBiz.getGranularity()) {
//            // 4表示人物图斑下发粒度是乡
//            List<RegionTown> regs = regionService.findRegionsTownByXzqdms(areas);
//            userBizAreaDTO.setUserOperAreas(regs);
//        } else {
//            List<Region> regs = regionService.findRegionsByXzqdms(areas);
//            userBizAreaDTO.setUserOperAreas(regs);
//        }
        return userBizAreaDTO;
    }

    public String getRegionName(String regionCode) {
        String regionName = "";
        if (regionCode.length() == 12) {
            RegionVillage regionVillage = regionService.queryRegionVillageByCode(regionCode);
            regionName = regionVillage != null ? regionVillage.getName() : null;
        } else if (regionCode.length() == 9) {
            RegionTown regionTown = regionService.queryRegionTownByCode(regionCode);
            regionName = regionTown != null ? regionTown.getName() : null;
        } else {
            Region region = regionService.queryRegionByCode(regionCode);
            regionName = region != null ? region.getName() : null;
        }
        return regionName;
    }

    public List<String> findRightAreaRegs(String taskId, String userId) {
        return tskRightAreaRegRepository.findXzqdmByTaskIdAndUserId(taskId, userId);
    }

    public List<String> findRightAreaRegsUnStatus(String taskId, String userId) {
        return tskRightAreaRegRepository.findXzqdmByTaskIdAndUserIdAndStatus(taskId, userId);
    }

    @Transactional
    public void changeRightArea(final String taskId, final String userId, String regions) {
        //删除用户作业区
        tskRightAreaRepository.deleteByTaskIdAndUserId(taskId, userId);
        //删除用户领取模式top记录
        mTaskNoticeNewService.deleteSubscribeByUserIdAndBizId(userId, taskId);
        //新版本消息通知
        //先删除用户当前biz的所有subscribe记录 作业员
        List<NoticeSubscribe> zyyList = noticeSubscribeRepository.findSubscribeIdsByUserIdAndBizIdAndRole1(userId, taskId, 3);
        noticeSubscribeRepository.deleteAll(zyyList);
        //所有包含要绑定的作业区
        //List<String> tempRegionList = Arrays.asList(regions.split(","));
        //如果政区列表不为空 则按照作业区进行创建topic并绑定subscribe
        /*
        if (!tempRegionList.isEmpty()) {
            for (String region : tempRegionList) {
                if (StringUtils.isNotBlank(region)) {
                     userManageService.saveNoticeTopicAndNoticeSub(region, userId, taskId, 3);
                }
            }
        }
        */
        List<TaskNoticeSubscribe>notics = new ArrayList<>();
        if (StringUtils.isNotBlank(regions)) {
            List<TskRightArea> userRegionList = Arrays.asList(regions.split(","))
                    .stream()
                    .map(r -> new TskRightArea(r, taskId, userId))
                    .collect(Collectors.toList());
            tskRightAreaRepository.saveAll(userRegionList);

            TskTaskBiz tskTaskBiz = tskTaskBizRepository.findById(taskId).orElse(null);

            for (TskRightArea tskRightArea : userRegionList) {
                /*
                String topic = "";
                if (tskTaskBiz.getMode() == 1) {
                    // 下发模式
                    topic = "tsk|" + taskId;
                } else {
                    // 领取模式
                    topic = "tsk|" + taskId + "|" + tskRightArea.getXzqdm();
                }
                List<TaskNoticeSubscribe> subscribeByUserIdAndTopic = mTaskNoticeNewService.getSubscribeByUserIdAndTopic(tskRightArea.getUserId(), topic);
                if (subscribeByUserIdAndTopic != null && subscribeByUserIdAndTopic.size() > 0) {
                    continue;
                }

                mTaskNoticeNewService.addSubscribe(tskRightArea.getUserId(), topic);
                */

                String topic  = "tsk|" + taskId;

                List<TaskNoticeSubscribe> subscribeByUserIdAndTopic = mTaskNoticeNewService.getSubscribeByUserIdAndTopic(tskRightArea.getUserId(), topic);
                if (subscribeByUserIdAndTopic == null || subscribeByUserIdAndTopic.isEmpty()) {
                    TaskNoticeSubscribe taskNoticeSubscribe = new TaskNoticeSubscribe();
                    taskNoticeSubscribe.setId(UUID.randomUUID().toString());
                    taskNoticeSubscribe.setUserid(tskRightArea.getUserId());
                    taskNoticeSubscribe.setTopic(topic);
                    taskNoticeSubscribe.setDate(new Date());
                    notics.add(taskNoticeSubscribe);
                }

                topic = "tsk|" + taskId + "|" + tskRightArea.getXzqdm();
                subscribeByUserIdAndTopic = mTaskNoticeNewService.getSubscribeByUserIdAndTopic(tskRightArea.getUserId(), topic);
                if (subscribeByUserIdAndTopic == null || subscribeByUserIdAndTopic.isEmpty()) {
                    TaskNoticeSubscribe taskNoticeSubscribe = new TaskNoticeSubscribe();
                    taskNoticeSubscribe.setId(UUID.randomUUID().toString());
                    taskNoticeSubscribe.setUserid(tskRightArea.getUserId());
                    taskNoticeSubscribe.setTopic(topic);
                    taskNoticeSubscribe.setDate(new Date());
                    notics.add(taskNoticeSubscribe);
                }

            }
            if(!notics.isEmpty()) {
                mTaskNoticeNewService.addSubscribe(notics);
            }
        }
    }

    public void addSubscribe (TskTaskBiz task, List<TskRightArea>userRegionList) {
        //删除用户领取模式top记录
        List<String>userIds = userRegionList.stream().map(t->t.getUserId()).collect(Collectors.toList());
        mTaskNoticeNewService.deleteSubscribeByUserIdsAndBizId(userIds, task.getId());
        //新版本消息通知
        //先删除用户当前biz的所有subscribe记录 作业员
        List<NoticeSubscribe> zyyList = noticeSubscribeRepository.findSubscribeIdsByUserIdsAndBizIdAndRole1(userIds, task.getId(), 3);
        noticeSubscribeRepository.deleteAll(zyyList);

        List<TaskNoticeSubscribe>notics = new ArrayList<>();
        for (TskRightArea tskRightArea : userRegionList) {
            String topic  = "tsk|" + task.getId();

            List<TaskNoticeSubscribe> subscribeByUserIdAndTopic = mTaskNoticeNewService.getSubscribeByUserIdAndTopic(tskRightArea.getUserId(), topic);
            if (subscribeByUserIdAndTopic == null || subscribeByUserIdAndTopic.isEmpty()) {
                TaskNoticeSubscribe taskNoticeSubscribe = new TaskNoticeSubscribe();
                taskNoticeSubscribe.setId(UUID.randomUUID().toString());
                taskNoticeSubscribe.setUserid(tskRightArea.getUserId());
                taskNoticeSubscribe.setTopic(topic);
                taskNoticeSubscribe.setDate(new Date());
                notics.add(taskNoticeSubscribe);
            }

            topic = "tsk|" + task.getId() + "|" + tskRightArea.getXzqdm();
            subscribeByUserIdAndTopic = mTaskNoticeNewService.getSubscribeByUserIdAndTopic(tskRightArea.getUserId(), topic);
            if (subscribeByUserIdAndTopic == null || subscribeByUserIdAndTopic.isEmpty()) {
                TaskNoticeSubscribe taskNoticeSubscribe = new TaskNoticeSubscribe();
                taskNoticeSubscribe.setId(UUID.randomUUID().toString());
                taskNoticeSubscribe.setUserid(tskRightArea.getUserId());
                taskNoticeSubscribe.setTopic(topic);
                taskNoticeSubscribe.setDate(new Date());
                notics.add(taskNoticeSubscribe);
            }
            if(!notics.isEmpty()) {
                mTaskNoticeNewService.addSubscribe(notics);
            }
        }

    }

    /**
     * 追加用户作业区
     *
     * @param taskId
     * @param userId
     * @param regions
     */
    @Transactional
    public Boolean appendRightArea(final String taskId, final String userId, String regions) {

        List<TskRightArea> byTaskIdAndUserId = tskRightAreaRepository.findByTaskIdAndUserId(taskId, userId);
        List<String> byTaskIdAndUserIds = byTaskIdAndUserId.stream().map(r -> r.getXzqdm()).collect(Collectors.toList());
        if (StringUtils.isNotBlank(regions)) {
            List<TskRightArea> userRegionList = Arrays.asList(regions.split(","))
                    .stream()
                    .filter(r -> !byTaskIdAndUserIds.contains(r))// 不存在的追加
                    .map(r -> new TskRightArea(r, taskId, userId))
                    .collect(Collectors.toList());
            if (!userRegionList.isEmpty()) {
                for (TskRightArea bean : userRegionList) {
                    tskRightAreaRepository.save(bean);
                }
                return true;
            }

        }
        return false;

    }

    public Integer getNumDataByXzqdm(TbtskObjectinfo obj, String type, String xzqdm) {
        Integer count = mDataBizService.getCount(obj.getfTablename(), " f_tbbh like '%" + type + "%' and f_xzqdm = '" + xzqdm + "'");
        return count;
    }

    @Transactional
    public TskRightAreaReg saveTskRightAreaReg(TskRightAreaReg tskRightAreaReg) {
        return tskRightAreaRegRepository.save(tskRightAreaReg);
    }

    @Transactional
    public Iterable<TskRightAreaReg> saveTskRightAreaRegList(List<TskRightAreaReg> list) {
        return tskRightAreaRegRepository.saveAll(list);
    }

    public List<TskRightAreaReg> findTskRightAreaRegByIds(List<String> idsList) {
        return tskRightAreaRegRepository.findTskRightAreaRegByIds(idsList);
    }

    @Transactional
    public void verifyTskRightArea(List<TskRightAreaReg> regs, String remark, String status, Long userid, TskTaskBiz tskTaskBiz, HashMap<String, List<String>> map) {
        for (TskRightAreaReg reg : regs) {
            // 1表示审核通过
            if ("1".equals(status)) {
                TskRightArea tra = new TskRightArea();
                tra.setTaskId(reg.getTaskId());
                tra.setUserId(reg.getUserId());
                tra.setXzqdm(reg.getXzqdm());
                saveRightArea(tra, userid.toString());

                // 如果没有业务权限，则需要挂接业务权限
                List<UserBiz2> list = userBiz2Repository.findByUserIdAndBizId(Long.valueOf(reg.getUserId()), reg
                        .getTaskId());
                if (list == null || list.size() < 1) {
                    UserBiz2 userBiz2 = new UserBiz2();
                    userBiz2.setId(UUID.randomUUID().toString());
                    userBiz2.setBizId(reg.getTaskId());
                    userBiz2.setUserId(Long.valueOf(reg.getUserId()));
                    userBiz2.setRole(3);
                    userBiz2Repository.save(userBiz2);

                    mTaskNoticeNewService.addSubscribe(reg.getUserId(), "tsk|" + reg.getTaskId());
                }
                //新版本消息通知
                //保存作业员消息订阅记录
                /* userManageService.saveNoticeTopicAndNoticeSub(reg.getXzqdm(), reg.getUserId(), reg.getTaskId(), 3);*/
            }

            reg.setStatus(status);
            reg.setRemark(remark);
            tskRightAreaRegRepository.save(reg);
        }

        String titleStr = "";
        if ("1".equals(status)) {
            titleStr = "审核通过";
        } else {
            titleStr = "审核不通过";
        }

        List<TaskNoticeUserNew> taskNoticeUserNewList = new ArrayList<>();
        for (String key : map.keySet()) {
            List<String> xzqList = map.get(key);
            String xzqname = regionService.getName(xzqList.get(0));
            if (xzqList.size() > 1) {
                xzqname += "等";
            }
            String content = String.format("【%s】。任务名称：%s；申请作业区：%s %s个作业区；审核意见：%s", titleStr, tskTaskBiz.getName(), xzqname, regs.size(), remark);

            TaskNoticeUserNew taskNoticeUserNew = new TaskNoticeUserNew();
            taskNoticeUserNew.setId(UUID.randomUUID().toString());
            taskNoticeUserNew.setSenduser(userid.toString());
            taskNoticeUserNew.setTitle("作业区审核通知");
            taskNoticeUserNew.setContent(content);
            taskNoticeUserNew.setAction(9);
            taskNoticeUserNew.setTaskmode(tskTaskBiz.getMode());
            taskNoticeUserNew.setBizid(tskTaskBiz.getId());
            taskNoticeUserNew.setCount(xzqList.size());
            taskNoticeUserNew.setReceiveuser(key);
            taskNoticeUserNew.setData("");
            taskNoticeUserNew.setSenddate(new Date());

            taskNoticeUserNewList.add(taskNoticeUserNew);
        }

        mTaskNoticeNewService.addTaskNoticeUserNewList(taskNoticeUserNewList);
    }

    /**
     * @param userId
     * @param bizId
     * @param roleIds 只用与宅基地
     */
    @Transactional
    public void updateUserBiz(Long userId, String bizId, String roleIds) {
        // 宅基地前端只传 1，3
        userBiz2Repository.deleteByBizIdAndUserIdAndRole(bizId, userId, 1);
        userBiz2Repository.deleteByBizIdAndUserIdAndRole(bizId, userId, 3);

        //新版本消息通知
        //先删除管理员任务订阅记录 管理员配置一定会插入subscribe 无需判断 直接删除
        List<NoticeSubscribe> glySubscribes = noticeSubscribeRepository.findSubscribeIdsByUserIdAndBizIdAndRole1(userId.toString(), bizId, 1);
        noticeSubscribeRepository.deleteAll(glySubscribes);

        //配置任务作业员时不会向subscribe插入记录 需判断 否则会丢失角色权限
        if (Arrays.asList(roleIds.split(",")).indexOf("3") < 0) {
            //如果没有传作业员角色则删除
            List<NoticeSubscribe> zyySubscribes = noticeSubscribeRepository.findSubscribeIdsByUserIdAndBizIdAndRole1(userId.toString(), bizId, 4);
            noticeSubscribeRepository.deleteAll(zyySubscribes);
            //同时删除用户作业区
            tskRightAreaRepository.deleteByTaskIdAndUserId(bizId, userId.toString());
        }
        for (String s : roleIds.split(",")) {
            if (StringUtils.isBlank(s)) {
                continue;
            }
            Integer roleId = Integer.valueOf(s);
            //新版本消息通知
            //如果配置管理员则根据被配置的人员的政区进行绑定
            LandUser2Area landUser2Area = userAreaDao.queryOneByUserId(userId);
            if (landUser2Area != null && roleId == 1) {
                /* userManageService.saveNoticeTopicAndNoticeSub(landUser2Area.getRegionCode(), userId.toString(), bizId, roleId);*/
            }

            List<UserBiz2> ub2List = userBiz2Repository.findByUserIdAndBizIdAndRole(userId, bizId, roleId);
            if (ub2List == null || (ub2List != null && ub2List.size() == 0)) {
                UserBiz2 ub = new UserBiz2();
                ub.setUserId(userId);
                ub.setBizId(bizId);
                ub.setRole(roleId);
                userBiz2Repository.save(ub);
            }
        }
    }

    /**
     * 更改用户任务角色
     *
     * @param userId
     * @param bizId
     * @param roleIds
     */
    @Transactional
    public void updateUserBizRole(Long userId, String bizId, String roleIds) {
        //清除全部角色
        userBiz2Repository.deleteByBizIdAndUserIdAndByRole(userId, bizId, Arrays.asList(1, 2, 3, 4,5,6));
        //新版本消息通知
        //先删除管理员任务订阅记录 管理员配置一定会插入subscribe 无需判断 直接删除
        List<NoticeSubscribe> glySubscribes = noticeSubscribeRepository.findSubscribeIdsByUserIdAndBizIdAndRole1(userId.toString(), bizId, 1);
        noticeSubscribeRepository.deleteAll(glySubscribes);

        //配置任务作业员时不会向subscribe插入记录 需判断 否则会丢失角色权限
        if (Arrays.asList(roleIds.split(",")).indexOf("3") < 0) {
            //如果没有传作业员角色则删除
            List<NoticeSubscribe> zyySubscribes = noticeSubscribeRepository.findSubscribeIdsByUserIdAndBizIdAndRole1(userId.toString(), bizId, 3);
            noticeSubscribeRepository.deleteAll(zyySubscribes);
            //同时删除用户作业区
            tskRightAreaRepository.deleteByTaskIdAndUserId(bizId, userId.toString());
        }
        if (Arrays.asList(roleIds.split(",")).indexOf("2") < 0) {
            //如果没有传审核员角色则删除对应区域
            tbtskUserAuditAreaService.deleteByTaskIdAndUserId(bizId, String.valueOf(userId));
        }
        if (Arrays.asList(roleIds.split(",")).indexOf("4") < 0) {
            //如果没有传复核员角色则删除对应区域
            tbtskUserReviewAreaService.deleteByTaskIdAndUserId(bizId, String.valueOf(userId));
        }
        if (Arrays.asList(roleIds.split(",")).indexOf("1") < 0) {
            //如果没有传管理员角色则删除对应区域
            tbtskUserManageAreaService.deleteByTaskIdAndUserId(bizId, String.valueOf(userId));
        }
        if (Arrays.asList(roleIds.split(",")).indexOf("6") < 0) {
            //如果没有传上传角色则删除对应区域
            tbtskUserUploadAreaService.deleteByTaskIdAndUserId(bizId, String.valueOf(userId));
        }
        if (Arrays.asList(roleIds.split(",")).indexOf("5") < 0) {
            //如果没有传超级审核员角色则删除对应区域
            tbtskSuperUserAuditAreaService.deleteByTaskIdAndUserId(bizId, String.valueOf(userId));
        }

        for (String s : roleIds.split(",")) {
            if (StringUtils.isBlank(s)) {
                continue;
            }
            Integer roleId = Integer.valueOf(s);
            //新版本消息通知
            //如果配置管理员则根据被配置的人员的政区进行绑定
            LandUser2Area landUser2Area = userAreaDao.queryOneByUserId(userId);
            if (landUser2Area != null && roleId == 1) {
                /*userManageService.saveNoticeTopicAndNoticeSub(landUser2Area.getRegionCode(), userId.toString(), bizId, roleId);*/
            }
            List<UserBiz2> ub2List = userBiz2Repository.findByUserIdAndBizIdAndRole(userId, bizId, roleId);
            if (ub2List == null || (ub2List != null && ub2List.size() == 0)) {
                UserBiz2 ub = new UserBiz2();
                ub.setUserId(userId);
                ub.setBizId(bizId);
                ub.setRole(roleId);
                userBiz2Repository.save(ub);
            }
            //作业员挂接的政区与任务粒度一致时，应将挂接的政区设为作业区
            if (roleId == 3) {
                int userLevel = 0;
                //获取用户的行政区
                List<String> userRegions = userAreaDao.queryAreas(userId);
                if (!GutilCollection.isEmpty(userRegions)) {
                    String regionCode = userRegions.get(0);
                    if ("1".equalsIgnoreCase(regionCode)) {
                        userLevel = 1;
                    } else if (regionCode.endsWith("0000")) {
                        userLevel = 2;
                    } else if (regionCode.endsWith("00")) {
                        userLevel = 3;
                    } else {
                        userLevel = 4;
                    }
                    TskTaskBiz tskTaskBiz = tskTaskBizRepository.findById(bizId).orElse(null);
                    if (tskTaskBiz.getGranularity() == (userLevel - 1)) {
                        //  changeRightArea(bizId, String.valueOf(userId), regionCode);
                        List<String> areas = new ArrayList<>();
                        areas.add(regionCode);
                        saveRightAreasNew(areas, bizId, String.valueOf(userId));
                    }
                }
            }
        }
    }


    public List<TskAssignRecord> findByTaskIdAndDataIds(String taskId, List<String> dataIds) {
        return tskAssignRecordRepository.findByTaskIdAndDataIds(taskId, dataIds);
    }

    @Transactional(rollbackFor = Exception.class)
    public boolean saveTskKeyData(TskTaskBiz tskTaskBiz, JSONArray keyData, String remark) {

        TbtskObjectinfo table = tbtskObjectinfoRepository.findById(tskTaskBiz.getTableId()).orElse(null);
        tskTaskBiz.setRemark(remark);
        tskTaskBizRepository.save(tskTaskBiz);

        List<TbtskFields> fields = tbtskFieldsRepository.getTbtskFieldsByTableid(tskTaskBiz.getTableId());
        // have:true,check:false,only:true
        Map<String, JSONObject> keyMap = new HashMap<>();
        for (int i = 0; i < keyData.size(); i++) {
            JSONObject jsonObject = keyData.getJSONObject(i);

            String fieldId = jsonObject.getString("id");
            keyMap.put(fieldId, jsonObject);
        }
        List<TbtskFields> updateFields = new ArrayList<>(fields.size());
        for (TbtskFields field : fields) {
            String fid = field.getfId();
            if (keyMap.containsKey(fid)) {
                JSONObject data = keyMap.get(fid);

                Boolean have = data.getBoolean("have");
                Boolean check = data.getBoolean("check");
                Boolean only = data.getBoolean("only");
                field.setfNullable(check ? 0 : 1);
                field.setfUnique(only ? 1 : 0);
                field.setfIsMust(have ? 1 : 0);
                updateFields.add(field);
            }
        }
        tbtskFieldsRepository.saveAll(updateFields);
        return true;
    }

    @Transactional(rollbackFor = Exception.class)
    public boolean saveTaskKeyLimitData(TskTaskBiz tskTaskBiz, JSONArray keyData, String remark) {
        tskTaskBiz.setRemark(remark);
        tskTaskBizRepository.save(tskTaskBiz);
        for (int m = 0; m < keyData.size(); m++) {
            JSONObject jsonObject1 = keyData.getJSONObject(m);
            String tableId = jsonObject1.getString("tableId");
            JSONArray keyValue = jsonObject1.getJSONArray("value");
            List<TbtskFields> fields = tbtskFieldsRepository.getTbtskFieldsByTableid(tableId);
            // have:true,check:false,only:true
            Map<String, JSONObject> keyMap = new HashMap<>();
            for (int i = 0; i < keyValue.size(); i++) {
                JSONObject jsonObject = keyValue.getJSONObject(i);
                String fieldId = jsonObject.getString("id");
                keyMap.put(fieldId, jsonObject);
            }
            List<TbtskFields> updateFields = new ArrayList<>(fields.size());
            for (TbtskFields field : fields) {
                String fid = field.getfId();
                if (keyMap.containsKey(fid)) {
                    JSONObject data = keyMap.get(fid);

                    Boolean have = data.getBoolean("have");
                    Boolean check = data.getBoolean("check");
                    Boolean only = data.getBoolean("only");
                    field.setfNullable(check ? 0 : 1);
                    field.setfUnique(only ? 1 : 0);
                    field.setfIsMust(have ? 1 : 0);
                    updateFields.add(field);
                }
            }
            tbtskFieldsRepository.saveAll(updateFields);
        }
        return true;
    }

    @Transactional(rollbackFor = Exception.class)
    public void createTable(TskTaskBiz tskTaskBiz, TbtskObjectinfo tableInfo) {

        GutilAssert.hasLength(tableInfo.getfTablename(), "表不能为空");
        // 创建数据库表sql
        StringBuilder creatTableSql = new StringBuilder("CREATE TABLE ");
        List<TbtskFields> fields = tbtskFieldsRepository.getTbtskFieldsByTableid(tableInfo.getfId());
        // 表名称

        creatTableSql.append(tableInfo.getfTablename()).append(" (");
        // 保存‘数据库表字段’信息
        creatTableSql.append(TskTaskBizDBUtil.generateFieldSql(tskTaskBiz, fields));
        // 生成索引信息
        creatTableSql.append(TskTaskBizDBUtil.generateTableIndex(tableInfo.getfTablename()));
        // 创建数据库表
        jdbcTemplate.execute(creatTableSql.toString());
        //调查任务的shape数据srid设置为4490
        if(tableInfo.getfTablename().contains(".")){
            String[] split = tableInfo.getfTablename().split("\\.");
            jdbcTemplate.execute("select UpdateGeometrySRID('','"+split[0]+"','"+split[1]+"', 'f_shape', 4490)");
        }else{
            jdbcTemplate.execute("select UpdateGeometrySRID('"+tableInfo.getfTablename()+"', 'f_shape', 4490)");
        }

        // 同步创建到eleasticsearch中
       /* try {
            elasticsearchService.createIndex(tableInfo.getfTablename(), fields);
        } catch (Exception e) {
            e.printStackTrace();
        }*/
    }

    @Transactional(rollbackFor = Exception.class)
    public boolean finishCreateTsk(TskTaskBiz tskTaskBiz, Long userId) {
        TbtskObjectinfo table = tbtskObjectinfoRepository.findById(tskTaskBiz.getTableId()).orElse(null);
        List<TbtskFields> fields = tbtskFieldsRepository.getTbtskFieldsByTableid(tskTaskBiz.getTableId());
        String beforeTableName =  StringUtils.isNotBlank(table.getfTablename())?table.getfTablename():table.getfId();
        // 任务表上 tableName 是否已经有值
        Boolean isHaveTableName = StringUtils.isNotBlank(table.getfTablename());
        boolean existTableName = false;
        Boolean hasData = false;
        boolean allowSplitSpot = false;
        if(StringUtils.isNotBlank(tskTaskBiz.getConfigArgs())) {
            JSONObject configArgsObject = JSONObject.parseObject(tskTaskBiz.getConfigArgs());
            if((configArgsObject.getInteger("allowWebSplitSpot") != null && configArgsObject.getInteger("allowWebSplitSpot")==1)|| (configArgsObject.getInteger("allowAppSplitSpot") != null && configArgsObject.getInteger("allowAppSplitSpot")==1)) {
                allowSplitSpot = true;
            }
        }
        if (!isHaveTableName) {// 表名为空
            String tableName = TskTaskBizDBUtil.generateTableName(tskTaskBiz.getType());
            if(tskTaskBiz.getClassId() != null ){
                String sql1 = " select count(1)  from tbtsk_task_class inner join bus_apps_schema on " +
                        "(tbtsk_task_class.f_appkey  = bus_apps_schema.f_apps_id  ) and tbtsk_task_class.f_id  = '"+tskTaskBiz.getClassId()+"'";
                String sql = " select bus_apps_schema.f_schema  from tbtsk_task_class inner join bus_apps_schema on " +
                        "(tbtsk_task_class.f_appkey  = bus_apps_schema.f_apps_id  ) and tbtsk_task_class.f_id  = '"+tskTaskBiz.getClassId()+"'";
                Integer fId = jdbcTemplate.queryForObject(sql1, Integer.class);
                if(fId > 0){
                    String f_schema = jdbcTemplate.queryForObject(sql, String.class);
                    tableName  = f_schema +"." + tableName;
                }
            }
            table.setfTablename(tableName);
            existTableName = false;
            if(allowSplitSpot){
                table.setSplitTableName(tableName+"_child");
            }
        } else {
            existTableName = mDataBizService.isExistTableName(table.getfTablename());
            // 表存在且数据大于0 不允许创建
            if (existTableName && mDataBizService.getCount(table.getfTablename(), " 1=1 ") > 0) {
                hasData = true;
            }
            // 表存在 且 表中无数据 则重新创建一次表
            if (existTableName && !hasData) {
                // 删除表
                String sql = "DROP TABLE IF EXISTS " + table.getfTablename() + ";";
                jdbcTemplate.execute(sql);
                //删除字图斑表
                if(allowSplitSpot && mDataBizService.isExistTableName(table.getfTablename()+"_child")){
                    // 删除表
                    String sql1 = "DROP TABLE IF EXISTS " + table.getfTablename()+"_child" + ";";
                    jdbcTemplate.execute(sql1);
                }

                String tableName = TskTaskBizDBUtil.generateTableName(tskTaskBiz.getType());
                if(tskTaskBiz.getClassId() != null ){
                    String countsql = " select count(1)  from tbtsk_task_class inner join bus_apps_schema" +
                            " on (tbtsk_task_class.f_appkey  = bus_apps_schema.f_apps_id  ) and tbtsk_task_class.f_id = '"+tskTaskBiz.getClassId()+"'";
                    Integer count = jdbcTemplate.queryForObject(countsql, Integer.class);
                    if(count > 0){
                        String sql1 = " select bus_apps_schema.f_schema  from tbtsk_task_class inner join bus_apps_schema" +
                                " on (tbtsk_task_class.f_appkey  = bus_apps_schema.f_apps_id  ) and tbtsk_task_class.f_id = '"+tskTaskBiz.getClassId()+"'";
                        String f_schema = jdbcTemplate.queryForObject(sql1, String.class);
                        tableName  = f_schema +"." + tableName;
                    }
                }
                table.setfTablename(tableName);
                if(allowSplitSpot){
                    table.setSplitTableName(tableName+"_child");
                }
                hasData = false;

            }
        }
        // 三个条件是有顺序的不能调换位置
        // 1 表名为空创建，2 表名不为空且表实际不存在创建 3 表存在 但 不存在数据
        if (!isHaveTableName || !existTableName || !hasData) {
            TskTaskBizService bean = SpringContextHolder2.getBean(TskTaskBizService.class);
            bean.createTable(tskTaskBiz, table);
            //创建子图斑
            if(allowSplitSpot){
                String spotsql = "create table "+table.getfTablename()+"_child  as select * from "+table.getfTablename()+" where 1 =2";
                jdbcTemplate.execute(spotsql);
            }
        }
        // 完成
        tskTaskBiz.setFinish(1);
        fields.stream().forEach(f -> {
            f.setfTablename(table.getfTablename());
        });
        List<TbtskGroup> tbtskGroups = new ArrayList<>();

        fields.stream().forEach(r -> {
            List<TbtskGroup> groups = tbtskGroupRepository.findByFFieldid(r.getfId());
            for (TbtskGroup g : groups) {
                g.setfTablename(table.getfTablename());
                tbtskGroups.add(g);
            }
        });

        // 这里主要为了获取 f_spot 字段和  f_speack 字段
        TbtskTemplate template = tbtskTemplateRepository.findById(tskTaskBiz.getTemplateId()).orElse(null);
        List<TbtskGroup> groupList = tbtskGroupRepository.getFiledIdIsNull(template.getTableId());

        //List<TbtskGroup> groupList = tbtskGroupRepository.findByFTablename(tskTaskBiz.getTableId());
           /* if(groupList.size() < 1){
                groupList = tbtskGroupRepository.findByFTablename(temTableName);
            }*/
        for (TbtskGroup g : groupList) {
            TbtskGroup tg = new TbtskGroup();
            BeanUtil.copyProperties(g, tg, "fId");
            tg.setfTablename(table.getfTablename());
            tbtskGroups.add(tg);
        }

        //获取系统字段配置
        List<TbtskGroup> sysFieldGroups = tbtskGroupRepository.selectByTableNameAndGroupcode("web", beforeTableName, "104");
        for (TbtskGroup g1 : sysFieldGroups) {
            g1.setfTablename(org.apache.commons.lang3.StringUtils.isNotBlank(table.getfTablename())?table.getfTablename():table.getfId());
            tbtskGroups.add(g1);
        }
        // 字段内存储表名
        tbtskFieldsRepository.saveAll(fields);
        tbtskGroupRepository.saveAll(tbtskGroups);
        // 生成dburl
        String dbUrl = createDB(tskTaskBiz.getId(), userId.toString(), "sendApp");
        tskTaskBiz.setStructDbUrl(dbUrl);
        // 保存完成状态
        tskTaskBizRepository.save(tskTaskBiz);
        mTskTaskSyncService.pushCreateTaskSync(tskTaskBiz,userId);
        return true;
    }

    @Transactional(rollbackFor = Exception.class)
    public boolean finishCreatePMTsk(TskTaskBiz tskTaskBiz, Long userId) {
        List<TbtskObjectinfo> objectbyTaskId = tbtskObjectinfoRepository.getObjectbyTaskId(tskTaskBiz.getId());
           if(objectbyTaskId.size() > 0 ){
              for(TbtskObjectinfo table : objectbyTaskId){
                  List<TbtskFields> fields = tbtskFieldsRepository.getTbtskFieldsByTableid(table.getfId());
                  String beforeTableName =  StringUtils.isNotBlank(table.getfTablename())?table.getfTablename():table.getfId();
                  // 任务表上 tableName 是否已经有值
                  Boolean isHaveTableName = StringUtils.isNotBlank(table.getfTablename());
                  boolean existTableName = false;
                  Boolean hasData = false;
                  boolean allowSplitSpot = false;
                  if(StringUtils.isNotBlank(tskTaskBiz.getConfigArgs())) {
                      JSONObject configArgsObject = JSONObject.parseObject(tskTaskBiz.getConfigArgs());
                      if((configArgsObject.getInteger("allowWebSplitSpot") != null && configArgsObject.getInteger("allowWebSplitSpot")==1)|| (configArgsObject.getInteger("allowAppSplitSpot") != null && configArgsObject.getInteger("allowAppSplitSpot")==1)) {
                          allowSplitSpot = true;
                      }
                  }
                  if (!isHaveTableName) {// 表名为空
                      String tableName = TskTaskBizDBUtil.generateTableName(tskTaskBiz.getType());
                      if(tskTaskBiz.getClassId() != null ){
                          String sql1 = " select count(1)  from tbtsk_task_class inner join bus_apps_schema on " +
                                  "(tbtsk_task_class.f_appkey  = bus_apps_schema.f_apps_id  ) and tbtsk_task_class.f_id  = '"+tskTaskBiz.getClassId()+"'";
                          String sql = " select bus_apps_schema.f_schema  from tbtsk_task_class inner join bus_apps_schema on " +
                                  "(tbtsk_task_class.f_appkey  = bus_apps_schema.f_apps_id  ) and tbtsk_task_class.f_id  = '"+tskTaskBiz.getClassId()+"'";
                          Integer fId = jdbcTemplate.queryForObject(sql1, Integer.class);
                          if(fId > 0){
                              String f_schema = jdbcTemplate.queryForObject(sql, String.class);
                              tableName  = f_schema +"." + tableName;
                          }
                      }
                      table.setfTablename(tableName);
                      existTableName = false;
                      if(allowSplitSpot){
                          table.setSplitTableName(tableName+"_child");
                      }
                  } else {
                      existTableName = mDataBizService.isExistTableName(table.getfTablename());
                      // 表存在且数据大于0 不允许创建
                      if (existTableName && mDataBizService.getCount(table.getfTablename(), " 1=1 ") > 0) {
                          hasData = true;
                      }
                      // 表存在 且 表中无数据 则重新创建一次表
                      if (existTableName && !hasData) {
                          // 删除表
                          String sql = "DROP TABLE IF EXISTS " + table.getfTablename() + ";";
                          jdbcTemplate.execute(sql);
                          //删除字图斑表
                          if(allowSplitSpot && mDataBizService.isExistTableName(table.getfTablename()+"_child")){
                              // 删除表
                              String sql1 = "DROP TABLE IF EXISTS " + table.getfTablename()+"_child" + ";";
                              jdbcTemplate.execute(sql1);
                          }

                          String tableName = TskTaskBizDBUtil.generateTableName(tskTaskBiz.getType());
                          if(tskTaskBiz.getClassId() != null ){
                              String countsql = " select count(1)  from tbtsk_task_class inner join bus_apps_schema" +
                                      " on (tbtsk_task_class.f_appkey  = bus_apps_schema.f_apps_id  ) and tbtsk_task_class.f_id = '"+tskTaskBiz.getClassId()+"'";
                              Integer count = jdbcTemplate.queryForObject(countsql, Integer.class);
                              if(count > 0){
                                  String sql1 = " select bus_apps_schema.f_schema  from tbtsk_task_class inner join bus_apps_schema" +
                                          " on (tbtsk_task_class.f_appkey  = bus_apps_schema.f_apps_id  ) and tbtsk_task_class.f_id = '"+tskTaskBiz.getClassId()+"'";
                                  String f_schema = jdbcTemplate.queryForObject(sql1, String.class);
                                  tableName  = f_schema +"." + tableName;
                              }
                          }
                          table.setfTablename(tableName);
                          if(allowSplitSpot){
                              table.setSplitTableName(tableName+"_child");
                          }
                          hasData = false;

                      }
                  }
                  // 三个条件是有顺序的不能调换位置
                  // 1 表名为空创建，2 表名不为空且表实际不存在创建 3 表存在 但 不存在数据
                  if (!isHaveTableName || !existTableName || !hasData) {
                      createTable(tskTaskBiz, table);
                      /*TskTaskBizService bean = SpringContextHolder2.getBean(TskTaskBizService.class);
                      bean.createTable(tskTaskBiz, table);*/
                      //创建子图斑
                      if(allowSplitSpot){
                          String spotsql = "create table "+table.getfTablename()+"_child  as select * from "+table.getfTablename()+" where 1 =2";
                          jdbcTemplate.execute(spotsql);
                      }
                  }
                  fields.stream().forEach(f -> {
                      f.setfTablename(table.getfTablename());
                  });
                  List<TbtskGroup> tbtskGroups = new ArrayList<>();

                  fields.stream().forEach(r -> {
                      List<TbtskGroup> groups = tbtskGroupRepository.findByFFieldid(r.getfId());
                      for (TbtskGroup g : groups) {
                          g.setfTablename(table.getfTablename());
                          tbtskGroups.add(g);
                      }
                  });
                  // 这里主要为了获取 f_spot 字段和  f_speack 字段
                  TbtskTemplate template = tbtskTemplateRepository.findById(table.getTemplateId()).orElse(null);
                  List<TbtskGroup> groupList = tbtskGroupRepository.getFiledIdIsNull(template.getTableId());

                  for (TbtskGroup g : groupList) {
                      TbtskGroup tg = new TbtskGroup();
                      BeanUtil.copyProperties(g, tg, "fId");
                      tg.setfTablename(table.getfTablename());
                      tbtskGroups.add(tg);
                  }

                  //获取系统字段配置
                  List<TbtskGroup> sysFieldGroups = tbtskGroupRepository.selectByTableNameAndGroupcode("web", beforeTableName, "104");
                  for (TbtskGroup g1 : sysFieldGroups) {
                      g1.setfTablename(org.apache.commons.lang3.StringUtils.isNotBlank(table.getfTablename())?table.getfTablename():table.getfId());
                      tbtskGroups.add(g1);
                  }
                  // 字段内存储表名
                  tbtskFieldsRepository.saveAll(fields);
                  tbtskGroupRepository.saveAll(tbtskGroups);
              }
               // 完成
               tskTaskBiz.setFinish(1);
               // 生成dburl
               String dbUrl = createDB(tskTaskBiz.getId(), userId.toString(), "sendApp");
               tskTaskBiz.setStructDbUrl(dbUrl);
               // 保存完成状态
               tskTaskBizRepository.save(tskTaskBiz);
               //内网同步到外网
               mTskTaskSyncService.pushCreateTaskSync(tskTaskBiz,userId);
               return true;
           }else{
               TbtskObjectinfo table = tbtskObjectinfoRepository.findById(tskTaskBiz.getTableId()).orElse(null);
               List<TbtskFields> fields = tbtskFieldsRepository.getTbtskFieldsByTableid(tskTaskBiz.getTableId());
               String beforeTableName =  StringUtils.isNotBlank(table.getfTablename())?table.getfTablename():table.getfId();
               // 任务表上 tableName 是否已经有值
               Boolean isHaveTableName = StringUtils.isNotBlank(table.getfTablename());
               boolean existTableName = false;
               Boolean hasData = false;
               boolean allowSplitSpot = false;
               if(StringUtils.isNotBlank(tskTaskBiz.getConfigArgs())) {
                   JSONObject configArgsObject = JSONObject.parseObject(tskTaskBiz.getConfigArgs());
                   if((configArgsObject.getInteger("allowWebSplitSpot") != null && configArgsObject.getInteger("allowWebSplitSpot")==1)|| (configArgsObject.getInteger("allowAppSplitSpot") != null && configArgsObject.getInteger("allowAppSplitSpot")==1)) {
                       allowSplitSpot = true;
                   }
               }
               if (!isHaveTableName) {// 表名为空
                   String tableName = TskTaskBizDBUtil.generateTableName(tskTaskBiz.getType());
                   if(tskTaskBiz.getClassId() != null ){
                       String sql1 = " select count(1)  from tbtsk_task_class inner join bus_apps_schema on " +
                               "(tbtsk_task_class.f_appkey  = bus_apps_schema.f_apps_id  ) and tbtsk_task_class.f_id  = '"+tskTaskBiz.getClassId()+"'";
                       String sql = " select bus_apps_schema.f_schema  from tbtsk_task_class inner join bus_apps_schema on " +
                               "(tbtsk_task_class.f_appkey  = bus_apps_schema.f_apps_id  ) and tbtsk_task_class.f_id  = '"+tskTaskBiz.getClassId()+"'";
                       Integer fId = jdbcTemplate.queryForObject(sql1, Integer.class);
                       if(fId > 0){
                           String f_schema = jdbcTemplate.queryForObject(sql, String.class);
                           tableName  = f_schema +"." + tableName;
                       }
                   }
                   table.setfTablename(tableName);
                   existTableName = false;
                   if(allowSplitSpot){
                       table.setSplitTableName(tableName+"_child");
                   }
               } else {
                   existTableName = mDataBizService.isExistTableName(table.getfTablename());
                   // 表存在且数据大于0 不允许创建
                   if (existTableName && mDataBizService.getCount(table.getfTablename(), " 1=1 ") > 0) {
                       hasData = true;
                   }
                   // 表存在 且 表中无数据 则重新创建一次表
                   if (existTableName && !hasData) {
                       // 删除表
                       String sql = "DROP TABLE IF EXISTS " + table.getfTablename() + ";";
                       jdbcTemplate.execute(sql);
                       //删除字图斑表
                       if(allowSplitSpot && mDataBizService.isExistTableName(table.getfTablename()+"_child")){
                           // 删除表
                           String sql1 = "DROP TABLE IF EXISTS " + table.getfTablename()+"_child" + ";";
                           jdbcTemplate.execute(sql1);
                       }

                       String tableName = TskTaskBizDBUtil.generateTableName(tskTaskBiz.getType());
                       if(tskTaskBiz.getClassId() != null ){
                           String countsql = " select count(1)  from tbtsk_task_class inner join bus_apps_schema" +
                                   " on (tbtsk_task_class.f_appkey  = bus_apps_schema.f_apps_id  ) and tbtsk_task_class.f_id = '"+tskTaskBiz.getClassId()+"'";
                           Integer count = jdbcTemplate.queryForObject(countsql, Integer.class);
                           if(count > 0){
                               String sql1 = " select bus_apps_schema.f_schema  from tbtsk_task_class inner join bus_apps_schema" +
                                       " on (tbtsk_task_class.f_appkey  = bus_apps_schema.f_apps_id  ) and tbtsk_task_class.f_id = '"+tskTaskBiz.getClassId()+"'";
                               String f_schema = jdbcTemplate.queryForObject(sql1, String.class);
                               tableName  = f_schema +"." + tableName;
                           }
                       }
                       table.setfTablename(tableName);
                       if(allowSplitSpot){
                           table.setSplitTableName(tableName+"_child");
                       }
                       hasData = false;

                   }
               }
               // 三个条件是有顺序的不能调换位置
               // 1 表名为空创建，2 表名不为空且表实际不存在创建 3 表存在 但 不存在数据
               if (!isHaveTableName || !existTableName || !hasData) {
                   TskTaskBizService bean = SpringContextHolder2.getBean(TskTaskBizService.class);
                   bean.createTable(tskTaskBiz, table);
                   //创建子图斑
                   if(allowSplitSpot){
                       String spotsql = "create table "+table.getfTablename()+"_child  as select * from "+table.getfTablename()+" where 1 =2";
                       jdbcTemplate.execute(spotsql);
                   }
               }
               // 完成
               tskTaskBiz.setFinish(1);
               fields.stream().forEach(f -> {
                   f.setfTablename(table.getfTablename());
               });
               List<TbtskGroup> tbtskGroups = new ArrayList<>();

               fields.stream().forEach(r -> {
                   List<TbtskGroup> groups = tbtskGroupRepository.findByFFieldid(r.getfId());
                   for (TbtskGroup g : groups) {
                       g.setfTablename(table.getfTablename());
                       tbtskGroups.add(g);
                   }
               });

               // 这里主要为了获取 f_spot 字段和  f_speack 字段
               TbtskTemplate template = tbtskTemplateRepository.findById(tskTaskBiz.getTemplateId()).orElse(null);
               List<TbtskGroup> groupList = tbtskGroupRepository.getFiledIdIsNull(template.getTableId());

               //List<TbtskGroup> groupList = tbtskGroupRepository.findByFTablename(tskTaskBiz.getTableId());
           /* if(groupList.size() < 1){
                groupList = tbtskGroupRepository.findByFTablename(temTableName);
            }*/
               for (TbtskGroup g : groupList) {
                   TbtskGroup tg = new TbtskGroup();
                   BeanUtil.copyProperties(g, tg, "fId");
                   tg.setfTablename(table.getfTablename());
                   tbtskGroups.add(tg);
               }

               //获取系统字段配置
               List<TbtskGroup> sysFieldGroups = tbtskGroupRepository.selectByTableNameAndGroupcode("web", beforeTableName, "104");
               for (TbtskGroup g1 : sysFieldGroups) {
                   g1.setfTablename(org.apache.commons.lang3.StringUtils.isNotBlank(table.getfTablename())?table.getfTablename():table.getfId());
                   tbtskGroups.add(g1);
               }
               // 字段内存储表名
               tbtskFieldsRepository.saveAll(fields);
               tbtskGroupRepository.saveAll(tbtskGroups);
               // 生成dburl
               String dbUrl = createDB(tskTaskBiz.getId(), userId.toString(), "sendApp");
               tskTaskBiz.setStructDbUrl(dbUrl);
               // 保存完成状态
               tskTaskBizRepository.save(tskTaskBiz);
               //内网同步到外网
               mTskTaskSyncService.pushCreateTaskSync(tskTaskBiz,userId);
               return true;
           }
    }



    @Transactional(rollbackFor = Exception.class)
    public boolean finishCreateXCTsk(TskTaskBiz tskTaskBiz, Long userId) {
        TbtskObjectinfo table = tbtskObjectinfoRepository.findById(tskTaskBiz.getTableId()).orElse(null);
        List<TbtskObjectinfo> objectbyTaskId = tbtskObjectinfoRepository.getObjectbyTaskId(tskTaskBiz.getId());
        TbtskObjectinfo table2 = null;
        TbtskObjectinfo table3 = null;
        if(objectbyTaskId.size() > 0){
            for(TbtskObjectinfo tbtskObjectinfo : objectbyTaskId){
                if(org.apache.commons.lang3.StringUtils.isNotBlank(tbtskObjectinfo.getfRemark())  && "工作情况".equals(tbtskObjectinfo .getfRemark()) ){
                    table2 = tbtskObjectinfo;
                }else if(org.apache.commons.lang3.StringUtils.isNotBlank(tbtskObjectinfo.getfRemark())  && "问题数据".equals(tbtskObjectinfo .getfRemark()) ){
                    table3 = tbtskObjectinfo;
                }
            }
        }
        List<TbtskFields> fields = tbtskFieldsRepository.getTbtskFieldsByTableid(tskTaskBiz.getTableId());
        List<TbtskFields> fields2 = new ArrayList<>();
        List<TbtskFields> fields3 = new ArrayList<>();
        //判断模板是否存在问题类型和工作情况字段
        boolean isExist2 = false;boolean isExist3 = false;
        for(TbtskFields fields1 : fields){
            if(org.apache.commons.lang3.StringUtils.isNotBlank(fields1.getfFieldAttribution()) && "2".equals(fields1.getfFieldAttribution())){
                isExist2= true;
                fields2.add(fields1);
            }else if(org.apache.commons.lang3.StringUtils.isNotBlank(fields1.getfFieldAttribution()) && "3".equals(fields1.getfFieldAttribution())){
                isExist3= true;
                fields3.add(fields1);
            }
        }
        // 任务表上 tableName 是否已经有值
        Boolean isHaveTableName = StringUtils.isNotBlank(table.getfTablename());
        boolean existTableName = false;
        Boolean hasData = false;
        if (!isHaveTableName) {// 表名为空
            String tableName = TskTaskBizDBUtil.generateTableName(tskTaskBiz.getType());
            if(tskTaskBiz.getClassId() != null ){
                String sql1 = " select count(1)  from tbtsk_task_class inner join bus_apps_schema on " +
                        "(tbtsk_task_class.f_appkey  = bus_apps_schema.f_apps_id  ) and tbtsk_task_class.f_id  = '"+tskTaskBiz.getClassId()+"'";
                String sql = " select bus_apps_schema.f_schema  from tbtsk_task_class inner join bus_apps_schema on " +
                        "(tbtsk_task_class.f_appkey  = bus_apps_schema.f_apps_id  ) and tbtsk_task_class.f_id  = '"+tskTaskBiz.getClassId()+"'";
                Integer fId = jdbcTemplate.queryForObject(sql1, Integer.class);
                if(fId > 0){
                    String f_schema = jdbcTemplate.queryForObject(sql, String.class);
                    tableName  = f_schema +"." + tableName;
                }
            }
            table.setfTablename(tableName);
            existTableName = false;
        } else {
            existTableName = mDataBizService.isExistTableName(table.getfTablename());
            // 表存在且数据大于0 不允许创建
            if (existTableName && mDataBizService.getCount(table.getfTablename(), " 1=1 ") > 0) {
                hasData = true;
            }
            // 表存在 且 表中无数据 则重新创建一次表
            if (existTableName && !hasData) {
                // 删除表
                String sql = "DROP TABLE IF EXISTS " + table.getfTablename() + ";";
                jdbcTemplate.execute(sql);
                //删除字图斑表
                if( mDataBizService.isExistTableName(table.getfTablename()+"_gzqk")){
                    // 删除表
                    String sql1 = "DROP TABLE IF EXISTS " + table.getfTablename()+"_gzqk" + ";";
                    jdbcTemplate.execute(sql1);
                }
                if( mDataBizService.isExistTableName(table.getfTablename()+"_wtsj")){
                    // 删除表
                    String sql1 = "DROP TABLE IF EXISTS " + table.getfTablename()+"_wtsj" + ";";
                    jdbcTemplate.execute(sql1);
                }
                String tableName = TskTaskBizDBUtil.generateTableName(tskTaskBiz.getType());
                if(tskTaskBiz.getClassId() != null ){
                    String countsql = " select count(1)  from tbtsk_task_class inner join bus_apps_schema" +
                            " on (tbtsk_task_class.f_appkey  = bus_apps_schema.f_apps_id  ) and tbtsk_task_class.f_id = '"+tskTaskBiz.getClassId()+"'";
                    Integer count = jdbcTemplate.queryForObject(countsql, Integer.class);
                    if(count > 0){
                        String sql1 = " select bus_apps_schema.f_schema  from tbtsk_task_class inner join bus_apps_schema" +
                                " on (tbtsk_task_class.f_appkey  = bus_apps_schema.f_apps_id  ) and tbtsk_task_class.f_id = '"+tskTaskBiz.getClassId()+"'";
                        String f_schema = jdbcTemplate.queryForObject(sql1, String.class);
                        tableName  = f_schema +"." + tableName;
                    }
                }
                table.setfTablename(tableName);
                hasData = false;

            }
        }
            if( table2 == null){
                TbtskObjectinfo tablegzqk = new TbtskObjectinfo();
                BeanUtils.copyProperties(table,tablegzqk,"fId");
                tablegzqk.setfTablename(table.getfTablename()+"_gzqk");
                tablegzqk.setTaskId(tskTaskBiz.getId());
                tablegzqk.setfRemark("工作情况");
                tablegzqk.setParentObjId("-1");
                tbtskObjectinfoRepository.save(tablegzqk);
                objectbyTaskId.add(tablegzqk);
            }else{
                table2.setfTablename(table.getfTablename()+"_gzqk");
                tbtskObjectinfoRepository.save(table2);
            }
            if( table3 == null){
                TbtskObjectinfo tablewtsj = new TbtskObjectinfo();
                BeanUtils.copyProperties(table,tablewtsj,"fId");
                tablewtsj.setfTablename(table.getfTablename()+"_wtsj");
                tablewtsj.setfRemark("问题数据");
                tablewtsj.setTaskId(tskTaskBiz.getId());
                tablewtsj.setParentObjId(tskTaskBiz.getTableId());
                tablewtsj.setRelfield("{\"parentFieldName\":\"f_xmid\",\"fieldName\":\"f_xmid\"}");
                tbtskObjectinfoRepository.save(tablewtsj);
                objectbyTaskId.add(tablewtsj);
            }else{
                table3.setfTablename(table.getfTablename()+"_wtsj");
                tbtskObjectinfoRepository.save(table3);
            }

        List<TbtskGroup> tbtskGroups = new ArrayList<>();
        // 三个条件是有顺序的不能调换位置
        // 1 表名为空创建，2 表名不为空且表实际不存在创建 3 表存在 但 不存在数据
        if (!isHaveTableName || !existTableName || !hasData) {
            //创建子图斑
                for(TbtskObjectinfo objectinfo : objectbyTaskId ){
                   /* if(isExist2){*/
                    if(true){
                        if("工作情况".equals(objectinfo.getfRemark()) && !objectinfo.getfId().equals(table.getfId())){
                            //处理字段数据
                            int i = 1;
                            for(TbtskFields fields1 : fields2){
                                fields1.setfTablename(objectinfo.getfTablename());
                                fields1.setfTableid(objectinfo.getfId());
                                tbtskFieldsRepository.save(fields1);
                                //增加app配置
                                TbtskGroup group = new TbtskGroup();
                                group.setfSyscode("app");
                                group.setfGroupcode("202");
                                group.setfTablename(objectinfo.getfTablename());
                                group.setfFieldname(fields1.getfFieldname());
                                group.setfFieldid(fields1.getfId());
                                group.setfAlias(fields1.getfAlias());
                                group.setVisible(1);
                                group.setfCode(1);
                                group.setNotNull(fields1.getfNullable()!=null?fields1.getfNullable():1);
                                group.setfFieldorder(i);
                                tbtskGroups.add(group);
                                i++;
                            }
                            addDefaultFieldsToXCYW(objectinfo,"2");
                            createTable(tskTaskBiz, objectinfo);
                          }
                        }
                   /* if(isExist3){*/
                    if(true){
                        if("问题数据".equals(objectinfo.getfRemark()) && !objectinfo.getfId().equals(table.getfId())){
                            //处理字段数据
                            int i = 1;
                            for(TbtskFields fields1 : fields3){
                                fields1.setfTablename(objectinfo.getfTablename());
                                fields1.setfTableid(objectinfo.getfId());
                                tbtskFieldsRepository.save(fields1);
                                //增加app配置
                                TbtskGroup group = new TbtskGroup();
                                group.setfSyscode("app");
                                group.setfGroupcode("202");
                                group.setfTablename(objectinfo.getfTablename());
                                group.setfFieldname(fields1.getfFieldname());
                                group.setfFieldid(fields1.getfId());
                                group.setfAlias(fields1.getfAlias());
                                group.setfFieldorder(i);
                                group.setVisible(1);
                                group.setNotNull(fields1.getfNullable()!=null?fields1.getfNullable():1);
                                group.setfCode(1);
                                tbtskGroups.add(group);
                                i++;
                            }
                            addDefaultFieldsToXCYW(objectinfo,"3");
                            createTable(tskTaskBiz, objectinfo);
                        }
                    }
                }
             //最后创建主图斑
            createTable(tskTaskBiz, table);
        }
        // 完成
        tskTaskBiz.setFinish(1);
        fields.stream().forEach(f -> {
            if(org.apache.commons.lang3.StringUtils.isBlank(f.getfFieldAttribution())){
                f.setfTablename(table.getfTablename());
            }
        });
       /* List<TbtskGroup> tbtskGroups = new ArrayList<>();*/
        fields.stream().forEach(r -> {
            if(org.apache.commons.lang3.StringUtils.isBlank(r.getfFieldAttribution())){
                List<TbtskGroup> groups = tbtskGroupRepository.findByFFieldid(r.getfId());
                for (TbtskGroup g : groups) {
                    g.setfTablename(table.getfTablename());
                    tbtskGroups.add(g);
                }
            }
        });
        // 这里主要为了获取 f_spot 字段和  f_speack 字段
        TbtskTemplate template = tbtskTemplateRepository.findById(tskTaskBiz.getTemplateId()).orElse(null);
        List<TbtskGroup> groupList = tbtskGroupRepository.getFiledIdIsNull(template.getTableId());

        //List<TbtskGroup> groupList = tbtskGroupRepository.findByFTablename(tskTaskBiz.getTableId());
           /* if(groupList.size() < 1){
                groupList = tbtskGroupRepository.findByFTablename(temTableName);
            }*/
        for (TbtskGroup g : groupList) {
            TbtskGroup tg = new TbtskGroup();
            BeanUtil.copyProperties(g, tg, "fId");
            tg.setfTablename(table.getfTablename());
            tbtskGroups.add(tg);
        }

        // 字段内存储表名
        tbtskFieldsRepository.saveAll(fields);
        tbtskGroupRepository.saveAll(tbtskGroups);
        // 生成dburl
        String dbUrl = createDB(tskTaskBiz.getId(), userId.toString(), "sendApp");
        tskTaskBiz.setStructDbUrl(dbUrl);
        // 保存完成状态
        tskTaskBizRepository.save(tskTaskBiz);
        return true;
    }

    void addDefaultFieldsToXCYW(TbtskObjectinfo table,String fFieldAttribution) {
        addField(table,fFieldAttribution, "f_id", "主键", "2", 100, null, 0, FieldGroupTypeConstant.SYSTEM_FIELD);
        addField(table,fFieldAttribution, "f_tbid", "图斑id", "2", 100, null, 0, FieldGroupTypeConstant.SYSTEM_FIELD);
        addField(table,fFieldAttribution, "f_patrolid", "巡查id(系统)", "2", 100, null, 1, FieldGroupTypeConstant.SYSTEM_FIELD);
        addField(table,fFieldAttribution, "f_xmid", "项目id(系统)", "2", 100, null, 1, FieldGroupTypeConstant.SYSTEM_FIELD);
        addField(table,fFieldAttribution, "f_xcrwid", "巡查任务id(系统)", "2", 100, null, 1, FieldGroupTypeConstant.SYSTEM_FIELD);
        addField(table, fFieldAttribution,"f_status", "状态(系统)", "8", null, null, 1, FieldGroupTypeConstant.SYSTEM_FIELD);
        addField(table, fFieldAttribution,"f_requestid", "云查询id(系统)", "2", 100, null, 1, FieldGroupTypeConstant.SYSTEM_FIELD);
        addField(table, fFieldAttribution,"f_xzqdmcity", "行政区代码市(系统)", "2", 20, null, 1, FieldGroupTypeConstant.SYSTEM_FIELD);
        addField(table, fFieldAttribution,"f_xzqdmcounty", "行政区代码县(系统)", "2", 20, null, 1, FieldGroupTypeConstant.SYSTEM_FIELD);
        addField(table, fFieldAttribution,"f_xzqdmtown", "行政区代码镇(系统)", "2", 20, null, 1, FieldGroupTypeConstant.SYSTEM_FIELD);
        addField(table,fFieldAttribution, "f_xzqdmsys", "行政区代码村(系统)", "2", 20, null, 1, FieldGroupTypeConstant.SYSTEM_FIELD);
        addField(table, fFieldAttribution,"f_reject_count", "打回次数(系统)", "8", null, null, 1, FieldGroupTypeConstant.SYSTEM_FIELD);
        addField(table,fFieldAttribution, "f_review_stage", "审核阶段(系统)", "8", null, null, 1, FieldGroupTypeConstant.SYSTEM_FIELD);
        addField(table,fFieldAttribution, "f_reject_status", "打回状态(系统)", "8", null, null, 1, FieldGroupTypeConstant.SYSTEM_FIELD);
        // 1 + 4 内业 + 系统
        addField(table, fFieldAttribution,"f_shape", "shape(系统)", "9", null, null, 0, FieldGroupTypeConstant.INNER_FIELD + FieldGroupTypeConstant.SYSTEM_FIELD);
        addField(table, fFieldAttribution,"f_xzqdm", "行政区代码(系统)", "2", 20, null, 1, FieldGroupTypeConstant.INNER_FIELD + FieldGroupTypeConstant.SYSTEM_FIELD);
        addField(table,fFieldAttribution, "f_xzqmc", "行政区名称(系统)", "2", 100, null, 1, FieldGroupTypeConstant.INNER_FIELD + FieldGroupTypeConstant.SYSTEM_FIELD);
        addField(table, fFieldAttribution,"f_lat", "中心点Y坐标(系统)", "3", 12, 6, 0, FieldGroupTypeConstant.INNER_FIELD + FieldGroupTypeConstant.SYSTEM_FIELD);
        addField(table, fFieldAttribution,"f_lon", "中心点X坐标(系统)", "3", 12, 6, 0, FieldGroupTypeConstant.INNER_FIELD + FieldGroupTypeConstant.SYSTEM_FIELD);
        addField(table,fFieldAttribution, "f_userid", "操作人(系统)", "2", 100, null, 1, FieldGroupTypeConstant.SYSTEM_FIELD + FieldGroupTypeConstant.INNER_FIELD);
        addField(table, fFieldAttribution,"f_createtime", "创建时间(系统)", "2", 100, null, 1, FieldGroupTypeConstant.SYSTEM_FIELD + FieldGroupTypeConstant.INNER_FIELD);
        addField(table, fFieldAttribution,"f_updatetime", "更新时间(系统)", "2", 100, null, 1, FieldGroupTypeConstant.SYSTEM_FIELD +  FieldGroupTypeConstant.INNER_FIELD);
        addField(table, fFieldAttribution,"f_committime", "提交时间(系统)", "2", 100, null, 1, FieldGroupTypeConstant.SYSTEM_FIELD + FieldGroupTypeConstant.OUTER_FIELD);
        addField(table, fFieldAttribution,"f_upload_userid", "执行人员(系统)", "2", 100, null, 1, FieldGroupTypeConstant.SYSTEM_FIELD + FieldGroupTypeConstant.OUTER_FIELD);
        addField(table, fFieldAttribution,"f_approvetime", "审核时间(系统)", "2", 100, null, 1, FieldGroupTypeConstant.SYSTEM_FIELD + FieldGroupTypeConstant.INNER_FIELD);
        addField(table, fFieldAttribution,"f_typical", "典型问题(系统)", "2", 100, null, 1, FieldGroupTypeConstant.SYSTEM_FIELD + FieldGroupTypeConstant.INNER_FIELD);
    }

    private void addField(TbtskObjectinfo tableInfo,String fFieldAttribution, String name, String alias, String
            fieldType, Integer length, Integer pricies, Integer nullAble, Integer code) {
        TbtskFields tbField = new TbtskFields();
        tbField.setfAlias(alias);
        tbField.setfFieldname(name);
        tbField.setfFieldtype(fieldType);
        tbField.setfLength(length);
        tbField.setfPrecision(pricies);
        tbField.setfNullable(nullAble);
        tbField.setfFieldInnerOuterSys(1);
        tbField.setfTableid(tableInfo.getfId());
        tbField.setfTablename(tableInfo.getfTablename());
        tbField.setfFieldInnerOuterSys(code);
        tbField.setfFieldAttribution(fFieldAttribution);
        tbtskFieldsRepository.save(tbField);
    }


    @Transactional
    public Boolean deleteTaskUrl(String id, String type) {
        TskTaskBiz task = this.findByTaskId(id);
        GutilAssert.notNull(task, "未找到相应的任务");
        String url = null;
        if ("dataDemo".equals(type)) {
            url = task.getDataUrl();
            task.setDataUrl("");
        } else if ("stepImg".equals(type)) {
            url = task.getWorkflowUrl();
            task.setWorkflowUrl("");
        } else if ("guideBook".equals(type)) {
            url = task.getUserUrl();
            task.setUserUrl("");
        } else {
            throw new RuntimeException("type参数错误");
        }
        this.save(task);
        // 缺少删除obs上数据的方法
        return true;
    }

    @Transactional
    public Boolean assignTskTypeUser(TskTaskBiz tskTaskBiz, String type, Set<String> users) {
        if ("gly".equals(type) && !"zyy".equals(type) && !"shy".equals(type)) {
            throw new NoSuchElementException("非法参数");
        }
        switch (type) {
            case "gly":
                userBiz2Repository.deleteByBizIdAndRole(tskTaskBiz.getId(), 1);
                for (String userIdStr : users) {
                    saveUserBiz(Long.parseLong(userIdStr), tskTaskBiz.getId(), 1);
                }
                break;
            case "zyy":
                userBiz2Repository.deleteByBizIdAndRole(tskTaskBiz.getId(), 3);
                for (String userIdStr : users) {
                    saveUserBiz(Long.parseLong(userIdStr), tskTaskBiz.getId(), 3);
                }
                break;
            case "shy":
                userBiz2Repository.deleteByBizIdAndRole(tskTaskBiz.getId(), 2);
                for (String userIdStr : users) {
                    saveUserBiz(Long.parseLong(userIdStr), tskTaskBiz.getId(), 2);
                }
                break;
            default:
                break;
        }
        return true;
    }

    public List<TbtskGroup> getGroupByTableNameAndSysCode(String tableName, String sysCode) {
        GutilAssert.hasLength(tableName, "参数错误");
        GutilAssert.hasLength(sysCode, "参数错误");

        return tbtskGroupRepository.findByFTablenameAndFSyscode(tableName, sysCode);
    }

    public String parseFilterParam(String filterParam, String taskId,String tableId, String tableAlias) {
        String where = "";
        if (!StringUtils.isEmpty(filterParam)) {
            JSONArray filterArray = JSONArray.parseArray(filterParam);
            //101代表筛选配置
            List<TbtskFieldGroupView> filterField = fieldsService.getTaskFieldsMateWeb(taskId, tableId,"101");
            for (int i = 0; i < filterArray.size(); i++) {
                JSONObject jsonObject = filterArray.getJSONObject(i);
                String field = jsonObject.getString("field");
                String ref = jsonObject.getString("ref");
                String val = jsonObject.getString("val");
                String filterStr = "";
                if (!"".equals(val)) {
                    Optional<TbtskFieldGroupView> optional = filterField.stream().filter(r -> r.getfId().equals(field)).findFirst();
                    if (optional.isPresent()) {
                        TbtskFieldGroupView one = optional.orElse(null);
                        switch (one.getfFieldtype()) {
//                            文本型的
                            case "1":
                            case "2": {
                                switch (ref) {
                                    case "LK": {
                                        /*  filterStr = tableAlias + "." + one.getfFieldname() + " LIKE '%" + jsonObject.getString("val") + "%' ";*/
                                        String[] tem = val.split(",");
                                        if (tem.length > 1) {
                                            filterStr += "( ";
                                            for (String s : tem) {
                                                filterStr += tableAlias + "." + one.getfFieldname() + " LIKE '%" +
                                                        s + "%'  or ";
                                            }
                                            filterStr = filterStr.substring(0, filterStr.length() - 3) + ") ";
                                        } else {
                                            filterStr = tableAlias + "." + one.getfFieldname() + " LIKE '%" + jsonObject.getString("val") + "%' ";
                                        }
                                        break;
                                    }
                                    case "EQ": {
                                        filterStr = tableAlias + "." + one.getfFieldname() + " = '" + jsonObject.getString("val") + "' ";
                                        break;
                                    }
                                    case "IN": {

                                        List<String> inValues = new ArrayList<>();
                                        for (String s : val.split(",")) {
                                            inValues.add("'" + s + "'");
                                        }
                                        filterStr = tableAlias + "." + one.getfFieldname() + " IN (" + StringUtils.join(inValues, ",") + ") ";
                                        break;
                                    }
                                    case "IN_OR":{
                                        String[] values = val.split(",");
                                        if(values.length>0){
                                            filterStr = " (";
                                        }
                                        for (int j = 0; j < values.length; j++) {
                                            String value = values[j];
                                            filterStr += " " + tableAlias + "." + one.getfFieldname() + " LIKE '%"+value+"%' OR";
                                        }
                                        if(filterStr.endsWith("OR")){
                                            filterStr = filterStr.substring(0,filterStr.length()-2);
                                        }
                                        filterStr += ") ";
                                        break;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            case "3":
                            case "4":
                                switch (ref) {
                                    case "GT": {
                                        filterStr = tableAlias + "." + one.getfFieldname() + " > '" + jsonObject.getString("val") + "' ";
                                        break;
                                    }
                                    case "EQ": {
                                        filterStr = tableAlias + "." + one.getfFieldname() + " = '" + jsonObject.getString("val") + "' ";
                                        break;
                                    }
                                    case "LT": {
                                        filterStr = tableAlias + "." + one.getfFieldname() + " < '" + jsonObject.getString("val") + "' ";
                                        break;
                                    }
                                    case "LE": {
                                        filterStr = tableAlias + "." + one.getfFieldname() + " <= '" + jsonObject .getString("val") + "' ";
                                        break;
                                    }
                                    case "GE": {
                                        filterStr = tableAlias + "." + one.getfFieldname() + " >= '" + jsonObject.getString("val") + "' ";
                                        break;
                                    }
                                    case "NE": {
                                        filterStr = tableAlias + "." + one.getfFieldname() + " != '" + jsonObject.getString("val") + "' ";
                                        break;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            case "5": {
                                switch (ref) {
                                    case "GT": {
                                        filterStr = tableAlias + "." + one.getfFieldname() + " > " + jsonObject.getString("val") + " ";
                                        break;
                                    }
                                    case "EQ": {
                                        filterStr = tableAlias + "." + one.getfFieldname() + " = " + jsonObject.getString("val") + " ";
                                        break;
                                    }
                                    case "LT": {
                                        filterStr = tableAlias + "." + one.getfFieldname() + " < " + jsonObject.getString("val") + " ";
                                        break;
                                    }
                                    case "LE": {
                                        filterStr = tableAlias + "." + one.getfFieldname() + " <= " + jsonObject .getString("val") + " ";
                                        break;
                                    }
                                    case "GE": {
                                        filterStr = tableAlias + "." + one.getfFieldname() + " >= " + jsonObject.getString("val") + " ";
                                        break;
                                    }
                                    case "NE": {
                                        filterStr = tableAlias + "." + one.getfFieldname() + " != " + jsonObject.getString("val") + " ";
                                        break;
                                    }
                                    default:
                                        break;
                                }
                                break;
                            }
                            default:
                                break;
                        }
                    }
                    if (!StringUtils.isEmpty(filterStr)) {
                        where += " AND " + filterStr;
                    }
                }
            }
        }
        return where;
    }

    public String parseSysFilterParam(String filterParam, String taskId, String tableAlias) {
        String where = "";
        if (!StringUtils.isEmpty(filterParam)) {
            JSONArray filterArray = JSONArray.parseArray(filterParam);
            //101代表筛选配置
            List<TbtskSysFields> tbtskSysFields = fieldsService.getAllSysFields();
            for (int i = 0; i < filterArray.size(); i++) {
                JSONObject jsonObject = filterArray.getJSONObject(i);
                String field = jsonObject.getString("field");
                String ref = jsonObject.getString("ref");
                String val = jsonObject.getString("val");
                String filterStr = "";
                if (!"".equals(val)) {
                    Optional<TbtskSysFields> optional = tbtskSysFields.stream().filter(r -> r.getfId().equals(field)).findFirst();
                    if (optional.isPresent()) {
                        TbtskSysFields one = optional.orElse(null);
                        JSONArray filtercondition = JSONArray.parseArray(one.getfFiltercondition());
                        switch (one.getfFieldtype()) {//数据类型 [{name:'长文本',id:'1'},{name:'短文本',id:'2'},{name:'数字',id:'3'},{name:'日期',id:'4'},       {name:'时间',id:'5'},{name:'编号',id:'6'},{name:'面积',id:'7'},{name:'整数',id:'8'},{name:'空间字段',id:'9'},{name:'签名',id:'10'},{name:'编码',id:'11'}]
//                            文本型的
                            case "1":
                            case "2":
                            case "4": {  // XXX标识传参val值  TTT标识 任务id BBB标识图斑id
                                    if(filtercondition.size() == 1 ){
                                        JSONObject condition = filtercondition.getJSONObject(0);
                                        filterStr =  condition.getString("filter").replaceAll("XXX",val).replaceAll("TTT",taskId);
                                    }else{
                                        for(int j = 0; j  < filtercondition.size(); j++){
                                            JSONObject condition = filtercondition.getJSONObject(j);
                                            if(val.equals(condition.getString("id"))){
                                                filterStr =  condition.getString("filter").replaceAll("XXX",val).replaceAll("TTT",taskId);
                                            }
                                        }
                                    }
                                break;
                            } case "5": {  // 5时间格式
                                if(filtercondition.size() == 1 ){
                                    JSONObject condition = filtercondition.getJSONObject(0);
                                    val = String.valueOf(converTime(val));
                                    filterStr =  condition.getString("filter").replaceAll("XXX",val).replaceAll("TTT",taskId);
                                }
                                break;
                            }
                            case "7": {
                                for(int j = 0; j < filtercondition.size(); j++){
                                    JSONObject condition = filtercondition.getJSONObject(j);
                                    if(ref.equals(condition.getString("id"))){
                                        filterStr =  condition.getString("filter").replaceAll("XXX",val).replaceAll("TTT",taskId);
                                    }
                                }

                                break;
                            }
                            default:
                                break;
                        }
                    }
                    if (!StringUtils.isEmpty(filterStr)) {
                        where +=  filterStr;
                    }
                }
            }
        }
        return where;
    }



    public String parseSearchParam(String keyWord, String taskId,String tableId, String tableAlias) {
        String where = "";
        if (!StringUtils.isEmpty(keyWord)) {
            List<String> searchList = fieldsService.getTaskFieldsMateWeb(taskId, tableId,"102")
                    .stream()
                    .map(r -> "(" + tableAlias + "." + r.getfFieldname() + " LIKE '%" + keyWord + "%')")
                    .collect(Collectors.toList());
            String searchStr = String.join(" OR ", searchList);
            where += " AND (" + searchStr + ") ";
        }
        return where;
    }

    public String parseRegionCodeListParam(List<String> workAreaList, String tableAlias, TaskQueryParameter param, List<String> fields) {

        List<TbtskFlowDef> tbtskFlowDefs = MTbtskFlowService.findFlow(param.getTaskId(), FlowTypeEnum.AUDIT.getCode());
        Boolean isContainReview = false;
        if (!GutilCollection.isEmpty(tbtskFlowDefs)) {
            isContainReview = tbtskFlowDefs.get(0).getName().contains("审复核");
        }
        //获取最大级别
        String reviewStageStr = "";
        //判断是否是已审核列表或已复核列表
        if (param.getUserRole() != null && (param.getUserRole() == 2 || param.getUserRole() == 4 || param.getUserRole() == 5)) {
            int maxlevel = 6;
            if (param.getState() != null && param.getState() == 1) {
                for (String area : workAreaList) {
                    int temp = 5;
                    if (area.length() == 12) {
                        temp = 5;
                    } else if (area.length() == 9) {
                        temp = 4;
                    } else if (area.length() == 6) {
                        if (area.endsWith("0000")) {
                            temp = 1;
                        } else if (area.endsWith("00")) {
                            temp = 2;
                        } else {
                            temp = 3;
                        }
                    }
                    if (temp < maxlevel) {
                        maxlevel = temp;
                    }
                }
                //最大省级
                if (maxlevel == 1) {
                    /* reviewStageStr = " and (f_review_stage > " + ReviewStageEnum.PROVINCE_VERIFY.getCode() + " or f_reject_status = 1)";*/
                    if (param.getUserRole() == 2 || param.getUserRole() == 5) {
                        FlowStep getFlowStep = MTbtskFlowService.getFlowStep(tbtskFlowDefs.get(0), "省级审核", true);
                        if (getFlowStep != null) {
                            if (isContainReview) {
                                reviewStageStr = " and ((f_review_stage = " + getFlowStep.getPost_stage() + " and " +
                                        "f_status = " + getFlowStep.getPost_status() + ") or f_review_stage > " + getFlowStep.getPost_stage() + ") ";
                            } else {
                                reviewStageStr = " and f_review_stage >= " + getFlowStep.getPost_stage() + " and f_status >= " + getFlowStep.getPost_status();
                            }
                        }
                        /*  reviewStageStr = " and (f_review_stage > " + ReviewStageEnum.PROVINCE_VERIFY.getCode() + "and" +" f_status in ( " + TbStatusEnum.VERIFY.getCode() + "," + TbStatusEnum.VERIFY_REPORT.getCode() + "))";*/
                    } else if (param.getUserRole() == 4) {
                        FlowStep getFlowStep = MTbtskFlowService.getFlowStep(tbtskFlowDefs.get(0), "省级复核", true);
                        if (getFlowStep != null) {
                            reviewStageStr = " and f_review_stage >= " + getFlowStep.getPost_stage();
                        }
                        /* reviewStageStr = " and (f_review_stage > " + ReviewStageEnum.PROVINCE_VERIFY.getCode() +" and f_status in ( " + TbStatusEnum.REVIEW.getCode() + "," + TbStatusEnum.REVIEW_REPORT.getCode() + "))";*/
                    }
                } else if (maxlevel == 2) {
                    //最大市级
                    /*reviewStageStr = " and (f_review_stage > " + ReviewStageEnum.CITY_VERIFY.getCode() + " or f_reject_status = 1)";*/
                    if (param.getUserRole() == 2 || param.getUserRole() == 5) {
                        FlowStep getFlowStep = MTbtskFlowService.getFlowStep(tbtskFlowDefs.get(0), "市级审核", true);
                        if (getFlowStep != null) {
                            if (isContainReview) {
                                reviewStageStr = " and ((f_review_stage = " + getFlowStep.getPost_stage() + " and " +
                                        "f_status = " + getFlowStep.getPost_status() + ") or f_review_stage > " + getFlowStep.getPost_stage() + ") ";
                            } else {
                                reviewStageStr = " and ((f_review_stage >= " + getFlowStep.getPost_stage() + " and f_status >= " + getFlowStep.getPost_status()+") or ";
                                //增加打回市级数据
                                String f_review_stage = getFlowStep.getPre_stages();
                                if(f_review_stage.contains(",")){
                                    f_review_stage = f_review_stage.split(",")[0];
                                }
                                reviewStageStr += " ( f_reject_status =1 and f_review_stage='"+f_review_stage+"'))";
                            }
                        }
                        /* reviewStageStr = " and (f_review_stage > " + ReviewStageEnum.CITY_VERIFY.getCode() +" and f_status in ( " + TbStatusEnum.VERIFY.getCode() + "," + TbStatusEnum.VERIFY_REPORT.getCode() + "))";*/
                    } else if (param.getUserRole() == 4) {
                        FlowStep getFlowStep = MTbtskFlowService.getFlowStep(tbtskFlowDefs.get(0), "市级复核", true);
                        if (getFlowStep != null) {
                            reviewStageStr = " and f_review_stage >= " + getFlowStep.getPost_stage();
                        }
                        /* reviewStageStr = " and (f_review_stage > " + ReviewStageEnum.CITY_VERIFY.getCode() +" and f_status in ( " + TbStatusEnum.REVIEW.getCode() + "," + TbStatusEnum.REVIEW_REPORT.getCode() + "))";*/
                    }
                } else if (maxlevel == 3) {
                    //最大县级
                    /*   reviewStageStr = " and (f_review_stage > " + ReviewStageEnum.COUNTY_VERIFY.getCode() + " or f_reject_status = 1)";*/
                    if (param.getUserRole() == 2 || param.getUserRole() == 5) {
                        FlowStep getFlowStep = MTbtskFlowService.getFlowStep(tbtskFlowDefs.get(0), "区县审核", true);
                        if (getFlowStep != null) {
                            if (isContainReview) {
                                reviewStageStr = " and ((f_review_stage = " + getFlowStep.getPost_stage() + " and " +
                                        "f_status = " + getFlowStep.getPost_status() + ") or f_review_stage > " + getFlowStep.getPost_stage() + ") ";
                            } else {
                                reviewStageStr = " and ((f_review_stage >= " + getFlowStep.getPost_stage() + " and f_status >= " + getFlowStep.getPost_status()+") or ";
                                //增加打回县级数据
                                String f_review_stage = getFlowStep.getPre_stages();
                                if(f_review_stage.contains(",")){
                                    f_review_stage = f_review_stage.split(",")[0];
                                }
                                reviewStageStr += " ( f_reject_status =1 and f_review_stage='"+f_review_stage+"'))";
                            }
                        }
                        /*  reviewStageStr = " and (f_review_stage > " + ReviewStageEnum.COUNTY_VERIFY.getCode() +" and f_status in ( " + TbStatusEnum.VERIFY.getCode() + "," + TbStatusEnum.VERIFY_REPORT.getCode() + "))";*/
                    } else if (param.getUserRole() == 4) {
                        FlowStep getFlowStep = MTbtskFlowService.getFlowStep(tbtskFlowDefs.get(0), "区县复核", true);
                        if (getFlowStep != null) {
                            reviewStageStr = " and f_review_stage >= " + getFlowStep.getPost_stage();
                        }
                        /* reviewStageStr = " and (f_review_stage > " + ReviewStageEnum.COUNTY_VERIFY.getCode() +" and f_status in ( " + TbStatusEnum.REVIEW.getCode() + "," + TbStatusEnum.REVIEW_REPORT.getCode() + "))";*/
                    }
                } else if (maxlevel == 4) {
                    //最大乡级
                    /*  reviewStageStr = " and (f_review_stage > " + ReviewStageEnum.TOWN_VERIFY.getCode() + " or f_reject_status = 1)";*/
                    if (param.getUserRole() == 2 || param.getUserRole() == 5) {
                        FlowStep getFlowStep = MTbtskFlowService.getFlowStep(tbtskFlowDefs.get(0), "乡镇审核", true);
                        if (getFlowStep != null) {
                            if (isContainReview) {
                                reviewStageStr = " and ((f_review_stage = " + getFlowStep.getPost_stage() + " and " +
                                        "f_status = " + getFlowStep.getPost_status() + ") or f_review_stage > " + getFlowStep.getPost_stage() + ") ";
                            } else {
                                reviewStageStr = " and f_review_stage >= " + getFlowStep.getPost_stage() + " and f_status >= " + getFlowStep.getPost_status();
                            }
                        }
                        /*reviewStageStr = " and (f_review_stage > " + ReviewStageEnum.TOWN_VERIFY.getCode() +" and f_status in ( " + TbStatusEnum.VERIFY.getCode() + "," + TbStatusEnum.VERIFY_REPORT.getCode() + "))";*/
                    } else if (param.getUserRole() == 4) {
                        FlowStep getFlowStep = MTbtskFlowService.getFlowStep(tbtskFlowDefs.get(0), "乡镇复核", true);
                        if (getFlowStep != null) {
                            reviewStageStr = " and f_review_stage >= " + getFlowStep.getPost_stage();
                        }
                        /*  reviewStageStr = " and (f_review_stage > " + ReviewStageEnum.TOWN_VERIFY.getCode() +" and f_status in ( " + TbStatusEnum.REVIEW.getCode() + "," + TbStatusEnum.REVIEW_REPORT.getCode() + "))";*/
                    }
                } else if (maxlevel == 5) {
                    //最大村级
                    /* reviewStageStr = " and (f_review_stage > " + ReviewStageEnum.VILLAGE_VERIFY.getCode() + " or f_reject_status = 1)";*/
                    if (param.getUserRole() == 2 || param.getUserRole() == 5) {
                        FlowStep getFlowStep = MTbtskFlowService.getFlowStep(tbtskFlowDefs.get(0), "村级审核", true);
                        if (getFlowStep != null) {
                            if (isContainReview) {
                                reviewStageStr = " and ((f_review_stage = " + getFlowStep.getPost_stage() + " and " +
                                        "f_status = " + getFlowStep.getPost_status() + ") or f_review_stage > " + getFlowStep.getPost_stage() + ") ";
                            } else {
                                reviewStageStr = " and f_review_stage >= " + getFlowStep.getPost_stage() + " and f_status >= " + getFlowStep.getPost_status();
                            }
                        }
                        /*  reviewStageStr = " and (f_review_stage > " + ReviewStageEnum.VILLAGE_VERIFY.getCode() +" and f_status in ( " + TbStatusEnum.VERIFY.getCode() + "," + TbStatusEnum.VERIFY_REPORT.getCode() + "))";*/
                    } else if (param.getUserRole() == 4) {
                        FlowStep getFlowStep = MTbtskFlowService.getFlowStep(tbtskFlowDefs.get(0), "村级复核", true);
                        if (getFlowStep != null) {
                            reviewStageStr = " and f_review_stage >= " + getFlowStep.getPost_stage();
                        }
                        /* reviewStageStr = " and (f_review_stage > " + ReviewStageEnum.VILLAGE_VERIFY.getCode() +" and f_status in ( " + TbStatusEnum.REVIEW.getCode() + "," + TbStatusEnum.REVIEW_REPORT.getCode() + "))";*/
                    }
                }
            }
        }

        String where = "";
        if (!GutilCollection.isEmpty(workAreaList)) {
            String tempStr = "";
            for (String workArea : workAreaList) {
                String clause = parseRegionCodeParam(workArea, tableAlias, param,fields);
                if (StringUtils.isNotBlank(clause) && clause.trim().startsWith("AND")) {
                    clause = clause.trim().substring(3);
                }
                if (StringUtils.isNotBlank(clause)) {
                    tempStr += " " + clause + " OR";
                }
            }
            if (tempStr.trim().endsWith("OR")) {
                tempStr = tempStr.substring(0, tempStr.length() - 2);
            }
            if (StringUtils.isNotBlank(tempStr)) {
                where = " AND ( " + tempStr + " )" + reviewStageStr;
            }
        }
        return where;
    }

    /**
     * 解析政区代码获取筛选条件
     *
     * @param regionCode 政区代码
     * @param tableAlias 表别名
     * @return
     */
    public String parseRegionCodeParam(String regionCode, String tableAlias, TaskQueryParameter param, List<String> fields) {
        List<TbtskFlowDef> flowStep = MTbtskFlowService.findFlow(param.getTaskId(), FlowTypeEnum.AUDIT.getCode());
        Boolean isContainReview = false;
        if (!GutilCollection.isEmpty(flowStep)) {
            isContainReview = flowStep.get(0).getName().contains("审复核");
        }
        String AuditOrReviewStr = "";
        //判断审核或复核
        if (param.getUserRole() != null && (param.getUserRole() == 2 || param.getUserRole() == 5)) {
            //审核
            if (regionCode.length() == 12) {
                if (param.getState() != null && param.getState() == 0) {
                    FlowStep getFlowStep = MTbtskFlowService.getFlowStep(flowStep.get(0), "村级审核", true);
                    if (getFlowStep != null) {
                        AuditOrReviewStr = " and f_review_stage in (" + getFlowStep.getPre_stages() + ") and f_status in ( " + getFlowStep.getPre_status() + ")";
                    }
                }
            } else if (regionCode.length() == 9) {
                if (param.getState() != null && param.getState() == 0) {
                    FlowStep getFlowStep = MTbtskFlowService.getFlowStep(flowStep.get(0), "乡镇审核", true);

                    if (getFlowStep != null) {
                        String pre_stages = getFlowStep.getPre_stages();
                        if (!getFlowStep.getIs_start()) {
                            if (getFlowStep.getPre_stages().contains(",")) {
                                pre_stages = getFlowStep.getPre_stages().split(",")[1];
                            } else {
                                pre_stages = getFlowStep.getPre_stages();
                            }
                        }
                        AuditOrReviewStr = " and f_review_stage in (" + pre_stages + ") and f_status in ( " + getFlowStep.getPre_status() + ")";
                    }
                }
            } else if (regionCode.length() == 6) {
                // 区县、市、省
                if (regionCode.endsWith("0000")) {
                    if (param.getState() != null && param.getState() == 0) {
                        FlowStep getFlowStep = MTbtskFlowService.getFlowStep(flowStep.get(0), "省级审核", true);

                        if (getFlowStep != null) {
                            String pre_stages = getFlowStep.getPre_stages();
                            if (!getFlowStep.getIs_start()) {
                                if (getFlowStep.getPre_stages().contains(",")) {
                                    pre_stages = getFlowStep.getPre_stages().split(",")[1];
                                } else {
                                    pre_stages = getFlowStep.getPre_stages();
                                }
                            }
                            AuditOrReviewStr = " and f_review_stage in (" + pre_stages + ") and f_status in ( " + getFlowStep.getPre_status() + ")";
                        }
                    }
                } else if (regionCode.endsWith("00")) {
                    if (param.getState() != null && param.getState() == 0) {
                        FlowStep getFlowStep = MTbtskFlowService.getFlowStep(flowStep.get(0), "市级审核", true);

                        if (getFlowStep != null) {
                            String pre_stages = getFlowStep.getPre_stages();
                            if (!getFlowStep.getIs_start()) {
                                if (getFlowStep.getPre_stages().contains(",")) {
                                    pre_stages = getFlowStep.getPre_stages().split(",")[1];
                                } else {
                                    pre_stages = getFlowStep.getPre_stages();
                                }
                            }
                            AuditOrReviewStr = " and f_review_stage in (" + pre_stages + ") and f_status in ( " + getFlowStep.getPre_status() + ")";
                        }
                    }
                } else {
                    if (param.getState() != null && param.getState() == 0) {
                        FlowStep getFlowStep = MTbtskFlowService.getFlowStep(flowStep.get(0), "区县审核", true);

                        if (getFlowStep != null) {
                            String pre_stages = getFlowStep.getPre_stages();
                            if (!getFlowStep.getIs_start()) {
                                if (getFlowStep.getPre_stages().contains(",")) {
                                    pre_stages = getFlowStep.getPre_stages().split(",")[1];
                                } else {
                                    pre_stages = getFlowStep.getPre_stages();
                                }
                            }
                            AuditOrReviewStr = " and f_review_stage in (" + pre_stages + ") and f_status in ( " + getFlowStep.getPre_status() + ")";
                        }
                    }
                }
            }
        } else if (param.getUserRole() != null && param.getUserRole() == 4) {
            //复核
            if (regionCode.length() == 12) {
                if (param.getState() != null && param.getState() == 0) {
                    FlowStep getFlowStep = MTbtskFlowService.getFlowStep(flowStep.get(0), "村级复核", true);
                    if (getFlowStep != null) {
                        AuditOrReviewStr = " and f_review_stage in (" + getFlowStep.getPre_stages() + ") and f_status in ( " + getFlowStep.getPre_status() + ")";
                    }
                }
            } else if (regionCode.length() == 9) {
                if (param.getState() != null && param.getState() == 0) {
                    FlowStep getFlowStep = MTbtskFlowService.getFlowStep(flowStep.get(0), "乡镇复核", true);
                    if (getFlowStep != null) {
                        AuditOrReviewStr = " and f_review_stage in (" + getFlowStep.getPre_stages() + ") and f_status in ( " + getFlowStep.getPre_status() + ")";
                    }
                }
            } else if (regionCode.length() == 6) {
                // 区县、市、省
                if (regionCode.endsWith("0000")) {
                    if (param.getState() != null && param.getState() == 0) {
                        FlowStep getFlowStep = MTbtskFlowService.getFlowStep(flowStep.get(0), "省级复核", true);
                        if (getFlowStep != null) {
                            AuditOrReviewStr = " and f_review_stage in (" + getFlowStep.getPre_stages() + ") and f_status in ( " + getFlowStep.getPre_status() + ")";
                        }
                    }
                } else if (regionCode.endsWith("00")) {
                    if (param.getState() != null && param.getState() == 0) {
                        FlowStep getFlowStep = MTbtskFlowService.getFlowStep(flowStep.get(0), "市级复核", true);
                        if (getFlowStep != null) {
                            AuditOrReviewStr = " and f_review_stage in (" + getFlowStep.getPre_stages() + ") and f_status in ( " + getFlowStep.getPre_status() + ")";
                        }
                    }
                } else {
                    if (param.getState() != null && param.getState() == 0) {
                        FlowStep getFlowStep = MTbtskFlowService.getFlowStep(flowStep.get(0), "区县复核", true);
                        if (getFlowStep != null) {
                            AuditOrReviewStr = " and f_review_stage in (" + getFlowStep.getPre_stages() + ") and f_status in ( " + getFlowStep.getPre_status() + ")";
                        }
                    }
                }
            }
        }

        String where = "";
        if (StringUtils.isNotBlank(regionCode)) {
            if (!"1".equalsIgnoreCase(regionCode)) {
                String clause = "";
                if (regionCode.length() == 12) {
                    // 村级
                    clause = "f_xzqdmsys = '" + regionCode + "'" + AuditOrReviewStr;
                } else if (regionCode.length() == 9) {
                    // 乡镇级
                    if(fields.contains("f_xzqdmtown")){
                        clause = "f_xzqdmtown = '" + regionCode + "'" + AuditOrReviewStr;
                    }else{
                        clause = "f_xzqdmsys like '" + regionCode + "%'" + AuditOrReviewStr;
                    }

                } else if (regionCode.length() == 6) {
                    // 区县、市、省
                    if (regionCode.endsWith("0000")) {
                        clause = "f_xzqdmsys like '" + regionCode.substring(0, 2) + "%'" + AuditOrReviewStr;
                    } else if (regionCode.endsWith("00")) {
                        if(fields.contains("f_xzqdmcity")){
                            clause = "f_xzqdmcity = '" + regionCode + "'" + AuditOrReviewStr;
                        }else{
                            clause = "f_xzqdmsys like '" + regionCode.substring(0, 4) + "%'" + AuditOrReviewStr;
                        }
                    } else {
                        if(fields.contains("f_xzqdmcounty")){
                            clause = "f_xzqdmcounty = '" + regionCode + "'" + AuditOrReviewStr;
                        }else{
                            clause = "f_xzqdmsys like '" + regionCode + "%'" + AuditOrReviewStr;
                        }
                    }
                } else {
                    // 其他情况，此时政区代码可能不是标准的政区代码
                    clause = "f_xzqdmsys like '" + regionCode + "%'";
                }
                if (StringUtils.isNotBlank(tableAlias)) {
                    clause = tableAlias + "." + clause;
                    if (clause.length() > tableAlias.length() + 1) {
                        where = " AND (" + clause + " )";
                    }
                } else {
                    if (StringUtils.isNotBlank(clause)) {
                        where = " AND (" + clause + " )";
                    }
                }
            } else {
                // 国家级 数据不用筛选
            }
        }
        return where;
    }

    /**
     * 解析用户行政区 ，如果是区县级 则显示所有数据，如果是市级或者升级，则只显示没有被退回办结的图斑
     *
     * @param regionCode
     * @param tableAlias
     * @return
     */
    public String parseIsFinishFilterSC(String regionCode, String tableAlias) {
        String where = "";
        if (StringUtils.isNotBlank(regionCode)) {
            if (!"1".equalsIgnoreCase(regionCode)) {
                String clause = "";
                if (regionCode.length() == 12) {
                    // 村级
                    clause = "f_xzqdmsys = '" + regionCode + "'";
                } else if (regionCode.length() == 9) {
                    // 乡镇级
                    clause = "f_xzqdmsys like '" + regionCode + "%'";
                } else if (regionCode.length() == 6) {
                    // 区县、市、省
                    if (regionCode.endsWith("0000")) {
                        clause = "f_xzqdmsys like '" + regionCode.substring(0, 2) + "%'";
                    } else if (regionCode.endsWith("00")) {
                        clause = "f_xzqdmsys like '" + regionCode.substring(0, 4) + "%'";
                    } else {
                        clause = "f_xzqdmsys like '" + regionCode + "%'";
                    }
                } else {
                    // 其他情况，此时政区代码可能不是标准的政区代码
                    clause = "f_xzqdmsys like '" + regionCode + "%'";
                }
                if (StringUtils.isNotBlank(tableAlias)) {
                    clause = tableAlias + "." + clause;
                    if (clause.length() > tableAlias.length() + 1) {
                        where = " AND " + clause;
                    }
                } else {
                    if (StringUtils.isNotBlank(clause)) {
                        where = " AND " + clause;
                    }
                }
            } else {
                // 国家级 数据不用筛选
            }
        }
        return where;
    }

    /**
     * 聚合模式
     *
     * @param lon
     * @param lat
     * @param bizId
     * @param count
     * @return
     */
    public List<Map<String, Object>> aggregationSQL(String lon, String lat, String bizId, int count) {
        List<Map<String, Object>> list = null;
        String sql = "";
        String tableName = getTableNameByBizId(bizId);
        //聚合sql
        if (!"".equals(tableName)) {
            sql = "select width_bucket ( " +
                    "f_lon ," + lon + "," + count + ")" + "grid_x, " +
                    "width_bucket ( " +
                    "f_lat ," + lat + "," + count + ")" + "grid_y, " +
                    "count(*)," +
                    "st_asewkt(st_centroid(st_collect(f_shape))) geom " +
                    "from " + tableName + " " +
                    "where f_shape is not null and  " +
                    "f_lon between " + lon.replace(",", " and ") + " and " +
                    "f_lat between " + lat.replace(",", " and ") +
                    "group by grid_x,grid_y";
            list = jdbcTemplate.queryForList(sql);
        }
        return list;
    }

    /**
     * 取消聚合模式
     *
     * @param lon
     * @param lat
     * @param bizId
     * @return
     */
    public List<Map<String, Object>> cancelAggregationSQL(String lon, String lat, String bizId) {
        List<Map<String, Object>> list = new ArrayList<>();
        String sql = "";
        TskTaskBiz tskTaskBiz = tskTaskBizRepository.findById(bizId).orElse(null);
        String tableName = getTableNameByBizId(bizId);
        if (!"".equals(tableName)) {
            String countsql = "select count(1) from " + tableName + " where " +
                    "f_shape is not null and " +
                    "f_lon between " + lon + " and " +
                    "f_lat between " + lat;
            Integer count = jdbcTemplate.queryForObject(countsql, Integer.class);
            if (count > 1000) {
                throw new GwValidateException("图斑数量过多,请放大后取消聚合");
            }
            sql = "select f_id,st_asewkt(st_centroid(f_shape)) shape,f_status from " +
                    tableName + " where " +
                    "f_shape is not null and " +
                    "f_lon between " + lon + " and " +
                    "f_lat between " + lat;
            list = jdbcTemplate.queryForList(sql);
        }
        return list;
    }

    /**
     * 勾选获取图斑列表
     * 李密浩
     *
     * @param shape
     * @param bizId
     * @return
     */
    public List<Map<String, Object>> findTbsByShapeSQL(String shape, String bizId) {
        List<Map<String, Object>> list = new ArrayList<>();
        try {
            Geometry geometry = WKTUtil.wktToGeom(shape);
            String tableName = getTableNameByBizId(bizId);
            String sql = "";
            if (!"".equals(tableName)) {
                //查询配置的展示项
                List<String> showList = fieldsService.getTaskFieldsMateWeb(bizId, null,"100")
                        .stream().map(r -> r.getfFieldname()).collect(Collectors.toList());
                //分割成查询项
                String showSql = StringUtils.join(showList, ",");
                sql = "select f_id," + showSql + ",f_status,st_asewkt(st_centroid(f_shape)) point " + " from " +
                        tableName + " where f_shape is not null and " +
                        " st_intersects(st_geometryfromtext('" + geometry + "',4490),f_shape)";
                list = jdbcTemplate.queryForList(sql);
            }
        } catch (ParseException e) {
            e.printStackTrace();
        }
        return list;
    }

    /**
     * 动态获取图斑显示字段
     *
     * @param bizId
     * @param tbId
     * @return
     */
    public List<Map<String, Object>> getTbDetail(String bizId, String tbId) {
        List<Map<String, Object>> list = new ArrayList<>();
        String tableName = getTableNameByBizId(bizId);
        String sql = "";
        //主显示字段
        List<String> fields = fieldsService.getTaskFieldsMateWeb(bizId, null,"103").stream().map(r -> r.getfFieldname())
                .collect(Collectors.toList());

        String selectFields = StringUtils.join(fields, ",");
        if (!"".equals(tableName) && fields.size() > 0) {
            sql = " select " + selectFields + ",f_shape " + " from " + tableName + " where f_id='" + tbId + "'";
            list = jdbcTemplate.queryForList(sql);
        }
        for (Map<String, Object> map : list) {
            map.put("f_shape", map.get("f_shape").toString());
        }
        return list;
    }

    /**
     * 查询tableName
     * 李密浩
     *
     * @param bizId
     * @return
     */
    public String getTableNameByBizId(String bizId) {
        String tableName = "";
        TskTaskBiz tskTaskBiz = tskTaskBizRepository.findById(bizId).orElse(null);
        if (tskTaskBiz != null) {
            TbtskObjectinfo tbtskObjectinfo = tbtskObjectinfoRepository.getObjectByTableId(tskTaskBiz.getTableId());
            tableName = tbtskObjectinfo.getfTablename();
        }
        return tableName;
    }

    /**
     * 获取用户所属政区，当用户存在多个所属政区时，取第一个所属政区
     *
     * @param request
     * @param userId
     * @return
     */
    private String getUserRegionCode(HttpServletRequest request, Long userId) {
        String userRegionCode = "";
        if (request.getSession().getAttribute("user-area") != null) {
            String userAreas = (String) request.getSession().getAttribute("user-area");
            if (StringUtils.isNotBlank(userAreas)) {
                if (userAreas.contains(",")) {
                    String[] userRegions = userAreas.split(",");
                    if (userRegions.length > 0) {
                        userRegionCode = userRegions[0];
                    }
                } else {
                    userRegionCode = userAreas;
                }
            }
        } else {
            userRegionCode = userAreaService.getUserRegionCode(userId);
        }

        return userRegionCode;
    }

    /**
     * 查询Web端列表展示数据
     *
     * @param param 查询参数
     * @return 查询结果元组，第一个属性为数据个数，第二个属性为数据内容
     * @throws Exception 用户政区查询失败异常等
     */
    public Triplet<Long, List<Map>,Double> queryWebDisplayListData(TaskQueryParameter param) throws Exception {
        if (param == null) {
            return null;
        }
        Pair<String, String> queryParamPair = null;
        //获取四川举报线索任务Id
        SysConfig sysConfig = sysConfigService.findOne(BizIdConstants.SCGTY_BIZ_ID);


        if (sysConfig != null && param.getTaskId().equalsIgnoreCase(sysConfig.getValue())) {
            queryParamPair = parseQueryParameterBySc(param);
        } else {
            queryParamPair = parseQueryParameter(param);
        }
        String tableName = queryParamPair.getLeft();
        String where = queryParamPair.getRight();
        String order = " order by " + param.getSortParam();
        //待审核页面使用审核时间排序
        if(param.getUserRole() != null && param.getUserRole() == 2 && param.getState() != null && param.getState() == 0){
            order = " order by f_approvetime asc " ;
        }
        TskTaskBiz taskBiz = findByTaskId(param.getTaskId());
        //处理地块列表数据
        TbtskObjectinfo tableInfo = null;
        if(StringUtils.isNotBlank(param.getTableId())){
            tableInfo = mTbtskObjectinfoService.getObjectbyID(param.getTableId());
            if(StringUtils.isNotBlank(param.getTbIds())){
                TbtskObjectinfo parentTableInfo = mTbtskObjectinfoService.getObjectbyID(taskBiz.getTableId());
                JSONObject jsonObject = JSONObject.parseObject(tableInfo.getRelfield());
                String parentFieldName = jsonObject.getString("parentFieldName");
                String childFieldName = jsonObject.getString("fieldName");
                String sql = "select "+parentFieldName+" from "+parentTableInfo.getfTablename() + " where f_id ='"+param.getTbIds()+"'";
                String data = jdbcTemplate.queryForObject(sql, String.class);
                where += " and tb."+childFieldName+" = '"+data+"'";
            }
        }else{
            tableInfo = mTbtskObjectinfoService.getObjectbyID(taskBiz.getTableId());
        }
        List<String> fieldNameList = null;
        fieldNameList = fieldsService.getTbtskFieldsNameListBySysCodeAndGroupCode("web",tableInfo.getfId(), FieldGroupTypeConstant.WEB_LIST_DISPLAY);
        fillRequiredFieldNames(fieldNameList,tableInfo);
        fieldNameList = fieldNameList.stream().map("tb."::concat).collect(Collectors.toList());

       /* if (fieldNameList.contains("f_splitedid")) { //通过配置判断是否加载分割字段、默认不加载
            where += " and ( f_splitedid is null)";//分割后的子图斑使用懒加载
        }*/
        //查询下发人员
        fieldNameList.add("(select record.f_assignto  from tbtsk_assign_record record where tb.f_id = record.f_dataid and  record.f_status ='1' and record.f_taskid = '"+param.getTaskId()+"' order by record.f_createtime desc   limit 1 )");
        //查询批量审核分发
        List<UserBiz2> byBizIdAndRole = userBiz2Repository.findByBizIdAndRole(param.getTaskId(), 5);
        if(byBizIdAndRole.size() > 0){//判断该任务是否配置超级审核员
            fieldNameList.add("(select record.f_assignto as f_distributionto from tbtsk_audit_assign_record record where tb.f_id = record.f_dataid limit 1 )");
        }
        // 子图斑，不作连接
        if (StringUtils.isNotBlank(tableInfo.getParentObjId())) {
            tableName = tableInfo.getfTablename() + " as tb";
        }
        // //综合监管定制页面 问题整改数据页面返回数据
        if(StringUtils.isNotBlank(param.getZhjgWtzgCode()) ){
            if (!fieldNameList.contains("f_gzlx")) {
                fieldNameList.add("f_gzlx");
            }
        }
        if(param.getNeedHld()!=null&&param.getNeedHld().equals(1)){
            Long green = greenDay*24*60*60L;
            Long yellow = yellowDay*24*60*60L;
            fieldNameList.add("tb.f_option");
            fieldNameList.add("(case when EXTRACT(EPOCH FROM now()-tb.f_approve_time_city)<="+ green+" then 1\n" +
                    " when EXTRACT(EPOCH FROM now()-tb.f_approve_time_city)>"+green+" and EXTRACT(EPOCH FROM now()-tb.f_approve_time_city)<="+ yellow +" then 2\n" +
                    "when EXTRACT(EPOCH FROM now()-tb.f_approve_time_city)>"+ yellow+" then 3\n" +
                    "else 0 end) as hld");
            fieldNameList.add("(case when EXTRACT(EPOCH FROM now()-tb.f_approve_time_city)<="+ green+" then '正常'\n" +
                    " when EXTRACT(EPOCH FROM now()-tb.f_approve_time_city)>"+green+" and EXTRACT(EPOCH FROM now()-tb.f_approve_time_city)<="+ yellow +" then '预警未审核'\n" +
                    "when EXTRACT(EPOCH FROM now()-tb.f_approve_time_city)>"+ yellow+" then '超期未审核'\n" +
                    "else '' end) as hld_text");
        }
        Integer count = mDataBizService.getCount(tableName, where);
        List<Map> list = mDataBizService.queryPageData(tableName, fieldNameList, param.getRows(), param.getPage(), where + order);
        String sumSql = "  select sum(f_tbmj) from "+tableName +" where "+where;
        Double sumMj = jdbcTemplate.queryForObject(sumSql, Double.class);
        List<Map> dataList = updateAssignInfo(list, param.getTaskId());
        //增加子图斑数据
        if (fieldNameList.contains("tb.f_splitedid") ) {
            dataList = updateChildren(list, param.getTaskId(), tableInfo, fieldNameList,param);
        }
        return Triplet.with(Long.valueOf(count), dataList,sumMj);
    }

    //只获取数据id，就不用查询列表那些不相关的数据，影响性能
    public Pair<Long, List<Map>> queryWebDisplayListDataNotPage(TaskQueryParameter param) throws Exception {
        if (param == null) {
            return null;
        }
        Pair<String, String> queryParamPair =  parseQueryParameter(param);
        String tableName = queryParamPair.getLeft();
        String where = queryParamPair.getRight();
        String order = " order by " + param.getSortParam();

       /* TskTaskBiz taskBiz = findByTaskId(param.getTaskId());
        TbtskObjectinfo tableInfo = mTbtskObjectinfoService.getObjectbyID(taskBiz.getTableId());*/
        List<String> fieldNameList = Arrays.asList("f_id","f_status");
       /* fieldNameList = fieldsService.getTbtskFieldsNameListBySysCodeAndGroupCode("web",
                tableInfo.getfId(), FieldGroupTypeConstant.WEB_LIST_DISPLAY);
        fillRequiredFieldNames(fieldNameList,tableInfo);*/
       /* if (fieldNameList.contains("f_splitedid")) { //通过配置判断是否加载分割字段、默认不加载
            where += " and ( f_splitedid is null)";//分割后的子图斑使用懒加载
        }*/
        //查询下发人员
       /* fieldNameList.add("(select record.f_assignto  from tbtsk_assign_record record where tb.f_id = record.f_dataid limit 1 )");
        //查询批量审核分发
        fieldNameList.add("(select record.f_assignto as f_distributionto from tbtsk_audit_assign_record record where tb.f_id = record.f_dataid limit 1 )");
        // 子图斑，不作连接
        if (StringUtils.isNotBlank(tableInfo.getParentObjId())) {
            tableName = tableInfo.getfTablename() + " as tb";
        }
        // //综合监管定制页面 问题整改数据页面返回数据
        if(StringUtils.isNotBlank(param.getZhjgWtzgCode()) ){
            if (!fieldNameList.contains("f_gzlx")) {
                fieldNameList.add("f_gzlx");
            }
        }
        Integer count = mDataBizService.getCount(tableName, where);*/
        List<Map> list = dataBizMapper.queryNotPageData(tableName, fieldNameList, where );
       /*  List<Map> dataList = updateAssignInfo(list, param.getTaskId());
        //增加子图斑数据
       if (fieldNameList.contains("f_splitedid") ) {
            dataList = updateChildren(list, param.getTaskId(), tableInfo, fieldNameList);
        }*/
        return Pair.of(Long.valueOf(0), list);
    }

    /**
     * 查询Web端列表展示数据
     *
     * @param param 查询参数
     * @return 查询结果元组，第一个属性为数据个数，第二个属性为数据内容
     * @throws Exception 用户政区查询失败异常等
     */
    public Pair<Long, List<Map>> queryTaskDataMedias(TaskQueryParameter param) throws Exception {
        if (param == null) {
            return null;
        }
        Pair<String, String> queryParamPair = parseQueryParameter(param);
        String tableName = queryParamPair.getLeft();
        String where = queryParamPair.getRight();
        String order = " order by media.f_galleryid,media.f_time desc ";

        TskTaskBiz taskBiz = findByTaskId(param.getTaskId());
        TbtskObjectinfo tableInfo = mTbtskObjectinfoService.getObjectbyID(taskBiz.getTableId());
        List<String> fieldNameList = new ArrayList<>();
        //增加附件表字段
        fillRequiredFieldNamesMedia(fieldNameList);
        // 子图斑，不作连接
        if (StringUtils.isNotBlank(tableInfo.getParentObjId())) {
            tableName = tableInfo.getfTablename() + " as tb";
        }
        // 附件表数据进行左连接查询
        tableName = tableName +" INNER JOIN tb_app_media  AS media ON tb.f_id = media.f_galleryid ";
        //只查询照片
        where = where + " and media.f_type ='1'  ";
        Integer count = mDataBizService.getCount(tableName, where);
        List<Map> list = mDataBizService.queryPageData(tableName, fieldNameList, param.getRows(), param.getPage(), where + order);
        if(list.size() > 0 ){
            for(Map map : list){
                if (map.get("f_serverpath") != null && org.apache.commons.lang3.StringUtils.isNotBlank(map.get("f_serverpath").toString())
                        && !map.get("f_serverpath").toString().contains("AccessKeyId")) {
                    String url = temporarySignedUrlService.getTemporarySignedUrl("", map.get("f_serverpath").toString(), null);
                    map.put("f_serverpath",url);
                }
                map.put("f_bizid",param.getTaskId());
            }
        }
        return Pair.of(Long.valueOf(count), list);
    }

    /**
     * 查询Web端列表展示数据
     *
     * @param param 查询参数
     * @return 查询结果元组，第一个属性为数据个数，第二个属性为数据内容
     * @throws Exception 用户政区查询失败异常等
     */
    public Pair<Long, List<Map>> queryTaskDataMediaList(TaskQueryParameter param) throws Exception {
        if (param == null) {
            return null;
        }
        Pair<String, String> queryParamPair = parseQueryParameter(param);
        String tableName = queryParamPair.getLeft();
        String where = queryParamPair.getRight();
        String order = " order by media.f_galleryid,media.f_time desc ";

        TskTaskBiz taskBiz = findByTaskId(param.getTaskId());
        TbtskObjectinfo tableInfo = mTbtskObjectinfoService.getObjectbyID(taskBiz.getTableId());
        List<String> fieldNameList = new ArrayList<>();
        fieldNameList.add("tb.f_id");
        fieldNameList.add("tb.f_tbbh");
        //增加附件表字段
       /* fillRequiredFieldNamesMedia(fieldNameList);*/
        // 子图斑，不作连接
        if (StringUtils.isNotBlank(tableInfo.getParentObjId())) {
            tableName = tableInfo.getfTablename() + " as tb";
        }
       /* // 附件表数据进行左连接查询
        tableName = tableName +" INNER JOIN tb_app_media  AS media ON tb.f_id = media.f_galleryid ";*/
        //只查询照片
        where = where + " and EXISTS(SELECT media.f_galleryid  FROM tb_app_media AS media WHERE tb.f_id = media.f_galleryid and media.f_type ='1' )  ";
        Integer count = mDataBizService.getCount(tableName, where);
        List<Map> list = mDataBizService.queryPageData(tableName, fieldNameList, param.getRows(), param.getPage(), where);
        if(list.size() > 0 ){
            for(Map map : list){
                String f_galleryid = map.get("f_id").toString();
                //获取附件数据
                String mediaSql = " select * from tb_app_media where f_galleryid  ='"+f_galleryid+"' and f_type ='1' order by f_time  desc limit 4";
                List<Map> mediaList = mDataBizService.queryDataBySql(mediaSql);
                if(mediaList.size() > 0){
                    for(Map map1 : mediaList){
                        if (map1.get("f_serverpath") != null && org.apache.commons.lang3.StringUtils.isNotBlank(map1.get("f_serverpath").toString())
                                && !map1.get("f_serverpath").toString().contains("AccessKeyId")) {
                            String url = temporarySignedUrlService.getTemporarySignedUrl("", map1.get("f_serverpath").toString(), null);
                            map1.put("f_serverpath",url);
                            map1.put("f_bizid",param.getTaskId());
                        }
                    }
                    map.put("mediaList",mediaList);
                }else{
                    map.put("mediaList",new ArrayList<>());
                }
            }
        }
        return Pair.of(Long.valueOf(count), list);
    }

    /**
     * 更新审核信息-河北项目
     *
     * @param sourceDataList
     * @param param
     */
    private void updateAuditInfo(List<Map> sourceDataList, TaskQueryParameter param) {
        for (Map map : sourceDataList) {
            if (map != null) {
                Integer rejectCount = MapUtils.getInteger(map, "f_reject_count", 0);
                TbtskApproveRecord approveRecord = tbtskApproveRecordRepository.queryLatestApproveRecord(param.getTaskId(), map.get("f_id").toString(), rejectCount);

                map.put("f_auditResult", approveRecord != null ? approveRecord.getOption() : null);
            }
        }
    }

    /**
     * 查询业务流程对应步骤信息
     */
    public List<FlowStep> findFlowSteps(String taskId, FlowTypeEnum flowType) {
        if (StringUtils.isBlank(taskId)) {
            return null;
        }
        List<TbtskFlowDef> flows = tbtskFlowDefRepository.findTbtskFlowByTaskId(taskId, flowType.getCode());
        if (flows == null || flows.size() == 0) {
            return null;
        }
        List<FlowStep> steps = new Gson().fromJson(flows.get(0).getSteps(), new TypeToken<List<FlowStep>>() {
        }.getType());
        return steps;
    }

    public Pair<String, String> parseQueryParameter(TaskQueryParameter param) throws Exception {

        String tempFilter = "";
        String rejectJoinFilter = "";
        StringBuilder sbFilter = new StringBuilder(" 1=1 ");
        String tableAlias = "tb";
        List<String> fields = new ArrayList<>();
        if(StringUtils.isNotBlank(param.getRegionCode()) || param.getUserRole() != null){
            //查找表所有字段
            TskTaskBiz taskBiz = findByTaskId(param.getTaskId());
            List<TbtskFields> allFields = tbtskFieldsRepository.getTbtskFieldsByTableid(org.apache.commons.lang3.StringUtils.isNotBlank(param.getTableId())?param.getTableId():taskBiz.getTableId());
            //处理新增的市、县、镇、村
            fields = allFields.stream().map(e -> e.getfFieldname()).collect(Collectors.toList());
        }
        if (StringUtils.isNotBlank(param.getRegionCode())) {
            sbFilter.append(" and  (");
            String[] split = param.getRegionCode().split(",");
            for(int i=0;i< split.length ; i++){
                String regionCode = split[i];
                if (regionCode.length() <= 6) {
                    if (regionCode.endsWith("0000")) {
                        sbFilter.append(tableAlias);
                        sbFilter.append(".f_xzqdmsys like '" + regionCode.substring(0, 2) + "%' ");
                    } else if (regionCode.endsWith("00")) {
                        sbFilter.append(tableAlias);
                        if(fields.contains("f_xzqdmcity")){
                            sbFilter.append(".f_xzqdmcity = '" + regionCode + "' ");
                        }else{
                            sbFilter.append(".f_xzqdmsys like '" + regionCode.substring(0, 4) + "%' ");
                        }
                    } else {
                        sbFilter.append(tableAlias);
                        if(fields.contains("f_xzqdmcounty")){
                            sbFilter.append(".f_xzqdmcounty = '" + regionCode + "' ");
                        }else{
                            sbFilter.append(".f_xzqdmsys like '" + regionCode + "%' ");
                        }
                    }
                } else if(regionCode.length() == 9 ){
                    sbFilter.append(tableAlias);
                    if(fields.contains("f_xzqdmtown")){
                        sbFilter.append(".f_xzqdmtown = '" + regionCode + "' ");
                    }else{
                        sbFilter.append(".f_xzqdmsys like '" + regionCode + "%' ");
                    }
                }else if(regionCode.length() == 12 ){
                    sbFilter.append(tableAlias);
                    sbFilter.append(".f_xzqdmsys = '" + regionCode + "' ");
                }
                if(i < split.length-1){
                    sbFilter.append(" or ");
                }
            }
            sbFilter.append(" )");
        }

        //综合监管定制页面 问题整改数据页面
        if(StringUtils.isNotBlank(param.getZhjgWtzgCode()) ){

            List<JcClueFilter> jcClueFilters = jcClueFilterDao.selectBySourceIdAndEnumCode(param.getTaskId(), param.getZhjgWtzgCode());
            if(jcClueFilters.size() > 0){
                //定制查询删选数据条件
                sbFilter.append(" and (");
                for(JcClueFilter jcClueFilter : jcClueFilters){
                    sbFilter.append("(").append(jcClueFilter.getFilterValue()).append(") or ");
                }
                sbFilter.delete(sbFilter.length()-4,sbFilter.length());
                sbFilter.append(" ) ");
            }else{
                sbFilter.append(" and ");
                sbFilter.append(tableAlias);
                sbFilter.append(".f_id is null  ");
            }
        }
        //市级审核状态 0：不通过，1：通过
        if(org.apache.commons.lang3.StringUtils.isNotBlank(param.getSjshStatus())){
            if("1".equals(param.getSjshStatus())){
                sbFilter.append("and (");
                sbFilter.append(tableAlias);
                sbFilter.append(".f_review_stage > 95 ");
                sbFilter.append(")");
            }else{
                sbFilter.append("and (");
                sbFilter.append(tableAlias);
                sbFilter.append(".f_reject_status = 1 ");
                sbFilter.append("and ");
                sbFilter.append(tableAlias);
                sbFilter.append(".f_review_stage = 93 ");
                sbFilter.append(")");
            }
        }
        //区县级审核状态 0：不通过，1：通过
        if(org.apache.commons.lang3.StringUtils.isNotBlank(param.getQxshStatus())){
            if("1".equals(param.getQxshStatus())){
                sbFilter.append("and (");
                sbFilter.append(tableAlias);
                sbFilter.append(".f_review_stage > 93 ");
                sbFilter.append(")");
            }else{
                sbFilter.append("and (");
                sbFilter.append(tableAlias);
                sbFilter.append(".f_reject_status = 1 ");
                sbFilter.append("and ");
                sbFilter.append(tableAlias);
                sbFilter.append(".f_review_stage = 90 ");
                sbFilter.append(")");
            }
        }

        if( param.getReviewResults() != null || param.getStaging() != null){
            List<RegionDto> userRoleAreas = getUserRoleAreas(param.getTaskId(), param.getUserId(), param.getUserRole(), null);
            RegionDto regionDto = userRoleAreas.get(0);
            String code = regionDto.getCode();
            Integer level = null;
            if (code.endsWith("0000") && code.length() == 6){
                level = 1;
            } else if (code.endsWith("00") && code.length() == 6) {
                level = 2;
            } else if (code.length() == 6){
                level = 3;
            }
            //是否通过
            if (param.getReviewResults() != null){
                if (param.getReviewResults() == 1){ //通过
                    if (level == 1){ //省级审核通过
                        sbFilter.append("and (");
                        sbFilter.append(tableAlias);
                        sbFilter.append(".f_review_stage > 97");
                        sbFilter.append(")");
                    }else if (level == 2){ //市级审核通过
                        sbFilter.append("and (");
                        sbFilter.append(tableAlias);
                        sbFilter.append(".f_review_stage > 95");
                        sbFilter.append(")");
                    }else if (level == 3){ //县级审核通过
                        sbFilter.append("and (");
                        sbFilter.append(tableAlias);
                        sbFilter.append(".f_review_stage > 93");
                        sbFilter.append(")");
                    }

                }else  if (param.getReviewResults() == 2){ //不通过

                    if (level == 1){ //省级审核不通过
                        sbFilter.append("and (");
                        sbFilter.append(tableAlias);
                        sbFilter.append(".f_reject_status = 1");
                        sbFilter.append("and ");
                        sbFilter.append(tableAlias);
                        sbFilter.append(".f_review_stage = 95");
                        sbFilter.append(")");
                    }else if (level == 2){ //市级审核不通过
                        sbFilter.append("and (");
                        sbFilter.append(tableAlias);
                        sbFilter.append(".f_reject_status = 1");
                        sbFilter.append("and ");
                        sbFilter.append(tableAlias);
                        sbFilter.append(".f_review_stage = 93");
                        sbFilter.append(")");
                    }else if (level == 3){ //县级审核不通过
                        sbFilter.append("and (");
                        sbFilter.append(tableAlias);
                        sbFilter.append(".f_reject_status = 1");
                        sbFilter.append("and ");
                        sbFilter.append(tableAlias);
                        sbFilter.append(".f_review_stage = 90");
                        sbFilter.append(")");
                    }

                }else  if (param.getReviewResults() == 3){ //暂存
                    if (level == 1){ //省级审核暂存
                        sbFilter.append("and (");
                        sbFilter.append(tableAlias);
                        sbFilter.append(".f_status = 20 ");
                        sbFilter.append("and ");
                        sbFilter.append(tableAlias);
                        sbFilter.append(".f_review_stage = 97");
                        sbFilter.append(")");
                    }else if (level == 2){ //市级审核暂存
                        sbFilter.append("and (");
                        sbFilter.append(tableAlias);
                        sbFilter.append(".f_status = 20 ");
                        sbFilter.append("and ");
                        sbFilter.append(tableAlias);
                        sbFilter.append(".f_review_stage = 95");
                        sbFilter.append(")");
                    }else if (level == 3){ //县级审核暂存
                        sbFilter.append("and (");
                        sbFilter.append(tableAlias);
                        sbFilter.append(".f_status = 20 ");
                        sbFilter.append("and ");
                        sbFilter.append(tableAlias);
                        sbFilter.append(".f_review_stage = 93");
                        sbFilter.append(")");
                    }

                }

            }
            //是否暂存
            if (param.getStaging() != null){
                if (param.getStaging() == 1){//是
                    sbFilter.append("and (");
                    sbFilter.append(tableAlias);
                    sbFilter.append(".f_status = 20 ");
                    sbFilter.append(")");
                }else if(param.getStaging() == 2){//否
                    sbFilter.append("and (");
                    sbFilter.append(tableAlias);
                    sbFilter.append(".f_status != 20 ");
                    sbFilter.append(")");
                }

            }
        }
        // 领取状态/下发状态
        if (StringUtils.isNotBlank(param.getDeliveryStatus())) {
            sbFilter.append(" and ");
            sbFilter.append(tableAlias);
            if ("1".equals(param.getDeliveryStatus())) {
                sbFilter.append(".f_status = 1 ");
            } else {
                sbFilter.append(".f_status > 1 ");
            }
        }
        // 菜单id
        if (StringUtils.isNotBlank(param.getMenuId())) {
            TbtskTaskMenu taskMenu = tbtskTaskMenuRepository.findById(param.getMenuId()).orElse(null);
            if(taskMenu != null){
                sbFilter.append(" and (");
                sbFilter.append(taskMenu.getCondition());
                sbFilter.append(" ) ");
            }
        }

        // 提交状态
        if (StringUtils.isNotBlank(param.getSubmitStatus())) {
            sbFilter.append(" and ");
            sbFilter.append(tableAlias);
            if ("2".equals(param.getSubmitStatus())) {
                sbFilter.append(".f_status >= 4 ");
                // 提交时间
                //结束时间为当天最后一秒
                if (param.getSubmitTimeEnd() != null) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(new Date(param.getSubmitTimeEnd()));
                    calendar.set(Calendar.HOUR, 23);
                    calendar.set(Calendar.MINUTE, 59);
                    calendar.set(Calendar.SECOND, 59);
                    Date date = calendar.getTime();
                    param.setSubmitTimeEnd(date.getTime());
                }
                if (param.getSubmitTimeStart() != null && param.getSubmitTimeEnd() != null) {
                    sbFilter.append(" and ");
                    sbFilter.append(" (").append(tableAlias).append(".f_committime >= '").append(param.getSubmitTimeStart())
                            .append("' and ").append(tableAlias).append(".f_committime <='").append(param.getSubmitTimeEnd())
                            .append("') ");
                } else if (param.getSubmitTimeStart() != null && param.getSubmitTimeEnd() == null) {
                    sbFilter.append(" and ");
                    sbFilter.append(tableAlias).append(".f_committime >='").append(param.getSubmitTimeStart()).append("'");
                } else if (param.getSubmitTimeStart() == null && param.getSubmitTimeEnd() != null) {
                    sbFilter.append(" and ");
                    sbFilter.append(tableAlias).append(".f_committime <='").append(param.getSubmitTimeEnd() + "'");
                }
            } else {
                sbFilter.append(".f_status < 4 ");
            }
        }

        // 图斑来源
        if (StringUtils.isNotBlank(param.getDataSource())) {
            sbFilter.append(" and ");
            if ("1".equals(param.getDataSource())) {
                sbFilter.append(tableAlias).append(".f_ismycreate = 1 ");
            } else {
                sbFilter.append(" (").append(tableAlias).append(".f_ismycreate = 0 ")
                        .append(" or ").append(tableAlias).append(".f_ismycreate is null ").append(") ");
            }
        }
        // 典型数据
        if (param.getIsTypicalData() != null) {
            sbFilter.append(" and ");
            if (param.getIsTypicalData() == 1) {
                sbFilter.append(tableAlias).append(".f_typical = '1' ");
            }else{
                sbFilter.append(" (").append(tableAlias).append(".f_typical = '0' ")
                        .append(" or ").append(tableAlias).append(".f_typical is null ").append(") ");
            }
        }

        // 作业人员
        if (StringUtils.isNotBlank(param.getOperator())) {
          /*  sbFilter.append(" and ");
            sbFilter.append(tableAlias);
            sbFilter.append(".f_upload_userid like '%" + param.getOperator().trim() + "%'");*/
            rejectJoinFilter = String.format(" inner join (select distinct r.f_dataid from TbSYS_USER u," +
                    "tbtsk_assign_record r where to_number(r.f_assignto,'99999999')=u.f_userid and r.f_taskid ='%s' " +
                    "and (u.f_username = '%s' or u.f_rname = '%s')) AS assign ON tb.f_id = assign.f_dataid and r.f_status != '2' ",
                    param.getTaskId(), param.getOperator().trim(), param.getOperator().trim());
        }

        // 是否提报
        if (StringUtils.isNotBlank(param.getReportStatus())) {
            sbFilter.append(" and ");
            sbFilter.append(tableAlias);
            if ("0".equals(param.getReportStatus())) {
                sbFilter.append(".f_status < ").append(TbStatusEnum.WAITING_VERIFY.getCode());
            } else if ("1".equals(param.getReportStatus())) {
                sbFilter.append(".f_status >= ").append(TbStatusEnum.WAITING_VERIFY.getCode());
            }
        }

        // 分配人员
        if (StringUtils.isNotBlank(param.getAllocator())) {
            rejectJoinFilter = String.format(" inner join (select distinct r.f_dataid from TbSYS_USER u," +
                            "tbtsk_audit_assign_record r where to_number(r.f_assignto,'99999999')=u.f_userid and r" +
                            ".f_status != '2' and r.f_taskid ='%s' and (u.f_username = '%s' or u.f_rname = '%s')) AS assign ON tb.f_id = assign.f_dataid  ",
                    param.getTaskId(), param.getAllocator().trim(), param.getAllocator().trim());
        }

        // 是否分配
        if (StringUtils.isNotBlank(param.getDistributionStatus())) {
            if("1".equals(param.getDistributionStatus())){
                sbFilter.append(" and   exists (select tbtsk_audit_assign_record.f_dataid from tbtsk_audit_assign_record where tbtsk_audit_assign_record.f_dataid  = tb.f_id )");
            }else{
                sbFilter.append(" and  not exists (select tbtsk_audit_assign_record.f_dataid from tbtsk_audit_assign_record where tbtsk_audit_assign_record.f_dataid  = tb.f_id )");
            }

        }

        // 项目阶段
        if (StringUtils.isNotBlank(param.getCheckStage())) {
            FlowStep flowStep = MTbtskFlowService.findFlow(param.getTaskId(), FlowTypeEnum.AUDIT.getCode(), Integer.valueOf(param.getCheckStage()));
            if (flowStep != null) {
                ReviewStageEnum currentStage = getStageByStep(flowStep);
                // 核查状态
                if (StringUtils.isNotBlank(param.getCheckStatus())) {
//                    待审核：10、20
//                    已审核：25、30、进入复核或者下一项目阶段的图斑
//                    待复核：25、30
//                    已复核：进入下一个项目阶段的图斑
                    // 待审核
                    if ("1".equals(param.getCheckStatus())) {
                        if (!flowStep.getContainReview()) {
                            sbFilter.append(" and (").append(tableAlias).append(".f_review_stage =").append(currentStage.getCode())
                                    .append(" and (").append(tableAlias).append(".f_status =").append(TbStatusEnum.WAITING_VERIFY.getCode())
                                    .append("  or ").append(tableAlias).append(".f_status =").append(TbStatusEnum.VERIFY_NOT_PASS.getCode())
                                    .append("))");
                        } else {
                            sbFilter.append(" and (").append(tableAlias).append(".f_review_stage =").append(currentStage.getCode())
                                    .append(" and (").append(tableAlias).append(".f_status =").append(TbStatusEnum.WAITING_REVIEW.getCode())
                                    .append("  or ").append(tableAlias).append(".f_status =").append(TbStatusEnum.REVIEW_NOT_PASS.getCode())
                                    .append("))");
                        }
                    } else if ("2".equals(param.getCheckStatus())) {
                        if (!flowStep.getContainReview()) {
                            sbFilter.append(" and ").append(tableAlias).append(".f_review_stage >").append(currentStage.getCode());
                        } else {
                            sbFilter.append(" and ((").append(tableAlias).append(".f_review_stage =").append(currentStage.getCode())
                                    .append(" and (").append(tableAlias).append(".f_status =").append(TbStatusEnum.WAITING_REVIEW.getCode())
                                    .append("  or ").append(tableAlias).append(".f_status =").append(TbStatusEnum.REVIEW_NOT_PASS.getCode())
                                    .append("))").append(" or (").append(tableAlias).append(".f_review_stage >").append(currentStage.getCode())
                                    .append("))");
                        }
                    } else if ("3".equals(param.getCheckStatus())) {
                        sbFilter.append(" and (").append(tableAlias).append(".f_review_stage =").append(currentStage.getCode())
                                .append(" and (").append(tableAlias).append(".f_status =").append(TbStatusEnum.WAITING_REVIEW.getCode())
                                .append("  or ").append(tableAlias).append(".f_status =").append(TbStatusEnum.REVIEW_NOT_PASS.getCode())
                                .append("))");
                    } else if ("4".equals(param.getCheckStatus())) {
                        sbFilter.append(" and ").append(tableAlias).append(".f_review_stage >").append(currentStage.getCode());
                    }
                }
            }
        }

        // 是否打回
        if (StringUtils.isNotBlank(param.getRejectStatus())) {

            List<ReviewStageEnum> stageEnumList = getReviewStageList(param);
            if (param.getRejectStatus().equals(String.valueOf(NumberConst.ZERO))) {
                sbFilter.append(" and (").append(tableAlias).append(".f_reject_status = 0 or  ")
                        .append(tableAlias).append(".f_reject_status is null ) ");
                // 未被打回
                switch (param.getUserRole()) {
                    case 1:
                        // 管理员不做控制
                        break;
                    case 2:
                    case 4:
                        List<Integer> tempStageCodeList = stageEnumList.stream().map(stage -> stage.getCode()).collect(Collectors.toList());
                        if (!GutilCollection.isEmpty(tempStageCodeList)) {
                            sbFilter.append(" AND ");
                            sbFilter.append(" NOT EXISTS(SELECT reject.f_tbid FROM tbtsk_reject_record AS reject WHERE f_taskid = reject.f_taskid ");
                            sbFilter.append(" AND ");
                            sbFilter.append(tableAlias);
                            sbFilter.append(".f_id = reject.f_tbid AND reject.f_target_stage in ");
                            sbFilter.append("(");
                            sbFilter.append(StringUtils.join(tempStageCodeList, ","));
                            sbFilter.append(")) ");
                        }
                        break;
                    case 3:
                        sbFilter.append(" AND ");
                        sbFilter.append(" NOT EXISTS(SELECT reject.f_tbid FROM tbtsk_reject_record AS reject WHERE f_taskid = reject.f_taskid ");
                        sbFilter.append(" AND ");
                        sbFilter.append(tableAlias);
                        sbFilter.append(".f_id = reject.f_tbid AND reject.f_target_stage = ");
                        sbFilter.append(ReviewStageEnum.OPERATOR_VERIFY.getCode());
                        sbFilter.append(") ");
                        break;
                    default:
                        break;
                }
            } else if (param.getRejectStatus().equals(String.valueOf(NumberConst.ONE))) {
                sbFilter.append(" and ").append(tableAlias).append(".f_reject_status = 1 ");
                // 对于作业员，是否打回 指的是图斑是否被打回到作业员阶段
                switch (param.getUserRole()) {
                    case 1:
                        // 管理员不做控制
                        break;
                    case 2:
                    case 4:
                        List<Integer> tempStageCodeList = stageEnumList.stream().map(stage -> stage.getCode()).collect(Collectors.toList());
                        if (!GutilCollection.isEmpty(tempStageCodeList)) {
                            sbFilter.append(" and ").append(tableAlias).append(".f_review_stage in ( ").append(StringUtils.join(tempStageCodeList, ",")).append(" ) ");
                            rejectJoinFilter = String.format(" INNER JOIN (SELECT DISTINCT f_tbid FROM tbtsk_reject_record WHERE f_taskid = '%s' AND f_target_stage in (%s)) AS reject ON tb.f_id = reject.f_tbid ", param.getTaskId(), StringUtils.join(tempStageCodeList, ","));
                        }
                        break;
                    case 3:
                        sbFilter.append(" and ").append(tableAlias).append(".f_review_stage = ").append(ReviewStageEnum.OPERATOR_VERIFY.getCode());
                        rejectJoinFilter = String.format(" INNER JOIN (SELECT DISTINCT f_tbid FROM tbtsk_reject_record WHERE f_taskid = '%s' AND f_target_stage = %d) AS reject ON tb.f_id = reject.f_tbid ", param.getTaskId(), ReviewStageEnum.OPERATOR_VERIFY.getCode());
                        //rejectJoinFilter = "LEFT JOIN tbtsk_reject_record AS reject ON tb.f_id = reject.f_tbid WHERE reject.f_target_stage = " + ReviewStageEnum.OPERATOR_VERIFY.getCode();
                        break;
                    default:
                        break;
                }
            } else {
                throw new RuntimeException("rejectStatus 参数取值错误。");
            }
//            if ("0".equals(param.getRejectStatus())) {
//                sbFilter.append(" and ").append(" (").append(tableAlias).append(".f_reject_count = 0").append(" or ")
//                        .append(tableAlias).append(".f_reject_count is null").append(") ");
//            } else if ("1".equals(param.getRejectStatus())) {
//                sbFilter.append(" and ").append(tableAlias).append(".f_reject_count > 0");
//            }

        }

        if (StringUtils.isNotBlank(param.getKeyWord())) {
            tempFilter = parseSearchParam(param.getKeyWord(), param.getTaskId(),param.getTableId(), tableAlias);
            if (StringUtils.isNotBlank(tempFilter)) {
                sbFilter.append(tempFilter);
            }
        }
        //业务字段过滤
        if (StringUtils.isNotBlank(param.getCustomFilter())) {
            tempFilter = parseFilterParam(param.getCustomFilter(), param.getTaskId(),param.getTableId(), tableAlias);
            if (StringUtils.isNotBlank(tempFilter)) {
                sbFilter.append(tempFilter);
            }
        }
        //系统字段过滤
        if (StringUtils.isNotBlank(param.getCustomSysFilter())) {
            tempFilter = parseSysFilterParam(param.getCustomSysFilter(), param.getTaskId(), tableAlias);
            if (StringUtils.isNotBlank(tempFilter)) {
                sbFilter.append(tempFilter);
            }
        }

        TskTaskBiz taskBiz = findByTaskId(param.getTaskId());
        // 任务如果是公共的任务，需要区分谁创建的
        if (taskBiz.getIsPublic() != null && taskBiz.getIsPublic() == 1) {
            sbFilter.append(" and ").append(tableAlias).append(".f_userid = '" + param.getUserId() + "' ");
        }
        TbtskObjectinfo tableInfo = mTbtskObjectinfoService.getObjectbyID(org.apache.commons.lang3.StringUtils.isNotBlank(param.getTableId())?param.getTableId():taskBiz.getTableId());

        String tableName = " " + tableInfo.getfTablename() + " as " + tableAlias + " ";
        //如果是需要查询红绿灯状态的
        if(param.getNeedHld()!=null&&param.getNeedHld().equals(1)){
            tableName = "(select \n" +
                    "(select  r.f_option  from tbtsk_approve_record r\n" +
                    "where r.f_stepname ='省级审核' and r.f_taskid ='" + param.getTaskId() + "' and r.f_tbid = t.f_id\n" +
                    "order by r.f_approve_time desc limit 1) as f_option,\n" +
                    "(select  r.f_approve_time from tbtsk_approve_record r\n" +
                    "where r.f_stepname ='市级审核' and r.f_taskid ='" + param.getTaskId() + "' and r.f_tbid = t.f_id\n" +
                    "order by r.f_approve_time desc limit 1) as f_approve_time_city,\n" +
                    "t.*\n" +
                    "from "+ tableInfo.getfTablename() +" t) " + " as " + tableAlias + " ";

            //河北卫片执法页面定制参数
            if(param.getTrafficLight()!=null && param.getTrafficLight()>0){
                Long green = greenDay*24*60*60L;
                Long yellow = yellowDay*24*60*60L;
                sbFilter.append(" and ");
                String leftAnd = "((tb.f_review_stage=97 and tb.f_status>=10) or (tb.f_review_stage=101 and tb.f_status>=10 and tb.f_option=3)) and tb.f_dkbs='需反馈图斑' and (";
                List<String> fls = new ArrayList<>();
                if((1&param.getTrafficLight())>0){
                    String temp = "EXTRACT(EPOCH FROM CURRENT_TIMESTAMP-tb.f_approve_time_city)<="+ green;
                    temp="("+temp+")";
                    fls.add(temp);
                }
                if((2&param.getTrafficLight())>0){
                    String temp = "EXTRACT(EPOCH FROM CURRENT_TIMESTAMP-tb.f_approve_time_city)>"+ green
                            + " and EXTRACT(EPOCH FROM CURRENT_TIMESTAMP-tb.f_approve_time_city)<=" + yellow;
                    temp="("+temp+")";
                    fls.add(temp);
                }
                if((4&param.getTrafficLight())>0){
                    String temp = "EXTRACT(EPOCH FROM CURRENT_TIMESTAMP-tb.f_approve_time_city)>"+ yellow;
                    temp="("+temp+")";
                    fls.add(temp);
                }
                leftAnd+=String.join(" or ",fls)+")";
                sbFilter.append(leftAnd);
            }
        }
        //河北卫片执法页面定制参数
        if (param.getUserRole() != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
            String dateString = sdf.format(new Date());

            if(param.getUserRole() == 1){  //管理员
                if(param.getWpzfIsExpire()!=null && param.getWpzfIsExpire() ==1 ){ //超期未填报
                    sbFilter.append(" and ").append(tableAlias).append(".f_jzrq < '" + dateString + "'"); //当前日期 大于 截止日期
                    sbFilter.append(" and ").append(tableAlias).append(".f_status in (1,2,4)"); // 未处理为1，未提交为2
                    sbFilter.append(" and ").append(tableAlias).append(".f_review_stage < '95' ");
//                    sbFilter.append(" and   EXISTS(SELECT approve.f_tbid FROM tbtsk_task_wpzf_tem AS approve WHERE tb.f_id  = approve.f_tbid  and approve.f_taskid = '" +param.getTaskId() +"' )");
                }
                if(param.getWpzfPdlx()!=null && param.getWpzfPdlx() == 1){//省级判定合法
                    sbFilter.append(" and ((").append(tableAlias).append(".f_review_stage = '101' ");
                    sbFilter.append(" or exists ( select null from  tbtsk_approve_record AS approve WHERE approve.f_option='1' and approve.f_is_revoked is null and approve.f_stepname ='省级审核'  and approve.f_taskid = '"+param.getTaskId()+"' and approve.f_tbid = tb.f_id ))");
                    sbFilter.append(" and ").append(tableAlias).append(".f_sjhfxpd like '%合法%' )");
                }else if(param.getWpzfPdlx()!=null &&param.getWpzfPdlx() == 2){//省级判定违法
                    sbFilter.append(" and ((").append(tableAlias).append(".f_review_stage = '101' ");
                    sbFilter.append(" or exists ( select null from  tbtsk_approve_record AS approve WHERE approve.f_option='1' and approve.f_is_revoked is null and approve.f_stepname ='省级审核'  and approve.f_taskid = '"+param.getTaskId()+"' and approve.f_tbid = tb.f_id ))");
                  /*  sbFilter.append(" and COALESCE(tb.f_hftdy_n2, 0) + COALESCE(tb.f_bbmjm_n1, 0) <= COALESCE(tb.f_dkmj, 0) ");*/
                    sbFilter.append(" and ").append(tableAlias).append(".f_sjhfxpd like '%违法%') ");
                }else if(param.getWpzfPdlx()!=null && param.getWpzfPdlx() == 3){//省级判定其他
                    sbFilter.append(" and ((").append(tableAlias).append(".f_review_stage = '101' ");
                    sbFilter.append(" or exists ( select null from  tbtsk_approve_record AS approve WHERE approve.f_option='1' and approve.f_is_revoked is null and approve.f_stepname ='省级审核'  and approve.f_taskid = '"+param.getTaskId()+"' and approve.f_tbid = tb.f_id ))");
                    sbFilter.append(" and ").append(tableAlias).append(".f_sjhfxpd like '%其他%' )");
                }
            }else if( param.getUserRole() == 2){//审核员
                 if(param.getWpzfShPage()!=null && param.getWpzfShPage() ==1 ){ //整改清单
                     if(param.getWpzfRejectStatus()!=null && param.getWpzfRejectStatus() ==1 ){ //退回
                         sbFilter.append(" and (").append(tableAlias).append(".f_reject_status = '1' ");
                         sbFilter.append(" and ").append(tableAlias).append(".f_sjhfxpd like '%违法%' ) ");
                        /* sbFilter.append(" and COALESCE(tb.f_hftdy_n2, 0) + COALESCE(tb.f_bbmjm_n1, 0) <= COALESCE(tb.f_dkmj, 0) ");*/
//                         sbFilter.append(" and   EXISTS(SELECT approve.f_tbid FROM tbtsk_approve_record AS approve WHERE tb.f_id  = approve.f_tbid and approve.f_option='1' and approve.f_is_revoked is null and approve.f_stepname ='省级审核' and approve.f_taskid = '" +param.getTaskId() +"' ))");
                     }else {
                         if(param.getState() != null && param.getState() == 1){
                             sbFilter.append(" and (").append(tableAlias).append(".f_sjhfxpd like '%违法%' )");
                            /* sbFilter.append(" and COALESCE(tb.f_hftdy_n2, 0) + COALESCE(tb.f_bbmjm_n1, 0) <= COALESCE(tb.f_dkmj, 0) ");*/
//                             sbFilter.append(" and   EXISTS(SELECT approve.f_tbid FROM (select tar.f_taskid ,tar.f_tbid from tbtsk_approve_record tar where tar.f_option='1' and tar.f_is_revoked is null and tar.f_stepname ='省级审核' group by tar.f_taskid ,tar.f_tbid  having count(1) > 1) as approve  where approve.f_tbid  =tb.f_id and  approve.f_taskid = '" +param.getTaskId() +"' ))");
                         }else{
                             sbFilter.append(" and (").append(tableAlias).append(".f_sjhfxpd like '%违法%' ) ");
                            /* sbFilter.append(" and COALESCE(tb.f_hftdy_n2, 0) + COALESCE(tb.f_bbmjm_n1, 0) <= COALESCE(tb.f_dkmj, 0) ");*/
//                             sbFilter.append(" and   EXISTS(SELECT approve.f_tbid FROM tbtsk_approve_record AS approve " +
//                                     "WHERE tb.f_id  = approve.f_tbid and approve.f_option='1' and approve.f_is_revoked is null and approve.f_stepname ='省级审核' and approve.f_taskid = '" +param.getTaskId() +"' ))");
                         }
                     }
                 }else{
                     if(param.getState() != null && param.getState() == 0){
                         sbFilter.append(" and  not EXISTS(SELECT approve.f_tbid FROM tbtsk_approve_record AS approve WHERE tb.f_id  = approve.f_tbid and approve.f_option='1' and approve.f_is_revoked is null and approve.f_stepname ='省级审核' and approve.f_taskid = '" +param.getTaskId() +"' )");
                     }
                   if(param.getWpzfIsExpire()!=null && param.getWpzfIsExpire() == 1){ //超期未填报
                       sbFilter.append(" and ").append(tableAlias).append(".f_jzrq < '" + dateString + "'"); //当前日期 大于 截止日期
                       sbFilter.append(" and ").append(tableAlias).append(".f_status in (1,2,4)"); // 未处理为1，未提交为2
                       sbFilter.append(" and ").append(tableAlias).append(".f_review_stage < '95' ");
//                       sbFilter.append(" and   EXISTS(SELECT approve.f_tbid FROM tbtsk_task_wpzf_tem AS approve WHERE tb.f_id  = approve.f_tbid  and approve.f_taskid = '" +param.getTaskId() +"' )");
                   }
                 if(param.getWpzfRejectStatus()!=null && param.getWpzfRejectStatus() == 1){ //退回
                     sbFilter.append(" and (").append(tableAlias).append(".f_reject_status = '1' ");
                     sbFilter.append(" and ").append(tableAlias).append(".f_review_stage < '101'");
                     sbFilter.append(" and ").append(tableAlias).append(".f_sjhfxpd not like '%违法%' )");
                 }
                 }
            }else if( param.getUserRole() == 3){//作业员
                if(param.getWpzfIsSubmit()!=null && param.getWpzfIsSubmit() == 1){ //未填报
                    sbFilter.append(" and (").append(tableAlias).append(".f_status is not null ");
                    sbFilter.append(" and ").append(tableAlias).append(".f_status < '10') ");
                }
                if(param.getWpzfRejectStatus()!=null && param.getWpzfRejectStatus() == 1){ //退回
                    sbFilter.append(" and (").append(tableAlias).append(".f_reject_status = '1' ");
                    sbFilter.append(" and ").append(tableAlias).append(".f_status < '10' )");
                }
                if(param.getWpzfIsExpire()!=null && param.getWpzfIsExpire() == 1){ //超期未填报
                    sbFilter.append(" and ").append(tableAlias).append(".f_jzrq < '" + dateString + "'");
                    sbFilter.append(" and ").append(tableAlias).append(".f_status < '10' ");
//                    sbFilter.append(" and   EXISTS(SELECT approve.f_tbid FROM tbtsk_task_wpzf_tem AS approve WHERE tb.f_id  = approve.f_tbid  and approve.f_taskid = '" +param.getTaskId() +"' )");
                }
                if(param.getWpzfPdlx()!=null && param.getWpzfPdlx() == 1){//省级判定合法
                    sbFilter.append(" and ((").append(tableAlias).append(".f_review_stage = '101' ");
                    sbFilter.append(" or exists ( select null from  tbtsk_approve_record AS approve WHERE approve.f_option='1' and approve.f_is_revoked is null and approve.f_stepname ='省级审核'  and approve.f_taskid = '"+param.getTaskId()+"' and approve.f_tbid = tb.f_id ))");
                    sbFilter.append(" and ").append(tableAlias).append(".f_sjhfxpd like '%合法%' )");
                }else if(param.getWpzfPdlx()!=null && param.getWpzfPdlx() == 2){//省级判定违法
                    sbFilter.append(" and ((").append(tableAlias).append(".f_review_stage = '101' ");
                    sbFilter.append(" or exists ( select null from  tbtsk_approve_record AS approve WHERE approve.f_option='1' and approve.f_is_revoked is null and approve.f_stepname ='省级审核'  and approve.f_taskid = '"+param.getTaskId()+"' and approve.f_tbid = tb.f_id ))");
                    /*  sbFilter.append(" and COALESCE(tb.f_hftdy_n2, 0) + COALESCE(tb.f_bbmjm_n1, 0) <= COALESCE(tb.f_dkmj, 0) ");*/
                    sbFilter.append(" and ").append(tableAlias).append(".f_sjhfxpd like '%违法%') ");
                }else if(param.getWpzfPdlx()!=null && param.getWpzfPdlx() == 3){//省级判定其他
                    sbFilter.append(" and ((").append(tableAlias).append(".f_review_stage = '101' ");
                    sbFilter.append(" or exists ( select null from  tbtsk_approve_record AS approve WHERE approve.f_option='1' and approve.f_is_revoked is null and approve.f_stepname ='省级审核'  and approve.f_taskid = '"+param.getTaskId()+"' and approve.f_tbid = tb.f_id ))");
                    sbFilter.append(" and ").append(tableAlias).append(".f_sjhfxpd like '%其他%' )");
                }
            }
        }

        String rightJoinStr = "";
        if (param.getUserRole() != null) {
            switch (param.getUserRole()) {
                case 0:
                case 1: {
                    //如果用户的身份是创建者、管理员，那么需要查找其管理区里面的数据,
                    // TODO 目前是查询的其所属政区，需改成其管理的政区
                   /* String userRegionCode = userAreaService.getUserRegionCode(param.getUserId());
                    if (!StringUtils.isNotBlank(userRegionCode)) {
                        throw new RuntimeException("用户所属政区获取失败，请联系管理员。");
                    } else {
                        tempFilter = parseRegionCodeParam(userRegionCode, tableAlias, param);
                        if (StringUtils.isNotBlank(tempFilter)) {
                            sbFilter.append(tempFilter);
                        }
                    }*/

                    // 查找其管理区里面的数据 暂时注释，
                    List<TbtskUserManageArea> userManageAreas = tbtskUserManageAreaService.listManageAreas(param.getTaskId()
                            , param.getUserId().toString());
                    if (GutilCollection.isEmpty(userManageAreas)) {
                        throw new GwValidateException("用户未分配管理区，请联系管理员。");
                    } else {
                        List<String> userManageAreaList = new ArrayList<>();
                        for (TbtskUserManageArea area : userManageAreas) {
                            if (StringUtils.isNotBlank(area.getRegioncode())) {
                                userManageAreaList.add(area.getRegioncode());
                            }
                        }
                        tempFilter = parseRegionCodeListParam(userManageAreaList, tableAlias, param,fields);
                        if (StringUtils.isNotBlank(tempFilter)) {
                            sbFilter.append(tempFilter);
                        }
                    }
                }
                break;
                case 2: {
                    //判断该任务是否配置超级审核员
                    List<UserBiz2> byBizIdAndRole = userBiz2Repository.findByBizIdAndRole(param.getTaskId(), 5);
                    if(byBizIdAndRole.size() > 0){
                        //获取待审核数据
                        if (param.getState() != null && param.getState() == 0) {
                            sbFilter.append("  and exists (select tbtsk_audit_assign_record.f_dataid from tbtsk_audit_assign_record where tbtsk_audit_assign_record.f_dataid  = tb.f_id and " +
                                    "tbtsk_audit_assign_record.f_status='0' and tbtsk_audit_assign_record.f_assignto ='"+param.getUserId()+"')");
                        }else if(param.getState() != null && param.getState() == 1){ //获取已审核数据
                            sbFilter.append("  and exists (select tbtsk_audit_assign_record.f_dataid from tbtsk_audit_assign_record where tbtsk_audit_assign_record.f_dataid  = tb.f_id and " +
                                    "tbtsk_audit_assign_record.f_status='3' and tbtsk_audit_assign_record.f_assignto ='"+param.getUserId()+"')");
                        }else{
                            sbFilter.append("  and exists (select tbtsk_audit_assign_record.f_dataid from tbtsk_audit_assign_record where tbtsk_audit_assign_record.f_dataid  = tb.f_id and " +
                                    "tbtsk_audit_assign_record.f_status in('0','3') and tbtsk_audit_assign_record.f_assignto ='"+param.getUserId()+"')");
                        }
                    }else{
                        // 查找其审核区里面的数据
                        List<TbtskUserAuditArea> userAuditAreas = tbtskUserAuditAreaService.listAuditAreas(param.getTaskId()
                                , param.getUserId().toString());
                        if (GutilCollection.isEmpty(userAuditAreas)) {
                            throw new GwValidateException("用户未分配审核区，请联系管理员。");
                        } else {
                            List<String> userAuditAreaList = new ArrayList<>();
                            for (TbtskUserAuditArea area : userAuditAreas) {
                                if (StringUtils.isNotBlank(area.getRegionCode())) {
                                    userAuditAreaList.add(area.getRegionCode());
                                }
                            }
                            tempFilter = parseRegionCodeListParam(userAuditAreaList, tableAlias, param,fields);
                            if (StringUtils.isNotBlank(tempFilter)) {
                                sbFilter.append(tempFilter);
                            }
                        }
                    }
                }
                break;
                case 5: {
                    // 查找其超级审核区里面的数据
                    List<TbtskSuperUserAuditArea> userAuditAreas = tbtskSuperUserAuditAreaService.listAuditAreas(param.getTaskId() , param.getUserId().toString());
                    if (GutilCollection.isEmpty(userAuditAreas)) {
                        throw new GwValidateException("用户未分配审核区，请联系管理员。");
                    } else {
                        List<String> userAuditAreaList = new ArrayList<>();
                        for (TbtskSuperUserAuditArea area : userAuditAreas) {
                            if (StringUtils.isNotBlank(area.getRegionCode())) {
                                userAuditAreaList.add(area.getRegionCode());
                            }
                        }
                        tempFilter = parseRegionCodeListParam(userAuditAreaList, tableAlias, param,fields);
                        if (StringUtils.isNotBlank(tempFilter)) {
                            sbFilter.append(tempFilter);
                        }
                    }
                }
                break;
                case 4: {
                    // 查找其复核区里面的数据
                    List<TbtskUserReviewArea> userReviewAreas = tbtskUserReviewAreaService.listReviewAreas(param.getTaskId()
                            , param.getUserId().toString());
                    if (GutilCollection.isEmpty(userReviewAreas)) {
                        throw new GwValidateException("用户未分配复核区，请联系管理员。");
                    } else {
                        List<String> userReviewAreaList = new ArrayList<>();
                        for (TbtskUserReviewArea area : userReviewAreas) {
                            if (StringUtils.isNotBlank(area.getRegionCode())) {
                                userReviewAreaList.add(area.getRegionCode());
                            }
                        }
                        tempFilter = parseRegionCodeListParam(userReviewAreaList, tableAlias, param,fields);
                        if (StringUtils.isNotBlank(tempFilter)) {
                            sbFilter.append(tempFilter);
                        }
                    }
                }
                break;
                case 3: {
                    // 如果是作业员，1、下发类型的任务，则查询下发给作业员的数据；2、领取类型的任务，则查找作业员的作业区下的数据
                    if (taskBiz.getMode().intValue() == 1) {
                        //查找作业员的作业区
                        List<String> userWorkAreas = tskRightAreaRepository.findXzqdmByTaskIdAndUserId(param.getTaskId(), param .getUserId().toString());
                        tempFilter = parseRegionCodeListParam(userWorkAreas, tableAlias, param,fields);
                        if (StringUtils.isNotBlank(tempFilter)) {
                            sbFilter.append(tempFilter);
                        }
                        rightJoinStr = " INNER JOIN (SELECT DISTINCT f_dataid FROM tbtsk_assign_record where f_taskid='" + taskBiz.getId()
                                + "' and f_status != '2' and f_assignto = '" + param.getUserId() + "') " +
                                " AS re ON tb.f_id = re.f_dataid ";
                    } else if (taskBiz.getMode().intValue() == 2) {
                        List<String> userWorkAreas = tskRightAreaRepository.findXzqdmByTaskIdAndUserId(param.getTaskId(), param.getUserId().toString());
                        tempFilter = parseRegionCodeListParam(userWorkAreas, tableAlias, param,fields);
                        if (StringUtils.isNotBlank(tempFilter)) {
                            sbFilter.append(tempFilter);
                        }
                        // 仅我领取的图斑
                        if (StringUtils.isNotBlank(param.getOnlyMySpot())) {
                            if ("1".equals(param.getOnlyMySpot())) {
                                rightJoinStr = " INNER JOIN (SELECT DISTINCT f_dataid FROM tbtsk_assign_record where f_taskid='" + taskBiz.getId()
                                        + "' and f_status != '2' and f_assignto = '" + param.getUserId() + "') " +
                                        " AS re ON tb.f_id = re.f_dataid";
                            }
                        }
                    }
                }
                break;
                default:
                    throw new GwValidateException("用户角色错误。");
            }
        }
//        String orderByStr = " order by " + param.getSortParam();
//        String where = sbFilter.toString() + orderByStr;

        String syncStatusFilter = "";
        if(param.getSyncStatusMask() != null && param.getSyncStatusMask() != 0){
            syncStatusFilter = "LEFT JOIN tb_sync_status stat on (tb.f_id = stat.f_tbid and stat.f_object_type = 2 and stat.f_objectid = '" + taskBiz.getId() + "')";
            Integer status = param.getSyncStatusMask();
            if(status > 0){
                sbFilter.append(" AND (stat.f_status is not null AND (stat.f_status & ")
                        .append(status)
                        .append( " )= ")
                        .append(status)
                        .append(")");
            }else if(status < 0){
                sbFilter.append(" AND (stat.f_status is null or (stat.f_status & ")
                        .append( - status)
                        .append( " )= 0)");
            }
        }
        return Pair.of(tableName + syncStatusFilter + rightJoinStr + rejectJoinFilter, sbFilter.toString());
    }


    private ReviewStageEnum getStageByStep(FlowStep step) {
        String[] stagesArray = null;
        if (StringUtils.isNotBlank(step.getPre_stages())) {
            stagesArray = step.getPre_stages().split(",");
        }
        if (stagesArray != null) {
            if (stagesArray.length == 2) {
                return ReviewStageEnum.getEnum(Integer.parseInt(stagesArray[1]));
            } else if (stagesArray.length == 1) {
                return ReviewStageEnum.getEnum(Integer.parseInt(stagesArray[0]));
            }
        }
        return null;
    }

    private List<ReviewStageEnum> getReviewStageList(TaskQueryParameter param) {
        List<ReviewStageEnum> stageEnumList = new ArrayList<>();
        if (param.getUserRole().equals(UserRoleEnum.OPERATOR)) {
            stageEnumList.add(ReviewStageEnum.OPERATOR_VERIFY);
        } else if (param.getUserRole().equals(UserRoleEnum.AUDITOR.getCode()) || param.getUserRole().equals(UserRoleEnum.REVIEWER.getCode())) {
            TskTaskBiz tskTaskBiz = tskTaskBizRepository.findById(param.getTaskId()).orElse(null);
            if (tskTaskBiz.getIsApprove().equals(NumberConst.ONE)) {
                if (param.getUserRole().equals(UserRoleEnum.AUDITOR.getCode())) {
                    List<TbtskUserAuditArea> userAuditAreas = tbtskUserAuditAreaService.listAuditAreas(param.getTaskId(), String.valueOf(param.getUserId()));
                    if (!GutilCollection.isEmpty(userAuditAreas)) {
                        for (TbtskUserAuditArea auditArea : userAuditAreas) {
                            switch (auditArea.getLevel()) {
                                case 0:
                                    stageEnumList.add(ReviewStageEnum.COUNTRY_VERIFY);
                                    break;
                                case 1:
                                    stageEnumList.add(ReviewStageEnum.PROVINCE_VERIFY);
                                    break;
                                case 2:
                                    stageEnumList.add(ReviewStageEnum.CITY_VERIFY);
                                    break;
                                case 3:
                                    stageEnumList.add(ReviewStageEnum.COUNTY_VERIFY);
                                    break;
                                case 4:
                                    stageEnumList.add(ReviewStageEnum.TOWN_VERIFY);
                                    break;
                                case 5:
                                    stageEnumList.add(ReviewStageEnum.VILLAGE_VERIFY);
                                    break;
                                default:
                                    break;
                            }
                        }
                    }
                } else {
                    List<TbtskUserReviewArea> userReviewAreas = tbtskUserReviewAreaService.listReviewAreas(param.getTaskId(), String.valueOf(param.getUserId()));
                    if (!GutilCollection.isEmpty(userReviewAreas)) {
                        for (TbtskUserReviewArea reviewArea : userReviewAreas) {
                            switch (reviewArea.getLevel()) {
                                case 0:
                                    stageEnumList.add(ReviewStageEnum.COUNTRY_VERIFY);
                                    break;
                                case 1:
                                    stageEnumList.add(ReviewStageEnum.PROVINCE_VERIFY);
                                    break;
                                case 2:
                                    stageEnumList.add(ReviewStageEnum.CITY_VERIFY);
                                    break;
                                case 3:
                                    stageEnumList.add(ReviewStageEnum.COUNTY_VERIFY);
                                    break;
                                case 4:
                                    stageEnumList.add(ReviewStageEnum.TOWN_VERIFY);
                                    break;
                                case 5:
                                    stageEnumList.add(ReviewStageEnum.VILLAGE_VERIFY);
                                    break;
                                default:
                                    break;
                            }
                        }
                    }
                }
            }
        }
        return stageEnumList;
    }

    public Pair<String, String> parseQueryParameterBySc(TaskQueryParameter param) throws Exception {
        String tempFilter = "";
        StringBuilder sbFilter = new StringBuilder(" 1=1 ");
        String tableAlias = "tb";

//        if (StringUtils.isNotBlank(param.getRegionCode())) {
//            tempFilter = parseRegionCodeParam(param.getRegionCode(), tableAlias);
//            if (StringUtils.isNotBlank(tempFilter)) {
//                sbFilter.append(tempFilter);
//            }
//        }

        // 领取状态/下发状态
        if (StringUtils.isNotBlank(param.getDeliveryStatus())) {
            sbFilter.append(" and ");
            sbFilter.append(tableAlias);
            if ("1".equals(param.getDeliveryStatus())) {
                sbFilter.append(".f_status = 1 ");
            } else {
                sbFilter.append(".f_status > 1 ");
            }
        }

        //审核区
        if (StringUtils.isNotBlank(param.getRegionCode())) {
            sbFilter.append(" and ( ");
            //审核区
            List<String> auditAreas = Arrays.asList(param.getRegionCode().split(","));
            for (int i = 0; i < auditAreas.size(); i++) {
                String temp = auditAreas.get(i);
                if (temp.endsWith("0000")) {
                    sbFilter.append(tableAlias);
                    sbFilter.append(".f_xzqdmsys like '" + temp.substring(0, 2) + "%' ");
                } else if (temp.endsWith("00")) {
                    sbFilter.append(tableAlias);
                    sbFilter.append(".f_xzqdmsys like '" + temp.substring(0, 4) + "%' ");
                } else {
                    sbFilter.append(tableAlias);
                    sbFilter.append(".f_xzqdmsys like '" + temp + "%' ");
                }
                if (i < auditAreas.size() - 1) {
                    sbFilter.append(" or ");
                }
            }
            sbFilter.append("  ) ");
        }

        // 提交状态
        if (StringUtils.isNotBlank(param.getSubmitStatus())) {
            sbFilter.append(" and ");
            sbFilter.append(tableAlias);
            if ("2".equals(param.getSubmitStatus())) {
                sbFilter.append(".f_status >= 4 ");
                // 提交时间
                //结束时间为当天最后一秒
                if (param.getSubmitTimeEnd() != null) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(new Date(param.getSubmitTimeEnd()));
                    calendar.set(Calendar.HOUR, 23);
                    calendar.set(Calendar.MINUTE, 59);
                    calendar.set(Calendar.SECOND, 59);
                    Date date = calendar.getTime();
                    param.setSubmitTimeEnd(date.getTime());
                }
                if (param.getSubmitTimeStart() != null && param.getSubmitTimeEnd() != null) {
                    sbFilter.append(" and ");
                    sbFilter.append(" (").append(tableAlias).append(".f_submittime >=").append(param.getSubmitTimeStart())
                            .append(" and ").append(tableAlias).append(".f_submittime <=").append(param.getSubmitTimeEnd())
                            .append(") ");
                } else if (param.getSubmitTimeStart() != null && param.getSubmitTimeEnd() == null) {
                    sbFilter.append(" and ");
                    sbFilter.append(tableAlias).append(".f_submittime >=").append(param.getSubmitTimeStart());
                } else if (param.getSubmitTimeStart() == null && param.getSubmitTimeEnd() != null) {
                    sbFilter.append(" and ");
                    sbFilter.append(tableAlias).append(".f_submittime <=").append(param.getSubmitTimeEnd());
                }
            } else {
                sbFilter.append(".f_status < 4 ");
            }
        }

        // 图斑来源
        if (StringUtils.isNotBlank(param.getDataSource())) {
            sbFilter.append(" and ");
            if ("1".equals(param.getDataSource())) {
                sbFilter.append(tableAlias).append(".f_ismycreate = 1 ");
            } else {
                sbFilter.append(" (").append(tableAlias).append(".f_ismycreate = 0 ")
                        .append(" or ").append(tableAlias).append(".f_ismycreate is null ").append(") ");
            }
        }

        // 作业人员
        if (StringUtils.isNotBlank(param.getOperator())) {
            sbFilter.append(" and ");
            sbFilter.append(tableAlias);
            sbFilter.append(".f_upload_userid like '%" + param.getOperator().trim() + "%'");
        }

        // 是否提报
        if (StringUtils.isNotBlank(param.getReportStatus())) {
            sbFilter.append(" and ");
            sbFilter.append(tableAlias);
            if ("0".equals(param.getReportStatus())) {
                sbFilter.append(".f_status < ").append(TbStatusEnum.WAITING_VERIFY.getCode());
            } else if ("1".equals(param.getReportStatus())) {
                sbFilter.append(".f_status >= ").append(TbStatusEnum.WAITING_VERIFY.getCode());

                // 提报时间 TODO:筛选提报时间 提报记录表？考虑数据表中增加提报时间字段
//                if (param.getReportTimeStart() != null && param.getReportTimeEnd() != null) {
//                    sbFilter.append(" and ").append(" (").append(tableAlias).append(".f_submittime >=")
//                            .append(param.getReportTimeStart()).append(" and ").append(tableAlias)
//                            .append(".f_submittime <=").append(param.getReportTimeEnd()).append(") ");
//                } else if (param.getReportTimeStart() != null && param.getReportTimeEnd() == null) {
//                    sbFilter.append(" and ").append(tableAlias).append(".f_submittime >=").append(param.getReportTimeStart());
//                } else if (param.getReportTimeStart() == null && param.getReportTimeEnd() != null) {
//                    sbFilter.append(" and ").append(tableAlias).append(".f_submittime <=").append(param.getReportTimeEnd());
//                }
            }
        }

        //四川图斑审核状态
        if (StringUtils.isNotBlank(param.getAuditStatus())) {
            if ("1".equals(param.getAuditStatus())) {
                //退回至公众
                sbFilter.append(" and ").append(tableAlias).append(".f_review_stage = ").append(ReviewStageEnum.OPERATOR_VERIFY.getCode());
                sbFilter.append(" and ").append(tableAlias).append(".f_status = ").append(TbStatusEnum.WAITING_VERIFY.getCode());
            } else if ("2".equals(param.getAuditStatus())) {
                //待区县审核
                sbFilter.append(" and ").append(tableAlias).append(".f_review_stage = ").append(ReviewStageEnum.COUNTY_VERIFY.getCode());
                sbFilter.append(" and ").append(tableAlias).append(".f_status = ").append(TbStatusEnum.WAITING_VERIFY.getCode());
            } else if ("3".equals(param.getAuditStatus())) {
                //待市级审核
                sbFilter.append(" and ").append(tableAlias).append(".f_review_stage = ").append(ReviewStageEnum.CITY_VERIFY.getCode());
                sbFilter.append(" and ").append(tableAlias).append(".f_status = ").append(TbStatusEnum.WAITING_REVIEW.getCode());
            } else if ("4".equals(param.getAuditStatus())) {
                //外业核查
                sbFilter.append(" and ").append(tableAlias).append(".f_review_stage <= ").append(ReviewStageEnum.COUNTY_VERIFY.getCode());
                sbFilter.append(" and ").append(tableAlias).append(".f_status = ").append(TbStatusEnum.DISTRIBUTED.getCode());
            } else if ("5".equals(param.getAuditStatus())) {
                //已办结
                sbFilter.append(" and ").append(tableAlias).append(".f_review_stage = ").append(ReviewStageEnum.OVER_VERIFY.getCode());
            }
        }

        // 核查阶段
        if (StringUtils.isNotBlank(param.getCheckStage())) {
            if ("1".equals(param.getCheckStage())) {
                // 村级核查
                sbFilter.append(" and ").append(tableAlias).append(".f_review_stage = ").append(ReviewStageEnum.VILLAGE_VERIFY.getCode());
            } else if ("2".equals(param.getCheckStage())) {
                // 乡镇核查
                sbFilter.append(" and ").append(tableAlias).append(".f_review_stage = ").append(ReviewStageEnum.TOWN_VERIFY.getCode());
            } else if ("3".equals(param.getCheckStage())) {
                // 区县核查
                sbFilter.append(" and ").append(tableAlias).append(".f_review_stage = ").append(ReviewStageEnum.COUNTY_VERIFY.getCode());
            } else if ("4".equals(param.getCheckStage())) {
                // 市级核查
                sbFilter.append(" and ").append(tableAlias).append(".f_review_stage = ").append(ReviewStageEnum.CITY_VERIFY.getCode());
            } else if ("5".equals(param.getCheckStage())) {
                // 省级核查
                sbFilter.append(" and ").append(tableAlias).append(".f_review_stage = ").append(ReviewStageEnum.PROVINCE_VERIFY.getCode());
            } else if ("6".equals(param.getCheckStage())) {
                // 国家核查
                sbFilter.append(" and ").append(tableAlias).append(".f_review_stage = ").append(ReviewStageEnum.COUNTRY_VERIFY.getCode());
            }
        }

        // 核查状态
        if (StringUtils.isNotBlank(param.getCheckStatus())) {
            if ("1".equals(param.getCheckStatus())) {
                // 未审核
                sbFilter.append(" and ").append(tableAlias).append(".f_status = ").append(TbStatusEnum.WAITING_VERIFY.getCode());
            } else if ("2".equals(param.getCheckStatus())) {
                // 已审核
                sbFilter.append(" and ").append(tableAlias).append(".f_status = ").append(TbStatusEnum.VERIFY_NOT_PASS.getCode());
            } else if ("3".equals(param.getCheckStatus())) {
                // 未复核
                sbFilter.append(" and ").append(tableAlias).append(".f_status = ").append(TbStatusEnum.WAITING_REVIEW.getCode());
            } else if ("4".equals(param.getCheckStatus())) {
                // 已复核
                sbFilter.append(" and ").append(tableAlias).append(".f_status = ").append(TbStatusEnum.VERIFY_NOT_PASS.getCode());
            }
        }

        String rejectJoinFilter = "";
        // 是否打回
        if (StringUtils.isNotBlank(param.getRejectStatus())) {

            List<ReviewStageEnum> stageEnumList = getReviewStageList(param);
            if (param.getRejectStatus().equals(String.valueOf(NumberConst.ZERO))) {
                // 未被打回
                switch (param.getUserRole()) {
                    case 2:
                    case 4:
                        List<Integer> tempStageCodeList = stageEnumList.stream().map(stage -> stage.getCode()).collect(Collectors.toList());
                        if (!GutilCollection.isEmpty(tempStageCodeList)) {
                            sbFilter.append(" AND ");
                            sbFilter.append(" NOT EXISTS(SELECT reject.f_tbid FROM tbtsk_reject_record AS reject WHERE f_taskid = reject.f_taskid ");
                            sbFilter.append(" AND ");
                            sbFilter.append(tableAlias);
                            sbFilter.append(".f_id = reject.f_tbid AND reject.f_target_stage in ");
                            sbFilter.append("(");
                            sbFilter.append(StringUtils.join(tempStageCodeList, ","));
                            sbFilter.append(")) ");
                        }
                        break;
                    case 3:
                        sbFilter.append(" AND ");
                        sbFilter.append(" NOT EXISTS(SELECT reject.f_tbid FROM tbtsk_reject_record AS reject WHERE f_taskid = reject.f_taskid ");
                        sbFilter.append(" AND ");
                        sbFilter.append(tableAlias);
                        sbFilter.append(".f_id = reject.f_tbid AND reject.f_target_stage = ");
                        sbFilter.append(ReviewStageEnum.OPERATOR_VERIFY.getCode());
                        sbFilter.append(") ");
                        break;
                    default:
                        break;
                }
            } else if (param.getRejectStatus().equals(String.valueOf(NumberConst.ONE))) {
                // 对于作业员，是否打回 指的是图斑是否被打回到作业员阶段
                switch (param.getUserRole()) {
                    case 2:
                    case 4:
                        List<Integer> tempStageCodeList = stageEnumList.stream().map(stage -> stage.getCode()).collect(Collectors.toList());
                        if (!GutilCollection.isEmpty(tempStageCodeList)) {
                            rejectJoinFilter = String.format(" RIGHT JOIN (SELECT DISTINCT f_tbid FROM tbtsk_reject_record WHERE f_taskid = '%s' AND f_target_stage in (%s)) AS reject ON tb.f_id = reject.f_tbid ", param.getTaskId(), StringUtils.join(tempStageCodeList, ","));
                        }
                        break;
                    case 3:
                        rejectJoinFilter = String.format(" RIGHT JOIN (SELECT DISTINCT f_tbid FROM tbtsk_reject_record WHERE f_taskid = '%s' AND f_target_stage = %d) AS reject ON tb.f_id = reject.f_tbid ", param.getTaskId(), ReviewStageEnum.OPERATOR_VERIFY.getCode());
                        //rejectJoinFilter = "LEFT JOIN tbtsk_reject_record AS reject ON tb.f_id = reject.f_tbid WHERE reject.f_target_stage = " + ReviewStageEnum.OPERATOR_VERIFY.getCode();
                        break;
                    default:
                        break;
                }
            } else {
                throw new RuntimeException("rejectStatus 参数取值错误。");
            }
//            if ("0".equals(param.getRejectStatus())) {
//                sbFilter.append(" and ").append(" (").append(tableAlias).append(".f_reject_count = 0").append(" or ")
//                        .append(tableAlias).append(".f_reject_count is null").append(") ");
//            } else if ("1".equals(param.getRejectStatus())) {
//                sbFilter.append(" and ").append(tableAlias).append(".f_reject_count > 0");
//            }

        }

        if (StringUtils.isNotBlank(param.getKeyWord())) {
            tempFilter = parseSearchParam(param.getKeyWord(), param.getTaskId(),param.getTableId(), tableAlias);
            if (StringUtils.isNotBlank(tempFilter)) {
                sbFilter.append(tempFilter);
            }
        }

        if (StringUtils.isNotBlank(param.getCustomFilter())) {
            tempFilter = parseFilterParam(param.getCustomFilter(), param.getTaskId(), param.getTableId(),tableAlias);
            if (StringUtils.isNotBlank(tempFilter)) {
                sbFilter.append(tempFilter);
            }
        }

        TskTaskBiz taskBiz = findByTaskId(param.getTaskId());
        // 任务如果是公共的任务，需要区分谁创建的
        if (taskBiz.getIsPublic() == 1) {
            sbFilter.append(" and ").append(tableAlias).append(".f_userid = '" + param.getUserId() + "' ");
        }
        TbtskObjectinfo tableInfo = mTbtskObjectinfoService.getObjectbyID(taskBiz.getTableId());

        String tableName = " " + tableInfo.getfTablename() + " as " + tableAlias + " ";
        //如果是需要查询红绿灯状态的
        if(param.getNeedHld()!=null&&param.getNeedHld().equals(1)){
            tableName = "(select \n" +
                    "(select  r.f_option  from tbtsk_approve_record r\n" +
                    "where r.f_stepname ='省级审核' and r.f_taskid ='" + param.getTaskId() + "' and r.f_tbid = t.f_id\n" +
                    "order by r.f_approve_time desc limit 1) as f_option,\n" +
                    "(select  r.f_approve_time from tbtsk_approve_record r\n" +
                    "where r.f_stepname ='市级审核' and r.f_taskid ='" + param.getTaskId() + "' and r.f_tbid = t.f_id\n" +
                    "order by r.f_approve_time desc limit 1) as f_approve_time_city,\n" +
                    "t.*\n" +
                    "from "+ tableInfo.getfTablename() +" t) " + " as " + tableAlias + " ";

            //河北卫片执法页面定制参数
            if(param.getTrafficLight()!=null && param.getTrafficLight()>0){
                Long green = greenDay*24*60*60L;
                Long yellow = yellowDay*24*60*60L;
                sbFilter.append(" and ");
                String leftAnd = "((tb.f_review_stage=97 and tb.f_status>=10) or (tb.f_review_stage=101 and tb.f_status>=10 and tb.f_option=3)) and tb.f_dkbs='需反馈图斑' and (";
                List<String> fls = new ArrayList<>();
                if((1&param.getTrafficLight())>0){
                    String temp = "EXTRACT(EPOCH FROM CURRENT_TIMESTAMP-tb.f_approve_time_city)<="+ green;
                    temp="("+temp+")";
                    fls.add(temp);
                }
                if((2&param.getTrafficLight())>0){
                    String temp = "EXTRACT(EPOCH FROM CURRENT_TIMESTAMP-tb.f_approve_time_city)>"+ green
                            + " and EXTRACT(EPOCH FROM CURRENT_TIMESTAMP-tb.f_approve_time_city)<=" + yellow;
                    temp="("+temp+")";
                    fls.add(temp);
                }
                if((4&param.getTrafficLight())>0){
                    String temp = "EXTRACT(EPOCH FROM CURRENT_TIMESTAMP-tb.f_approve_time_city)>"+ yellow;
                    temp="("+temp+")";
                    fls.add(temp);
                }
                leftAnd+=String.join(" or ",fls)+")";
                sbFilter.append(leftAnd);
            }
        }

        String rightJoinStr = "";
        switch (param.getUserRole()) {
            case 0:
            case 1: {
                //如果用户的身份是创建者、管理员，那么需要查找其管理区里面的数据,
                // TODO 目前是查询的其所属政区，需改成其管理的政区
                String userRegionCode = userAreaService.getUserRegionCode(param.getUserId());
                if (!StringUtils.isNotBlank(userRegionCode)) {
                    throw new RuntimeException("用户所属政区获取失败，请联系管理员。");
                } else {
                    tempFilter = parseRegionCodeParam(userRegionCode, tableAlias, param,new ArrayList<>());
                    if (StringUtils.isNotBlank(tempFilter)) {
                        sbFilter.append(tempFilter);
                    }
                }

            }
            break;
            case 2: {
                // 查找其审核区里面的数据
                List<TbtskUserAuditArea> userAuditAreas = tbtskUserAuditAreaService.listAuditAreas(param.getTaskId()
                        , param.getUserId().toString());
                Short level = null;
                if (GutilCollection.isEmpty(userAuditAreas)) {
                    throw new RuntimeException("用户未分配审核区，请联系管理员。");
                } else {
                    Optional<TbtskUserAuditArea> collect = userAuditAreas.stream().collect(Collectors.minBy((e1, e2) -> Short.compare(e1.getLevel(),
                            e2.getLevel())));
                    level = collect.orElse(null).getLevel();
                }
                if (param.getPageType() == 1) {//查询全部线索
                    if (level == 1) { //省级
                        // 没有被区县退回的记录
                        sbFilter.append(" and ").append(tableAlias).append(".f_isfinish = 0 or ").append(tableAlias).append(".f_isfinish is null ");
                    } else if (level == 2) {//市级
                        // 没有被区县退回的记录
                        sbFilter.append(" and ").append(tableAlias).append(".f_isfinish = 0 or ").append(tableAlias).append(".f_isfinish is null ");

                    } else if (level == 3) {//区县级

                    }
                } else if (param.getPageType() == 2) {  //查询代办
                    if (level == 1) { //省级
                        // 省级核查
                        sbFilter.append(" and  ( ").append(tableAlias).append(".f_review_stage = ").append(ReviewStageEnum.PROVINCE_VERIFY.getCode());
                        // 未审核
                        sbFilter.append(" and ").append(tableAlias).append(".f_status = ").append(TbStatusEnum.WAITING_REVIEW.getCode());

                        // 没有被区县退回的记录
                        sbFilter.append(" and (").append(tableAlias).append(".f_isfinish = 0 or ").append(tableAlias).append(".f_isfinish is null ))");
                    } else if (level == 2) {//市级
                        // 市级核查
                        sbFilter.append(" and (( ").append(tableAlias).append(".f_review_stage = ").append(ReviewStageEnum.CITY_VERIFY.getCode());
                        // 未审核
                        sbFilter.append(" and ").append(tableAlias).append(".f_status = ").append(TbStatusEnum.WAITING_REVIEW.getCode());

                        // 没有被区县退回的记录
                        sbFilter.append(" and ( ").append(tableAlias).append(".f_isfinish = 0 or ").append(tableAlias).append(".f_isfinish is null ))");

                    } else if (level == 3) {//区县级
                        // 区县级核查
                        sbFilter.append(" and (").append(tableAlias).append(".f_review_stage = ").append(ReviewStageEnum.COUNTY_VERIFY.getCode());
                        // 未审核
                        sbFilter.append(" and ").append(tableAlias).append(".f_status = ").append(TbStatusEnum.WAITING_VERIFY.getCode());
                    }

                } else if (param.getPageType() == 3) {//查询已办
                    if (level == 1) { //省级
                        // 省级核查
                        sbFilter.append(" and ( ").append(tableAlias).append(".f_review_stage = ").append(ReviewStageEnum.PROVINCE_VERIFY.getCode());
                        // 未审核
                        sbFilter.append(" and ").append(tableAlias).append(".f_status = ").append(TbStatusEnum.VERIFY_NOT_PASS.getCode());

                        // 没有被区县退回的记录
                        sbFilter.append(" and ( ").append(tableAlias).append(".f_isfinish = 0 or ").append(tableAlias).append(".f_isfinish is null ))");

                    } else if (level == 2) {//市级
                        // 市级核查
                        sbFilter.append(" and (( ").append(" ( ").append(" ( ").append(tableAlias).append(".f_review_stage > ").append(ReviewStageEnum.CITY_VERIFY.getCode());
                        // 已审核
                        sbFilter.append(" and ").append(tableAlias).append(".f_status >= ").append(TbStatusEnum.VERIFY_NOT_PASS.getCode());
                        sbFilter.append(" and   EXISTS(SELECT approve.f_tbid FROM tbtsk_approve_record AS approve WHERE tb.f_id  = approve.f_tbid and approve.f_taskid = '" + param.getTaskId());
                        sbFilter.append("' and approve.f_approve_userid = '" + param.getUserId() + "' )) ");
                       /* sbFilter.append(" or (").append(tableAlias).append(".f_reject_status =1 ");
                        sbFilter.append(" and ").append(tableAlias).append(".f_review_stage = ").append(ReviewStageEnum.COUNTY_VERIFY.getCode());
                        sbFilter.append(" and   EXISTS(SELECT reject.f_tbid FROM tbtsk_reject_record AS reject WHERE tb.f_id  = reject.f_tbid and reject.f_taskid = '"+param.getTaskId());*/
                        sbFilter.append(" )) ");
                        // 没有被区县退回的记录
                        sbFilter.append(" and ( ").append(tableAlias).append(".f_isfinish = 0 or ").append(tableAlias).append(".f_isfinish is null )");

                    } else if (level == 3) {//区县级
                        // 区县级核查
                        sbFilter.append(" and ").append(" ( ").append(" ( ").append(tableAlias).append(".f_review_stage > ").append(ReviewStageEnum.COUNTY_VERIFY.getCode());
                        // 已审核
                        sbFilter.append(" and ").append(tableAlias).append(".f_status > ").append(TbStatusEnum.WAITING_VERIFY.getCode());
                        sbFilter.append(" and   EXISTS(SELECT approve.f_tbid FROM tbtsk_approve_record AS approve WHERE tb.f_id  = approve.f_tbid and approve.f_taskid = '" + param.getTaskId());
                        sbFilter.append("' and approve.f_approve_userid = '" + param.getUserId() + "' )) ");
                        sbFilter.append(" or (").append(tableAlias).append(".f_reject_status =1 ");
                        sbFilter.append(" and   EXISTS(SELECT reject.f_tbid FROM tbtsk_reject_record AS reject WHERE tb.f_id  = reject.f_tbid and reject.f_taskid = '" + param.getTaskId());
                        sbFilter.append("' and reject.f_userid = '" + param.getUserId() + "' )) ");
                        sbFilter.append(" or (").append(tableAlias).append(".f_status = ").append(TbStatusEnum.DISTRIBUTED.getCode());
                        sbFilter.append(" and   EXISTS(SELECT assign.f_dataid FROM tbtsk_assign_record AS assign WHERE tb.f_id  = assign.f_dataid and assign.f_taskid = '" + param.getTaskId());
                        sbFilter.append("' and assign.f_optuserid = '" + param.getUserId() + "' )) ");
                       /* sbFilter.append(" or ").append(tableAlias).append(".f_isfinish =1 ");
                        sbFilter.append(" or ").append(tableAlias).append(".f_reject_status =1 ").append(" ) ");*/
                    }

                } else if (param.getPageType() == 4) {//违法挂号页面
                    // 省级核查
                    sbFilter.append(" and (( ").append(tableAlias).append(".f_review_stage >= ").append(ReviewStageEnum.CITY_VERIFY.getCode());
                    // 已审核
                    sbFilter.append(" and ").append(tableAlias).append(".f_status = ").append(TbStatusEnum.VERIFY_NOT_PASS.getCode());
                    // 没有被区县退回的记录
                    sbFilter.append(" and (").append(tableAlias).append(".f_isfinish = 0 or ").append(tableAlias).append(".f_isfinish is null ))");

                }
                List<String> userAuditAreaList = new ArrayList<>();

                for (TbtskUserAuditArea area : userAuditAreas) {
                    if (StringUtils.isNotBlank(area.getRegionCode())) {
                        userAuditAreaList.add(area.getRegionCode());
                    }
                }
                tempFilter = parseRegionCodeListParam(userAuditAreaList, tableAlias, param,new ArrayList<>());
                if (StringUtils.isNotBlank(tempFilter)) {
                    sbFilter.append(tempFilter);
                    if (param.getPageType() != 1) {
                        sbFilter.append(" ) ");
                    }
                }
                break;
            }
            case 4: {
                // 查找其复核区里面的数据
                List<TbtskUserReviewArea> userReviewAreas = tbtskUserReviewAreaService.listReviewAreas(param.getTaskId()
                        , param.getUserId().toString());
                if (GutilCollection.isEmpty(userReviewAreas)) {
                    throw new RuntimeException("用户未分配复核区，请联系管理员。");
                } else {
                    List<String> userReviewAreaList = new ArrayList<>();
                    for (TbtskUserReviewArea area : userReviewAreas) {
                        if (StringUtils.isNotBlank(area.getRegionCode())) {
                            userReviewAreaList.add(area.getRegionCode());
                        }
                    }
                    tempFilter = parseRegionCodeListParam(userReviewAreaList, tableAlias, param,new ArrayList<>());
                    if (StringUtils.isNotBlank(tempFilter)) {
                        sbFilter.append(tempFilter);
                    }
                }
                break;
            }
            case 3: {
                // 如果是作业员，1、下发类型的任务，则查询下发给作业员的数据；2、领取类型的任务，则查找作业员的作业区下的数据
                if (taskBiz.getMode().intValue() == 1) {
                    rightJoinStr = " RIGHT JOIN (SELECT DISTINCT f_dataid FROM tbtsk_assign_record where f_taskid='" + taskBiz.getId()
                            + "' and f_assignto = '" + param.getUserId() + "') " +
                            " AS re ON tb.f_id = re.f_dataid";
                } else if (taskBiz.getMode().intValue() == 2) {

                    List<String> userWorkAreas = tskRightAreaRepository.findXzqdmByTaskIdAndUserId(param.getTaskId(), param.getUserId().toString());
                    tempFilter = parseRegionCodeListParam(userWorkAreas, tableAlias, param,new ArrayList<>());
                    if (StringUtils.isNotBlank(tempFilter)) {
                        sbFilter.append(tempFilter);
                    }
                    // 仅我领取的图斑
                    if (StringUtils.isNotBlank(param.getOnlyMySpot())) {
                        if ("1".equals(param.getOnlyMySpot())) {
                            rightJoinStr = " RIGHT JOIN (SELECT DISTINCT f_dataid FROM tbtsk_assign_record where f_taskid='" + taskBiz.getId()
                                    + "' and f_assignto = '" + param.getUserId() + "') " +
                                    " AS re ON tb.f_id = re.f_dataid";
                        }
                    }
                }
            }
            break;
            default:
                throw new GwValidateException("用户角色错误。");
        }
//        String orderByStr = " order by " + param.getSortParam();
//        String where = sbFilter.toString() + orderByStr;


        return Pair.of(tableName + rightJoinStr + rejectJoinFilter, sbFilter.toString());
    }


    /**
     * 获取用户身份
     *
     * @param taskId       业务编号
     * @param userId       用户id
     * @param priorityRole 优先的用户身份
     * @return 对于拥有多个角色的用户，优先返回其多个角色中包含 priorityRole参数的角色，
     * 如果priorityRole未指定或者用户拥有的角色中不包含priorityRole，则返回其角色集合中权限最大的角色
     */
    private UserRoleEnum getUserRole(String taskId, Long userId, Integer priorityRole) {

        Integer tempRole = Integer.MAX_VALUE;
        List<UserBiz2> userBiz2List = userBiz2Repository.findByUserIdAndBizId(userId, taskId);
        if (!GutilCollection.isEmpty(userBiz2List)) {
            boolean existPriorityRole = false;
            if (priorityRole != null) {
                existPriorityRole = userBiz2List.stream().filter(role -> role.getRole().equals(priorityRole)).findAny().isPresent();
            }
            if (existPriorityRole) {
                tempRole = priorityRole;
            } else {
                // 对于既是作业员，又是管理员的任务，则取其权限大的，取管理员身份;同理如果又是创建者，则取创建者身份
                for (UserBiz2 userBiz2 : userBiz2List) {
                    if (userBiz2.getRole().intValue() == 4) {
                        // 复核员
                        if (tempRole.intValue() == 3) {
                            tempRole = 4;
                        }
                    } else {
                        if (userBiz2.getRole() < tempRole) {
                            tempRole = userBiz2.getRole();
                        }
                    }
                }
            }
        }

        if (tempRole.intValue() != Integer.MAX_VALUE) {
            return UserRoleEnum.getEnum(tempRole);
        } else {
            return UserRoleEnum.UNDEFINED;
        }
    }

    public void fillRequiredFieldNames(List<String> fieldNameList, TbtskObjectinfo tableInfo) {
        List<TbtskFields> list = fieldsService.getAllFieldsByTableID(tableInfo.getfId());
        if (!fieldNameList.contains("f_id")) {
            fieldNameList.add("f_id");
        }
        if (!fieldNameList.contains("f_createtime")) {
            fieldNameList.add("f_createtime");
        }
        if (!fieldNameList.contains("f_approvetime")) {
            fieldNameList.add("f_approvetime");
        }
        if (!fieldNameList.contains("f_committime")) {
            fieldNameList.add("f_committime");
        }
        if (!fieldNameList.contains("f_submit_userid")) {
            fieldNameList.add("f_submit_userid");
        }
        if (!fieldNameList.contains("f_upload_userid")) {
            fieldNameList.add("f_upload_userid");
        }
        if (!fieldNameList.contains("f_typical")) {
            fieldNameList.add("f_typical");
        }
        if (!fieldNameList.contains("f_submittime")) {
            fieldNameList.add("f_submittime");
        }

        // 增加地图模式定位所需要的数据字段，因为列表获取数据和地图模式获取数据采用的同一个接口
        if (!fieldNameList.contains("f_lon")) {
            fieldNameList.add("f_lon");
        }
        if (!fieldNameList.contains("f_lat")) {
            fieldNameList.add("f_lat");
        }
      /*  if (!fieldNameList.contains("f_shape")) {
            fieldNameList.add("f_shape");
        }*/
        if (!fieldNameList.contains("f_status")) {
            fieldNameList.add("f_status");
        }
        if (!fieldNameList.contains("f_review_stage")) {
            fieldNameList.add("f_review_stage");
        }
        if (!fieldNameList.contains("f_xzqdmsys")) {
            fieldNameList.add("f_xzqdmsys");
        }
        if (!fieldNameList.contains("f_userid")) {
            fieldNameList.add("f_userid");
        }
        if (!fieldNameList.contains("f_tbmc")) {
            fieldNameList.add("f_tbmc");
        }
        if (!fieldNameList.contains("f_tbmj")) {
            fieldNameList.add("f_tbmj");
        }

        // 打回状态
        if (!fieldNameList.contains("f_reject_status")) {
            fieldNameList.add("f_reject_status");
        }

        if (!fieldNameList.contains("f_issplitted") && list.stream().anyMatch(m -> "f_issplitted".equals(m.getfFieldname()))) {
            fieldNameList.add("f_issplitted");
        }
        if (!fieldNameList.contains("f_splitedid") && list.stream().anyMatch(m -> "f_splitedid".equals(m.getfFieldname()))) {
            fieldNameList.add("f_splitedid");
        }
        if (!fieldNameList.contains("f_mergeid") && list.stream().anyMatch(m -> "f_mergeid".equals(m.getfFieldname()))) {
            fieldNameList.add("f_mergeid");
        }
        if (!fieldNameList.contains("f_ismultipart") && list.stream().anyMatch(m -> "f_ismultipart".equals(m.getfFieldname()))) {
            fieldNameList.add("f_ismultipart");
        }
        if (!fieldNameList.contains("f_pid") && list.stream().anyMatch(m -> "f_pid".equals(m.getfFieldname()))) {
            fieldNameList.add("f_pid");
        }
        //河北定制增加面积字段
        if (!fieldNameList.contains("f_sjrdccmj") && list.stream().anyMatch(m -> "f_sjrdccmj".equals(m.getfFieldname()))) {
            fieldNameList.add("f_sjrdccmj");
        }
        if (!fieldNameList.contains("f_sjrdbbmj") && list.stream().anyMatch(m -> "f_sjrdbbmj".equals(m.getfFieldname()))) {
            fieldNameList.add("f_sjrdbbmj");
        }
    }

    public void fillRequiredFieldNamesMedia(List<String> fieldNameList) {
        fieldNameList.add("media.f_id");
        fieldNameList.add("tb.f_tbbh");
        fieldNameList.add("media.f_galleryid");
        fieldNameList.add("media.f_type");
        fieldNameList.add("media.f_time");
        fieldNameList.add("media.f_lon");
        fieldNameList.add("media.f_lat");
        fieldNameList.add("media.f_azimuth");
        fieldNameList.add("media.f_pitch");
        fieldNameList.add("media.f_shape");
        fieldNameList.add("media.f_videorecord");
        fieldNameList.add("media.f_serverpath");
        fieldNameList.add("media.f_mediatimelength");
        fieldNameList.add("media.f_mediasize");
        fieldNameList.add("media.f_fileid");
        fieldNameList.add("media.f_downloadurl");
        fieldNameList.add("media.f_mark");
        fieldNameList.add("media.f_typetype");
        fieldNameList.add("media.f_username");
        fieldNameList.add("media.f_media");
        fieldNameList.add("media.f_group_code  ");
        fieldNameList.add("media.f_viewurl");
        fieldNameList.add("media.f_appkey");
        fieldNameList.add("media.f_createtime");
        fieldNameList.add("media.f_tilestate");
        fieldNameList.add("media.f_tileurl");
        fieldNameList.add("media.f_scale");
        fieldNameList.add("media.f_psgd");
        fieldNameList.add("media.f_takeofflon");
        fieldNameList.add("media.f_takeofflat");
        fieldNameList.add("media.f_takeoffrelheight");
        fieldNameList.add("media.f_device_source");
        fieldNameList.add("media.f_jym");
        fieldNameList.add("media.f_takeoffaltitude");
        fieldNameList.add("media.f_psaltitude");
        fieldNameList.add("media.f_copyid");
        fieldNameList.add("media.f_bizid");
        fieldNameList.add("media.f_fromsource");
        fieldNameList.add("media.f_tablename");
    }

    private void fillRequiredFieldNamesJXCJ(List<String> fieldNameList) {
        if (!fieldNameList.contains("f_id")) {
            fieldNameList.add("f_id");
        }

        // 增加地图模式定位所需要的数据字段，因为列表获取数据和地图模式获取数据采用的同一个接口
        if (!fieldNameList.contains("f_lon")) {
            fieldNameList.add("f_lon");
        }
        if (!fieldNameList.contains("f_lat")) {
            fieldNameList.add("f_lat");
        }
        if (!fieldNameList.contains("f_shape")) {
            fieldNameList.add("f_shape");
        }
    }

    private List<Map> updateChildren(List<Map> list, String taskId, TbtskObjectinfo tableInfo, List<String> fieldNameList,TaskQueryParameter param) {
        for (Map map : list) {
            if (org.apache.commons.collections.MapUtils.getString(map, "f_issplitted", "0").equals("1") && map.containsKey("f_splitedid")) {
                String f_id = org.apache.commons.collections.MapUtils.getString(map, "f_id", "");
                     boolean f_ismultipart = false;
                if(fieldNameList.contains("f_pid")){
                    f_ismultipart = true;
                }
                String tableName = tableInfo.getSplitTableName()+" tb ";
                if(param.getNeedHld()!=null&&param.getNeedHld().equals(1)){
                    tableName = "(select \n" +
                            "(select  r.f_option  from tbtsk_approve_record r\n" +
                            "where r.f_stepname ='省级审核' and r.f_taskid ='" + param.getTaskId() + "' and r.f_tbid = t.f_id\n" +
                            "order by r.f_approve_time desc limit 1) as f_option,\n" +
                            "(select  r.f_approve_time from tbtsk_approve_record r\n" +
                            "where r.f_stepname ='市级审核' and r.f_taskid ='" + param.getTaskId() + "' and r.f_tbid = t.f_id\n" +
                            "order by r.f_approve_time desc limit 1) as f_approve_time_city,\n" +
                            "t.*\n" +
                            "from "+ tableInfo.getSplitTableName() +" t) " + " as tb ";
                }
                List<Map> maps = new ArrayList<>();
                   if(f_ismultipart){
                       maps =  mDataBizService.queryAllData(tableName, fieldNameList, " f_pid is null and f_splitedid = '" + f_id + "' ORDER BY to_number(COALESCE(NULLIF(split_part(f_tbbh,'_',2),''),'0'),'00')");
                     }else{
                       maps = mDataBizService.queryAllData(tableName, fieldNameList, " f_splitedid = '" + f_id + "' ORDER BY to_number(COALESCE(NULLIF(split_part(f_tbbh,'_',2),''),'0'),'00')");
                     }
                for (Map map1 : maps) {
                    if (map1 != null) {
                        if (map1.get("f_committime") != null && StringUtils.isNotBlank(map1.get("f_committime").toString())) {
                            map1.put("f_committime", Long.valueOf(map1.get("f_committime").toString()));
                        } else {
                            map1.put("f_committime", null);
                        }
                        if(f_ismultipart){
                            String f_Pid = org.apache.commons.collections.MapUtils.getString(map1, "f_id", "");
                            List<Map> maps2 = mDataBizService.queryAllData(tableInfo.getSplitTableName()+" tb ", fieldNameList, " " +
                                    "f_pid = '" + f_Pid + "' ORDER BY to_number(COALESCE(NULLIF(split_part(f_tbbh,'_',2),''),'0'),'00')");
                            for (Map map3 : maps2) {
                                if (map3 != null) {
                                    if (map3.get("f_committime") != null && StringUtils.isNotBlank(map3.get("f_committime").toString())) {
                                        map3.put("f_committime", Long.valueOf(map3.get("f_committime").toString()));
                                    } else {
                                        map3.put("f_committime", null);
                                    }
                                }
                            }
                            map1.put("children", maps2);
                        }
                    }
                }
                map.put("children", maps);
            }
        }
        return list;
    }

    public List<Map> updateAssignInfo(List<Map> sourceDataList, String taskId) {
        List<Map> resultList = new ArrayList<>();
        for (Map map : sourceDataList) {
            if (map != null) {
                if (!map.containsKey("f_taskid")) {
                    map.put("f_taskid", taskId);
                }
                map.put("f_assignname", "");
                if (map.get("f_approvetime") != null && StringUtils.isNotBlank(map.get("f_approvetime").toString())) {
                    map.put("f_approvetime", Long.valueOf(map.get("f_approvetime").toString()));
                } else {
                    map.put("f_approvetime", null);
                }
                if (map.get("f_assignto") != null && StringUtils.isNotBlank(map.get("f_assignto").toString())) {
                    if (map.get("f_createtime") != null && StringUtils.isNotBlank(map.get("f_createtime").toString())) {
                        map.put("f_createtime", Long.valueOf(map.get("f_createtime").toString()));
                    } else {
                        map.put("f_createtime", null);
                    }
                    if (map.get("f_committime") != null && StringUtils.isNotBlank(map.get("f_committime").toString())) {
                        map.put("f_committime", Long.valueOf(map.get("f_committime").toString()));
                    } else {
                        map.put("f_committime", null);
                    }
                    String userRealName = userNameService.getUserNameByUserId(map.get("f_assignto").toString());
                    map.put("f_assignname", userRealName);

                    if (map.get("f_submit_userid") != null && StringUtils.isNotBlank(map.get("f_submit_userid").toString())) {
                        map.put("f_submitname", userNameService.getUserNameByUserId(map.get("f_submit_userid").toString()));
                    } else {
                        map.put("f_submitname", "");
                    }
                } else {
                    map.put("f_assigntime", null);
                    map.put("f_committime", null);
                    map.put("f_assignname", "");
                    map.put("f_submitname", "");
                }
                if (map.containsKey("f_distributionto") && map.get("f_distributionto") != null && StringUtils.isNotBlank(map.get("f_distributionto").toString())) {
                    String userRealName = userNameService.getUserNameByUserId(map.get("f_distributionto").toString());
                    map.put("f_distributionname", userRealName);
                }else {
                    map.put("f_distributionname", "");
                }
            }
            resultList.add(map);
        }
        return resultList;
    }



    public List<TskTaskBiz> getBizListsByType(String type, Long userId) {
        List<TskTaskBiz> tskTaskBizs = null;
        if (type == null || type.equals("")) {
            throw new RuntimeException("参数错误");
        }
        String[] strings = type.split(",");
        List<String> list = Arrays.asList(strings);
        List<Long> integers = list.stream().map(Long::parseLong).collect(Collectors.toList());
        tskTaskBizs = distinct(tskTaskBizRepository.getBizListsByTypeAndUserId(integers, userId));
        return tskTaskBizs;
    }

    public List<TbtskTaskClass> getClassContainTaskTrees(String type, Long userId) {
        List<TbtskTaskClass> datas = new ArrayList<>();
        if (type == null || type.equals("")) {
            throw new RuntimeException("参数错误");
        }
        String[] strings = type.split(",");
        List<String> list = Arrays.asList(strings);
        list.forEach(a -> {
            TbtskTaskClass tbtskTaskClass = mTbtskTaskClassService.containTaskTrees(Long.valueOf(a), userId);
            datas.add(tbtskTaskClass);
        });
        return datas;
    }


    public List<TskTaskBiz> getBizListsByUserId(Long userId) {
        List<TskTaskBiz> tskTaskBizs = distinct(tskTaskBizRepository.getBizListsUserId(userId));
        return tskTaskBizs;
    }

    public List<TskTaskBiz> getBizListsByUserId1(Long userId) {
        List<TskTaskBiz> tskTaskBizs = new ArrayList<>();
        List<Object> list = tskTaskBizRepository.getBizListsUserIdLeftTbtskTaskClass(userId);
        for (int i = 0; i < list.size(); i++) {
            TskTaskBiz bean = new TskTaskBiz();
            Object[] obj = (Object[]) list.get(i);
            bean.setId(obj[0].toString());
            bean.setName(obj[1].toString());
            bean.setParentId(obj[2] != null ? Long.valueOf(obj[2].toString()) : null);
            bean.setClassId(obj[3] != null ? Long.valueOf(obj[3].toString()) : null);
            tskTaskBizs.add(bean);
        }
        return tskTaskBizs;
    }

    public List<TskTaskBiz> getTskTaskBizByClassId(Long classId) {
        List<TskTaskBiz> tskTaskBizs = tskTaskBizRepository.getTskTaskBizByClassId(classId);
        return tskTaskBizs;
    }


    public Integer getCountTskTaskBizByClassIds(List<Long> classIds) {
        return tskTaskBizRepository.getCountTskTaskBizByClassIds(classIds);
    }


    public List<TskTaskBiz> getTskTaskBizByClassIdAndUserId(Long classId,Long userId) {
        List<TskTaskBiz> tskTaskBizs = tskTaskBizRepository.getTskTaskBizByClassIdAndUserId(classId, userId);
        return tskTaskBizs;
    }



    /**
     * 去重
     *
     * @param deviceTracks
     * @return
     */
    public List<TskTaskBiz> distinct(List<TskTaskBiz> deviceTracks) {
        Set set = new HashSet();
        List<TskTaskBiz> doubleList = new ArrayList<>();
        set.addAll(deviceTracks);
        doubleList.addAll(set);
        return doubleList;
    }

    public List<TbtskTaskClass> getMyTaskClassAndGroup(Long userId, String branch) {
        List<TbtskTaskClass> tbtskTaskClasses = null;
        if (branch != null && !branch.isEmpty()) {
            SysConfig sysConfig = sysConfigService.findOne(branch);
            if (sysConfig != null) {
                //获取该省份下全部显示业务
                tbtskTaskClasses = tbtskTaskClassRepository.queryAllByAppkeyAndVisible(sysConfig.getValue(), 1);
                tbtskTaskClasses.addAll(getUserTbtskTaskClass(userId, sysConfig.getValue()));
                tbtskTaskClasses = tbtskTaskClasses.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() ->
                        new TreeSet<>(Comparator.comparing(o -> o.getId() + ";" + o.getName()))), ArrayList::new));
                // 获取用户拥有业务大类
                List<TbtskUserTaskClass> taskClassIds = tbtskUserTaskClassRepository.queryByUserId(Long.valueOf(userId));
                if (tbtskTaskClasses != null) {
                    tbtskTaskClasses.forEach(a -> {
                        if (a.getParentId() == -1) {
                            a.setEnable(0);
                            taskClassIds.forEach(b -> {
                                if (a.getId() == b.getClassId()) {
                                    a.setEnable(1);
                                }
                            });
                        } else {
                            // 非根节点，直接返回enable=1
                            a.setEnable(1);
                        }
                    });
                }
            }
        } else {
            tbtskTaskClasses = getUserTbtskTaskClass(userId, null);
        }
        //排序
        if (!GutilCollection.isEmpty(tbtskTaskClasses)) {
            Collections.sort(tbtskTaskClasses, new Comparator<TbtskTaskClass>() {
                @Override
                public int compare(TbtskTaskClass o1, TbtskTaskClass o2) {
                    int flag = o1.getLevel().compareTo(o2.getLevel());
                    if (flag != 0) {
                        return flag;
                    } else {
                        return o1.getCreateDate().compareTo(o2.getCreateDate());
                    }
                }
            });
        }
        return tbtskTaskClasses;
    }


    public List<TbtskTaskClass> getUserTbtskTaskClass(Long userId, String appKey) {
        List<TbtskTaskClass> tbtskTaskClasses = new ArrayList<>();
        List<Integer> roles = Arrays.asList(2, 3, 4);
        //获取用户所有bizId
        List<String> bizs = new ArrayList<>();
        if (appKey != null) {
            bizs = userBiz2Repository.getUserBiz2ByUserIdAndRoleListNotDelAndAppkey(userId, roles, appKey);
        } else {
            bizs = userBiz2Repository.getUserBiz2ByUserIdAndRoleListNotDel(userId, roles);
        }
        if (!bizs.isEmpty()) {
            //查询用户所有biz的分组
            List<Long> groupId = tskTaskBizRepository.findByIds(bizs).stream().filter(r -> r.getClassId() != null).map(r -> r.getClassId()).distinct().collect(Collectors.toList());
            //获取所有parentId
            List<Long> parentIds = tbtskTaskClassRepository.queryParentId(groupId);
            //大类和分组id
            List<Long> classAndGroupIds = new ArrayList<>();
            classAndGroupIds.addAll(groupId);
            classAndGroupIds.addAll(parentIds);
            tbtskTaskClasses = tbtskTaskClassRepository.queryById(classAndGroupIds);
        }
        return tbtskTaskClasses;
    }

    public List<TbtskTaskClass> getMyTaskGroupByClass(Long userId, Integer classId) {
        List<TbtskTaskClass> tbtskTaskClasses = null;
        List<Integer> roles = Arrays.asList(2, 3, 4);
        //获取用户所有bizId
        List<String> bizs = userBiz2Repository.getUserBiz2ByUserIdAndRoleListNotDel(userId, roles);
        //根据bizId查询用户任务所在分组
        List<Long> groupIds = tskTaskBizRepository.findByIds(bizs).stream().map(r -> r.getClassId()).collect(Collectors.toList());
        tbtskTaskClasses = tbtskTaskClassRepository.queryById(groupIds);
        return tbtskTaskClasses;
    }

    /***
     * 根据id获取子表信息
     * @param parentObjId
     * @return
     */
    public List<TbtskObjectinfo> getObjectInfoListByParentId(String parentObjId) {
        return mTbtskObjectinfoService.getObjectByParentObjId(parentObjId);
    }

    /**
     * 获取建新拆旧子任务bizId
     *
     * @return
     */
    public Map getJXCJ(String hostId) {
        Map map = new HashMap();
        SysConfig sysConfig = null;
        //获取建新拆旧项目
        SysConfig jxcj = sysConfigService.findOne("zjgg-jxcj");
        if (jxcj != null) {
            JSONObject object = JSONObject.parseObject(jxcj.getValue());
            if (object.get("bizid").equals(hostId)) {
                sysConfig = jxcj;
            }
        }
        //获取耕地质量项目
        SysConfig gdzl = sysConfigService.findOne("zjgg-gdzlbdd");
        if (gdzl != null) {
            JSONObject object = JSONObject.parseObject(gdzl.getValue());
            if (object.get("bizid").equals(hostId)) {
                sysConfig = gdzl;
            }
        }
        //获取复垦现状非耕地
        SysConfig fkxz = sysConfigService.findOne("zjgg-fkxzfgd");
        if (fkxz != null) {
            JSONObject object = JSONObject.parseObject(fkxz.getValue());
            if (object.get("bizid").equals(hostId)) {
                sysConfig = fkxz;
            }
        }

        if (sysConfig != null) {
            JSONObject jsonObject = JSONObject.parseObject(sysConfig.getValue());
            if (jsonObject.get("jx") != null) {
                JSONObject jx = JSONObject.parseObject(jsonObject.get("jx").toString());
                String bizId = jx.get("bizid").toString();
                TskTaskBiz jxBiz = tskTaskBizRepository.findById(bizId).orElse(null);
                map.put("new", jxBiz);
                map.put("zjggType", Integer.parseInt(jx.get("type").toString()));
            }
            if (jsonObject.get("cj") != null) {
                JSONObject cj = JSONObject.parseObject(jsonObject.get("cj").toString());
                String bizId = cj.get("bizid").toString();
                TskTaskBiz cjBiz = tskTaskBizRepository.findById(bizId).orElse(null);
                map.put("zjggType", Integer.parseInt(cj.get("type").toString()));
                map.put("old", cjBiz);
            }
        }
        return map;
    }

    /**
     * 将导出附件下载 放入定时任务中
     *
     * @param userId
     * @param bizid
     * @param tbIds
     */
    public void saveExportRecord(Long userId, String bizid, String tbIds) {
        TaskRecord taskRecord = new TaskRecord();
        String id = UUID.randomUUID().toString();
        taskRecord.setId(id);
        taskRecord.setTasktype(JobConstants.JOB_TYPE_DATA_DOWNLOAD);
        //设置参数
        DownloadParameter downloadParameter = new DownloadParameter();
        downloadParameter.setBizType("DailyTask");
        //设置增减挂钩下载
        downloadParameter.setDataType("zjgg");
        downloadParameter.setRecordId(id);
        downloadParameter.setTaskId(bizid);
        downloadParameter.setTbIds(tbIds);
        downloadParameter.setUserId(userId);
        //下载记录参数赋值
        taskRecord.setParam(JSONObject.toJSONString(downloadParameter));
        taskRecord.setState(1);
        taskRecord.setStarttime(new Date());
        taskRecord.setUserid(userId);
        taskRecord.setVersion("v2");
        taskRecordRepository.save(taskRecord);

        //todo 创建下载记录
        DataDownloadRecord dataDownloadRecord = new DataDownloadRecord();
        dataDownloadRecord.setId(id);
        dataDownloadRecord.setState(DataDownloadStateEnum.PACKING);
        dataDownloadRecord.setTbCount(tbIds.split(",").length);
        dataDownloadRecord.setUserId(userId);
        dataDownloadRecord.setTbIds(tbIds);
        dataDownloadRecord.setStartTime(new Date());
        dataDownloadRecord.setTaskId(bizid);
        dataDownloadRecordRepository.save(dataDownloadRecord);

    }

    public List<TaskTranslateTargetTaskDTO> queryTaskTranslateTemplateTargetTaskList(String sourceTaskId, long userId) {
        GutilAssert.isTrue(StringUtils.isNotBlank(sourceTaskId), "parameter 'sourceTaskId' must not be null or empty.");
        GutilAssert.notNull(userId, "parameter 'userId' must not be null .");

        List<TaskTranslateTargetTaskDTO> retVal = new ArrayList<>();
        TskTaskBiz sourceTask = tskTaskBizRepository.findById(sourceTaskId).orElse(null);
        if (sourceTask != null) {
            List<TskTaskBiz> tskTaskBizList = tskTaskBizRepository.findByUserId(String.valueOf(userId));
            if (!GutilCollection.isEmpty(tskTaskBizList)) {
                //   a、当前用户有任务权限的任务
                //   b、任务粒度相同
                //   c、当前任务范围是目标任务范围的子集
                //   d、目标任务需支持新增图斑
                TaskTranslateTargetTaskDTO dto = null;
                List<BizArea> sourceTaskBizAreaList = getTskTaskBizAreaByBizId(sourceTask.getId());
                if (!GutilCollection.isEmpty(sourceTaskBizAreaList)) {
                    List<String> sourceAreaList = sourceTaskBizAreaList.stream().map(a -> a.getArea()).collect(Collectors.toList());
                    List<BizArea> currTaskBizAreaList = null;
                    List<String> currentAreaList = null;
                    for (TskTaskBiz biz : tskTaskBizList) {
                        if (biz.getGranularity() == null
                                || sourceTask.getGranularity() == null
                                || biz.getAllowNew() == null
                                || biz.getFinish() == null) {
                            continue;
                        }

                        if (biz.getGranularity().equals(sourceTask.getGranularity())
                                && biz.getAllowNew().equalsIgnoreCase(String.valueOf(NumberConst.ONE))
                                && biz.getFinish().equals(NumberConst.ONE)) {
                            currTaskBizAreaList = getTskTaskBizAreaByBizId(biz.getId());
                            if (!GutilCollection.isEmpty(currTaskBizAreaList)) {
                                currentAreaList = sourceTaskBizAreaList.stream().map(a -> a.getArea()).collect(Collectors.toList());
                                boolean flag = hasIntersection(sourceAreaList, currentAreaList);
                                if (flag) {
                                    dto = new TaskTranslateTargetTaskDTO();
                                    dto.setGranularity(biz.getGranularity());
                                    dto.setName(biz.getName());
                                    dto.setId(biz.getId());
                                    dto.setScope(biz.getScope());
                                    retVal.add(dto);
                                }
                            }

                        }
                    }
                }
            }
        }

        return retVal;
    }

    /**
     * 判断两个业务区域集合是否有交集
     *
     * @param sourceAreaList
     * @param targetAreaList
     * @return boolean
     * @author zkn
     * @date 2021/4/25 15:51
     */
    private boolean hasIntersection(List<String> sourceAreaList, List<String> targetAreaList) {
        if (GutilCollection.isEmpty(sourceAreaList) || GutilCollection.isEmpty(targetAreaList)) {
            return false;
        }
        // 判断是否有交集
        if (sourceAreaList.retainAll(targetAreaList)) {
            return true;
        }
        // 判断 是否为目标业务区的子区域
        for (String targetArea : targetAreaList) {
            for (String sourceArea : sourceAreaList) {
                // 只要由一个的业务区域为全国，则有交集
                if (targetArea.equalsIgnoreCase("1")
                        || sourceArea.equalsIgnoreCase("1")) {
                    return true;
                }

                if (targetArea.length() >= 6) {
                    if (targetArea.endsWith("00") && sourceArea.startsWith(targetArea.substring(0, 3))) {
                        return true;
                    }
                    if (targetArea.endsWith("0000") && sourceArea.startsWith(targetArea.substring(0, 1))) {
                        return true;
                    }
                }
            }
        }

        return false;
    }

    /**
     * 根据任务id查询表内任一条记录
     *
     * @param taskId 任务id
     * @return
     */
    public TskTaskBiz findOne(String taskId) {
        TskTaskBiz one = tskTaskBizRepository.findById(taskId).orElse(null);
        if (one == null) {
            throw new RuntimeException("任务id错误");
        }
        return one;
    }

    private List<Long> findAllChildClass(List<Long> list, Long classId) {
        List<Long> tbtskTaskClasses = tbtskTaskClassRepository.queryByParentId(Long.valueOf(classId))
                .stream().map(r -> r.getId()).collect(Collectors.toList());
        list.add(classId);
        if (tbtskTaskClasses.isEmpty()) {
            return list;
        } else {
            for (Long tbtskTaskClass : tbtskTaskClasses) {
                classId = tbtskTaskClass;
                findAllChildClass(list, classId);
            }
        }
        return list;
    }

    public List<String> insertTaskTbList(Long userId, String taskId, String updateType, List<Map<String, Object>> tbList) {
        TskTaskBiz tskTaskBiz = tskTaskBizRepository.findById(taskId).orElse(null);
        if (tskTaskBiz == null) {
            throw new RuntimeException("任务id错误");
        }
        TbtskObjectinfo objectinfo = tbtskObjectinfoRepository.findById(tskTaskBiz.getTableId()).orElse(null);
        //查找表所有字段
        List<TbtskFields> tbtskFields = tbtskFieldsRepository.getTbtskFieldsByTableid(objectinfo.getfId());
        List<Map<String, Object>> temp = new ArrayList<>();
        //对map进行调整 例如xzqdmsys字段 shape
        for (Map<String, Object> tb : tbList) {
            reBuildMap(tbtskFields, tb, userId);
            //遍历tbList 剔除重复数据
            if (tb.containsKey("f_tbbh") && tb.get("f_tbbh") != null) {
                Map map = mDataBizService.selectByID(objectinfo.getfTablename(), "f_tbbh", "'" + tb.get("f_tbbh").toString() + "'");
                if (map == null) {
                    temp.add(tb);
                }
            }
        }//插入记录
        if (!temp.isEmpty()) {
            mDataBizService.insertDatasBatch(objectinfo.getfTablename(), temp, "f_shape");
        } else {
            return new ArrayList<String>();
        }
        return temp.stream().map(r -> r.get("f_id").toString()).collect(Collectors.toList());
    }

    private void reBuildMap(List<TbtskFields> tbtskFields, Map<String, Object> tb, Long userid) {
        try {
            //补充xzqdmsys、xzqdm字段、时间、userid等
            if (tb.get("f_shape") == null) {
                throw new RuntimeException("shape图形参数不能为空");
            }
            Geometry geometry = WKTUtil.wktToGeom(tb.get("f_shape").toString().replace("SRID=4490;",""));
            //查找所属行政区
            //中心点
            Geometry centroid = geometry.getCentroid();
            //查询是否有对应的村级行政区代码
            RegionVillage regionVillage = regionService.queryRegionVillageByCoor(centroid);
            String xzqdmsysStr = "";
            if (regionVillage != null) {
                xzqdmsysStr = regionVillage.getCode();
            } else {
                RegionTown regionTown = regionService.queryRegionTownCotain(centroid);
                if (regionTown != null) {
                    xzqdmsysStr = regionTown.getCode() + "000";
                } else {
                    if (tb.get("f_xzqdm") != null) {
                        xzqdmsysStr = tb.get("f_xzqdm").toString() + "000000";
                    }
                }
            }
            //默认字段
            tb.put("f_id", UUID.randomUUID().toString());
            tb.put("f_xzqdmsys", xzqdmsysStr);
            tb.put("f_userid", userid);
            tb.put("f_createtime", System.currentTimeMillis() + "");
            if (!tb.containsKey("f_shape")) {
                tb.put("f_shape", null);
            }
            if (!tb.containsKey("f_shape1")) {
                tb.put("f_shape1", null);
            }
            if (!tb.containsKey("f_shape_b")) {
                tb.put("f_shape_b", null);
            }
            if (!tb.containsKey("f_shape_g")) {
                tb.put("f_shape_g", null);
            }
            tb.put("f_lon", null);
            tb.put("f_lat", null);

            tb.put("f_lon_b", null);
            tb.put("f_lat_b", null);

            tb.put("f_lon_g", null);
            tb.put("f_lat_g", null);
            tb.put("f_status", 1);

            Set<String> keys = tb.keySet();

            for (String key : keys) {
                List<TbtskFields> one = tbtskFields.stream().filter(tbtskField -> tbtskField.getfFieldname().equals(key)).collect(Collectors.toList());
                if (!one.isEmpty()) {
                    //找到对应的记录
                    TbtskFields tempField = one.get(0);
                    String type = tempField.getfFieldtype();
                    String name = tempField.getfFieldname();
                    String value = tb.get(key) != null ? tb.get(key).toString() : null;
                    String defaultValue = tempField.getfDefaultvalue();
                    buildMap(tb, name, type, value, defaultValue);
                }
            }
        } catch (ParseException e) {
            e.printStackTrace();
        } catch (java.text.ParseException e) {
            e.printStackTrace();
        }
    }

    private void buildMap(Map map, String fieldName, String fieldType, String value, String defaultValue) throws java.text.ParseException, ParseException {
        DecimalFormat format = new DecimalFormat("######0.0000000");
        //转化枚举值
        if (fieldType.equals("1") || fieldType.equals("10")) {
            fieldType = "text";
        } else if (fieldType.equals("2") || fieldType.equals("6")) {
            fieldType = "varchar";
        } else if (fieldType.equals("3") || fieldType.equals("7")) {
            fieldType = "decimal";
        } else if (fieldType.equals("4") || fieldType.equals("5")) {
            fieldType = "timestamp";
        } else if (fieldType.equals("8")) {
            fieldType = "int4";
        } else if (fieldType.equals("9")) {
            fieldType = "geometry";
        }

        switch (fieldType) {
            case "varchar":
                map.put(fieldName, value);
                break;
            case "decimal":
                if (!"f_lat".equals(fieldName) && !"f_lon".equals(fieldName)) {
                    if (value == null) {
                        map.put(fieldName, value);
                    } else {
                        Double value2 = Double.valueOf(value);
                        map.put(fieldName, value2);
                    }
                }
                break;
            case "int4":
                if (value == null) {
                    map.put(fieldName, value);
                } else {
                    Integer value3 = Integer.valueOf(value);
                    map.put(fieldName, value3);
                }
                break;
            case "timestamp":
                if (value == null) {
                    map.put(fieldName, value);
                } else {
                    DateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                    Date date = df.parse(value);
                    Timestamp value5 = new Timestamp(date.getTime());
                    map.put(fieldName, value5);
                }
                break;
            case "text":
                map.put(fieldName, value);
                break;
            case "geometry":
                if (value != null) {
                    Geometry geo = WKTUtil.wktToGeom(value);
                    if ("f_shape".equalsIgnoreCase(fieldName)) {
                        if (geo == null) {
                            break;
                        } else {
                            map.put(fieldName, WKTUtil.geomToWkt(geo));
                            map.put("f_shape1", WKTUtil.geomToWkt(geo));
                            Point point = geo.getCentroid();
                            if (point != null) {
                                map.put("f_lat", format.format(point.getY()));
                                map.put("f_lon", format.format(point.getX()));
                            } else {
                                map.put("f_lat", "0.0");
                                map.put("f_lon", "0.0");
                            }
                        }
                    } else if ("f_shape_g".equalsIgnoreCase(fieldName)) {
                        // google
                        Geometry geometry_g = convertGeometry(geo, 1);
                        map.put("f_shape_g", WKTUtil.geomToWkt(geometry_g));
                        Point point_g = geometry_g.getCentroid();
                        if (point_g != null) {
                            map.put("f_lat_g", format.format(point_g.getY()));
                            map.put("f_lon_g", format.format(point_g.getX()));
                        } else {
                            map.put("f_lat_g", "0.0");
                            map.put("f_lon_g", "0.0");
                        }
                    } else if ("f_shape_b".equalsIgnoreCase(fieldName)) {
                        // baidu
                        Geometry geometry_b = convertGeometry(geo, 2);
                        map.put("f_shape_b", WKTUtil.geomToWkt(geometry_b));
                        Point point_b = geometry_b.getCentroid();
                        if (point_b != null) {
                            map.put("f_lat_b", format.format(point_b.getY()));
                            map.put("f_lon_b", format.format(point_b.getX()));
                        } else {
                            map.put("f_lat_b", "0.0");
                            map.put("f_lon_b", "0.0");
                        }
                    }
                }
                break;
            default:
                break;
        }
    }

    /**
     * @param bizId
     * @param tbId
     * @return
     */
    public List<Tbgst> getTakGstData(String bizId, String tbId) {
        List<Tbgst> list = tbgstRepository.findByBizIdAndTbId(bizId, tbId);
        return list;
    }

    /**
     * @param bizId
     * @param tbIds
     * @return
     */
    public List<Tbgst> getTakGstDatas(String bizId, String tbIds) {
        List<Tbgst> list = tbgstRepository.findByBizIdAndTbIds(bizId, Arrays.asList(tbIds.split(",")));
        return list;
    }

    public void updateCanRevoke(String taskId, Integer canRevoke) {
        tskTaskBizRepository.updateCanRevoke(taskId, canRevoke);
    }

    /**
     * 复制任务用户权限
     *
     * @param sourceTaskId
     * @param targetTaskId
     * @param role
     * @param userIds
     */
    @Transactional
    public void copyTaskRoleNew(String sourceTaskId, String targetTaskId, String role, String userIds, Long userId) throws Exception {
        List<String> userList = new ArrayList<>();
        if ("checkAll".equals(userIds)) {
            //获取当前用户的管理区
            List<String> regionAreas =  tbtskUserManageAreaService.listManageAreas(sourceTaskId, userId.toString()).stream().map(r -> r.getRegioncode()).collect(Collectors.toList());
            if (regionAreas.isEmpty()) {
                throw new GwValidateException("用户无本任务管理区");
            }
            //查询表名称
            String tableName = getTableName(role);
            //查询字段
            String tablefield = "c.f_regioncode";
            if(role.equals("3")){
                tablefield = "c.f_xzqdm";
            }
            String regionStr = "";
            for (int i = 0; i < regionAreas.size(); i++) {
                if (!regionAreas.get(i).equals("1")) {
                    regionStr += " " + tablefield + " ";
                    String tempRegion = "";
                    if (regionAreas.get(i).endsWith("0000") && regionAreas.get(i).length() <= 6) {
                        tempRegion = regionAreas.get(i).substring(0, 2) + "%";
                    } else if (regionAreas.get(i).endsWith("00") && regionAreas.get(i).length() <= 6) {
                        tempRegion = regionAreas.get(i).substring(0, 4) + "%";
                    } else {
                        tempRegion = regionAreas.get(i) + "%";
                    }
                    regionStr += "like '" + tempRegion + "'";
                    if (i < regionAreas.size() - 1) {
                        regionStr += " or ";
                    }
                }
            }
            if (GutilStr.isNotBlank(regionStr)) {
                regionStr = " and ( " + regionStr + " ) ";
            }
            //添加用户业务范围
            TskTaskBiz one = tskTaskBizRepository.findById(targetTaskId).orElse(null);
          //插入角色表
            String roleSql = " INSERT INTO public.tbsys_user_biz2 (f_userid, f_bizid, f_id, f_role) select aa.f_userid,'"+targetTaskId+"',uuid_generate_v4(),'"+role+"' from (select distinct(b.f_userid) " +
                    "from "+tableName+" c,tbsys_user_biz2 b where b.f_userid = cast(c.f_userid as int8 ) and b.f_bizid = c.f_taskid and  b.f_role='"+role+"' and b.f_bizid = '"+sourceTaskId+"'  "+regionStr+" and   not " +
                    "exists(select biz2.f_userid  from tbsys_user_biz2 biz2 where  b.f_userid =biz2.f_userid and  biz2.f_bizid='"+targetTaskId+"' and biz2.f_role='"+role+"')) aa";
             jdbcTemplate.execute(roleSql);

           //插入政区表
            if(role.equals("3")){
                String rightSql = "INSERT INTO public.tbtsk_right_area (f_id, f_taskid, f_userid, f_xzqdm) select uuid_generate_v4(),'"+targetTaskId+"',aa.f_userid,aa.f_xzqdm from (select c.f_userid,c.f_xzqdm from " +
                        "tbtsk_right_area c,tbsys_user_biz2 b where b.f_userid = cast(c.f_userid as int8 ) and b.f_bizid " +
                        "= c.f_taskid and  b.f_role='3' and b.f_bizid = '"+sourceTaskId+"' "+regionStr+"  and  not   exists (select mm.*  from tbtsk_right_area mm where  mm.f_userid =c.f_userid and  mm.f_taskid='"+targetTaskId+"' and c.f_xzqdm = mm.f_xzqdm)) aa ";
                jdbcTemplate.execute(rightSql);

                //拷贝用户太多影响系统运行,拷贝用户和通知分开执行 通知改成定时任务
                String sSql = "select aa.f_userid,aa.f_xzqdm from (select c.f_userid,c.f_xzqdm from " +
                        "tbtsk_right_area c,tbsys_user_biz2 b where b.f_userid = cast(c.f_userid as int8 ) and b.f_bizid " +
                        "= c.f_taskid and  b.f_role='3' and b.f_bizid = '"+sourceTaskId+"' "+regionStr+") aa";
                TaskRecord record = new TaskRecord();
                record.setState(JobConstants.JOB_STATE_CREATE);
                record.setBizId(targetTaskId);
                record.setParam(sSql);
                record.setTasktype(JobConstants.JOB_TYPE_USER_COPY_NOTIFY);
                record.setUserid(userId);
                record.setId(UUID.randomUUID().toString());
                taskRecordRepository.save(record);
                /*
                String sSql = "select aa.f_userid,aa.f_xzqdm from (select c.f_userid,c.f_xzqdm from " +
                        "tbtsk_right_area c,tbsys_user_biz2 b where b.f_userid = cast(c.f_userid as int8 ) and b.f_bizid " +
                        "= c.f_taskid and  b.f_role='3' and b.f_bizid = '"+sourceTaskId+"' "+regionStr+") aa";
                List<Map<String,Object>> maps = jdbcTemplate.queryForList(sSql);
                List<TskRightArea>rightAreas = new ArrayList<>();
                if(maps!=null&&!maps.isEmpty()) {
                    for(Map m:maps)
                    {
                        String uid=m.get("f_userid").toString();
                        String xzqdm=m.get("f_xzqdm").toString();
                        TskRightArea area = new TskRightArea();
                        area.setUserId(uid);
                        area.setXzqdm(xzqdm);
                        area.setTaskId(one.getId());
                        rightAreas.add(area);
                    }
                    addSubscribe(one, rightAreas);
                }
                */
            }else{
             String areaSql = " INSERT INTO "+tableName+" ( f_taskid, f_userid, f_level, f_regioncode) select '"+targetTaskId+"'," +
                     "aa.f_userid,aa.f_level,aa.f_regioncode from (select c.f_userid,c.f_regioncode,c.f_level from "+tableName+" c,tbsys_user_biz2 b where b.f_userid = cast(c.f_userid as int8 ) and b.f_bizid = c.f_taskid and  " +
                     "b.f_role='"+role+"' and b.f_bizid = '"+sourceTaskId+"' "+regionStr+"  and    not  exists (select mm.*  from "+tableName+" mm where  mm.f_userid =c.f_userid and  mm.f_taskid='"+targetTaskId+"' and c.f_regioncode = mm.f_regioncode)) aa";
                jdbcTemplate.execute(areaSql);
            }

            TbtskTaskClass one1 = tbtskTaskClassRepository.queryByFId(one.getClassId());
            if (one1 != null) {
                if (one1.getParentId() != -1) {
                    one1 = tbtskTaskClassRepository.queryByFId(one1.getParentId());
                }
                Long classId= one1.getParentId() == -1 ? one1.getId() : one1.getParentId();
               String classSql = "INSERT INTO public.tbtsk_user_task_class (f_id, f_userid, f_classid, f_createdate)\n" +
                       "select uuid_generate_v4(),aa.f_userid,'"+classId+"',now() from (select distinct(b.f_userid) from "+tableName+" c,tbsys_user_biz2 b where b.f_userid = cast(c.f_userid as int8 ) and b.f_bizid = c" +
                       ".f_taskid and  b.f_role='"+role+"' and b.f_bizid = '"+sourceTaskId+"' "+regionStr+" and not  exists (select * from tbtsk_user_task_class mm where mm.f_userid = b.f_userid and mm.f_classid='"+classId+"')) aa";
                jdbcTemplate.execute(classSql);
            }


        } else {
            userList = Arrays.asList(userIds.split(","));
            if (!userList.isEmpty()) {
                //添加角色
                for (String s : userList) {
                    saveUserBiz(Long.valueOf(s), targetTaskId, Integer.parseInt(role));
                }
                //添加区域
                if ("1".equals(role)) {
                    tbtskUserManageAreaService.copyTaskRoleByUserId(sourceTaskId, targetTaskId, userList);
                } else if ("3".equals(role)) {
                    copyTaskRoleByUserId(sourceTaskId, targetTaskId, userList);
                } else if ("2".equals(role)) {
                    tbtskUserAuditAreaService.copyTaskRoleByUserId(sourceTaskId, targetTaskId, userList);
                } else if ("4".equals(role)) {
                    tbtskUserReviewAreaService.copyTaskRoleByUserId(sourceTaskId, targetTaskId, userList);
                }else if ("5".equals(role)) {
                    tbtskSuperUserAuditAreaService.copyTaskRoleByUserId(sourceTaskId, targetTaskId, userList);
                }else if ("6".equals(role)) {
                    tbtskUserUploadAreaService.copyTaskRoleByUserId(sourceTaskId, targetTaskId, userList);
                }
            }
        }
        //添加记录
        TbtsktaskCopy tbtsktaskCopy = new TbtsktaskCopy();
        tbtsktaskCopy.setOperId(userId);
        tbtsktaskCopy.setRole(role);
        tbtsktaskCopy.setSourceTaskId(sourceTaskId);
        tbtsktaskCopy.setTargetTaskId(targetTaskId);
        tbtsktaskCopy.setUserIds(userIds);
        tbtsktaskCopy.setType(1);
        tbtsktaskCopy.setCreateTime(new Timestamp(System.currentTimeMillis()));
        tbtsktaskCopyRepository.save(tbtsktaskCopy);
    }


    public void notifyUser(TaskRecord record)
    {

        String sql = record.getParam();
        TskTaskBiz one = tskTaskBizRepository.findById(record.getBizId()).orElse(null);
        if(one!=null) {
            List<Map<String, Object>> maps = jdbcTemplate.queryForList(sql);
            List<TskRightArea> rightAreas = new ArrayList<>();
            if (maps != null && !maps.isEmpty()) {
                for (Map m : maps) {
                    String uid = m.get("f_userid").toString();
                    String xzqdm = m.get("f_xzqdm").toString();
                    TskRightArea area = new TskRightArea();
                    area.setUserId(uid);
                    area.setXzqdm(xzqdm);
                    area.setTaskId(record.getBizId());
                    rightAreas.add(area);
                }
                addSubscribe(one, rightAreas);
            }
        }

    }

    public String getTableName(String role){
        //查询表名称
        String tableName = "";
        if (role.equals("1")) {
            //管理员
            tableName = GLY_TABLE_NAME;
        } else if (role.equals("2")) {
            //审核员
            tableName = SHY_TABLE_NAME;
        } else if (role.equals("3")) {
            //作业员
            tableName = ZYY_TABLE_NAME;
        } else if (role.equals("4")) {
            //复核员
            tableName = FHY_TABLE_NAME;
        }else if (role.equals("5")) {
            //复核员
            tableName = CJSHY_TABLE_NAME;
        }else if (role.equals("6")) {
            //上传员
            tableName = SCY_TABLE_NAME;
        }
       return tableName;
    }
    /**
     * 复制任务用户权限
     *
     * @param sourceTaskId
     * @param targetTaskId
     * @param role
     * @param userIds
     */
    public void copyTaskRole(String sourceTaskId, String targetTaskId, String role, String userIds, Long userId) throws Exception {
        List<String> userList = new ArrayList<>();
        if ("checkAll".equals(userIds)) {
            String bizArea = "";
            List<String> areas = landUser2AreaRepository.queryAreas(userId);
            if (areas != null && areas.size() > 0) {
                bizArea = areas.get(0);
            }
            Integer regionLevel = regionService.getRegionLevel(bizArea, null);
            if (regionLevel == 0) {
                bizArea = "";
            } else if (regionLevel == 1) {
                bizArea = bizArea.substring(0, 2);
            } else if (regionLevel == 2) {
                bizArea = bizArea.substring(0, 4);
            }
            Map<String, Object> map = landUserService.getUsersByBizIdAndBizAreaAndBizRoleId(userId, sourceTaskId, "%%", "%%",
                    bizArea + "%", role, 0, 1000);
            if (map != null) {
                List<LandUser> list = (List<LandUser>) map.get("content");
                userList = list.stream().map(LandUser::getId).collect(Collectors.toList()).stream().map(x -> x + "").collect(Collectors.toList());
            }
               /* if ("1".equals(role)) {
                    userList =  tbtskUserManageAreaService.queryListByTaskId(sourceTaskId).stream().map(TbtskUserManageArea :: getUserId).collect(Collectors.toList());
                } else if ("3".equals(role)) {
                    userList = tskRightAreaRepository.findByTaskId(sourceTaskId).stream().map(TskRightArea :: getUserId).collect(Collectors.toList());
                } else if ("2".equals(role)) {
                    userList =   tbtskUserAuditAreaService.queryListByTaskId(sourceTaskId).stream().map(TbtskUserAuditArea :: getUserId).collect(Collectors.toList());
                } else if ("4".equals(role)) {
                    userList =  tbtskUserReviewAreaService.queryListByTaskId(sourceTaskId).stream().map(TbtskUserReviewArea :: getUserId).collect(Collectors.toList());
                }*/
        } else {
            userList = Arrays.asList(userIds.split(","));
        }
        if (!userList.isEmpty()) {
            //添加角色
            for (String s : userList) {
                saveUserBiz(Long.valueOf(s), targetTaskId, Integer.parseInt(role));
            }
            //添加区域
            if ("1".equals(role)) {
                tbtskUserManageAreaService.copyTaskRoleByUserId(sourceTaskId, targetTaskId, userList);
            } else if ("3".equals(role)) {
                copyTaskRoleByUserId(sourceTaskId, targetTaskId, userList);
            } else if ("2".equals(role)) {
                tbtskUserAuditAreaService.copyTaskRoleByUserId(sourceTaskId, targetTaskId, userList);
            } else if ("4".equals(role)) {
                tbtskUserReviewAreaService.copyTaskRoleByUserId(sourceTaskId, targetTaskId, userList);
            }else if ("5".equals(role)) {
                tbtskSuperUserAuditAreaService.copyTaskRoleByUserId(sourceTaskId, targetTaskId, userList);
            }else if ("6".equals(role)) {
                tbtskUserUploadAreaService.copyTaskRoleByUserId(sourceTaskId, targetTaskId, userList);
            }
            //添加记录
            TbtsktaskCopy tbtsktaskCopy = new TbtsktaskCopy();
            tbtsktaskCopy.setOperId(userId);
            tbtsktaskCopy.setRole(role);
            tbtsktaskCopy.setSourceTaskId(sourceTaskId);
            tbtsktaskCopy.setTargetTaskId(targetTaskId);
            tbtsktaskCopy.setUserIds(userIds);
            tbtsktaskCopy.setType(1);
            tbtsktaskCopy.setCreateTime(new Timestamp(System.currentTimeMillis()));
            tbtsktaskCopyRepository.save(tbtsktaskCopy);
        }
    }

    /**
     * 作业员增加作业区
     *
     * @param sourceTaskId
     * @param targetTaskId
     * @param userList
     */
    public void copyTaskRoleByUserId(String sourceTaskId, String targetTaskId, List<String> userList) {
        List<Object[]> list = tbtsktaskCopyRepository.findUserIdByXzqdms(sourceTaskId, userList);
        if (!list.isEmpty()) {
            Map<String, Set<String>> regionMap = new HashMap<>();
            for (int i = 0; i < list.size(); i++) {
                TskRightArea bean = new TskRightArea();
                Object[] obj = (Object[]) list.get(i);
                bean.setTaskId(targetTaskId);
                bean.setXzqdm(obj[1].toString());
                bean.setUserId(obj[0].toString());
                //判断是否已存在
                List<TskRightArea> tskRightAreas = tskRightAreaRepository.findByTaskIdAndUserIdAndXzqdm(targetTaskId, bean.getUserId(), bean.getXzqdm());
                if (tskRightAreas.isEmpty()) {
                    tskRightAreaRepository.save(bean);
                    Set<String> regionSet = null;
                    if (regionMap.containsKey(obj[0].toString())) {
                        regionSet = regionMap.get(obj[0].toString());
                    } else {
                        regionSet = new HashSet<>();
                        regionMap.put(obj[0].toString(), regionSet);
                    }
                    regionSet.add(obj[1].toString());
                }
            }
            regionMap.forEach((key, value) -> {
                this.changeRightArea(targetTaskId, key, StringUtils.joinSet(value, ","));
            });
        }
    }

    public List<TbtskGroup> getGroupByTableName(String tableName) {
        GutilAssert.hasLength(tableName, "参数错误");
        return tbtskGroupRepository.findByFTablename(tableName);
    }

    public List<TskTaskBiz> queryTaskTranslateTargetTaskList(String taskId) {

        List<TskTaskBiz> retVal = new ArrayList<>();

        Iterable<TskTaskBiz>  iterable = tskTaskBizRepository.findAll();
        Iterator<TskTaskBiz>tskTaskBizList = iterable.iterator();
        while (tskTaskBizList.hasNext()) {
            TskTaskBiz biz=  tskTaskBizList.next();
            /*
            if(biz.getId().equals(taskId)||(biz.getIsDel()!=null&&biz.getIsDel()>0))
            {
                continue;
            }
            */
            if(biz.getIsDel()!=null&&biz.getIsDel()>0)
            {
                continue;
            }
            retVal.add(biz);

        }
        return retVal;
    }

    public Map<String, Object> getTbSheet(List<String> tfs1, List<Map> tbList, Map<String, String> colums1) {
        Map<String, Object> map1 = new HashMap<>();

        for (Map map : tbList) {
            int status = (int) map.get("f_status");
            map.put("f_status", getTbStatus(status));
        }

        String sheetname1 = "图斑列表";

        colums1.put("assignUserId", "外业人员ID");
        colums1.put("assignUserName", "外业人员");
        tfs1.add(0, "assignUserId");
        tfs1.add(1, "assignUserName");
        map1.put("mapList", tbList);
        map1.put("sortedHeaders", tfs1);
        map1.put("columnNameToHeaderMap", colums1);
        map1.put("sheetName", sheetname1);
        return map1;
    }

    private String getTbStatus(int status) {
        switch (status) {
            case 1:
                return "未下发";
            case 2:
                return "未提交";
            case 4:
                return "已提交";
            case 5:
                return "已退回";
            case 6:
                return "已完成";
            default:
                return "未知状态";
        }
    }

    public Map<String, Object> getAssignUserSheet(TskTaskBiz tskTaskBiz, Long userid) {
        Map<String, Object> map1 = new HashMap<>();

        String bizArea = "";
        List<String> areas = landUser2AreaRepository.queryAreas(userid);
        if (areas != null && areas.size() > 0) {
            bizArea = areas.get(0);
        }
        if ("1".equalsIgnoreCase(bizArea)) {
            bizArea = "";
        } else if (bizArea.endsWith("0000")) {
            bizArea = bizArea.substring(0, 2);
        } else if (bizArea.endsWith("00")) {
            bizArea = bizArea.substring(0, 4);
        }
        Long count = landUserRepository.getUsersByBizIdAndBizAreaCount(tskTaskBiz.getId(), "%%", "%%", bizArea + "%");
        List<LandUser> list = landUserRepository.getUsersByBizIdAndBizArea(tskTaskBiz.getId(), "%%", "%%", bizArea + "%", Math.toIntExact(count), 0);

        List result = new ArrayList();
        for (LandUser user1 : list) {
            LandUser user = new LandUserBuilder(user1).regionFullName().organization().hidePhone().build();
            if(org.apache.commons.lang3.StringUtils.isNotBlank(tskTaskBiz.getId())){
                List<User2Biz> user2Bizs = user2BizRepository.getByBizidAndUserid(tskTaskBiz.getId(), user.getId());
                String bizRole = "";
                for (int j = 0; j < user2Bizs.size(); j++) {
                    if (user2Bizs.get(j).getRole() == null) {
                        continue;
                    }
                    if (org.apache.commons.lang3.StringUtils.isNotBlank(bizRole)) {
                        bizRole += "," + user2Bizs.get(j).getRole();
                    } else {
                        bizRole = user2Bizs.get(j).getRole() + "";
                    }
                }
                user.setBizRole(bizRole);
            }
            JSONObject jsonObject = JSONObject.parseObject(JSON.toJSONString(user));
            String bizRole = jsonObject.getString("bizRole");
            String role = "";
            if (bizRole.contains("0") || bizRole.contains("1")) {
                role = "管理员";
            }
            if (bizRole.contains("3")) {
                role += (role.length() > 0 ? "," : "") + "作业员";
            }
            jsonObject.put("role", role);
            result.add(jsonObject);
        }


        List<String> tfs1 = new ArrayList<>();
        tfs1.add("id");
        tfs1.add("name");
        tfs1.add("rname");
        tfs1.add("regionFullName");
        tfs1.add("depId");
        tfs1.add("userType");
        tfs1.add("role");
        Map<String, String> colums1 = new HashMap<>();
        colums1.put("id", "用户id");
        colums1.put("name", "用户名");
        colums1.put("rname", "真实姓名");
        colums1.put("regionFullName", "所属政区");
        colums1.put("depId", "用户单位");
        colums1.put("userType", "用户类别");
        colums1.put("role", "用户权限");


        String sheetname1 = "下发用户";
        map1.put("mapList", result);
        map1.put("sortedHeaders", tfs1);
        map1.put("columnNameToHeaderMap", colums1);
        map1.put("sheetName", sheetname1);
        return map1;
    }


    /**
     * 从excel中读取数据
     *
     * @param excelFile
     * @throws Exception
     */
    public Map<String, List<String>> parseExcel(String excelFile, String bizId) throws Exception {
        Workbook workbook = null;
        OutputStream out = null;

        Map<String, List<String>> data = new HashMap<>();
        try {
            List<String> bizUsers = this.getBizUsers(bizId);
            File file = new File(excelFile);
            InputStream inputStream = new FileInputStream(file);

            File parentFile = file.getParentFile();
            if (parentFile != null && (!parentFile.exists())) {
                parentFile.mkdirs();
            }
            //这种方式 Excel 2003/2007/2010 都是可以处理的
            workbook = WorkbookFactory.create(inputStream);
            inputStream.close();

            Sheet sheet = workbook.getSheetAt(0);
            int lastRowNum = sheet.getLastRowNum();
            if(lastRowNum > 5001){
                throw new RuntimeException("excel分发功能单次不能超过5000条记录，请对excel文件分幅后重新上传，当前分发操作无效。");
            }
            Row row = sheet.getRow(0);
            int colNumber = row.getPhysicalNumberOfCells();
            int rowCount = sheet.getPhysicalNumberOfRows();

            //sysFaqDao.deleteAll();
            for (int i = 1; i < rowCount; i++) {
                row = sheet.getRow(i);
                if (row == null) {
                    continue;
                }
                try {
                    boolean find = false;
                    String userid = findCellValue(row.getCell(0));
                    if(org.apache.commons.lang3.StringUtils.isEmpty(userid)){
                        continue;
                    }
                    for (Object bizUser : bizUsers) {
                        if(bizUser.toString().equals(userid)){
                            find = true;
                        }
                    }
                    if(!find){
                        String username = findCellValue(row.getCell(1));
                        throw new RuntimeException("第" + (i+1) + "行用户：" + username + "，无任务权限");
                    }
                    String tbid = findCellValue(row.getCell(2));
                    if (org.apache.commons.lang3.StringUtils.isNotEmpty(userid.trim()) && org.apache.commons.lang3.StringUtils.isNotEmpty(tbid)) {
                        List<String> list;
                        if (data.containsKey(userid)) {
                            list = data.get(userid);
                            list.add(tbid);
                        } else {
                            list = new ArrayList<String>(Arrays.asList(tbid));
                        }
                        data.put(userid, list);
                    }
                } catch (Exception e) {
                    if(e.getMessage().contains("无任务权限")){
                        throw e;
                    }else{
                        e.printStackTrace();
                        continue;
                    }
                }
            }

            out = new FileOutputStream(file);
            workbook.write(out);
            out.flush();
            out.close();
        } catch (Exception ex) {
            throw ex;
        }

        return data;
    }

    private String findCellValue(Cell cell) {
        String cellValue = "";
        if (cell == null) {
            return "";
        }
        try {
            org.apache.poi.ss.usermodel.CellType cellType = cell.getCellType();
            switch (cellType) {
                case STRING: //文本
                    cellValue = cell.getStringCellValue();
                    break;
                case NUMERIC: //数字、日期
                    if (DateUtil.isCellDateFormatted(cell)) {
                        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd");
                        cellValue = fmt.format(cell.getDateCellValue()); //日期型
                    } else {
                        cellValue = String.valueOf((long) cell.getNumericCellValue()); //数字
                    }
                    break;
                case BOOLEAN: //布尔型
                    cellValue = String.valueOf(cell.getBooleanCellValue());
                    break;
                case BLANK: //空白
                    cellValue = cell.getStringCellValue();
                    break;
                case ERROR: //错误
                    cellValue = "错误";
                    break;
                case FORMULA: //公式
                    cellValue = "错误";
                    break;
                default:
                    cellValue = "错误";
            }
        } catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
        return cellValue.trim();
    }

    public List<String> getBizUsers(String bizId) {
        List<String> usersByBizIdAndBizArea = landUserRepository.getUsersByBizIdAndBizArea(bizId, "%%", "%%", "50%");

        return usersByBizIdAndBizArea;
    }


    public List<RegionDto> getUserRoleAreas(String taskId, Long userId, Integer role, String version) {
        List<RegionDto> areaLists = new ArrayList<>();
        if (role == UserRoleEnum.CREATOR.getCode()) {
            List<RegionDto> list = userAreaService.userRoleRegions(landUserService.queryUserAreas(userId), version);
            areaLists = list;
        } else if (role == UserRoleEnum.MANAGER.getCode()) {
            List<TbtskUserManageArea> list = tbtskUserManageAreaService.listManageAreas(taskId, userId.toString());
            List<RegionDto> list1 = userAreaService.userRoleRegions(list.stream().map(e -> e.getRegioncode()).collect(Collectors.toList()), version);
            areaLists = list1;
        } else if (role == UserRoleEnum.AUDITOR.getCode()) {
            List<TbtskUserAuditArea> list = tbtskUserAuditAreaService.listAuditAreas(taskId, userId.toString());
            List<RegionDto> list1 = userAreaService.userRoleRegions(list.stream().map(e -> e.getRegionCode()).collect(Collectors.toList()), version);
            areaLists = list1;
        } else if (role == UserRoleEnum.SUPERAUDITOR.getCode()) {
            List<TbtskSuperUserAuditArea> list = tbtskSuperUserAuditAreaService.listAuditAreas(taskId, userId.toString());
            List<RegionDto> list1 = userAreaService.userRoleRegions(list.stream().map(e -> e.getRegionCode()).collect(Collectors.toList()), version);
            areaLists = list1;
        } else if (role == UserRoleEnum.REVIEWER.getCode()) {
            List<TbtskUserReviewArea> list = tbtkUserReviewAreaService.listReviewAreas(taskId, userId.toString());
            List<RegionDto> list1 = userAreaService.userRoleRegions(list.stream().map(e -> e.getRegionCode()).collect(Collectors.toList()), version);
            areaLists = list1;
        } else if (role == UserRoleEnum.OPERATOR.getCode()) {
            List<RegionDto> list = userAreaService.userRoleRegions(tskTaskBizService.findRightAreas(taskId, userId.toString()), version);
            areaLists = list;
        }else if (role == UserRoleEnum.UPLOADER.getCode()) {
            List<TbtskUserUploadArea> list = tbtskUserUploadAreaService.listManageAreas(taskId, userId.toString());
            List<RegionDto> list1 = userAreaService.userRoleRegions(list.stream().map(e -> e.getRegioncode()).collect(Collectors.toList()), version);
            areaLists = list1;
        }
        return areaLists;
    }


    /**
     * tongj用户任务相关数据
     * @param userId
     * @param type
     * @return
     */
    public JSONObject getMyTaskStatistical(Long userId,String type){
        //获取全部数据
        JSONObject object = new JSONObject();
        Integer taskTotalNum = 0;
        Integer taskTBTotalNum = 0;
        Integer taskMedTpTotalNum = 0;
        Integer taskMedSpTotalNum = 0;
        Calendar cal = Calendar.getInstance();
        String start = "";
        String end =  "";

        if("1".equals(type)){
            //获取今年
            int year = cal.get(Calendar.YEAR);
             start = year +"-01-01 00:00:00";
             end = year +"-12-31 23:59:59";
        }else if("2".equals(type)){
            //获取本季度
             start = getCurrentQuarterStartTime();
              end = getCurrentQuarterEndTime();
        }else if("3".equals(type)){
            //获取本月
             start = getFisrtDayOfMonth(cal.get(Calendar.YEAR), cal.get(Calendar.MONTH) + 1);
              end = getLastDayOfMonth(cal.get(Calendar.YEAR), cal.get(Calendar.MONTH) + 1);
        }
        //任务总数
        String yearsql = "select aa.f_bizid from (select *,ROW_NUMBER ( ) OVER ( PARTITION BY tub.f_bizid ORDER BY tub.f_bizid  ) AS group_idx " +
                "from tbsys_user_biz2 tub, tbtsk_task_biz ttb " +
                " where tub.f_bizid  = ttb.f_id and tub.f_userid='"+userId+"' and ttb.f_createtime between '"+
                start +"' and '" + end +"' and ttb.f_isdel  is null ) aa where aa.group_idx=1 ";
        List<Map<String, Object>> taskMap = jdbcTemplate.queryForList(yearsql);
        taskTotalNum = taskMap.size();
        if(taskMap.size() > 0 ){
            //下发数据sql
            String assignCount = "select count(distinct tar.f_dataid) from tbtsk_assign_record tar  where f_taskid in ("+yearsql+") and " +
                    "f_assignto ='"+userId+"';";
            Integer count = jdbcTemplate.queryForObject(assignCount, Integer.class);
            taskTBTotalNum = count;
            //附件数量 1 图片 2 视频
            String medCount = " select f_type,count(1) from tb_app_media tam  where f_bizid  in ("+yearsql+") group by" +
                    " f_type having f_type in (1,2); ";
            List<Map<String, Object>> medCountmap = jdbcTemplate.queryForList(medCount);
            for(Map<String, Object> map1 :medCountmap){
                //status 0 未处理  1 已处理
                if(map1.get("f_type") != null && map1.get("f_type").toString().equals("1")){
                    taskMedTpTotalNum += Integer.valueOf(map1.get("count").toString());
                }else{
                    taskMedSpTotalNum += Integer.valueOf(map1.get("count").toString());
                }
            }
        }
        object.put("taskTotalNum",taskTotalNum);
        object.put("taskTBTotalNum",taskTBTotalNum);
        object.put("taskMedTpTotalNum",taskMedTpTotalNum );
        object.put("taskMedSpTotalNum",taskMedSpTotalNum );
        return object;

    }

    /**
     * 获取用户任务详情数据
     * @param userId
     * @param type
     * @return
     */
    public List<Map<String, Object>> getMyTaskDetailsStatistical(Long userId,String type){
        //获取全部数据
        Calendar cal = Calendar.getInstance();
        String start = "";
        String end =  "";
        if("1".equals(type)){
            //获取今年
            int year = cal.get(Calendar.YEAR);
            start = year +"-01-01 00:00:00";
            end = year +"-12-31 23:59:59";
        }else if("2".equals(type)){
            //获取本季度
            start = getCurrentQuarterStartTime();
            end = getCurrentQuarterEndTime();
        }else if("3".equals(type)){
            //获取本月
            start = getFisrtDayOfMonth(cal.get(Calendar.YEAR), cal.get(Calendar.MONTH) + 1);
            end = getLastDayOfMonth(cal.get(Calendar.YEAR), cal.get(Calendar.MONTH) + 1);
        }

        String taskClassSql = "select ttc.f_id ,ttc.f_name,count(1)  from tbtsk_task_class ttc ,tbtsk_user_task_class" +
                "  tutc  where ttc.f_id  = tutc.f_classid \n" +
                " and ttc.f_parentid ='-1' and tutc.f_userid ='"+userId+"' group by ttc.f_id ,ttc.f_name;";
        List<Map<String, Object>> taskClassmap = jdbcTemplate.queryForList(taskClassSql);
        for(Map<String, Object> map1 :taskClassmap){
            if(map1.get("f_id") != null ) {
                String classId = map1.get("f_id").toString();
                List<Long> classIds = new ArrayList<>();
                classIds.add(Long.valueOf(classId));
                mTbtskTaskClassService.queryClassIdByParentId(Long.valueOf(classId),classIds);
                //任务总数
                String yearsql = "select aa.f_bizid from (select *,ROW_NUMBER ( ) OVER ( PARTITION BY tub.f_bizid ORDER BY tub.f_bizid  ) AS group_idx " +
                        " from tbsys_user_biz2 tub, tbtsk_task_biz ttb " +
                        " where tub.f_bizid  = ttb.f_id and tub.f_userid='"+userId+"'  and ttb.f_classid in ("+ GutilStr.join(classIds,",") +
                        ") and ttb.f_createtime between '"+ start +"' and '" + end +"' and ttb.f_isdel  is null ) aa " +
                        " where aa.group_idx=1 ";
                List<Map<String, Object>> taskMap = jdbcTemplate.queryForList(yearsql);
                map1.put("taskNum",taskMap.size());
                if(taskMap.size() > 0 ){
                    //下发数据sql
                    String assignCount = "select count(distinct tar.f_dataid) from tbtsk_assign_record tar  where f_taskid in ("+yearsql+") and " +
                            "f_assignto ='"+userId+"';";
                    Integer count = jdbcTemplate.queryForObject(assignCount, Integer.class);
                    map1.put("taskTBNum",count);

                    //附件数量 1 图片 2 视频
                    String medCount = " select f_type,count(1) from tb_app_media tam  where f_bizid  in ("+yearsql+") group by" +
                            " f_type having f_type in (1,2); ";
                    List<Map<String, Object>> medCountmap = jdbcTemplate.queryForList(medCount);
                    if(medCountmap.size() > 0 ){
                        for(Map<String, Object> map2 :medCountmap){
                            //status 0 未处理  1 已处理
                            if(map1.get("f_type") != null && map2.get("f_type").toString().equals("1")){
                                map1.put("taskMedTpNum",Integer.valueOf(map2.get("count").toString()));
                            }else{
                                map1.put("taskMedSpNum",Integer.valueOf(map2.get("count").toString()));
                            }
                        }
                    }else{
                        map1.put("taskMedTpNum",0);
                        map1.put("taskMedSpNum",0);
                    }
                }else{
                    map1.put("taskTBNum",0);
                    map1.put("taskMedTpNum",0);
                    map1.put("taskMedSpNum",0);
                }
            }
        }
        List<Map<String, Object>> list = taskClassmap.stream().sorted((e1, e2) -> {
            // 升序
            // return Integer.compare((Integer) e1.get("id"), (Integer) e2.get("id"));
            // 降序
            return -Integer.compare((Integer) e1.get("taskNum"), (Integer) e2.get("taskNum"));
        }).collect(Collectors.toList());
        return list;

    }

    public void  zhjgTaskFocus(Long userId,String taskId,String tbIds,String zdgz,String gzlx){
        TskTaskBiz taskBiz = findByTaskId(taskId);
        TbtskObjectinfo tableInfo = mTbtskObjectinfoService.getObjectbyID(taskBiz.getTableId());
        List<String> idList = Arrays.asList(tbIds.split(","));
          String sql = " update "+tableInfo.getfTablename() + " set f_zdgz = '"+zdgz+"' ,f_gzlx =  '"+gzlx+"' where " +
                  "f_id in ("+idList.stream().map(n -> String.valueOf(n)).collect(Collectors.joining("', '", "'",
                  "'"))+")";
          if(org.apache.commons.lang3.StringUtils.isBlank(zdgz)){
               sql = " update "+tableInfo.getfTablename() + " set f_zdgz = null,f_gzlx = null  where " +
                      "f_id in ("+idList.stream().map(n -> String.valueOf(n)).collect(Collectors.joining("', '", "'",
                      "'"))+")";
          }
       // String ids = idList.stream().map(n -> String.valueOf(n)).collect(Collectors.joining("', '", "'", "'"));
         mDataBizService.excuteSql(sql);
    }


    public static String getFisrtDayOfMonth(int year,int month){
        Calendar cal = Calendar.getInstance();
        //设置年份
        cal.set(Calendar.YEAR,year);
        //设置月份
        cal.set(Calendar.MONTH, month-1);

        //获取某月最小天数
        int firstDay = cal.getActualMinimum(Calendar.DAY_OF_MONTH);
        //设置日历中月份的最小天数
        cal.set(Calendar.DAY_OF_MONTH, firstDay);

        cal.set(Calendar.HOUR_OF_DAY, 0);
        cal.set(Calendar.MINUTE, 0);
        cal.set(Calendar.SECOND, 0);

        //格式化日期
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String firstDayOfMonth = sdf.format(cal.getTime());
        return firstDayOfMonth;
    }


    public static String getLastDayOfMonth(int year,int month)
    {
        Calendar cal = Calendar.getInstance();
        //设置年份
        cal.set(Calendar.YEAR,year);
        //设置月份
        cal.set(Calendar.MONTH, month-1);
        //获取某月最大天数
        int lastDay = cal.getActualMaximum(Calendar.DAY_OF_MONTH);
        //设置日历中月份的最大天数
        cal.set(Calendar.DAY_OF_MONTH, lastDay);

        cal.set(Calendar.HOUR_OF_DAY, 23);
        cal.set(Calendar.MINUTE, 59);
        cal.set(Calendar.SECOND, 59);
        //格式化日期
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String lastDayOfMonth = sdf.format(cal.getTime());
        return lastDayOfMonth;
    }


    /**
     * 当季开始时间
     * @return
     */
    public static String getCurrentQuarterStartTime() {
        Calendar c = Calendar . getInstance();
        int currentMonth = c. get (Calendar .MONTH) + 1;
        Date now = null;
        try {
            if (currentMonth >= 1 && currentMonth <= 3)
                c.set(Calendar.MONTH,0) ;
            else if (currentMonth >= 4 && currentMonth <= 6)
                c.set(Calendar . MONTH,3) ;
            else if ( currentMonth >= 7 && currentMonth <= 9)
                c.set(Calendar . MONTH,4);
            else if ( currentMonth >= 10 && currentMonth <= 12)
                c.set(Calendar . MONTH,9);
        } catch (Exception e) {
            e.printStackTrace() ;
        }
        //格式化日期
        c.set(Calendar.DATE,1) ;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String  time = sdf.format(c.getTime())+ " 00:00:00";
        return time;
    }

    /**
     * 当季结束时间
     * @return
     */
    public static String getCurrentQuarterEndTime() {
        Calendar c = Calendar . getInstance();
        int currentMonth = c. get (Calendar .MONTH) + 1;
        Date now = null;
        try {
            if (currentMonth >= 1 && currentMonth <= 3){
                c.set(Calendar.MONTH,2) ;
                c.set(Calendar.DATE,31) ;
            } else if (currentMonth >= 4 && currentMonth <= 6){
                c.set(Calendar.MONTH,5) ;
                c.set(Calendar.DATE,31) ;
            }else if ( currentMonth >= 7 && currentMonth <= 9){
                c.set(Calendar.MONTH,8) ;
                c.set(Calendar.DATE,31) ;
            } else if ( currentMonth >= 10 && currentMonth <= 12){
                c.set(Calendar.MONTH,11) ;
                c.set(Calendar.DATE,31) ;
            }
        } catch (Exception e) {
            e.printStackTrace() ;
        }
        //格式化日期
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String  time = sdf.format(c.getTime()) +"  23:59:59";
        return time;
    }

    /**
     * 将字符串转为时间戳
     * @param time
     * @return
     */
    public static Long converTime(String time ) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Long resulttime = 0L;
        try {
            Date date = format.parse(time);
            resulttime = date.getTime();
        } catch (java.text.ParseException e) {
            e.printStackTrace();
        }
        return resulttime;
    }


    public JSONObject clipGeomTbInfo(Long userId, TskTaskBiz tskTaskBiz, String tbId, String tbInfo,String splicType) throws
            Exception {
        //默认图斑分割后下发图斑到当前用户
        return clipGeomTbInfo(userId, tskTaskBiz, tbId, tbInfo, true, false, splicType);
    }

    /***
     *
     * @param userId
     * @param tskTaskBiz
     * @param tbId
     * @param tbInfo
     * @param assignRecord 图斑分割后是否下发图斑到当前用户
     * @return
     */
    @Transactional(rollbackFor = Exception.class)
    public JSONObject clipGeomTbInfo(Long userId, TskTaskBiz tskTaskBiz, String tbId, String tbInfo, Boolean assignRecord, Boolean copyMedia,String splicType) throws Exception {
        if(org.apache.commons.lang3.StringUtils.isBlank(tskTaskBiz.getConfigArgs()) ){
            throw new GwValidateException("该任务不支持图斑分割");
        }
        JSONObject configArgs = JSONObject.parseObject(tskTaskBiz.getConfigArgs());
        if((configArgs.get("allowWebSplitSpot") != null && configArgs.getInteger("allowWebSplitSpot")==1)|| (configArgs.getInteger("allowAppSplitSpot") != null && configArgs.getInteger("allowAppSplitSpot")==1)) {

        JSONObject result = new JSONObject();
        List<String> updateAreaId = new ArrayList<>();
        try {
            //获取任务的详细信息
            TbtskObjectinfo tbtskObjectinfo = tbtskObjectinfoRepository.getObjectByTableId(tskTaskBiz.getTableId());
            List<TbtskFields> tbtskFields = tbtskFieldsRepository.getTbtskFieldsByTableid(tskTaskBiz.getTableId());
            List<String> fields = new ArrayList<>();
            for (TbtskFields f : tbtskFields) {
                fields.add(f.getfFieldname());
            }
            //是否是子图斑
            boolean isSubTb = false;
            boolean isChild = false;
            String f_splitedid = tbId;
            String tableName = tbtskObjectinfo.getfTablename();
            Map currObj = mDataBizService.selectFieldByID(tbtskObjectinfo.getfTablename(), fields, "f_id", "'" + tbId + "'");
            if(currObj != null){
                /*if (org.apache.commons.collections.MapUtils.getInteger(currObj, "f_status", 1) >= 10) {
                    throw new GwValidateException("图斑已提报，不允许分割");
                }*/
            }else{  //子图斑数据
                currObj = mDataBizService.selectFieldByID(tbtskObjectinfo.getSplitTableName(), fields, "f_id", "'" + tbId + "'");
               /* if (org.apache.commons.collections.MapUtils.getInteger(currObj, "f_status", 1) >= 10) {
                    throw new GwValidateException("图斑已提报，不允许分割");
                }*/
                tableName = tbtskObjectinfo.getSplitTableName();
                isChild = true;
                isSubTb = true;
                f_splitedid = org.apache.commons.collections.MapUtils.getString(currObj,"f_splitedid", "");
            }
            if (tbtskObjectinfo != null) {
               /* if (org.apache.commons.collections.MapUtils.getString(currObj, "f_issplitted", "0").equals("1") && org.apache.commons.collections.MapUtils.getString(currObj, "f_splitedid", "0").equals("0")) {//原始图斑
                    //已经切割的图斑重新切割则进行删除已分割的子图斑
                    String subTbIdsStr = currObj.get("f_id") + "";
                    List<Map> subTbs = mDataBizService.queryAllData(tableName, new ArrayList<String>() {{ add("f_id"); }}, " f_splitedid like '" + subTbIdsStr + "'");
                    if (subTbs != null && subTbs.size() > 0) {
                        for (Map subtb : subTbs) {
                            if (subtb.get("f_id") != null) {
                                mDataBizService.delete(tableName, "f_id", subtb.get("f_id").toString());
                                appMediaRepository.deleteByGalleryid(subtb.get("f_id").toString());
                            }
                        }
                    }
                }


                if (currObj.containsKey("f_splitedid") && org.apache.commons.lang3.StringUtils.isNotEmpty(org.apache.commons.collections.MapUtils.getString(currObj, "f_splitedid", ""))) {
                    isSubTb = true;
                }*/
                List<Map> objs = new ArrayList<>();
                //获取动态生成的表明
                JSONObject jsonObject = JSONObject.parseObject(tbInfo);
                if (jsonObject.getJSONArray("wkts") != null) {
                    JSONArray wkts = jsonObject.getJSONArray("wkts");
                    if (wkts != null && wkts.size() > 0) {
                        Integer index = 1;
                        String splitFieldsStr = configArgs.getString("splitFields");
                        String[] splitFields = new String[0];
                        if (org.apache.commons.lang3.StringUtils.isNotEmpty(splitFieldsStr)) {
                            splitFields = splitFieldsStr.split(",");
                            Map<String, Object> map = new HashMap<>();
                            for (String splitField : splitFields) {
                                map.put(splitField, currObj.get(splitField));
                            }
                            map.put("f_id", currObj.get("f_id"));
                            map.put("f_shape", currObj.get("f_shape").toString());
                            result.put("tbInfo", map);
                            if (isSubTb) {
                                Map<String, Object> map2 = new HashMap<>();
                                for (String key : map.keySet()) {
                                    map2.put(key, map.get(key));
                                }
                                map2.put("f_shape", wkts.get(0).toString());
                                objs.add(map2);
                            }
                        } else {
                            result.put("tbInfo", currObj);
                            if (isSubTb) {
                                objs.add(currObj);
                            }
                        }
                        String f_pid = org.apache.commons.collections.MapUtils.getString(currObj,"f_pid", "");
                        List<Map> subTbs = getSubTbIndexs(Arrays.asList(splitFields), tbtskObjectinfo, currObj,  isSubTb,splicType);
                        int start = 0;
                        int curCutCount = 0;//当前子图斑已有数量
                        if (isSubTb) {//如果有子图斑，被分割的是子图斑，第一个wkt更新被分割的子图斑，
                            if("1".equals(splicType)){ //
                                start = 1;        //如果没有子图斑，被分割的是原始图斑，所有wkt被分别生成子图斑
                                updateGeomInfo(tbtskObjectinfo, tskTaskBiz, currObj, wkts.get(0).toString());
                                int num = mDataBizService.updateData(tableName, currObj, " f_id = '" + currObj.get("f_id") + "'");
                                if (num < 0) {
                                    throw new GwValidateException("更新被分割子图斑失败");
                                }
                                updateAreaId.add(currObj.get("f_id").toString());
                                curCutCount = mDataBizService.getCount(tableName, " f_splitedid = '" + currObj.get("f_splitedid") + "'");
                            }else if("2".equals(splicType)){ //多部件内单部件进行分割
                                if(org.apache.commons.lang3.StringUtils.isNotBlank(f_pid)){//判断是否是三级子图斑
                                    //如果是多部件三级子图斑继续分割就需要处理
                                    start = 1;        //如果没有子图斑，被分割的是原始图斑，所有wkt被分别生成子图斑
                                    updateGeomInfo(tbtskObjectinfo, tskTaskBiz, currObj, wkts.get(0).toString());
                                    int num = mDataBizService.updateData(tableName, currObj, " f_id = '" + currObj.get("f_id") + "'");
                                    if (num < 0) {
                                        throw new GwValidateException("更新被分割子图斑失败");
                                    }
                                    updateAreaId.add(currObj.get("f_id").toString());
                                    curCutCount = mDataBizService.getCount(tableName, " f_pid = '" + currObj.get("f_pid") + "'");
                                }else{
                                    //多部件内单部件进行分割的二级子图斑分割三级数据,则二级数据保持不变
                                    String sql = " update "+tbtskObjectinfo.getSplitTableName() +" set f_issplitted = '1' where f_id ='"+tbId+"'";
                                    jdbcTemplate.update(sql);
                                }
                            }
                        }

                        for (int j = start; j < wkts.size(); j++) {
                            Map temp = new HashMap();
                            Object wkt = wkts.get(j);
                            Map newObj = JSONObject.parseObject(JSONObject.toJSONString(currObj));

                           /* if (!subTbs.isEmpty()) {
                                index = getIndex(subTbs, index, splitFields);
                            }*/
                            if (!subTbs.isEmpty() && !isSubTb) {
                                index = getIndex(subTbs, index, splitFields);
                            } else if (isSubTb) {
                                curCutCount++;
                                index = curCutCount;
                            }
                            String newID = UUID.randomUUID().toString();
                            temp.put("f_id", newID);
                            temp.put("f_shape", wkt.toString());
                            newObj.put("f_id", newID);
                            newObj.put("f_createtime", new Date().getTime());
                            for (String splitField : splitFields) {
                                String newVal = newObj.get(splitField) + "_" + index;
                                if (isSubTb) {
                                    newVal = newObj.get(splitField).toString().substring(0, org.apache.commons.collections.MapUtils.getString(newObj, splitField, "").lastIndexOf("_")) + "_" + index;
                                    //查询编号是否存在
                                    String sql = "select count(1) from " + tableName + " where " + splitField + " = '" + newVal + "'";
                                    Integer integer = jdbcTemplate.queryForObject(sql, Integer.class);
                                    while (integer > 0) {
                                        index = index + 1;
                                        newVal = newVal.substring(0,newVal.indexOf("_")) + "_" + index;
                                        sql = "select count(1) from " + tableName + " where " + splitField + " = '" + newVal + "'";
                                        integer = jdbcTemplate.queryForObject(sql, Integer.class);
                                    }
                                  if("2".equals(splicType)  ){
                                      if(org.apache.commons.lang3.StringUtils.isBlank(f_pid)){
                                          //多部件二级子图斑生成的三级子图斑数据就直接加_index
                                          newVal =   newObj.get(splitField) + "_" + index;
                                      }else{
                                          //多部件三级子图斑数据再次分割数据
                                          newVal = newObj.get(splitField).toString().substring(0, org.apache.commons.collections.MapUtils.getString(newObj, splitField, "").lastIndexOf("_")) + "_" + index;
                                      }
                                  }
                                }
                                newObj.put(splitField, newVal);
                                temp.put(splitField, newVal);
                            }
                            newObj.put("f_requestid", null);
                            newObj.put("f_issplitted", null);
                            if (!isSubTb ) {
                                newObj.put("f_splitedid", tbId);
                            } else {
                                newObj.put("f_splitedid", currObj.get("f_splitedid"));
                                if("2".equals(splicType)  ){
                                    //多部件三级分割增加f_pid和f_ismultipart
                                    if(org.apache.commons.lang3.StringUtils.isBlank(f_pid)){
                                        newObj.put("f_ismultipart", "1");
                                        newObj.put("f_pid", tbId);
                                    }else{
                                        newObj.put("f_ismultipart", "1");
                                        newObj.put("f_pid",  currObj.get("f_pid"));
                                    }
                                }
                            }
                            newObj.put("f_status", org.apache.commons.collections.MapUtils.getObject(currObj, "f_status"));
                           updateGeomInfo(tbtskObjectinfo, tskTaskBiz, newObj, wkt.toString());
                            int num = mDataBizService.insertData(tbtskObjectinfo.getSplitTableName(), newObj, "f_shape");
                            if (num < 0) {
                                throw new GwValidateException("插入不成功");
                            }
                            index++;
                            objs.add(temp);
                            updateAreaId.add(newID);
                        }

                        if (!isSubTb) {
                         /*   JSONObject updatObjectInfo = new JSONObject();
                            updatObjectInfo.put("f_issplitted", 1);*/
                            //更新已分割字段
                          /*  String sql = mDataBizService.updateTbInfoSQL(tableName, updatObjectInfo, tbId, tbtskFields);*/
                            String sql = " update "+tbtskObjectinfo.getfTablename() +" set f_issplitted = '1' where f_id ='"+tbId+"'";
                            jdbcTemplate.update(sql);
                        }
                        result.put("subtbs", objs);

                    }
                }
            }

         /*   try {
                this.updateXZBYZB(updateAreaId, tbtskObjectinfo.getSplitTableName());
            } catch (Exception e) {
                logger.error("更新面积及XY坐标失败：" + e.getMessage());
                throw e;
            }*/

           //生成定时任务同步数据到app
//            if (assignRecord) {
//                JSONObject params = new JSONObject();
//                params.put("userId", userId);
//                params.put("tbId", isSubTb?f_splitedid:tbId);
//                params.put("bizId", tskTaskBiz.getId());
//                params.put("type", "splitGeom"); //分割
//                MTbtskFlowService.addTaskRecord(params, userId, JobConstants.JOB_TYPE_TASK_SPLIT_MERGE, tskTaskBiz.getId());
//            }
            return result;
        } catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        }else{
            throw new GwValidateException("该任务不支持图斑分割");
        }
    }

    public void updateXZBYZB(List<String> updateAreaId, String tablename) {

        int ssrid = 4490;
        SysConfig sysConfig = sysConfigService.findOne("spotTableSrid");
        if (null != sysConfig) {
            try {
                ssrid = Integer.parseInt(sysConfig.getValue());
            }catch (Exception e){

            }
        }
        String whereSql = "SELECT f_id,f_lon FROM " + tablename + " WHERE f_id in ('" + org.apache.commons.lang3.StringUtils.join(updateAreaId, "','") + "')";

        List<Map> mapList = mDataBizService.queryDataBySql(whereSql);
        for (Map map : mapList) {

            String f_id = org.apache.commons.collections.MapUtils.getString(map, "f_id");
            Double f_lon = org.apache.commons.collections.MapUtils.getDouble(map, "f_lon");
            Double f_lat = org.apache.commons.collections.MapUtils.getDouble(map, "f_lat");

            int srid = getSrid(f_lon, f_lat);

            String sql2 = "UPDATE " + tablename +
                    " SET f_tbmj = ( ST_Area ( ST_AsText ( ST_Transform ( st_geometryfromtext ( st_astext ( f_shape ), "+ ssrid + " ), " + srid + " ) ) ) * 0.0015 )," +
                  /*  "f_xzb = st_x ( ST_Transform ( st_geometryfromtext ( st_astext ( st_centroid ( f_shape ) ), "+ ssrid +" ), " + srid + " ) )," +
                    "f_yzb = st_y ( ST_Transform ( st_geometryfromtext ( st_astext ( st_centroid ( f_shape ) ), "+ ssrid +" ), " + srid + " ) )," +*/
                    "f_lon = st_x ( st_geometryfromtext ( st_astext ( st_centroid ( f_shape ) ) ))," +
                    "f_lat = st_y (st_geometryfromtext ( st_astext ( st_centroid ( f_shape ) ))) " +
                    " WHERE f_id = '" + f_id + "'";
            mDataBizService.excuteSql(sql2);
        }
    }

    private int getSrid(Double f_lon, Double f_lat) {

        int floor = (int) Math.floor(f_lon / 3);

        return Integer.parseInt(String.valueOf(4513 + floor - 25));


    }


    private List<Map> getSubTbIndexs(List<String> splitFields, TbtskObjectinfo tbtskObjectinfo, Map currObj) {

        String splitField = splitFields.get(0);

        String val = org.apache.commons.collections.MapUtils.getString(currObj, "f_id", "");
        String subTbIdsStr = val;
        return mDataBizService.queryAllData(tbtskObjectinfo.getfTablename(), splitFields, " f_splitedid = '" +
                subTbIdsStr + "'");
    }

    private List<Map> getSubTbIndexs(List<String> splitFields, TbtskObjectinfo tbtskObjectinfo, Map currObj, boolean isSubTb,String splicType) {
        String fieldName = "f_id";
        if(isSubTb){
            if("2".equals(splicType)){
                fieldName = "f_pid";
            }else{
                fieldName = "f_splitedid";
            }
        }
        String parentField = "f_splitedid";
        if("2".equals(splicType)){
            parentField =  "f_pid";
        }
        String subTbIdsStr = org.apache.commons.collections.MapUtils.getString(currObj,fieldName, "");
        //多部件单图斑数据第一次分割，使用f_pid是获取不到数据，应该使用数据的f_id作为第三级子图斑的父id，第三级子图斑再次分割就可以找到对应的f_pid数据
        if(org.apache.commons.lang3.StringUtils.isBlank(subTbIdsStr) && "2".equals(splicType)){
            fieldName = "f_id";
            subTbIdsStr = org.apache.commons.collections.MapUtils.getString(currObj,fieldName, "");
        }
        return mDataBizService.queryAllData(tbtskObjectinfo.getSplitTableName(), splitFields,  parentField +" = '"  + subTbIdsStr + "'");
    }

    private Integer getIndex(List<Map> subTbs, Integer index, String[] splitFields) {
        String splitField = splitFields[0];
        for (int i = index; i < MAX_SUBTB_INDEX; i++) {
            int finalI = i;
            boolean b = subTbs.stream().anyMatch(item -> item.get(splitField).toString().endsWith(String.valueOf(finalI)));
            if (!b) {
                return finalI;
            }

        }
        return index;
    }

    public void updateGeomInfo(TbtskObjectinfo table, TskTaskBiz tskTaskBiz, Map newObj, String wkt) {
        WKTReader wr = new WKTReader();
        DecimalFormat format = new DecimalFormat("######0.0000000");
        try {
            Geometry geo = wr.read(wkt);
            if (newObj.containsKey("f_shape")) {
               /* newObj.put("f_shape", wkt);*/
                newObj.put("f_shape", "SRID=4490;"+wkt);
                Geometry pt = geo.getCentroid();
                int proNum = getColNum(((Point) pt).getX());
                String areasql = "select st_area(ST_Transform(ST_GeomFromText('" + WKTUtil.geomToWkt(geo) + "',4490)," + proNum + "))/666.6666667 as area";
                Map<String, Object> areaMap = jdbcTemplate.queryForMap(areasql);
                String area = areaMap.get("area").toString();
                newObj.put("f_tbmj", new BigDecimal(Double.valueOf(area)));

                if (newObj.containsKey("f_shape1"))
                   /* newObj.put("f_shape1", wkt);*/
                  newObj.put("f_shape1", "SRID=4490;"+wkt);
                if (table.getfSpatialtype() != null && table.getfSpatialtype().equals("1")) {
                    if (geo.getGeometryType().equals("Point")) {
                        newObj.put("f_lat", format.format(((Point) geo).getY()));
                        newObj.put("f_lon", format.format(((Point) geo).getX()));
                    } else {
                        Point point = geo.getCentroid();
                        if (point != null) {
                            newObj.put("f_lat", format.format(point.getY()));
                            newObj.put("f_lon", format.format(point.getX()));
                        } else {
                            newObj.put("f_lat", "0.0");
                            newObj.put("f_lon", "0.0");
                        }
                    }
                } else {
                    Point point = geo.getCentroid();
                    if (point != null) {
                        newObj.put("f_lat", format.format(point.getY()));
                        newObj.put("f_lon", format.format(point.getX()));
                    } else {
                        newObj.put("f_lat", "0.0");
                        newObj.put("f_lon", "0.0");
                    }
                }
                //如果图斑编号不存在则进行自动赋值
//                if (newObj.containsKey("f_tbbh")) {
//                    JSONObject data = tbbhUtil.generateBgdcTbbhByBizId(tskTaskBiz.getId(), "DF", wkt);
//                    newObj.put("f_tbbh", data.getString("tbbh"));
//                }
              /*  if (newObj.containsKey("f_tbmj") && geo.getGeometryType().contains("Polygon")) {//计算面积可能有误
                    Point point = geo.getCentroid();
                    if (point != null && (point.getY() > 90 || point.getY() < -90 || point.getX() > 180 || point.getX() < -180)) {
                        newObj.put("f_tbmj", geo.getArea());
                    } else if (point.getY() <= 90 && point.getY() >= -90 && point.getX() <= 180 && point.getX() >= -180) {
                        newObj.put("f_tbmj", this.getGeometryArea(geo));
                    }
                }*/

            }
            if (newObj.containsKey("f_shape_g")) {
                // google
                if (table.getfSpatialtype() != null && table.getfSpatialtype().equals("1")) {
                    if (geo.getGeometryType().equals("Point")) {
                        Point point = converPoint((Point) geo, 1);
                       /* newObj.put("f_shape_g", WKTUtil.geomToWkt(point));*/
                        newObj.put("f_shape_g", "SRID=4490;"+WKTUtil.geomToWkt(point));
                        newObj.put("f_lat_g", format.format(((Point) point).getY()));
                        newObj.put("f_lon_g", format.format(((Point) point).getX()));
                    } else {
                        Geometry geometry_g = convertGeometry(geo, 1);
                       /* newObj.put("f_shape_g", WKTUtil.geomToWkt(geometry_g));*/
                        newObj.put("f_shape_g", "SRID=4490;"+WKTUtil.geomToWkt(geometry_g));
                        Point point_g = geometry_g.getCentroid();
                        newObj.put("f_lat_g", format.format(point_g.getY()));
                        newObj.put("f_lon_g", format.format(point_g.getX()));
                    }
                } else if (table.getfSpatialtype() != null && table.getfSpatialtype().equals("2")) {
                    if (geo.getGeometryType().equals("LineString")) {

                        LineString lineString1 = convertLineString1((LineString) geo, 1);
                       /* newObj.put("f_shape_g", WKTUtil.geomToWkt(lineString1));*/
                        newObj.put("f_shape_g", "SRID=4490;"+WKTUtil.geomToWkt(lineString1));
                        Point centroid = lineString1.getCentroid();
                        if (lineString1 != null) {
                            newObj.put("f_lat_g", format.format(centroid.getY()));
                            newObj.put("f_lon_g", format.format(centroid.getX()));
                        } else {
                            newObj.put("f_lat_g", "0.0");
                            newObj.put("f_lon_g", "0.0");
                        }
                    } else if (geo.getGeometryType().equals("MultiLineString")) {
                        Geometry multiLineString = convertMultiLineString((MultiLineString) geo, 2);
                      /*  newObj.put("f_shape_g", WKTUtil.geomToWkt(multiLineString));*/
                        newObj.put("f_shape_g", "SRID=4490;"+WKTUtil.geomToWkt(multiLineString));
                        Point centroid = multiLineString.getCentroid();
                        if (multiLineString != null) {
                            newObj.put("f_lat_g", format.format(centroid.getY()));
                            newObj.put("f_lon_g", format.format(centroid.getX()));
                        } else {
                            newObj.put("f_lat_g", "0.0");
                            newObj.put("f_lon_g", "0.0");
                        }
                    } else {
                        Geometry geometry_g = convertGeometry(geo, 1);
                      /*  newObj.put("f_shape_g", WKTUtil.geomToWkt(geometry_g));*/
                        newObj.put("f_shape_g", "SRID=4490;"+WKTUtil.geomToWkt(geometry_g));
                        Point point_g = geometry_g.getCentroid();
                        if (point_g != null) {
                            newObj.put("f_lat_g", format.format(point_g.getY()));
                            newObj.put("f_lon_g", format.format(point_g.getX()));
                        } else {
                            newObj.put("f_lat_g", "0.0");
                            newObj.put("f_lon_g", "0.0");
                        }
                    }
                } else {
                    Geometry geometry_g = convertGeometry(geo, 1);
                   /* newObj.put("f_shape_g", WKTUtil.geomToWkt(geometry_g));*/
                    newObj.put("f_shape_g", "SRID=4490;"+WKTUtil.geomToWkt(geometry_g));
                    Point point_g = geometry_g.getCentroid();
                    if (point_g != null) {
                        newObj.put("f_lat_g", format.format(point_g.getY()));
                        newObj.put("f_lon_g", format.format(point_g.getX()));
                    } else {
                        newObj.put("f_lat_g", "0.0");
                        newObj.put("f_lon_g", "0.0");
                    }
                }
            }
            if (newObj.containsKey("f_shape_b")) {
                // baidu
                if (table.getfSpatialtype() != null && table.getfSpatialtype().equals("1")) {
                    if (geo.getGeometryType().equals("Point")) {
                        Point point = converPoint((Point) geo, 2);
                       /* newObj.put("f_shape_b", WKTUtil.geomToWkt(point));*/
                        newObj.put("f_shape_b", "SRID=4490;"+WKTUtil.geomToWkt(point));
                        newObj.put("f_lat_b", format.format(point.getY()));
                        newObj.put("f_lon_b", format.format(point.getX()));
                    } else {
                        Geometry geometry_b = convertGeometry(geo, 2);
                      /*  newObj.put("f_shape_b", WKTUtil.geomToWkt(geometry_b));*/
                        newObj.put("f_shape_b", "SRID=4490;"+WKTUtil.geomToWkt(geometry_b));
                        Point point_b = geometry_b.getCentroid();
                        if (point_b != null) {
                            newObj.put("f_lat_b", format.format(point_b.getY()));
                            newObj.put("f_lon_b", format.format(point_b.getX()));
                        } else {
                            newObj.put("f_lat_b", "0.0");
                            newObj.put("f_lon_b", "0.0");
                        }
                    }
                } else if (table.getfSpatialtype() != null && table.getfSpatialtype().equals("2")) {
                    if (geo.getGeometryType().equals("LineString")) {
                        LineString lineString1 = convertLineString1((LineString) geo, 2);
                      /*  newObj.put("f_shape_b", WKTUtil.geomToWkt(lineString1));*/
                        newObj.put("f_shape_b", "SRID=4490;"+WKTUtil.geomToWkt(lineString1));

                        Point centroid = lineString1.getCentroid();
                        if (lineString1 != null) {
                            newObj.put("f_lat_b", format.format(centroid.getY()));
                            newObj.put("f_lon_b", format.format(centroid.getX()));
                        } else {
                            newObj.put("f_lat_b", "0.0");
                            newObj.put("f_lon_b", "0.0");
                        }
                    } else if (geo.getGeometryType().equals("MultiLineString")) {
                        Geometry multiLineString = convertMultiLineString((MultiLineString) geo, 2);
                      /*  newObj.put("f_shape_b", WKTUtil.geomToWkt(multiLineString));*/
                        newObj.put("f_shape_b", "SRID=4490;"+WKTUtil.geomToWkt(multiLineString));
                        Point centroid = multiLineString.getCentroid();
                        if (multiLineString != null) {
                            newObj.put("f_lat_b", format.format(centroid.getY()));
                            newObj.put("f_lon_b", format.format(centroid.getX()));
                        } else {
                            newObj.put("f_lat_b", "0.0");
                            newObj.put("f_lon_b", "0.0");
                        }
                    } else {
                        Geometry geometry_b = convertGeometry(geo, 2);
                       /* newObj.put("f_shape_b", WKTUtil.geomToWkt(geometry_b));*/
                        newObj.put("f_shape_b", "SRID=4490;"+WKTUtil.geomToWkt(geometry_b));
                        Point point_b = geometry_b.getCentroid();
                        if (point_b != null) {
                            newObj.put("f_lat_b", format.format(point_b.getY()));
                            newObj.put("f_lon_b", format.format(point_b.getX()));
                        } else {
                            newObj.put("f_lat_b", "0.0");
                            newObj.put("f_lon_b", "0.0");
                        }
                    }
                } else {
                    Geometry geometry_b = convertGeometry(geo, 2);
                  /*  newObj.put("f_shape_b", WKTUtil.geomToWkt(geometry_b));*/
                    newObj.put("f_shape_b", "SRID=4490;"+WKTUtil.geomToWkt(geometry_b));
                    Point point_b = geometry_b.getCentroid();
                    if (point_b != null) {
                        newObj.put("f_lat_b", format.format(point_b.getY()));
                        newObj.put("f_lon_b", format.format(point_b.getX()));
                    } else {
                        newObj.put("f_lat_b", "0.0");
                        newObj.put("f_lon_b", "0.0");
                    }
                }
            }
        } catch (Exception ex) {

        }
    }

    /**
     * 计算面积
     *
     * @param geometry
     */
    public Double getGeometryArea(Geometry geometry) throws FactoryException, TransformException {
        // WGS84(一般项目中常用的是CSR:84和EPSG:4326)
        CoordinateReferenceSystem sourceCRS = CRS.decode("EPSG:4490");
        // Pseudo-Mercator(墨卡托投影)
        ReferencedEnvelope bounds = JTS.bounds(geometry, CRS.decode("EPSG:4490"));
        Double contentX = (bounds.getMinX() + bounds.getMaxX()) / 2.0;
        int daihao = (int) (contentX + 1.5) / 3;
        int epsg = 4534;
        if (daihao >= 25 || daihao <= 45) {
            epsg += (daihao - 25);
        }
        CoordinateReferenceSystem targetCRS = CRS.decode("EPSG:" + epsg);
        MathTransform transform = CRS.findMathTransform(sourceCRS, targetCRS, false);
        Geometry geometryMercator = JTS.transform(geometry, transform);

        // 面积、周长
        System.out.println(geometryMercator.getArea());
        System.out.println(geometryMercator.getLength());
        //换算成亩
        return (geometryMercator.getArea() * 0.0015);
    }


    //@Transactional(rollbackFor = Exception.class)
    public void mergeGeom(String bizId, String tbIds,Long userId,Boolean syncApp) throws Exception {
        TskTaskBiz tskTaskBiz = tskTaskBizService.findByTaskId(bizId);
        if (tskTaskBiz == null) {
            throw new GwValidateException("任务id错误");
        }
        JSONObject configArgs = JSONObject.parseObject(tskTaskBiz.getConfigArgs());
        String splitFieldsStr = configArgs.getString("splitFields");

        List<String> tbs = Arrays.asList(tbIds.split(","));
        String mainId = tbs.get(0);

        //获取任务的详细信息
        TbtskObjectinfo tbtskObjectinfo = mTbtskObjectinfoService.getObjectbyID(tskTaskBiz.getTableId());
        String tableName = tbtskObjectinfo.getSplitTableName();
//        Map map1 = mDataBizService.selectFieldByID(tableName, Arrays.asList("f_id", "f_status"), "f_id", "'" + mainId + "'");
//        if (org.apache.commons.collections.MapUtils.getInteger(map1, "f_status", 1) >= 10) {
//            throw new GwValidateException("图斑已提报，不允许合并");
//        }
        Boolean isChild = true;
        String sql = String.format("SELECT f_id, st_astext(f_shape) as shape FROM %s WHERE f_id in ('%s');",  tableName, org.apache.commons.lang3.StringUtils.join(tbs, "','"));
        List<Map> maps1 = mDataBizService.queryDataBySql(sql);
        // 检查图斑是否相邻，不相邻图斑不允许进行合并
        WKTReader wktReader = new WKTReader();
        double bufferSize = 0.000000001D;
        List<Geometry> geomList = maps1.stream().map(data -> {
            try {
                String shape = data.get("shape").toString();
                Geometry geom = wktReader.read(shape);
                return geom;
            } catch (Exception ex) {
                return null;
            }
        }).filter(geom -> null != geom).collect(Collectors.toList());
        for (Geometry geom : geomList) {
            int count = 0;
            for (Geometry _geom : geomList) {
                if (geom.equals(_geom)) {
                    continue;
                }
                Geometry buffer = geom.buffer(bufferSize);
                if (buffer.touches(_geom) || buffer.intersects(_geom)) {
                    count++;
                }
            }
           /* if (count == 0) {
                throw new GwValidateException("子图斑不相邻无法合并，请重新选择子图斑。");
            }*/
        }
        String wkt = null;
        if (false) {//使用分析引擎合并图斑
            JSONArray jsonArray = new JSONArray();
            sql = String.format("SELECT st_astext(f_shape) as wkt, f_id, f_tbbh FROM %s WHERE f_id in ('%s');",
                    tableName, org.apache.commons.lang3.StringUtils.join(tbs, "','"));
            logger.info(sql);
            List<Map> maps = mDataBizService.queryDataBySql(sql);
            for (Map map : maps) {
                jsonArray.add(map.get("wkt"));
            }
            String unionRequestUrl = "" + "/spatial/union";
            String unionResponse = HttpUtil.createPost(unionRequestUrl).contentType("application/json").body
                    (jsonArray.toString()).execute().body();
            if (org.apache.commons.lang3.StringUtils.isNotEmpty(unionResponse)) {
                JSONObject result = JSONObject.parseObject(unionResponse);
                wkt = result.getString("data");
            }
        } else {//使用原始sql合并图斑
//            sql = String.format("SELECT st_astext(st_makevalid(st_union(f_shape))) as wkt FROM %s WHERE f_id in ('%s');",
////            sql = String.format("SELECT st_astext(st_makevalid(st_union(st_accum(st_snaptogrid(f_shape, 0.000000001))))) as wkt FROM %s WHERE f_id in ('%s');",
//                    tbtskObjectinfo.getfTablename(), StringUtils.join(tbs, "','"));
            sql = String.format("SELECT st_astext(" +
                            "st_makevalid(" +
                            "st_buffer(" +
                            "st_union(" +
                            "st_buffer(f_shape," + bufferSize + ")" +
                            ")" +
                            ", -" + bufferSize + ")" +
                            ")" +
                            ") as wkt FROM %s WHERE f_id in ('%s');",
                    tableName, org.apache.commons.lang3.StringUtils.join(tbs, "','"));
            logger.info(sql);
            List<Map> maps = mDataBizService.queryDataBySql(sql);
            if (!maps.isEmpty()) {
                wkt = org.apache.commons.collections.MapUtils.getString(maps.get(0), "wkt", "");
            }
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty(wkt)) {
            String updateSql = "update %s set f_shape=st_geomfromewkt('%s') where  f_id = '%s';";

            mDataBizService.excuteSql(String.format(updateSql, tableName, "SRID=4490;"+wkt, mainId));

            for (int i = 1; i < tbs.size(); i++) {
                // 删除图斑数据
                mDataBizService.delete(tableName, "f_id", tbs.get(i));
            }
        } else {
            throw new GwValidateException("合并失败");
        }

        Map map = mDataBizService.selectByID(tableName, "f_id", "'" + mainId + "'");
        String f_splitedid = org.apache.commons.collections.MapUtils.getString(map, "f_splitedid", "");
        String f_pid = org.apache.commons.collections.MapUtils.getString(map, "f_pid", "");
        if (org.apache.commons.lang3.StringUtils.isNotBlank(f_splitedid)) {
            Map map2 = mDataBizService.selectByID(tbtskObjectinfo.getfTablename(), "f_id", "'" + f_splitedid + "'");
            String rejectCount = org.apache.commons.collections.MapUtils.getString(map2, "f_reject_count", "0");
            String rejectStatus = org.apache.commons.collections.MapUtils.getString(map2, "f_reject_status", "0");
            String reviewStage = org.apache.commons.collections.MapUtils.getString(map2, "f_review_stage", null);
            if(org.apache.commons.lang3.StringUtils.isNotBlank(f_pid)){
                int count = mDataBizService.getCount(tableName, "f_pid = '" + f_pid + "'");
                if (count == 1) {
                    //直接删除所有子图斑
                    mDataBizService.delete(tableName, "f_pid", f_pid);
                   /* mDataBizService.delete(tableName, "f_id", mainId);*/
                    mainId = f_pid;
                    isChild = false;
                    Map<String, Object> updateMap = new HashMap<>();
                    updateMap.put("f_issplitted", null);
                    mDataBizService.updateDataNew(tbtskObjectinfo.getSplitTableName(), updateMap, " f_id = '" + f_pid + "'");
                }
            }else{
                int count = mDataBizService.getCount(tableName, "f_splitedid = '" + f_splitedid + "'");
                if (count == 1) {
                    //直接删除所有子图斑
                    mDataBizService.delete(tableName, "f_splitedid", f_splitedid);
                 /*   mDataBizService.delete(tableName, "f_id", mainId);*/
                    List<String> stringList = Arrays.asList(splitFieldsStr.split(","));
                    Iterator iterator = map.keySet().iterator();
                    while (iterator.hasNext()) {
                        String next = iterator.next().toString();
                        if ("f_id".equals(next)) {
                            map.put("f_id", f_splitedid);
                        }
                        if ("f_issplitted".equals(next)) {
                            map.put("f_issplitted", "0");
                        }
                        if ("f_splitedid".equals(next)) {
                            map.put("f_splitedid", null);
                        }
                        if ("f_mergeid".equals(next)) {
                            map.put("f_mergeid", null);
                        }
                        if (next.contains("shape") && map.get(next) != null) {
                            map.put(next, map.get(next).toString());
                        }
                        if (stringList.contains(next) && map.get(next) != null) {
                            map.put(next, map.get(next).toString().split("_")[0]);
                        }
                    }
                    if (map.containsKey("f_reject_count")) {
                        map.put("f_reject_count", rejectCount);
                    }
                    if (map.containsKey("f_review_stage")) {
                        map.put("f_review_stage", reviewStage);
                    }
                    if (map.containsKey("f_reject_status")) {
                        map.put("f_reject_status", rejectStatus);
                    }
                    /* mDataBizService.insertData(tableName, map, "f_shape");*/
                    //将母图斑是否分割数据还原
                    Map<String, Object> updateMap = new HashMap<>();
                    updateMap.put("f_issplitted", null);
                    mDataBizService.updateDataNew(tbtskObjectinfo.getfTablename(), updateMap, " f_id = '" + f_splitedid + "'");
                    mainId = f_splitedid;
                    isChild = false;
                }
            }
        }
        List<AppMedia> media = appMediaRepository.queryByGalleryids(tbs);
        List<AppMedia> saveList = new ArrayList<>();
        List<String> mediaIds = new ArrayList<>();
        for (AppMedia appMedia : media) {
            if (!appMedia.getGalleryid().equals(mainId)) {
                Integer exist = appMediaRepository.isExist(mainId, appMedia.getServerpath());
                if (exist <= 0) {
                    appMedia.setGalleryid(mainId);
                    saveList.add(appMedia);
                }else{
                    //appMediaRepository.deleteById(appMedia.getId());
                    mediaIds.add(appMedia.getId());
                }
            }
        }
        if(mediaIds.size() > 0){
            appMediaRepository.deleteById2s(mediaIds);
        }
        if (!saveList.isEmpty()) {
            //去重
            List<AppMedia> newList = saveList.stream().collect(Collectors
                    .collectingAndThen(
                            Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(AppMedia::getServerpath))),
                            ArrayList::new));
            appMediaRepository.saveAll(newList);
        }
        try {
            if(isChild){
                String sql2 = "UPDATE " + tableName +
                        " SET f_tbmj = ( ST_Area ( ST_AsText ( ST_Transform ( st_geometryfromtext ( st_astext ( f_shape ), 4326 ), 4527 ) ) ) * 0.0015 )," +
                        "f_lon = st_x ( st_geometryfromtext ( st_astext ( st_centroid ( f_shape ) ) ))," +
                        "f_lat = st_y (st_geometryfromtext ( st_astext ( st_centroid ( f_shape ) ))) " +
                        " WHERE f_id = '" + mainId + "'";
                mDataBizService.excuteSql(sql2);
            }
        } catch (Exception e) {
            logger.error("更新面积及XY坐标失败：" + e.getMessage());
        }
        //生成定时任务同步数据到app
//        if (syncApp) {
//            JSONObject params = new JSONObject();
//            params.put("userId", userId);
//            params.put("bizId", bizId);
//            params.put("tbId", f_splitedid);
//            params.put("type", "mergeGeom"); //合并
//            MTbtskFlowService.addTaskRecord(params, userId, JobConstants.JOB_TYPE_TASK_SPLIT_MERGE, bizId);
//        }
    }


   // @Transactional(rollbackFor = Exception.class)
    public void mergeMulGeom(String bizId, String tbIds, Long userId,Boolean syncApp) throws Exception {
        TskTaskBiz tskTaskBiz = null;

        tskTaskBiz = tskTaskBizService.findByTaskId(bizId);
        if (tskTaskBiz == null) {
            throw new GwValidateException("任务id错误");
        }
        JSONObject configArgs = JSONObject.parseObject(tskTaskBiz.getConfigArgs());
        String splitFieldsStr = configArgs.getString("splitFields");

        List<String> tbs = Arrays.asList(tbIds.split(","));
        String mainId = tbs.get(0);

        //获取任务的详细信息
        TbtskObjectinfo tbtskObjectinfo = mTbtskObjectinfoService.getObjectbyID(tskTaskBiz.getTableId());
        String tableName = tbtskObjectinfo.getSplitTableName();
        Map map1 = mDataBizService.selectFieldByID(tableName, Arrays.asList("f_id", "f_status","f_splitedid"), "f_id", "'" +  mainId + "'");
        if (org.apache.commons.collections.MapUtils.getInteger(map1, "f_status", 1) >= 10) {
            throw new GwValidateException("图斑已提报，不允许合并");
        }
        String sql = "";
        Boolean isChild = true;
      /*  List<Map> maps1 = mDataBizService.queryDataBySql(sql);*/
        // 检查图斑是否相邻，不相邻图斑不允许进行合并
        double bufferSize = 0.000000001D;
        String wkt = null;
        if (false) {//使用分析引擎合并图斑
            JSONArray jsonArray = new JSONArray();
            sql = String.format("SELECT st_astext(f_shape) as wkt, f_id, f_tbbh FROM %s WHERE f_id in ('%s');",
                    tableName, org.apache.commons.lang3.StringUtils.join(tbs, "','"));
            logger.info(sql);
            List<Map> maps = mDataBizService.queryDataBySql(sql);
            for (Map map : maps) {
                jsonArray.add(map.get("wkt"));
            }
            String unionRequestUrl = "" + "/spatial/union";
            String unionResponse = HttpUtil.createPost(unionRequestUrl).contentType("application/json").body
                    (jsonArray.toString()).execute().body();
            if (org.apache.commons.lang3.StringUtils.isNotEmpty(unionResponse)) {
                JSONObject result = JSONObject.parseObject(unionResponse);
                wkt = result.getString("data");
            }
        } else {//使用原始sql合并图斑
            sql = String.format("SELECT st_astext(" +
                            "st_makevalid(" +
                            "st_buffer(" +
                            "st_union(" +
                            "st_buffer(f_shape," + bufferSize + ")" +
                            ")" +
                            ", -" + bufferSize + ")" +
                            ")" +
                            ") as wkt FROM %s WHERE f_id in ('%s');",
                    tableName, org.apache.commons.lang3.StringUtils.join(tbs, "','"));
            logger.info(sql);
            List<Map> maps = mDataBizService.queryDataBySql(sql);
            if (!maps.isEmpty()) {
                wkt = org.apache.commons.collections.MapUtils.getString(maps.get(0), "wkt", "");
            }
        }
        if (org.apache.commons.lang3.StringUtils.isNotEmpty(wkt)) {
            String updateSql = "update %s set f_shape=st_geomfromewkt('%s') where  f_id = '%s';";

            mDataBizService.excuteSql(String.format(updateSql, tableName, "SRID=4490;"+wkt, mainId));

            for (int i = 1; i < tbs.size(); i++) {
                // 删除图斑数据
                mDataBizService.delete(tableName, "f_id", tbs.get(i));
            }
        } else {
            throw new GwValidateException("合并失败");
        }

        Map map = mDataBizService.selectByID(tableName, "f_id", "'" + mainId + "'");
        String f_splitedid = org.apache.commons.collections.MapUtils.getString(map, "f_splitedid", "");
        String f_pid = org.apache.commons.collections.MapUtils.getString(map, "f_pid", "");
        if (org.apache.commons.lang3.StringUtils.isNotEmpty(f_splitedid)) {
            Map map2 = mDataBizService.selectByID(tableName, "f_id", "'" + f_splitedid + "'");
            String rejectCount = org.apache.commons.collections.MapUtils.getString(map2, "f_reject_count", "0");
            String rejectStatus = org.apache.commons.collections.MapUtils.getString(map2, "f_reject_status", "0");
            String reviewStage = org.apache.commons.collections.MapUtils.getString(map2, "f_review_stage", null);
            if(org.apache.commons.lang3.StringUtils.isNotBlank(f_pid)){
                int count = mDataBizService.getCount(tableName, "f_pid = '" + f_pid + "'");
                if (count == 1) {
                    //直接删除所有子图斑
                    mDataBizService.delete(tableName, "f_pid", f_pid);
                    /* mDataBizService.delete(tableName, "f_id", mainId);*/
                    mainId = f_pid;
                    isChild = false;
                    Map<String, Object> updateMap = new HashMap<>();
                    updateMap.put("f_issplitted", null);
                    mDataBizService.updateDataNew(tbtskObjectinfo.getSplitTableName(), updateMap, " f_id = '" + f_pid + "'");
                }
            }else{
                int count = mDataBizService.getCount(tableName, "f_splitedid = '" + f_splitedid + "'");
                if (count == 1) {
                    //直接删除所有子图斑
                    mDataBizService.delete(tableName, "f_splitedid", f_splitedid);
                    /*   mDataBizService.delete(tableName, "f_id", mainId);*/
                    List<String> stringList = Arrays.asList(splitFieldsStr.split(","));
                    Iterator iterator = map.keySet().iterator();
                    while (iterator.hasNext()) {
                        String next = iterator.next().toString();
                        if ("f_id".equals(next)) {
                            map.put("f_id", f_splitedid);
                        }
                        if ("f_issplitted".equals(next)) {
                            map.put("f_issplitted", "0");
                        }
                        if ("f_splitedid".equals(next)) {
                            map.put("f_splitedid", null);
                        }
                        if ("f_mergeid".equals(next)) {
                            map.put("f_mergeid", null);
                        }
                        if (next.contains("shape") && map.get(next) != null) {
                            map.put(next, map.get(next).toString());
                        }
                        if (stringList.contains(next) && map.get(next) != null) {
                            map.put(next, map.get(next).toString().split("_")[0]);
                        }
                    }
                    if (map.containsKey("f_reject_count")) {
                        map.put("f_reject_count", rejectCount);
                    }
                    if (map.containsKey("f_review_stage")) {
                        map.put("f_review_stage", reviewStage);
                    }
                    if (map.containsKey("f_reject_status")) {
                        map.put("f_reject_status", rejectStatus);
                    }
                    /* mDataBizService.insertData(tableName, map, "f_shape");*/
                    //将母图斑是否分割数据还原
                    Map<String, Object> updateMap = new HashMap<>();
                    updateMap.put("f_issplitted", null);
                    mDataBizService.updateDataNew(tbtskObjectinfo.getfTablename(), updateMap, " f_id = '" + f_splitedid + "'");
                    mainId = f_splitedid;
                    isChild = false;
                }
            }
        }
        List<AppMedia> media = appMediaRepository.queryByGalleryids(tbs);
        List<AppMedia> saveList = new ArrayList<>();
        List<String> mediaIds = new ArrayList<>();
        for (AppMedia appMedia : media) {
            if (!appMedia.getGalleryid().equals(mainId)) {
                Integer exist = appMediaRepository.isExist(mainId, appMedia.getServerpath());
                if (exist <= 0) {
                    appMedia.setGalleryid(mainId);
                    saveList.add(appMedia);
                }else{
                    //appMediaRepository.deleteById(appMedia.getId());
                    mediaIds.add(appMedia.getId());
                }
            }
        }
        if(mediaIds.size() > 0){
            appMediaRepository.deleteById2s(mediaIds);
        }
        if (!saveList.isEmpty()) {
            //去重
            List<AppMedia> newList = saveList.stream().collect(Collectors
                    .collectingAndThen(
                            Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(AppMedia::getServerpath))),
                            ArrayList::new));
            appMediaRepository.saveAll(newList);
        }
        try {
            if(isChild){
                String sql2 = "UPDATE " + tableName +
                        " SET f_tbmj = ( ST_Area ( ST_AsText ( ST_Transform ( st_geometryfromtext ( st_astext ( f_shape ), 4326 ), 4527 ) ) ) * 0.0015 )," +
                        "f_lon = st_x ( st_geometryfromtext ( st_astext ( st_centroid ( f_shape ) ) ))," +
                        "f_lat = st_y (st_geometryfromtext ( st_astext ( st_centroid ( f_shape ) ))) " +
                        " WHERE f_id = '" + mainId + "'";
                mDataBizService.excuteSql(sql2);
            }
        } catch (Exception e) {
            logger.error("更新面积及XY坐标失败：" + e.getMessage());
        }
        //生成定时任务同步数据到app
//        if (syncApp) {
//            JSONObject params = new JSONObject();
//            params.put("userId", userId);
//            params.put("bizId", bizId);
//            params.put("tbId", f_splitedid);
//            params.put("type", "mergeGeom"); //合并
//            MTbtskFlowService.addTaskRecord(params, userId, JobConstants.JOB_TYPE_TASK_SPLIT_MERGE, bizId);
//        }
    }


   // @Transactional(rollbackFor = Exception.class)
    public void oneClickRecovery(String bizId, String tbId, Long userId, String type,Boolean syncApp) {
        TskTaskBiz tskTaskBiz  = tskTaskBizService.findByTaskId(bizId);
        if (tskTaskBiz == null) {
            throw new GwValidateException("任务id错误");
        }
        TbtskObjectinfo tbtskObjectinfo = mTbtskObjectinfoService.getObjectbyID(tskTaskBiz.getTableId());
        String tableName = tbtskObjectinfo.getSplitTableName();
        Map map1 = mDataBizService.selectFieldByID(tbtskObjectinfo.getfTablename(), Arrays.asList("f_id", "f_status"), "f_id", "'" + tbId + "'");
        if (org.apache.commons.collections.MapUtils.getInteger(map1, "f_status", 1) >= 10) {
            throw new GwValidateException("图斑已提报，不允许还原");
        }

        List<TbtskFields> tbtskFields = fieldsService.getAllFieldsByTableID(tskTaskBiz.getTableId());
        List<String> fieldNames = tbtskFields.stream().map(TbtskFields::getfFieldname).collect(Collectors.toList());

        List<TbtskFields> collect = tbtskFields.stream().filter(i -> (i.getfFieldInnerOuterSys() & FieldGroupTypeConstant.OUTER_FIELD)
                == FieldGroupTypeConstant.OUTER_FIELD)
                .collect(Collectors.toList());
        /*List<TbtskFields> collect = tbtskFields.stream()
                .filter(i -> i.getfFieldInnerOuterSys() == FieldGroupTypeConstant.OUTER_FIELD)
                .collect(Collectors.toList());*/
        Map currObj = new HashMap();
        //保留字段（f_submit_userid提交人id，f_committime提交时间，f_upload_userid上传用户id）
        List<String> reservedFields = Arrays.asList("f_submit_userid","f_committime","f_upload_userid");
        for (TbtskFields fields : collect) {
            String fieldName = fields.getfFieldname();
            if(!reservedFields.contains(fieldName)) currObj.put(fieldName, null);
            //if(!"f_submit_userid".equals(fields.getfFieldname()) && !"f_committime".equals(fields.getfFieldname())) currObj.put(fields.getfFieldname(), null);
        }
        boolean isSplited = tbtskFields.stream().anyMatch(i -> i.getfFieldname().equals("f_splitedid"));
        if (isSplited) {
            List<Map> maps = mDataBizService.queryAllData(tableName, fieldNames, " f_splitedid='" + tbId + "'");
            List<AppMedia> addMediaList = new ArrayList<>();
            List<String> deleteMediaIds = new ArrayList<>();
            List<String> tbIds = new ArrayList<>();
            List<AppMedia> mainMediaList = appMediaRepository.queryByGid(tbId);

            for (Map map : maps) {
                String f_id = map.get("f_id").toString();
                List<AppMedia> childMediaList = appMediaRepository.queryByGid(f_id);
                for(AppMedia appMedia : childMediaList){
                    boolean add=true;
                    if(mainMediaList!=null&&mainMediaList.stream().filter(t->StringUtils.isNotBlank(t.getServerpath())&&t.getServerpath().equals(appMedia.getServerpath())).findFirst().isPresent())
                    {
                        add=false;
                    }
                    if(add)
                    {
                        AppMedia newMedia = new AppMedia();
                        BeanUtils.copyProperties(appMedia,newMedia);
                        newMedia.setGalleryid(tbId);
                        newMedia.setId(UUID.randomUUID().toString());
                        addMediaList.add(newMedia);
                        mainMediaList.add(newMedia);
                    }
                    deleteMediaIds.add(appMedia.getId());
                }
                tbIds.add(f_id);
            }
            //删除图斑及附件数据
            delTbAndMedia(deleteMediaIds,tbIds,tableName);
            if(!addMediaList.isEmpty()) {
                //去重
                List<AppMedia> newList = addMediaList.stream().collect(Collectors
                        .collectingAndThen(
                                Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(AppMedia::getServerpath))),
                                ArrayList::new));
                appMediaRepository.saveAll(newList);
            }
            currObj.put("f_issplitted", 0);
        }

        if ("origin".equals(type)) {
            if (checkCheckExists(tbtskObjectinfo.getfTablename() )) {
                Map map = mDataBizService.selectFieldByID(tbtskObjectinfo.getfTablename() , Arrays.asList("f_shape"), "f_id", "'" + tbId + "'");
                if (map != null && null != map.get("f_shape")) {
                    currObj.put("f_shape", map.get("f_shape").toString());
                }
            } else {
                throw new GwValidateException("未找到母图斑表");
            }
        }
        mDataBizService.updateDataNew(tbtskObjectinfo.getfTablename(), currObj, " f_id='" + tbId + "'");
        //生成定时任务同步数据到app
//        if (syncApp) {
//            JSONObject params = new JSONObject();
//            params.put("userId", userId);
//            params.put("bizId", bizId);
//            params.put("tbId", tbId);
//            params.put("type", "mergeGeom"); //合并
//            MTbtskFlowService.addTaskRecord(params, userId, JobConstants.JOB_TYPE_TASK_SPLIT_MERGE, bizId);
//        }
    }

    @Transactional(rollbackFor = Exception.class)
    public void delTbAndMedia(List<String> mediaIds,List<String> tbIds,String tableName){
         if(mediaIds.size() > 0 ){
             appMediaRepository.deleteById2s(mediaIds);
         }
         if(tbIds.size() > 0 ){
             // 删除图斑数据
             mDataBizService.deleteByCond(tableName,"f_id in ('"+StringUtils.join(tbIds,"','")+"')");
         }
    }

    private boolean checkCheckExists(String tablename) {
        if(tablename.contains(".")){
            String[] split = tablename.split("\\.");
            tablename = split[1];
        }
        String checkSql = "select count(*) from pg_class where relname = '" + tablename + "'";
        Long count = (Long) jdbcTemplate.queryForMap(checkSql).get("count");
        return count > 0;
    }

    public  void uploadAuditTaskDataExcel(String excelFile,String taskId,Long userId) throws Exception {
        TskTaskBiz tskTaskBiz = tskTaskBizService.findOne(taskId);
        if (null == tskTaskBiz) {
            throw new Exception("分配失败，业务不存在或已被删除");
        }
        TbtskObjectinfo tbtskObjectinfo = tbtskObjectinfoRepository.getObjectByTableId(tskTaskBiz.getTableId());
        if (null == tbtskObjectinfo || (tbtskObjectinfo != null && StringUtils.isBlank(tbtskObjectinfo.getfTablename()))) {
            throw new Exception("分配失败，业务数据表不存在或已被删除");
        }
        Workbook workbook = null;
        try {
            File file = new File(excelFile);
            InputStream inputStream = new FileInputStream(file);

            File parentFile = file.getParentFile();
            if (parentFile != null && (!parentFile.exists())) {
                parentFile.mkdirs();
            }
            //这种方式 Excel 2003/2007/2010 都是可以处理的
            workbook = WorkbookFactory.create(inputStream);
            inputStream.close();

            Sheet sheet = workbook.getSheetAt(0);
            Row row = sheet.getRow(0);
            int colNumber = row.getPhysicalNumberOfCells();
            int rowCount = sheet.getPhysicalNumberOfRows();
            Map<String,Object> userMap = new HashMap<>();
            List<TbtskAuditAssignRecord> tbtskAuditAssignRecordList = new ArrayList<>();
            for (int i = 1; i < rowCount; i++) {
                row = sheet.getRow(i);
                if (row == null) {
                    continue;
                }
                    String id = findCellValue(row.getCell(1));
                    String xzqmc = findCellValue(row.getCell(2));
                    String tbbh = findCellValue(row.getCell(3));
                    String shry = findCellValue(row.getCell(4));
                    if(org.apache.commons.lang3.StringUtils.isNotBlank(shry)){
                        List<String> userNameList = Arrays.asList(shry.split(","));
                        for (String s : userNameList) {
                            if(!userMap.containsKey(s)){
                                LandUser tempUser = landUserService.queryAppUserByUsernamePhone(s);
                                userMap.put(s,tempUser.getId());
                            }
                            TbtskAuditAssignRecord tbtskAuditAssignRecord = new TbtskAuditAssignRecord();
                            tbtskAuditAssignRecord.setTaskId(taskId);
                            tbtskAuditAssignRecord.setDataId(id);
                            tbtskAuditAssignRecord.setId(UUID.randomUUID().toString());
                            tbtskAuditAssignRecord.setAssignto(userMap.get(s).toString());
                            tbtskAuditAssignRecord.setStatus("0");
                            tbtskAuditAssignRecord.setCreateTime(new Timestamp(System.currentTimeMillis()));
                            tbtskAuditAssignRecord.setOptUserId(userId.toString());
                            tbtskAuditAssignRecordList.add(tbtskAuditAssignRecord);
                        }
                    }
                }
            tbtskAuditAssignRecordRepository.saveAll(tbtskAuditAssignRecordList);
        } catch (Exception ex) {
            throw ex;
        }
    }


    public Map<String, List<String>> importTaskExcelData(String fileDir, String taskId, Long userId, String
            updateType, Map<String, TskUploadLogDTO> dataUploadLog, Set<String> existData,String fileType) throws Exception {
        TskTaskBiz tskTaskBiz = tskTaskBizRepository.findById(taskId).orElse(null);
        TbtskObjectinfo tableInfo = tbtskObjectinfoRepository.gwSearchByPK(tskTaskBiz.getTableId());
        File file = new File(fileDir);
        List<File> excelList = new ArrayList<>();
        excelList.add(file);
        if (excelList.isEmpty()) {
            throw new RuntimeException("未找到Excel文件，请检查压缩包内容");
        }
        List<Workbook> wbs = new ArrayList<>();
        Iterator<File> iterator = excelList.iterator();
        final String sheetName = "图斑数据";
        List<String> mustExistField = new ArrayList<String>() {
            {
                add("行政区代码");
                add("行政区名称");
            }
        };
        List<String> head = new ArrayList<>();
        while (iterator.hasNext()) {
            File file1 = iterator.next();
            Workbook excelWorkbook = ExcelPOIUtil.getExcelWorkbook(file1);
             head = ExcelPOIUtil.getExcelHead(excelWorkbook, sheetName);
            if (head.containsAll(mustExistField)) {
                iterator.remove();
            }
            else{
                throw new RuntimeException("Excel文件缺少必要字段，请检查压缩包内容");
            }
            wbs.add(excelWorkbook);
        }
        if (wbs.isEmpty()) {
            throw new RuntimeException("所有Excel文件缺少必要字段，请检查压缩包内容");
        }
        Map<String, List<String>> map = new HashMap<>();
        List<Map<String, Object>> addDataCacheList = new ArrayList<>();
        List<TbtskFields> allFields = tbtskFieldsRepository.getTbtskFieldsByTableid(tableInfo.getfId());
        // 唯一值字段集合
        List<TbtskFields> uniqueFields = tbtskFieldsRepository.getTbtskUniqueFieldsByTableid(tableInfo.getfId(), 1);
        int i = 0;
        for (Workbook wb : wbs) {
            List<Map<String, String>> data = ExcelPOIUtil.getExcelData(wb, sheetName);
            for (Map<String, String> row : data) {

                HashMap<String, Object> addmap = new HashMap<>();
                HashMap<String, Object> updateMap = new HashMap<>();
                // 数据预处理 目前处理excel 宅基地相关
                //preProcessRow(row, tableInfo);
                //处理null数据
                for(String headname :head){
                    if(!row.containsKey(headname)){
                        row.put(headname,null);
                    }
                }
                List<String> fieldDefault = new ArrayList<>();
                // 读取row中的数据
                saveData(addmap, updateMap, row, updateType, allFields,fieldDefault);
                // 处理数据并返回处理结果,
                Map<String, Object> result = processTbDataMap(addmap, updateMap, tableInfo, userId.toString(),
                        taskId, updateType, addDataCacheList, allFields, uniqueFields, existData,
                        fileType,fieldDefault,taskId);
                // 处理保存的结果 生成日志
                i += processAfterSaveData(result, dataUploadLog, updateType, map, "excel");
                // 每达到提交数量是，提交插入数据,并清空缓存集合
                if (addDataCacheList.size() == BATCH_COMMIT_COUNT) {
                    mDataBizService.insertDatasBatch(tableInfo.getfTablename(), addDataCacheList, "f_shape");
                    addDataCacheList.clear();
                }
            }
        }
        if (!addDataCacheList.isEmpty()) {
            // 提交插入最后一批数据
            mDataBizService.insertDatasBatch(tableInfo.getfTablename(), addDataCacheList, "f_shape");
        }

        if (tskTaskBiz.getTotal() == null) {
            tskTaskBiz.setTotal(i);
        } else if (tskTaskBiz.getTotal() != null) {
            tskTaskBiz.setTotal(tskTaskBiz.getTotal() + i);
        }
        tskTaskBizRepository.save(tskTaskBiz);
        return map;
    }



    /**
     * 预处理数据
     *
     * @param row
     */
    private void preProcessRow(Map<String, String> row, TbtskObjectinfo tableInfo) {
        row.put("坐落", row.get("坐落"));
    }


    /**
     * 读取excel中的数据
     *
     * @param map
     * @param updateMap
     * @param row
     * @param updateType
     * @param allFields
     * @throws Exception
     */
    private void saveData(Map<String, Object> map, HashMap<String, Object> updateMap, Map<String, String> row, String
            updateType, List<TbtskFields> allFields,List<String> fieldDefault) throws Exception {
        String fieldName = "";
        String fieldType = "";
        String alias = "";

        //插入数据
        for (TbtskFields field : allFields) {
            fieldName = field.getfFieldname();
            fieldType = field.getfFieldtype();
            fieldType = TskTaskBizDBUtil.getDBType(fieldType);
            alias = field.getfAlias();
          if(row.containsKey(alias)){

              if (field.getfDefaultvalue() != null && !"".equalsIgnoreCase(field.getfDefaultvalue())) {
                  fieldDefault.add(fieldName);
              }
              map.put(fieldName, field.getfDefaultvalue());
              addZJDDatatoMap(map, row, fieldType, fieldName, alias,  field.getfNullable(), field.getfOrder(), field.getfDefaultvalue());
          }
        }
        // 默认赋上村级政区代码
        List<TbtskFields> sysFields = allFields.stream().filter(t -> "f_xzqdmcity".equalsIgnoreCase(t.getfFieldname())).collect(Collectors.toList());
        if (sysFields != null && sysFields.size() > 0) {
            // 包含这个字段的表，赋上系统政区代码值
            if (map.get("f_xzqdm") != null) {
                map.put("f_xzqdmsys", map.get("f_xzqdm"));
                map.put("f_xzqdmcity", map.get("f_xzqdm").toString().substring(0,4)+"00");
                map.put("f_xzqdmcounty", map.get("f_xzqdm").toString().substring(0,6));
                map.put("f_xzqdmtown", map.get("f_xzqdm"));

                updateMap.put("f_xzqdmcity", map.get("f_xzqdm").toString().substring(0,4)+"00");
                updateMap.put("f_xzqdmcounty", map.get("f_xzqdm").toString().substring(0,6));
                updateMap.put("f_xzqdmtown", map.get("f_xzqdm"));
                updateMap.put("f_xzqdmsys", map.get("f_xzqdm"));
            }
        }

    }

    void addZJDDatatoMap(Map map, Map<String, String> row, String fieldType, String fieldName, String alias,
                         Integer nullable, Integer order, String defaultValue) throws Exception {

        DecimalFormat format = new DecimalFormat("######0.0000000");
        String val = row.get(alias);
        switch (fieldType) {
            case "varchar":
                String value1 = val;
                if (value1 == null || "null".equals(value1.toLowerCase()) || "".equals(value1)) {
                    if (order != null && nullable == 0) {
                        // throw new Exception(alias + "不能为空");
                    } else {
                        map.put(fieldName, org.apache.commons.lang3.StringUtils.isBlank(defaultValue) ? null : defaultValue);
                    }
                } else {
                    map.put(fieldName, value1);
                }
                break;
            case "decimal":
                if (!"f_lat".equals(fieldName) && !"f_lon".equals(fieldName)) {
                    String tmp1 = val;
                    if (tmp1 == null || isMessyCode(tmp1) || "".equals(tmp1)) {
                        if (order != null && nullable == 0) {
                            //    throw new Exception(alias + "不能为空");
                        } else {
                            /*  map.put(fieldName, StringUtils.isBlank(defaultValue) ? null : Double.valueOf(defaultValue));*/
                            map.put(fieldName, defaultValue);
                        }
                    } else {
                        Double value2 = Double.valueOf(tmp1);
                        map.put(fieldName, value2);
                    }
                }
                break;
            case "int4":
                String tmp2 = val;
                if (tmp2 == null || isMessyCode(tmp2) || "".equals(tmp2)) {
                    if (order != null && nullable == 0) {
                        //   throw new Exception(alias + "不能为空");
                    } else {
                        /* map.put(fieldName, StringUtils.isBlank(defaultValue) ? null : Integer.valueOf(defaultValue));*/
                        map.put(fieldName, defaultValue);
                    }
                } else {
                    Integer value3 = Integer.valueOf(tmp2);
                    map.put(fieldName, value3);
                }
                break;
            case "timestamp":
                String tmp3 = val;
                if (tmp3 == null || isMessyCode(tmp3) || "".equals(tmp3)) {
                    if (order != null && nullable == 0) {
                        //   throw new Exception(alias + "不能为空");
                    } else {
                        map.put(fieldName, null);
                    }
                } else {
                    DateFormat df = new SimpleDateFormat("yyyy/MM/dd");
                    Date date = df.parse(tmp3);
                    Timestamp value5 = new Timestamp(date.getTime());
                    map.put(fieldName, value5);
                }
                break;
            case "text":
                String value2 = val;
                if (value2 == null || "null".equals(value2.toLowerCase()) || "".equals(value2)) {
                    if (order != null && nullable == 0) {
                        //    throw new Exception(alias + "不能为空");
                    } else {
                        map.put(fieldName, org.apache.commons.lang3.StringUtils.isBlank(defaultValue) ? null : defaultValue);
                    }
                } else {
                    map.put(fieldName, value2);
                }
                break;
            case "geometry":
                // excel无空间数据
                Geometry geo = null;
                if (geo == null) {
                    break;
                }
                break;
            default:
                break;
        }
    }


    /**
     * 对读取到的数据进行处理
     *
     * @param map
     * @param updateMap
     * @param table
     * @param userId
     * @param bizId
     * @param updateType
     * @param addDataList
     * @param uniqueFields
     * @return
     * @throws Exception
     */
    private Map<String, Object> processTbDataMap(HashMap<String, Object> map, HashMap<String, Object> updateMap, TbtskObjectinfo table, String userId, String bizId, String
            updateType, List<Map<String, Object>> addDataList, List<TbtskFields> allFields, List<TbtskFields> uniqueFields,
                                                 Set<String> uniqueValSet, String
                                                         fileType, List<String> fieldDefault,String taskId)throws Exception {
        map.put("f_id", UUID.randomUUID().toString());
        map.put("f_status", "1");
        map.put("f_createtime", System.currentTimeMillis() + "");
        map.put("f_userid", userId);
        map.put("f_ismy", "0");
        Map<String, Object> result = new HashMap<>();

        // 判断不能为空字段是否有空值
        if (map.get("f_xzqdm") == null) {
            result.put("type", UpResultEnum.ERROR);
            result.put("error", UpResultErrorEnum.XZQDM_ERROR);
            result.put("errorInfo", "行政区代码字段不能为空");
            return result;
        }
        for (TbtskFields field : allFields) {
            //获取编码字段及其配置规则{name:'编码',id:'11'}
            if(field.getfFieldtype().equals("11") && org.apache.commons.lang3.StringUtils.isNotBlank(field.getAutoVal())){
                Pair<String, String> paramKey = tbsysBhmanagerService.getParamKey(field.getAutoVal(),map);
                String bhNextValue = tbsysBhmanagerService.getBhNextValue(table.getfTablename(), field.getfFieldname(), paramKey.getLeft(), Integer.valueOf(paramKey.getRight()));
                map.put(field.getfFieldname(),bhNextValue);
            }

        }
        if (map.containsKey("f_xzqdm") && org.apache.commons.lang3.StringUtils.isNotBlank((String) map.get("f_xzqdm"))) {
            String xzqdm = (String) map.get("f_xzqdm");
            List<Map> maps = new ArrayList<>();
            String val = "";
            // 唯一值判断
            if (uniqueFields != null && !uniqueFields.isEmpty()) {
                StringBuilder stringBuilder = new StringBuilder();

                stringBuilder.append("select f_id from " + table.getfTablename() + " where 1=1 ");
                List<Object> values = new ArrayList<>(uniqueFields.size());
                for (TbtskFields tbtskFields : uniqueFields) {
                    stringBuilder.append(" and ");
                    stringBuilder.append(tbtskFields.getfFieldname());
                    stringBuilder.append(" = ?");
                    values.add(map.get(tbtskFields.getfFieldname()));
                    val += "," + map.get(tbtskFields.getfFieldname());
                }

                maps = jdbcTemplate.query(stringBuilder.toString(), values.toArray(new Object[0]), new RowMapper<Map>() {
                    @Override
                    public Map mapRow(ResultSet rs, int rowNum) throws SQLException {
                        Map ha = new HashMap();
                        rs.getString("f_id");
                        ha.put("f_id", rs.getString("f_id"));
                        return ha;
                    }
                });
            }
            result.put("xzqdm", xzqdm);
            // 缓存中存在 则无论是否覆盖更新都选择跳过
            if (uniqueValSet.contains(val)) {
                result.put("type", UpResultEnum.SKIP);
                // 错误信息记录
                StringBuilder stringBuilder1 = new StringBuilder();
                for (TbtskFields uniqueField : uniqueFields) {
                    stringBuilder1.append(uniqueField.getfAlias())
                            .append(":").append(map.get(uniqueField.getfFieldname())).append(",");
                }
                result.put("errorInfo", stringBuilder1.toString());
                return result;
            }
            // 跳过--有重复记录且追加新增模式跳过
            if ((!maps.isEmpty() || uniqueValSet.contains(val)) && SHAPE_APPEND.equals(updateType)) {
                result.put("type", UpResultEnum.SKIP);
                // 错误信息记录
                StringBuilder stringBuilder1 = new StringBuilder();
                for (TbtskFields uniqueField : uniqueFields) {
                    stringBuilder1.append(uniqueField.getfAlias())
                            .append(":").append(map.get(uniqueField.getfFieldname())).append(",");
                }
                result.put("errorInfo", stringBuilder1.toString());
                return result;
            }
            String name = regionService.getName(xzqdm);
            if(org.apache.commons.lang3.StringUtils.isBlank(name)){
                result.put("type", UpResultEnum.ERROR);
                result.put("error", UpResultErrorEnum.XZQDM_ERROR);
                result.put("errorInfo", "政区代码错误："+xzqdm+"政区代码不存在");
                return result;
            }
            if (updateMap.containsKey("f_createtime")) {
                updateMap.put("f_createtime", System.currentTimeMillis() + "");
            }
            if (updateMap.containsKey("f_userid")) {
                updateMap.put("f_userid", userId);
            }
          /*  Map<String, Object> result1 =    processGZLQZJDData(map, updateMap, table, bizId, xzqdm, result, maps);
            if(result1.get("error") != null){
                return result;
            }*/
            // 没有定义唯一值
            if (maps.isEmpty() && !uniqueValSet.contains(val)) {
                result.put("f_id", map.get("f_id"));
                result.put("type", UpResultEnum.ADD);
                // 将记录放进缓存 防止批量存放造成的重复记录
                uniqueValSet.add(val);
                //解析默认值
                resolveFieldDefault(map, fieldDefault);
                addDataList.add(map);
                return result;

            } else if (maps.size() > 0 && SHAPE_UPDATE.equals(updateType)) { // 覆盖更新
                result.put("type", UpResultEnum.SKIP);
                result.put("error", UpResultErrorEnum.OTHER);
                result.put("errorInfo", "数据已存在");
                return result;
            }
            return result;
        } else {
            result.put("type", UpResultEnum.ERROR);
            result.put("error", UpResultErrorEnum.MISS_XZQDM_FIELD);
            result.put("errorInfo", "政区代码不能为空");
            return result;
        }
    }

    private int processAfterSaveData(Map<String, Object> result, Map<String, TskUploadLogDTO> dataUploadLog, String updateType, Map<String, List<String>> map, String fileType) {
        UpResultEnum r = (UpResultEnum) result.get("type");
        int i = 0;
        String xzqdm = result.get("xzqdm")==null?"行政区代码为空":(String) result.get("xzqdm");

        TskUploadLogDTO tskUploadLogDTO = dataUploadLog.computeIfAbsent(xzqdm, k -> new TskUploadLogDTO(xzqdm, updateType));
        tskUploadLogDTO.addTotal(1L);
        switch (r) {
            case ADD:
                tskUploadLogDTO.addSuccessNum(1L);
                map.computeIfAbsent("ADD", k -> new ArrayList<>()).add((String) result.get("f_id"));
                i++;
                break;
            case UPDATE:
                tskUploadLogDTO.addSuccessNum(1L);
                map.computeIfAbsent("UPDATE", k -> new ArrayList<>()).add((String) result.get("f_id"));
                break;
            case SKIP:
                tskUploadLogDTO.addSkipNum(1L);
                break;
            case ERROR:
                Map<UpResultErrorEnum, Long> errorEnumLongMap = tskUploadLogDTO.getErrorEnumLongMap();
                UpResultErrorEnum e = (UpResultErrorEnum) result.getOrDefault("error", UpResultErrorEnum.OTHER);
                // 统计错误的类型
                errorEnumLongMap.merge(e, 1L, (oldValue, newValue) -> oldValue + newValue);
                tskUploadLogDTO.addFailNum(1L).appendErrorInfo((String) result.getOrDefault("errorInfo", ""));
                break;
            default:
                break;
        }
        return i;
    }


    /**
     * 定时任务处理数据
     * @param classId
     */
    @Transactional(rollbackFor = Exception.class)
    public void handWpzfexpire(Long classId){
        List<Long> classIds = new ArrayList<>();
        classIds.add(Long.valueOf(classId));
        mTbtskTaskClassService.queryClassIdByParentId(Long.valueOf(classId),classIds);
        String taskSql = "select ttb.f_id ,to2.f_tablename,to2.f_splittablename,ttb.f_configargs  from tbtsk_task_biz ttb  inner join " +
                "tbtsk_objectinfo to2 on (ttb.f_tableid = to2.f_id) where ttb.f_isdel  is null and ttb.f_finish='1' and ttb.f_classid in ("+ GutilStr.join(classIds,",")+")";

        List<Map<String, Object>> taskMap = jdbcTemplate.queryForList(taskSql);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String dateString = sdf.format(new Date());
        for(Map<String, Object> map2 :taskMap) {
            if(map2.get("f_configargs") != null){
                JSONObject configArgsObject = JSONObject.parseObject(map2.get("f_configargs").toString());
                if(configArgsObject.get("isWpzf") != null ){
                    if(configArgsObject.getInteger("isWpzf")==1) {
                        if (map2.get("f_tablename") != null) {
                            String f_tablename = map2.get("f_tablename").toString();
                            String f_splittablename = map2.get("f_splittablename") != null && StringUtils.isNotBlank(map2.get("f_splittablename").toString()) ? map2.get("f_splittablename").toString() : null;
                            String f_id = map2.get("f_id").toString();
                            if (org.apache.commons.lang3.StringUtils.isNotBlank(f_tablename)) {
                                String sql = " select tb.* from " + f_tablename + "tb  where  tb.pzsj <'" + dateString + "'  " +
                                        "and   EXISTS(SELECT approve.f_tbid FROM tbtsk_approve_record AS approve WHERE tb.f_id  = approve.f_tbid and approve.f_option='1' and approve.f_is_revoked is null and approve.f_stepname ='省级审核' and approve.f_taskid = '" + f_id + "' )";

//                            //将数据放到临时表
//                            String insertSql = "INSERT INTO public.tbtsk_task_wpzf_tem (f_id, f_taskid, f_tbid," +
//                                    "f_createtime,f_status, f_review_stage) select uuid_generate_v4(),'"+f_id+"',tb.f_id,now(),tb.f_status,tb.f_review_stage from "+f_tablename +
//                                    " tb where  tb.f_jzrq <'"+dateString+"' and   (tb.f_review_stage<'95' or tb.f_review_stage is null) and   not " +
//                                    "EXISTS(SELECT approve.f_tbid FROM tbtsk_approve_record AS approve WHERE" +
//                                    " tb.f_id  = approve.f_tbid and approve.f_option='1' and approve.f_is_revoked is null and approve.f_stepname ='市级审核' and approve.f_taskid = '" +f_id +"' )";
//                            jdbcTemplate.execute(insertSql);

                                String selectSql = "select uuid_generate_v4() f_id,'" + f_id + "' f_taskid,tb.f_id f_tbid,now() f_createtime,tb.f_status,tb.f_review_stage from " + f_tablename +
                                        " tb where  tb.f_jzrq <'" + dateString + "' and   (tb.f_review_stage<'95' or tb.f_review_stage is null) and   not " +
                                        "EXISTS(SELECT approve.f_tbid FROM tbtsk_approve_record AS approve WHERE" +
                                        " tb.f_id  = approve.f_tbid and approve.f_option='1' and approve.f_is_revoked is null and approve.f_stepname ='市级审核' and approve.f_taskid = '" + f_id + "' ) ";
                                List<Map<String, Object>> maps = jdbcTemplate.queryForList(selectSql);
                                // 当前时间大于截止日期，图斑状态小于95且图斑没有超期流转记录,流转到市级待审核 补充：已打回的图斑也不流转
                                String updateSql = " update " + f_tablename + " tb set f_status = '10' , f_review_stage = '95' , f_reject_status = null  where  f_jzrq <'" + dateString + "' and   (f_review_stage<'95' or f_review_stage is null) " +
                                        "and  not EXISTS(SELECT approve.f_tbid FROM tbtsk_approve_record AS approve WHERE" +
                                        " tb.f_id  = approve.f_tbid and approve.f_option='1' and approve.f_is_revoked is null and approve.f_stepname ='市级审核' and approve.f_taskid = '" + f_id + "' ) and not exists( select null from tbtsk_task_wpzf_tem where f_taskid = '" + f_id + "' and f_tbid = tb.f_id)  ";
                                jdbcTemplate.execute(updateSql);
                                //子图斑流转
                                if (StringUtils.isNotBlank(f_splittablename)) {
                                    String updateSql1 = " update " + f_splittablename + " tb set f_status = '10' , f_review_stage = '95' , f_reject_status = null  where  f_jzrq <'" + dateString + "' and   (f_review_stage<'95' or f_review_stage is null) " +
                                            "and  not EXISTS(SELECT approve.f_tbid FROM tbtsk_approve_record AS approve WHERE" +
                                            " tb.f_splitedid  = approve.f_tbid and approve.f_option='1' and approve.f_is_revoked is null and approve.f_stepname ='市级审核' and approve.f_taskid = '" + f_id + "')  and not exists( select null from tbtsk_task_wpzf_tem where f_taskid = '" + f_id + "' and f_tbid = f_splitedid ) ";
                                    jdbcTemplate.execute(updateSql1);
                                }
                                //记录流转信息
                                if (!maps.isEmpty()) {
                                    dataBizMapper.insertBatch("tbtsk_task_wpzf_tem", maps, null);
                                }
                            }
                        }
                    }else if(configArgsObject.getInteger("isWpzf")==2){
                        if (map2.get("f_tablename") != null) {
                            String f_tablename = map2.get("f_tablename").toString();
                            String f_splittablename = map2.get("f_splittablename") != null && StringUtils.isNotBlank(map2.get("f_splittablename").toString()) ? map2.get("f_splittablename").toString() : null;
                            String f_id = map2.get("f_id").toString();
                            if (org.apache.commons.lang3.StringUtils.isNotBlank(f_tablename)) {
                                String selectSql = "select uuid_generate_v4() f_id,'" + f_id + "' f_taskid,tb.f_id f_tbid,now() f_createtime,tb.f_status,tb.f_review_stage from " + f_tablename +
                                        " tb where  tb.f_jzrq <'" + dateString + "' and   (tb.f_review_stage<'95' or tb.f_review_stage is null) and not exists( select null from tbtsk_task_wpzf_tem where f_taskid = '" + f_id + "' and f_tbid = tb.f_id) ";
                                List<Map<String, Object>> maps = jdbcTemplate.queryForList(selectSql);
                                // 当前时间大于截止日期，图斑状态小于95且图斑没有超期流转记录,流转到市级待审核
                                String updateSql = " update " + f_tablename + " tb set f_status = '10' , f_review_stage = '95' , f_reject_status = null  where  f_jzrq <'" + dateString + "' and   (f_review_stage<'95' or f_review_stage is null) " +
                                        " and not exists( select null from tbtsk_task_wpzf_tem where f_taskid = '" + f_id + "' and f_tbid = tb.f_id)  ";
                                jdbcTemplate.execute(updateSql);
                                //子图斑流转
                                if (StringUtils.isNotBlank(f_splittablename)) {
                                    String updateSql1 = " update " + f_splittablename + " tb set f_status = '10' , f_review_stage = '95' , f_reject_status = null  where  f_jzrq <'" + dateString + "' and   (f_review_stage<'95' or f_review_stage is null) " +
                                            " and not exists( select null from tbtsk_task_wpzf_tem where f_taskid = '" + f_id + "' and f_tbid = f_splitedid ) ";
                                    jdbcTemplate.execute(updateSql1);
                                }
                                //记录流转信息
                                if (!maps.isEmpty()) {
                                    dataBizMapper.insertBatch("tbtsk_task_wpzf_tem", maps, null);
                                }
                            }
                        }
                    }
                }
            }

        }
    }

    public Map<String, Object> findTbWpzfStage(String taskId, List<String> tbids) {

        String sql = " SELECT  f_tbid, count(1) FROM tbtsk_approve_record AS approve WHERE approve.f_option='1' and " +
                "approve.f_is_revoked is null and approve.f_stepname ='市级审核' and approve.f_taskid = '"+taskId+"' " +
                "and  approve.f_tbid in ('"+ GutilStr.join(tbids,"','")+"')   group by f_tbid";
        Map<String, Object> map = new HashMap<>();
        try {
            List<Map<String, Object>> maps = jdbcTemplate.queryForList(sql);
            for(Map<String, Object> map1 : maps){
                map.put(map1.get("f_tbid").toString(),map1.get("count"));
            }
        } catch (Exception e) {

        }
        return map;
    }

    public JSONObject simpleGeomTbInfo(Long userId, TskTaskBiz tskTaskBiz, String tbId) throws
            Exception {
        //默认图斑分割后下发图斑到当前用户
        TbtskObjectinfo tbtskObjectinfo = tbtskObjectinfoRepository.getObjectByTableId(tskTaskBiz.getTableId());
        if(tbtskObjectinfo==null)
        {
            throw new GwValidateException("任务表对象不存在");
        }
        List<String>shapeField = new ArrayList<>();
        shapeField.add("f_shape");
        Map shape = mDataBizService.selectFieldByID(tbtskObjectinfo.getfTablename(), shapeField, "f_id", "'" + tbId + "'");
        if(shape==null&&StringUtils.isNotBlank(tbtskObjectinfo.getSplitTableName()))
        {
            shape = mDataBizService.selectFieldByID(tbtskObjectinfo.getSplitTableName(), shapeField, "f_id", "'" + tbId + "'");
        }
        String wkt = shape.get("f_shape")!=null?shape.get("f_shape").toString():"";
        if(StringUtils.isBlank(wkt))
        {
            throw new GwValidateException("当前图斑图形为空");
        }
        if(wkt.toUpperCase().startsWith("SRID=4490;"))
        {
            wkt = wkt.substring(10);
        }
        Geometry geo = WKTUtil.wktToGeom(wkt);
        if(geo.getNumGeometries()==1)
        {
            throw new GwValidateException("当前图斑图形为简单图形，不支持拆分");
        }
        List<String>wkts = new ArrayList<>();
        for(int i=0;i<geo.getNumGeometries();i++)
        {
            Geometry simpleGeo =  geo.getGeometryN(i);
            wkts.add(simpleGeo.toText());
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("wkts",wkts);
        return clipGeomTbInfo(userId, tskTaskBiz, tbId, jsonObject.toJSONString(), true, false, "2");
    }
}
