package com.geoway.landteam.landcloud.service.customtask.task;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.pub.entity.TaskRecord;
import com.geoway.landteam.customtask.servface.task.TaskRecordService;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.core.model.pub.constants.JobConstants;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import com.mchange.v2.uid.UidUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.UUID;

@Service
public class MTskTaskSyncService {

    GiLoger loger = GwLoger.getLoger(MTskTaskSyncService.class);
    @Value("${project.innerouter:outer}")
    String innerouter;

    @Autowired
    TaskRecordService taskRecordService;


    public void pushCreateTaskSync(TskTaskBiz tskTaskBiz, Long userId)
    {
        loger.info("同步内网任务到外网 inerouter:"+innerouter);
        //仅内网创建任务时同步到外网 不同步数据
        if(innerouter.equals("inner")) {
            loger.info("同步内网任务到外网 创建定时任务");
            String recordId = UUID.randomUUID().toString();
            JSONObject params = new JSONObject();
            params.put("filterType", "pushTaskData");
            params.put("userId", userId);
            params.put("taskId", tskTaskBiz.getId());
            params.put("recordId", recordId);
            //params.put("taskQueryParameter", null);
            // 任务下发记录
            TaskRecord record = new TaskRecord();
            record.setId(recordId);
            //数据下发3
            record.setTasktype(JobConstants.JOB_TYPE_DATA_ASSIGN);
            record.setState(1);
            //状态1创建，2执行中，3成功，4失败
            record.setParam(JSONObject.toJSONString(params));
            record.setData(recordId);
            record.setStarttime(new Date());
            record.setUserid(userId);
            record.setBizId(tskTaskBiz.getId());
            taskRecordService.save(record);
        }
    }

}
