package com.geoway.landteam.landcloud.service.customtask.task;

import com.geoway.landteam.customtask.repository.task.TbtskObjectinfoRepository;
import com.geoway.landteam.customtask.repository.task.TskTaskBizRepository;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.servface.customtask.task.ObjectTableNameService;
import com.geoway.landteam.patrolclue.dao.cluelibrary.JcClueSourceDao;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Optional;

/**
 * @Author Waves
 * @Date 2023/7/27
 * @Description
 **/
@Service
public class ObjectTableNameServiceImpl implements ObjectTableNameService {

    @Autowired
    protected JcClueSourceDao sourceDao;
    @Autowired
    protected TskTaskBizRepository tskTaskBizRepository;
    @Autowired
    protected TbtskObjectinfoRepository tbtskObjectinfoRepository;

    @Override
    public String getTablename(String objectid, Integer objectType) {
        if(objectType == 0){
            return objectid;
        }else if(objectType == 1){
            JcClueSource jcClueSource = sourceDao.gwSearchByPK(objectid);
            return jcClueSource.getfTablename();
        }else if(objectType == 2){
            String tableName = Optional.of(objectid)
                    .map(tskTaskBizRepository::findById)
                    .map(e-> e.<RuntimeException>orElseThrow(RuntimeException::new))
                    .map(TskTaskBiz::getTableId)
                    .map(tbtskObjectinfoRepository::findById)
                    .map(e-> e.<RuntimeException>orElseThrow(RuntimeException::new))
                    .map(TbtskObjectinfo::getfTablename)
                    .orElseThrow(()-> new RuntimeException("无效的任务表"));
            return tableName;
        }else {
            throw new RuntimeException("无效的对象类型");
        }
    }
    @Override
    public String getChildTablename(String objectid, Integer objectType) {
        if(objectType == 0){
            return objectid;
        }else if(objectType == 1){
            JcClueSource jcClueSource = sourceDao.gwSearchByPK(objectid);
            return jcClueSource.getfTablename();
        }else if(objectType == 2){
            String tableName = Optional.of(objectid)
                    .map(tskTaskBizRepository::findById)
                    .map(e-> e.<RuntimeException>orElseThrow(RuntimeException::new))
                    .map(TskTaskBiz::getTableId)
                    .map(tbtskObjectinfoRepository::findById)
                    .map(e-> e.<RuntimeException>orElseThrow(RuntimeException::new))
                    .map(TbtskObjectinfo::getSplitTableName)
                    .orElseThrow(()-> new RuntimeException("无效的任务表"));
            return tableName;
        }else {
            throw new RuntimeException("无效的对象类型");
        }
    }
}
