package com.geoway.landteam.landcloud.service.customtask.task;

import cn.hutool.core.codec.Base64;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.asymmetric.KeyType;
import cn.hutool.crypto.asymmetric.SM2;
import cn.hutool.crypto.symmetric.SM4;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.model.base.entity.AppMedia;
import com.geoway.landteam.landcloud.core.model.user.entity.LandUser;
import com.geoway.landteam.landcloud.core.repository.base.AppMediaRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandUserRepository;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.landcloud.dao.pub.AppMediaGjDao;
import com.geoway.landteam.landcloud.model.giht.entity.TbGjhtAssign;
import com.geoway.landteam.landcloud.model.pub.entity.AppMediaGj;
import com.geoway.landteam.landcloud.repository.gjht.TbGjhtAssignRepository;
import com.geoway.landteam.landcloud.service.cffx.MCffxTaskServiceImpl;
import com.geoway.landteam.landcloud.service.util.FileUtil;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import com.gw.base.util.GutilAssert;
import com.mchange.lang.IntegerUtils;
import com.sun.jersey.json.impl.provider.entity.JSONArrayProvider;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.awt.*;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.List;

@Service
public class SharedDataService {

    private final GiLoger logger = GwLoger.getLoger(SharedDataService.class);

    @Autowired
    TbGjhtAssignRepository tbGjhtAssignRepository;

    @Resource
    GjhtAssignService gjhtAssignService;

    @Autowired
    LandUserRepository landUserRepository;

    @Autowired
    DefaultOssOperatorService ossOperatorService;

    @Autowired
    TskTaskBizService tskTaskBizService;

    @Autowired
    AppMediaRepository appMediaDao;

    @Autowired
    DefaultOssOperatorService defaultOssOperatorService;

    @Autowired
    TemporarySignedUrlService temporarySignedUrlService;

    @Autowired
    MDataBizService dataBizService;

    @Resource
    AppMediaGjDao appMediaGjDao;


    String MEDIA_FROM = "FROM_GJ";
    // 查询举证成果共享数据
    public JSONObject findSharedData(String range, Integer buffer, String begintime, String endtime, Integer limit) throws Exception {

        int min = 1; // 范围的最小值
        int max = 50000; // 范围的最大值
        //数据判断，传递数据都不能为空
        if(StringUtils.isBlank(range) || ObjectUtils.isEmpty(buffer)){
            System.out.println("range与buffer 数据信息不完整！");
            logger.info("range与buffer 数据信息不完整！" );
            return null;
        }

        if (buffer == null || buffer <= min || buffer >= max) {
            System.out.println("缓冲区范围超界、系统不支持！");
            logger.info("缓冲区范围超界、系统不支持！" );
            return null;
        }
//      接口返回数据
        JSONObject resultData = new JSONObject();
//      请求参数数据
        JSONObject dataJson = new JSONObject();

//        String polygon = "POLYGON ((107.35639168341127 29.747474867209956,107.36744238455448 29.746860075498642,107.36613346655655 29.741969552623598,107.35671354849303 29.74211860065438,107.35639168341127 29.747474867209956))";
        dataJson.put("range",range);
        dataJson.put("buffer",buffer);
        if(StringUtils.isNotBlank(begintime)){
            dataJson.put("begintime",begintime);
        }
        if(StringUtils.isNotBlank(endtime)){
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            try {
                Date end=  df.parse(endtime);
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(end);
                calendar.add(Calendar.DAY_OF_MONTH,1);
                endtime = df.format(calendar.getTime());
            }
            catch (Exception ex)
            {

            }
            dataJson.put("endtime",endtime);
        }
        if(ObjectUtils.isNotEmpty(limit)){
            dataJson.put("limit",limit);
        }



        if(StringUtils.isBlank(gjhtAssignService.getKeyPublic()) || StringUtils.isBlank(gjhtAssignService.getKeyPrivate())
                || StringUtils.isBlank(gjhtAssignService.getGtUrl()) ){
            System.out.println("没有公钥或没有私钥或没有服务地址配置信息！");
            logger.info("没有公钥或没有私钥或没有服务地址配置信息！" );
            return null;
        }

        //创建 SM2
        SM2 sm2 = new SM2(gjhtAssignService.getKeyPrivate(), gjhtAssignService.getKeyPublic());
        //使用R|S裸格式，不使用ASN1(R|S)格式
        sm2.usePlainEncoding();
        //产生SM4随机密钥
        byte[] sm4Key = SecureUtil.generateKey("SM4").getEncoded();

        // 获取 平台身份认证Token
        String token = gjhtAssignService.getToken(sm2);
        if(StringUtils.isBlank(token)){
            return null;
        }
        // 获取 数据加密秘钥密文
        String secret = gjhtAssignService.getSecret(sm2,sm4Key);
        if(StringUtils.isBlank(secret)){
            return null;
        }

        Map<String,String> headerMap = new HashMap<>();
        headerMap.put("x-lc-secret",secret);
        headerMap.put("x-lc-token", token);

        String returnJsonObjectData = dataJson.toString();
//        System.out.println(" dataJson = " + returnJsonObjectData);
//        returnJsonObjectData = returnJsonObjectData.substring(1,returnJsonObjectData.length()-1);
//        System.out.println(" dataJson = " + returnJsonObjectData);
        String dataEncrypt = gjhtAssignService.getEncrypt(returnJsonObjectData, sm4Key);

//        《附录4 举证成果共享接口.pdf》文档中 3.1 发起查询
        HttpResponse httpResponse = HttpUtil.createPost(gjhtAssignService.getGtUrl()+"/EvidenceShare/CreateTask")
                .contentType("application/json").addHeaders(headerMap).body(dataEncrypt).execute();

        if(ObjectUtils.isEmpty(httpResponse)){
            logger.info("服务发起查询未返回任何结果！" );
            return null;
        }
        String result = httpResponse.body();
        String xLcSecret = httpResponse.header("x-lc-secret");

        if(StringUtils.isNotBlank(result) &&  (result.indexOf("\"code\": 200")!=-1 || result.indexOf("\"code\":200")!=-1)){
            resultData = JSONObject.parseObject(result);
//            任务编号
            String taskDataId = resultData.get("data").toString();

//          返回数据进行解密
            String data = gjhtAssignService.getDecrypt(sm2,taskDataId,xLcSecret);

            if(StringUtils.isNotBlank(data)){
                resultData.put("data",data);
            }


//            if(StringUtils.isNotBlank(taskDataId)){
//                boolean isState = true; // 接口请求标志 （任务失败：-1;等待运行：0;运行中：1;运行完成：2 ）
//                String stateData = "";
//                while (isState){
//                    //           《附录4 举证成果共享接口.pdf》文档中    3.2 获取查询状态
//                    String getUrl = gjhtAssignService.getGtUrl()+ "/EvidenceShare/GetState?requestid=" + taskDataId;
//                    logger.info("获取查询状态:"+getUrl);
//                    httpResponse = HttpUtil.createGet(getUrl).execute();
//                    String resultState = httpResponse.body();
//
//                    if(StringUtils.isNotBlank(resultState) &&  (resultState.indexOf("\"code\": 200")!=-1 || resultState.indexOf("\"code\":200")!=-1)){
//                        JSONObject resultStateData = JSONObject.parseObject(resultState);
//                        stateData = resultStateData.get("data").toString();
//                        if(stateData.equals("-1")){ // 任务失败：-1
//                            isState = false; // 接口请求操作结束
//                        }
//                        if(stateData.equals("2")){ // 运行完成：2
//                            isState = false; // 接口请求操作结束
//                        }
//                        if(!stateData.equals("-1") && !stateData.equals("2")){
//                            Thread.sleep(300); // 暂停300毫秒
//                        }
//                    } else {
//                        Thread.sleep(300); // 暂停300毫秒
//                        // 有问题 需要间隔多少时间后还没有准确查询结果 应用跳出轮询请求服务  6秒、1分钟、还是多少？？？
//                    }
//                }
//
//                if(stateData.equals("2")){ // 运行完成：2
//                    //           《附录4 举证成果共享接口.pdf》文档中   3.3 获取查询结果
//                    String getUrl = gjhtAssignService.getGtUrl()+ "/EvidenceShare/GetResult?requestid=" + taskDataId;
//                    logger.info("获取查询结果:"+getUrl);
//                    httpResponse = HttpUtil.createGet(getUrl).execute();
//                    String resultData = httpResponse.body();
//                    if(StringUtils.isNotBlank(resultData) &&  (resultData.indexOf("\"code\": 200")!=-1 || resultData.indexOf("\"code\":200")!=-1)){
//                        JSONObject jsonObjectData = JSONObject.parseObject(resultData);
//                        JSONObject jsonData =  jsonObjectData.getJSONObject("data");
//                        JSONArray jsonArrayList = jsonData.getJSONArray("FjInfoList");
//                        for (int i = 0; i < jsonArrayList.size(); i++) {
//                            JSONObject jsonObject = jsonArrayList.getJSONObject(i);
//                            if(ObjectUtils.isNotEmpty(jsonObject)){
//                                System.out.println(" URL = " + jsonObject.get("URL").toString());
//                            }
//                        }
//                    }
//
//                }
//
//            }

        } else {
            resultData = null;
        }

        return resultData;
    }


    // 获取查询状态
    public JSONObject getState(String taskDataId) throws Exception {

        //      接口返回数据
        JSONObject resultData = new JSONObject();

        if(StringUtils.isBlank(taskDataId)){
            logger.info("taskDataId任务编号不存在！" );
            return  resultData;
        }

        if(StringUtils.isBlank(gjhtAssignService.getKeyPublic()) || StringUtils.isBlank(gjhtAssignService.getKeyPrivate())
                || StringUtils.isBlank(gjhtAssignService.getGtUrl()) ){
            System.out.println("没有公钥或没有私钥或没有服务地址配置信息！");
            logger.info("没有公钥或没有私钥或没有服务地址配置信息！" );
            return null;
        }

        //创建 SM2
        SM2 sm2 = new SM2(gjhtAssignService.getKeyPrivate(), gjhtAssignService.getKeyPublic());
        //使用R|S裸格式，不使用ASN1(R|S)格式
        sm2.usePlainEncoding();
        //产生SM4随机密钥
        byte[] sm4Key = SecureUtil.generateKey("SM4").getEncoded();

        // 获取 平台身份认证Token
        String token = gjhtAssignService.getToken(sm2);
        if(StringUtils.isBlank(token)){
            return null;
        }
        // 获取 数据加密秘钥密文
//        String secret = gjhtAssignService.getSecret(sm2,sm4Key);
//        if(StringUtils.isBlank(secret)){
//            return null;
//        }

        Map<String,String> headerMap = new HashMap<>();
//        headerMap.put("x-lc-secret",secret);
        headerMap.put("x-lc-token", token);

//      《附录4 举证成果共享接口.pdf》文档中    3.2 获取查询状态
        String getUrl = gjhtAssignService.getGtUrl()+ "/EvidenceShare/GetState?requestid=" + taskDataId;
        logger.info("获取查询状态:"+getUrl);
        HttpResponse httpResponse = HttpUtil.createGet(getUrl)
                .contentType("application/json").addHeaders(headerMap).execute();

        if(ObjectUtils.isEmpty(httpResponse)){
            logger.info("服务发起查询未返回任何结果！" );
            return null;
        }

        String resultState = httpResponse.body();
        String xLcSecret = httpResponse.header("x-lc-secret");

        if(StringUtils.isNotBlank(resultState) &&  (resultState.indexOf("\"code\": 200")!=-1 || resultState.indexOf("\"code\":200")!=-1)){
            resultData = JSONObject.parseObject(resultState);
//            接口请求结果（任务失败：-1;等待运行：0;运行中：1;运行完成：2 )
            String stateData = resultData.get("data").toString();
//            返回数据进行解密
            String data = gjhtAssignService.getDecrypt(sm2,stateData,xLcSecret);
            resultData.put("data",data);
        } else {
            resultData = null;
        }
        return resultData;
    }

//    获取查询结果
    public JSONObject getResult(String taskDataId, String resize,String tbId) throws Exception {
        //      接口返回数据
        JSONObject resultData = new JSONObject();

        if(StringUtils.isBlank(taskDataId)){
            logger.info("taskDataId任务编号不存在！" );
            return  resultData;
        }

        //创建 SM2
        SM2 sm2 = new SM2(gjhtAssignService.getKeyPrivate(), gjhtAssignService.getKeyPublic());
        //使用R|S裸格式，不使用ASN1(R|S)格式
        sm2.usePlainEncoding();
        //产生SM4随机密钥
        byte[] sm4Key = SecureUtil.generateKey("SM4").getEncoded();

        // 获取 平台身份认证Token
        String token = gjhtAssignService.getToken(sm2);
        if(StringUtils.isBlank(token)){
            return null;
        }

        // 获取 数据加密秘钥密文
        /* get 请求不需要
        String secret = gjhtAssignService.getSecret(sm2,sm4Key);
        if(StringUtils.isBlank(secret)){
            return null;
        }
        */
        Map<String,String> headerMap = new HashMap<>();
//        headerMap.put("x-lc-secret",secret);
        headerMap.put("x-lc-token", token);

        // 《附录4 举证成果共享接口.pdf》文档中   3.3 获取查询结果
        String getUrl = gjhtAssignService.getGtUrl()+ "/EvidenceShare/GetResult?requestid=" + taskDataId;
        logger.info("获取查询结果:"+getUrl);

        HttpResponse httpResponse = HttpUtil.createGet(getUrl)
                .contentType("application/json").addHeaders(headerMap).execute();

        if(ObjectUtils.isEmpty(httpResponse)){
            logger.info("服务发起查询未返回任何结果！" );
            return null;
        }

        String data = httpResponse.body();
        String xLcSecret = httpResponse.header("x-lc-secret");

        if(StringUtils.isNotBlank(data) &&  (data.indexOf("\"code\": 200")!=-1 || data.indexOf("\"code\":200")!=-1)){
            resultData = JSONObject.parseObject(data);

            String resultDataSecret = resultData.getString("data");
//            返回数据进行解密
            String dataSecret = gjhtAssignService.getDecrypt(sm2,resultDataSecret,xLcSecret);
            List<AppMedia>appMediaList = null;
            if(StringUtils.isNotBlank(tbId)) {
                appMediaList = appMediaDao.queryALLByGid(tbId);
            }
            JSONArray jsonArrayList = JSONObject.parseArray(dataSecret);
            jsonArrayList = setId(jsonArrayList);
            jsonArrayList = restore(jsonArrayList,resize);
            jsonArrayList = setIsAttach(jsonArrayList,appMediaList);
            resultData.put("data",jsonArrayList);

        } else {
            resultData = null;
        }
        return  resultData;
    }


    // 保存举证成果共享数据
    public List<AppMedia> saveSharedData(String taskId,String tbbhId, JSONArray jsonArray) throws Exception {


        List<AppMedia> returnMediaList = null;

        if(StringUtils.isEmpty(taskId) || ObjectUtils.isEmpty(jsonArray) || StringUtils.isBlank(tbbhId)){
            throw new IllegalArgumentException("参数不能为空");
        }
        List<AppMedia>appMediaList = appMediaDao.queryALLByGid(tbbhId);
        HttpURLConnection httpURLConnection = null;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (int i = 0; i < jsonArray.size(); i++) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            if(ObjectUtils.isEmpty(returnMediaList)){
                returnMediaList = new ArrayList<AppMedia>();
            }

//            tbybh 图斑预编号
            String tbybh = jsonObject.getString("tbybh")!=null ? jsonObject.getString("tbybh") : "";
            String tcbm = jsonObject.getString("tcbm")!=null ? jsonObject.getString("tcbm") : "";
            String url = jsonObject.getString("url")!=null ? jsonObject.getString("url") : "";
            // xzqdm行政区代码
            String xzqdm = jsonObject.getString("xzqdm")!=null ? jsonObject.getString("xzqdm") :"";
            // 拍摄人员
            String psry = jsonObject.getString("psry")!=null ? jsonObject.getString("psry") :"";
//            lysb  来源设备(0:手机拍摄 1:无人机)
            Integer lysb = jsonObject.getInteger("lysb")!=null ? jsonObject.getInteger("lysb") : null;

//            pssj 拍摄时间
            String pssj = jsonObject.getString("pssj")!=null ? jsonObject.getString("pssj") :"";

//           psfyj  拍摄俯仰角
            String psfyj = jsonObject.getString("psfyj")!=null ? jsonObject.getString("psfyj") :"";

//            psjj 拍摄焦距
            Double psjj = jsonObject.getDouble("psjj")!=null ?jsonObject.getDouble("psjj") : null;


//           pshgj	number	拍摄横滚角
            Integer pshgj = jsonObject.getInteger("pshgj")!=null ? jsonObject.getInteger("pshgj") : null;

//            fjysgd	number	附件原始高度

//            fjyskd	number	附件原始宽度

//            zsdm	string	证书代码
//            String zsdm = jsonObject.getString("zsdm");

//            psjd	number	拍摄角度
            String psjd = jsonObject.getString("psjd")!=null ? jsonObject.getString("psjd") :"";

//            经度
            Double longitude = jsonObject.getDouble("longitude")!=null ?jsonObject.getDouble("longitude") : null;
//            纬度
            Double latitude = jsonObject.getDouble("latitude")!=null ?jsonObject.getDouble("latitude") : null;


            String filepath = StringUtils.split(url,"?")[0];
            String name = filepath.substring(filepath.lastIndexOf("/")+1);
            name = StringUtils.split(name,".")[0];
            String id= getId(name,tcbm,tbybh);
            if(appMediaList!=null&&appMediaList.stream().filter(t->id.equals(t.getCopyid())).findFirst().isPresent())
            {
                //已经挂接过了
                continue;
            }


            AppMediaGj appMediaGj =  appMediaGjDao.gwSearchByPK(id);

            // 文件名称
            String fjmc = UUID.randomUUID().toString();
            String suffix = ""; //文件后缀名称
            AppMedia media = new AppMedia();
            media.setCopyid(id);
            media.setFromSource(MEDIA_FROM);
//            类型 1-jpg/png 2-mp4 3-mp3 4-osgb 5-pdf 6-txt 7-word 8-excel 9-ppt 10-zip/rar
            if (url.contains(".jpg")) {
                media.setType(1);
                fjmc = fjmc+".jpg";
                suffix = ".jpg";
            } else if (url.contains(".png")) {
                media.setType(1);
                fjmc = fjmc+".png";
                suffix = ".png";
            } else if (url.contains(".mp4")) {
                media.setType(2);
                fjmc = fjmc+".mp4";
                suffix = ".mp4";
            } else if (url.contains(".mp3")) {
                media.setType(3);
                fjmc = fjmc+".mp3";
                suffix = ".mp3";
            } else if (url.contains(".osgb")) {
                media.setType(4);
                fjmc = fjmc+".osgb";
                suffix = ".osgb";
            } else if (url.contains(".pdf")) {
                media.setType(5);
                fjmc = fjmc+".pdf";
                suffix = ".pdf";
            } else {
                media.setType(1);
                fjmc = fjmc+".jpg";
                suffix = ".jpg";
            }

            String result="";
            Double size=0d;
            if(appMediaGj==null) {
                String objectname  = "media/" + taskId  + "/" + tbbhId + "/" + fjmc;

                // 统一资源
                URL httpUrl = new URL(url);
                // 连接类的父类，抽象类
                URLConnection urlConnection = httpUrl.openConnection();
                // http的连接类
                httpURLConnection = (HttpURLConnection) urlConnection;
                //设置超时
                httpURLConnection.setConnectTimeout(1000 * 60 * 10);
                //设置请求方式，默认是GET
                httpURLConnection.setRequestMethod("GET");
                // 设置字符编码
                httpURLConnection.setRequestProperty("Charset", "UTF-8");
                // 打开到此 URL引用的资源的通信链接（如果尚未建立这样的连接）。
                httpURLConnection.connect();

                // 文件大小
                int sizeInt =  httpURLConnection.getContentLength();
                size = Double.parseDouble(String.valueOf(sizeInt));
                InputStream inputStream = httpURLConnection.getInputStream();
                //创建上传文件
                String uploadDir = (String) ProjectConfig.getConfig(ProjectConfigEnum.UPLOAD_DIR.getKey());
                File dir = new File(uploadDir);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                File temFile = File.createTempFile("tmp", suffix, dir);
                FileUtils.copyInputStreamToFile(inputStream, temFile);
                result = defaultOssOperatorService.sendObject2Oss(objectname, temFile);

                if (inputStream != null) {
                    inputStream.close();
                }
                httpURLConnection.disconnect();

                // 删除创建的文件
                if (ObjectUtils.isNotEmpty(temFile)) {
                    FileUtils.delete(temFile);
                }
                if (StringUtils.isBlank(result)) {
                    // 对象存储出现问题，没获取到存储路径
                    continue;
                }


            }
            else
            {
                result = appMediaGj.getUrl();
                size = appMediaGj.getSize();
            }
//            主键
            media.setId(UUID.randomUUID().toString());
//            关联图斑id
            media.setGalleryid(tbbhId);
//            时间
            media.setCreateTime(String.valueOf(System.currentTimeMillis()));
//            文件相对路径
            media.setServerpath(result);
//            文件大小

            media.setMediasize(size);

            // 是否固定(1表示固定，0 表示不固定)
            media.setMark(0);
            //标识媒体的类型(0无类型，101整治前，102整治后)
            media.setTypetype(0);

            if(StringUtils.isNotBlank(psry)){
                // 拍摄人员
                media.setUsername(psry);
            }

            if(ObjectUtils.isNotEmpty(lysb)){
                // 设备来源:0:手机拍摄；1:无人机拍摄;2:web端浏览文件上传
                media.setDeviceSource(lysb);
            }

            if(ObjectUtils.isNotEmpty(longitude)){
                // 经度
                media.setLon(longitude);
            }

            if(ObjectUtils.isNotEmpty(latitude)){
                // 纬度
                media.setLat(latitude);
            }

//            f_bizid 任务主键 taskId
            media.setBizId(taskId);

            if(StringUtils.isNotBlank(pssj)){
                //            pssj 拍摄时间
                try {
                  Date date=  df.parse(pssj);
                  media.setTime(String.valueOf(date.getTime()));
                }
                catch (Exception ex)
                {
                    media.setTime(pssj);
                }

            }

            if(StringUtils.isNotBlank(psfyj)){
                //           psfyj 拍摄俯仰角
                media.setPsfyj(psfyj);
                media.setPitch(psfyj);
            }

            if(ObjectUtils.isNotEmpty(pssj)){
                //     f_focal 焦距
                media.setFocal(psjj);
            }

            if(ObjectUtils.isNotEmpty(pshgj)){
                //           f_roll 拍摄横滚角  pshgj	number	拍摄横滚角
                media.setRoll(pshgj);
            }


//            fjysgd	number	附件原始高度
//            fjyskd	number	附件原始宽度

            //            zsdm	string	证书代码
//            media.setZsdm(zsdm);

            if(StringUtils.isNotBlank(psjd)){
                //          f_azimuth  方位角 f_azimuth psjd	number	拍摄角度
                media.setAzimuth(psjd);
            }

            if(StringUtils.isBlank(media.getUsername()))
            {
                media.setUsername("复用国家");
            }
            AppMedia returnMedia = appMediaDao.save(media);
            returnMediaList.add(returnMedia);


        }

        if(ObjectUtils.isNotEmpty(httpURLConnection)){
            httpURLConnection.disconnect();
        }

        return  returnMediaList;
    }

    private JSONArray restore(JSONArray jsonArray,String resize)
    {
        if(jsonArray==null||jsonArray.isEmpty())
            return jsonArray;
        List<AppMediaGj>appMediaGjs = new ArrayList<>();
        List<String>urls = new ArrayList<>();
        for(int i=0;i<jsonArray.size();i++)
        {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            String url = jsonObject.getString("url");
            if(StringUtils.isBlank(url))
                continue;
            if(url.contains(gjhtAssignService.getGjObs()))
            {
                String id =jsonObject.getString("id");
                AppMediaGj appMediaGj =  appMediaGjDao.gwSearchByPK(id);
                if(appMediaGj!=null)
                {
                    String tempUrl = temporarySignedUrlService.getTemporarySignedUrl(null, appMediaGj.getUrl(), null);
                    jsonObject.put("url", tempUrl);
                }
                else
                {
                    urls.add(url);
                }
            }
            else {
                urls.add(url);
            }
        }
        urls =  getTempUrl(urls,resize);
        for(int i=0;i<jsonArray.size();i++)
        {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            String url = jsonObject.getString("url");
            url = StringUtils.split(url,"?")[0];

            String path = url.replace("http","https").replace("HTTP","https").replace("https://","");
            path = path.substring(path.indexOf("/")+1);


            //以下代码有问题，获取的临时地址会从http变成https
            //String tempUrl = urls.stream().filter(t->t.startsWith(finalUrl)).findFirst().orElse(null);
            String finalUrl = path;
            String tempUrl = urls.stream().filter(t->t.contains(finalUrl)).findFirst().orElse(null);
            if(!StringUtils.isBlank(tempUrl)) {
                jsonObject.put("url", tempUrl);
                if(tempUrl.contains(gjhtAssignService.getGjObs()))
                {

                    String tcbm=jsonObject.getString("tcbm");
                    if(StringUtils.isBlank(tcbm))
                    {
                        tcbm="tcbm";
                    }
                    String filepath = StringUtils.split(url, "?")[0];
                    String name = filepath.substring(filepath.lastIndexOf("/")+1);
                    byte [] bytes = getDownload(tempUrl);
                    int size = bytes.length;
                    ByteArrayInputStream is = new ByteArrayInputStream(bytes);
                    String sendObjName = "media/fromgj/" + tcbm +"/"+ name;
                    String newUrl = defaultOssOperatorService.sendObject2Oss(sendObjName, is);
                    try {
                        is.close();
                    }
                    catch (Exception ex)
                    {
                        logger.error("关闭 oss file InputStream error",ex);
                    }
                    tempUrl = temporarySignedUrlService.getTemporarySignedUrl(null, newUrl, null);
                    jsonObject.put("url", tempUrl);
                    String id =jsonObject.getString("id");
                    AppMediaGj appMediaGj = new AppMediaGj();
                    appMediaGj = new AppMediaGj();
                    appMediaGj.setId(id);
                    appMediaGj.setUrl(newUrl);
                    appMediaGj.setSourceurl(url);
                    appMediaGj.setJym(jsonObject.getString("jym"));
                    appMediaGj.setArg(jsonObject.getString("arg"));
                    appMediaGj.setPsfyj(jsonObject.getString("psfyj"));
                    appMediaGj.setFjysgd(jsonObject.getString("fjysgd"));
                    appMediaGj.setFjyskd(jsonObject.getString("fjyskd"));
                    appMediaGj.setLatitude(jsonObject.getString("latitude"));
                    appMediaGj.setLayername(jsonObject.getString("layername"));
                    appMediaGj.setLongitude(jsonObject.getString("longitude"));
                    appMediaGj.setLysb(jsonObject.getString("lysb"));
                    appMediaGj.setPshgj(jsonObject.getString("pshgj"));
                    appMediaGj.setPsjd(jsonObject.getString("psjd"));
                    appMediaGj.setPsjj(jsonObject.getString("psjj"));
                    appMediaGj.setPsry(jsonObject.getString("psry"));
                    appMediaGj.setPssj(jsonObject.getString("pssj"));
                    appMediaGj.setQuerytype(jsonObject.getString("querytype"));
                    appMediaGj.setTbybh(jsonObject.getString("tbybh"));
                    appMediaGj.setTcbm(jsonObject.getString("tcbm"));
                    appMediaGj.setXzqdm(jsonObject.getString("xzqdm"));
                    appMediaGj.setZsdm(jsonObject.getString("zsdm"));
                    appMediaGj.setSize(Double.parseDouble(String.valueOf(size)));
                    appMediaGjs.add(appMediaGj);
                    bytes=null;


                }
            }

        }


        if(!appMediaGjs.isEmpty())
        {
            appMediaGjDao.batchInsert(appMediaGjs);
        }
        return jsonArray;
    }
    private JSONArray setId(JSONArray jsonArray)
    {
        if(jsonArray==null||jsonArray.isEmpty())
            return jsonArray;

        for(int i=0;i<jsonArray.size();i++)
        {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            String url = jsonObject.getString("url");
            if(StringUtils.isBlank(url))
                continue;

            String tbybh = jsonObject.getString("tbybh");
            String tcbm = jsonObject.getString("tcbm");
            String filepath = StringUtils.split(url,"?")[0];
            String name = filepath.substring(filepath.lastIndexOf("/")+1);
            name = StringUtils.split(name,".")[0];
            String id= getId(name,tcbm,tbybh);

            jsonObject.put("id",id);

        }
        JSONArray result = new JSONArray();
        List<String>ids = new ArrayList<>();
        for(int i=0;i<jsonArray.size();i++)
        {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            String id = jsonObject.getString("id");
            if(ids.contains(id))
            {
                continue;
            }

            ids.add(id);
            result.add(jsonObject);
        }
        return result;
    }
    private JSONArray setIsAttach(JSONArray jsonArray,List<AppMedia>appMediaList)
    {
        if(jsonArray==null||jsonArray.isEmpty())
            return jsonArray;

        for(int i=0;i<jsonArray.size();i++)
        {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            String id =jsonObject.getString("id");
            if(appMediaList!=null&&!appMediaList.isEmpty()&&appMediaList.stream().filter(t->id.equals(t.getCopyid())).findFirst().isPresent())
            {
                jsonObject.put("isAttached",true);
            }
            else
            {
                jsonObject.put("isAttached",false);
            }

        }

        return jsonArray;
    }
    private List<String>getTempUrl(List<String>urls,String resize) {

        JSONObject paramJSONObject = new JSONObject();
        paramJSONObject.put("urls", urls);
        //图片转换大小设置(Thumbnail:缩略图 （默认值） Medium: 中等质量 Original:原图 )
        if (StringUtils.isBlank(resize)) {
            paramJSONObject.put("resize", "Original");
        }
        else
        {
            paramJSONObject.put("resize", resize);
        }


        Map<String, String> headerMap2 = new HashMap<>();
        //创建 SM22
        SM2 sm22 = new SM2(gjhtAssignService.getKeyPrivate(), gjhtAssignService.getKeyPublic());
        //使用R|S裸格式，不使用ASN1(R|S)格式
        sm22.usePlainEncoding();
        //产生SM4随机密钥
        byte[] sm4Key2 = SecureUtil.generateKey("SM4").getEncoded();

        // 获取 平台身份认证Token
        String token2 = gjhtAssignService.getToken(sm22);
        // 获取 数据加密秘钥密文
        String secret2 = gjhtAssignService.getSecret(sm22, sm4Key2);
        headerMap2.put("x-lc-secret", secret2);
        headerMap2.put("x-lc-token", token2);

        String returnJsonObjectData = paramJSONObject.toString();

        String dataEncrypt = gjhtAssignService.getEncrypt(returnJsonObjectData, sm4Key2);

        HttpResponse  httpResponse = HttpUtil.createPost(gjhtAssignService.getGtUrl() + "/landCloud/getTempSignature")
                .contentType("application/json").addHeaders(headerMap2).body(dataEncrypt).execute();

        if (ObjectUtils.isEmpty(httpResponse)) {
            logger.info("服务发起查询未返回任何结果！");
            return null;
        }

        String resultUrls = httpResponse.body();
        String  xLcSecret = httpResponse.header("x-lc-secret");

        if (StringUtils.isNotBlank(resultUrls) && (resultUrls.indexOf("\"code\": 200") != -1 || resultUrls.indexOf("\"code\":200") != -1)) {
            JSONObject resultUrlData = JSONObject.parseObject(resultUrls);

           String resultDataSecret = resultUrlData.getString("data");
           //返回数据进行解密
            String dataSecret = gjhtAssignService.getDecrypt(sm22, resultDataSecret, xLcSecret);

            JSONArray urlDatas = JSONObject.parseArray(dataSecret);
            if(urlDatas==null||urlDatas.isEmpty())
                return null;
            List<String>tempUrls = new ArrayList<>();
            for(int i=0;i<urlDatas.size();i++)
            {
                tempUrls.add(urlDatas.getString(i));
            }
            return tempUrls;
        }
        return null;
    }
    private byte[] getDownload(String uploadurl){
        InputStream inputStream = null;
        ByteArrayOutputStream byteArrayOutputStream=null;
        try {
            HttpURLConnection httpURLConnection = null;
            // 统一资源
            URL url = new URL(uploadurl);
            // 连接类的父类，抽象类
            URLConnection urlConnection = url.openConnection();
            // http的连接类
            httpURLConnection = (HttpURLConnection) urlConnection;
            //设置超时
            httpURLConnection.setConnectTimeout(1000 * 60*10);
            //设置请求方式，默认是GET
            httpURLConnection.setRequestMethod("GET");
            // 设置字符编码
            httpURLConnection.setRequestProperty("Charset", "UTF-8");
            // 打开到此 URL引用的资源的通信链接（如果尚未建立这样的连接）。
            httpURLConnection.connect();

            inputStream = httpURLConnection.getInputStream();
            byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int length;
            while ((length = inputStream.read(buffer)) != -1) {
                byteArrayOutputStream.write(buffer, 0, length);
            }
            // 最后关闭流是一个好习惯，尽管在这个特定的例子中可能不是必须的
            inputStream.close();
            // 什么时候关闭
            httpURLConnection.disconnect();

            byte [] bytes = byteArrayOutputStream.toByteArray();
            return bytes;
        }catch (Exception e){
            e.printStackTrace();
            return null;
        }
        finally {
            if(byteArrayOutputStream!=null)
            {
                try {
                    byteArrayOutputStream.close();
                }
                catch (Exception ex)
                {
                    logger.error("关闭流异常",ex);
                }
            }
        }

    }

    private String  getId(String name,String tcbm,String tbybh)
    {
        String id="";
        int hashCode = (tcbm+"_"+tbybh+"_"+name).hashCode();
        if(hashCode<0)
        {
            hashCode=hashCode*-1;
            id ="1"+String.valueOf(hashCode);
        }
        else
        {
            id ="2"+String.valueOf(hashCode);
        }
        return id;
    }

}
