package com.geoway.landteam.landcloud.service.customtask.task;

import com.geoway.landteam.customtask.repository.task.*;
import com.geoway.landteam.customtask.task.dto.TbtskTaskPiwenDto;
import com.geoway.landteam.customtask.task.entity.*;
import com.geoway.landteam.landcloud.core.model.base.entity.AppMedia;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.patrolclue.model.cluelibrary.entity.JcClueSource;
import com.gw.base.data.GwValidateException;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

import javax.xml.bind.ValidationException;
import java.io.IOException;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * @author panzhiguang
 * @Package com.geoway.landteam.landcloud.service.customtask.task
 * @date 2024/7/26 14:30
 */

@Service
@Transactional(rollbackFor = Exception.class)
public class TbtskTaskPiwenService {

    private static final GiLoger log = GwLoger.getLoger();

    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    TbtskTaskPiwenRepository tbtskTaskPiwenRepository;
    @Autowired
    TbtskTaskPiwenRelRepository tbtskTaskPiwenRelRepository;
    @Autowired
    TbtskTaskWpzfAttrRepository tbtskTaskWpzfAttrRepository;
    @Autowired
    DefaultOssOperatorService defaultOssOperatorService;
    @Autowired
    protected TemporarySignedUrlService temporarySignedUrlService;


    public   List<TbtskTaskPiwenDto> findPiwenByTaskIdAndDataId(String taskId, String tbId,String groupCode){
        String sql = " select rel.f_id relId,rel.f_tbid tbId,ttp.f_id  id,ttp.f_taskid taskId,ttp.f_dataid dataId,ttp" +
                ".f_type as type,ttp   .f_pzjg pzjg,ttp.f_pzwh pzwh,ttp.f_pzrq pzrq,ttp.f_xmmc xmmc,ttp.f_pwly pwly,ttp" +
                ".f_pzmj  pzmj,ttp.f_pznydmj pznydmj,ttp.f_pzgdmj pzgdmj,ttp.f_pzyjjbntmj pzyjjbntmj,ttp.f_pzjsydmj " +
                "pzjsydmj,ttp.f_pzwlymj pzwlymj,ttp.f_pwfj pwfj,ttp.f_pwplfj pwplfj,ttp.f_wbayy wbayy,ttp.f_yxqz " +
                "yxqz,ttp.f_dz dz,ttp.f_nz nz,ttp.f_xz xz,ttp.f_bz bz,ttp.f_userid userId,ttp.f_regioncode regionCode,ttp.f_pwlb pwlb,ttp.f_tdgylx tdgylx,ttp.f_onlyid onlyId,rel.f_groupcode groupCode from " +
                "tbtsk_task_piwen_rel rel,tbtsk_task_piwen ttp  where rel" +
                ".f_piwenid  = ttp.f_id and rel.f_taskid ='"+taskId+"' and rel.f_tbid ='"+tbId+"' ";
        if(StringUtils.isNotBlank(groupCode)){
            sql += " and rel.f_groupcode like '%"+groupCode+"%' ";
        }
        sql += " order by rel.f_createtime asc";
        List<TbtskTaskPiwenDto> dataList = jdbcTemplate.query(sql, new BeanPropertyRowMapper<>(TbtskTaskPiwenDto.class));
        if(dataList.size() > 0){
            for(TbtskTaskPiwenDto taskPiwenDto : dataList){
                taskPiwenDto.setIncrement(false);
                if(taskPiwenDto.getDataId().equals(taskPiwenDto.getTbId())){
                    taskPiwenDto.setIncrement(true);
                }
                if (StringUtils.isNotBlank(taskPiwenDto.getPwfj()) && !taskPiwenDto.getPwfj().contains("AccessKeyId")) {
                    String url = temporarySignedUrlService.getTemporarySignedUrl("",taskPiwenDto.getPwfj(), null);
                    taskPiwenDto.setPwfj(url);
                }
                if (StringUtils.isNotBlank(taskPiwenDto.getPwplfj()) && !taskPiwenDto.getPwplfj().contains("AccessKeyId")) {
                    String url = temporarySignedUrlService.getTemporarySignedUrl("",taskPiwenDto.getPwplfj(), null);
                    taskPiwenDto.setPwplfj(url);
                }
            }
        }
        return dataList;
    }


    public Map<String, Object> findPiwenList(Long userId, String taskId,String pzwh,String groupCode, int pageIndex, int pageSize)throws Exception {
        Map<String, Object> result = new HashMap<>();
        String sql = "select * from  tbtsk_task_piwen where 1 = 1  ";
        String countSql = "select count(1) from tbtsk_task_piwen where 1 = 1 ";

        if(StringUtils.isNotBlank(pzwh)){
            sql += " and f_pzwh like '%"+pzwh+"%'";
            countSql += " and f_pzwh like '%"+pzwh+"%'";
        }
        if(StringUtils.isNotBlank(groupCode)){
            sql += " and f_groupcode like '%"+groupCode+"%'";
            countSql += " and f_groupcode like '%"+groupCode+"%'";
        }
        int start = (pageIndex - 1) * pageSize;
        sql += " order by f_createtime desc limit " + pageSize + " offset " + start;
        List<Map<String, Object>> mapList = jdbcTemplate.queryForList(sql);
        Integer count = jdbcTemplate.queryForObject(countSql, Integer.class);
        result.put("datas", mapList);
        result.put("totalNum", count);
        return result;
    }

    public TbtskTaskPiwenDto addTbPiwen(TbtskTaskPiwenDto tbtskTaskPiwenDto, MultipartFile pwfile, MultipartFile pwslfile) throws Exception{
        TbtskTaskPiwen tbtskTaskPiwen = new TbtskTaskPiwen();
        BeanUtils.copyProperties(tbtskTaskPiwenDto,tbtskTaskPiwen);
        tbtskTaskPiwen.setCreateTime(new Timestamp(System.currentTimeMillis()));
        if(pwfile != null){
            // 获取文件名
            String fileName = pwfile.getOriginalFilename();
            // 获取文件后缀
            String ext = fileName.substring(fileName.lastIndexOf("."));
            String objectname = "media/" + tbtskTaskPiwenDto.getUserId() + "/" + tbtskTaskPiwenDto.getDataId() + "/" + System.currentTimeMillis() + "/" +fileName;
            String result = defaultOssOperatorService.sendObject2Oss(objectname, pwfile.getInputStream());
            tbtskTaskPiwen.setPwfj(result);
        }
        if(pwslfile != null){
            // 获取文件名
            String fileName = pwslfile.getOriginalFilename();
            // 获取文件后缀
            String ext = fileName.substring(fileName.lastIndexOf("."));
            String objectname = "media/" + tbtskTaskPiwenDto.getUserId() + "/" + tbtskTaskPiwenDto.getDataId() + "/" + System.currentTimeMillis() + "/" +fileName;
            String result = defaultOssOperatorService.sendObject2Oss(objectname, pwslfile.getInputStream());
            tbtskTaskPiwen.setPwplfj(result);
        }
       /* if(StringUtils.isNotBlank(tbtskTaskPiwenDto.getPzrq())){
                Long timeLong = null;
                try {
                    timeLong = Long.valueOf(tbtskTaskPiwenDto.getPzrq());
                } catch (NumberFormatException e) {
                    try {
                        Date date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(tbtskTaskPiwenDto.getPzrq());
                        timeLong = date.getTime();
                    } catch (ParseException parseException) {

                    }
                }
                if (timeLong != null) {
                    tbtskTaskPiwen.setPzrq(new Timestamp(timeLong));
                }
            }
        if(StringUtils.isNotBlank(tbtskTaskPiwenDto.getYxqz())){
                Long timeLong = null;
                try {
                    timeLong = Long.valueOf(tbtskTaskPiwenDto.getYxqz());
                } catch (NumberFormatException e) {
                    try {
                        Date date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(tbtskTaskPiwenDto.getYxqz());
                        timeLong = date.getTime();
                    } catch (ParseException parseException) {

                    }
                }
                if (timeLong != null) {
                    tbtskTaskPiwen.setYxqz(new Timestamp(timeLong));
                }
            }*/
            //插入批次数据
        TbtskTaskPiwen tbtskTaskPiwen1 = tbtskTaskPiwenRepository.save(tbtskTaskPiwen);
        //插入数据关联表
        TbtskTaskPiwenRel tbtskTaskPiwenRel = new TbtskTaskPiwenRel();
         tbtskTaskPiwenRel.setPiwenId(tbtskTaskPiwen1.getId());
         tbtskTaskPiwenRel.setTaskId(tbtskTaskPiwen1.getTaskId());
         tbtskTaskPiwenRel.setTbId(tbtskTaskPiwen1.getDataId());
         tbtskTaskPiwenRel.setUserId(tbtskTaskPiwenDto.getUserId());
         tbtskTaskPiwenRel.setGroupCode(tbtskTaskPiwen1.getGroupCode());
         tbtskTaskPiwenRel.setCreateTime(new Timestamp(System.currentTimeMillis()));
        tbtskTaskPiwenRelRepository.save(tbtskTaskPiwenRel);

        tbtskTaskPiwenDto.setId(tbtskTaskPiwen1.getId());
        tbtskTaskPiwenDto.setRelId(tbtskTaskPiwenRel.getId());
        tbtskTaskPiwenDto.setTbId(tbtskTaskPiwenRel.getTbId());
        tbtskTaskPiwenDto.setPwfj(tbtskTaskPiwen1.getPwfj());
        tbtskTaskPiwenDto.setPwplfj(tbtskTaskPiwen1.getPwplfj());
        return tbtskTaskPiwenDto;
    }

    /**
     * 关联批文
     * @param userId
     * @param piwenIds
     * @param taskId
     * @param tbId
     */
    public void relTbPiwen(Long userId,String piwenIds,String  taskId,String  tbId,String groupCode){
      List<String> piwenIdList = Arrays.asList(piwenIds.split(","));
      List<TbtskTaskPiwenRel> tbtskTaskPiwenRels = new ArrayList<>();
          for(String s : piwenIdList){
              List<TbtskTaskPiwenRel> rels =    tbtskTaskPiwenRelRepository.findPiwenByTaskIdAndDataIdAndPiwenId(taskId,  tbId, s);
              if(rels.size() <= 0 ){
                  //插入数据关联表
                  TbtskTaskPiwenRel tbtskTaskPiwenRel = new TbtskTaskPiwenRel();
                  tbtskTaskPiwenRel.setPiwenId(s);
                  tbtskTaskPiwenRel.setTaskId(taskId);
                  tbtskTaskPiwenRel.setTbId(tbId);
                  tbtskTaskPiwenRel.setUserId(userId);
                  tbtskTaskPiwenRel.setCreateTime(new Timestamp(System.currentTimeMillis()));
                  if(StringUtils.isNotBlank(groupCode)){
                      tbtskTaskPiwenRel.setGroupCode(groupCode);
                  }
                  tbtskTaskPiwenRels.add(tbtskTaskPiwenRel);
              }
          }
        tbtskTaskPiwenRelRepository.saveAll(tbtskTaskPiwenRels);
    }



    public TbtskTaskPiwen updateTbPiwen(TbtskTaskPiwenDto tbtskTaskPiwenDto, MultipartFile pwfile, MultipartFile pwslfile) throws Exception{
       if(StringUtils.isBlank(tbtskTaskPiwenDto.getId())){
           throw new GwValidateException("主键id不能为null");
       }
        TbtskTaskPiwen tbtskTaskPiwen = tbtskTaskPiwenRepository.findById(tbtskTaskPiwenDto.getId()).orElse(null);
       if(tbtskTaskPiwen == null ){
           throw new GwValidateException("未找到批文记录");
       }
        BeanUtils.copyProperties(tbtskTaskPiwenDto,tbtskTaskPiwen,"pwfj","pwplfj");
        tbtskTaskPiwen.setCreateTime(new Timestamp(System.currentTimeMillis()));
        if(pwfile != null){
            // 获取文件名
            String fileName = pwfile.getOriginalFilename();
            // 获取文件后缀
            String ext = fileName.substring(fileName.lastIndexOf("."));
            String objectname = "media/" + tbtskTaskPiwenDto.getUserId() + "/" + tbtskTaskPiwenDto.getDataId() + "/" + System.currentTimeMillis() + "/" +fileName;
            String result = defaultOssOperatorService.sendObject2Oss(objectname, pwfile.getInputStream());
            tbtskTaskPiwen.setPwfj(result);
        }
        if(pwslfile != null){
            // 获取文件名
            String fileName = pwslfile.getOriginalFilename();
            // 获取文件后缀
            String ext = fileName.substring(fileName.lastIndexOf("."));
            String objectname = "media/" + tbtskTaskPiwenDto.getUserId() + "/" + tbtskTaskPiwenDto.getDataId() + "/" + System.currentTimeMillis() + "/" +fileName;
            String result = defaultOssOperatorService.sendObject2Oss(objectname, pwslfile.getInputStream());
            tbtskTaskPiwen.setPwplfj(result);
        }
       /* if(StringUtils.isNotBlank(tbtskTaskPiwenDto.getPzrq())){
            Long timeLong = null;
            try {
                timeLong = Long.valueOf(tbtskTaskPiwenDto.getPzrq());
            } catch (NumberFormatException e) {
                try {
                    Date date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(tbtskTaskPiwenDto.getPzrq());
                    timeLong = date.getTime();
                } catch (ParseException parseException) {

                }
            }
            if (timeLong != null) {
                tbtskTaskPiwen.setPzrq(new Timestamp(timeLong));
            }
        }
        if(StringUtils.isNotBlank(tbtskTaskPiwenDto.getYxqz())){
            Long timeLong = null;
            try {
                timeLong = Long.valueOf(tbtskTaskPiwenDto.getYxqz());
            } catch (NumberFormatException e) {
                try {
                    Date date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(tbtskTaskPiwenDto.getYxqz());
                    timeLong = date.getTime();
                } catch (ParseException parseException) {

                }
            }
            if (timeLong != null) {
                tbtskTaskPiwen.setYxqz(new Timestamp(timeLong));
            }
        }*/
       tbtskTaskPiwenRepository.save(tbtskTaskPiwen);
        return tbtskTaskPiwen;
    }



    public void deleteTbPiwen(String relId){
        TbtskTaskPiwenRel tbtskTaskPiwenRel = tbtskTaskPiwenRelRepository.findById(relId).orElse(null);
        if(tbtskTaskPiwenRel == null ){
            throw new GwValidateException("未找到批文关联记录");
        }
        TbtskTaskPiwen tbtskTaskPiwen = tbtskTaskPiwenRepository.findById(tbtskTaskPiwenRel.getPiwenId()).orElse(null);
        if(tbtskTaskPiwen == null ){
            throw new GwValidateException("未找到批文记录");
        }
        List<TbtskTaskPiwenRel> rels =   tbtskTaskPiwenRelRepository.findPiwenByPiwenId(tbtskTaskPiwenRel.getPiwenId());
        if(rels.size() == 1 && rels.get(0).getTbId().equals(tbtskTaskPiwen.getDataId())){
            //删除关联数据
            tbtskTaskPiwenRelRepository.deleteById(relId);
            //删除批文
            tbtskTaskPiwenRepository.deleteById(rels.get(0).getPiwenId());
        }else if(rels.size() > 1 && !tbtskTaskPiwenRel.getTbId().equals(tbtskTaskPiwen.getDataId())){
            //删除关联数据
            tbtskTaskPiwenRelRepository.deleteById(relId);
        }else{
            throw new GwValidateException("还有其他批文关联记录不能删除批文");
        }
    }

    public  List<TbtskTaskPiwenRel> findPiwenByTaskIdAndDataId(String taskId,String tbId){
       return tbtskTaskPiwenRelRepository.findPiwenByTaskIdAndDataId(taskId,tbId);
    }

    public  List<TbtskTaskPiwenRel> findPiwenByTaskIdAndDataIds(String taskId,List<String> tbIds){
        return tbtskTaskPiwenRelRepository.findPiwenByTaskIdAndDataIds(taskId,tbIds);
    }




    public void uploadBatchAttachByWpzf(Long userId,String taskId,String tbId,String type,MultipartFile[] files) throws IOException {
        List<TbtskTaskWpzfAttr> tbtskTaskWpzfAttrs = new ArrayList<>();
        if(files.length >0 ){
            for(MultipartFile file : files){
                // 获取文件名
                String fileName = file.getOriginalFilename();
                // 获取文件后缀
                String ext = fileName.substring(fileName.lastIndexOf("."));
                String objectname = "media/" + userId + "/" + tbId + "/" + System.currentTimeMillis() + "/" +fileName;

                String contentType ="";
                TbtskTaskWpzfAttr media = new TbtskTaskWpzfAttr();
                media.setTaskId(taskId);
                if (ext.contains("jpg") || ext.contains("png")) {
                    media.setType("1");
                } else if (ext.contains("mp4")) {
                    media.setType("2");
                } else if (ext.contains("mp3")) {
                    media.setType("3");
                } else if (ext.contains("osgb")) {
                    media.setType("4");
                } else if (ext.contains("pdf")) {
                    media.setType("5");
                    contentType ="application/pdf";
                } else {
                    media.setType("6");
                }
                String result = defaultOssOperatorService.sendObject2Oss(objectname, file.getInputStream(),contentType);
                media.setSort(type);
                media.setTbId(tbId);
                media.setCreateTime(new Timestamp(System.currentTimeMillis()));
                media.setServerPath(result);
                media.setUserId(userId);
                tbtskTaskWpzfAttrs.add(media);
            }
            tbtskTaskWpzfAttrRepository.saveAll(tbtskTaskWpzfAttrs);
        }else{
            throw new GwValidateException("缺失文件附件");
        }
    }


    public void delAttachByWpzf(String attrId){
        tbtskTaskWpzfAttrRepository.deleteById(attrId);
    }

    public  List<TbtskTaskWpzfAttr> findAttrsByWpzf(String taskId,String tbId,String sort){
        List<TbtskTaskWpzfAttr> tbtskTaskWpzfAttrs = tbtskTaskWpzfAttrRepository.findByTaskIdAndTbIdAndType(taskId, tbId, sort);
         for(TbtskTaskWpzfAttr tbtskTaskWpzfAttr : tbtskTaskWpzfAttrs){
             if (StringUtils.isNotBlank(tbtskTaskWpzfAttr.getServerPath()) && !tbtskTaskWpzfAttr.getServerPath().contains("AccessKeyId")) {
                 String url = temporarySignedUrlService.getTemporarySignedUrl("",tbtskTaskWpzfAttr.getServerPath(), null);
                 tbtskTaskWpzfAttr.setTemPath(url);
             }
         }
        return tbtskTaskWpzfAttrs;
    }


    public  List<TbtskTaskWpzfAttr> findByTaskIdAndTbIdAndSort(String taskId,String tbId,String sort){
        List<TbtskTaskWpzfAttr> tbtskTaskWpzfAttrs = tbtskTaskWpzfAttrRepository.findByTaskIdAndTbIdAndType(taskId, tbId, sort);
        return tbtskTaskWpzfAttrs;
    }

}
