package com.geoway.landteam.landcloud.service.customtask.task.impl;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.enm.DownloadTypeEnum;
import com.geoway.landteam.customtask.pub.dto.DataDownloadRecord;
import com.geoway.landteam.customtask.pub.dto.DownloadParameter;
import com.geoway.landteam.customtask.pub.enm.DataDownloadStateEnum;
import com.geoway.landteam.customtask.pub.entity.TaskQueryParameter;
import com.geoway.landteam.customtask.pub.entity.TaskRecord;
import com.geoway.landteam.customtask.servface.pub.DataDownloadDailyTaskService;
import com.geoway.landteam.customtask.servface.pub.DataDownloadRecordService;
import com.geoway.landteam.customtask.servface.pub.DataDownloadZjdService;
import com.geoway.landteam.customtask.servface.pub.DownloadFileDailyTaskService;
import com.geoway.landteam.customtask.servface.task.TaskRecordService;

import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.service.pub.DownloadGeometryService;
import com.geoway.landteam.customtask.service.util.UuidUtil;
import com.geoway.landteam.customtask.task.entity.TbtskFields;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.common.util.base.FileUtil;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.landcloud.servface.customtask.task.MIDownloadService;
import com.geoway.landteam.landcloud.service.customtask.pub.impl.*;
import com.geoway.landteam.landcloud.service.customtask.task.MTbtskFieldsService;
import com.geoway.landteam.landcloud.service.customtask.task.MTbtskObjectinfoService;
import com.geoway.landteam.landcloud.service.patrolclue.pub.impl.MDownloadExcelDailyClueServiceImpl;
import com.geoway.landteam.landcloud.service.statistics.CgjcApproveRecordDetailService;
import com.geoway.landteam.landcloud.service.statistics.CgjcApproveRecordService;
import com.geoway.landteam.landcloud.service.statistics.CgjcProgressService;
import com.geoway.landteam.landcloud.service.statistics.GdLcTotalService;
import com.geoway.landteam.patrolclue.service.pub.impl.JcClueDownloadService;
import com.gw.base.log.GwLoger;
import com.gw.base.log.GiLoger;
import com.gw.base.data.GwValidateException;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.poi.ss.usermodel.*;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.BeanUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

import java.io.*;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

/**
 * @Author: zkn
 * @Date: 2020/7/3 14:24
 * @Description:
 */
@Service
public class MDownloadServiceImpl implements MIDownloadService {
    private final GiLoger logger = GwLoger.getLoger(MDownloadServiceImpl.class);
    @Value("${project.uploadDir}")
    String uploadDir;
    @Autowired
    RedisTemplate redisTemplate;
    @Autowired
    TaskRecordService taskRecordService;
    @Autowired
    DataDownloadDailyTaskService dataDownloadDailyTaskService;
    @Autowired
    MDataDownloadTakeHandService MDataDownloadTakeHandService;
    @Autowired
    DefaultOssOperatorService defaultOssOperatorService;
    @Autowired
    DataDownloadZjdService dataDownloadZjdService;

    @Autowired
    MMDownloadGeometryTakeHandKmlServiceImpl downloadGeometryTakeHandKmlService;
    @Autowired
    MMDownloadGeometryTakeHandShapeServiceImpl downloadGeometryTakeHandShapeService;
    @Autowired
    MDownloadGeometryDailyTaskKmlServiceImpl downloadGeometryDailyTaskKmlService;
    @Autowired
    MDownloadGeometryDailyTaskShapeServiceImpl downloadGeometryDailyTaskShapeService;
    @Autowired
    MDownloadExcelDailyTaskServiceImpl downloadExcelDailyTaskService;
    @Autowired
    DataDownloadRecordService dataDownloadRecordService;
    @Autowired
    MDownloadTxtDailyTaskServiceImpl  downloadTxtDailyTaskService;
    @Autowired
    TskTaskBizService tskTaskBizService;
    @Autowired
    MTbtskObjectinfoService tbtskObjectinfoService;


    private DownloadGeometryService downloadGeometryService;

    @Autowired
    MDownloadExcelDailyClueServiceImpl downloadExcelDailyClueService;

    private JcClueDownloadService jcClueDownloadService;

    @Autowired
    DownloadFileDailyTaskService downloadFileDailyTaskService;

    @Autowired
    CgjcApproveRecordService cgjcApproveRecordService;
    @Autowired
    CgjcProgressService cgjcProgressService;
    @Autowired
    GdLcTotalService gdLcTotalService;
    @Autowired
    CgjcApproveRecordDetailService cgjcApproveRecordDetailService;
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Autowired
    MTbtskFieldsService fieldsService;

    @Override
    public boolean runDataDownload(TaskRecord record) throws Exception {
        if (record == null) {
            return false;
        }
        logger.debug("runDataDownload 执行----开始-----");
        try {
            String parameter = record.getParam();
            if (StringUtils.isNotBlank(parameter)) {
                JSONObject jsonObject = JSONObject.parseObject(parameter);
                if (jsonObject != null) {
                    DownloadParameter downloadParameter = JSONObject.toJavaObject(jsonObject, DownloadParameter.class);
                    if (downloadParameter != null) {
                        String dataType = downloadParameter.getDataType();
                        String bizType = downloadParameter.getBizType();
                        if (StringUtils.isNotBlank(bizType)) {
                            switch (bizType.toLowerCase()) {
                                case "dailytask": {
                                    if (StringUtils.isNotBlank(dataType)) {
                                        switch (dataType.toLowerCase()) {
                                            case "attach": {
                                                DataDownloadRecord dataDownloadRecord = null;
                                                Object value = redisTemplate.opsForValue().get(downloadParameter.getRecordId());
                                                if (value != null) {
                                                    dataDownloadRecord =  JSONObject.toJavaObject(JSONObject.parseObject(value.toString()),DataDownloadRecord.class);
                                                    /*dataDownloadRecord = (DataDownloadRecord) JSONObject.toJavaObject(JSONObject.parseObject(JSONObject.toJSONString(value)), DataDownloadRecord.class);*/
                                                    if (dataDownloadRecord != null) {
                                                        dataDownloadDailyTaskService.downloadDailyTaskAttach(downloadParameter.getTaskId(), downloadParameter.getTbIds(), downloadParameter.getUserId(), dataDownloadRecord, downloadParameter.getDownloadType());
                                                    }
                                                }
                                            }
                                            break;
                                            case "kml": {
                                                downloadGeometryService = downloadGeometryDailyTaskKmlService;
                                                if (downloadGeometryService != null) {
                                                    boolean initSuccess = downloadGeometryService.init(downloadParameter);
                                                    if (initSuccess) {
                                                        downloadGeometryService.doDownload();
                                                    }
                                                }
                                            }
                                            break;
                                            case "shp":
                                            case "shape": {
                                                downloadGeometryService = downloadGeometryDailyTaskShapeService;
                                                if (downloadGeometryService != null) {
                                                    boolean initSuccess = downloadGeometryService.init(downloadParameter);
                                                    if (initSuccess) {
                                                        downloadGeometryService.doDownload();
                                                    }
                                                }
                                            }
                                            break;
                                            case "excel": {
                                                if ( downloadParameter.getType() != null && downloadParameter.getType().equals(DownloadTypeEnum.线索.getCode())) {
                                                        jcClueDownloadService = downloadExcelDailyClueService;
                                                        if (jcClueDownloadService != null){
                                                            com.geoway.landteam.patrolclue.model.pub.DownloadParameter downloadParameterClue = new com.geoway.landteam.patrolclue.model.pub.DownloadParameter();
                                                            BeanUtils.copyProperties(downloadParameter, downloadParameterClue);
                                                            boolean initSuccess = jcClueDownloadService.init(downloadParameterClue);
                                                            if (initSuccess) {
                                                                jcClueDownloadService.doDownloadClue();
                                                            }
                                                        }
                                                }else {
                                                     downloadGeometryService = downloadExcelDailyTaskService;
                                                    if (downloadGeometryService != null) {
                                                        boolean initSuccess = downloadGeometryService.init(downloadParameter);
                                                        if (initSuccess) {
                                                            downloadGeometryService.doDownload();
                                                        }
                                                    }
                                                }

                                            }
                                            break;
                                            case "zjgg": {
                                                if (downloadParameter != null) {
                                                    downloadFileDailyTaskService.export(downloadParameter);
                                                }
                                            }
                                            break;
                                            case "txt":
                                            {

                                                boolean initSuccess = downloadTxtDailyTaskService.init(downloadParameter);
                                                if (initSuccess) {
                                                    downloadTxtDailyTaskService.doDownload();
                                                }

                                            }
                                            break;
                                            default: {
                                                throw new GwValidateException("任务数据类型错误");
                                            }
                                        }
                                    }
                                }
                                break;
                                case "ssp": {
                                    if (StringUtils.isNotBlank(dataType)) {
                                        switch (dataType.toLowerCase()) {
                                            case "attach": {
                                                logger.debug("随手拍下载数据开始处理");
                                                DataDownloadRecord dataDownloadRecord = null;
                                                Object value = redisTemplate.opsForValue().get(downloadParameter.getRecordId());
                                                if (value != null) {
                                                  /*  dataDownloadRecord = (DataDownloadRecord) JSONObject.parseObject(JSONObject.toJSONString(value), DataDownloadRecord.class);*/
                                                    dataDownloadRecord =  JSONObject.toJavaObject(JSONObject.parseObject(value.toString()),DataDownloadRecord.class);
                                                    if (dataDownloadRecord != null) {
                                                        MDataDownloadTakeHandService.downloadTakeHandAttach(downloadParameter.getTbIds(), downloadParameter.getTbNames(), downloadParameter.getUserId(), dataDownloadRecord);
                                                    }
                                                }
                                            }
                                            break;
                                            case "kml": {
                                                downloadGeometryService = downloadGeometryTakeHandKmlService;
                                                if (downloadGeometryService != null) {
                                                    boolean initSuccess = downloadGeometryService.init(downloadParameter);
                                                    if (initSuccess) {
                                                        downloadGeometryService.doDownload();
                                                    }
                                                }
                                            }
                                            break;
                                            case "shp":
                                            case "shape": {
                                                downloadGeometryService = downloadGeometryTakeHandShapeService;
                                                if (downloadGeometryService != null) {
                                                    boolean initSuccess = downloadGeometryService.init(downloadParameter);
                                                    if (initSuccess) {
                                                        downloadGeometryService.doDownload();
                                                    }
                                                }
                                            }
                                            default: {
                                                throw new GwValidateException("任务数据类型错误");
                                            }
                                        }
                                    }
                                }
                                break;
                                case "zjd": {
                                    DataDownloadRecord dataDownloadRecord = null;
                                    Object value = redisTemplate.opsForValue().get(downloadParameter.getRecordId());
                                    if (value != null) {
                                       /* dataDownloadRecord = (DataDownloadRecord) JSONObject.toJavaObject(JSONObject.parseObject(JSONObject.toJSONString(value)), DataDownloadRecord.class);*/
                                        dataDownloadRecord =  JSONObject.toJavaObject(JSONObject.parseObject(value.toString()),DataDownloadRecord.class);
                                        if (dataDownloadRecord != null) {
                                            dataDownloadRecord.setBatchOpr(true);
                                            dataDownloadZjdService.doDownloadData(downloadParameter.getTaskId(), downloadParameter.getTbIds(), downloadParameter.getUserId(), dataDownloadRecord, downloadParameter.getDownloadType());
                                        }
                                    }
                                }
                                break;
                                case "statistics": {
                                    if(downloadParameter.getDataType().equals("approveRecord")){ //常规监测审核记录
                                        return   cgjcApproveRecordService.runDownloadCgjcApprove(record,downloadParameter);
                                    }else if(downloadParameter.getDataType().equals("approveRecordDetail")){ //审核记录详情
                                        return   cgjcApproveRecordDetailService.runDownloadCgjcApproveDetail(record,downloadParameter);
                                    }else if(downloadParameter.getDataType().equals("progressRecord")){ //常规监测进度汇总
                                           cgjcProgressService.runDownloadCgjcProgress(record,downloadParameter);
                                    }else if(downloadParameter.getDataType().equals("gdLrLcRecord")){ //耕地流入流出
                                        gdLcTotalService.runDownloadGdLrLcTotalExcel(record,downloadParameter);
                                    }
                                }
                                break;
                                default: {
                                    throw new GwValidateException("任务数据类型错误");
                                }
                            }
                        }
                    }
                }
            }
            return true;
        } catch (Exception e) {
            throw e;
        }
    }

    @Override
    public boolean runDataDownloadByWpzf(TaskRecord record) throws Exception {
        DataDownloadRecord downloadRecord = dataDownloadRecordService.findeOne(record.getId());
        downloadRecord.setStartTime(new Date());
        downloadRecord.setState(DataDownloadStateEnum.PACKING);
        dataDownloadRecordService.update(downloadRecord);
        try{
            JSONObject paramsObject = JSONObject.parseObject(record.getParam());
            TaskQueryParameter queryParameter = JSONObject.parseObject(paramsObject.getString("taskQueryParameter"),TaskQueryParameter.class);
            String taskId = queryParameter.getTaskId();
            TskTaskBiz tskTaskBiz = tskTaskBizService.findByTaskId(taskId);
            TbtskObjectinfo tbtskObjectinfo = null;
            if (tskTaskBiz != null && StringUtils.isNotBlank(tskTaskBiz.getTableId())) {
                tbtskObjectinfo = tbtskObjectinfoService.getObjectbyID(tskTaskBiz.getTableId());
            }
            List<Map<String, Object>> maps = new ArrayList<>();
            String fields = fieldList2(queryParameter.getTaskId());
            //获取数据
            if(StringUtils.isNotBlank(queryParameter.getTbIds())){
                String sql = " select "+fields+ " from "+tbtskObjectinfo.getfTablename()+ " where f_id in ( '" +
                        queryParameter.getTbIds().replace(",", "','") + "' )";
                maps = jdbcTemplate.queryForList(sql);
            }else{
                Pair<String, String> queryParamPair = tskTaskBizService.parseQueryParameter(queryParameter);
                String tableName = queryParamPair.getKey();
                String where = queryParamPair.getValue();
                String count = " select count(1) from " + tableName + " where " + where;
                Integer integer = jdbcTemplate.queryForObject(count, Integer.class);
                int rows = 5000;
                int page = integer%rows==0?integer/rows:(integer/rows)+1;
                for (int i = 1;i<= page ;i ++) {
                    String sql = " select "+fields +" from "+ tableName + "  where  "+where + " limit " + rows + " offset " + (i-1)*rows;
                    maps.addAll(jdbcTemplate.queryForList(sql));
                }
            }
            ClassPathResource tbjxlxfx = new ClassPathResource("/static/excel/卫片执法定制明细表.xlsx");
            InputStream tbjxlxfxInputStream = tbjxlxfx.getInputStream();
            //生成目标文件
            String id = UUID.randomUUID().toString().replace("-","");
            File tbjxlxfxFile = File.createTempFile("template_tbjxlxfx_copy"+id, ".xlsx");
            try {
                FileUtils.copyInputStreamToFile(tbjxlxfxInputStream, tbjxlxfxFile);
            } finally {
                IOUtils.closeQuietly(tbjxlxfxInputStream);
            }
            File barray =  exportExcel(maps,tbjxlxfxFile,tbtskObjectinfo.getSplitTableName(),tbtskObjectinfo.getfId());
            try {
                //将文件上传到obs上
                SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
                String dateString = sdf.format(new Date());
                String obsFilePath = "wpzfExcel/" + taskId + "/项目明细_" + dateString + ".xlsx";
                String resultUrl = defaultOssOperatorService.sendObject2Oss(obsFilePath, barray);
                downloadRecord.setTbCount(maps.size());
                if (resultUrl != null) {
                    downloadRecord.setUrl(resultUrl);
                    downloadRecord.setState(DataDownloadStateEnum.FINISTHE);
                    downloadRecord.setEndTime(new Date());
                    // 计算大小
                    Double zipFileSize = barray.length() / 1024d;
                    downloadRecord.setAttachSize(zipFileSize);
                }
                dataDownloadRecordService.update(downloadRecord);
            } finally {
                if(barray!=null)
                    barray.delete();
            }
        }catch (Exception e){
            e.printStackTrace();
            downloadRecord.setState(DataDownloadStateEnum.FAILED);
            downloadRecord.setEndTime(new Date());
            dataDownloadRecordService.update(downloadRecord);
            throw e;
        }
        return true;
    }

   public File exportExcel(List<Map<String, Object>> maps, File templateFile,String splitTableName,String tableId) throws IOException {
       if (maps == null) {
           return null;
       }
       if(uploadDir == null){
           uploadDir = (String) ProjectConfig.getConfig(ProjectConfigEnum.UPLOAD_DIR.getKey());
       }
       String tempFolderPath = new StringBuilder().append(uploadDir).toString();
       FileUtil.creatDirectoryIfNotExist(tempFolderPath);
       String fileName = UUID.randomUUID() + ".xlsx";
       String filePath = uploadDir + File.separator + fileName;

       Workbook wb = null;
       XSSFWorkbook header = null;
       FileInputStream fileInputStream = null;
       byte[] barray = null;
       ByteArrayOutputStream bos = null;
       OutputStream os = null;
       File file = null;
       try {
           fileInputStream = new FileInputStream(templateFile);
           header = new XSSFWorkbook(fileInputStream);
           wb = new SXSSFWorkbook(header);
           tbjxlxfxSheet(wb, maps,splitTableName,tableId);
           os = new FileOutputStream(filePath);
           wb.write(os);
           file = new File(filePath);
           //barray = bos.toByteArray();
//           if (wb != null) {
//                file = new File(filePath);
//               os = new FileOutputStream(file);
//               wb.write(os);
//               // 删除临时文件，很重要，否则磁盘可能会被写满
//           }
           logger.info("excel完成！！！！！");

       } catch (Exception ex) {
           ex.printStackTrace();
           throw ex;
       } finally {
           if (wb != null) {
               try {
                   wb.close();
               } catch (IOException e) {
                   e.printStackTrace();
               }
           }
           if (fileInputStream != null) {
               try {
                   fileInputStream.close();
               } catch (IOException e) {
                   e.printStackTrace();
               }
           }
           if (os != null) {
               try {
                   os.close();
               } catch (IOException e) {
                   e.printStackTrace();
               }
           }
           if (bos != null) {
               try {
                   bos.close();
               } catch (IOException e) {
                   e.printStackTrace();
               }
           }
       }
       return file;

   }

    /**
     * 卫片执法定制项目清单下载
     * @param wb
     * @param maps
     */
    private void tbjxlxfxSheet(Workbook wb, List<Map<String, Object>> maps, String splitTableName, String tableId) {
        List<TbtskFields> list = fieldsService.getAllFieldsByTableID(tableId);
        //查询任务id
        TbtskObjectinfo tbtskObjectinfo = tbtskObjectinfoService.getObjectbyID(tableId);
        //将字符串和数值类型的数据分组
        List<String> StringList = new ArrayList<>();
        List<String> numList = new ArrayList<>();
        for(TbtskFields fields : list){
            if(fields.getfFieldtype().equals("3")){
                numList.add(fields.getfFieldname());
            }else if(fields.getfFieldtype().equals("1") || fields.getfFieldtype().equals("2")){
                StringList.add(fields.getfFieldname());
            }
        }
        Sheet  workSheet = wb.getSheetAt(0);
        Row row;
        CellStyle cellStyle = wb.createCellStyle();
        cellStyle.setBorderBottom(BorderStyle.THIN); //下边框
        cellStyle.setBorderLeft(BorderStyle.THIN);//左边框
        cellStyle.setBorderTop(BorderStyle.THIN);//上边框
        cellStyle.setBorderRight(BorderStyle.THIN);//右边框
        List<String> fieldList = fieldList2List();
        String fields = fieldList2(tbtskObjectinfo.getTaskId());
        int dataRow = 3;
        List<String> ids = maps.stream().map(r -> r.get("id").toString()).collect(Collectors.toList());
        int size = ids.size();
        int rows = 5000;
        int page = size%rows == 0 ? size/rows:(size/rows)+1;
        List<Map<String, Object>> AllchildMaps = new ArrayList<>();
        for (int i = 1; i <= page; i++) {
            String sql = " select  "+fields+ ",f_splitedid from "+splitTableName+ " tb where f_splitedid in ('" +ids.stream().skip((i-1)*rows).limit(rows).collect(Collectors.joining("','"))+ "') ";
            AllchildMaps.addAll(jdbcTemplate.queryForList(sql));
        }
        //查询所有子图斑
        int count = 0;
        // 添加数据
        if (maps.size() > 0) {
            for(Map<String, Object> map : maps){
                count = count +1;
                String  f_issplitted = MapUtils.getString(map, "f_issplitted", "");
                if(StringUtils.isNotBlank(f_issplitted) && "1".equals(f_issplitted)){
                    String  f_id = MapUtils.getString(map, "id", "");
                    List<Map<String, Object>> childMaps = new ArrayList<>();
                    if(!AllchildMaps.stream().filter(r->f_id.equals(r.get("f_splitedid").toString())).collect(Collectors.toList()).isEmpty()){
                        childMaps  = AllchildMaps.stream().filter(r->f_id.equals(r.get("f_splitedid").toString())).collect(Collectors.toList());
                    }else{
                        continue;
                    }
                    //处理母图斑
                    row = workSheet.createRow(dataRow);
                    for (int j = 0; j < fieldList.size(); j++) {
                        String fieldName = fieldList.get(j);
                        Cell cell0 = row.createCell(j);
                        if(j > 84  && j < 155){
                            if(StringList.contains(fieldName)){
                                String fieldValue = "";
                                for(Map<String, Object> map1 : childMaps){
                                    if(map1.get(fieldName) != null){
                                         fieldValue += map1.get(fieldName)+";";
                                    }
                                }
                                cell0 .setCellValue(fieldValue);
                            }else if(numList.contains(fieldName)){
                                Double fieldValue = 0D;
                                for(Map<String, Object> map1 : childMaps){
                                    if(map1.get(fieldName) != null){
                                        fieldValue =  fieldValue + Double.valueOf(map1.get(fieldName).toString());
                                    }
                                }
                                if("0".equals(fieldValue.toString())){
                                    cell0 .setCellValue("");
                                }else{
                                    cell0 .setCellValue(fieldValue);
                                }
                            }
                        }else{
                            if("cf".equals(fieldName)){
                                cell0 .setCellValue("被拆分");
                            }else{
                                cell0 .setCellValue(map.get(fieldName) != null ? map.get(fieldName).toString(): null);
                            }
                        }
                        cell0.setCellStyle(cellStyle);
                    }
                    dataRow++;

                    //处理子图斑
                    for(Map<String, Object> map1 : childMaps){
                        row = workSheet.createRow(dataRow);
                        for (int j = 0; j < fieldList.size(); j++) {
                            String fieldName = fieldList.get(j);
                            Cell cell0 = row.createCell(j);
                            if("cf".equals(fieldName)){
                                cell0 .setCellValue("拆分");
                            }else{
                                cell0 .setCellValue(map1.get(fieldName) != null ? map1.get(fieldName).toString(): null);
                            }
                            cell0.setCellStyle(cellStyle);
                        }
                        dataRow++;
                    }
                }else{
                    row = workSheet.createRow(dataRow);
                    for (int j = 0; j < fieldList.size(); j++) {
                        String fieldName = fieldList.get(j);
                        Cell cell0 = row.createCell(j);
                        cell0 .setCellValue(map.get(fieldName) != null ? map.get(fieldName).toString(): null);
                        cell0.setCellStyle(cellStyle);
                    }
                    dataRow++;
                }
            }
        }
    }

    public String fieldList2(String taskId){
        String field = " ROW_NUMBER() over() xh,f_sjxzqdm,f_sjxzqmc,f_xjxzqdm,f_xjxzqmc,f_xzqdm,f_xzqmc,f_jcbh,f_jcpc,f_xfsj,f_tblx,f_tbfl,f_zlwz,f_jcmj_n1,f_gdmj_n1,f_yjjbntmj,f_nydmj_n1,f_jsy_n1,f_wlydmj,f_stbhhxmj,f_gdbhmbmj,f_czkfbjmj, " +
                "                f_ydspmjm+f_tdgymjm+f_zjggjxzs+f_zjggjxdk+f_gkfqdjxm+f_bdcdjmjm pwth,f_bdcdjzgd,f_bdcdjzyj,f_ydspzb+f_tdgyzb+f_zjggj_n1+f_zjggj_n2+f_gkfqdjxz+f_bdcdjzb sxthbl,   " +
                "                f_ydsppzwh||','||f_tdgypzwh||','||f_zjggj_n6||','||f_zjggj_n4||','||f_gkfqdpzw||','||f_bdcqzh sxthwh,  " +
                "                f_ydspmjm,f_ydspzb,f_ydspxmmc,f_ydsppzwh,f_tdgymjm,f_tdgyzb,f_tdgyxmmc,f_tdgypzwh,f_zjggjxzs,f_zjggj_n1,f_zjggj_n3,f_zjggj_n6,f_zjggjxdk,f_zjggj_n2,f_zjggj_n4,f_zjggj_n5,f_gkfqdjxm,f_gkfqdjxz,f_gkfqdjxx,f_gkfqdpzw,f_zjggcjqm,f_zjggcjqz,f_zjggcjqx,' ' f_zjggcjqp,  " +
                "                f_bdcdjxmm,f_bdcqzh,f_bdcdjmjm,f_bdcdjzgd,f_bdcdjzyj,f_bdcdjzb,f_ssnydxm,f_ssnydstr,f_ssnydmj,f_ssnydzgd,f_ssnydzyj,f_lsydxmmc,f_lsydpzwh,f_lsydmj,f_lsydzgdm,f_lsydz_n1,f_tdzzmj,f_tdzzzb,f_tdzzxmmc,f_tdzzpzwh,f_stxfmj,f_stxfzb,f_stxfxmmc,f_stxfpzwh,f_ckqmj,f_ckqzb,f_ckqxmmc,f_ckqpzwh,f_tkqmj,f_tkqzb,f_tkqxmmc,f_tkqpzwh,f_dkbh,  " +
                "                '' cf,f_dkbs,f_dkmj,f_nydmj_n1,f_gdmj_n1,f_yjjbntmj,f_jsy_n1,f_wlydmj,to_char(to_timestamp(substr(f_submittime,1,10)::int8),'YYYY-mm-dd') tbsj,f_jzrq,  " +
                "                ( select case when count > 0 then '是' else '否' end from (select count(1) from tbtsk_task_wpzf_tem wpzf where wpzf.f_taskid = '"+taskId+"' and wpzf.f_tbid = tb.f_id ) g ) sfcq,f_sfbgwjsy,f_tbjsqk,f_pdlx,f_hflx,  " +
                "                (select string_agg(f_pzwh,',') from tbtsk_task_piwen where f_taskid = '"+taskId+"' and f_dataid = tb.f_id) pzwh, " +
                "                f_wflx,f_qtlx,f_yblqthfy,f_fnhwfydl,f_xzfnjswf,f_sdwbhlx,f_clfnjswf,f_pzsj,f_wgjylx,f_flhwfwgy,f_nyssjswf,f_sjfzlgyw,f_wfzdlx,f_wfpzzylx,f_wfgdlx,f_hfydsjyt,f_wfydsjyt,f_sfxzlzgd,f_sfwhzj,f_sfdpf,f_sfyfyhfz,f_sfbzxajz,f_sfjjxm,f_sfgefqc,f_sfwjbs,f_pdyjsm,f_xzwfpdyj,f_xmlx,f_xmmc,f_xmzt,f_lxpzjg,f_lxpzwh,f_clfs,f_labh,f_yjdbm,f_bylalx,f_bylasm,f_zglsqk,f_hftdy_n2,f_fgdwmj,f_ccyjj_n2,f_bbmjm_n1,f_bbgdmj,f_bbjbntmj,  " +
                "                (select string_agg(f_pzwh,',') from tbtsk_task_piwen where f_taskid = '"+taskId+"' and f_dataid = tb.f_id) bbsxpzwh,f_bbsxlx, " +

                "                (select case when f_option = 1 then '通过' when f_option = 2 then '未通过' when f_option = 3 then '暂存' when f_option = 0 then '退回' else '' end  from (select * from (select f_option,f_approve_time from  tbtsk_approve_record where f_stepname = '区县审核' and f_is_revoked is null and tbtsk_approve_record.f_taskid = '"+taskId+"' and tbtsk_approve_record.f_tbid=tb.f_id union all select 0 f_option,f_reject_time f_approve_time from tbtsk_reject_record where tbtsk_reject_record.f_tbid = tb.f_id and  tbtsk_reject_record.f_taskid = '"+taskId+"' and f_stepname = '区县审核' ) g order by f_approve_time desc limit 1 )g) xianshjg,  " +
                "                (select f_remark  from (select * from (select f_remark,f_approve_time from  tbtsk_approve_record where f_stepname = '区县审核' and f_is_revoked is null and tbtsk_approve_record.f_taskid = '"+taskId+"' and tbtsk_approve_record.f_tbid=tb.f_id union all select f_remark,f_reject_time f_approve_time from tbtsk_reject_record where tbtsk_reject_record.f_tbid = tb.f_id and  tbtsk_reject_record.f_taskid = '"+taskId+"' and f_stepname = '区县审核' ) g order by f_approve_time desc limit 1 )g) xianshyj,  " +
                "                (select f_approve_time  from (select * from (select f_approve_time from  tbtsk_approve_record where f_stepname = '区县审核' and f_is_revoked is null and tbtsk_approve_record.f_taskid = '"+taskId+"' and tbtsk_approve_record.f_tbid=tb.f_id union all select f_reject_time f_approve_time from tbtsk_reject_record where tbtsk_reject_record.f_tbid = tb.f_id and  tbtsk_reject_record.f_taskid = '"+taskId+"' and f_stepname = '区县审核' ) g order by f_approve_time desc limit 1 )g) xianshsj,   " +
                "                (select f_approve_user  from (select * from (select f_approve_user,f_approve_time from  tbtsk_approve_record where f_stepname = '区县审核' and f_is_revoked is null and tbtsk_approve_record.f_taskid = '"+taskId+"' and tbtsk_approve_record.f_tbid=tb.f_id union all select f_username f_approve_user,f_reject_time f_approve_time from tbtsk_reject_record where tbtsk_reject_record.f_tbid = tb.f_id and  tbtsk_reject_record.f_taskid = '"+taskId+"' and f_stepname = '区县审核' ) g order by f_approve_time desc limit 1 )g) xianshry,  " +

                "                (select case when f_option = 1 then '通过' when f_option = 2 then '未通过' when f_option = 3 then '暂存' when f_option = 0 then '退回' else '' end  from (select * from (select f_option,f_approve_time from  tbtsk_approve_record where f_stepname = '市级审核' and f_is_revoked is null and tbtsk_approve_record.f_taskid = '"+taskId+"' and tbtsk_approve_record.f_tbid=tb.f_id union all select 0 f_option,f_reject_time f_approve_time from tbtsk_reject_record where tbtsk_reject_record.f_tbid = tb.f_id and  tbtsk_reject_record.f_taskid = '"+taskId+"' and f_stepname = '市级审核' ) g order by f_approve_time desc limit 1 )g) shishjg,  " +
                "                (select f_remark  from (select * from (select f_remark,f_approve_time from  tbtsk_approve_record where f_stepname = '市级审核' and f_is_revoked is null and tbtsk_approve_record.f_taskid = '"+taskId+"' and tbtsk_approve_record.f_tbid=tb.f_id union all select f_remark,f_reject_time f_approve_time from tbtsk_reject_record where tbtsk_reject_record.f_tbid = tb.f_id and  tbtsk_reject_record.f_taskid = '"+taskId+"' and f_stepname = '市级审核' ) g order by f_approve_time desc limit 1 )g) shishyj,  " +
                "                (select f_approve_time  from (select * from (select f_approve_time from  tbtsk_approve_record where f_stepname = '市级审核' and f_is_revoked is null and tbtsk_approve_record.f_taskid = '"+taskId+"' and tbtsk_approve_record.f_tbid=tb.f_id union all select f_reject_time f_approve_time from tbtsk_reject_record where tbtsk_reject_record.f_tbid = tb.f_id and  tbtsk_reject_record.f_taskid = '"+taskId+"' and f_stepname = '市级审核' ) g order by f_approve_time desc limit 1 )g) shishsj,   " +
                "                (select f_approve_user  from (select * from (select f_approve_user,f_approve_time from  tbtsk_approve_record where f_stepname = '市级审核' and f_is_revoked is null and tbtsk_approve_record.f_taskid = '"+taskId+"' and tbtsk_approve_record.f_tbid=tb.f_id union all select f_username f_approve_user,f_reject_time f_approve_time from tbtsk_reject_record where tbtsk_reject_record.f_tbid = tb.f_id and  tbtsk_reject_record.f_taskid = '"+taskId+"' and f_stepname = '市级审核' ) g order by f_approve_time desc limit 1 )g) shishry,  " +

//                "                \"(select case when f_option = 1 then '通过' when f_option = 2 then '未通过' when f_option = 3 then '暂存' when f_option = 0 then '退回' else '' end  from (select * from (select f_option,f_approve_time from  tbtsk_approve_record where f_stepname = '省级审核' and f_is_revoked is null and tbtsk_approve_record.f_taskid = '"+taskId+"' and tbtsk_approve_record.f_tbid=tb.f_id union all select 0 f_option,f_reject_time f_approve_time from tbtsk_reject_record where tbtsk_reject_record.f_tbid = tb.f_id and  tbtsk_reject_record.f_taskid = '"+taskId+"' and f_stepname = '省级审核' ) g order by f_approve_time desc limit 1 )g) shengshjg, \\n\" +\n" +
//                "                \"(select f_remark  from (select * from (select f_remark,f_approve_time from  tbtsk_approve_record where f_stepname = '省级审核' and f_is_revoked is null and tbtsk_approve_record.f_taskid = '"+taskId+"' and tbtsk_approve_record.f_tbid=tb.f_id union all select f_remark,f_reject_time f_approve_time from tbtsk_reject_record where tbtsk_reject_record.f_tbid = tb.f_id and  tbtsk_reject_record.f_taskid = '"+taskId+"' and f_stepname = '省级审核' ) g order by f_approve_time desc limit 1 )g) shengshyj, \\n\" +\n" +
//                "                \"(select f_approve_time  from (select * from (select f_approve_time from  tbtsk_approve_record where f_stepname = '省级审核' and f_is_revoked is null and tbtsk_approve_record.f_taskid = '"+taskId+"' and tbtsk_approve_record.f_tbid=tb.f_id union all select f_reject_time f_approve_time from tbtsk_reject_record where tbtsk_reject_record.f_tbid = tb.f_id and  tbtsk_reject_record.f_taskid = '"+taskId+"' and f_stepname = '省级审核' ) g order by f_approve_time desc limit 1 )g) shengshsj, \\n\" +\n" +
//                "                \"(select f_approve_user  from (select * from (select f_approve_user,f_approve_time from  tbtsk_approve_record where f_stepname = '省级审核' and f_is_revoked is null and tbtsk_approve_record.f_taskid = '"+taskId+"' and tbtsk_approve_record.f_tbid=tb.f_id union all select f_username f_approve_user,f_reject_time f_approve_time from tbtsk_reject_record where tbtsk_reject_record.f_tbid = tb.f_id and  tbtsk_reject_record.f_taskid = '"+taskId+"' and f_stepname = '省级审核' ) g order by f_approve_time desc limit 1 )g) shengshry, \\n\" +\n" +
                "                f_sjhfxpd," +
//                "               case when f_sjhfxpd = '合法' or f_sjhfxpd = '其他' then f_sjhfxpd when f_sjhfxpd = '违法' then f_sjrdwflx else '' end hfxpdlx,  " +
//                "                f_sjhfxpdx,f_sjshbtgl,f_sjrddfxx,f_sjfxwtqk,f_sjzdgzwt,f_sjybgzwt,f_sjsfcxjc,f_sjcxjclx,f_sjhfxpdb,   " +
                "                case when f_sjhfxpd = '合法' then f_sjrdhfmj else null end sjpdhfmj,   " +
                "                case when f_sjhfxpd = '合法' then f_sjrdhfgd else null end sjpdhfgdmj,   " +
                "                case when f_sjhfxpd = '合法' then f_sjrdhfjb else null end sjpdhfjbntmj,   " +
                "                case when f_sjhfxpd = '合法' then f_sjejl else null end sjpdhfejl,   " +
//                "                case when f_sjhfxpd = '合法' then f_ydsppzwh||','||f_tdgypzwh||','||f_zjggj_n6||','||f_zjggj_n4||','||f_gkfqdpzw||','||f_bdcqzh||','||(select string_agg(f_pzwh,',') from tbtsk_task_piwen where f_dataid = tb.f_id) else null end  sjpdhfpzwh,   " +
                "                case when f_sjhfxpd = '其他' then f_sjrdqtmj else null end sjpdqtmj,  " +
                "                case when f_sjhfxpd = '其他' then f_sjrdqtgd else null end sjpdqtgdmj,   " +
                "                case when f_sjhfxpd = '其他' then f_sjrdqtjb else null end sjpdqtjbntmj,   " +
                "                case when f_sjhfxpd = '其他' then f_sjejl else null end sjpdqtejl,   " +
                "                case when f_sjhfxpd = '其他' then f_ssnydstr||','||f_lsydpzwh else null end  sjpdqttkbh,   " +
                "                case when f_sjhfxpd = '违法' and f_sjrdwflx = '非粮违法' then f_sjrdflwf else null end sjpdflwfmj,   " +
                "                case when f_sjhfxpd = '违法' and f_sjrdwflx = '非粮违法' then f_sjrdf_n3 else null end sjpdflwfgdmj,   " +
                "                case when f_sjhfxpd = '违法' and f_sjrdwflx = '非粮违法' then f_sjrdf_n4 else null end sjpdflwfjbntmj,   " +
                "                case when f_sjhfxpd = '违法' and f_sjrdwflx = '非粮违法' then f_sjejl else null end sjpdflwfejl,   " +
                "                '' sjshwgjymj,'' sjshwgjygdmj,'' sjshwgjyjbntmj,'' sjshwgjyejl,   " +
                "                case when f_sjhfxpd = '违法' and f_sjrdwflx = '非农违法' and (f_sjhfxpdx = '违法用地-非农化违法用地（存量非农建设违法用地）') then f_sjrdfnwf else null end sjpdclwfmj,   " +
                "                case when f_sjhfxpd = '违法' and f_sjrdwflx = '非农违法' and (f_sjhfxpdx = '违法用地-非农化违法用地（存量非农建设违法用地）') then f_sjrdf_n1 else null end sjpdclwfgdmj,   " +
                "                case when f_sjhfxpd = '违法' and f_sjrdwflx = '非农违法' and (f_sjhfxpdx = '违法用地-非农化违法用地（存量非农建设违法用地）') then f_sjrdf_n2 else null end sjpdclwfjbntmj,  " +
                "                case when f_sjhfxpd = '违法' and f_sjrdwflx = '非农违法' and (f_sjhfxpdx = '违法用地-非农化违法用地（存量非农建设违法用地）') then f_sjejl else null end sjpdclwfejl,   " +
                "                case when f_sjhfxpd = '违法' and f_sjrdwflx = '非农违法' and f_sjhfxpdx in ('违法用地-非农化违法用地（新增非农建设违法用地-临时用地未批准）','违法用地-非农化违法用地（新增非农建设违法用地-其他）') then f_sjrdfnwf else null end sjpdxzfnmj,    " +
                "                case when f_sjhfxpd = '违法' and f_sjrdwflx = '非农违法' and f_sjhfxpdx in ('违法用地-非农化违法用地（新增非农建设违法用地-临时用地未批准）','违法用地-非农化违法用地（新增非农建设违法用地-其他）') then f_sjrdf_n1 else null end sjpdxzfngdmj,    " +
                "                case when f_sjhfxpd = '违法' and f_sjrdwflx = '非农违法' and f_sjhfxpdx in ('违法用地-非农化违法用地（新增非农建设违法用地-临时用地未批准）','违法用地-非农化违法用地（新增非农建设违法用地-其他）') then f_sjrdf_n2 else null end sjpdxzfnjbntmj,   " +
                "                case when f_sjhfxpd = '违法' and f_sjrdwflx = '非农违法' and f_sjhfxpdx in ('违法用地-非农化违法用地（新增非农建设违法用地-临时用地未批准）','违法用地-非农化违法用地（新增非农建设违法用地-其他）') then f_sjejl else null end sjpdxzfnejl,  " +
                "               f_sjrdccmj,f_sjrdccgd,f_sjrdccjb,f_sjrdbbmj,f_sjrdbbgd,f_sjrdbbjb,f_sjrdbbpw,f_sjrdyzjm,f_sjrdyzjg,f_sjrdyzjj,f_sjrdyzjx,   " +
                "                case when f_status = 1 then '未处理' when f_status = 2 then '未提交' when f_status=4 and f_review_stage is null then '已提交' when f_status='10' and f_review_stage is null then '已提报' when f_review_stage='91' and (f_reject_status ='0' or f_reject_status  is null) then '村级待审核' when f_review_stage='92' and (f_reject_status ='0' or f_reject_status  is null) then '乡级待审核' when f_review_stage='93' and (f_reject_status ='0' or f_reject_status  is null) then '县级待审核' when f_review_stage='95' and (f_reject_status ='0' or f_reject_status  is null) then '市级待审核' when f_review_stage='97' and (f_reject_status ='0' or f_reject_status  is null) then '省级待审核' when f_review_stage='101' and (f_reject_status ='0' or f_reject_status  is null) then '审核完成' when f_review_stage='90' and f_reject_status ='1' then '已打回' when f_review_stage='91' and f_reject_status ='1' then '乡级已打回' when f_review_stage='92' and f_reject_status ='1' then '县级已打回' when f_review_stage='93' and f_reject_status ='1' then '市级已打回' when  f_review_stage='95' and f_reject_status ='1' then '省级已打回'  else '' end as jdzt,   " +
                "                f_sjrdccmj+f_sjrdbbmj zgmj,  " +
                "                f_sjrdccgd+f_sjrdbbgd zggdmj,  " +
                "                f_sjrdccjb+f_sjrdbbjb zgjbntmj,   " +
                "                f_dkmj-(f_sjrdccmj+f_sjrdbbmj) symj,   " +
                "                f_gdmj_n1-(f_sjrdccgd+f_sjrdbbgd) sygdmj,   " +
                "                f_yjjbntmj-(f_sjrdccjb+f_sjrdbbjb) syjbntmj,  " +
                "                f_id as id,   " +
                "                f_issplitted as f_issplitted  ";
        return field;
    }

    public List<String> fieldList2List(){
        return  Arrays.asList("xh,f_sjxzqdm,f_sjxzqmc,f_xjxzqdm,f_xjxzqmc,f_xzqdm,f_xzqmc,f_jcbh,f_jcpc,f_xfsj,f_tblx,f_tbfl,f_zlwz,f_jcmj_n1,f_gdmj_n1,f_yjjbntmj,f_nydmj_n1,f_jsy_n1,f_wlydmj,f_stbhhxmj,f_gdbhmbmj,f_czkfbjmj,pwth,f_bdcdjzgd,f_bdcdjzyj,sxthbl,sxthwh,f_ydspmjm,f_ydspzb,f_ydspxmmc,f_ydsppzwh,f_tdgymjm,f_tdgyzb,f_tdgyxmmc,f_tdgypzwh,f_zjggjxzs,f_zjggj_n1,f_zjggj_n3,f_zjggj_n6,f_zjggjxdk,f_zjggj_n2,f_zjggj_n4,f_zjggj_n5,f_gkfqdjxm,f_gkfqdjxz,f_gkfqdjxx,f_gkfqdpzw,f_zjggcjqm,f_zjggcjqz,f_zjggcjqx,f_zjggcjqp,f_bdcdjxmm,f_bdcqzh,f_bdcdjmjm,f_bdcdjzgd,f_bdcdjzyj,f_bdcdjzb,f_ssnydxm,f_ssnydstr,f_ssnydmj,f_ssnydzgd,f_ssnydzyj,f_lsydxmmc,f_lsydpzwh,f_lsydmj,f_lsydzgdm,f_lsydz_n1,f_tdzzmj,f_tdzzzb,f_tdzzxmmc,f_tdzzpzwh,f_stxfmj,f_stxfzb,f_stxfxmmc,f_stxfpzwh,f_ckqmj,f_ckqzb,f_ckqxmmc,f_ckqpzwh,f_tkqmj,f_tkqzb,f_tkqxmmc,f_tkqpzwh,f_dkbh,cf,f_dkbs,f_dkmj,f_nydmj_n1,f_gdmj_n1,f_yjjbntmj,f_jsy_n1,f_wlydmj,tbsj,f_jzrq,sfcq,f_sfbgwjsy,f_tbjsqk,f_pdlx,f_hflx,pzwh,f_wflx,f_qtlx,f_yblqthfy,f_fnhwfydl,f_xzfnjswf,f_sdwbhlx,f_clfnjswf,f_pzsj,f_wgjylx,f_flhwfwgy,f_nyssjswf,f_sjfzlgyw,f_wfzdlx,f_wfpzzylx,f_wfgdlx,f_hfydsjyt,f_wfydsjyt,f_sfxzlzgd,f_sfwhzj,f_sfdpf,f_sfyfyhfz,f_sfbzxajz,f_sfjjxm,f_sfgefqc,f_sfwjbs,f_pdyjsm,f_xzwfpdyj,f_xmlx,f_xmmc,f_xmzt,f_lxpzjg,f_lxpzwh,f_clfs,f_labh,f_yjdbm,f_bylalx,f_bylasm,f_zglsqk,f_hftdy_n2,f_fgdwmj,f_ccyjj_n2,f_bbmjm_n1,f_bbgdmj,f_bbjbntmj,bbsxpzwh,f_bbsxlx,xianshjg,xianshyj,xianshsj,xianshry,shishjg,shishyj,shishsj,shishry,f_sjhfxpd,sjpdhfmj,sjpdhfgdmj,sjpdhfjbntmj,sjpdhfejl,sjpdqtmj,sjpdqtgdmj,sjpdqtjbntmj,sjpdqtejl,sjpdqttkbh,sjpdflwfmj,sjpdflwfgdmj,sjpdflwfjbntmj,sjpdflwfejl,sjshwgjymj,sjshwgjygdmj,sjshwgjyjbntmj,sjshwgjyejl,sjpdclwfmj,sjpdclwfgdmj,sjpdclwfjbntmj,sjpdclwfejl,sjpdxzfnmj,sjpdxzfngdmj,sjpdxzfnjbntmj,sjpdxzfnejl,f_sjrdccmj,f_sjrdccgd,f_sjrdccjb,f_sjrdbbmj,f_sjrdbbgd,f_sjrdbbjb,f_sjrdbbpw,f_sjrdyzjm,f_sjrdyzjg,f_sjrdyzjj,f_sjrdyzjx,jdzt,zgmj,zggdmj,zgjbntmj,symj,sygdmj,syjbntmj".split(","));
    }

    public String fieldList(){
        String field = "f_sjxzqdm," +
                "f_sjxzqmc," +
                "f_xjxzqdm," +
                "f_xjxzqmc," +
                "f_xzqdm," +
                "f_xzqmc," +
                "f_jcbh," +
                "f_jcpc," +
                "f_jcmj_n1," +
                "f_xfsj," +
                "f_tblx," +
                "f_tbfl," +
                "f_zlwz," +
                "f_ydspmjm," +
                "f_ydspzb," +
                "f_ydspxmmc," +
                "f_tdgymjm," +
                "f_tdgyzb," +
                "f_tdgyxmmc," +
                "f_zjggjxzs," +
                "f_zjggj_n1," +
                "f_zjggj_n3," +
                "f_zjggjxdk," +
                "f_zjggj_n2," +
                "f_zjggj_n4," +
                "f_gkfqdjxm," +
                "f_gkfqdjxz," +
                "f_gkfqdjxx," +
                "f_zjggcjqm," +
                "f_zjggcjqz," +
                "f_zjggcjqx," +
                "f_bdcdjmjm," +
                "f_bdcdjzb," +
                "f_bdcdjxmm," +
                "f_ssnydmj," +
                "f_ssnydzb," +
                "f_ssnydxm," +
                "f_lsydmj," +
                "f_lsydzb," +
                "f_lsydxmmc," +
                "f_gdbhmbmj," +
                "f_gdbhmbzb," +
                "f_stbhhxmj," +
                "f_stbhhxzb," +
                "f_czkfbjmj," +
                "f_czkfbjzb," +
                "f_tdzzmj," +
                "f_tdzzzb," +
                "f_tdzzxmmc," +
                "f_stxfmj," +
                "f_stxfzb," +
                "f_stxfxmmc," +
                "f_ckqmj," +
                "f_ckqzb," +
                "f_ckqxmmc," +
                "f_tkqmj," +
                "f_tkqzb," +
                "f_tkqxmmc," +
                "f_dkbh," +
                "'' as cf," +
                "f_dkmj," +
                "f_nydmj_n1," +
                "f_gdmj_n1," +
                "f_yjjbntmj," +
                "f_jsy_n1," +
                "f_wlydmj," +
                "f_sfbgwjsy," +
                "f_tbjsqk," +
                "f_pdlx," +
                "f_hflx," +
                "f_wflx," +
                "f_qtlx," +
                "f_yblqthfy," +
                "f_fnhwfydl," +
                "f_xzfnjswf," +
                "f_sdwbhlx," +
                "f_clfnjswf," +
                "f_pzsj," +
                "f_wgjylx," +
                "f_flhwfwgy," +
                "f_nyssjswf," +
                "f_sjfzlgyw," +
                "f_wfzdlx," +
                "f_wfpzzylx," +
                "f_wfgdlx," +
                "f_hfydsjyt," +
                "f_wfydsjyt," +
                "f_sfxzlzgd," +
                "f_sfwhzj," +
                "f_sfdpf," +
                "f_sfyfyhfz," +
                "f_sfbzxajz," +
                "f_sfjjxm," +
                "f_sfgefqc," +
                "f_sfwjbs," +
                "f_pdyjsm," +
                "f_xzwfpdyj," +
                "f_xmlx," +
                "f_xmmc," +
                "f_xmzt," +
                "f_lxpzjg," +
                "f_lxpzwh," +
                "f_clfs," +
                "f_labh," +
                "f_yjdbm," +
                "f_bylalx," +
                "f_bylasm," +
                "f_zglsqk," +
                "f_hftdy_n2," +
                "f_fgdwmj," +
                "f_ccyjj_n2," +
                "f_bbmjm_n1," +
                "f_bbgdmj," +
                "f_bbjbntmj," +
                "f_bbsxlx," +
                "f_sjshjl," +
                "f_sjshsm," +
                "f_sjs_n1," +
                "f_sjs_n2," +
                "f_sjhfxpdx," +
                "f_sjrdhfmj," +
                "f_sjrdhfgd," +
                "f_sjrdhfjb," +
                "f_sjejl," +
                "f_sjrdfnwf," +
                "f_sjrdf_n1," +
                "f_sjrdf_n2," +
                "f_sjejl," +
                "f_sjrdwgjy," +
                "f_sjrdw_n1," +
                "f_sjrdw_n2," +
                "f_sjejl," +
                "f_sjrdflwf," +
                "f_sjrdf_n3," +
                "f_sjrdf_n4," +
                "f_sjejl," +
                "f_sjrdqtmj," +
                "f_sjrdqtgd," +
                "f_sjrdqtjb," +
                "f_sjejl," +
                "f_sjrdxmmc," +
                "f_sjrdyddw," +
                "f_sjgsgdrd," +
                "f_sjrdccmj," +
                "f_sjrdccgd," +
                "f_sjrdccjb," +
                "f_sjrdbbmj," +
                "f_sjrdbbgd," +
                "f_sjrdbbjb," +
                "f_sjrdbbpw," +
                "f_sjrdyzjm," +
                "f_sjrdyzjg," +
                "f_sjrdyzjj," +
                "f_sjrdyzjx," +
                "f_sjzgqkpd || ';' || f_sjzgqkpd bz1," +
                "coalesce(f_sjrdccmj, 0)+ coalesce(f_sjrdbbmj, 0) mj1," +
                "coalesce(f_sjrdccgd, 0)+ coalesce(f_sjrdbbgd, 0) mj2," +
                "coalesce(f_sjrdccjb, 0)+ coalesce(f_sjrdbbjb, 0) mj3," +
                "coalesce(f_sjrdfnwf, 0)+ coalesce(f_sjrdwgjy, 0)+ coalesce(f_sjrdflwf, 0)-coalesce(f_sjrdccmj, 0)+ coalesce(f_sjrdbbmj, 0) mj4," +
                "coalesce(f_sjrdf_n1, 0)+ coalesce(f_sjrdw_n1, 0)+ coalesce(f_sjrdf_n3, 0)-coalesce(f_sjrdccgd, 0)+ coalesce(f_sjrdbbgd, 0) mj5," +
                "coalesce(f_sjrdf_n2, 0)+ coalesce(f_sjrdw_n2, 0)+ coalesce(f_sjrdf_n4, 0)-coalesce(f_sjrdccjb, 0)+ coalesce(f_sjrdbbjb, 0) mj6," +
                "f_id as id," +
                "f_issplitted as f_issplitted  ";
        return field;
    }

    public String fieldList1(){
        String field = "f_sjxzqdm," +
                "f_sjxzqmc," +
                "f_xjxzqdm," +
                "f_xjxzqmc," +
                "f_xzqdm," +
                "f_xzqmc," +
                "f_jcbh," +
                "f_jcpc," +
                "f_jcmj_n1," +
                "f_xfsj," +
                "f_tblx," +
                "f_tbfl," +
                "f_zlwz," +
                "f_ydspmjm," +
                "f_ydspzb," +
                "f_ydspxmmc," +
                "f_tdgymjm," +
                "f_tdgyzb," +
                "f_tdgyxmmc," +
                "f_zjggjxzs," +
                "f_zjggj_n1," +
                "f_zjggj_n3," +
                "f_zjggjxdk," +
                "f_zjggj_n2," +
                "f_zjggj_n4," +
                "f_gkfqdjxm," +
                "f_gkfqdjxz," +
                "f_gkfqdjxx," +
                "f_zjggcjqm," +
                "f_zjggcjqz," +
                "f_zjggcjqx," +
                "f_bdcdjmjm," +
                "f_bdcdjzb," +
                "f_bdcdjxmm," +
                "f_ssnydmj," +
                "f_ssnydzb," +
                "f_ssnydxm," +
                "f_lsydmj," +
                "f_lsydzb," +
                "f_lsydxmmc," +
                "f_gdbhmbmj," +
                "f_gdbhmbzb," +
                "f_stbhhxmj," +
                "f_stbhhxzb," +
                "f_czkfbjmj," +
                "f_czkfbjzb," +
                "f_tdzzmj," +
                "f_tdzzzb," +
                "f_tdzzxmmc," +
                "f_stxfmj," +
                "f_stxfzb," +
                "f_stxfxmmc," +
                "f_ckqmj," +
                "f_ckqzb," +
                "f_ckqxmmc," +
                "f_tkqmj," +
                "f_tkqzb," +
                "f_tkqxmmc," +
                "f_dkbh," +
                "cf," +
                "f_dkmj," +
                "f_nydmj_n1," +
                "f_gdmj_n1," +
                "f_yjjbntmj," +
                "f_jsy_n1," +
                "f_wlydmj," +
                "f_sfbgwjsy," +
                "f_tbjsqk," +
                "f_pdlx," +
                "f_hflx," +
                "f_wflx," +
                "f_qtlx," +
                "f_yblqthfy," +
                "f_fnhwfydl," +
                "f_xzfnjswf," +
                "f_sdwbhlx," +
                "f_clfnjswf," +
                "f_pzsj," +
                "f_wgjylx," +
                "f_flhwfwgy," +
                "f_nyssjswf," +
                "f_sjfzlgyw," +
                "f_wfzdlx," +
                "f_wfpzzylx," +
                "f_wfgdlx," +
                "f_hfydsjyt," +
                "f_wfydsjyt," +
                "f_sfxzlzgd," +
                "f_sfwhzj," +
                "f_sfdpf," +
                "f_sfyfyhfz," +
                "f_sfbzxajz," +
                "f_sfjjxm," +
                "f_sfgefqc," +
                "f_sfwjbs," +
                "f_pdyjsm," +
                "f_xzwfpdyj," +
                "f_xmlx," +
                "f_xmmc," +
                "f_xmzt," +
                "f_lxpzjg," +
                "f_lxpzwh," +
                "f_clfs," +
                "f_labh," +
                "f_yjdbm," +
                "f_bylalx," +
                "f_bylasm," +
                "f_zglsqk," +
                "f_hftdy_n2," +
                "f_fgdwmj," +
                "f_ccyjj_n2," +
                "f_bbmjm_n1," +
                "f_bbgdmj," +
                "f_bbjbntmj," +
                "f_bbsxlx," +
                "f_sjshjl," +
                "f_sjshsm," +
                "f_sjs_n1," +
                "f_sjs_n2," +
                "f_sjhfxpdx," +
                "f_sjrdhfmj," +
                "f_sjrdhfgd," +
                "f_sjrdhfjb," +
                "f_sjejl," +
                "f_sjrdfnwf," +
                "f_sjrdf_n1," +
                "f_sjrdf_n2," +
                "f_sjejl," +
                "f_sjrdwgjy," +
                "f_sjrdw_n1," +
                "f_sjrdw_n2," +
                "f_sjejl," +
                "f_sjrdflwf," +
                "f_sjrdf_n3," +
                "f_sjrdf_n4," +
                "f_sjejl," +
                "f_sjrdqtmj," +
                "f_sjrdqtgd," +
                "f_sjrdqtjb," +
                "f_sjejl," +
                "f_sjrdxmmc," +
                "f_sjrdyddw," +
                "f_sjgsgdrd," +
                "f_sjrdccmj," +
                "f_sjrdccgd," +
                "f_sjrdccjb," +
                "f_sjrdbbmj," +
                "f_sjrdbbgd," +
                "f_sjrdbbjb," +
                "f_sjrdbbpw," +
                "f_sjrdyzjm," +
                "f_sjrdyzjg," +
                "f_sjrdyzjj," +
                "f_sjrdyzjx," +
                "bz1," +
                "mj1," +
                " mj2," +
                "mj3," +
                "mj4," +
                "mj5," +
                "mj6";
        return field;
    }


    @Override
    public void MockRedisRecord(TaskRecord taskRecord) {
        if (taskRecord != null) {
            String parameter = taskRecord.getParam();
            if (StringUtils.isNotBlank(parameter)) {
                JSONObject jsonObject = JSONObject.parseObject(parameter);
                if (jsonObject != null) {
                    DownloadParameter downloadParameter = JSONObject.toJavaObject(jsonObject, DownloadParameter.class);
                    if (downloadParameter != null) {
                        DataDownloadRecord record = dataDownloadRecordService.findeOne(downloadParameter.getRecordId());
                        if (record != null) {
                            record.setBatchOpr(true);
                            if (redisTemplate.hasKey(record.getId())) {
                                redisTemplate.delete(record.getId());
                            }
                            redisTemplate.opsForValue().set(record.getId(), JSONObject.toJSONString(record).toString(), 2, TimeUnit.DAYS);
                        }
                    }
                }
            }
        }

    }
}

