package com.geoway.landteam.landcloud.service.customtask.task.impl;


import com.geoway.landteam.customtask.repository.task.*;
import com.geoway.landteam.customtask.task.entity.*;
import com.geoway.landteam.landcloud.core.model.pub.dto.NoticeNewDTO;
import com.geoway.landteam.landcloud.core.model.user.entity.LandUser;
import com.geoway.landteam.landcloud.core.repository.user.LandUserRepository;
import com.geoway.landteam.landcloud.servface.customtask.task.MNoticeNewService;
import com.geoway.landteam.landcloud.servface.customtask.task.MNoticeSubscribeService;
import com.geoway.landteam.landcloud.servface.customtask.task.MNoticeTopicService;
import com.geoway.landteam.landcloud.service.customtask.task.MNoticeService;
import com.gw.base.data.GwValidateException;
import com.gw.base.util.GutilStr;
import com.geoway.landteam.landcloud.common.util.base.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.sql.Timestamp;
import java.util.*;
import java.util.stream.Collectors;

@Transactional
@Service
public class MNoticeNewServiceImpl implements MNoticeNewService {
    @Autowired
    NoticeTopicRepository noticeTopicRepository;

    @Autowired
    JdbcTemplate jdbcTemplate;

    @Autowired
    LandUserRepository landUserRepository;

    @Autowired
    NoticeNewRepository noticeNewRepository;

    @Autowired
    UserBiz2Repository biz2Repository;

    @Autowired
    NoticeSubscribeRepository noticeSubscribeRepository;

    @Autowired
    MNoticeTopicService noticeTopicService;

    @Autowired
    MNoticeSubscribeService noticeSubscribeService;

    @Autowired
    TskTaskBizRepository tskTaskBizRepository;

    @Autowired
    BizAreaRepository bizAreaRepository;

    @Autowired
    MNoticeService noticeService;


    @Override
    public Map<String, Object> getHomeSysNotice(Long userId, String content, Date startTime, Date endTime, String sort, int page, int rows,int targettype) {
        Map<String, Object> map = new HashMap<>();
        List<String> topicids = null;
        List<Map<String, Object>> list = null;
        List<NoticeNew> noticeNews = new ArrayList<>();
        int count = 0;
        //查询系统消息
        topicids = noticeTopicRepository.getTopicIdByType("sys");
        //查询sql
        StringBuffer sql = new StringBuffer("");
        //计数sql
        StringBuffer sqlcount = new StringBuffer("");
        //筛选计数sql
        StringBuffer sqltotal = new StringBuffer("");
        //sql头部
        sql.append("select n.f_id,n.f_content,n.f_title,n.f_senddate from tb_notice_new n ");
        sqlcount.append("select sum(count) from ( select count(1) from tb_notice_new n ");
        sqltotal.append("select sum(count) from ( select count(1) from tb_notice_new n ");
        //生成where条件
        String whereSql = sysNoticeWhere(userId, content, startTime, endTime, sort);
        String whereSqlCount = sysNoticeWhereCount(userId, content, startTime, endTime);
        String wherefilterCount = sysNoticeWhereCount(userId, null, null, null);
        //拼接where条件 新表
        sql.append(whereSql);
        sqlcount.append(whereSqlCount);
        sqltotal.append(wherefilterCount);


        //旧表
        sql.append(" union select n.f_id,n.f_content,n.f_title,n.f_createdate as f_senddate from tb_notice n ");
        sql.append(sysNoticeUnionWhere(content,targettype));
        sql.append(" order by f_senddate " + sort );

        //条件筛选数量
        sqlcount.append(" union select count(1) from tb_notice n ");
        sqlcount.append(sysNoticeUnionWhere(content,targettype));
        sqlcount.append(" ) g");

        //总数量
        sqltotal.append(" union select count(1) from tb_notice n ");
        sqltotal.append(sysNoticeUnionWhere(null,targettype));
        sqltotal.append(" ) g");

        Long total = jdbcTemplate.queryForObject(sqltotal.toString(), Long.class);

        int start = (page - 1) * rows;
        sql.append(" limit " + rows + " offset " + start);
        count = jdbcTemplate.queryForObject(sqlcount.toString(), Integer.class);
        list = jdbcTemplate.queryForList(sql.toString());
        for (Map<String, Object> temp : list) {
            NoticeNew noticeNew = new NoticeNew();
            noticeNew.setId(temp.get("f_id").toString());
            noticeNew.setTitle(temp.get("f_title").toString());
            noticeNew.setContent(temp.get("f_content").toString());
            noticeNew.setSendDate((Date) temp.get("f_senddate"));
            noticeNews.add(noticeNew);
        }
        map.put("list", noticeNews);
        map.put("total", total);
        map.put("filtercount", count);
        return map;
    }

    @Override
    public NoticeNew getNoticeDetail(String id) {
        NoticeNew noticeDetailById=new NoticeNew();
        NoticeNew noticeNew = noticeNewRepository.getNoticeDetailById(id);
        if(noticeNew != null){
            noticeDetailById=noticeNew;
        }
        Page<Notice> notice= noticeService.queryByFilter("Q_id_S_EQ="+id,null,0,1);
        if (notice.getContent().size() == 0) {
            throw new GwValidateException("无该消息");
        }
        if (notice != null && notice.getContent().size() != 0) {
            noticeDetailById.setTitle(notice.getContent().get(0).getTitle());
            noticeDetailById.setId(notice.getContent().get(0).getId());
            noticeDetailById.setContent(notice.getContent().get(0).getContent());
            noticeDetailById.setData(notice.getContent().get(0).getDate());
        }
        return noticeDetailById;
    }

    @Override
    public String sysNoticeUnionWhere(String content,int targettype) {
        //查询sql
        StringBuffer sql = new StringBuffer("where n.f_noticetype=1 and n.f_targettype <> "+targettype);

        //查询内容模糊查询
        if (content != null && !content.equals("")) {
            sql.append(" and n.f_content like '%" + content + "%' ");
        }

        return sql.toString();
    }

    @Override
    public Map<String, Object> getHomeTskMessage(Long userId, String bizId, String content, Date stratTime, Date endTime, String sort, int page, int rows) {
        Map<String, Object> map = new HashMap<>();
        //查询sql
        StringBuffer sql = new StringBuffer("select n.f_id,n.f_title,n.f_content,n.f_senddate,f_bizid from tb_notice_new n ");
        //筛选计数sql
        StringBuffer sqltotal = new StringBuffer("select count(1) from tb_notice_new n ");

        //条件
        String where = homeTskNoticeWhere(userId, bizId, content, stratTime, endTime, sort);
        sql.append(where);
        sql.append(" order by n.f_senddate " + sort);

        int start = (page - 1) * rows;
        sql.append(" limit " + rows + " offset " + start);
        List<Map<String, Object>> list = jdbcTemplate.queryForList(sql.toString());
        List<NoticeNew> noticeNews = new ArrayList<>();
        for (Map temp : list) {
            NoticeNew noticeNew = new NoticeNew();
            noticeNew.setId(temp.get("f_id").toString());
            noticeNew.setTitle(temp.get("f_title").toString());
            noticeNew.setContent(temp.get("f_content").toString());
            noticeNew.setSendDate((Date) temp.get("f_senddate"));
            noticeNew.setBizId(temp.get("f_bizid") != null ? temp.get("f_bizid").toString() : null);
            noticeNews.add(noticeNew);
        }
        //计数sql
        StringBuffer sqlCount = new StringBuffer("select count(1) from tb_notice_new n ");
        String wherecount = homeTskNoticeWhereCount(userId, bizId, content, stratTime, endTime);
        sqlCount.append(wherecount);
        String wheretotal = homeTskNoticeWhereCount(userId, null, null, null, null);
        sqltotal.append(wheretotal);
        //筛选总数查询
        Long total = jdbcTemplate.queryForObject(sqltotal.toString(), Long.class);
        Long filtercount = jdbcTemplate.queryForObject(sqlCount.toString(), Long.class);
        map.put("list", noticeNews);
        map.put("total", total);
        map.put("filtercount", filtercount);
        return map;
    }

    @Override
    public String homeTskNoticeWhere(Long userId, String bizId, String content, Date startTime, Date endTime, String sort) {
//        LandUser landUser = landUserRepository.findOne(userId);
//        Date registDate = landUser.getCreateTime();
        List<String> topics = getTopicByUserId("tsk", userId.toString());
        StringBuffer sql = new StringBuffer(" where 1=1 ");

        String topicsStr = GutilStr.join(topics, "','");
        //查询内容模糊查询
        if (content != null && !content.equals("")) {
            sql.append(" and (n.f_content like '%" + content + "%' or n.f_title like '%" + content + "%')");
        }
        //按照所属任务查询
        if (bizId != null && !bizId.equals("")) {
            sql.append(" and n.f_bizid='" + bizId + "' ");
        }

        //时间查询
        if (startTime != null && endTime != null) {
            Date endtime = changeEndTime(endTime);
            sql.append(" and n.f_senddate between '" + startTime + "' and '" + endtime + "'");
        }
//        //获取消息时间大于用户注册时间的信息
//        sql.append(" and n.f_senddate > '" + registDate + "' ");
        //查询topicid
        sql.append(" and n.f_topicid in('" + topicsStr + "') ");

//        //排序
//        if ("DESC".equals(sort)) {
//            sql.append(" order by n.f_senddate desc ");
//        } else {
//            sql.append("order by n.f_senddate asc");
//        }
        return sql.toString();
    }

    @Override
    public String homeTskNoticeWhereCount(Long userId, String bizId, String content, Date startTime, Date endTime) {
//        LandUser landUser = landUserRepository.findOne(userId);
//        Date registDate = landUser.getCreateTime();
        List<String> topics = getTopicByUserId("tsk", userId.toString());
        StringBuffer sql = new StringBuffer(" where 1=1 ");

        String topicsStr = GutilStr.join(topics, "','");
        //查询内容模糊查询
        if (content != null && !content.equals("")) {
            sql.append(" and (n.f_content like '%" + content + "%' or n.f_title like '%" + content + "%')");
        }
        //按照所属任务查询
        if (bizId != null && !bizId.equals("")) {
            sql.append(" and n.f_bizid='" + bizId + "' ");
        }
        //时间查询
        if (startTime != null && endTime != null) {
            Date endtime = changeEndTime(endTime);
            sql.append(" and n.f_senddate between '" + startTime + "' and '" + endtime + "'");
        }
        //获取消息时间大于用户注册时间的信息
//        sql.append(" and n.f_senddate > '" + registDate + "' ");
        //查询topicid
        sql.append(" and n.f_topicid in('" + topicsStr + "') ");


        return sql.toString();
    }

    @Override
    public String sysNoticeWhere(Long userId, String content, Date startTime, Date endTime, String sort) {
        LandUser landUser = landUserRepository.findById(userId).orElse(null);
        Date registDate = landUser.getCreateTime();
        //查询sql
        StringBuffer sql = new StringBuffer("where 1=1 ");
        //查询系统消息
        List<String> topicids = noticeTopicRepository.getTopicIdByType("sys");
        String topicIdStr = StringUtils.join(topicids, "','");
        //查询内容模糊查询
        if (content != null && !content.equals("")) {
            sql.append(" and n.f_content like '%" + content + "%' ");
        }
        //时间查询
        if (startTime != null && endTime != null) {
            Date endtime = changeEndTime(endTime);
            sql.append(" and n.f_senddate between '" + startTime + "' and '" + endtime + "'");
        }
        //获取消息时间大于用户注册时间的信息
        if(registDate!=null && !"".equals(registDate)) {
            sql.append(" and n.f_senddate > '" + registDate + "' ");
        }
        //查询topicid
        sql.append(" and n.f_topicid in('" + topicIdStr + "') ");
//        //排序
//        if ("DESC".equals(sort)) {
//            sql.append(" order by n.f_senddate desc ");
//        } else {
//            sql.append("order by n.f_senddate asc");
//        }
        return sql.toString();
    }

    @Override
    public String sysNoticeWhereCount(Long userId, String content, Date startTime, Date endTime) {
        LandUser landUser = landUserRepository.findById(userId).orElse(null);
        Date registDate = landUser.getCreateTime();
        //查询系统消息
        List<String> topicids = noticeTopicRepository.getTopicIdByType("sys");
        //计数sql
        StringBuffer sqlcount = new StringBuffer(" where 1=1 ");
        String topicIdStr = StringUtils.join(topicids, "','");
        sqlcount.append(" and n.f_topicid in('" + topicIdStr + "') ");
        //查询内容模糊查询
        if (content != null && !content.equals("")) {
            sqlcount.append(" and n.f_content like '%" + content + "%' ");
        }
        //时间查询
        if (startTime != null && endTime != null) {
            Date endtime = changeEndTime(endTime);
            sqlcount.append(" and n.f_senddate between '" + startTime + "' and '" + endtime + "'");
        }
        //获取消息时间大于用户注册时间的信息
        if(registDate!=null && !"".equals(registDate)) {
            sqlcount.append(" and n.f_senddate > '" + registDate + "' ");
        }
        return sqlcount.toString();
    }

    @Override
    public Map<String, Object> queryISendNotice(Long userId, String bizId, String content, Date startTime, Date endTime, String sort, int page, int rows) {
        Map map = new HashMap();
        //查询sql
        StringBuffer sql = new StringBuffer("select n.f_id,n.f_title,n.f_content,n.f_senddate,n.f_bizid from tb_notice_new n ");
        String where = sendNoticeWhere(userId, bizId, content, startTime, endTime, sort);
        sql.append(where);
        sql.append(" limit " + rows + " offset " + (page - 1) * rows + " ");
        List<Map<String, Object>> list = jdbcTemplate.queryForList(sql.toString());
        //消息列表
        List<NoticeNew> noticeNews = new ArrayList<>();
        for (Map<String, Object> temp : list) {
            NoticeNew noticeNew = new NoticeNew();
            noticeNew.setId(temp.get("f_id").toString());
            noticeNew.setTitle(temp.get("f_title").toString());
            noticeNew.setContent(temp.get("f_content").toString());
            noticeNew.setSendDate((Date) temp.get("f_senddate"));
            noticeNew.setBizId(temp.get("f_bizid") != null ? temp.get("f_bizid").toString() : null);
            noticeNews.add(noticeNew);
        }
        map.put("list", noticeNews);
        //计数sql
        StringBuffer sqlcount = new StringBuffer("select count(1) from tb_notice_new n ");
        String countWhere = sendNoticeWhereCount(userId, bizId, content, startTime, endTime);
        sqlcount.append(countWhere);
        Long filtercount = jdbcTemplate.queryForObject(sqlcount.toString(), Long.class);
        map.put("filtercount", filtercount);
        //总数sql
        StringBuffer sqltotal = new StringBuffer("select count(1) from tb_notice_new n ");
        String totalWhere = sendNoticeWhereCount(userId, bizId, null, null, null);
        sqltotal.append(totalWhere);
        Long total = jdbcTemplate.queryForObject(sqltotal.toString(), Long.class);
        map.put("total", total);
        return map;
    }

    @Override
    public String sendNoticeWhere(Long userId, String bizId, String content, Date startTime, Date endTime, String sort) {
        StringBuffer sql = new StringBuffer(" where 1=1 ");
        sql.append(" and n.f_senduser='" + userId + "' ");
        sql.append(" and n.f_bizid= '" + bizId + "' ");

        if (content != null && !content.equals("")) {
            sql.append(" and n.f_content like '%" + content + "%' ");
        }
        //时间查询
        if (startTime != null && endTime != null) {
            Date endtime = changeEndTime(endTime);
            sql.append(" and n.f_senddate between '" + startTime + "' and '" + endtime + "'");
        }
        //排序
        if ("DESC".equals(sort)) {
            sql.append(" order by n.f_senddate desc ");
        } else {
            sql.append("order by n.f_senddate asc");
        }
        return sql.toString();
    }

    @Override
    public String sendNoticeWhereCount(Long userId, String bizId, String content, Date startTime, Date endTime) {
        StringBuffer sql = new StringBuffer(" where 1=1 ");
        sql.append(" and n.f_senduser='" + userId + "' ");
        sql.append(" and n.f_bizid= '" + bizId + "' ");

        if (content != null && !content.equals("")) {
            sql.append(" and n.f_content like '%" + content + "%' ");
        }
        //时间查询
        if (startTime != null && endTime != null) {
            Date endtime = changeEndTime(endTime);
            sql.append(" and n.f_senddate between '" + startTime + "' and '" + endtime + "'");
        }
        return sql.toString();
    }

    @Override
    public NoticeNew getTskNoticeDetail(String id, String bizId) {
        return noticeNewRepository.queryNoticeNewByIdAndBizId(id, bizId);
    }

    /**
     * 创建任务消息
     *
     * @param title      标题
     * @param content    正文
     * @param role       发给任务某一角色
     * @param regionCode 下发政区
     * @param bizId      任务id
     */
    @Override
    public void createNotice(Long userId, String title, String content, String role, String regionCode, String bizId) {
        //接受消息的用户角色
        Integer sendRole = 0;
        //用户角色数组
        String[] roles = role.split(",");
        //用户角色加和
        for (String roleStr : roles) {
            if (roleStr.equals("3")) {
                roleStr = "4";
            } else if (roleStr.equals("4")) {
                roleStr = "8";
            }
            sendRole += Integer.valueOf(roleStr);
        }
        String topicid = null;
        //查询是否有该订阅条件
        List<NoticeTopic> tempNoticeTopics = noticeTopicRepository.queryNoticeTopicByBizidAndRegionAndRoleAndType(bizId, regionCode, sendRole, "tsk");
        NoticeTopic tempNoticeTopic = null;
        if(!tempNoticeTopics.isEmpty()){
            tempNoticeTopic = tempNoticeTopics.get(0);
        }
        //判断是否有该订阅记录 有则不变 没有就创建
        if (tempNoticeTopic == null) {
            //创建新的订阅记录
            NoticeTopic noticeTopic = new NoticeTopic();
            topicid = UUID.randomUUID().toString();
            noticeTopic.setBizid(bizId);
            noticeTopic.setDate(new Date());
            noticeTopic.setId(topicid);
            noticeTopic.setType("tsk");

            //设置订阅政区
            noticeTopic.setRegion(regionCode);
            if (regionCode != null && regionCode.length() >= 9) {
                noticeTopic.setRegionXiang(regionCode.substring(0, 9));
            }
            if (regionCode != null && regionCode.length() >= 6) {
                noticeTopic.setRegionShi(regionCode.substring(0, 4) + "00");
                noticeTopic.setRegionSheng(regionCode.substring(0, 2) + "0000");
                noticeTopic.setRegionXian(regionCode.substring(0, 6));
            }
            noticeTopic.setRole(sendRole);
            //保存订阅条件
            noticeTopicRepository.save(noticeTopic);
        } else {
            topicid = tempNoticeTopic.getId();
        }
        //查询biz
        TskTaskBiz tskTaskBiz = tskTaskBizRepository.findById(bizId).orElse(null);
        //消息实体赋值保存
        String noticeNewId = UUID.randomUUID().toString();
        NoticeNew noticeNew = new NoticeNew();
        noticeNew.setId(noticeNewId);
        noticeNew.setTitle(title);
        noticeNew.setContent(content);
        noticeNew.setSendDate(new Date());
        noticeNew.setBizId(bizId);
        noticeNew.setSendUser(userId.toString());
        noticeNew.setTopicId(topicid);
        //设置mode
        noticeNew.setTaskMode(tskTaskBiz != null ? tskTaskBiz.getMode() : null);
        noticeNewRepository.save(noticeNew);

    }

    @Override
    public Map<String, Object> getTskNotice(Long userId, String content, String bizId, Date startTime, Date endTime, String sort, int page, int rows) {
        Map map = new HashMap();
        //查询sql
        StringBuffer sql = new StringBuffer(" select n.f_id,n.f_title,n.f_content,n.f_senddate,n.f_bizid from tb_notice_new n ");
        String where = tskNoticeWhere(userId, content, bizId, startTime, endTime, sort);
        sql.append(where);
        List<Integer> roles = biz2Repository.findByUserIdAndBizId(userId, bizId).stream().map(r -> r.getRole()).collect(Collectors.toList());
        String roleStr = GutilStr.join(roles, ",");
        sql.append(" limit " + rows + " offset " + (page - 1) * rows);
        //任务消息列表
        List<NoticeNew> noticeNews = new ArrayList<>();
        List<Map<String, Object>> maps = jdbcTemplate.queryForList(sql.toString());
        for (Map<String, Object> temp : maps) {
            NoticeNew noticeNew = new NoticeNew();
            noticeNew.setId(temp.get("f_id").toString());
            noticeNew.setTitle(temp.get("f_title").toString());
            noticeNew.setContent(temp.get("f_content").toString());
            noticeNew.setSendDate((Date) temp.get("f_senddate"));
            noticeNew.setBizId(temp.get("f_bizid") != null ? temp.get("f_bizid").toString() : null);
            noticeNews.add(noticeNew);
        }
        //统计sql
        StringBuffer sqlcount = new StringBuffer(" select count(1) from tb_notice_new n ");
        String wherecount = tskNoticeWhereCount(userId, content, bizId, startTime, endTime);
        sqlcount.append(wherecount);
        Long filtercount = jdbcTemplate.queryForObject(sqlcount.toString(), Long.class);
        //总计sql
        StringBuffer sqltotal = new StringBuffer(" select count(1) from tb_notice_new n  ");
        String wheretotal = tskNoticeWhereCount(userId, null, bizId, null, null);
        sqltotal.append(wheretotal);
        Long total = jdbcTemplate.queryForObject(sqltotal.toString(), Long.class);
        map.put("list", noticeNews);
        map.put("filtercount", filtercount);
        map.put("total", total);
        return map;
    }

    @Override
    public String tskNoticeWhere(Long userId, String content, String bizId, Date startTime, Date endTime, String sort) {
        List<Integer> roles = biz2Repository.findByUserIdAndBizId(userId, bizId).stream().map(r -> r.getRole()).collect(Collectors.toList());
        if (roles.isEmpty()) {
            throw new RuntimeException("无该业务权限");
        }
//        LandUser landUser = landUserRepository.findOne(userId);
//        Date registDate = landUser.getCreateTime();
        List<String> topics = getTopicByUserIdAndRoleAndBizid("tsk", userId.toString(), roles, bizId);
        StringBuffer sql = new StringBuffer(" where 1=1 ");

        String topicsStr = GutilStr.join(topics, "','");
        //查询内容模糊查询
        if (content != null && !content.equals("")) {
            sql.append(" and n.f_content like '%" + content + "%' ");
        }
        if (bizId != null && !bizId.equals("")) {
            sql.append(" and n.f_bizid='" + bizId + "' ");
        }
        //时间查询
        if (startTime != null && endTime != null) {
            Date endtime = changeEndTime(endTime);
            sql.append(" and n.f_senddate between '" + startTime + "' and '" + endtime + "'");
        }
        //获取消息时间大于用户注册时间的信息
//        sql.append(" and n.f_senddate > '" + registDate + "' ");
        //查询topicid
        sql.append(" and n.f_topicid in('" + topicsStr + "') ");
        //排序
        if ("DESC".equals(sort)) {
            sql.append(" order by n.f_senddate desc ");
        } else {
            sql.append("order by n.f_senddate asc");
        }


        return sql.toString();
    }

    @Override
    public String tskNoticeWhereCount(Long userId, String content, String bizId, Date startTime, Date endTime) {
        List<Integer> roles = biz2Repository.findByUserIdAndBizId(userId, bizId).stream().map(r -> r.getRole()).collect(Collectors.toList());
        if (roles.isEmpty()) {
            throw new RuntimeException("无该业务权限");
        }

//        LandUser landUser = landUserRepository.findOne(userId);
//        Date registDate = landUser.getCreateTime();
        List<String> topics = getTopicByUserIdAndRoleAndBizid("tsk", userId.toString(), roles, bizId);
        StringBuffer sql = new StringBuffer(" where 1=1 ");

        String topicsStr = GutilStr.join(topics, "','");
        //查询内容模糊查询
        if (content != null && !content.equals("")) {
            sql.append(" and n.f_content like '%" + content + "%' ");
        }
        if (bizId != null && !bizId.equals("")) {
            sql.append(" and n.f_bizid='" + bizId + "' ");
        }
        //时间查询
        if (startTime != null && endTime != null) {
            Date endtime = changeEndTime(endTime);
            sql.append(" and n.f_senddate between '" + startTime + "' and '" + endtime + "'");
        }
        //获取消息时间大于用户注册时间的信息
//        sql.append(" and n.f_senddate > '" + registDate + "' ");
        //查询topicid
        sql.append(" and n.f_topicid in('" + topicsStr + "') ");
        return sql.toString();
    }

    /**
     * 设置结束时间为当天最后一秒
     * limihao
     *
     * @param endTime
     * @return
     */
    @Override
    public Date changeEndTime(Date endTime) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(endTime);
        calendar.set(Calendar.HOUR, 23);
        calendar.set(Calendar.MINUTE, 59);
        calendar.set(Calendar.SECOND, 59);
        return calendar.getTime();
    }

    @Override
    public List<String> getTopicByUserIdAndRoleAndBizid(String type, String userId, List<Integer> roles, String bizId) {
        List<String> topics = new ArrayList<>();
        List<BizArea> bizAreas = bizAreaRepository.findByBizId(bizId);
        List<String> bizRegion = new ArrayList<>();
        for (BizArea bizArea : bizAreas) {
            bizRegion.add(bizArea.getArea());
        }
        if (bizAreas.isEmpty()) {
            throw new RuntimeException("该任务无作业区");
        }
        //查询是作业员但无作业区切下发给该任务的全部作业员的topic sql
        StringBuffer topicSql = new StringBuffer("select t.f_id,t.f_region from tb_notice_topic t where 1=1 ");
        //查询已存在于订阅记录表的topic  sql
        StringBuffer sql = new StringBuffer("select t.f_id from tb_notice_topic t " +
                "left join tb_notice_subscribe s on t.f_id=s.f_topicid where 1=1 ");
        if (type != null) {
            sql.append(" and t.f_type = '" + type + "' ");
            topicSql.append(" and t.f_type = '" + type + "' ");
        }
        if (userId != null) {
            sql.append(" and s.f_userid='" + userId + "' ");
        }
        roles = roles.stream().filter(role -> role != 0).collect(Collectors.toList());
        //根据用户该任务角色查询是否接收该topic
        if (!roles.isEmpty()) {
            sql.append(" and (");
            topicSql.append(" and (");
            for (int i = 0; i < roles.size(); i++) {
                if (roles.get(i) == 1) {
                    sql.append(" t.f_role&1=1 ");
                    topicSql.append(" t.f_role&1=1 ");
                }else if(roles.get(i) == 2) {
                    sql.append(" t.f_role&2=2 ");
                    topicSql.append(" t.f_role&2=2 ");
                }else if(roles.get(i) == 3) {
                    sql.append(" t.f_role&4=4 ");
                    topicSql.append(" t.f_role&4=4 ");
                }else if(roles.get(i) == 4) {
                    sql.append(" t.f_role&8=8 ");
                    topicSql.append(" t.f_role&8=8 ");
                }
                if (i < roles.size() - 1) {
                    sql.append(" or ");
                    topicSql.append(" or ");
                }
            }
            sql.append(" ) ");
            topicSql.append(" ) ");
        }
        //查询有没有发给作业员topic
        if (bizId != null) {
            sql.append(" and t.f_bizid= '" + bizId + "' ");
            topicSql.append("and t.f_bizid= '" + bizId + "' ");
        }
        List<Map<String, Object>> list = jdbcTemplate.queryForList(topicSql.toString());
        for (Map<String, Object> map : list) {
            //消息通知政区和任务政区统一、或全国 则为发送给所有相关角色
            if (bizRegion.indexOf(map.get("f_region").toString()) > -1 || map.get("f_region").equals("1")) {
                topics.add(map.get("f_id").toString());
            }
        }
        topics.addAll(jdbcTemplate.queryForList(sql.toString(), String.class));
        //获取不在subscribe的管理作业员情况
        List<String> glyZyyTopics = getGlyAndZyyTopic(userId);
        topics.addAll(glyZyyTopics);

        return topics;
    }

    @Override
    public List<String> getTopicByUserId(String type, String userId) {
        List<String> topics = new ArrayList<>();
        //1.先去查询用户的订阅记录表
        topics = noticeTopicRepository.getTopicByUserId("tsk", userId.toString());
        //2.获取发送政区和作业政区相等的信息（即全部作业员）
        List<String> userBizs = biz2Repository.getUserBiz2ByUserIdAndRole(Long.valueOf(userId), 3);
        String userBizsStr = StringUtils.join(userBizs, "','");
        //获取包含发送给作业员的消息
        String sql = "select t.f_id from tb_notice_topic t,tbtsk_biz_area ba " +
                "where  t.f_bizid=ba.f_bizid and t.f_region=ba.f_area and t.f_bizid in ('" + userBizsStr + "') and (t.f_role&4)=4 ";
        topics.addAll(jdbcTemplate.queryForList(sql, String.class));
        //3.获取不在subscribe的管理员作业员情况
        List<String> glyZyyTopic = getGlyAndZyyTopic(userId);
        topics.addAll(glyZyyTopic);
        //topic去重
        topics = topics.stream().distinct().collect(Collectors.toList());
        return topics;
    }

    @Override
    public List<String> getGlyAndZyyTopic(String userId) {
        List<String> topics = new ArrayList<>();
        //管理员
        topics.addAll(getTopicsByUserAndRole(topics, userId, 1));
        //审核员
        topics.addAll(getTopicsByUserAndRole(topics, userId, 2));
        //作业员
        topics.addAll(getTopicsByUserAndRole(topics, userId, 3));
        //复核员
        topics.addAll(getTopicsByUserAndRole(topics, userId, 4));
        return topics;
    }

    @Override
    public List<String> getTopicsByUserAndRole(List<String> topics, String userId, Integer role) {
        //1作业员 消息记录表存1 ，2审核员 消息记录表里存2 ，3 作业员 消息记录表里存4， 4复核员 消息记录表里存8
        if (role == 3) {
            role = 4;
        } else if (role == 4) {
            role = 8;
        }
        //管理员或作业员身份 但没在订阅表里的情况（注册新用户为管理员但发送消息是是多角色发送消息）
        String GlySql = "select t.f_bizid,string_agg(t.f_region,',') arr from tb_notice_subscribe s " +
                "left join tb_notice_topic t on s.f_topicid=t.f_id where s.f_userid='" + userId + "' and (t.f_role&" + role + ")=" + role + " group by t.f_bizid";
        List<Map<String, Object>> GlyBizs = jdbcTemplate.queryForList(GlySql);
        for (Map<String, Object> glyBiz : GlyBizs) {
            String[] tempRegions = glyBiz.get("arr").toString().split(",");
            List<String> tempRegionList = new ArrayList<>(Arrays.asList(tempRegions));
            List<String> glytopics = noticeTopicRepository.getNoticeIdByBizidAndRoleAndRegion(glyBiz.get("f_bizid").toString(), role, tempRegionList);
            topics.addAll(glytopics);
        }
        return topics;
    }

    @Override
    public List<NoticeNew> findLastedTaskNoticeForApp(String userId) {
        //查询sql
        StringBuffer sql = new StringBuffer("select * from ( select n.f_id,n.f_title,n.f_content,n.f_senddate,f_bizid from tb_notice_new n ");
        String where = homeTskNoticeWhere(Long.valueOf(userId), null, null, null, null, "DESC");
        sql.append(where);
        sql.append(" union select u.f_id,u.f_title,u.f_content,u.f_senddate,f_bizid " +
                "FROM tb_tasknotice as u,tb_tasknotice_user as t where u.f_id = t.f_noticeid and t.f_userid = '"+userId+"' and u.f_bizid is not null ) g");
        sql.append(" order by f_senddate desc");
        sql.append(" limit 1  offset 0 ");

        List<NoticeNew> noticeNews = new ArrayList<>();
        List<Map<String, Object>> list = jdbcTemplate.queryForList(sql.toString());
        for (Map<String, Object> map : list) {
            NoticeNew noticeNew = new NoticeNew();
            noticeNew.setId(map.get("f_id").toString());
            noticeNew.setTitle(map.get("f_title").toString());
            noticeNew.setContent(map.get("f_content").toString());
            noticeNew.setSendDate((Date) map.get("f_senddate"));
            noticeNew.setBizId(map.get("f_bizid") != null ? map.get("f_bizid").toString() : null);
            noticeNews.add(noticeNew);
        }
        return noticeNews;
    }


    @Override
    public List<NoticeNew> findMyWorkGroupNotice(String userId) {
        List<NoticeNew> noticeNews=new ArrayList<>();
        //获取用户订阅的anc类型的消息
        List<String> topics = noticeTopicRepository.getTopicByUserId("anc", userId);
        if(!topics.isEmpty()){
            //根据订阅记录查找对应的消息
           noticeNews = noticeNewRepository.queryNoticeNewsByTopicId(topics);
        }
        //从旧的表中查询工作组记录
        String sql="select t.f_id,t.f_content,t.f_title,t.f_senddate from tb_tasknotice t,tb_tasknotice_user u where t.f_posttype=7 " +
                "and t.f_id=u.f_noticeid and u.f_userid='"+userId+"'";
        List<Map<String, Object>> list = jdbcTemplate.queryForList(sql);
        if(!list.isEmpty()) {
            for (Map<String, Object> map : list) {
                NoticeNew noticeNew=new NoticeNew();
                noticeNew.setId(map.get("f_id").toString());
                noticeNew.setTitle(map.get("f_title").toString());
                noticeNew.setContent(map.get("f_content").toString());
                noticeNew.setSendDate((Date)map.get("f_senddate"));
                noticeNews.add(noticeNew);
            }
        }
        Collections.sort(noticeNews, new Comparator<NoticeNew>() {
            @Override
            public int compare(NoticeNew o1, NoticeNew o2) {
                return o2.getSendDate().compareTo(o1.getSendDate());
            }
        });

        return noticeNews;
    }

    @Override
    public List<NoticeNewDTO> findNoticeByUserIdAndDateAndTopics(String bizId, Date date, List<String> topics) {
        List<NoticeNew> noticeNews = noticeNewRepository.queryNoticeNewsByTopicIdsAndSendDateAndBizId(topics, date, bizId);
        List<NoticeNewDTO> noticeNewDTOS = new ArrayList<>();
        for (NoticeNew noticeNew : noticeNews) {
            NoticeNewDTO noticeNewDTO = new NoticeNewDTO();
            noticeNewDTO.setId(noticeNew.getId());
            noticeNewDTO.setAction(noticeNew.getAction());
            noticeNewDTO.setBizId(noticeNew.getBizId());
            noticeNewDTO.setContent(noticeNew.getContent());
            noticeNewDTO.setCount(noticeNew.getCount());
            noticeNewDTO.setData(noticeNew.getData());
            noticeNewDTO.setSenddate(noticeNew.getSendDate());
            noticeNewDTO.setTaskmode(noticeNew.getTaskMode());
            noticeNewDTO.setTitle(noticeNew.getTitle());
            noticeNewDTOS.add(noticeNewDTO);
        }
        return noticeNewDTOS;
    }

    @Override
    public List<Map<String,Object>> findTaskNoticesBySendTimeAndBizIdAndVerifyCode(String bizId, Date date, List<String> topics) {
        String topicsListStr = "";
        if (!topics.isEmpty()) {
            topicsListStr = StringUtils.join(topics, "','");
        }
        String sql = "select n.f_id,n.f_title,n.f_content,n.f_senddate,n.f_data,n.f_senduser,t.f_type,t.f_region,n.f_action,n.f_bizid" +
                " from tb_notice_new n left join tb_notice_topic t on t.f_id=n.f_topicid where 1=1  ";
        if (bizId != null) {
            sql += "and n.f_bizid='" + bizId + "' ";
        }
        if (date != null) {
            sql += " and n.f_senddate > '" + date + "' ";
        }
        sql += " and n.f_topicid in ('" + topicsListStr + "') ";
        List<Map<String, Object>> mapList = jdbcTemplate.queryForList(sql);
        List<Map<String,Object>> noticeDTOS = new ArrayList<>();
        for (Map<String, Object> map : mapList) {
            Map temp=new LinkedHashMap();
            temp.put("id",map.get("f_id") != null ? map.get("f_id").toString() : null);
            temp.put("title",map.get("f_title") != null ? map.get("f_title").toString() : null);
            temp.put("content",map.get("f_content") != null ? map.get("f_content").toString() : null);
            temp.put("sendTime",map.get("f_senddate") != null ? (Timestamp) map.get("f_senddate") : null);
            temp.put("data",map.get("f_data") != null ?  map.get("data").toString() : null);
            temp.put("sendUser",map.get("f_senduser") != null ? Long.valueOf(map.get("f_senduser").toString()) : null);
            temp.put("type",map.get("f_type") != null ? map.get("f_type").toString() : null);
            temp.put("region",map.get("f_region") != null ? map.get("f_region").toString() : null);
            temp.put("action",map.get("f_action") != null ? Integer.valueOf(map.get("f_action").toString()) : null);
            temp.put("bizId",map.get("f_bizid") != null ? map.get("f_bizid").toString() : null);
            noticeDTOS.add(temp);
        }
        return noticeDTOS;
    }
}


