package com.geoway.landteam.landcloud.service.customtask.task.impl;

import com.geoway.landteam.customtask.repository.task.NoticeSubscribeRepository;
import com.geoway.landteam.customtask.repository.task.UserBiz2Repository;
import com.geoway.landteam.customtask.task.entity.NoticeSubscribe;
import com.geoway.landteam.landcloud.servface.customtask.task.MNoticeSubscribeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;

@Service
public class MNoticeSubscribeServiceImpl implements MNoticeSubscribeService {

    @Autowired
    UserBiz2Repository biz2Repository;

    @Autowired
    NoticeSubscribeRepository noticeSubscribeRepository;

    @Override
    public void saveNoticeSubscribes(String topicId, String bizId, String role, String regionCode) {
        String tempRegion = "";
        if (regionCode.length() == 12 || regionCode.length() == 9) {
            tempRegion = regionCode + "%";
        } else if (regionCode.length() == 6) {
            if (regionCode.endsWith("0000")) {
                tempRegion = regionCode.substring(0, 2) + "%";
            } else if (regionCode.endsWith("00")) {
                tempRegion = regionCode.substring(0, 4) + "%";
            } else {
                tempRegion = regionCode + "%";
            }
        }
        //订阅人保存
        List<NoticeSubscribe> noticeSubscribes = new ArrayList<>();
        List<Long> usersIdBybizId = new ArrayList<>();
        //发送给管理员
        if (role != null && ((Integer.valueOf(role) & 1) == 1 || (Integer.valueOf(role) & 2) == 2 || (Integer.valueOf(role) & 8) == 8)) {
            List<Long> tempUserIdsList = new ArrayList<>();
            String temprole="";
            if ((Integer.valueOf(role) & 8) == 8){
                //角色赋值为4复核员
                temprole="4";
            }else if((Integer.valueOf(role) & 2) == 2){
                //角色赋值为2审核员
                temprole="2";
            }else if((Integer.valueOf(role) & 1) == 1){
                //角色赋值为1管理员
                temprole="1";
            }
            //选择的是国家级
            if (regionCode.equals("1")) {
                tempUserIdsList = biz2Repository.findUserIdsBybizidAndRoleId1Region(bizId, Integer.valueOf(temprole));
            } else {//非国家级
                tempUserIdsList = biz2Repository.findUserIdsBybizidAndRoleId1(bizId, Integer.valueOf(temprole), tempRegion);
            }
            usersIdBybizId.addAll(tempUserIdsList);
        }
        if ((Integer.valueOf(role) & 4) == 4) {//发送给作业员
            String temprole="3";
            List<Long> tempUserIdsList = new ArrayList<>();
            //国家级
            if (regionCode.equals("1")) {
                tempUserIdsList = biz2Repository.findUserIdsBybizidAndRoleId3Region(bizId, Integer.valueOf(temprole));
            } else {//非国家级
                tempUserIdsList = biz2Repository.findUserIdsBybizidAndRoleId3(bizId, Integer.valueOf(temprole), tempRegion);
            }
            usersIdBybizId.addAll(tempUserIdsList);
        }

        for (int i = 0; i < usersIdBybizId.size(); i++) {
            String useridStr = String.valueOf(usersIdBybizId.get(i));
            Long userid = Long.valueOf(useridStr);
            NoticeSubscribe noticeSubscribe = new NoticeSubscribe();
            noticeSubscribe.setId(UUID.randomUUID().toString());
            noticeSubscribe.setTopicId(topicId);
            noticeSubscribe.setCreateTime(new Date());
            noticeSubscribe.setUserId(userid.toString());
            noticeSubscribes.add(noticeSubscribe);
        }
        noticeSubscribeRepository.saveAll(noticeSubscribes);
    }
}
