package com.geoway.landteam.landcloud.service.customtask.task.impl;


import com.geoway.landteam.customtask.repository.task.NoticeTopicRepository;
import com.geoway.landteam.customtask.task.entity.NoticeSubscribe;
import com.geoway.landteam.customtask.task.entity.NoticeTopic;
import com.geoway.landteam.landcloud.servface.customtask.task.MNoticeSubscribeService;
import com.geoway.landteam.landcloud.servface.customtask.task.MNoticeTopicService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

@Service
public class MNoticeTopicServiceImpl implements MNoticeTopicService {

    @Autowired
    NoticeTopicRepository noticeTopicRepository;

    @Autowired
    MNoticeSubscribeService noticeSubscribeService;

    @Override
    public List<String> getTopicIdByType(String type) {
        return noticeTopicRepository.getTopicIdByType(type);
    }

    @Override
    public void saveTopicNoticeTopicAndSubscribe(String bizId, Long userId, String regionCode, String role, String type) {
        //先判断作业区级别 省级插入1条记录 市级插入2条记录 县级插入3条记录 乡级插入4条记录 村级插入5记录
        //订阅条件
        List<NoticeTopic> noticeTopics=new ArrayList<>();
        //订阅人
        List<NoticeSubscribe> noticeSubscribes=new ArrayList<>();
        //政区
        List<String> regions=new ArrayList<>();
        if(regionCode.length()==6){
            //省级
            if(regionCode.endsWith("0000")){
                regions.add(regionCode.substring(0,2)+"0000");
            }else if(regionCode.endsWith("00")){
                regions.add(regionCode.substring(0,4)+"00");
                regions.add(regionCode.substring(0,2)+"0000");
            }else{
                regions.add(regionCode.substring(0,4)+"00");
                regions.add(regionCode.substring(0,2)+"0000");
                regions.add(regionCode);
            }
        }



    }

}
