package com.geoway.landteam.landcloud.service.customtask.task.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.pub.entity.TaskDataDbParameter;
import com.geoway.landteam.customtask.pub.entity.TaskQueryParameter;
import com.geoway.landteam.customtask.pub.entity.TaskRecord;
import com.geoway.landteam.customtask.pub.entity.TaskRecordTemp;
import com.geoway.landteam.customtask.servface.multitask.DataBizService;

import com.geoway.landteam.customtask.servface.task.TaskRecordService;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.service.task.TaskNoticeServiceImpl;


import com.geoway.landteam.customtask.service.task.thread.TaskAssignThread;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.model.pub.constants.JobConstants;
import com.geoway.landteam.landcloud.core.repository.user.WorkGroupMemberRepository;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.landcloud.servface.customtask.task.MITaskAssignService;
import com.geoway.landteam.landcloud.service.customtask.task.*;
import com.gw.base.data.GwValidateException;
import com.gw.base.log.GwLoger;
import com.gw.base.log.GiLoger;
import com.geoway.landteam.landcloud.common.util.base.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.concurrent.*;

/**
 * @Author: zkn
 * @Date: 2020/6/19 10:16
 * @Description:
 */
@Service
public class MTaskAssignServiceImpl implements MITaskAssignService {
    /* @Autowired
   ThreadPoolTaskExecutor threadPoolTaskExecutor;*/

    protected String uploadDir;

    private final GiLoger logger = GwLoger.getLoger(MTaskAssignServiceImpl.class);
    @Autowired
    DefaultOssOperatorService ossOperatorService;
    @Autowired
    MTaskNoticeService taskNoticeService;
    @Autowired
    TaskNoticeServiceImpl taskNoticeService1;
    @Autowired
    MTskTaskBizService mtskTaskBizService;
    @Autowired
    TskTaskBizService tskTaskBizService;
    @Autowired
    MDataBizService dataBizService;
    @Autowired
    DataBizService dataBizService1;
  /*  @Autowired
    TaskAssignProducerServiceImpl taskAssignProducerService;*/
    @Autowired
  WorkGroupMemberRepository workGroupMemberRepository;

    @Autowired
    MTaskRecordService taskRecordService;
    @Autowired
    TaskRecordService taskRecordService1;

    @Autowired
    MTskTaskSyncService mTskTaskSyncService;

    ExecutorService threadPool= Executors.newFixedThreadPool(20);

    @Override
    public void assignTask(Long userId, String taskId, JSONArray tbIds, JSONArray groups, JSONArray orgs) {
        String recordId = UUID.randomUUID().toString();
        List<String> list = JSONObject.parseArray(JSONObject.toJSONString(tbIds),  String.class);
        //获取任务
        TskTaskBiz tskTaskBiz = mtskTaskBizService.getTskTaskBizById(taskId);
        JSONObject additionJson = new JSONObject();
        additionJson.put("count", tbIds.size());

        // 不管是下发模式还是领取模式的任务，都标记为update，app端对判断如果本地不存在，就将update的数据转为新增
        additionJson.put("addOrUpdate", "UPDATE");
        additionJson.put("taskMode", tskTaskBiz.getMode());
        additionJson.put("curMode", "assign");

        TaskDataDbParameter parameter = new TaskDataDbParameter();
        parameter.setGroups(groups);
        parameter.setTaskId(taskId);
        parameter.setOrgs(orgs);
        parameter.setUserId(userId);
        //parameter.setIds(list);
        parameter.setMode(tskTaskBiz.getMode().toString());
        parameter.setRecordId(recordId);
        parameter.setAddition(additionJson);

      //  String paramJSONStr = JSONObject.toJSONString(parameter);
        //将参数添加到任务记录中进行后台处理
        JSONObject params = new JSONObject();
            params.put("filterType", "checkFilter");
            params.put("userId", userId);
            params.put("TaskDataDbParameter", parameter);
            params.put("taskId", taskId);
        // 任务下发记录
        TaskRecord record = new TaskRecord();
        record.setId(recordId);
        record.setParam(JSONObject.toJSONString(params));
        //数据下发3
        record.setTasktype(JobConstants.JOB_TYPE_DATA_ASSIGN);
        record.setStarttime(new Date());
        //状态1创建，2执行中，3成功，4失败
        record.setState(1);
        record.setUserid(userId);
        taskRecordService.save(record);

        List<TaskRecordTemp> tempList = new ArrayList<>();
        for (int i = 0; i < list.size(); i++) {
            TaskRecordTemp temp = new TaskRecordTemp();
            temp.setId(UUID.randomUUID().toString());
            temp.setRecordid(recordId);
            temp.setDataid(list.get(i));
            tempList.add(temp);
        }

        taskRecordService.saveTaskRecordTemp(tempList);


    }

   @Override
    public void assignTaskByConditionFilter(Long userId, String taskId,  JSONArray groups, JSONArray orgs,TaskQueryParameter taskQueryParameter,JSONObject allparams) {
       //限制重复动作1小时内不能重新操作
       Date oneHourAgo = new Date(new Date().getTime() - 60 * 60 * 1000); // 获取1小时前的时间
       int count = taskRecordService.findByTypeAndParamAndStarttime(JobConstants.JOB_TYPE_DATA_ASSIGN, JSONObject.toJSONString(allparams), oneHourAgo);
       if(count > 0 ){
           throw new GwValidateException("数据正在进行下发，无需重复操作！");
       }
       //将参数添加到任务记录中进行后台处理
       JSONObject params = new JSONObject();
           params.put("filterType", "conditionFilter");
           params.put("userId", userId);
           params.put("groups", groups);
           params.put("orgs", orgs);
           params.put("taskQueryParameter", taskQueryParameter);
           params.put("taskId", taskId);
        // 任务下发记录
       TaskRecord record = new TaskRecord();
           record.setId(UUID.randomUUID().toString());
           //数据下发3
           record.setTasktype(JobConstants.JOB_TYPE_DATA_ASSIGN);
           record.setState(1);
           //状态1创建，2执行中，3成功，4失败
           record.setParam(JSONObject.toJSONString(params));
           record.setStarttime(new Date());
           record.setUserid(userId);
           record.setBizId(taskId);
           record.setRemark(JSONObject.toJSONString(allparams));
       taskRecordService.save(record);

    }

    @Override
    public void doAssign(TaskDataDbParameter parameter) {
        if (parameter == null) {
            return;
        }

        TaskRecord one = taskRecordService.findOne(parameter.getRecordId());
        uploadDir = (String) ProjectConfig.getConfig(ProjectConfigEnum.UPLOAD_DIR.getKey());
        TaskAssignThread threadAssign = new TaskAssignThread(workGroupMemberRepository, tskTaskBizService,
                taskNoticeService1, ossOperatorService, dataBizService1, taskRecordService1, uploadDir, parameter);
        //threadPoolTaskExecutor.execute(threadAssign);
        //threadPool.execute(threadAssign);

        Future<?> future = threadPool.submit(threadAssign);
        String failReason = null;
        try {
            // 等待计算结果，最长等待timeout秒，timeout秒后中止任务
            Object o = future.get(60, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            failReason = "主线程在等待返回结果时被中断！";
            one.setState(4);
            one.setRemark(failReason);
            taskRecordService.save(one);
        } catch (ExecutionException e) {
            failReason = "主线程等待返回结果，但任务本身抛出异常！";
            one.setState(4);
            one.setRemark(failReason);
            taskRecordService.save(one);
        } catch (TimeoutException e) {
            failReason = "主线程等待计算结果超时，因此中断任务线程！";
            one.setState(4);
            one.setRemark(failReason);
            taskRecordService.save(one);
        }

    }

    @Override
    public Map<String, Object> queryAssignUserRecord(String taskId, String dataId, int page, int rows) {
        if(StringUtils.isBlank(taskId) || StringUtils.isBlank(dataId)){
            throw new RuntimeException("参数错误");
        }
        return  taskRecordService.queryAssignUserRecord(taskId,dataId,page,rows);
    }

    @Override
    public Map<String, Object> getAssignRecordList(String taskId, String dataId, int page, int rows) {
        if(StringUtils.isBlank(taskId) || StringUtils.isBlank(dataId)){
            throw new RuntimeException("参数错误");
        }
        return  taskRecordService.getAssignRecordList(taskId,dataId,page,rows);
    }


}
