package com.geoway.landteam.landcloud.service.customtask.task.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.pub.entity.TaskTransformMedia;
import com.geoway.landteam.customtask.servface.multitask.DataBizService;
import com.geoway.landteam.customtask.servface.multitask.TbtskFieldsService;
import com.geoway.landteam.customtask.servface.multitask.TbtskObjectinfoService;
import com.geoway.landteam.customtask.servface.task.TaskTransMediaService;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.common.constant.CommonConstants;
import com.geoway.landteam.landcloud.common.dto.BaseObjectResponse;
import com.geoway.landteam.landcloud.servface.customtask.task.MTaskAttachTransformService;
import com.gw.base.Gw;
import com.gw.base.log.GwLoger;
import com.gw.base.log.GiLoger;
import com.geoway.landteam.landcloud.common.util.base.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletRequest;
import java.util.*;


/**
 * @Author: zhenkaining
 * @Date: 2019/11/22 15:34
 * @Description:
 */
@Service
public class MTaskAttachTransDailyTaskImpl implements MTaskAttachTransformService {
    @Autowired
    TskTaskBizService tskTaskBizService;
    @Autowired
    DataBizService dataBizService;
    @Autowired
    TbtskObjectinfoService tbtskObjectinfoService;
    @Autowired
    TbtskFieldsService tbtskFieldsService;
    @Autowired
 TaskTransMediaService  taskTransMediaService;
    private final GiLoger logger = GwLoger.getLoger(MTaskAttachTransDailyTaskImpl.class);

    @Override
    public BaseObjectResponse transform(HttpServletRequest request, long userId, String sourceTaskCode, String sourceTaskName, String targetTaskCode, String targetTaskName,
                                        JSONArray mediaArrary, String xzqdm, String tbid) {
        BaseObjectResponse baseResponse = new BaseObjectResponse();
        try {
            String token = request.getSession().getAttribute("access_token").toString();

            TskTaskBiz targetTaskBiz = tskTaskBizService.findByTaskId(targetTaskCode);
            TbtskObjectinfo targetObjinfo = null;
            if (targetTaskBiz != null && StringUtils.isNotBlank(targetTaskBiz.getTableId())) {
                targetObjinfo = tbtskObjectinfoService.getObjectbyID(targetTaskBiz.getTableId());
            }
            List<String> queryFieldNames = new ArrayList<>();
            queryFieldNames.add("f_id");
            queryFieldNames.add("f_shape");
            Map<String, Object> valueMap = new HashMap<>();
            if (dataBizService.getCount(targetObjinfo.getfTablename(), "f_id " + "= '" + tbid + "'") > 0) {
                List<Map> targetDatas = dataBizService.queryAllData(targetObjinfo.getfTablename(), queryFieldNames, "f_id = '" + tbid + "'");
                if (targetDatas != null && targetDatas.size() > 0) {
                    if (targetDatas.get(0) != null && targetDatas.get(0).containsKey("f_shape")) {
                        if (mediaArrary != null && mediaArrary.size() > 0) {
                            List<TaskTransformMedia> mediaList = new ArrayList<>();
                            for (Object jsonObj : mediaArrary) {
                               JSONObject jsonObject =  JSONObject.parseObject(JSONObject.toJSONString(jsonObj));
                                if (jsonObject != null) {
                                    TaskTransformMedia media = Gw.beans.getBean(TaskTransMediaService.class).convertTaskTransMediaFromJson (jsonObject);
                                    media.setAttachId(UUID.randomUUID().toString());
                                    mediaList.add(media);
                                }
                            }
                            taskTransMediaService.saveAttach(userId, tbid, targetDatas.get(0).get("f_shape").toString(), mediaList, token);
                        }
                    }
                }
            } else {
            }

            baseResponse.setStatus(CommonConstants.RESPONSE_STATUS_OK);
            baseResponse.setMessage("转换成功!");
        } catch (Exception e) {
            e.printStackTrace();
            logger.error(e);
            baseResponse.setStatus(CommonConstants.RESPONSE_STATUS_FAILURE);
            baseResponse.setMessage(e.getMessage());
        }

        return baseResponse;
    }
}
