package com.geoway.landteam.landcloud.service.customtask.task.impl;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.service.pub.ProxyService;
import com.geoway.landteam.landcloud.common.constant.CommonConstants;
import com.geoway.landteam.landcloud.common.dto.BaseObjectResponse;
import com.geoway.landteam.landcloud.common.util.base.StringUtils;
import com.geoway.landteam.landcloud.servface.customtask.task.MTaskAttachTransformService;
import com.gw.base.log.GwLoger;
import com.gw.base.log.GiLoger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.Map;


/**
 * @Author: zhenkaining
 * @Date: 2019/11/22 15:35
 * @Description:
 */
@Service
public class MTaskAttachTransOtherImpl implements MTaskAttachTransformService {
    private final GiLoger logger = GwLoger.getLoger(MTaskAttachTransOtherImpl.class);

    @Autowired
    ProxyService proxyService;
    @Override
    public BaseObjectResponse transform(HttpServletRequest request, long userId, String sourceTaskCode, String sourceTaskName, String targetTaskCode, String targetTaskName,
                                        JSONArray mediaArrary, String xzqdm, String tbid) {
        BaseObjectResponse baseResponse = new BaseObjectResponse();
        try {
            String thirdTokenStr = "";
            Object third_token = request.getSession().getAttribute("third_auth");
            if (third_token == null) {
                thirdTokenStr = proxyService.getThirdToken(request);
            } else {
                thirdTokenStr = (String) third_token;
            }

            Map<String, Object> param = getpostparamter(sourceTaskCode, sourceTaskName, targetTaskCode, targetTaskName, mediaArrary, xzqdm, tbid);

            String url = proxyService.thirdHost + "/webapi/gtdcyv2/taskattachtransform";
            HttpRequest post = HttpUtil.createPost(url).contentType("application/json");
            post.header("Authorization", thirdTokenStr);
            post.form(param);
            cn.hutool.http.HttpResponse execute = post.execute();
            if (execute.getStatus() == 200) {
                JSONObject body = JSONObject.parseObject(execute.body());
                if (body != null) {
                    if (body.containsKey("code")) {
                        if (body.get("code").toString().equalsIgnoreCase("500")) {
                            throw new RuntimeException("第三方接口tasktransform请求错误,状态码：500");
                        }
                    }
                    Object data = body.get("data");
                    if (data != null) {
                        baseResponse.setStatus(CommonConstants.RESPONSE_STATUS_OK);
                        baseResponse.setMessage(data.toString());
                    }
                }
            } else {
                JSONObject body = JSONObject.parseObject(execute.body());
                baseResponse.setStatus(CommonConstants.RESPONSE_STATUS_FAILURE);
                baseResponse.setMessage(body.get("error").toString());
            }
        } catch (Exception e) {
            logger.error(e);
            baseResponse.setStatus(CommonConstants.RESPONSE_STATUS_FAILURE);
            baseResponse.setMessage(e.getMessage());
        }
        return baseResponse;
    }

    private Map<String, Object> getpostparamter(String sourceTaskCode, String sourceTaskName, String targetTaskCode, String targetTaskName, JSONArray mediaArrary, String xzqdm, String tbid) {
        Map<String, Object> param = new HashMap<>();
        param.put("srcTaskCode", sourceTaskCode);
        param.put("srcTaskName", sourceTaskName);
        if (StringUtils.isNotBlank(xzqdm)) {
            if (xzqdm.equalsIgnoreCase("1")) {
                param.put("xzqdm", "000000");
            } else {
                param.put("xzqdm", xzqdm);
            }
        } else {
            param.put("xzqdm", "");
        }
        param.put("tagtTaskCode", targetTaskCode);
        param.put("tagtTaskName", targetTaskName);
        param.put("tbid", tbid);

        param.put("medias", mediaArrary);
        return param;
    }

}
