package com.geoway.landteam.landcloud.service.customtask.task.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletRequest;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.servface.task.TaskTransMediaService;
import com.gw.base.Gw;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.alibaba.fastjson.JSONArray;
import com.geoway.landteam.customtask.pub.entity.TaskTransformMedia;

import com.geoway.landteam.landcloud.common.constant.CommonConstants;
import com.geoway.landteam.landcloud.common.dto.BaseObjectResponse;
import com.geoway.landteam.landcloud.core.model.base.entity.AppBasic;
import com.geoway.landteam.landcloud.servface.customtask.task.MTaskAttachTransformService;
import com.geoway.landteam.landcloud.service.base.impl.AppBasicServiceImpl;
import com.geoway.landteam.landcloud.service.customtask.task.MTaskTransMediaService;
import com.gw.base.log.GwLoger;
import com.gw.base.log.GiLoger;


/**
 * @Author: zhenkaining
 * @Date: 2019/11/22 15:34
 * @Description:
 */
@Service
public class MTaskAttachTransTakeHandImpl implements MTaskAttachTransformService {
    @Autowired
    AppBasicServiceImpl appBasicService;
    @Autowired
    MTaskTransMediaService taskTransMediaService;
    private final GiLoger logger = GwLoger.getLoger(MTaskAttachTransTakeHandImpl.class);

    @Override
    public BaseObjectResponse transform(HttpServletRequest request, long userId, String sourceTaskCode, String sourceTaskName, String targetTaskCode, String targetTaskName,
                                        JSONArray mediaArrary, String xzqdm, String tbid) {
        BaseObjectResponse baseResponse = new BaseObjectResponse();
        try {
            String token = request.getSession().getAttribute("access_token").toString();

            if (appBasicService.exist(tbid)) {
                List<String> ids = new ArrayList<>();
                ids.add(tbid);
                List<AppBasic> basicList = appBasicService.getBasicListByIds(ids, userId);
                if (basicList != null && basicList.size() > 0) {
                    if (mediaArrary != null && mediaArrary.size() > 0) {
                        List<TaskTransformMedia> mediaList = new ArrayList<>();
                        for (Object jsonObj : mediaArrary) {
                            JSONObject jsonObject = JSONObject.parseObject(JSONObject.toJSONString(jsonObj));
                            if (jsonObject != null) {
                                TaskTransformMedia media =
                                        Gw.beans.getBean(TaskTransMediaService.class).convertTaskTransMediaFromJson
                                                (jsonObject);
                                media.setAttachId(UUID.randomUUID().toString());
                                mediaList.add(media);
                            }
                        }
                        taskTransMediaService.saveAttach(userId, tbid, basicList.get(0).getShape(), mediaList, token);
                    }
                }
                baseResponse.setStatus(CommonConstants.RESPONSE_STATUS_OK);
                baseResponse.setMessage("转换成功!");
            } else {
                baseResponse.setStatus(CommonConstants.RESPONSE_STATUS_FAILURE);
                baseResponse.setMessage("目标项目不存在");
            }

        } catch (Exception e) {
            e.printStackTrace();
            logger.error(e);
            baseResponse.setStatus(CommonConstants.RESPONSE_STATUS_FAILURE);
            baseResponse.setMessage(e.getMessage());
        }

        return baseResponse;
    }
}
