package com.geoway.landteam.landcloud.service.customtask.task.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.pub.entity.TaskDataDbParameter;
import com.geoway.landteam.customtask.pub.entity.TaskRecord;
import com.geoway.landteam.customtask.pub.entity.TaskRecordTemp;
import com.geoway.landteam.customtask.servface.multitask.DataBizService;

import com.geoway.landteam.customtask.servface.task.TaskRecordService;
import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.service.task.TaskNoticeServiceImpl;


import com.geoway.landteam.customtask.service.task.thread.TaskRecieveThread;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.model.pub.constants.JobConstants;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.landcloud.servface.customtask.task.MITaskRecieveService;
import com.gw.base.log.GwLoger;
import com.gw.base.log.GiLoger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.concurrent.*;

/**
 * @Author: zkn
 * @Date: 2020/6/20 16:30
 * @Description:
 */
@Service
public class MTaskRecieveServiceImpl implements MITaskRecieveService {

    protected String uploadDir;
   /* @Autowired
    ThreadPoolTaskExecutor threadPoolTaskExecutor;*/
    @Autowired
    DefaultOssOperatorService ossOperatorService;
    @Autowired
    TaskNoticeServiceImpl taskNoticeService;
    @Autowired
    TskTaskBizService tskTaskBizService;
    @Autowired
    DataBizService dataBizService;

    @Autowired
    TaskRecordService taskRecordService;

   /* @Autowired
    TaskRecieveProducerServiceImpl taskRecieveProducerService;
*/
    ExecutorService threadPool= Executors.newFixedThreadPool(10);

    private final GiLoger logger = GwLoger.getLoger(MTaskRecieveServiceImpl.class);
//    @Autowired
//    WorkGroupMemberRepository workGroupMemberRepository;

    @Override
    public void recieveTask(Long userId, String taskId, JSONArray tbIds, JSONArray groups) {

        List<String> list = JSONObject.parseArray(JSONObject.toJSONString(tbIds),  String.class);

        TskTaskBiz tskTaskBiz = tskTaskBizService.getTskTaskBizById(taskId);
        JSONObject additionJson = new JSONObject();
        additionJson.put("count", tbIds.size());
        if(Objects.equals(tskTaskBiz.getMode(),1)) {
            additionJson.put("addOrUpdate", "ADD");
        }
        else if(Objects.equals(tskTaskBiz.getMode(),2)){
            additionJson.put("addOrUpdate", "UPDATE");
        }
        additionJson.put("taskMode", tskTaskBiz.getMode());
        additionJson.put("curMode", "assign");

        String recordId = UUID.randomUUID().toString();
        TaskDataDbParameter parameter = new TaskDataDbParameter();
        parameter.setGroups(groups);
        parameter.setTaskId(taskId);
        parameter.setUserId(userId);
        //parameter.setIds(list);
        parameter.setAddition(additionJson);
        parameter.setMode(tskTaskBiz.getMode().toString());
        parameter.setRecordId(recordId);

        //将参数添加到任务记录中进行后台处理
        JSONObject params = new JSONObject();
            params.put("filterType", "checkFilter");
            params.put("userId", userId);
            params.put("TaskDataDbParameter", parameter);
            params.put("taskId", taskId);
        // 任务领取记录
        TaskRecord record = new TaskRecord();
        record.setId(recordId);
        record.setParam(JSONObject.toJSONString(params));
        record.setTasktype(JobConstants.JOB_TYPE_DATA_ASSIGN);
        record.setStarttime(new Date());
        record.setState(1);
        record.setUserid(userId);
        taskRecordService.save(record);

        List<TaskRecordTemp> tempList = new ArrayList<>();
        for (int i = 0; i < list.size(); i++) {
            TaskRecordTemp temp = new TaskRecordTemp();
            temp.setId(UUID.randomUUID().toString());
            temp.setRecordid(recordId);
            temp.setDataid(list.get(i));
            tempList.add(temp);
        }

        taskRecordService.saveTaskRecordTemp(tempList);
        //taskRecieveProducerService.sendMessageToMq(taskId, JSONObject.toJSONString(parameter),recordId);
    }

    @Override
    public void doRecieve(TaskDataDbParameter parameter) {
        // 该方法弃用
        if (parameter == null) {
            return;
        }

        TaskRecord one = taskRecordService.findOne(parameter.getRecordId());
        uploadDir = (String) ProjectConfig.getConfig(ProjectConfigEnum.UPLOAD_DIR.getKey());
        TaskRecieveThread threadRecieve = new TaskRecieveThread(tskTaskBizService,
                taskNoticeService, ossOperatorService, dataBizService, uploadDir, parameter,taskRecordService);
        //threadPoolTaskExecutor.execute(threadRecieve);

        Future<?> future = threadPool.submit(threadRecieve);
        String failReason = null;
        try {
            // 等待计算结果，最长等待timeout秒，timeout秒后中止任务
            Object o = future.get(60, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            failReason = "主线程在等待返回结果时被中断！";
            one.setState(4);
            one.setRemark(failReason);
            taskRecordService.save(one);
        } catch (ExecutionException e) {
            failReason = "主线程等待返回结果，但任务本身抛出异常！";
            one.setState(4);
            one.setRemark(failReason);
            taskRecordService.save(one);
        } catch (TimeoutException e) {
            failReason = "主线程等待计算结果超时，因此中断任务线程！";
            one.setState(4);
            one.setRemark(failReason);
            taskRecordService.save(one);
        }
    }
}
