package com.geoway.landteam.landcloud.service.customtask.task.impl;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.pub.entity.TaskTransformData;
import com.geoway.landteam.customtask.service.pub.ProxyService;
import com.geoway.landteam.landcloud.common.constant.CommonConstants;
import com.geoway.landteam.landcloud.common.dto.BaseObjectResponse;

import com.geoway.landteam.landcloud.servface.customtask.task.MTaskTransformService;
import com.gw.base.log.GwLoger;
import com.gw.base.log.GiLoger;
import com.geoway.landteam.landcloud.common.util.base.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


/**
 * @Author: zhenkaining
 * @Date: 2019/11/20 14:31
 * @Description:
 */
@Service
public class MTaskTransOtherImpl implements MTaskTransformService {
    private final GiLoger logger = GwLoger.getLoger(MTaskTransOtherImpl.class);

    @Autowired
    ProxyService proxyService;
    @Override
    public boolean checkData(List<TaskTransformData> tbDataList, Map<String, List<String>> errorInfo) {
        return true;
    }

    @Override
    public BaseObjectResponse transform(HttpServletRequest request, long userId, String sourceTaskCode, String sourceTaskName, String targetTaskCode, String targetTaskName, List<TaskTransformData> tbDataList, String xzqdm) {
        BaseObjectResponse baseResponse = new BaseObjectResponse();
        try {
            Map<String, List<String>> errorInfo = new HashMap<>();
            if (checkData(tbDataList, errorInfo)) {
                String thirdTokenStr = "";
                Object third_token = request.getSession().getAttribute("third_auth");
                if (third_token == null) {
                    thirdTokenStr = proxyService.getThirdToken(request);
                } else {
                    thirdTokenStr = (String) third_token;
                }

                Map<String, Object> param = getPostParameter(request, userId, sourceTaskCode, sourceTaskName, targetTaskCode, targetTaskName, tbDataList, xzqdm);
                // 将参数转成json字符串，调试使用
                String paramStr = JSONObject.toJSONString(param);
                String url = proxyService.thirdHost + "/webapi/gtdcyv2/tasktransform";
                HttpRequest post = HttpUtil.createPost(url).contentType("application/json");
                post.header("Authorization", thirdTokenStr);
                post.body(paramStr);
                cn.hutool.http.HttpResponse execute = post.execute();
                if (execute.getStatus()==200) {
                    JSONObject body =JSONObject.parseObject(execute.body()) ;
                    if (body != null) {
                        if (body.containsKey("code")) {
                            if (body.get("code").toString().equalsIgnoreCase("500")) {
                                throw new RuntimeException("第三方接口tasktransform请求错误,状态码：500");
                            }
                        }
                        Object data = body.get("data");
                        if (data != null) {
                            baseResponse.setStatus(CommonConstants.RESPONSE_STATUS_OK);
                            if (data.toString().equalsIgnoreCase("success")) {
                                data = "转换成功";
                            }
                            baseResponse.setMessage(data.toString());
                        }
                    }
                } else {
                    JSONObject body =JSONObject.parseObject(execute.body()) ;
                    baseResponse.setStatus(CommonConstants.RESPONSE_STATUS_FAILURE);
                    baseResponse.setMessage(body.get("error").toString());
                }
            } else {
                StringBuilder sb = new StringBuilder();
                if (!errorInfo.isEmpty()) {
                    for (String key : errorInfo.keySet()) {
                        sb.append(errorInfo.get(key));
                        sb.append(";");
                    }
                }
                baseResponse.setStatus(CommonConstants.RESPONSE_STATUS_FAILURE);
                baseResponse.setMessage(sb.toString());
            }
        } catch (Exception e) {
            logger.error(e);
            baseResponse.setStatus(CommonConstants.RESPONSE_STATUS_FAILURE);
            baseResponse.setMessage(e.getMessage());
        }

        return baseResponse;
    }

    private Map<String, Object> getPostParameter(HttpServletRequest request, long userId, String sourceTaskCode, String sourceTaskName, String targetTaskCode, String targetTaskName, List<TaskTransformData> tbDataList, String xzqdm) {
        Map<String, Object> param = new HashMap<>();
        param.put("srcTaskCode", sourceTaskCode);
        param.put("srcTaskName", sourceTaskName);
        if (StringUtils.isNotBlank(xzqdm)) {
            if (xzqdm.equalsIgnoreCase("1")) {
                param.put("xzqdm", "000000");
            } else {
                param.put("xzqdm", xzqdm);
            }
        } else {
            param.put("xzqdm", "");
        }
        param.put("tagtTaskCode", targetTaskCode);
        param.put("tagtTaskName", targetTaskName);
        JSONArray jsonArray = convertTbDataListToJsonArray(request, userId, tbDataList, xzqdm);
        param.put("datas", jsonArray);
        return param;
    }

    private JSONArray convertTbDataListToJsonArray(HttpServletRequest request, long userId, List<TaskTransformData> tbDataList, String xzqdm) {
        JSONArray jsonArray = new JSONArray();
        if (tbDataList != null && tbDataList.size() > 0) {
            for (TaskTransformData transformData : tbDataList) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("tbId", transformData.getTbId());
                jsonObject.put("prjNum", transformData.getPrjNum());
                jsonObject.put("prjName", transformData.getPrjName());
                if (StringUtils.isBlank(transformData.getRegionCode())) {
                    if (StringUtils.isNotBlank(xzqdm)) {
                        if (xzqdm.equalsIgnoreCase("1")){
                            jsonObject.put("regionCode", "000000");
                        }
                        else {
                            jsonObject.put("regionCode", xzqdm);
                        }
                    } else {
                        jsonObject.put("regionCode", "");
                    }
                } else {
                    if (transformData.getRegionCode().equalsIgnoreCase("1")){
                        jsonObject.put("regionCode", "000000");
                    }
                    else {
                        jsonObject.put("regionCode", transformData.getRegionCode());
                    }
                }
                jsonObject.put("extent", transformData.getExtent());
                jsonObject.put("md5", transformData.getMd5());
                jsonObject.put("medias", transformData.getMedias());
                jsonArray.add(jsonObject);
            }
        }
        return jsonArray;
    }


}
