package com.geoway.landteam.landcloud.service.customtask.task.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.pub.entity.TaskTransformData;
import com.geoway.landteam.customtask.pub.entity.TaskTransformMedia;

import com.geoway.landteam.customtask.servface.task.TaskTransMediaService;
import com.geoway.landteam.landcloud.common.constant.CommonConstants;
import com.geoway.landteam.landcloud.common.dto.BaseObjectResponse;
import com.geoway.landteam.landcloud.common.util.geometry.WKTUtil;
import com.geoway.landteam.landcloud.core.model.base.entity.AppBasic;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionDetail;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionVillage;
import com.geoway.landteam.landcloud.core.servface.region.RegionService;
import com.geoway.landteam.landcloud.core.servface.user.UserNameService;
import com.geoway.landteam.landcloud.servface.customtask.task.MTaskTransformService;
import com.geoway.landteam.landcloud.service.base.impl.AppBasicServiceImpl;
import com.geoway.landteam.landcloud.service.customtask.task.MTaskTransMediaService;
import com.gw.base.Gw;
import com.gw.base.log.GwLoger;
import com.gw.base.log.GiLoger;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.io.ParseException;
import com.geoway.landteam.landcloud.common.util.base.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletRequest;
import java.util.*;


//import  JSONObject;


/**
 * @Author: zhenkaining
 * @Date: 2019/11/20 14:29
 * @Description:
 */
@Service
public class MTaskTransTakeHandImpl implements MTaskTransformService {
    @Autowired
    AppBasicServiceImpl appBasicService;
    @Autowired
    MTaskTransMediaService taskTransMediaService;
    @Autowired
    UserNameService userNameService;
    @Autowired
    RegionService regionService;
    private final GiLoger logger = GwLoger.getLoger(MTaskTransTakeHandImpl.class);

    @Override
    public boolean checkData(List<TaskTransformData> tbDataList, Map<String, List<String>> errorInfo) {
//        List<String> errorLst = null;
//
//        if (tbDataList == null || tbDataList.size() == 0) {
//            errorLst = new ArrayList<>();
//            errorLst.add("图斑数据为空");
//            errorInfo.put("error", errorLst);
//            return false;
//        }
//        for (TaskTransformData data : tbDataList) {
//            errorLst = new ArrayList<>();
//            String tbid = "";
//            if (StringUtils.isBlank(data.getTbId())) {
//                errorLst.add("图斑编号为空");
//            } else {
//                tbid = data.getTbId();
//            }
//            if (StringUtils.isBlank(data.getTbName())) {
//                errorLst.add("图斑名称为空");
//            }
//            if (StringUtils.isBlank(data.getExtent())) {
//                errorLst.add("图斑范围为空");
//            }
//            if (data.getMedias() == null) {
//                errorLst.add("图斑附件为空");
//            }
//
//            for (Object media : data.getMedias()) {
//                try {
//                    JSONObject jsonObject = JSONObject.fromObject(media);
//                    if (!checkFieldAndValue(jsonObject, "attachId")) {
//                        errorLst.add(String.format("缺少%s字段或%s值为空", "attachId"));
//                    }
//                    if (!jsonObject.containsKey("mediaSource")) {
//                        errorLst.add(String.format("缺少%s字段", "mediaSource"));
//                    } else {
//                        if (!jsonObject.get("mediaSource").toString().equalsIgnoreCase("0")
//                                && !jsonObject.get("mediaSource").toString().equalsIgnoreCase("1")) {
//                            errorLst.add(String.format("%s字段取值不合法，必须为0或1", "mediaSource"));
//                        }
//                    }
//                    if (!checkFieldAndValue(jsonObject, "mediaFormat")) {
//                        errorLst.add(String.format("缺少%s字段或%s值为空", "mediaFormat"));
//                    }
//
//                    if (!checkFieldAndValue(jsonObject, "url")) {
//                        errorLst.add(String.format("缺少%s字段或%s值为空", "url"));
//                    }
//                    if (!checkFieldAndValue(jsonObject, "mediaMeta")) {
//                        errorLst.add(String.format("缺少%s字段或%s值为空", "mediaMeta"));
//                    }
//                    if (!checkFieldAndValue(jsonObject, "status")) {
//                        errorLst.add(String.format("缺少%s字段或%s值为空", "status"));
//                    }
//                } catch (Exception e) {
//                    e.printStackTrace();
//                    errorLst.add(e.getMessage());
//                }
//            }
//
//            if (StringUtils.isBlank(tbid)) {
//                errorInfo.put("##EmptyID" + UUID.randomUUID().toString(), errorLst);
//            } else {
//                errorInfo.put(tbid, errorLst);
//            }
//        }
        return true;
    }

    private boolean checkFieldAndValue(JSONObject jsonObject, String fieldName) {
        return jsonObject.containsKey(fieldName) && !StringUtils.isBlank(jsonObject.get(fieldName).toString());
    }

    @Override
    public BaseObjectResponse transform(HttpServletRequest request, long userId, String sourceTaskCode, String sourceTaskName, String targetTaskCode, String targetTaskName, List<TaskTransformData> tbDataList, String xzqdm) {
        BaseObjectResponse baseResponse = new BaseObjectResponse();
        try {
            String token = request.getSession().getAttribute("access_token").toString();

            Map<String, List<String>> errorInfo = new HashMap<>();
            if (checkData(tbDataList, errorInfo)) {
                if (tbDataList != null && tbDataList.size() > 0) {
                    for (TaskTransformData tbData : tbDataList) {
                        AppBasic appBasic = new AppBasic();
                        String uuid = UUID.randomUUID().toString();
                        String tbId = "";
//                        boolean exist=appBasicService.exist(tbData.getTbId());
//                        tbId=exist?uuid:tbData.getTbId();
                        tbId = uuid;
                        appBasic.setId(tbId);
                        appBasic.setUserid(String.valueOf(userId));
                        // 名称
                        appBasic.setHeading(tbData.getTbName());
                        appBasic.setCreatetime(String.valueOf(System.currentTimeMillis()));
                        // 必须设置字段
                        appBasic.setTime(new Date());
                        appBasic.setIsDeleted(0);
                        if (StringUtils.isNotBlank(tbData.getRegionCode())) {
                            if (tbData.getRegionCode().equalsIgnoreCase("000000")) {
                                // 今奥的图斑的行政区代码中，000000表示全国，我们的系统中 1代表全国
                                appBasic.setRegion("1");
                            } else {
                                appBasic.setRegion(tbData.getRegionCode());
                            }
                        } else {
                            appBasic.setRegion("");
                        }
                        appBasic.setShape(tbData.getExtent());

                        try {
                            String regionName = getRegionNameByExtent(tbData.getExtent());
                            if (StringUtils.isNotBlank(regionName)) {
                                // 设置拍摄地点
                                appBasic.setName(regionName);
                            }
                        } catch (ParseException e) {
                            e.printStackTrace();
                        }
                        appBasic.setRequestId(tbData.getRequestId());
                        // 909 表示 我的任务
                        appBasic.setOri("909");
                        appBasic.setType("");
                        appBasic.setMj(tbData.getTbmj());
                        String userName = userNameService.getUserNameByUserId(String.valueOf(userId));
                        if (StringUtils.isNotBlank(userName)) {
                            appBasic.setUsername(userName);
                        }

                        JSONArray jsonArray = tbData.getMedias();
                        if (jsonArray != null && jsonArray.size() > 0) {
                            List<TaskTransformMedia> mediaList = new ArrayList<>();
                            for (Object obj : jsonArray) {
                                JSONObject jsonObject = JSONObject.parseObject(JSONObject.toJSONString(obj));
                                if (jsonObject != null) {
                                    TaskTransformMedia media =
                                            Gw.beans.getBean(TaskTransMediaService.class).convertTaskTransMediaFromJson
                                                    (jsonObject);
                                    media.setAttachId(UUID.randomUUID().toString());
                                    mediaList.add(media);
                                }
                            }
                            taskTransMediaService.saveAttach(userId, tbId, appBasic.getShape(), mediaList, token);
                        }
                        appBasicService.save(appBasic);
                        try {
                            appBasicService.updateLonLatById(appBasic.getId());
                        } catch (Exception e) {
                            logger.error("任务转换-转成随手拍后，根据shape更新随手拍的中心点坐标报错");
                            logger.error(e);
                        }
                    }
                }
                baseResponse.setStatus(CommonConstants.RESPONSE_STATUS_OK);
                baseResponse.setMessage("转换成功!");
            } else {
                StringBuilder sb = new StringBuilder();
                if (!errorInfo.isEmpty()) {
                    for (String key : errorInfo.keySet()) {
                        sb.append(errorInfo.get(key));
                        sb.append(";");
                    }
                }
                baseResponse.setStatus(CommonConstants.RESPONSE_STATUS_FAILURE);
                baseResponse.setMessage(sb.toString());
            }
        } catch (Exception e) {
            logger.error(e);
            baseResponse.setStatus(CommonConstants.RESPONSE_STATUS_FAILURE);
            baseResponse.setMessage(e.getMessage());
        }

        return baseResponse;
    }

    /**
     * 根据extent获取中心点的行政区名称
     *
     * @param extent
     * @return
     * @throws Exception
     */
    private String getRegionNameByExtent(String extent) throws Exception {
        if (StringUtils.isBlank(extent)) {
            return "";
        }
        // 拍摄地点，根据shape计算中心点，然后根据中心点，获取所在的位置
        Geometry geometry = WKTUtil.wktToGeom(extent);
        if (geometry != null && geometry.getCentroid() != null) {
            Point centroid = geometry.getCentroid();
            String wkt = "POINT(" + centroid.getX() + " " + centroid.getY() + ")";
            RegionDetail region = regionService.queryRegionByGeom(wkt, 4490, 3);
            if (region == null) {
                // 由于行政区缝隙或地级市找不到行政区代码，先查询市级行政区代码
                region = regionService.queryRegionByGeom(wkt, 4490, 2);
            }
            if (region == null) {
                // 如果刚好处在市级缝隙，则作缓冲区查询
                region = regionService.queryRegionByGeom(wkt, 4490, 2, 2000);
            }
            if (region != null) {
                String name = region.getName();
                RegionVillage village = regionService.queryVillageCotain(wkt, 0);
                if (village != null) {
                    name += village.getName();
                }
                return name;
            }
        }

        return "";
    }


}
