package com.geoway.landteam.landcloud.service.customtask.task.impl;


import com.geoway.landteam.customtask.mapper.task.TbtskSuperUserAuditAreaMapper;
import com.geoway.landteam.customtask.task.entity.TbtskSuperUserAuditArea;
import com.geoway.landteam.landcloud.core.servface.region.RegionService;
import com.geoway.landteam.landcloud.servface.customtask.task.MTbtskSuperUserAuditAreaService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.List;

@Service
public class MTbtskSuperUserAuditAreaServiceImpl implements MTbtskSuperUserAuditAreaService {

    @Autowired
    private TbtskSuperUserAuditAreaMapper tbtskSuperUserAuditAreaMapper;

    @Autowired
    private RegionService regionService;


    @Override
    public int deleteByPrimaryKey(Long id) {
        return tbtskSuperUserAuditAreaMapper.deleteByPrimaryKey(id);
    }

    @Override
    public int deleteByTaskIdAndUserId(String taskId,String userId) {
        return tbtskSuperUserAuditAreaMapper.deleteByTaskIdAndUserId(taskId,userId);
    }

    @Override
    public int deleteByTaskId(String taskId) {
        return tbtskSuperUserAuditAreaMapper.deleteByTaskId(taskId);
    }

    @Override
    public int insert(TbtskSuperUserAuditArea record) {
        return tbtskSuperUserAuditAreaMapper.insert(record);
    }

    @Override
    public int insertSelective(TbtskSuperUserAuditArea record) {
        return tbtskSuperUserAuditAreaMapper.insertSelective(record);
    }

    @Override
    public TbtskSuperUserAuditArea selectByPrimaryKey(Long id) {
        return tbtskSuperUserAuditAreaMapper.selectByPrimaryKey(id);
    }

    @Override
    public int updateByPrimaryKeySelective(TbtskSuperUserAuditArea record) {
        return tbtskSuperUserAuditAreaMapper.updateByPrimaryKeySelective(record);
    }

    @Override
    public int updateByPrimaryKey(TbtskSuperUserAuditArea record) {
        return tbtskSuperUserAuditAreaMapper.updateByPrimaryKey(record);
    }

    @Override
    public int updateByTaskIdAndUserId(String taskId, String userId, String regions,String version) {
        List<String> tempRegionList = Arrays.asList(regions.split(","));
        for(String s:tempRegionList){
            List<TbtskSuperUserAuditArea> list = tbtskSuperUserAuditAreaMapper.queryByTaskIdAndUserIdAndRegioncode(taskId,
                    userId,s);
            if(list.size() <= 0){
                TbtskSuperUserAuditArea TbtskSuperUserAuditArea = new TbtskSuperUserAuditArea();
                /*if ("1".equalsIgnoreCase(s)) {
                    TbtskSuperUserAuditArea.setLevel((short) 0);
                } else if (s.endsWith("0000")) {
                    TbtskSuperUserAuditArea.setLevel((short) 1);
                } else if (s.endsWith("00")) {
                    TbtskSuperUserAuditArea.setLevel((short) 2);
                } else {
                    if(s.length() == 6){
                        TbtskSuperUserAuditArea.setLevel((short) 3);
                    }else if(s.length() == 9){
                        TbtskSuperUserAuditArea.setLevel((short) 4);
                    }else if(s.length() == 12){
                        TbtskSuperUserAuditArea.setLevel((short) 5);
                    }
                }*/
                TbtskSuperUserAuditArea.setLevel(regionService.getRegionLevel(s, version).shortValue());
                TbtskSuperUserAuditArea.setRegionCode(s);
                TbtskSuperUserAuditArea.setTaskId(taskId);
                TbtskSuperUserAuditArea.setUserId(userId);
                tbtskSuperUserAuditAreaMapper.insertSelective(TbtskSuperUserAuditArea);
            }
        }
        return tempRegionList.size();
    }

    @Override
    public int delByTaskIdAndUserId(String taskId, String userId, String regions) {
        List<String> tempRegionList = Arrays.asList(regions.split(","));
        for(String s:tempRegionList) {
            List<TbtskSuperUserAuditArea> list = tbtskSuperUserAuditAreaMapper.queryByTaskIdAndUserIdAndRegioncode(taskId, userId, s);
            list.forEach(a -> tbtskSuperUserAuditAreaMapper.deleteByPrimaryKey(a.getId()));
        }
        return tempRegionList.size();
    }

    @Override
    public List<TbtskSuperUserAuditArea> listAuditAreas(String taskId, String userId, Short level) {
        return tbtskSuperUserAuditAreaMapper.listAuditAreas(taskId, userId, level);
    }

    @Override
    public List<TbtskSuperUserAuditArea> listAuditAreas(String taskId, String userId) {
        return tbtskSuperUserAuditAreaMapper.queryByTaskIdAndUserId(taskId, userId);
    }


    @Override
    public List<TbtskSuperUserAuditArea> queryListByTaskId(String taskId) {
        return tbtskSuperUserAuditAreaMapper.queryListByTaskId(taskId);
    }

    @Override
    public void copyTaskRoleByUserId(String sourceTaskId, String targetTaskId, List<String> userList) {
        List<TbtskSuperUserAuditArea> list = tbtskSuperUserAuditAreaMapper.queryByTaskIdAndUserIds(sourceTaskId,userList);
        if(!list.isEmpty()){
            for(TbtskSuperUserAuditArea bean : list){
                bean.setId(null);
                bean.setTaskId(targetTaskId);
                List<TbtskSuperUserAuditArea> TbtskSuperUserAuditAreas = tbtskSuperUserAuditAreaMapper .queryByTaskIdAndUserIdAndRegioncode(targetTaskId, bean.getUserId(),bean.getRegionCode());
                if(TbtskSuperUserAuditAreas.isEmpty()){
                    tbtskSuperUserAuditAreaMapper.insertSelective(bean);
                }
            }
        }
    }
}








