package com.geoway.landteam.landcloud.service.customtask.task.impl;


import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

import com.geoway.landteam.customtask.repository.task.TbtskTaskClassRepository;
import com.geoway.landteam.customtask.repository.task.TbtskUserTaskClassRepository;
import com.geoway.landteam.customtask.repository.task.TskTaskBizRepository;
import com.geoway.landteam.customtask.servface.multitask.TbtskObjectinfoService;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TbtskTaskClass;
import com.geoway.landteam.customtask.task.entity.TbtskUserTaskClass;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.common.util.orm.QueryParamUtil;
import com.geoway.landteam.landcloud.common.util.orm.QuerySpecification;
import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.geoway.landteam.landcloud.core.servface.base.SysConfigService;
import com.geoway.landteam.landcloud.core.servface.region.RegionService;
import com.geoway.landteam.landcloud.servface.customtask.task.MTbtskTaskClassService;
import com.gw.base.util.GutilStr;

/**
 * @author panzhiguang
 * @Package com.geoway.land.core.cloud.service.impl
 * @date 2021/3/31 9:27
 */
@Service
public class MTbtskTaskClassServiceImpl implements MTbtskTaskClassService {

    @Autowired
    TbtskTaskClassRepository tbtskTaskClassRepository;

    @Autowired
    TbtskUserTaskClassRepository tbtskUserTaskClassRepository;

    @Autowired
    TskTaskBizRepository tskTaskBizRepository;

    @Autowired
    SysConfigService sysConfigService;

    @Autowired
    JdbcTemplate jdbcTemplate;

    @Autowired
    TbtskObjectinfoService tbtskObjectinfoService;

    @Autowired
    RegionService regionService;

    @Override
    public TbtskTaskClass trees(Long parentId) {
        TbtskTaskClass tbtskTaskClass = tbtskTaskClassRepository.queryByFId(parentId);
        if(tbtskTaskClass != null){
            List<TbtskTaskClass> tbtskTaskClasses = tbtskTaskClassRepository.queryByParentId(parentId);
            tbtskTaskClasses.forEach(this::completeChildren);
            tbtskTaskClass.setChildren(tbtskTaskClasses);
        }
        return tbtskTaskClass;
    }

    @Override
    public TbtskTaskClass getTopParent(Long classId) {
        TbtskTaskClass tbtskTaskClass = tbtskTaskClassRepository.queryByFId(classId);
        if(tbtskTaskClass.getLevel() > 1){
           return  completeParentClass(tbtskTaskClass.getParentId());
        }else{
            return tbtskTaskClass;
        }
    }



    /**
     * 获取业务范围树
     * @param branch
     * @return
     */
    @Override
    public List<TbtskTaskClass>  treesNew(String branch,String appsId,Long userId) {
        // 获取业务大类
        List<TbtskTaskClass> lists = new ArrayList<>();
        if (branch != null) {
            SysConfig sysConfig = sysConfigService.findOne(branch);
            if (sysConfig != null) {
                lists = tbtskTaskClassRepository.queryByParentIdAndAppkey(-1L, sysConfig.getValue());
            }else {
                if(userId != null ){
                    if("XCYW".equals(branch)){
                        lists = tbtskTaskClassRepository.queryByParentIdAndAppkeyAndUserId(-1L, branch,userId);
                    }else{
                        lists = tbtskTaskClassRepository.queryByParentIdNOTXCYWAndUserId(-1L,userId);
                    }
                }else{
                    if("XCYW".equals(branch)){
                        lists = tbtskTaskClassRepository.queryByParentIdAndAppkey(-1L, branch);
                    }else{
                        lists = tbtskTaskClassRepository.queryByParentIdNOTXCYW(-1L);
                    }
                }
            }
        } else if(StringUtils.isNotBlank(appsId)){
            if(userId != null ){
                lists = tbtskTaskClassRepository.queryByParentIdAndAppkeyAndUserId(-1L, appsId,userId);
            }else{
                lists = tbtskTaskClassRepository.queryByParentIdAndAppkey(-1L, appsId);
            }
        }else {
            lists = tbtskTaskClassRepository.queryByParentId(-1L);
        }
        for(TbtskTaskClass tbtskTaskClass : lists){
            List<TbtskTaskClass> tbtskTaskClasses = tbtskTaskClassRepository.queryByParentId(tbtskTaskClass.getId());
            tbtskTaskClasses.forEach(this::completeChildren);
            if(tbtskTaskClasses.size() > 0){
                tbtskTaskClass.setChildren(tbtskTaskClasses);
            }else{
                tbtskTaskClass.setChildren(null);
            }
        }
        return lists;
    }

    /**
     * 业务大类分组及业务成果汇总
     * @param branch
     * @return
     */
    public  List<TbtskTaskClass> getTaskClassStatistical(String branch){
        // 获取业务大类
        List<TbtskTaskClass> lists = new ArrayList<>();
        if (branch != null) {
            SysConfig sysConfig = sysConfigService.findOne(branch);
            if (sysConfig != null) {
                lists = tbtskTaskClassRepository.queryByParentIdAndAppkey(-1L, sysConfig.getValue());
            }else {
                if("XCYW".equals(branch)){
                    lists = tbtskTaskClassRepository.queryByParentIdAndAppkey(-1L, branch);
                }else{
                    lists = tbtskTaskClassRepository.queryByParentIdNOTXCYW(-1L);
                }
            }
        } else {
            lists = tbtskTaskClassRepository.queryByParentId(-1L);
        }
        for(TbtskTaskClass tbtskTaskClass : lists){
            List<Long> classIds = new ArrayList<>();
            classIds.add(tbtskTaskClass.getId());
            List<Long> tbtskTaskClasses = tbtskTaskClassRepository.queryClassIdByParentId(tbtskTaskClass.getId());
            for (Long id : tbtskTaskClasses) {
                queryClassIdByParentId(id,tbtskTaskClasses);
            }
            if(tbtskTaskClasses.size() > 0){
                classIds.addAll(tbtskTaskClasses);
            }
            if(classIds.size() >0){
                String countsql = "select count(1) from tb_app_media media,tbtsk_task_biz biz where biz.f_id = media.f_bizid and biz.f_classid in ("+ GutilStr.join(classIds,",")+")";
                Integer count = jdbcTemplate.queryForObject(countsql, Integer.class);
                tbtskTaskClass.setPhotoNum(count);
            }else{
                tbtskTaskClass.setPhotoNum(0);
            }
        }
        return lists;
    }


    public void queryClassIdByParentId(Long classId,List<Long> classIds) {
        List<Long> tbtskTaskClasses = tbtskTaskClassRepository.queryClassIdByParentId(classId);
        for (Long id : tbtskTaskClasses) {
            queryClassIdByParentId(id,classIds);
        }
        if(tbtskTaskClasses.size() > 0){
            classIds.addAll(tbtskTaskClasses);
        }
    }

    public TbtskTaskClass getParentTbtskTaskClass(Long classId){
        TbtskTaskClass tbtskTaskClass = tbtskTaskClassRepository.queryByFId(classId);
        if(tbtskTaskClass!= null && tbtskTaskClass.getParentId() != -1){
            tbtskTaskClass =  getParentTbtskTaskClass(tbtskTaskClass.getParentId());
        }
        return tbtskTaskClass;
    }

    /**
     *  获取包含任务数据tree
     * @param parentId
     * @param userId
     * @return
     */
    @Override
    public TbtskTaskClass containTaskTrees(Long parentId,Long userId) {
        TbtskTaskClass tbtskTaskClass = tbtskTaskClassRepository.queryByFId(parentId);
        List<TskTaskBiz> taskBizs = distinct(tskTaskBizRepository.getBizListsByTypeAndUserId(parentId,userId));
        List<TbtskTaskClass> tbtskTaskClasses = tbtskTaskClassRepository.queryByParentId(parentId);
        tbtskTaskClasses.forEach(e ->{
            completeChildren(e,userId);
        });
        tbtskTaskClass.setChildren(tbtskTaskClasses);
        tbtskTaskClass.setTaskBizs(taskBizs);
        return tbtskTaskClass;
    }

    /**
     * 去重
     * @param deviceTracks
     * @return
     */
    public List<TskTaskBiz> distinct(List<TskTaskBiz> deviceTracks){
        Set set = new HashSet();
        List<TskTaskBiz> doubleList= new ArrayList<>();
        set.addAll(deviceTracks);
        doubleList.addAll(set);
        return doubleList;
    }

    private void completeChildren(TbtskTaskClass tbtskTaskClass) {
        List<TbtskTaskClass> tbtskTaskClasses = tbtskTaskClassRepository.queryByParentId(tbtskTaskClass.getId());
        tbtskTaskClasses.forEach(this::completeChildren);
        tbtskTaskClass.setChildren(tbtskTaskClasses);
    }

    private TbtskTaskClass completeParentClass(Long classId) {
        TbtskTaskClass tbtskTaskClass = tbtskTaskClassRepository.queryByFId(classId);
        if(tbtskTaskClass.getLevel() > 1){
            return completeParentClass(tbtskTaskClass.getParentId());
        }else{
            return tbtskTaskClass;
        }
    }
    //获取包含任务数据tree
    private void completeChildren(TbtskTaskClass tbtskTaskClass,Long userId) {
        List<TbtskTaskClass> tbtskTaskClasses = tbtskTaskClassRepository.queryByParentId(tbtskTaskClass.getId());
        List<TskTaskBiz> taskBizs = distinct(tskTaskBizRepository.getBizListsByTypeAndUserId(tbtskTaskClass.getId(),userId));
        tbtskTaskClasses.forEach(e ->{
            completeChildren(e,userId);
        });
        tbtskTaskClass.setChildren(tbtskTaskClasses);
        tbtskTaskClass.setTaskBizs(taskBizs);
    }

    /**
     *  获取业务成果
     * @param type  1 业务分组  2 任务
     * @param keyWord  1. 分组id  2 任务id
     * @return
     */
    public Object getTaskStatistical(Integer type,String keyWord){
        List<Map<String, Object>> resultMaps = new ArrayList<>();
        if(type == 1 ){
            List<Long> classIds = new ArrayList<>();
            classIds.add(Long.valueOf(keyWord));
            List<Long> tbtskTaskClasses = tbtskTaskClassRepository.queryClassIdByParentId(Long.valueOf(keyWord));
            for (Long id : tbtskTaskClasses) {
                queryClassIdByParentId(id,tbtskTaskClasses);
            }
            if(tbtskTaskClasses.size() > 0){
                classIds.addAll(tbtskTaskClasses);
            }
            String sql = "select biz.f_id taskid,biz.f_name taskname, count(1)-1 count from tbtsk_task_biz biz " +
                    "left join tb_app_media media on(biz.f_id = media.f_bizid) where   biz.f_classid in ("+GutilStr.join(classIds,",")+") GROUP " +
                    "BY biz.f_id,biz.f_name;";
            resultMaps  = jdbcTemplate.queryForList(sql);

        }else if(type == 2){
            TskTaskBiz taskBiz = tskTaskBizRepository.findById(keyWord).orElse(null);
            if(taskBiz.getTableId() != null){
                TbtskObjectinfo tableInfo = tbtskObjectinfoService.getObjectbyID(taskBiz.getTableId());
                if(tableInfo != null && tableInfo.getfTablename() != null){
                    String sql = "select  substring(tb.f_xzqdmsys,0,5) xzqdm,count(1) from "+tableInfo.getfTablename()+" tb , tb_app_media " +
                            "media where tb.f_id = media.f_galleryid  group by substring(tb.f_xzqdmsys,0,5)";
                    resultMaps = jdbcTemplate.queryForList(sql);
                    if(resultMaps.size() > 0){
                        for(Map<String, Object> map : resultMaps){
                            String xzqdm = map.get("xzqdm").toString().length()<6? map.get("xzqdm").toString()+"00":map.get("xzqdm").toString();
                            map.put("xzqdm",xzqdm);
                            String allFullName = regionService.getName(xzqdm);
                            map.put("xzqdmName",allFullName);
                        }
                    }
                }
            }
        }
        return resultMaps;
    }
    @Override
    public List<TbtskTaskClass> getTbtskTaskClassByName(String name,Long parentId) {
        return  tbtskTaskClassRepository.queryByName(name,parentId);
    }

    @Override
    public TbtskTaskClass findById(Long id) {
        return tbtskTaskClassRepository.queryByFId(id);
    }

    @Override
    public TbtskTaskClass save(TbtskTaskClass bean) {
        TbtskTaskClass save = tbtskTaskClassRepository.save(bean);
        //新增大类需给创建者赋予该业务权限
        TbtskUserTaskClass tbtskUserTaskClass = new TbtskUserTaskClass();
        tbtskUserTaskClass.setCreateDate(new Date());
        tbtskUserTaskClass.setUserId(save.getUserId());
        tbtskUserTaskClass.setClassId(save.getId());
        tbtskUserTaskClassRepository.save(tbtskUserTaskClass);
        return save;
    }

    @Override
    public List<TbtskTaskClass> queryAll() {
        return tbtskTaskClassRepository.findAll(new QuerySpecification<>(""));
    }
    
	@Override
	public List<TbtskTaskClass> getTaskClassTree() {
		List<TbtskTaskClass> findAll = tbtskTaskClassRepository.findAll(QueryParamUtil.parseSortParams("SORT_id_ASC"));
		List<TbtskTaskClass> collect = findAll.stream().filter(map->"-1".equals(map.getParentId().toString())).collect(Collectors.toList());
		for (int i = 0; i < collect.size(); i++) {
			completeChildren(collect.get(i),findAll);
		}
		return collect;
	}

    @Override
    public List<TbtskTaskClass> getAllChildrenByParentId(Long classId,List<TbtskTaskClass> result) {
        TbtskTaskClass tbtskTaskClass1 = tbtskTaskClassRepository.queryByFId(classId);
        List<TbtskTaskClass> tbtskTaskClasses = tbtskTaskClassRepository.queryByParentId(classId);
        //把自己加入
        if(result==null){
            result = new ArrayList<>();
            result.add(tbtskTaskClass1);
        }
        if(!tbtskTaskClasses.isEmpty()){

            result.addAll(tbtskTaskClasses);

            for (TbtskTaskClass tbtskTaskClass : tbtskTaskClasses) {
                getAllChildrenByParentId(tbtskTaskClass.getId(),result);
            }
        }
        return result;
    }

    private void completeChildren(TbtskTaskClass tbtskTaskClass, List<TbtskTaskClass> findAll) {
		List<TbtskTaskClass> children = findAll.stream().filter(map->tbtskTaskClass.getId().equals(map.getParentId())).collect(Collectors.toList());
		if(children.size() > 0) {
			tbtskTaskClass.setChildren(children);
			for (int i = 0; i < children.size(); i++) {
				completeChildren(children.get(i),findAll);
			}
		}
	}
}
