package com.geoway.landteam.landcloud.service.customtask.task.impl;


import com.geoway.landteam.customtask.mapper.task.TbtskUserAuditAreaMapper;
import com.geoway.landteam.customtask.task.entity.TbtskUserAuditArea;
import com.geoway.landteam.landcloud.core.servface.region.RegionService;
import com.geoway.landteam.landcloud.servface.customtask.task.MTbtskUserAuditAreaService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.List;

@Service
public class MTbtskUserAuditAreaServiceImpl implements MTbtskUserAuditAreaService {

    @Autowired
    private TbtskUserAuditAreaMapper tbtskUserAuditAreaMapper;

    @Autowired
    private RegionService regionService;


    @Override
    public int deleteByPrimaryKey(Long id) {
        return tbtskUserAuditAreaMapper.deleteByPrimaryKey(id);
    }

    @Override
    public int deleteByTaskIdAndUserId(String taskId,String userId) {
        return tbtskUserAuditAreaMapper.deleteByTaskIdAndUserId(taskId,userId);
    }

    @Override
    public int deleteByTaskId(String taskId) {
        return tbtskUserAuditAreaMapper.deleteByTaskId(taskId);
    }

    @Override
    public int insert(TbtskUserAuditArea record) {
        return tbtskUserAuditAreaMapper.insert(record);
    }

    @Override
    public int insertSelective(TbtskUserAuditArea record) {
        return tbtskUserAuditAreaMapper.insertSelective(record);
    }

    @Override
    public TbtskUserAuditArea selectByPrimaryKey(Long id) {
        return tbtskUserAuditAreaMapper.selectByPrimaryKey(id);
    }

    @Override
    public int updateByPrimaryKeySelective(TbtskUserAuditArea record) {
        return tbtskUserAuditAreaMapper.updateByPrimaryKeySelective(record);
    }

    @Override
    public int updateByPrimaryKey(TbtskUserAuditArea record) {
        return tbtskUserAuditAreaMapper.updateByPrimaryKey(record);
    }

    @Override
    public int updateByTaskIdAndUserId(String taskId, String userId, String regions,String version) {
        List<String> tempRegionList = Arrays.asList(regions.split(","));
        for(String s:tempRegionList){
            List<TbtskUserAuditArea> list = tbtskUserAuditAreaMapper.queryByTaskIdAndUserIdAndRegioncode(taskId,
                    userId,s);
            if(list.size() <= 0){
                TbtskUserAuditArea tbtskUserAuditArea = new TbtskUserAuditArea();
                /*if ("1".equalsIgnoreCase(s)) {
                    tbtskUserAuditArea.setLevel((short) 0);
                } else if (s.endsWith("0000")) {
                    tbtskUserAuditArea.setLevel((short) 1);
                } else if (s.endsWith("00")) {
                    tbtskUserAuditArea.setLevel((short) 2);
                } else {
                    if(s.length() == 6){
                        tbtskUserAuditArea.setLevel((short) 3);
                    }else if(s.length() == 9){
                        tbtskUserAuditArea.setLevel((short) 4);
                    }else if(s.length() == 12){
                        tbtskUserAuditArea.setLevel((short) 5);
                    }
                }*/
                tbtskUserAuditArea.setLevel(regionService.getRegionLevel(s, version).shortValue());
                tbtskUserAuditArea.setRegionCode(s);
                tbtskUserAuditArea.setTaskId(taskId);
                tbtskUserAuditArea.setUserId(userId);
                tbtskUserAuditAreaMapper.insertSelective(tbtskUserAuditArea);
            }
        }
        return tempRegionList.size();
    }

    @Override
    public int delByTaskIdAndUserId(String taskId, String userId, String regions) {
        List<String> tempRegionList = Arrays.asList(regions.split(","));
        for(String s:tempRegionList) {
            List<TbtskUserAuditArea> list = tbtskUserAuditAreaMapper.queryByTaskIdAndUserIdAndRegioncode(taskId, userId, s);
            list.forEach(a -> tbtskUserAuditAreaMapper.deleteByPrimaryKey(a.getId()));
        }
        return tempRegionList.size();
    }

    @Override
    public List<TbtskUserAuditArea> listAuditAreas(String taskId, String userId, Short level) {
        return tbtskUserAuditAreaMapper.listAuditAreas(taskId, userId, level);
    }

    @Override
    public List<TbtskUserAuditArea> listAuditAreas(String taskId, String userId) {
        return tbtskUserAuditAreaMapper.queryByTaskIdAndUserId(taskId, userId);
    }

    @Override
    public List<TbtskUserAuditArea> queryListByTaskId(String taskId) {
        return tbtskUserAuditAreaMapper.queryListByTaskId(taskId);
    }

    @Override
    public void copyTaskRoleByUserId(String sourceTaskId, String targetTaskId, List<String> userList) {
        List<TbtskUserAuditArea> list = tbtskUserAuditAreaMapper.queryByTaskIdAndUserIds(sourceTaskId,userList);
        if(!list.isEmpty()){
            for(TbtskUserAuditArea bean : list){
                bean.setId(null);
                bean.setTaskId(targetTaskId);
                List<TbtskUserAuditArea> tbtskUserAuditAreas = tbtskUserAuditAreaMapper .queryByTaskIdAndUserIdAndRegioncode(targetTaskId, bean.getUserId(),bean.getRegionCode());
                if(tbtskUserAuditAreas.isEmpty()){
                    tbtskUserAuditAreaMapper.insertSelective(bean);
                }
            }
        }
    }
}








