package com.geoway.landteam.landcloud.service.customtask.task.impl;


import com.geoway.landteam.customtask.dao.task.TbtskUserManageAreaDao;
import com.geoway.landteam.customtask.mapper.task.TbtskUserManageAreaMapper;
import com.geoway.landteam.customtask.task.entity.TbtskUserManageArea;
import com.geoway.landteam.landcloud.core.servface.region.RegionService;
import com.geoway.landteam.landcloud.servface.customtask.task.MTbtskUserManageAreaService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;

@Service
public class MTbtskUserManageAreaServiceImpl implements MTbtskUserManageAreaService {

    @Autowired
    TbtskUserManageAreaMapper tbtskUserManageAreaMapper;

    @Autowired
    RegionService regionService;

    @Autowired
    TbtskUserManageAreaDao tbtskUserManageAreaDao;
    @Resource
    JdbcTemplate jdbcTemplate;

    @Override
    public int deleteByPrimaryKey(Long id) {
        return tbtskUserManageAreaMapper.deleteByPrimaryKey(id);
    }

    @Override
    public int deleteByTaskIdAndUserId(String taskId, String userId) {
        return tbtskUserManageAreaMapper.deleteByTaskIdAndUserId(taskId,userId);
    }

    @Override
    public int deleteByTaskId(String taskId) {
        return tbtskUserManageAreaMapper.deleteByTaskId(taskId);
    }


    @Override
    public int insert(TbtskUserManageArea record) {
        return tbtskUserManageAreaMapper.insert(record);
    }


    @Override
    public int insertSelective(TbtskUserManageArea record) {
        return tbtskUserManageAreaMapper.insertSelective(record);
    }


    @Override
    public int updateByTaskIdAndUserId(String taskId, String userId, String regions,String  version) {
          List<String> tempRegionList = Arrays.asList(regions.split(","));
           for(String s:tempRegionList){
               List<TbtskUserManageArea> list = tbtskUserManageAreaMapper.queryByTaskIdAndUserIdAndRegioncode(taskId,userId,s);
                if(list.size() <= 0){
                    TbtskUserManageArea tbtskUserManageArea = new TbtskUserManageArea();
                   /* if ("1".equalsIgnoreCase(s)) {
                        tbtskUserManageArea.setLevel((short) 0);
                    } else if (s.endsWith("0000")) {
                        tbtskUserManageArea.setLevel((short) 1);
                    } else if (s.endsWith("00")) {
                        tbtskUserManageArea.setLevel((short) 2);
                    } else {
                        if(s.length() == 6){
                            tbtskUserManageArea.setLevel((short) 3);
                        }else if(s.length() == 9){
                            tbtskUserManageArea.setLevel((short) 4);
                        }else if(s.length() == 12){
                            tbtskUserManageArea.setLevel((short) 5);
                        }
                    }*/
                    tbtskUserManageArea.setLevel(regionService.getRegionLevel(s, version).shortValue());
                    tbtskUserManageArea.setRegioncode(s);
                    tbtskUserManageArea.setTaskId(taskId);
                    tbtskUserManageArea.setUserId(userId);
                    tbtskUserManageAreaMapper.insertSelective(tbtskUserManageArea);
                }
           }
        return tempRegionList.size();
    }

    @Override
    public int delByTaskIdAndUserId(String taskId, String userId, String regions) {
        List<String> tempRegionList = Arrays.asList(regions.split(","));
        for(String s:tempRegionList) {
            List<TbtskUserManageArea> list = tbtskUserManageAreaMapper.queryByTaskIdAndUserIdAndRegioncode(taskId, userId, s);
            list.forEach(a -> tbtskUserManageAreaMapper.deleteByPrimaryKey(a.getId()));
        }
        return tempRegionList.size();
    }


    @Override
    public TbtskUserManageArea selectByPrimaryKey(Long id) {
        return tbtskUserManageAreaMapper.selectByPrimaryKey(id);
    }


    @Override
    public int updateByPrimaryKeySelective(TbtskUserManageArea record) {
        return tbtskUserManageAreaMapper.updateByPrimaryKeySelective(record);
    }


    @Override
    public int updateByPrimaryKey(TbtskUserManageArea record) {
        return tbtskUserManageAreaMapper.updateByPrimaryKey(record);
    }

    @Override
    public List<TbtskUserManageArea> listManageAreas(String taskId, String userId, Short level) {
        return tbtskUserManageAreaMapper.listManageAreas(taskId, userId, level);
    }

    @Override
    public List<TbtskUserManageArea> listManageAreas(String taskId, String userId) {
        TbtskUserManageArea search = new TbtskUserManageArea();
        search.setTaskId(taskId);
        search.setUserId(userId);
        return tbtskUserManageAreaDao.gwSearch(search);
        //return tbtskUserManageAreaMapper.queryByTaskIdAndUserId(taskId, userId);
    }

    @Override
    public Map<String,Object> findManageAreasTree(String taskId,String userId){
        Map<String,Object> res = new HashMap<>();
        Map<String, Object> sheng = new HashMap<>();
        Map<String, Object> shi = new HashMap<>();
        Map<String, Object> xian = new HashMap<>();
        Map<String,Map<String, Object>> shiMap = new HashMap<>();
        Map<String,Map<String, Object>> xianMap = new HashMap<>();
        Map<String,Map<String, Object>>  xiangMap = new HashMap<>();
        res.put("sheng", sheng);
        res.put("shi", shi);
        res.put("xian", xian);
        List<TbtskUserManageArea> ls = listManageAreas(taskId,userId);
        if(ls!=null&&!ls.isEmpty()) {
            Map<String, TbtskUserManageArea> province = new HashMap<>();
            Map<String, TbtskUserManageArea> city = new HashMap<>();
            Map<String, TbtskUserManageArea> county = new HashMap<>();
            Map<String, TbtskUserManageArea> town = new HashMap<>();
            //先遍历获取管辖的最高一级行政区代码
            for (TbtskUserManageArea tbtskUserManageArea : ls) {
                //层级省级
                if (tbtskUserManageArea.getLevel() == 1) {
                    String key = tbtskUserManageArea.getRegioncode().substring(0, 2);
                    province.put(key, tbtskUserManageArea);
                } else if (tbtskUserManageArea.getLevel() == 2) {
                    String key = tbtskUserManageArea.getRegioncode().substring(0, 4);
                    city.put(key, tbtskUserManageArea);
                } else if (tbtskUserManageArea.getLevel() == 3) {
                    String key = tbtskUserManageArea.getRegioncode().substring(0, 6);
                    county.put(key, tbtskUserManageArea);
                }
            }
            List<TbtskUserManageArea> realArea = new ArrayList<>();
            if (!county.isEmpty()) {
                county.keySet().removeIf(key -> {
                    String first = key.substring(0, 2);
                    if (province.containsKey(first)) {
                        return true;
                    }
                    String second = key.substring(0, 4);
                    return city.containsKey(second);
                });
            }
            if (!city.isEmpty()) {
                city.keySet().removeIf(key -> {
                    String first = key.substring(0, 2);
                    return province.containsKey(first);
                });
            }
            sheng.put("130000", "河北省");
            //再根据用户权限最高层级定义组合
            if (!province.isEmpty()) {
                //省级只能是河北省,获取全省数据;
                String cnSql = "select f_xzqdm,f_xzqmc from tb_region r where r.f_level=3 and r.f_xzqdm like '13%'";
                List<Map<String, Object>> cnlist = jdbcTemplate.queryForList(cnSql);
                for (Map<String, Object> temp : cnlist) {
                    String code = temp.get("f_xzqdm").toString();
                    String name = temp.get("f_xzqmc").toString();
                    Map<String,Object> mapT = new HashMap<>();
                    mapT.put("code",code);
                    mapT.put("name",name);
                    xian.put(code, name);
                    xianMap.put(code,mapT);
                }
                xian.put("130000", "全省");
                String citySql = "select f_xzqdm,f_xzqmc from tb_region r where r.f_level=2 and r.f_xzqdm like '13%'";
                List<Map<String, Object>> ctlist = jdbcTemplate.queryForList(citySql);
                for (Map<String, Object> temp : ctlist) {
                    String code = temp.get("f_xzqdm").toString();
                    String name = temp.get("f_xzqmc").toString();
                    shi.put(code, name);
                    xian.put(code, "全" + name);
                    Map<String,Object> mapT = new HashMap<>();
                    mapT.put("code",code);
                    mapT.put("name",name);
                    shiMap.put(code,mapT);
                }
                shi.put("130000", "全省");

                String townSql = "select xzqdm,xzqmc from tb_region_town r where r.xzqdm like '13%'";
                List<Map<String, Object>> townlist = jdbcTemplate.queryForList(townSql);
                for (Map<String, Object> temp : townlist) {
                    String code = temp.get("xzqdm").toString();
                    String name = temp.get("xzqmc").toString();
                    Map<String,Object> mapT = new HashMap<>();
                    mapT.put("code",code);
                    mapT.put("name",name);
                    xiangMap.put(code,mapT);
                }
            } else {
                if (!county.isEmpty()) {
                    List<String> params = new ArrayList<>();
                    List<String> params2 = new ArrayList<>();
                    for (String key : county.keySet()) {
                        String second = key.substring(0, 4) + "00";
                        params.add(second);
                        params2.add(county.get(key).getRegioncode());
                    }
                    String sqlParam2 = "'" + String.join("','", params2) + "'";
                    String sql1 = "select f_xzqdm,f_xzqmc from tb_region r where r.f_level=3 and r.f_xzqdm in (" + sqlParam2 + ")";
                    List<Map<String, Object>> cnlist = jdbcTemplate.queryForList(sql1);
                    for (Map<String, Object> temp : cnlist) {
                        String code = temp.get("f_xzqdm").toString();
                        String name = temp.get("f_xzqmc").toString();
                        xian.put(code, name);
                        Map<String,Object> mapT = new HashMap<>();
                        mapT.put("code",code);
                        mapT.put("name",name);
                        xianMap.put(code,mapT);
                    }
                    String sqlParam = "'" + String.join("','", params) + "'";
                    String sql = "select f_xzqdm,f_xzqmc from tb_region r where r.f_level=2 and r.f_xzqdm in (" + sqlParam + ")";
                    List<Map<String, Object>> ctlist = jdbcTemplate.queryForList(sql);
                    for (Map<String, Object> temp : ctlist) {
                        String code = temp.get("f_xzqdm").toString();
                        String name = temp.get("f_xzqmc").toString();
                        shi.put(code, name);
                        Map<String,Object> mapT = new HashMap<>();
                        mapT.put("code",code);
                        mapT.put("name",name);
                        shiMap.put(code,mapT);
                    }

                    String sql2 = "select xzqdm,xzqmc from tb_region_town r where r.pcode in (" + sqlParam2 + ")";
                    List<Map<String, Object>> townList = jdbcTemplate.queryForList(sql2);
                    for (Map<String, Object> temp : townList) {
                        String code = temp.get("xzqdm").toString();
                        String name = temp.get("xzqmc").toString();
                        Map<String,Object> mapT = new HashMap<>();
                        mapT.put("code",code);
                        mapT.put("name",name);
                        xiangMap.put(code,mapT);
                    }

                }
                if (!city.isEmpty()) {
                    List<String> params = new ArrayList<>();
                    for (String key : city.keySet()) {
                        params.add(city.get(key).getRegioncode());
                    }
                    String sqlParam = "'" + String.join("','", params) + "'";
                    String sql1 = "select f_xzqdm,f_xzqmc from tb_region r where r.f_level=2 and r.f_xzqdm in (" + sqlParam + ")";
                    List<Map<String, Object>> ctlist = jdbcTemplate.queryForList(sql1);
                    for (Map<String, Object> temp : ctlist) {
                        String code = temp.get("f_xzqdm").toString();
                        String name = temp.get("f_xzqmc").toString();
                        shi.put(code, name);
                        xian.put(code, "全" + name);
                        Map<String,Object> mapT = new HashMap<>();
                        mapT.put("code",code);
                        mapT.put("name",name);
                        shiMap.put(code,mapT);
                    }

                    String sql = "select f_xzqdm,f_xzqmc from tb_region r where r.f_level=3 and r.f_pcode in (" + sqlParam + ")";
                    List<Map<String, Object>> cnlist = jdbcTemplate.queryForList(sql);
                    for (Map<String, Object> temp : cnlist) {
                        String code = temp.get("f_xzqdm").toString();
                        String name = temp.get("f_xzqmc").toString();
                        xian.put(code, name);
                        Map<String,Object> mapT = new HashMap<>();
                        mapT.put("code",code);
                        mapT.put("name",name);
                        xianMap.put(code,mapT);
                    }

                    String sql2 = "select xzqdm,xzqmc from tb_region_town r left join tb_region t on r.pcode=t.f_xzqdm and t.f_level=3 " +
                            " where t.f_pcode in (" + sqlParam + ")";
                    List<Map<String, Object>> townList = jdbcTemplate.queryForList(sql2);
                    for (Map<String, Object> temp : townList) {
                        String code = temp.get("xzqdm").toString();
                        String name = temp.get("xzqmc").toString();
                        Map<String,Object> mapT = new HashMap<>();
                        mapT.put("code",code);
                        mapT.put("name",name);
                        xiangMap.put(code,mapT);
                    }
                }
            }
        }
        res.put("cityRegion", new ArrayList<>(shiMap.values()));
        res.put("countyRegion", new ArrayList<>(xianMap.values()));
        res.put("townRegion", new ArrayList<>(xiangMap.values()));
        return res;
    }

    @Override
    public void copyTaskRoleByUserId(String sourceTaskId, String targetTaskId, List<String> userIds) {
        List<TbtskUserManageArea> list = tbtskUserManageAreaMapper.queryByTaskIdAndUserIds(sourceTaskId,userIds);
        if(!list.isEmpty()){
            for (TbtskUserManageArea bean : list){
                bean.setId(null);
                bean.setTaskId(targetTaskId);
                List<TbtskUserManageArea> tbtskUserManageAreas = tbtskUserManageAreaMapper .queryByTaskIdAndUserIdAndRegioncode(targetTaskId,bean.getUserId(),bean.getRegioncode());
                if(tbtskUserManageAreas.isEmpty()){
                    tbtskUserManageAreaMapper.insertSelective(bean);
                }
            }
        }
    }

    @Override
    public List<TbtskUserManageArea> queryListByTaskId(String taskId) {
        return tbtskUserManageAreaMapper.queryListByTaskId(taskId);
    }
}


