package com.geoway.landteam.landcloud.service.customtask.task.impl;


import com.geoway.landteam.customtask.mapper.task.TbtskUserReviewAreaMapper;
import com.geoway.landteam.customtask.task.entity.TbtskUserReviewArea;
import com.geoway.landteam.landcloud.core.servface.region.RegionService;
import com.geoway.landteam.landcloud.servface.customtask.task.MTbtskUserReviewAreaService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.List;

@Service
public class MTbtskUserReviewAreaServiceImpl implements MTbtskUserReviewAreaService {

    @Autowired
    private TbtskUserReviewAreaMapper tbtskUserReviewAreaMapper;

    @Autowired
    private RegionService regionService;

    @Override
    public int deleteByPrimaryKey(Long id) {
        return tbtskUserReviewAreaMapper.deleteByPrimaryKey(id);
    }

    @Override
    public int deleteByTaskIdAndUserId(String taskId,String userId) {
        return tbtskUserReviewAreaMapper.deleteByTaskIdAndUserId(taskId,userId);
    }

    @Override
    public int deleteByTaskId(String taskId) {
        return tbtskUserReviewAreaMapper.deleteByTaskId(taskId);
    }

    @Override
    public int insert(TbtskUserReviewArea record) {
        return tbtskUserReviewAreaMapper.insert(record);
    }


    @Override
    public int insertSelective(TbtskUserReviewArea record) {
        return tbtskUserReviewAreaMapper.insertSelective(record);
    }


    @Override
    public TbtskUserReviewArea selectByPrimaryKey(Long id) {
        return tbtskUserReviewAreaMapper.selectByPrimaryKey(id);
    }


    @Override
    public int updateByPrimaryKeySelective(TbtskUserReviewArea record) {
        return tbtskUserReviewAreaMapper.updateByPrimaryKeySelective(record);
    }


    @Override
    public int updateByPrimaryKey(TbtskUserReviewArea record) {
        return tbtskUserReviewAreaMapper.updateByPrimaryKey(record);
    }

    @Override
    public int updateByTaskIdAndUserId(String taskId, String userId, String regions,String version) {
        List<String> tempRegionList = Arrays.asList(regions.split(","));
        for(String s:tempRegionList){
            List<TbtskUserReviewArea> list = tbtskUserReviewAreaMapper.queryByTaskIdAndUserIdAndRegioncode(taskId,
                    userId,s);
            if(list.size()<=0){
                TbtskUserReviewArea tbtskUserReviewArea = new TbtskUserReviewArea();
               /* if ("1".equalsIgnoreCase(s)) {
                    tbtskUserReviewArea.setLevel((short) 0);
                } else if (s.endsWith("0000")) {
                    tbtskUserReviewArea.setLevel((short) 1);
                } else if (s.endsWith("00")) {
                    tbtskUserReviewArea.setLevel((short) 2);
                } else {
                    if(s.length() == 6){
                        tbtskUserReviewArea.setLevel((short) 3);
                    }else if(s.length() == 9){
                        tbtskUserReviewArea.setLevel((short) 4);
                    }else if(s.length() == 12){
                        tbtskUserReviewArea.setLevel((short) 5);
                    }
                }*/
                tbtskUserReviewArea.setLevel(regionService.getRegionLevel(s, version).shortValue());
                tbtskUserReviewArea.setRegionCode(s);
                tbtskUserReviewArea.setTaskId(taskId);
                tbtskUserReviewArea.setUserId(userId);
                tbtskUserReviewAreaMapper.insertSelective(tbtskUserReviewArea);
            }
        }
        return tempRegionList.size();
    }

    @Override
    public int delByTaskIdAndUserId(String taskId, String userId, String regions) {
        List<String> tempRegionList = Arrays.asList(regions.split(","));
        for(String s:tempRegionList) {
            List<TbtskUserReviewArea> list = tbtskUserReviewAreaMapper.queryByTaskIdAndUserIdAndRegioncode(taskId, userId, s);
            list.forEach(a -> tbtskUserReviewAreaMapper.deleteByPrimaryKey(a.getId()));
        }
        return tempRegionList.size();
    }

    @Override
    public List<TbtskUserReviewArea> listReviewAreas(String taskId, String userId, Short level) {
        return tbtskUserReviewAreaMapper.listReviewAreas(taskId, userId, level);
    }

    @Override
    public List<TbtskUserReviewArea> listReviewAreas(String taskId, String userId) {
        return tbtskUserReviewAreaMapper.queryByTaskIdAndUserId(taskId, userId);
    }

    @Override
    public void copyTaskRoleByUserId(String sourceTaskId, String targetTaskId, List<String> userList) {
        List<TbtskUserReviewArea> list = tbtskUserReviewAreaMapper.queryByTaskIdAndUserIds(sourceTaskId,userList);
        if(!list.isEmpty()){
            for (TbtskUserReviewArea bean : list){
                bean.setId(null);
                bean.setTaskId(targetTaskId);
                List<TbtskUserReviewArea> tbtskUserReviewAreas = tbtskUserReviewAreaMapper .queryByTaskIdAndUserIdAndRegioncode(targetTaskId,bean.getUserId(),bean.getRegionCode());
                if(tbtskUserReviewAreas.isEmpty()){
                    tbtskUserReviewAreaMapper.insertSelective(bean);
                }
            }
        }
    }

    @Override
    public List<TbtskUserReviewArea> queryListByTaskId(String taskId) {
        return tbtskUserReviewAreaMapper.queryListByTaskId(taskId);
    }
}



