package com.geoway.landteam.landcloud.service.customtask.task.impl;


import com.geoway.landteam.customtask.mapper.task.TbtskUserUploadAreaMapper;
import com.geoway.landteam.customtask.task.entity.TbtskUserUploadArea;
import com.geoway.landteam.landcloud.core.servface.region.RegionService;
import com.geoway.landteam.landcloud.servface.customtask.task.MTbtskUserUploadAreaService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.List;

@Service
public class MTbtskUserUploadAreaServiceImpl implements MTbtskUserUploadAreaService {

    @Autowired
    TbtskUserUploadAreaMapper tbtskUserUploadAreaMapper;

    @Autowired
    RegionService regionService;


    @Override
    public int deleteByPrimaryKey(Long id) {
        return tbtskUserUploadAreaMapper.deleteByPrimaryKey(id);
    }

    @Override
    public int deleteByTaskIdAndUserId(String taskId, String userId) {
        return tbtskUserUploadAreaMapper.deleteByTaskIdAndUserId(taskId,userId);
    }

    @Override
    public int deleteByTaskId(String taskId) {
        return tbtskUserUploadAreaMapper.deleteByTaskId(taskId);
    }


    @Override
    public int insert(TbtskUserUploadArea record) {
        return tbtskUserUploadAreaMapper.insert(record);
    }


    @Override
    public int insertSelective(TbtskUserUploadArea record) {
        return tbtskUserUploadAreaMapper.insertSelective(record);
    }


    @Override
    public int updateByTaskIdAndUserId(String taskId, String userId, String regions,String  version) {
          List<String> tempRegionList = Arrays.asList(regions.split(","));
           for(String s:tempRegionList){
               List<TbtskUserUploadArea> list = tbtskUserUploadAreaMapper.queryByTaskIdAndUserIdAndRegioncode(taskId,userId,s);
                if(list.size() <= 0){
                    TbtskUserUploadArea TbtskUserUploadArea = new TbtskUserUploadArea();
                   /* if ("1".equalsIgnoreCase(s)) {
                        TbtskUserUploadArea.setLevel((short) 0);
                    } else if (s.endsWith("0000")) {
                        TbtskUserUploadArea.setLevel((short) 1);
                    } else if (s.endsWith("00")) {
                        TbtskUserUploadArea.setLevel((short) 2);
                    } else {
                        if(s.length() == 6){
                            TbtskUserUploadArea.setLevel((short) 3);
                        }else if(s.length() == 9){
                            TbtskUserUploadArea.setLevel((short) 4);
                        }else if(s.length() == 12){
                            TbtskUserUploadArea.setLevel((short) 5);
                        }
                    }*/
                    TbtskUserUploadArea.setLevel(regionService.getRegionLevel(s, version).shortValue());
                    TbtskUserUploadArea.setRegioncode(s);
                    TbtskUserUploadArea.setTaskId(taskId);
                    TbtskUserUploadArea.setUserId(userId);
                    tbtskUserUploadAreaMapper.insertSelective(TbtskUserUploadArea);
                }
           }
        return tempRegionList.size();
    }

    @Override
    public int delByTaskIdAndUserId(String taskId, String userId, String regions) {
        List<String> tempRegionList = Arrays.asList(regions.split(","));
        for(String s:tempRegionList) {
            List<TbtskUserUploadArea> list = tbtskUserUploadAreaMapper.queryByTaskIdAndUserIdAndRegioncode(taskId, userId, s);
            list.forEach(a -> tbtskUserUploadAreaMapper.deleteByPrimaryKey(a.getId()));
        }
        return tempRegionList.size();
    }


    @Override
    public TbtskUserUploadArea selectByPrimaryKey(Long id) {
        return tbtskUserUploadAreaMapper.selectByPrimaryKey(id);
    }


    @Override
    public int updateByPrimaryKeySelective(TbtskUserUploadArea record) {
        return tbtskUserUploadAreaMapper.updateByPrimaryKeySelective(record);
    }


    @Override
    public int updateByPrimaryKey(TbtskUserUploadArea record) {
        return tbtskUserUploadAreaMapper.updateByPrimaryKey(record);
    }

    @Override
    public List<TbtskUserUploadArea> listManageAreas(String taskId, String userId, Short level) {
        return tbtskUserUploadAreaMapper.listManageAreas(taskId, userId, level);
    }

    @Override
    public List<TbtskUserUploadArea> listManageAreas(String taskId, String userId) {
        return tbtskUserUploadAreaMapper.queryByTaskIdAndUserId(taskId, userId);
    }

    @Override
    public void copyTaskRoleByUserId(String sourceTaskId, String targetTaskId, List<String> userIds) {
        List<TbtskUserUploadArea> list = tbtskUserUploadAreaMapper.queryByTaskIdAndUserIds(sourceTaskId,userIds);
        if(!list.isEmpty()){
            for (TbtskUserUploadArea bean : list){
                bean.setId(null);
                bean.setTaskId(targetTaskId);
                List<TbtskUserUploadArea> TbtskUserUploadAreas = tbtskUserUploadAreaMapper .queryByTaskIdAndUserIdAndRegioncode(targetTaskId,bean.getUserId(),bean.getRegioncode());
                if(TbtskUserUploadAreas.isEmpty()){
                    tbtskUserUploadAreaMapper.insertSelective(bean);
                }
            }
        }
    }

    @Override
    public List<TbtskUserUploadArea> queryListByTaskId(String taskId) {
        return tbtskUserUploadAreaMapper.queryListByTaskId(taskId);
    }
}


