package com.geoway.landteam.landcloud.service.customtask.task.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.pub.entity.TaskTransformData;
import com.geoway.landteam.customtask.pub.entity.TaskTransformMedia;
import com.geoway.landteam.customtask.servface.task.ITaskAssignService;
import com.geoway.landteam.customtask.servface.task.TaskTransMediaService;
import com.geoway.landteam.customtask.task.entity.TbtskFields;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskAssignRecord;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.common.constant.CommonConstants;
import com.geoway.landteam.landcloud.common.dto.BaseObjectResponse;
import com.geoway.landteam.landcloud.core.model.pub.entity.Organization2User;
import com.geoway.landteam.landcloud.core.repository.pub.Organization2UserRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandUserRepository;
import com.geoway.landteam.landcloud.core.repository.user.WorkGroupMemberRepository;
import com.geoway.landteam.landcloud.core.servface.user.LandRegUserService;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.servface.customtask.task.MTaskTransformService;
import com.geoway.landteam.landcloud.service.customtask.task.*;
import com.gw.base.Gw;
import com.gw.base.log.GwLoger;
import com.gw.base.log.GiLoger;
import com.geoway.landteam.landcloud.common.util.base.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.UncategorizedSQLException;
import org.springframework.stereotype.Service;

import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletRequest;
import java.util.*;


//import  JSONObject;

/**
 * @Author: zhenkaining
 * @Date: 2019/11/20 14:30
 * @Description:
 */
@Service
public class MtaskTransDailyTaskImpl implements MTaskTransformService {
    @Autowired
    ITaskAssignService taskAssignService;

    protected String uploadDir;

    @Autowired
    WorkGroupMemberRepository workGroupMemberRepository;
    @Autowired
    MTskTaskBizService tskTaskBizService;
    @Autowired
    MDataBizService dataBizService;
    @Autowired
    MTbtskObjectinfoService tbtskObjectinfoService;
    @Autowired
    MTbtskFieldsService tbtskFieldsService;
    @Autowired
    MTaskTransMediaService taskTransMediaService;
    @Autowired
    LandUserRepository landUserRepository;
    @Autowired
    DefaultOssOperatorService ossOperatorService;
    @Autowired
    MTaskNoticeService taskNoticeService;
   /* @Autowired
    ThreadPoolTaskExecutor threadPoolTaskExecutor;*/
    @Autowired
   LandRegUserService landRegUserService;
    @Autowired
    Organization2UserRepository organization2UserDao;
    private final GiLoger logger = GwLoger.getLoger(MtaskTransDailyTaskImpl.class);


    @Override
    public boolean checkData(List<TaskTransformData> tbDataList, Map<String, List<String>> errorInfo) {
        return true;
    }

    @Override
    public BaseObjectResponse transform(HttpServletRequest request, long userId, String sourceTaskCode, String sourceTaskName, String targetTaskCode, String targetTaskName, List<TaskTransformData> tbDataList, String xzqdm) {
        BaseObjectResponse baseResponse = new BaseObjectResponse();
        try {
            String token = request.getSession().getAttribute("access_token").toString();

            Map<String, List<String>> errorInfo = new HashMap<>();
            if (checkData(tbDataList, errorInfo)) {
                if (tbDataList != null && tbDataList.size() > 0) {
                    TskTaskBiz targetTaskBiz = tskTaskBizService.findByTaskId(targetTaskCode);
                    TbtskObjectinfo targetObjinfo = null;
                    List<TbtskFields> targetFields = null;
                    String geofield = "f_shape";

                    if (targetTaskBiz != null && StringUtils.isNotBlank(targetTaskBiz.getTableId())) {
                        targetObjinfo = tbtskObjectinfoService.getObjectbyID(targetTaskBiz.getTableId());
                    }
                    if (targetObjinfo != null && StringUtils.isNotBlank(targetObjinfo.getfTablename())) {
                        targetFields = tbtskFieldsService.getAllFieldsByTables(targetObjinfo.getfTablename());
                    }
                    if (targetFields != null && targetFields.size() > 0) {
                        // 需要下发的图斑id的集合
                        List<String> needAssignTbIdList = new ArrayList<>();
                        for (TaskTransformData tbData : tbDataList) {
                            Map<String, Object> valueMap = new HashMap<>();
                            String uuid = UUID.randomUUID().toString();
                            String tbId = "";
                            // 判断数据库中是否 存在相同id的记录
                            //int existedCount=dataBizService.getCount(targetObjinfo.getfTablename(), "f_id " + "= '" + tbData.getTbId() + "'");
                            //tbId=existedCount>0?uuid:tbData.getTbId();
                            tbId = uuid;
                            valueMap.put("f_id", tbId);
                            valueMap.put("f_status", 1);
                            valueMap.put("f_createtime", System.currentTimeMillis());
                            valueMap.put("f_ismycreate", 0);
                            valueMap.put("f_requestid", "");
                            valueMap.put("f_tbmc", tbData.getTbName());
                            valueMap.put(geofield, tbData.getExtent());
                            valueMap.put("f_tbmj", tbData.getTbmj());
                            valueMap.put("f_tbbh", UUID.randomUUID().toString());
                            valueMap.put("f_userid", userId);
                            valueMap.put("f_sign", "");
                            valueMap.put("f_lon", 0);
                            valueMap.put("f_lat", 0);
                            valueMap.put("f_shape1", tbData.getExtent());

                            for (TbtskFields field : targetFields) {
                                // 给不为空的字段填默认值
                                if (field.getfNullable() == 0 && !valueMap.containsKey(field.getfFieldname())) {
                                    if (StringUtils.isNotBlank(field.getfDefaultvalue())) {
                                        valueMap.put(field.getfFieldname(), field.getfDefaultvalue());
                                    } else {
                                        if (field.getfFieldtype().equalsIgnoreCase("int4")) {
                                            valueMap.put(field.getfFieldname(), 0);
                                        } else if (field.getfFieldtype().equalsIgnoreCase("varchar")) {
                                            valueMap.put(field.getfFieldname(), "");
                                        } else if (field.getfFieldtype().equalsIgnoreCase("text")) {
                                            valueMap.put(field.getfFieldname(), "");
                                        } else if (field.getfFieldtype().equalsIgnoreCase("decimal")) {
                                            valueMap.put(field.getfFieldname(), 0);
                                        } else if (field.getfFieldtype().equalsIgnoreCase("Character")) {
                                            valueMap.put(field.getfFieldname(), "");
                                        } else if (field.getfFieldtype().equalsIgnoreCase("geometry")) {
                                            valueMap.put(field.getfFieldname(), tbData.getExtent());

                                        }
                                    }
                                }
                            }

                            JSONArray jsonArray = tbData.getMedias();
                            if (jsonArray != null && jsonArray.size() > 0) {
                                List<TaskTransformMedia> mediaList = new ArrayList<>();
                                for (Object obj : jsonArray) {
                                     JSONObject jsonObject =  JSONObject.parseObject(JSONObject.toJSONString(obj));
                                    if (jsonObject != null) {
                                        TaskTransformMedia media =  Gw.beans.getBean(TaskTransMediaService.class).convertTaskTransMediaFromJson(jsonObject);
                                        media.setAttachId(UUID.randomUUID().toString());
                                        mediaList.add(media);
                                    }
                                }
                                taskTransMediaService.saveAttach(userId, tbId, tbData.getExtent(), mediaList, token);
                            }
                            dataBizService.insertData(targetObjinfo.getfTablename(), valueMap, geofield);

                            try {
                                //更新中心点坐标
                                Map<String, Object> updateMap = new HashMap<>();
                                String updateSql = "f_lon = st_x(st_centroid(f_shape)),f_lat = st_y(st_centroid(f_shape))";
                                dataBizService.updateBySql(targetObjinfo.getfTablename(), updateSql, "f_id ='" + tbId + "'");
                            } catch (Exception e) {
                                logger.error(e);
                                throw new RuntimeException(e);
                            }
                            needAssignTbIdList.add(tbId);
                        }
                        // 下发任务
                        assignCurrentTaskData(needAssignTbIdList, userId, targetTaskCode);
                    }
                }
                baseResponse.setStatus(CommonConstants.RESPONSE_STATUS_OK);
                baseResponse.setMessage("转换成功!");
            } else {
                StringBuilder sb = new StringBuilder();
                if (!errorInfo.isEmpty()) {
                    for (String key : errorInfo.keySet()) {
                        sb.append(errorInfo.get(key));
                        sb.append(";");
                    }
                }
                baseResponse.setStatus(CommonConstants.RESPONSE_STATUS_FAILURE);
                baseResponse.setMessage(sb.toString());
            }
        } catch (UncategorizedSQLException ue) {
            ue.printStackTrace();
            logger.error(ue);
            baseResponse.setStatus(CommonConstants.RESPONSE_STATUS_FAILURE);
            baseResponse.setMessage("转换失败，数据类型不匹配");
        } catch (Exception e) {
            e.printStackTrace();
            logger.error(e);
            baseResponse.setStatus(CommonConstants.RESPONSE_STATUS_FAILURE);
            baseResponse.setMessage(e.getMessage());
        }

        return baseResponse;
    }

    /**
     * 下发当前任务数据
     *
     * @param tbIdList
     * @param userId
     * @param taskId
     */
    private void assignCurrentTaskData(List<String> tbIdList, long userId, String taskId) {
        JSONArray tbIds = new JSONArray();
        JSONArray userIds = new JSONArray();
        JSONObject org = new JSONObject();
        JSONArray groups = new JSONArray();
        JSONArray orgs = new JSONArray();

        userIds.add(userId);
        org.put("userids", userIds);

        List<Organization2User> organization2Users = organization2UserDao.queryByUserId(userId);
        if (organization2Users != null && organization2Users.size() > 0) {
            org.put("orgid", organization2Users.get(0).getOrganizationId());
        }
        orgs.add(org);

        if (tbIdList != null && tbIdList.size() > 0) {
            for (String tbid : tbIdList) {
                TskAssignRecord record = tskTaskBizService.getRecordByTaskIdAndExecutorId(tbid, userId);
                if (record != null) {
                } else {
                    tbIds.add(tbid);
                }
            }
        }
        taskAssignService.assignTask(userId, taskId, tbIds, groups, orgs);
    }

}
