package com.geoway.landteam.landcloud.service.customtask.task.impl;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.landcloud.common.util.PhoneUtil;
import com.geoway.landteam.landcloud.common.util.geometry.WKTUtil;
import com.geoway.landteam.landcloud.core.model.base.entity.AppMedia;
import com.geoway.landteam.landcloud.core.model.user.entity.LandUser;
import com.geoway.landteam.landcloud.core.repository.base.AppMediaRepository;
import com.geoway.landteam.landcloud.core.repository.user.LandUserRepository;
import com.geoway.landteam.landcloud.core.servface.region.RegionService;
import com.geoway.landteam.landcloud.model.pub.entity.TbScheduleRecord;
import com.geoway.landteam.landcloud.model.pub.entity.TbScheduleTarget;
import com.geoway.landteam.landcloud.repository.pub.TbScheduleRecordRepository;
import com.geoway.landteam.landcloud.repository.pub.TbScheduleTargetRepository;
import com.geoway.landteam.landcloud.servface.customtask.task.TbScheduleRecordService;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

/**
 * @author : tuowei
 * @date : 2023/12/9 21:03
 * @description : TODO
 */
@Service
public class TbScheduleRecordServiceImpl implements TbScheduleRecordService {

    @Autowired
    private TbScheduleRecordRepository tbScheduleRecordRepository;
    @Autowired
    private TbScheduleTargetRepository tbScheduleTargetRepository;
    @Autowired
    private AppMediaRepository appMediaRepository;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    LandUserRepository landUserRepository;
    @Autowired
    RegionService regionService;

    @Override
    public List<TbScheduleRecord> getScheduleRecordList(String type, String content, Date startTime, Date endTime) {
        if(StringUtils.isNotBlank(type)) {
            if(Objects.nonNull(startTime) && Objects.nonNull(endTime)) {
                return tbScheduleRecordRepository.getScheduleRecordList(type, content, startTime, endTime);
            } else if(Objects.nonNull(startTime)) {
                return tbScheduleRecordRepository.getScheduleRecordList(type, content, startTime);
            } else {
                return tbScheduleRecordRepository.getScheduleRecordList(type, content);
            }
        } else {
            if(Objects.nonNull(startTime) && Objects.nonNull(endTime)) {
                return tbScheduleRecordRepository.getScheduleRecordList(content, startTime, endTime);
            } else if(Objects.nonNull(startTime)) {
                return tbScheduleRecordRepository.getScheduleRecordList(content, startTime);
            } else {
                return tbScheduleRecordRepository.getScheduleRecordList(content);
            }
        }

    }



    @Override
    public String startScheduleRecord(String type, String deviceType, Long userId, String taskId,
                                       String tbId, String tbbh,  String tbLocation, String receiver) {
        TbScheduleRecord tbScheduleRecord = new TbScheduleRecord();
        String fId = UUID.randomUUID().toString();
        tbScheduleRecord.setFId(fId);
        tbScheduleRecord.setFType(type);
        // 获取外业照片
        if("1".equals(type)){
            // 默认挂接外业附件照片
            List<AppMedia> appMedia = appMediaRepository.queryByGid(tbId);
            if(appMedia == null || CollectionUtils.isEmpty(appMedia)) {
                // 给与默认照片
//                tbScheduleRecord.setFLogo("该图斑没有附件，请提供默认照片");
                tbScheduleRecord.setFLogo("https://obs-cq-public.obs.cn-north-4.myhuaweicloud.com/picture/%E6%8C%87%E6%8C%A5%E8%B0%83%E5%BA%A6-%E8%B0%83%E5%BA%A6%E5%8A%A8%E6%80%81%E9%BB%98%E8%AE%A4%E5%9B%BE%E7%89%87.jpg");
            } else {
                tbScheduleRecord.setFLogo(appMedia.get(0).getServerpath());
            }
        } else {
            tbScheduleRecord.setFLogo("https://obs-cq-public.obs.cn-north-4.myhuaweicloud.com/picture/%E6%8C%87%E6%8C%A5%E8%B0%83%E5%BA%A6-%E8%B0%83%E5%BA%A6%E5%8A%A8%E6%80%81%E9%BB%98%E8%AE%A4%E5%9B%BE%E7%89%87.jpg");
        }
        LandUser landUser = landUserRepository.queryUserById(userId);
        tbScheduleRecord.setFSender(landUser.getName());
        tbScheduleRecord.setFReceiver(receiver);
        if("1".equals(deviceType)) {
            // TODO  视频互联则根据用户ID查用户名,  这里业务目前是单用户，后期支持多用户了，则用逗号切割
//            String userName = "接收人用户名";
            tbScheduleRecord.setFReceiverUserId(receiver);
        }
        String name = "";
        if(StringUtils.isNotBlank(tbLocation)) {
            name = regionService.getName(tbLocation);
            if(StringUtils.isBlank(name)) {
                String substring = tbLocation.substring(0, 9);
                name = regionService.getName(substring);
            }
            if(StringUtils.isBlank(name)) {
                String substring = tbLocation.substring(0, 6);
                name = regionService.getName(substring);
            }
            if(StringUtils.isBlank(name)) {
                name = "重庆市";
            }
        } else {
            name = "重庆市";
        }
        tbScheduleRecord.setFStartTime(new Timestamp(new Date().getTime()));
        tbScheduleRecord.setFDeviceType(deviceType);
        tbScheduleRecord.setFStatus("1");
        tbScheduleRecord.setFSendUserId(userId.toString());
        tbScheduleRecordRepository.save(tbScheduleRecord);
        TbScheduleTarget tbScheduleTarget = new TbScheduleTarget();
        tbScheduleTarget.setFId(UUID.randomUUID().toString());
        tbScheduleTarget.setFType(type);
        tbScheduleTarget.setFLinkid(fId);
        tbScheduleTarget.setFTaskId(taskId);
        tbScheduleTarget.setFTbid(tbId);
        tbScheduleTarget.setFLocation(name);
        tbScheduleTarget.setFTbbh(tbbh);
        tbScheduleTarget.setFCreateTime(new Timestamp(new Date().getTime()));
        tbScheduleTargetRepository.save(tbScheduleTarget);
        return tbScheduleRecord.getFId();
    }


    @Override
    public boolean endScheduleRecord(String scheduleId, String channelId, String state, String receiver) {
        TbScheduleRecord tbScheduleRecord = tbScheduleRecordRepository.findById(scheduleId).get();
        String  deviceType = tbScheduleRecord.getFDeviceType();
        if("1".equals(deviceType)) {
            if(StringUtils.isBlank(tbScheduleRecord.getFReceiver())) {
                tbScheduleRecord.setFReceiver(receiver);
            }
        }
        tbScheduleRecord.setFChannelId(channelId);
        tbScheduleRecord.setFState(state);
        tbScheduleRecord.setFEndTime(new Timestamp(new Date().getTime()));
        tbScheduleRecord.setFStatus("2");
        tbScheduleRecordRepository.save(tbScheduleRecord);
        return true;
    }

    /**
     * radius 是缓冲范围， 单位是米
     * @param wkt
     * @param radius
     * @param page
     * @param rows
     * @param filter
     * @param type
     * @return
     * @throws ParseException
     */
    @Override
    public Map<String, Object> getNearUserList(String wkt, Integer radius,int page,int rows,String filter,String type) throws ParseException {
            Geometry geo = WKTUtil.wktToGeom(wkt);
            double degree = radius * 0.0000089992800575;
            Geometry geometry = geo.buffer(degree);
            Calendar beforeTime = Calendar.getInstance();
            beforeTime.add(Calendar.MINUTE, -5);//5分钟的时间
            Date beforeD = beforeTime.getTime();
            SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String before = sf.format(beforeD);
            //查询在线且在附近的人
            String sql = "with tem  as(\n" +
                    "SELECT max(f_updatetime) f_updatetime,f_userid FROM tb_devicetrack where f_updatetime > '" + before + "' group by f_userid\n" +
                    ")\n" +
                    " select u.f_userid userId,u.f_username userName,u.f_rname rname,u.f_phonemobile phone, de.f_lon lon,de.f_lat lat, ty.f_accid as accid, ty.f_token  as token " +
                    " from tb_devicetrack de " +
                    " inner join tbsys_user u on de.f_userid = u.f_userid  " +
                    " inner join tem on  tem.f_userid = u.f_userid  " +
                    " inner join tb_yxuser2 ty on u.f_userid = ty.f_id " +
                    " where de.f_updatetime = tem.f_updatetime " +
                    " and st_contains(st_geometryfromtext('" + WKTUtil.geomToWkt(geometry) + "'),\n" +
                    " st_geometryfromtext('POINT('||de.f_lon||' '||de.f_lat||')' ))";
            String countsql = "with tem  as(\n" +
                    "SELECT max(f_updatetime) f_updatetime,f_userid FROM tb_devicetrack where f_updatetime > '" + before + "' group by f_userid\n" +
                    ")\n" +
                    "select count(1) " +
                    " from tb_devicetrack de " +
                    " inner join tbsys_user u on de.f_userid = u.f_userid  " +
                    " inner join tem on  tem.f_userid = u.f_userid  " +
                    " inner join tb_yxuser2 ty on u.f_userid = ty.f_id " +
                    " where de.f_updatetime = tem.f_updatetime " +
                    "and st_contains(st_geometryfromtext('" + WKTUtil.geomToWkt(geometry) + "'),\n" +
                    "st_geometryfromtext('POINT('||de.f_lon||' '||de.f_lat||')' ))";
            sql += " limit "+ rows +" offset "+ (page-1)*rows;
            List<Map<String, Object>> userList = jdbcTemplate.queryForList(sql);
            Long userCount = jdbcTemplate.queryForObject(countsql,Long.class);
            for (Map<String, Object> map : userList) {
                //隐藏手机号
//                map.put("phone", map.get("phone") != null ? PhoneUtil.hidePhone4(map.get("phone").toString()) : null);
                map.put("phone", map.get("phone") != null ? map.get("phone").toString() : null);
            }
            Map<String, Object> map = new HashMap<>();
            map.put("userList", userList);
            map.put("userCount",userCount);
            return map;
    }


    public Map<String, Object> getNearDroneList(String wkt, Integer radius,int page,int rows,String filter,String type) throws ParseException {
        Geometry geo = WKTUtil.wktToGeom(wkt);
        double degree = radius * 0.0000089992800575;
        Geometry geometry = geo.buffer(degree);
        Calendar beforeTime = Calendar.getInstance();
        beforeTime.add(Calendar.MINUTE, -5);//10分钟之前的时间
        Date beforeD = beforeTime.getTime();
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String before = sf.format(beforeD);
        //查询在线且在附近的无人机
        String sql = "with tem as(\n" +
                "\tselect t.* from (\n" +
                "\t\tselect tdd.*, row_number() over (partition by tdd.f_sn order by tdd.f_updatetime desc) " +
                " from tb_drone_devicetrack tdd where tdd.f_updatetime > '"+before+"'\n" +
                "\t) t where t.row_number = 1) " +
                "select * from tb_drone_live_channel tdlc \n" +
                "inner join tem on tdlc.f_sn = tem.f_sn \n" +
                "where st_contains(st_geometryfromtext('" + WKTUtil.geomToWkt(geometry) + "'),  " +
                "st_geometryfromtext('POINT('|| tem.f_lon ||' '|| tem.f_lat ||')' ))";
        String countsql = "with tem as(\n" +
                "\tselect t.* from (\n" +
                "\t\tselect tdd.*, row_number() over (partition by tdd.f_sn order by tdd.f_updatetime desc) " +
                " from tb_drone_devicetrack tdd where tdd.f_updatetime > '"+before+"'\n" +
                "\t) t where t.row_number = 1) " +
                "select count(*) from tb_drone_live_channel tdlc \n" +
                "inner join tem on tdlc.f_sn = tem.f_sn \n" +
                "where st_contains(st_geometryfromtext('" + WKTUtil.geomToWkt(geometry) + "'),  " +
                "st_geometryfromtext('POINT('|| tem.f_lon ||' '|| tem.f_lat ||')' ))";
        sql += " limit "+ rows +" offset "+ (page-1)*rows;
        List<Map<String, Object>> userList = jdbcTemplate.queryForList(sql);
        Long userCount = jdbcTemplate.queryForObject(countsql,Long.class);
        Map<String, Object> map = new HashMap<>();
        map.put("userList", userList);
        map.put("userCount",userCount);
        return map;
    }

    @Override
    public List<TbScheduleTarget> getScheduleTargetList(String type, String taskId, String tbId) {
        List<TbScheduleTarget> all = tbScheduleTargetRepository.getScheduleTargetList(type, taskId, tbId);
        for (TbScheduleTarget tbScheduleTarget : all) {
            TbScheduleRecord tbScheduleRecord = tbScheduleRecordRepository.findById(tbScheduleTarget.getFLinkid()).get();
            tbScheduleTarget.setFScheduleSender(tbScheduleRecord.getFSender());
            tbScheduleTarget.setFScheduleReceiver(tbScheduleRecord.getFReceiver());
        }
        return all;
    }

    @Override
    public List<TbScheduleRecord> getScheduleRecordByChannelId(String channelId) {
        return tbScheduleRecordRepository.findByChannelId(channelId);
    }

    /**
     * 获取最近的摄像头
     * @param wkt
     * @param radius
     * @param page
     * @param rows
     * @param filter
     * @param type
     * @return
     * @throws ParseException
     */
//    public Map<String, Object> getNearDeviceList(String wkt, Integer radius,int page,int rows,String filter,String type) throws ParseException {
//        Geometry geo = WKTUtil.wktToGeom(wkt);
//        //几公里外扩
//        if (radius > 3) {
//            throw new RuntimeException("范围过大请缩小范围查询");
//        }
//        double degree = radius * 0.0000089992800575;
//        Geometry geometry = geo.buffer(degree);
//        Calendar beforeTime = Calendar.getInstance();
//        beforeTime.add(Calendar.MINUTE, -10);//10分钟之前的时间
//        Date beforeD = beforeTime.getTime();
//        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
//        String before = sf.format(beforeD);
//        //type  0 全部  1人员过滤  2设备过滤
//        //查询在线且在附近的人
//        //查询附近的设备
//        String sql1 = "SELECT\n" +
////                "\td.f_device_code AS devicecode,\n" +
////                "\tf_device_name devicename,\n" +
////                "\tf_regioncode regioncode,\n" +
////                "\tf_regionname regionname,\n" +
////                "\tf_location \"location\",\n" +
////                "\td.f_longitude AS f_longitude,\n" +
////                "\td.f_latitude AS f_latitude,\n" +
////                "\tC.f_channel_code \n" +
//                " d.f_device_code AS devicecode,\n" +
//                "\tf_device_name devicename,\n" +
//                "\tf_regioncode regioncode,\n" +
//                "\tf_regionname regionname,\n" +
//                "\tf_location \"location\",\n" +
//                "\tC.f_channel_code as channelCode,\n" +
//                "\tC.f_channel_status as status,\n" +
//                "\td.f_height as height,\n" +
//                "\td.f_longitude,\n" +
//                "\td.f_latitude " +
//                "FROM\n" +
//                "\ttb_ttdevice d,\n" +
//                "\ttb_ttchannel C \n" +
//                "WHERE\n" +
//                "\td.f_device_code = C.f_device_code \n" +
//                "\tAND st_contains ( ( st_geometryfromtext ( '" + WKTUtil.geomToWkt(geometry) + "' ) ), st_geometryfromtext ( 'POINT(' || d.f_longitude || ' ' || d.f_latitude || ')' ) )";
//        String countsql1 = "SELECT\n" +
//                "\tcount(1)\n" +
//                "FROM\n" +
//                "\ttb_ttdevice d,\n" +
//                "\ttb_ttchannel C \n" +
//                "WHERE\n" +
//                "\td.f_device_code = C.f_device_code \n" +
//                "\tAND st_contains ( ( st_geometryfromtext ( '" + WKTUtil.geomToWkt(geometry) + "' ) ), st_geometryfromtext ( 'POINT(' || d.f_longitude || ' ' || d.f_latitude || ')' ) )";
//        if(type.equals("0")){
//            if(StringUtils.isNotBlank(filter)) {
//                sql1 += " and (d.f_device_code like '%" + filter + "%' or d.f_device_name like '" + filter + "')";
//                countsql1 += "and (d.f_device_code like '%" + filter + "%' or d.f_device_name like '" + filter + "')";
//            }
//        }else if(type.equals("1")){
//
//        }else if(type.equals("2")){
//            if(StringUtils.isNotBlank(filter)) {
//                //设备过滤
//                sql1 += " and (d.f_device_code like '%" + filter + "%' or d.f_device_name like '" + filter + "')";
//                countsql1 += "and (d.f_device_code like '%" + filter + "%' or d.f_device_name like '" + filter + "')";
//            }
//        }
//        sql1 += " limit "+ rows +" offset "+ (page-1)*rows;
//        List<Map<String, Object>> deviceList = jdbcTemplate.queryForList(sql1);
//        Long deviceCount = jdbcTemplate.queryForObject(countsql1,Long.class);
//        Map<String, Object> map = new HashMap<>();
//
//        for (Map<String, Object> stringObjectMap : deviceList) {
//            String devicecode = stringObjectMap.get("devicecode").toString();
//            String channelCode = stringObjectMap.get("channelCode").toString();
//            if(StringUtils.isNotBlank(devicecode) && StringUtils.isNotBlank(channelCode)){
//                JSONObject object2 = new JSONObject();
//                object2.put("streamType",2);
//                object2.put("protocolType",4);
//                object2.put("netType",1);
//                object2.put("deviceCode",devicecode);
//                object2.put("channelCode",channelCode);
//                JSONObject result =  getVideoRealtimeUrl(object2);
//                stringObjectMap.put("url", result.getJSONObject("data") != null ? result.getJSONObject("data").getString("streamUrl") : null);
//            }
//            String f_longitude = stringObjectMap.get("f_longitude").toString();
//            String f_latitude = stringObjectMap.get("f_latitude").toString();
//            stringObjectMap.put("lonlat", f_longitude + "," + f_latitude);
//        }
//        map.put("deviceCount",deviceCount);
//        map.put("deviceList", deviceList);
//        return map;
//    }


}
