package com.geoway.landteam.landcloud.service.customtask.taskTranslate.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

import com.geoway.landteam.customtask.servface.task.TskTaskBizService;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.customtask.taskTranslate.dto.SpatialIntersectOptionDto;
import com.geoway.landteam.customtask.taskTranslate.dto.TaskRelationAtalsResultDto;
import com.geoway.landteam.customtask.taskTranslate.dto.TaskRelationAtlasDTO;
import com.geoway.landteam.customtask.taskTranslate.dto.TaskTranslateAtlasDTO;
import com.geoway.landteam.customtask.taskTranslate.entity.*;
import com.geoway.landteam.landcloud.common.util.bean.BeanUtil;

import com.geoway.landteam.landcloud.common.util.RequestUtil;
import com.geoway.landteam.landcloud.common.util.http.HttpUtil;
import com.geoway.landteam.landcloud.core.model.base.entity.AppMedia;
import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.geoway.landteam.landcloud.core.servface.base.AppMediaService;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.servface.base.SysConfigService;
import com.geoway.landteam.landcloud.servface.customtask.taskTranslate.*;
import com.geoway.landteam.landcloud.service.customtask.task.MDataBizService;
import com.geoway.landteam.landcloud.service.customtask.task.MTbtskObjectinfoService;
 import cn.hutool.core.collection.ListUtil;
import com.gw.base.log.GwLoger;
import com.gw.base.log.GiLoger;

import com.gw.base.util.GutilAssert;
import com.gw.base.util.GutilCollection;
import org.apache.commons.collections4.MapUtils;
import com.geoway.landteam.landcloud.common.util.base.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author ZhenKaining
 * @date 2021年04月25日 18:17
 */

@Service
public class MTaskTranslateAtlasServiceImpl implements MTaskTranslateAtlasService {
    private static final GiLoger log= GwLoger.getLoger();
    private static final int BATCH_COUNT = 50;
    @Autowired
    TskTaskBizService taskBizService;
    @Autowired
    MTbtskObjectinfoService tbtskObjectinfoService;

    @Autowired
    MTbTaskTranslateTemplateService taskTranslateTemplateService;

    @Autowired
    MTbTaskTranslateFieldService taskTranslateFieldService;

    @Autowired
    MTbTaskTranslateAttachService taskTranslateAttachService;

    @Autowired
    MTbTaskTranslateTaskService tbTaskTranslateTaskService;

    @Autowired
    MDataBizService dataBizService;

    @Autowired
    SysConfigService sysConfigService;

    @Autowired
    AppMediaService appMediaService;
    @Autowired
    DefaultOssOperatorService ossOperatorService;

    @Autowired
    JdbcTemplate jdbcTemplate;

    @Override
    public Boolean setRelationTemplate(String templateId,String taskId,String atlasId)
    {
       TbTaskTranslateTask task =  tbTaskTranslateTaskService.select(atlasId);
       TaskRelationAtlasDTO dto= JSONObject.parseObject(task.getParam(), TaskRelationAtlasDTO.class);
       if(dto.getOptions()!=null)
       {
          Optional optional =  dto.getOptions().stream().filter(t->t.getTaskId().equals(taskId)).findFirst();
          if(optional.isPresent())
          {
             SpatialIntersectOptionDto op =  (SpatialIntersectOptionDto)optional.get() ;
             op.setTemplateId(templateId);
             String param = JSONObject.toJSONString(dto);
              tbTaskTranslateTaskService.updateParam(task.getId(),param);
              return true;
          }
       }
       return false;
    }

    @Override
    public String getRelationTemplate(String taskId,String atlasId)
    {
        TbTaskTranslateTask task =  tbTaskTranslateTaskService.select(atlasId);
        TaskRelationAtlasDTO dto= JSONObject.parseObject(task.getParam(), TaskRelationAtlasDTO.class);
        if(dto.getOptions()!=null)
        {
            Optional optional =  dto.getOptions().stream().filter(t->t.getTaskId().equals(taskId)).findFirst();
            if(optional.isPresent())
            {
                SpatialIntersectOptionDto op =  (SpatialIntersectOptionDto)optional.get() ;
                return op.getTemplateId();
            }
        }
        return null;
    }

    @Override
    public Map createRelationAtlasTask(TaskRelationAtlasDTO dto, long userId) {
        GutilAssert.notNull(dto, "parameter 'dto' must not be null .");
        Map retVal = new HashMap();
        retVal.put("result", false);
        retVal.put("data", "");
        retVal.put("error", StringUtils.EMPTY);

        try {
            if (StringUtils.isEmpty(dto.getTargetTaskId())) {
                retVal.put("error", "转换任务id为空。");
                return retVal;
            }

            TskTaskBiz targetTaskBiz = taskBizService.findByTaskId(dto.getTargetTaskId());
            if(targetTaskBiz==null)
            {
                retVal.put("error", "转换任务不存在。");
                return retVal;
            }
            TbtskObjectinfo targetTableInfo = tbtskObjectinfoService.getObjectByTableId(targetTaskBiz.getTableId());
            if(targetTableInfo==null)
            {
                retVal.put("error", "转换任务数据表不存在。");
                return retVal;
            }
            String tableName = targetTableInfo.getfTablename();
            if(StringUtils.isBlank(tableName))
            {
                retVal.put("error", "转换任务数据表名为空。");
                return retVal;
            }
            /*            if(dataBizService.getCount(tableName,"")==0)
            {
                retVal.put("error", "转换任务数据表为空表。");
                return retVal;
            }*/
            if(dto.getTransMode()==null||(dto.getTransMode()!=1&&dto.getTransMode()!=2))
            {
                retVal.put("error", "转换任务模式未知【1为空间叠加转换，2唯一值转换】");
                return retVal;
            }
            if (dto.getSourceTaskIds()==null|| dto.getSourceTaskIds().isEmpty()) {
                retVal.put("error", "转换任务源数据为空。");
                return retVal;
            }
            if(StringUtils.isBlank(dto.getTargetPrimaryField()))
            {
                dto.setTargetPrimaryField("f_id");
            }
            if(StringUtils.isBlank(dto.getTargetShapeField()))
            {
                dto.setTargetShapeField("f_shape");
            }
            if(dto.getTargetWhereClause()==null)
            {
                dto.setTargetWhereClause("");
            }
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date time = new Date();
            String createTime = df.format(time);
            String name="任务转换-"+targetTaskBiz.getName()+"-"+createTime;
            String desc="任务转换-"+targetTaskBiz.getName();
            Integer priority =100;
            String userName =String.valueOf(userId);
            String primaryField = dto.getTargetPrimaryField();
            String shapeField = dto.getTargetShapeField();
            String whereClause = dto.getTargetWhereClause();


            int splitCount  = (dto.getSplitCount()==null|| dto.getSplitCount()<=0)?500:dto.getSplitCount();
            dto.setSplitCount(splitCount);
            double areaRate =(dto.getAreaRate()==null|| dto.getAreaRate()<=0||dto.getAreaRate()>=1)?0.9:dto.getSplitCount();
            dto.setAreaRate(areaRate);
            List<SpatialIntersectOptionDto> layerInfos = new ArrayList<>();
            for (String id:dto.getSourceTaskIds()) {
                TskTaskBiz sourceTaskBiz = taskBizService.findByTaskId(id);
                if (sourceTaskBiz == null) {
                    retVal.put("error", "转换源任务" + id + "不存在。");
                    return retVal;
                }
                TbtskObjectinfo sourceTableInfo = tbtskObjectinfoService.getObjectByTableId(sourceTaskBiz.getTableId());
                if (sourceTableInfo == null) {
                    retVal.put("error", "转换源任务" + id + "数据表不存在。");
                    return retVal;
                }

                String layer = sourceTableInfo.getfTablename();
                String where = "";
                String primary = "f_id";
                String shape = "f_shape";
                String intersectName = "intersect_" + UUID.randomUUID().toString().replace("-", "");

                SpatialIntersectOptionDto option = new SpatialIntersectOptionDto();
                option.setLayerName(layer);
                option.setPrimaryField(primary);
                option.setShapeField(shape);
                option.setWhereClause(where);
                option.setIntersectName(intersectName);
                option.setTaskId(id);
                option.setTaskName(sourceTaskBiz.getName());
                layerInfos.add(option);
            }
            String pathClassPath =Thread.currentThread().getContextClassLoader().getResource("").getPath();
            String pathRoot ="";
            try {
                pathRoot = pathClassPath.substring(0, pathClassPath.indexOf("WEB-INF"));
            }
            catch (Exception ex)
            {
                log.error(ex.getMessage(), ex);
                retVal.put("error", "获取关联任务模板json文件失败。");
                return retVal;
            }
            String jsonFile = new StringBuilder()
                    .append(pathRoot)
                    .append("data")
                    .append(File.separator)
                    .append("taskRelationAtlas.json")
                    .toString();

            File file = new File(jsonFile);
            if(!file.exists())
            {
                log.error("关联任务模板json不存在："+jsonFile);
                retVal.put("error", "关联任务模板json文件不存在。");
                return retVal;
            }
            String jsonStr = readFile(file);
            JSONObject jsonObject = JSONObject.parseObject(jsonStr);
            jsonObject.put("Name",name);
            jsonObject.put("Desc",desc);
            jsonObject.put("CreateTime",createTime);
            jsonObject.put("Priority",priority);
            jsonObject.put("UserName",userName);
            JSONArray jsonArray = jsonObject.getJSONArray("JobsList");
            for(int i=0;i<jsonArray.size();i++) {
                JSONObject job = jsonArray.getJSONObject(i);
                String jobName = job.getString("Name");
                JSONArray params=  job.getJSONArray("ParamsList");
                if (jobName.startsWith("数据关联模型"))
                {
                  for(int j=0;j<params.size();j++) {
                      JSONObject param = params.getJSONObject(j);
                      String paramName = param.getString("Name");
                      switch (paramName)
                      {
                          case "LayerName":
                              param.put("ValueString",tableName);
                              break;
                          case "PrimaryField":
                              param.put("ValueString",primaryField);
                              break;
                          case "ShapeField":
                              param.put("ValueString",shapeField);
                              break;
                          case "WhereClause":
                              param.put("ValueString",whereClause);
                              break;
                          case "LayerInfos":
                              param.put("ValueString",JSONArray.toJSONString(layerInfos));
                              break;
                          case "TransMode":
                              param.put("ValueString",dto.getTransMode());
                              break;
                          case "SplitCount":
                              param.put("ValueString",splitCount);
                              break;
                          case "Rate":
                              param.put("ValueString",areaRate);
                              break;
                      }
                  }
                }
            }
            SysConfig config =  sysConfigService.findOne("atlas-url");
            if(config==null)
            {
                retVal.put("error", "未配置atlas计算框架地址。");
                return retVal;
            }
            String data = HttpUtil.JsonPostInvoke(config.getValue()+"/atlas/task/create","taskdata=["+jsonObject.toJSONString()+"]");
            JSONObject dataJons = JSONObject.parseObject(data);
            if("true".equals(dataJons.getString("flag")))
            {
                String atlasId = dataJons.getString("taskid");
                dto.setOptions(layerInfos);
                TbTaskTranslateTask task = new TbTaskTranslateTask();
                task.setName(targetTaskBiz.getName()+"-匹配任务");
                task.setId(atlasId);
                task.setTaskId(dto.getTargetTaskId());
                task.setCreateTime(new Date());
                task.setRelationCount(0);
                task.setRelationingCount(0);
                task.setStatus(Short.valueOf("0"));
                task.setParam(JSONObject.toJSONString(dto));
                task.setUseingCount(0);
                task.setUseCount(0);
                task.setIsUsed(Short.valueOf("0"));
                task.setUserId(String.valueOf(userId));
                tbTaskTranslateTaskService.insert(task);
                retVal.put("result", true);
                retVal.put("data", atlasId);
            }
            else
            {
                retVal.put("result", false);
                retVal.put("data", dataJons.getString("msg"));
            }
        } catch (Exception e) {
            retVal.put("error", e.getMessage());
        }
        return retVal;
    }

    @Override
    public Map startTask(String id) {
        Map retVal = new HashMap();
        retVal.put("result", false);
        retVal.put("data", "");
        retVal.put("error", StringUtils.EMPTY);
        SysConfig config =  sysConfigService.findOne("atlas-url");
        if(config==null)
        {
            retVal.put("error", "未配置atlas计算框架地址。");
            return retVal;
        }
        List<NameValuePair>params = new ArrayList<>();
        BasicNameValuePair param = new BasicNameValuePair("id",id);
        params.add(param);
        try {

            JSONObject json = RequestUtil.sendHttpRequest(null, config.getValue(), "/atlas/task/start", null, params, false);
            if(json!=null) {
                if ("true".equals(json.getString("flag")))
                {
                    tbTaskTranslateTaskService.update(id,1,new Date());
                    retVal.put("result",true);
                    retVal.put("data","任务启动成功");
                }
                else {
                    tbTaskTranslateTaskService.update(id,-1,new Date());
                    retVal.put("error","任务启动失败");

                    }
            }
        }
        catch (Exception ex)
        {
            log.error(ex.getMessage(),ex);
            retVal.put("error","启动任务失败");
        }
        return retVal;
    }

    @Override
    public Map progressTask(String id) {
        Map retVal = new HashMap();
        retVal.put("result", false);
        retVal.put("data", "");
        retVal.put("error", StringUtils.EMPTY);
        SysConfig config =  sysConfigService.findOne("atlas-url");
        if(config==null)
        {
            retVal.put("error", "未配置atlas计算框架地址。");
            return retVal;
        }
        List<NameValuePair>params = new ArrayList<>();
        BasicNameValuePair param = new BasicNameValuePair("id",id);
        params.add(param);
        try {
            JSONObject json = RequestUtil.sendHttpRequest(null, config.getValue(), "/atlas/task/get", null, params, false);
            if(json!=null) {
                if ("true".equals(json.getString("IsSucceed")))
                {
                    retVal.put("result",true);
                    retVal.put("data",json.getIntValue("Progress"));
                }
                else {
                    retVal.put("error","任务执行失败");
                }
            }
            /*
            JSONObject json = RequestUtil.sendHttpRequest(null, config.getValue(), "/atlas/task/progress", null, params, false);
            if(json!=null) {
                if ("true".equals(json.getString("flag")))
                {
                    retVal.put("result",true);
                    retVal.put("data",json.getIntValue("progress"));
                }
                else {
                    retVal.put("error","获取任务进度失败");
                }
            }*/
        }
        catch (Exception ex)
        {
            log.error(ex.getMessage(),ex);
            retVal.put("error","获取任务进度失败");
        }
        return retVal;
    }

    @Override
    public Map finishedTask(String id) {
        Map retVal = new HashMap();
        retVal.put("result", false);
        retVal.put("data", "");
        retVal.put("error", StringUtils.EMPTY);
        SysConfig config =  sysConfigService.findOne("atlas-url");
        if(config==null)
        {
            retVal.put("error", "未配置atlas计算框架地址。");
            return retVal;
        }
        List<NameValuePair>params = new ArrayList<>();
        BasicNameValuePair param = new BasicNameValuePair("id",id);
        params.add(param);
        try {
            JSONObject json = RequestUtil.sendHttpRequest(null, config.getValue(), "/atlas/task/get", null, params, false);
            if(json!=null) {
                if ("true".equals(json.getString("IsSucceed")))
                {
                    retVal.put("result",true);
                    retVal.put("data",json.getIntValue("Progress")==100);
                }
                else {
                    retVal.put("error","任务执行失败");
                }
            }
            /*
            JSONObject json = RequestUtil.sendHttpRequest(null, config.getValue(), "/atlas/task/progress", null, params, false);
            if(json!=null) {
                if ("true".equals(json.getString("flag")))
                {
                    retVal.put("result",true);
                    retVal.put("data",json.getIntValue("progress"));
                }
                else {
                    retVal.put("error","获取任务进度失败");
                }
            }*/
        }
        catch (Exception ex)
        {
            log.error(ex.getMessage(),ex);
            retVal.put("error","获取任务进度失败");
        }
        return retVal;
    }

    @Override
    public Map createTranslateAtlasTask(TaskTranslateAtlasDTO dto, long userId) {
        Map retVal = new HashMap();
        retVal.put("result", false);
        retVal.put("data", "");
        retVal.put("error", StringUtils.EMPTY);
        TaskTranslateLog taskTranslateLog = null;
        try {
            String checkResult = checkBeforeTranslate(dto);
            if (StringUtils.isNotBlank(checkResult)) {
                retVal.put("error",checkResult);
                return  retVal;

            } else {

                //int totalCount = dto.getTasks().stream().mapToInt(t -> t.getTbIds().size()).sum();

                tbTaskTranslateTaskService.updateUseCount(dto.getId(),dto.getTotalCount());
                tbTaskTranslateTaskService.updateUseingCount(dto.getId(),0);
                int useingCount = 0;
                for (TaskTranslateAtlasDTO.TranslateRecord recort:dto.getTasks()) {
                    TbTaskTranslateTemplate translateTemplate = taskTranslateTemplateService.findOneById(recort.getTemplateId());
                    List<TbTaskTranslateField> taskTranslateFields = taskTranslateFieldService.queryFieldsByTemplateId(translateTemplate.getId());
                    List<TbTaskTranslateAttach> taskTranslateAttaches = taskTranslateAttachService.queryAttachsByTemplateId(translateTemplate.getId());

                    Map<String, String> translateFieldMapping = new HashMap<>(taskTranslateFields.size());
                    for (TbTaskTranslateField field : taskTranslateFields) {
                        translateFieldMapping.put(field.getFieldName(), field.getSourceFieldName());
                    }

                    TskTaskBiz targetTaskBiz = taskBizService.findByTaskId(recort.getTaskId());
                    TbtskObjectinfo targetTableInfo = tbtskObjectinfoService.getObjectByTableId(targetTaskBiz.getTableId());
                    if (targetTableInfo != null) {
                        String relationName = getRelation(recort.getTemplateId(),recort.getTaskId(),dto.getId());
                        if(StringUtils.isBlank(relationName))
                        {
                            retVal.put("error","关联结果表名为空");
                            return  retVal;
                        }
                        if(!dataBizService.isExistTableName(relationName))
                        {
                            retVal.put("error","关联结果表不存在");
                            return  retVal;
                        }


                        List<String> fieldNameList = taskTranslateFields.stream().map(TbTaskTranslateField::getFieldName).collect(Collectors.toList());
                        fieldNameList.add("f_key1");
                        fieldNameList.add("f_key2");
                        int pageCount = recort.getTbIds().size() / BATCH_COUNT + 1;
                        List<Map> pageData = null;
                        Map<String,List<String>>tbIdMap = new HashMap<>();
                        if (translateTemplate.getTranslateType().intValue() == 1) {
                            //TODO 转换字段
                            for (int i = 0; i < pageCount; i++) {
                                int startIndex = i*BATCH_COUNT;
                                int endIndex = (i+1)*BATCH_COUNT;
                                if(endIndex>=recort.getTbIds().size())
                                {
                                    endIndex = recort.getTbIds().size();
                                }
                                List<String>ids = recort.getTbIds().subList(startIndex,endIndex);
                                String where ="f_id in ('" +StringUtils.join(ids,"','")+"')";
                                pageData = new ArrayList<>(BATCH_COUNT);
                                pageData = dataBizService.queryAllData(relationName, fieldNameList,where);

                                translateAndSaveTbData(pageData, translateFieldMapping, tbIdMap,
                                        targetTableInfo.getfTablename());
                                useingCount+=ids.size();
                                tbTaskTranslateTaskService.updateUseingCount(dto.getId(),useingCount);
                            }
                        } else if (translateTemplate.getTranslateType().intValue() == 3) {
                            //TODO 转换附件
                            for (int i = 0; i < pageCount; i++) {
                                int startIndex = i*BATCH_COUNT;
                                int endIndex = (i+1)*BATCH_COUNT;
                                if(endIndex>=recort.getTbIds().size())
                                {
                                    endIndex = recort.getTbIds().size();
                                }
                                List<String>ids = recort.getTbIds().subList(startIndex,endIndex);
                                String where ="f_id in ('" +StringUtils.join(ids,"','")+"')";
                                List<String>fields =   ListUtil.toList("f_key2","f_key1");
                                pageData = new ArrayList<>(BATCH_COUNT);
                                pageData = dataBizService.queryAllData(relationName, fields,where);
                                //转换附件
                                for (Map  map:pageData) {
                                    String key1 = map.get("f_key1").toString();
                                    String key2 = map.get("f_key2").toString();
                                    if(tbIdMap.containsKey(key2))
                                    {
                                        tbIdMap.get(key2).add(key1);
                                    }
                                    else
                                    {
                                        List<String>keys = new ArrayList<>();
                                        keys.add(key1);
                                        tbIdMap.put(key2,keys);
                                    }
                                }
                                List<String> tbIds =  pageData.stream().map(m -> m.get("f_key2").toString()).collect(Collectors.toList());
                                List<AppMedia> appMediaList = appMediaService.queryByGalleryids(tbIds);

                                translateAndSaveAttachData(appMediaList, tbIdMap, taskTranslateAttaches,userId);
                                useingCount+=ids.size();
                                tbTaskTranslateTaskService.updateUseingCount(dto.getId(),useingCount);
                            }
                        } else if (translateTemplate.getTranslateType().intValue() == 2) {
                            //TODO 转换图斑及附件
                            for (int i = 0; i < pageCount; i++) {
                                int startIndex = i*BATCH_COUNT;
                                int endIndex = (i+1)*BATCH_COUNT;
                                if(endIndex>=recort.getTbIds().size())
                                {
                                    endIndex = recort.getTbIds().size();
                                }
                                List<String>ids = recort.getTbIds().subList(startIndex,endIndex);
                                String where ="f_id in ('" +StringUtils.join(ids,"','")+"')";
                                pageData = new ArrayList<>(BATCH_COUNT);
                                pageData = dataBizService.queryAllData(relationName, fieldNameList,where);
                                translateAndSaveTbData(pageData, translateFieldMapping, tbIdMap,
                                        targetTableInfo.getfTablename());

                                //转换附件
                                List<String> tbIds =  pageData.stream().map(m -> m.get("f_key2").toString()).collect(Collectors.toList());
                                List<AppMedia> appMediaList = appMediaService.queryByGalleryids(tbIds);

                                translateAndSaveAttachData(appMediaList, tbIdMap, taskTranslateAttaches,userId);
                                useingCount+=ids.size();
                                tbTaskTranslateTaskService.updateUseingCount(dto.getId(),useingCount);
                            }
                        }
                    }
                }
                tbTaskTranslateTaskService.setUse(dto.getId());
            }

        } catch (Exception e) {
            log.error(e.getMessage(), e);
            retVal.put("error","复用失败");
            return  retVal;
        }
        retVal.put("result",true);
        return retVal;
    }

    @Override
    public Map list(String taskId,Integer top, long userId)
    {
        List<TbTaskTranslateTask>tasks = null;

        tasks = tbTaskTranslateTaskService.queryLatestNWithoutParam(taskId, top, String.valueOf(userId));
        for (TbTaskTranslateTask task:tasks) {
            if(task.getStatus()==1)
            {
               Map map =  finishedTask(task.getId());
                if (MapUtils.getBoolean(map, "result")) {
                    if (MapUtils.getBoolean(map, "data"))
                    {
                        task.setStatus(Short.valueOf("2"));
                        tbTaskTranslateTaskService.updateStatus(task.getId(),2);
                    }
                }
                else {
                        task.setStatus(Short.valueOf("-2"));
                        tbTaskTranslateTaskService.updateStatus(task.getId(),-2);
                    }


            }
        }
        Map retVal = new HashMap();
        retVal.put("result", true);
        retVal.put("data", tasks);
        retVal.put("error", StringUtils.EMPTY);
        return retVal;
    }

     @Override
     public List<TbTaskTranslateTask>getDelete()
     {
         return tbTaskTranslateTaskService.getDelete();
     }

    @Override
    public List<TbTaskTranslateTask>getDeleteByShard(int total, int index)
    {
        return tbTaskTranslateTaskService.getDeleteByShard(total, index);
    }

    @Override
    public TbTaskTranslateTask find(String id)
    {
        TbTaskTranslateTask task = tbTaskTranslateTaskService.selectSimple(id);
        if(task.getStatus()==1)
        {
            Map map =  finishedTask(task.getId());
            if (MapUtils.getBoolean(map, "result")) {
                if (MapUtils.getBoolean(map, "data"))
                {
                    task.setStatus(Short.valueOf("2"));
                    tbTaskTranslateTaskService.updateStatus(task.getId(),2);
                }
            }
            else {
                task.setStatus(Short.valueOf("-2"));
                tbTaskTranslateTaskService.updateStatus(task.getId(),-2);
            }
        }
        return task;
    }

    @Override
    public Boolean delete(String id) {
         tbTaskTranslateTaskService.setDelete(id);
         return true;
    }

    @Override
    public Boolean deleteWholeTask(TbTaskTranslateTask task)
    {

        TaskRelationAtlasDTO dto= JSONObject.parseObject(task.getParam(), TaskRelationAtlasDTO.class);
        if(dto.getOptions()!=null)
        {
            for (SpatialIntersectOptionDto op:dto.getOptions()) {
               String intersect=  op.getIntersectName();
               if(dataBizService.isExistTableName(intersect))
               {
                   String sql="drop table "+intersect;
                   jdbcTemplate.execute(sql);
               }

            }
        }
        String sql="delete from tb_task_translate_tbid where f_atlasid = '"+task.getId()+"'";
        jdbcTemplate.execute(sql);
        tbTaskTranslateTaskService.delete(task.getId());
        return true;
    }

    @Override
    public Map detialRelationAtlasTask(String id) {
        Map retVal = new HashMap();
        retVal.put("result", true);
        retVal.put("data", "");
        retVal.put("error", StringUtils.EMPTY);
        List<TaskRelationAtalsResultDto>results = new ArrayList<>();

        TbTaskTranslateTask task = tbTaskTranslateTaskService.select(id);
        String param = task.getParam();
        TaskRelationAtlasDTO dto = JSONObject.parseObject(param, TaskRelationAtlasDTO.class);
        List<SpatialIntersectOptionDto>options = dto.getOptions();
        for (SpatialIntersectOptionDto item :options) {
            TaskRelationAtalsResultDto result = new TaskRelationAtalsResultDto();
            result.setId(id);
            result.setTaskId1(task.getTaskId());
            result.setTaskName1(task.getName().replace("-匹配任务",""));
            result.setTaskId2(item.getTaskId());
            result.setTaskName2(item.getTaskName());
            result.setTransMode(dto.getTransMode());
            result.setTemplateId(item.getTemplateId());
            if(dataBizService.isExistTableName(item.getIntersectName())) {
                Integer count = dataBizService.getCount(item.getIntersectName(), "");
                result.setCount(count);
            }
            results.add(result);
        }
        retVal.put("data",results);
        return retVal;
    }

    @Override
    public Map detialTaskRelationAtlasTask(String id,String taskId,int pageSize,int page)
    {
        Map retVal = new HashMap();
        retVal.put("result", true);
        retVal.put("data", "");
        retVal.put("error", StringUtils.EMPTY);
        List<TaskRelationAtalsResultDto>results = new ArrayList<>();

        TbTaskTranslateTask task = tbTaskTranslateTaskService.select(id);
        String param = task.getParam();
        TaskRelationAtlasDTO dto = JSONObject.parseObject(param, TaskRelationAtlasDTO.class);
        List<SpatialIntersectOptionDto>options = dto.getOptions();
        Optional optional= options.stream().filter(t->t.getTaskId().equals(taskId)).findFirst();
        if(optional.isPresent())
        {
            SpatialIntersectOptionDto option =  (SpatialIntersectOptionDto)optional.get();
            List<String>fields =   ListUtil.toList("f_id","f_key1", "f_key2","f_unique1", "f_unique2","f_rate1","f_rate2");
            List<Map> maps = dataBizService.queryPageData(option.getIntersectName(),fields,pageSize,page,"");

            JSONObject json = new JSONObject();
            json.put("id",id);
            json.put("taskId1",task.getTaskId());
            json.put("taskId2",option.getTaskId());
            json.put("taskName1",task.getName().replace("-匹配任务",""));
            json.put("taskName2",option.getTaskName());
            json.put("page",maps);
            retVal.put("data", json);
        }
        else
        {
            retVal.put("result", false);
            retVal.put("data", "");
            retVal.put("error", "未找到任务信息");
        }

        return retVal;
    }

    private  String readFile(File file) throws Exception {
        if(file.exists()) {
            FileInputStream fileInputStream = new FileInputStream(file);
            String encode = "utf-8";
            InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream, encode);
            BufferedReader reader = new BufferedReader(inputStreamReader);
            String result = "";
            String text = null;
            while ((text = reader.readLine()) != null) {
                text = text.trim();
                if (StringUtils.isNotBlank(text)) {
                    result += text;
                }
            }
            return result;
        }
        return "";
    }

    private String checkBeforeTranslate(TaskTranslateAtlasDTO dto) {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isEmpty(dto.getId())) {
            sb.append(" 待转换ID不能为空。 ");
            return sb.toString();
        }
        if(dto.getTasks()==null||dto.getTasks().isEmpty())
        {
            sb.append(" 待转换任务集合为空。");
            return sb.toString();
        }
        TbTaskTranslateTask task =  tbTaskTranslateTaskService.select(dto.getId());
        TaskRelationAtlasDTO relaton= JSONObject.parseObject(task.getParam(), TaskRelationAtlasDTO.class);
        int totalCount=0;
        for (TaskTranslateAtlasDTO.TranslateRecord record:dto.getTasks()) {
            if (StringUtils.isEmpty(record.getTaskId())) {
                sb.append(" 待转换任务ID不能为空。");
                return sb.toString();
            }

            List<String>tbIds = record.getTbIds();
            if(tbIds==null||tbIds.isEmpty())
            {
                sb.append(" 请设置待转换数据。 ");
                return sb.toString();
            }

            if(relaton.getOptions()!=null)
            {
                Optional optional =  relaton.getOptions().stream().filter(t->t.getTaskId().equals(record.getTaskId())).findFirst();
                if(optional.isPresent())
                {
                    SpatialIntersectOptionDto op =  (SpatialIntersectOptionDto)optional.get() ;
                    record.setTemplateId(op.getTemplateId());

                    if(tbIds.size()==1&&tbIds.get(0).equals("all"))
                    {
                        tbIds.clear();
                        List<String>fields = new ArrayList<>();
                        fields.add("f_id");
                        List<Map>maps =   dataBizService.queryAllData(op.getIntersectName(),fields,"1=1");
                        maps.forEach(t->tbIds.add(t.get("f_id").toString()));
                        totalCount+= maps.size();
                    }
                    else
                    {
                        totalCount+=tbIds.size();
                    }

                }
            }
            if (StringUtils.isEmpty(record.getTemplateId())) {
                sb.append(" 请进行匹配设置。 ");
                return sb.toString();
            }
            TskTaskBiz targetTaskBiz = taskBizService.findByTaskId(record.getTaskId());
            if (targetTaskBiz == null) {
                sb.append(" 目标转换任务不存在或已被删除。 ");
                return sb.toString();
            }

            TbTaskTranslateTemplate template = taskTranslateTemplateService.findOneById(record.getTemplateId());
            if (template == null) {
                sb.append(" 任务转换模板不存在或已被删除。 ");
                return sb.toString();
            }

            TskTaskBiz sourceTaskBiz = taskBizService.findByTaskId(template.getSourceTaskId());
            if (sourceTaskBiz == null) {
                sb.append(" 源转换任务不存在或已被删除。 ");
                return sb.toString();
            }

            if (template.getTranslateType().intValue() == 1
                    || template.getTranslateType().intValue() == 3) {

                List<TbTaskTranslateField> taskTranslateFields = taskTranslateFieldService.queryFieldsByTemplateId(template.getId());
                if (GutilCollection.isEmpty(taskTranslateFields)) {
                    sb.append(" 待转换任务字段配置信息不存在或已被删除。 ");
                    return sb.toString();
                }
            }

            if (template.getTranslateType().intValue() == 2
                    || template.getTranslateType().intValue() == 3) {
                List<TbTaskTranslateAttach> taskTranslateAttaches = taskTranslateAttachService.queryAttachsByTemplateId(template.getId());
                if (GutilCollection.isEmpty(taskTranslateAttaches)) {
                    sb.append(" 待转换任务附件配置信息不存在或已被删除。 ");
                    return sb.toString();
                }
            }
        }

        dto.setTotalCount(totalCount);



        return sb.toString();
    }

    private void translateAndSaveTbData(List<Map> sourceData, Map<String, String> filedNameMapping,Map<String,List<String>>tbIdMap,String dataTableName) {
        if (GutilCollection.isEmpty(sourceData)) {
            return;
        }
        for (Map map : sourceData) {
            String sourceId = map.get("f_key2").toString();
            String targetId = map.get("f_key1").toString();
            Map<String, Object> newMap = new HashMap<>();
            for (Object key : map.keySet()) {
                if(filedNameMapping.containsKey(key)) {
                    newMap.put(filedNameMapping.get(key), map.get(key));
                }
            }
            if(tbIdMap.containsKey(sourceId))
            {
                tbIdMap.get(sourceId).add(targetId);
            }
            else
            {
                List<String>ids = new ArrayList<>();
                ids.add(targetId);
                tbIdMap.put(sourceId,ids);
            }
            try {
                int rows = dataBizService.updateData(dataTableName, newMap, "f_id ='"+targetId+"'");

            } catch (Exception e) {
                log.error(e.getMessage(), e);
            }
        }
    }

    private void translateAndSaveAttachData(List<AppMedia> appMediaList, Map<String,List<String>>tbIdMap,
                                            List<TbTaskTranslateAttach> taskTranslateAttaches, Long userId) {
        if (appMediaList != null) {
            for (AppMedia appMedia : appMediaList) {

                try {
                    List<String> targetIds = tbIdMap.get(appMedia.getGalleryid());
                    for (String targetId:targetIds) {
                        AppMedia media = new AppMedia();
                        BeanUtil.copyProperties(appMedia,media,true);
                        String newAttachId = UUID.randomUUID().toString();
                        media.setId(newAttachId);
                        media.setGalleryid(targetId);
                        // 更改分组 分类
                        if (media.getTypetype() != null && taskTranslateAttaches != null) {
                            for (TbTaskTranslateAttach taskTranslateAttach : taskTranslateAttaches) {
                                if (taskTranslateAttach.getSourceTypeName().equals(media.getTypetype().toString())) {
                                    media.setTypetype(Integer.valueOf(taskTranslateAttach.getTargetTypeName()));
                                }
                            }
                        }
                        String url = media.getServerpath();
                        String name = url.substring(url.lastIndexOf('/')+1);
                        String newUrl = "media/"+userId+"/" + targetId+"/"+name;
                        if(!appMediaService.isExist(targetId,newUrl))
                        {
                            String sourceUrl = appMedia.getServerpath();
                            if(sourceUrl.startsWith("https"))
                            {
                                sourceUrl = sourceUrl.replace("https","http");
                            }
                            else if(sourceUrl.startsWith("HTTPS"))
                            {
                                sourceUrl = sourceUrl.replace("HTTPS","http");
                            }
                            else if(sourceUrl.startsWith("HTTP"))
                            {
                                sourceUrl = sourceUrl.replace("HTTP","http");
                            }
                            if(sourceUrl.startsWith("http"))
                            {
                                sourceUrl = sourceUrl.replace("http://","");
                                sourceUrl = sourceUrl.substring(sourceUrl.indexOf('/')+1);
                            }

                            String ossUrl = ossOperatorService.copyObject(sourceUrl, newUrl);
                            if (StringUtils.isNotBlank(ossUrl)) {
                                media.setServerpath(newUrl);
                            }
                            int row = appMediaService.saveOne(media);
                        }
                    }
                } catch (Exception e) {
                    log.error(e.getMessage(), e);
                }
            }
        }
    }

    public String getRelation(String templateId,String taskId,String atlasId)
    {
        TbTaskTranslateTask task =  tbTaskTranslateTaskService.select(atlasId);
        TaskRelationAtlasDTO dto= JSONObject.parseObject(task.getParam(), TaskRelationAtlasDTO.class);
        if(dto.getOptions()!=null)
        {
            Optional optional =  dto.getOptions().stream().filter(t->t.getTaskId().equals(taskId)).findFirst();
            if(optional.isPresent())
            {
                SpatialIntersectOptionDto op =  (SpatialIntersectOptionDto)optional.get() ;
                return  op.getIntersectName();
            }
        }
        return null;
    }
}
