package com.geoway.landteam.landcloud.service.customtask.taskTranslate.impl;


import com.geoway.landteam.customtask.repository.task.TbtskFieldsRepository;
import com.geoway.landteam.customtask.servface.multitask.DataBizService;

import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.customtask.taskTranslate.dto.TaskTranslateDTO;
import com.geoway.landteam.customtask.taskTranslate.entity.*;
import com.geoway.landteam.landcloud.common.util.base.FileUtil;
import com.geoway.landteam.landcloud.core.model.base.enm.ProjectConfigEnum;
import com.geoway.landteam.landcloud.core.model.base.enm.ReviewStageEnum;
import com.geoway.landteam.landcloud.core.model.base.enm.TbStatusEnum;
import com.geoway.landteam.landcloud.core.model.base.entity.AppMedia;
import com.geoway.landteam.landcloud.core.servface.base.AppMediaService;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.pub.impl.ProjectConfig;
import com.geoway.landteam.landcloud.core.servface.user.UserNameService;
import com.geoway.landteam.landcloud.servface.customtask.taskTranslate.*;
import com.geoway.landteam.landcloud.service.customtask.task.MTbtskObjectinfoService;
import com.geoway.landteam.landcloud.service.customtask.task.MTskTaskBizService;
import com.gw.base.log.GwLoger;
import com.gw.base.log.GiLoger;

import com.geoway.landteam.landcloud.common.util.base.StringUtils;
import com.gw.base.util.GutilAssert;
import com.gw.base.util.GutilCollection;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author ZhenKaining
 * @date 2021年04月25日 18:17
 */
@Service
public class MTaskTranslateServiceImpl implements MTaskTranslateService {

	
	private final GiLoger logger = GwLoger.getLoger(MTaskTranslateServiceImpl.class);
	
    private static final int BATCH_COUNT = 50;
    @Autowired
    MTbTaskTranslateRecordService taskTranslateRecordService;
    @Autowired
    MTskTaskBizService taskBizService;
    @Autowired
    MTbtskObjectinfoService tbtskObjectinfoService;
    @Autowired
    TbtskFieldsRepository tbtskFieldsRepository;
    @Autowired
    MTbTaskTranslateTemplateService taskTranslateTemplateService;
    @Autowired
    MTbTaskTranslateFieldService taskTranslateFieldService;
    @Autowired
    MTbTaskTranslateAttachService taskTranslateAttachService;
    @Autowired
    DataBizService dataBizService;
    @Autowired
    AppMediaService appMediaService;
    @Autowired
    DefaultOssOperatorService ossOperatorService;
    @Autowired
    UserNameService userNameService;
    protected String tempDir;

    @Override
    public Map createTranslateRecord(TaskTranslateDTO dto, long userId) {
        GutilAssert.notNull(dto, "parameter 'dto' must not be null .");
        Map retVal = new HashMap();
        retVal.put("result", false);
        retVal.put("data", "");
        retVal.put("error", StringUtils.EMPTY);

        try {
            if (StringUtils.isEmpty(dto.getSourceTaskId())) {
                retVal.put("error", "转换任务id不能为空。");
                return retVal;
            }
            if (StringUtils.isEmpty(dto.getSourceTaskName())) {
                retVal.put("error", "转换任务名称不能为空。");
                return retVal;
            }
            if (StringUtils.isEmpty(dto.getTemplateId())) {
                retVal.put("error", "转换任务模板id不能为空。");
                return retVal;
            }
            if (dto.getTranslateType() == null || (dto.getTranslateType() < 1 || dto.getTranslateType() > 3)) {
                retVal.put("error", "转换任务类型不正确。");
                return retVal;
            }
            if (GutilCollection.isEmpty(dto.getTbIdList())) {
                retVal.put("error", "转换任务图斑数量不能为零。");
                return retVal;
            }
            TbTaskTranslateRecord record = new TbTaskTranslateRecord();
            record.setId(UUID.randomUUID().toString());
            record.setCreateTime(new Date());
            record.setCreateUserId(String.valueOf(userId));
            record.setTaskId(dto.getSourceTaskId());
            record.setTaskName(dto.getSourceTaskName());
            record.setTbCount(dto.getTbIdList().size());
            record.setTemplateId(dto.getTemplateId());
            record.setStatus(Short.valueOf("0"));
            record.setTranslateType(dto.getTranslateType());

            taskTranslateRecordService.insertSelective(record);
            retVal.put("result", true);
            retVal.put("data", record.getId());
        } catch (Exception e) {
            retVal.put("error", e.getMessage());
        }
        return retVal;
    }

    @Override
    public void doTranslate(TbTaskTranslateRecord record) {
        GutilAssert.notNull(record, "parameter 'record' must not be null .");

        TaskTranslateLog taskTranslateLog = null;
        try {
            String checkResult = checkRecordBeforeTranslate(record);
            if (StringUtils.isNotBlank(checkResult)) {
                taskTranslateLog = new TaskTranslateLog();
                taskTranslateLog.setTaskId(StringUtils.isNotBlank(record.getTaskId()) ? record.getTaskId() : "转换记录的任务id为空");
                taskTranslateLog.setTaskName(StringUtils.isNotBlank(record.getTaskName()) ? record.getTaskName() : "转换记录的任务名称为空");
                taskTranslateLog.setTranslateType(record.getTranslateType() != null ? record.getTranslateType() : 0);
                taskTranslateLog.setTranslateUser(userNameService.getUserRealNameByUserId(record.getCreateUserId()));
                taskTranslateLog.setTranslateTime(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
                record.setErrorInfo(checkResult);
                record.setTbSuccessCount(0);
                record.setAttachSuccessCount(0);

            } else {
                taskTranslateLog = new TaskTranslateLog(record.getTaskId(), record.getTaskName(), record.getTranslateType());
                taskTranslateLog.setTranslateUser(userNameService.getUserRealNameByUserId(record.getCreateUserId()));
                taskTranslateLog.setTranslateTime(LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));

                TbTaskTranslateTemplate translateTemplate = taskTranslateTemplateService.findOneById(record.getTemplateId());
                List<TbTaskTranslateField> taskTranslateFields = taskTranslateFieldService.queryFieldsByTemplateId(translateTemplate.getId());
                List<TbTaskTranslateAttach> taskTranslateAttaches = taskTranslateAttachService.queryAttachsByTemplateId(translateTemplate.getId());

                Map<String, String> translateFieldMapping = new HashMap<>(taskTranslateFields.size());
                for (TbTaskTranslateField field : taskTranslateFields) {
                    translateFieldMapping.put(field.getFieldName(), field.getSourceFieldName());
                }

                TskTaskBiz sourceTaskBiz = taskBizService.findByTaskId(record.getTaskId());
                TbtskObjectinfo sourceTableInfo = tbtskObjectinfoService.getObjectByTableId(sourceTaskBiz.getTableId());
                if (sourceTableInfo != null) {
                    TskTaskBiz targetTaskBiz = taskBizService.findByTaskId(translateTemplate.getTargetTaskId());
                    TbtskObjectinfo targetTableInfo = tbtskObjectinfoService.getObjectByTableId(targetTaskBiz.getTableId());
                    int totalCount = dataBizService.getCount(sourceTableInfo.getfTablename(), "");
                    if (totalCount > 0) {
                        record.setTbCount(totalCount);
                        List<String> fieldNameList = taskTranslateFields.stream().map(TbTaskTranslateField::getFieldName).collect(Collectors.toList());
                        fieldNameList.addAll(getSystemFields());
                        int pageCount = totalCount / BATCH_COUNT + 1;
                        List<Map> pageData = null;
                        List<Map<String, Object>> targetInsertDataList = new ArrayList<>(BATCH_COUNT);
                        // 保存图斑id变化前后的映射关系
                        Map<String, String> tbIdChangedMap = new HashMap<>();
                        if (record.getTranslateType().intValue() == 1) {
                            //TODO 转换字段
                            for (int i = 0; i < pageCount; i++) {
                                pageData = new ArrayList<>(BATCH_COUNT);
                                pageData = dataBizService.queryPageData(sourceTableInfo.getfTablename(), fieldNameList,
                                        BATCH_COUNT, i + 1, "");
                                taskTranslateLog.setTbCount(taskTranslateLog.getTbCount() + pageData.size());

                                List<TbTranslateLogItem> tbTranslateLogItems = new ArrayList<>(pageData.size());

                                translateAndSaveTbData(pageData, translateFieldMapping, tbIdChangedMap, tbTranslateLogItems,
                                        targetTableInfo.getfTablename());

                                if (!GutilCollection.isEmpty(tbTranslateLogItems)) {
                                    taskTranslateLog.getTbTaskTranslateLogItems().addAll(tbTranslateLogItems);
                                }
                                taskTranslateLog.setTbSuccessCount(taskTranslateLog.getTbSuccessCount() +
                                        (int) (tbTranslateLogItems.stream().filter(t -> t.isTransSuccess()).count()));

                            }
                        } else if (record.getTranslateType().intValue() == 2) {
                            //TODO 转换附件
                            //taskTranslateLog.setAttachCount(taskTranslateLog.getAttachCount()+appMediaList.size());

                        } else if (record.getTranslateType().intValue() == 3) {
                            for (int i = 0; i < pageCount; i++) {
                                //转换字段
                                pageData = new ArrayList<>(BATCH_COUNT);
                                pageData = dataBizService.queryPageData(sourceTableInfo.getfTablename(), fieldNameList, BATCH_COUNT, i, "");

                                taskTranslateLog.setTbCount(taskTranslateLog.getTbCount() + pageData.size());

                                List<TbTranslateLogItem> tbTranslateLogItems = new ArrayList<>(pageData.size());

                                translateAndSaveTbData(pageData, translateFieldMapping, tbIdChangedMap, tbTranslateLogItems, targetTableInfo.getfTablename());

                                if (!GutilCollection.isEmpty(tbTranslateLogItems)) {
                                    taskTranslateLog.getTbTaskTranslateLogItems().addAll(tbTranslateLogItems);
                                }
                                //转换附件
                                List<String> tbIds = pageData.stream().map(m -> m.get("f_id").toString()).collect(Collectors.toList());
                                List<AppMedia> appMediaList = appMediaService.queryByGalleryids(tbIds);
                                taskTranslateLog.setAttachCount(taskTranslateLog.getAttachCount() + appMediaList.size());

                                List<AttachTranslateLogItem> attachTranslateLogItems = new ArrayList<>();
                                translateAndSaveAttachData(appMediaList, tbIdChangedMap, taskTranslateAttaches, attachTranslateLogItems);
                                if (!GutilCollection.isEmpty(attachTranslateLogItems)) {
                                    taskTranslateLog.getAttachTranslateLogItems().addAll(attachTranslateLogItems);

                                    taskTranslateLog.setAttachSuccessCount(taskTranslateLog.getAttachSuccessCount() +
                                            (int) (attachTranslateLogItems.stream().filter(t -> t.isTransSuccess()).count()));

                                    // 将附件转换失败的图斑的转换状态设置为失败，并更新错误信息
                                    for (AttachTranslateLogItem attachTranslateLogItem : attachTranslateLogItems) {
                                        if (attachTranslateLogItem.isTransSuccess() == false) {
                                            for (TbTranslateLogItem tbTranslateLogItem : tbTranslateLogItems) {
                                                if (attachTranslateLogItem.getTbId().equalsIgnoreCase(tbTranslateLogItem.getTbId())) {
                                                    tbTranslateLogItem.setTransSuccess(false);
                                                    tbTranslateLogItem.setErrorInfo(tbTranslateLogItem.getErrorInfo() + attachTranslateLogItem.getErrorInfo());
                                                }
                                            }
                                        }
                                    }
                                }

                                taskTranslateLog.setTbSuccessCount(taskTranslateLog.getTbSuccessCount() +
                                        (int) (tbTranslateLogItems.stream().filter(t -> t.isTransSuccess()).count()));
                            }
                        }

                    }
                }
            }

            String logFileUrl = generateLogFileAndUploadToOss(taskTranslateLog);

            if (StringUtils.isNotBlank(logFileUrl)) {
                record.setTbCount(taskTranslateLog.getTbCount());
                record.setAttachCount(taskTranslateLog.getAttachCount());
                record.setTbSuccessCount(taskTranslateLog.getTbSuccessCount());
                record.setAttachSuccessCount(taskTranslateLog.getAttachSuccessCount());
                record.setLogUrl(logFileUrl);
            }
        } catch (Exception e) {
        	logger.error(e.getMessage(), e);
            record.setErrorInfo(e.getMessage());
        } finally {
            record.setEndTime(new Date());
            record.setStatus(new Short("2"));
            taskTranslateRecordService.updateByPrimaryKeySelective(record);
        }
    }

    private String generateTranslateLog(String tempFilePath, String fileName, TaskTranslateLog taskTranslateLog) throws IOException {
        String filePath = "";
        SXSSFWorkbook workbook = null;
        OutputStream os = null;
        try {
            filePath = tempFilePath + File.separator + fileName;
            FileUtil.creatDirectoryIfNotExist(tempFilePath);
            workbook = new SXSSFWorkbook(new XSSFWorkbook(), 500);
            //压缩临时文件，很重要，否则磁盘很快就会被写满
            workbook.setCompressTempFiles(true);
            createTaskSheet(taskTranslateLog, workbook);
            createTbSheet(taskTranslateLog, workbook);
            createAttachSheet(taskTranslateLog, workbook);
            if (workbook != null) {
                File file = new File(filePath);
                os = new FileOutputStream(file);
                workbook.write(os);
            }
        } catch (Exception e) {
            throw e;
        } finally {
            try {
                if (workbook != null) {
                    workbook.dispose();
                }
            } catch (Exception e) {

            }
            try {
                if (os != null) {
                    os.close();
                }
            } catch (IOException e) {

            }
        }

        return filePath;
    }

    private Sheet createAttachSheet(TaskTranslateLog taskTranslateLog, SXSSFWorkbook workbook) {
        Row row;
        Sheet sheet;
        sheet = workbook.createSheet("附件转换结果");
        row = sheet.createRow(0);
        row.createCell(0).setCellValue("源图斑id");
        row.createCell(1).setCellValue("新图斑id");
        row.createCell(2).setCellValue("源附件id");
        row.createCell(3).setCellValue("新附件id");
        row.createCell(4).setCellValue("附件名称");
        row.createCell(5).setCellValue("是否转换成功");
        row.createCell(6).setCellValue("错误原因");

        int dataRowIndex = 1;
        if (!GutilCollection.isEmpty(taskTranslateLog.getAttachTranslateLogItems())) {
            for (AttachTranslateLogItem attachTranslateLogItem : taskTranslateLog.getAttachTranslateLogItems()) {
                row = sheet.createRow(dataRowIndex);
                row.createCell(0).setCellValue(attachTranslateLogItem.getTbId());
                row.createCell(1).setCellValue(attachTranslateLogItem.getNewTbId());
                row.createCell(2).setCellValue(attachTranslateLogItem.getNewTbId());
                row.createCell(3).setCellValue(attachTranslateLogItem.getNewAttachId());
                row.createCell(4).setCellValue(attachTranslateLogItem.getAttachName());
                row.createCell(5).setCellValue(attachTranslateLogItem.isTransSuccess() ? "成功" : "失败");
                row.createCell(6).setCellValue(attachTranslateLogItem.getErrorInfo());
                dataRowIndex++;
            }
        }

        return sheet;
    }

    private Sheet createTbSheet(TaskTranslateLog taskTranslateLog, SXSSFWorkbook workbook) {
        Row row;
        Sheet sheet;
        sheet = workbook.createSheet("图斑转换结果");
        row = sheet.createRow(0);
        row.createCell(0).setCellValue("源图斑id");
        row.createCell(1).setCellValue("新图斑id");
        row.createCell(2).setCellValue("唯一值字段");
        row.createCell(3).setCellValue("是否转换成功");
        row.createCell(4).setCellValue("错误原因");

        int dataRowIndex = 1;
        if (!GutilCollection.isEmpty(taskTranslateLog.getTbTaskTranslateLogItems())) {
            for (TbTranslateLogItem tbTranslateLogItem : taskTranslateLog.getTbTaskTranslateLogItems()) {
                row = sheet.createRow(dataRowIndex);
                row.createCell(0).setCellValue(tbTranslateLogItem.getTbId());
                row.createCell(1).setCellValue(tbTranslateLogItem.getNewTbId());
                row.createCell(2).setCellValue(tbTranslateLogItem.getUniqueValue());
                row.createCell(3).setCellValue(tbTranslateLogItem.isTransSuccess() ? "成功" : "失败");
                row.createCell(4).setCellValue(tbTranslateLogItem.getErrorInfo());
                dataRowIndex++;
            }
        }
        return sheet;
    }

    private Sheet createTaskSheet(TaskTranslateLog taskTranslateLog, SXSSFWorkbook workbook) {
        Row row;
        Sheet sheet;
        sheet = workbook.createSheet("任务转换结果");
        row = sheet.createRow(0);
        row.createCell(0).setCellValue("任务编号");
        row.createCell(1).setCellValue("任务名称");
        row.createCell(2).setCellValue("转换类型");
        row.createCell(3).setCellValue("图斑总数量");
        row.createCell(4).setCellValue("图斑成功数量");
        row.createCell(5).setCellValue("图斑失败数量");
        row.createCell(6).setCellValue("附件总数量");
        row.createCell(7).setCellValue("附件成功数量");
        row.createCell(8).setCellValue("附件失败数量");
        row.createCell(9).setCellValue("转换人");
        row.createCell(10).setCellValue("转换时间");
        row.createCell(11).setCellValue("失败原因");

        row = sheet.createRow(1);
        row.createCell(0).setCellValue(taskTranslateLog.getTaskId());
        row.createCell(1).setCellValue(taskTranslateLog.getTaskName());
        if (taskTranslateLog.getTranslateType().equals(1)) {
            row.createCell(2).setCellValue("转换图斑字段");
        } else if (taskTranslateLog.getTranslateType().equals(2)) {
            row.createCell(2).setCellValue("转换附件");
        } else {
            row.createCell(2).setCellValue("转换图斑字段和附件");
        }
        row.createCell(3).setCellValue(taskTranslateLog.getTbCount());
        row.createCell(4).setCellValue(taskTranslateLog.getTbSuccessCount());
        row.createCell(5).setCellValue(Math.max(taskTranslateLog.getTbCount() - taskTranslateLog.getTbSuccessCount(), 0));
        row.createCell(6).setCellValue(taskTranslateLog.getAttachCount());
        row.createCell(7).setCellValue(taskTranslateLog.getAttachSuccessCount());
        row.createCell(8).setCellValue(Math.max(taskTranslateLog.getAttachCount() - taskTranslateLog.getAttachSuccessCount(), 0));
        row.createCell(9).setCellValue(taskTranslateLog.getTranslateUser());
        row.createCell(10).setCellValue(taskTranslateLog.getTranslateTime());
        row.createCell(11).setCellValue("");
        return sheet;
    }

    private String generateLogFileAndUploadToOss(TaskTranslateLog taskTranslateLog) {
        tempDir = (String) ProjectConfig.getConfig(ProjectConfigEnum.UPLOAD_DIR.getKey());
        String filePath = "";
        try {
            filePath = generateTranslateLog(tempDir, "任务转换日志", taskTranslateLog);
            if (StringUtils.isNotBlank(filePath)) {
                String url = ossOperatorService.sendObject2Oss("TaskTranslate/" + taskTranslateLog.getTaskId() + "/" + taskTranslateLog.getTaskName() + System.currentTimeMillis() + "任务转换日志.xlsx", filePath);
                return url;
            }
        } catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage(), e);
        } finally {
            if (StringUtils.isNotBlank(filePath)) {
                try {
                    File file = new File(filePath);
                    if (file.exists()) {
                        file.delete();
                    }
                } catch (Exception e) {

                }
            }
        }
        return null;
    }


    private void translateAndSaveAttachData(List<AppMedia> appMediaList, Map<String, String> tbIdChangedMap,
                                            List<TbTaskTranslateAttach> taskTranslateAttaches,
                                            List<AttachTranslateLogItem> attachTranslateLogItems) {
        if (appMediaList != null) {
            for (AppMedia appMedia : appMediaList) {
                AttachTranslateLogItem attachTranslateLogItem = new AttachTranslateLogItem();

                try {
                    String attachId = appMedia.getId();
                    String newAttachId = UUID.randomUUID().toString();
                    String tbId = appMedia.getGalleryid();
                    String newTbId = tbIdChangedMap.get(appMedia.getGalleryid());

                    attachTranslateLogItem.setAttachId(attachId);
                    attachTranslateLogItem.setNewAttachId(newAttachId);
                    attachTranslateLogItem.setTbId(tbId);
                    attachTranslateLogItem.setNewTbId(newTbId);

                    appMedia.setGalleryid(newTbId);
                    // 更改分组 分类
                    if (appMedia.getTypetype() != null && taskTranslateAttaches != null) {
                        for (TbTaskTranslateAttach taskTranslateAttach : taskTranslateAttaches) {
                            if (taskTranslateAttach.getSourceTypeName().equals(appMedia.getTypetype().toString())) {
                                appMedia.setTypetype(Integer.valueOf(taskTranslateAttach.getTargetTypeName()));
                            }
                        }
                    }
                    String newUrl = ossOperatorService.copyObject(appMedia.getServerpath(), "media/" + UUID.randomUUID().toString());
                    if (StringUtils.isNotBlank(newUrl)) {
                        appMedia.setServerpath(newUrl);
                    }
                    int row = appMediaService.saveOne(appMedia);
                    attachTranslateLogItem.setTransSuccess(row == 1);
                } catch (Exception e) {
                	logger.error(e.getMessage(), e);
                    attachTranslateLogItem.setTransSuccess(false);
                    attachTranslateLogItem.setErrorInfo(e.getMessage());
                }

                attachTranslateLogItems.add(attachTranslateLogItem);

            }
        }
    }

    private Collection<String> getSystemFields() {
        List<String> retVal = new ArrayList<>();
        retVal.add("f_id");
        retVal.add("f_ismy");
        //retVal.add("f_xzqmc");
        retVal.add("f_xzqdmsys");
        retVal.add("f_requestid");
        retVal.add("f_createtime");
        retVal.add("f_ismycreate");
        retVal.add("f_shape");
        retVal.add("f_shape1");
        retVal.add("f_lat");
        retVal.add("f_lon");
        retVal.add("f_committime");
        retVal.add("f_userid");
        retVal.add("f_status");
        retVal.add("f_submit_userid");

        return retVal;
    }

    private void translateAndSaveTbData(List<Map> sourcePageData, Map<String, String> filedNameMapping, Map<String, String> tbIdChangedMap,
                                        List<TbTranslateLogItem> tbTranslateLogItems, String dataTableName) {
        if (GutilCollection.isEmpty(sourcePageData)) {
            return;
        }
        for (Map map : sourcePageData) {
            TbTranslateLogItem tbTranslateLogItem = new TbTranslateLogItem();
            String tbId = map.get("f_id").toString();
            String newTbId = UUID.randomUUID().toString();

            tbTranslateLogItem.setTbId(tbId);
            tbTranslateLogItem.setNewTbId(newTbId);
            //tbTranslateLogItem.setUniqueValue("");
            Map<String, Object> newMap = new HashMap<>();
            for (Object key : map.keySet()) {
                if (filedNameMapping.containsKey(key.toString())) {
                    newMap.put(filedNameMapping.get(key), map.get(key));
                } else {
                    newMap.put(key.toString(), map.get(key));
                }
            }
            tbIdChangedMap.put(tbId, newTbId);
            // 设置图斑默认值
            newMap.put("f_id", newTbId);
            newMap.put("f_status", TbStatusEnum.DISTRIBUTED.getCode());
            newMap.put("f_review_stage", ReviewStageEnum.OPERATOR_VERIFY.getCode());
            // TODO xzqdmsys根据图斑位置重新生成
            //newMap.put("f_xzqdmsys", "");

            try {
                int rows = dataBizService.insertData(dataTableName, newMap, "f_shape");
                tbTranslateLogItem.setTransSuccess(rows == 1);
            } catch (Exception e) {
                tbTranslateLogItem.setTransSuccess(false);
                tbTranslateLogItem.setErrorInfo(e.getMessage());
            }

            tbTranslateLogItems.add(tbTranslateLogItem);
        }
    }

    private String checkRecordBeforeTranslate(TbTaskTranslateRecord record) {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isEmpty(record.getTaskId())) {
            sb.append(" 待转换任务ID不能为空。");
            return sb.toString();
        }

        if (StringUtils.isEmpty(record.getTemplateId())) {
            sb.append(" 任务转换模板ID不能为空。 ");
            return sb.toString();
        }

        TskTaskBiz sourceTaskBiz = taskBizService.findByTaskId(record.getTaskId());
        if (sourceTaskBiz == null) {
            sb.append(" 待转换任务不存在或已被删除。 ");
            return sb.toString();
        }

        TbTaskTranslateTemplate template = taskTranslateTemplateService.findOneById(record.getTemplateId());
        if (template == null) {
            sb.append(" 任务转换模板不存在或已被删除。 ");
            return sb.toString();
        }

        TskTaskBiz targetTaskBiz = taskBizService.findByTaskId(template.getTargetTaskId());
        if (targetTaskBiz == null) {
            sb.append(" 目标转换任务不存在或已被删除。 ");
            return sb.toString();
        }

        if (template.getTranslateType().intValue() == 1
                || template.getTranslateType().intValue() == 3) {

            List<TbTaskTranslateField> taskTranslateFields = taskTranslateFieldService.queryFieldsByTemplateId(template.getId());
            if (GutilCollection.isEmpty(taskTranslateFields)) {
                sb.append(" 待转换任务字段配置信息不存在或已被删除。 ");
                return sb.toString();
            }
        }

        if (template.getTranslateType().intValue() == 2
                || template.getTranslateType().intValue() == 3) {
            List<TbTaskTranslateAttach> taskTranslateAttaches = taskTranslateAttachService.queryAttachsByTemplateId(template.getId());
            if (GutilCollection.isEmpty(taskTranslateAttaches)) {
                sb.append(" 待转换任务附件配置信息不存在或已被删除。 ");
                return sb.toString();
            }
        }
        return sb.toString();
    }
}
