package com.geoway.landteam.landcloud.service.customtask.taskTranslate.impl;


import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.mapper.taskTranslate.TbTaskTranslateAttachMapper;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.customtask.taskTranslate.dto.TaskTranslateAttachItemDTO;
import com.geoway.landteam.customtask.taskTranslate.dto.TaskTranslateAttachMappingDTO;
import com.geoway.landteam.customtask.taskTranslate.dto.TaskTranslateTemplateAttachDTO;
import com.geoway.landteam.customtask.taskTranslate.entity.AttachConfig;
import com.geoway.landteam.customtask.taskTranslate.entity.TbTaskTranslateAttach;
import com.geoway.landteam.customtask.taskTranslate.entity.TbTaskTranslateTemplate;
import com.geoway.landteam.landcloud.servface.customtask.taskTranslate.MTbTaskTranslateAttachService;
import com.geoway.landteam.landcloud.servface.customtask.taskTranslate.MTbTaskTranslateTemplateService;
import com.geoway.landteam.landcloud.service.customtask.task.MTskTaskBizService;
import com.gw.base.util.GutilAssert;
import com.gw.base.util.GutilCollection;


import com.geoway.landteam.landcloud.common.util.base.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.*;

@Service
public class MTbTaskTranslateAttachServiceImpl implements MTbTaskTranslateAttachService {

    @Autowired
    private TbTaskTranslateAttachMapper tbTaskTranslateAttachMapper;

    @Autowired
    MTbTaskTranslateTemplateService templateService;
    @Autowired
    MTskTaskBizService taskBizService;

    @Override
    public int deleteByPrimaryKey(String id) {
        return tbTaskTranslateAttachMapper.deleteByPrimaryKey(id);
    }

    @Override
    public int insert(TbTaskTranslateAttach record) {
        return tbTaskTranslateAttachMapper.insert(record);
    }

    @Override
    public int insertSelective(TbTaskTranslateAttach record) {
        return tbTaskTranslateAttachMapper.insertSelective(record);
    }

    @Override
    public TbTaskTranslateAttach selectByPrimaryKey(String id) {
        return tbTaskTranslateAttachMapper.selectByPrimaryKey(id);
    }

    @Override
    public int updateByPrimaryKeySelective(TbTaskTranslateAttach record) {
        return tbTaskTranslateAttachMapper.updateByPrimaryKeySelective(record);
    }

    @Override
    public int updateByPrimaryKey(TbTaskTranslateAttach record) {
        return tbTaskTranslateAttachMapper.updateByPrimaryKey(record);
    }

    @Override
    public Map saveAttachMapping(TaskTranslateTemplateAttachDTO dto, long userId) {
        GutilAssert.notNull(dto, "parameter 'dto' must not be null .");

        Map resultMap = new HashMap();
        resultMap.put("result", false);
        resultMap.put("data", "");
        resultMap.put("error", "");

        String checkResult = checkMapping(dto);
        if (StringUtils.isNotBlank(checkResult)) {
            resultMap.put("error", checkResult);
        } else {
            doSaveAttachMapping(dto, userId);

            resultMap.put("result", true);
            resultMap.put("data", dto.getTemplateId());
        }
        return resultMap;
    }


    private void doSaveAttachMapping(TaskTranslateTemplateAttachDTO dto, long userId) {
        TskTaskBiz sourceTaskBiz = taskBizService.findByTaskId(dto.getSourceTaskId());
        if (sourceTaskBiz != null) {
            TbTaskTranslateTemplate template = templateService.findOneById(dto.getTemplateId());
            if (template != null) {
                if (StringUtils.isNotBlank(template.getTargetTaskId())) {
                    TskTaskBiz targetTaskBiz = taskBizService.findByTaskId(template.getTargetTaskId());
                    if (targetTaskBiz != null) {
                        if (!GutilCollection.isEmpty(dto.getAttachMappingList())) {

                            List<TbTaskTranslateAttach> list = new ArrayList<>();
                            TbTaskTranslateAttach attach = null;
                            for (TaskTranslateAttachMappingDTO attachMappingDTO : dto.getAttachMappingList()) {
                                attach = new TbTaskTranslateAttach();
                                attach.setId(StringUtils.isNoneBlank(attachMappingDTO.getId()) ? attachMappingDTO.getId() :
                                        UUID.randomUUID().toString());
                                attach.setEnable(new Short("1"));
                                attach.setTemplateId(dto.getTemplateId());
                                attach.setSourceCategoryId(getStringValue(attachMappingDTO.getSourceCategoryId()));
                                attach.setSourceCategoryName(getStringValue(attachMappingDTO.getSourceCategoryName()));
                                attach.setSourceTypeId(getStringValue(attachMappingDTO.getSourceTypeId()));
                                attach.setSourceTypeName(getStringValue(attachMappingDTO.getSourceTypeName()));
                                attach.setTargetCategoryId(getStringValue(attachMappingDTO.getTargetCategoryId()));
                                attach.setTargetCategoryName(getStringValue(attachMappingDTO.getTargetCategoryName()));
                                attach.setTargetTypeId(getStringValue(attachMappingDTO.getTargetTypeId()));
                                attach.setTargetTypeName(getStringValue(attachMappingDTO.getTargetTypeName()));

                                list.add(attach);
                            }
                            if (!GutilCollection.isEmpty(list)) {
                                deleteOldMappingAndInsertNewMapping(dto, list);
                                templateService.updateTemplateFinishStatus(dto.getTemplateId(), new Short("1"), userId);
                            }
                        }
                    }
                }
            }
        }
    }

    @Transactional(rollbackFor = Exception.class)
    public void deleteOldMappingAndInsertNewMapping(TaskTranslateTemplateAttachDTO dto, List<TbTaskTranslateAttach> list) {
        tbTaskTranslateAttachMapper.deleteByTemplateId(dto.getTemplateId());
        tbTaskTranslateAttachMapper.insertList(list);
    }

    private String checkMapping(TaskTranslateTemplateAttachDTO dto) {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isEmpty(dto.getSourceTaskId())) {
            sb.append(" 待转换任务ID不能为空。");
            return sb.toString();
        }
        if (StringUtils.isEmpty(dto.getTemplateId())) {
            sb.append(" 任务转换模板ID不能为空。 ");
            return sb.toString();
        }
        if (GutilCollection.isEmpty(dto.getAttachMappingList())) {
            sb.append(" 附件映射关系不能为空。 ");
            return sb.toString();
        }

        TskTaskBiz sourceTaskBiz = taskBizService.findByTaskId(dto.getSourceTaskId());
        if (sourceTaskBiz == null) {
            sb.append(" 待转换任务不存在或已被删除。 ");
            return sb.toString();
        }

        TbTaskTranslateTemplate template = templateService.findOneById(dto.getTemplateId());
        if (template == null) {
            sb.append(" 任务转换模板不存在或已被删除。 ");
            return sb.toString();
        }
        if (StringUtils.isEmpty(template.getTargetTaskId())) {
            sb.append(" 目标转换任务不存在或已被删除。 ");
            return sb.toString();
        }
        // TODO:检查附件映射关系是否合法
        //TskTaskBiz targetTaskBiz = taskBizService.findByTaskId(template.getTargetTaskId());


        return sb.toString();
    }

    @Override
    public List<TbTaskTranslateAttach> queryAttachsByTemplateId(String templateId) {
        return tbTaskTranslateAttachMapper.queryByTemplateId(templateId);
    }

    @Override
    public List<TaskTranslateAttachItemDTO> queryAttachListByTaskId(String taskId, long userId) {
        GutilAssert.isTrue(StringUtils.isNotBlank(taskId), "parameter 'taskId' must not be null or empty .");
        List<TaskTranslateAttachItemDTO> retVal = new ArrayList<>();
        TskTaskBiz tskTaskBiz = taskBizService.findByTaskId(taskId);
        if (tskTaskBiz != null) {
            if (StringUtils.isNotBlank(tskTaskBiz.getPicConfig())) {
                JSONArray jsonArray = JSONArray.parseArray(tskTaskBiz.getPicConfig());
                if (jsonArray != null) {
                    for (Object obj : jsonArray) {
                        JSONObject jsonObject = JSONObject.parseObject(JSONObject.toJSONString(obj));
                        if (jsonObject != null) {
                            AttachConfig attachConfig = (AttachConfig) JSONObject.toJavaObject(jsonObject, AttachConfig.class);
                            if (attachConfig != null) {
                                TaskTranslateAttachItemDTO dto = new TaskTranslateAttachItemDTO();
                                dto.setId(StringUtils.isNoneBlank(attachConfig.getId()) ? attachConfig.getId() : UUID.randomUUID().toString());
                                dto.setCategoryId(attachConfig.getPictureGroupCode() != null ? attachConfig.getPictureGroupCode().toString() : "1");
                                dto.setCategoryName(StringUtils.isNotBlank(attachConfig.getPictureGroupName()) ? attachConfig.getPictureGroupName() : "实地照片");
                                dto.setTypeId(attachConfig.getTypetype() != null ? attachConfig.getTypetype().toString() : "1");
                                dto.setTypeName(StringUtils.isNotBlank(attachConfig.getType()) ? attachConfig.getType() : "实地照片");
                                retVal.add(dto);
                            }
                        }
                    }
                }
            } else {
                TaskTranslateAttachItemDTO dto = new TaskTranslateAttachItemDTO();
                dto.setId(UUID.randomUUID().toString());
                dto.setCategoryId("1");
                dto.setCategoryName("实地照片");
                dto.setTypeId("1");
                dto.setTypeName("实地照片");
                retVal.add(dto);
            }
        }
        doGroup(retVal);
        return retVal;
    }

    private void doGroup(List<TaskTranslateAttachItemDTO> attachItemDTOList) {
        if (!GutilCollection.isEmpty(attachItemDTOList)) {
            for (TaskTranslateAttachItemDTO dto : attachItemDTOList) {
                dto.setChildrenType(new com.alibaba.fastjson.JSONArray());
                for (TaskTranslateAttachItemDTO itemDTO : attachItemDTOList) {
                    if (dto.getCategoryId().equalsIgnoreCase(itemDTO.getCategoryId())) {
                        JSONObject jsonObject = new JSONObject();
                        jsonObject.put("typeId", itemDTO.getTypeId());
                        jsonObject.put("typeName", itemDTO.getTypeName());
                        dto.getChildrenType().add(jsonObject);
                    }
                }
            }
        }
    }

    @Override
    public List<TaskTranslateAttachMappingDTO> queryAttachsByTemplateIdAndUserId(String templateId, long userId) {

        GutilAssert.isTrue(StringUtils.isNotBlank(templateId), "parameter 'templateId' must not be null or empty .");
        List<TaskTranslateAttachMappingDTO> retVal = new ArrayList<>();

        List<TbTaskTranslateAttach> translateAttaches = tbTaskTranslateAttachMapper.queryByTemplateId(templateId);
        if (!GutilCollection.isEmpty(translateAttaches)) {
            TaskTranslateAttachMappingDTO dto = null;
            for (TbTaskTranslateAttach attach : translateAttaches) {
                dto = new TaskTranslateAttachMappingDTO();
                dto.setId(attach.getId());
                dto.setSourceCategoryId(getStringValue(attach.getSourceCategoryId()));
                dto.setSourceCategoryName(getStringValue(attach.getSourceCategoryName()));
                dto.setSourceTypeId(getStringValue(attach.getSourceTypeId()));
                dto.setSourceTypeName(getStringValue(attach.getSourceTypeName()));
                dto.setTargetCategoryId(getStringValue(attach.getTargetCategoryId()));
                dto.setTargetCategoryName(getStringValue(attach.getTargetCategoryName()));
                dto.setTargetTypeId(getStringValue(attach.getTargetTypeId()));
                dto.setTargetTypeName(getStringValue(attach.getTargetTypeName()));
                retVal.add(dto);
            }
        }
        return retVal;
    }

    private String getStringValue(String value) {
        return StringUtils.isNoneBlank(value) ? value : "";
    }

}
