package com.geoway.landteam.landcloud.service.customtask.taskTranslate.impl;


import com.geoway.landteam.customtask.mapper.taskTranslate.TbTaskTranslateFieldMapper;
import com.geoway.landteam.customtask.repository.task.TbtskFieldsRepository;
import com.geoway.landteam.customtask.task.entity.TbtskFields;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.customtask.taskTranslate.dto.TaskTranslateFieldDTO;
import com.geoway.landteam.customtask.taskTranslate.dto.TaskTranslateFieldMappingDTO;
import com.geoway.landteam.customtask.taskTranslate.dto.TaskTranslateTemplateFiledDTO;
import com.geoway.landteam.customtask.taskTranslate.entity.TbTaskTranslateField;
import com.geoway.landteam.customtask.taskTranslate.entity.TbTaskTranslateTemplate;
import com.geoway.landteam.customtask.util.TskTaskBizDBUtil;
import com.geoway.landteam.landcloud.common.util.bean.MapUtil;
import com.geoway.landteam.landcloud.servface.customtask.taskTranslate.MTbTaskTranslateFieldService;
import com.geoway.landteam.landcloud.servface.customtask.taskTranslate.MTbTaskTranslateTemplateService;
import com.geoway.landteam.landcloud.service.customtask.task.MTskTaskBizService;

import com.gw.base.util.GutilAssert;
import com.gw.base.util.GutilCollection;
import org.apache.commons.collections4.MapUtils;
import com.geoway.landteam.landcloud.common.util.base.StringUtils;
import com.geoway.landteam.landcloud.common.util.bean.BeanUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.*;

@Service
public class MTbTaskTranslateFieldServiceImpl implements MTbTaskTranslateFieldService {

    @Autowired
    TbTaskTranslateFieldMapper tbTaskTranslateFieldMapper;
    @Autowired
    MTbTaskTranslateTemplateService templateService;

    @Autowired
    MTskTaskBizService taskBizService;
    @Autowired
    TbtskFieldsRepository tbtskFieldsRepository;


    /**
     * 系统字段
     */
    private final static Map SYSTEM_FIELD_MAP = new HashMap();

    static {
        SYSTEM_FIELD_MAP.put("f_xzqdmsys", "");
        SYSTEM_FIELD_MAP.put("f_lon", "");
        SYSTEM_FIELD_MAP.put("f_lat", "");
        SYSTEM_FIELD_MAP.put("f_status", "");
        SYSTEM_FIELD_MAP.put("f_ismycreate", "");
        SYSTEM_FIELD_MAP.put("f_createtime", "");
        SYSTEM_FIELD_MAP.put("f_requestid", "");
        SYSTEM_FIELD_MAP.put("f_ismy", "");
        SYSTEM_FIELD_MAP.put("f_submit_userid", "");
        SYSTEM_FIELD_MAP.put("f_reject_count", "");
        SYSTEM_FIELD_MAP.put("f_review_stage", "");
        SYSTEM_FIELD_MAP.put("f_reject_status", "");
        SYSTEM_FIELD_MAP.put("f_shape", "");
        SYSTEM_FIELD_MAP.put("f_shape1", "");
        SYSTEM_FIELD_MAP.put("f_shape_b", "");
        SYSTEM_FIELD_MAP.put("f_lat_b", "");
        SYSTEM_FIELD_MAP.put("f_lon_b", "");
        SYSTEM_FIELD_MAP.put("f_shape_g", "");
        SYSTEM_FIELD_MAP.put("f_lat_g", "");
        SYSTEM_FIELD_MAP.put("f_lon_g", "");
        SYSTEM_FIELD_MAP.put("f_userid", "");
        SYSTEM_FIELD_MAP.put("f_committime", "");
        SYSTEM_FIELD_MAP.put("f_upload_userid", "");
        SYSTEM_FIELD_MAP.put("f_qm", "");
    }

    @Override
    public int deleteByPrimaryKey(String id) {
        return tbTaskTranslateFieldMapper.deleteByPrimaryKey(id);
    }

    @Override
    public int insert(TbTaskTranslateField record) {
        return tbTaskTranslateFieldMapper.insert(record);
    }

    @Override
    public int insertSelective(TbTaskTranslateField record) {
        return tbTaskTranslateFieldMapper.insertSelective(record);
    }

    @Override
    public TbTaskTranslateField selectByPrimaryKey(String id) {
        return tbTaskTranslateFieldMapper.selectByPrimaryKey(id);
    }

    @Override
    public int updateByPrimaryKeySelective(TbTaskTranslateField record) {
        return tbTaskTranslateFieldMapper.updateByPrimaryKeySelective(record);
    }

    @Override
    public int updateByPrimaryKey(TbTaskTranslateField record) {
        return tbTaskTranslateFieldMapper.updateByPrimaryKey(record);
    }

    @Override
    public Map saveFieldMapping(TaskTranslateTemplateFiledDTO dto, long userId) {
        GutilAssert.notNull(dto, "parameter 'dto' must not be null .");

        Map resultMap = new HashMap();
        resultMap.put("result", false);
        resultMap.put("data", "");
        resultMap.put("error", "");

        String checkResult = checkMapping(dto);
        if (StringUtils.isNotBlank(checkResult)) {
            resultMap.put("error", checkResult);
        } else {
            doSaveFieldMapping(dto, userId);

            resultMap.put("result", true);
            resultMap.put("data", dto.getTemplateId());
        }
        return resultMap;
    }

    public void doSaveFieldMapping(TaskTranslateTemplateFiledDTO dto, long userId) {
        TskTaskBiz sourceTaskBiz = taskBizService.findByTaskId(dto.getSourceTaskId());
        if (sourceTaskBiz != null) {
            TbTaskTranslateTemplate template = templateService.findOneById(dto.getTemplateId());
            if (template != null) {
                if (StringUtils.isNotBlank(template.getTargetTaskId())) {
                    TskTaskBiz targetTaskBiz = taskBizService.findByTaskId(template.getTargetTaskId());
                    if (targetTaskBiz != null) {
                        List<TbtskFields> sourceTaskFieldList = tbtskFieldsRepository.getTbtskFieldsByTableid(sourceTaskBiz.getTableId());
                        if (!GutilCollection.isEmpty(sourceTaskFieldList)) {
                            List<TbtskFields> targetTaskFieldList = tbtskFieldsRepository.getTbtskFieldsByTableid(targetTaskBiz.getTableId());
                            if (!GutilCollection.isEmpty(targetTaskFieldList)) {
                                HashMap<String, TbtskFields> sourceFieldMap = new HashMap<>();
                                for (TbtskFields tbtskFields : sourceTaskFieldList) {
                                    sourceFieldMap.put(tbtskFields.getfId(), tbtskFields);
                                }
                                HashMap<String, TbtskFields> targetFieldMap = new HashMap<>();
                                for (TbtskFields tbtskFields : targetTaskFieldList) {
                                    targetFieldMap.put(tbtskFields.getfId(), tbtskFields);
                                }
                                TbTaskTranslateField field = null;
                                TbtskFields sourceField = null;
                                TbtskFields targetField = null;
                                List<TbTaskTranslateField> fieldList = new ArrayList<>();
                                for (TaskTranslateFieldMappingDTO fieldDto : dto.getFieldMappingList()) {
                                    field = getTaskTranslateField(dto, sourceFieldMap, targetFieldMap, fieldDto);
                                    fieldList.add(field);
                                }

                                if (!GutilCollection.isEmpty(fieldList)) {
                                    deleteOldFieldMappingAndInsertNewMapping(dto, fieldList);

                                    if (template.getTranslateType().intValue() == 1) {
                                        templateService.updateTemplateFinishStatus(dto.getTemplateId(), new Short("1"), userId);
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Transactional(rollbackFor = Exception.class)
    public void deleteOldFieldMappingAndInsertNewMapping(TaskTranslateTemplateFiledDTO dto, List<TbTaskTranslateField> fieldList) {
        tbTaskTranslateFieldMapper.deleteByTemplateId(dto.getTemplateId());
        tbTaskTranslateFieldMapper.insertList(fieldList);
    }

    private TbTaskTranslateField getTaskTranslateField(TaskTranslateTemplateFiledDTO dto, HashMap<String, TbtskFields> sourceFieldMap, HashMap<String, TbtskFields> targetFieldMap, TaskTranslateFieldMappingDTO fieldDto) {
        TbtskFields targetField;
        TbTaskTranslateField field;
        TbtskFields sourceField;
        sourceField = sourceFieldMap.get(fieldDto.getSourceFieldId());
        targetField = targetFieldMap.get(fieldDto.getTargetFieldId());
        field = new TbTaskTranslateField();
        field.setEnable(new Short("1"));
        field.setId(UUID.randomUUID().toString());
        field.setFieldName(StringUtils.isNotBlank(targetField.getfFieldname()) ? targetField.getfFieldname() : "");
        field.setFieldType(StringUtils.isNotBlank(targetField.getfFieldtype()) ? targetField.getfFieldtype() : "");
        field.setFieldAlias(StringUtils.isNotBlank(targetField.getfAlias()) ? targetField.getfAlias() : "");
        field.setLength(targetField.getfLength() != null ? targetField.getfLength() : null);
        field.setIsUnique(targetField.getfUnique() != null ? targetField.getfUnique().shortValue() : null);
        field.setDefaultValue(StringUtils.isNotBlank(targetField.getfDefaultvalue()) ? targetField.getfDefaultvalue() : "");
        field.setEnumDicCode(StringUtils.isNotBlank(targetField.getfCodetableid()) ? targetField.getfCodetableid() : "");
        field.setIsPrimary(targetField.getfIsprimary() != null ? targetField.getfIsprimary().shortValue() : new Short("0"));
        field.setPrecision(targetField.getfPrecision() != null ? targetField.getfPrecision() : 0);
        field.setNullable((targetField.getfNullable() != null ? targetField.getfNullable().shortValue() : null));
        field.setRemark(StringUtils.isNotBlank(targetField.getfRemark()) ? targetField.getfRemark() : "");
        field.setTemplateId(dto.getTemplateId());
        field.setSourceFieldId(StringUtils.isNotBlank(sourceField.getfId()) ? sourceField.getfId() : "");
        field.setSourceFieldName(StringUtils.isNotBlank(sourceField.getfFieldname()) ? sourceField.getfFieldname() : "");
        field.setSourceFieldAlias(StringUtils.isNotBlank(sourceField.getfAlias()) ? sourceField.getfAlias() : "");
        field.setFieldInnerOuterSys(targetField.getfFieldInnerOuterSys()!=null?targetField.getfFieldInnerOuterSys().shortValue():null);
        field.setTargetFieldId(StringUtils.isNotBlank(targetField.getfId())?targetField.getfId():"");
        return field;
    }

    private String checkMapping(TaskTranslateTemplateFiledDTO dto) {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isEmpty(dto.getSourceTaskId())) {
            sb.append(" 待转换任务ID不能为空。");
            return sb.toString();
        }
        if (StringUtils.isEmpty(dto.getTemplateId())) {
            sb.append(" 任务转换模板ID不能为空。 ");
            return sb.toString();
        }
        if (GutilCollection.isEmpty(dto.getFieldMappingList())) {
            sb.append(" 字段映射关系不能为空。 ");
            return sb.toString();
        }

        TskTaskBiz sourceTaskBiz = taskBizService.findByTaskId(dto.getSourceTaskId());
        if (sourceTaskBiz == null) {
            sb.append(" 待转换任务不存在或已被删除。 ");
            return sb.toString();
        }

        TbTaskTranslateTemplate template = templateService.findOneById(dto.getTemplateId());
        if (template == null) {
            sb.append(" 任务转换模板不存在或已被删除。 ");
            return sb.toString();
        }
        if (StringUtils.isEmpty(template.getTargetTaskId())) {
            sb.append(" 目标转换任务不存在或已被删除。 ");
            return sb.toString();
        }
        TskTaskBiz targetTaskBiz = taskBizService.findByTaskId(template.getTargetTaskId());

        List<TbtskFields> sourceTaskFieldList = tbtskFieldsRepository.getTbtskFieldsByTableid(sourceTaskBiz.getTableId());
        if (GutilCollection.isEmpty(sourceTaskFieldList)) {
            sb.append(" 待转换任务字段配置信息不存在或已被删除。 ");
            return sb.toString();
        }
        List<TbtskFields> targetTaskFieldList = tbtskFieldsRepository.getTbtskFieldsByTableid(targetTaskBiz.getTableId());
        if (GutilCollection.isEmpty(targetTaskFieldList)) {
            sb.append(" 目标转换任务字段配置信息不存在或已被删除。 ");
            return sb.toString();
        }
        HashMap<String, TbtskFields> sourceFieldMap = new HashMap<>();
        for (TbtskFields tbtskFields : sourceTaskFieldList) {
            sourceFieldMap.put(tbtskFields.getfId(), tbtskFields);
        }
        HashMap<String, TbtskFields> targetFieldMap = new HashMap<>();
        for (TbtskFields tbtskFields : targetTaskFieldList) {
            targetFieldMap.put(tbtskFields.getfId(), tbtskFields);
        }

        for (TaskTranslateFieldMappingDTO fieldMappingDTO : dto.getFieldMappingList()) {
            String result = checkFieldItem(fieldMappingDTO, sourceFieldMap, targetFieldMap);
            if (StringUtils.isNotBlank(result)) {
                sb.append(result);
            }
        }

        return sb.toString();
    }

    private String checkFieldItem(TaskTranslateFieldMappingDTO field, HashMap<String, TbtskFields> sourceFieldMap, HashMap<String, TbtskFields> targetFieldMap) {
        StringBuilder sb = new StringBuilder();
        if (MapUtil.isEmpty(sourceFieldMap) || MapUtil.isEmpty(targetFieldMap)) {
            sb.append(" 源字段集合为空或目标字段集合为空。 ");
            return sb.toString();
        }
        if (StringUtils.isEmpty(field.getSourceFieldId())) {
            sb.append(" 源字段Id不能为空。 ");
        }
        if (StringUtils.isEmpty(field.getTargetFieldId())) {
            sb.append(" 目标字段Id不能为空。 ");
        }
        String sourceFieldAlias = StringUtils.isNotBlank(field.getSourceFieldAlias()) ?
                field.getSourceFieldAlias() : StringUtils.isNotBlank(field.getSourceFieldId()) ? field.getSourceFieldId() : "";
        String targetFieldAlias = StringUtils.isNotBlank(field.getTargetFieldAlias()) ?
                field.getTargetFieldAlias() : StringUtils.isNotBlank(field.getTargetFieldId()) ? field.getTargetFieldId() : "";
        TbtskFields sourceField = sourceFieldMap.get(field.getSourceFieldId());
        if (sourceField == null) {
            sb.append(String.format(" 源字段%s的配置信息不存在。", sourceFieldAlias));
            return sb.toString();
        }
        TbtskFields targetField = targetFieldMap.get(field.getTargetFieldId());
        if (targetField == null) {
            sb.append(String.format(" 目标字段%s的配置信息不存在。", targetFieldAlias));
            return sb.toString();
        }
        if (StringUtils.isNotBlank(sourceField.getfCodetableid()) && StringUtils.isNotBlank(targetField.getfCodetableid())) {
            if (!sourceField.getfCodetableid().equalsIgnoreCase(targetField.getfCodetableid())) {
                sb.append(String.format(" 目标字段%s的与源字段%s的数据字典不一致。", targetFieldAlias, sourceFieldAlias));
            }
        } else if ((StringUtils.isNotBlank(sourceField.getfCodetableid()) && StringUtils.isEmpty(targetField.getfCodetableid()))
                || (StringUtils.isEmpty(sourceField.getfCodetableid()) && StringUtils.isNotBlank(targetField.getfCodetableid()))) {
            sb.append(String.format(" 目标字段%s的与源字段%s的数据字典不一致。", targetFieldAlias, sourceFieldAlias));
        }
        String sourceType = TskTaskBizDBUtil.getDBType(sourceField.getfFieldtype());
        String targetType = TskTaskBizDBUtil.getDBType(targetField.getfFieldtype());
        if (sourceType.equalsIgnoreCase("varchar")) {
            if (!targetType.equalsIgnoreCase("text")
                    && !targetType.equalsIgnoreCase("varchar")) {
                sb.append(String.format(" 目标字段%s的与源字段%s的数据类型不一致。", targetFieldAlias, sourceFieldAlias));
            } else {
                if (targetType.equalsIgnoreCase("varchar")
                        && sourceField.getfLength() > targetField.getfLength()) {
                    sb.append(String.format(" 所选源字段字段%s的目标字段长度大于%s的长度。", sourceFieldAlias, targetFieldAlias));
                }
            }
        } else if (sourceType.equalsIgnoreCase("int4")) {
            if (!targetType.equalsIgnoreCase("decimal")
                    && !targetType.equalsIgnoreCase("int4")
                    && !targetType.equalsIgnoreCase("text")
                    && !targetType.equalsIgnoreCase("varchar")) {
                sb.append(String.format(" 目标字段%s的与源字段%s的数据类型不一致。", targetFieldAlias, sourceFieldAlias));
            }
        } else if (sourceType.equalsIgnoreCase("decimal")) {
            if (!targetType.equalsIgnoreCase("decimal")) {
                sb.append(String.format(" 目标字段%s的与源字段%s的数据类型不一致。", targetFieldAlias, sourceFieldAlias));
            }
        } else if (!sourceField.getfFieldtype().equalsIgnoreCase(targetField.getfFieldtype())) {
            sb.append(String.format(" 目标字段%s的与源字段%s的数据类型不一致。", targetFieldAlias, sourceFieldAlias));
        }
        return sb.toString();
    }

    @Override
    public List<TaskTranslateFieldDTO> queryFieldsByTaskId(String taskId, String templateId, long userId) {
        GutilAssert.isTrue(StringUtils.isNotBlank(taskId), "parameter 'taskId' must not be null or empty .");

        List<TaskTranslateFieldDTO> retVal = new ArrayList<>();
        TskTaskBiz tskTaskBiz = taskBizService.findByTaskId(taskId);
        if (tskTaskBiz != null) {
            List<TbtskFields> tbtskFieldsList = tbtskFieldsRepository.queryInnerAndOuterFields(tskTaskBiz.getTableId());
            if (!GutilCollection.isEmpty(tbtskFieldsList)) {
                TaskTranslateFieldDTO dto = null;
                List<TbTaskTranslateField> existedFieldMappings = null;
                if (StringUtils.isNotBlank(templateId)) {
                    existedFieldMappings = queryFieldsByTemplateId(templateId);
                }
                for (TbtskFields tbtskFields : tbtskFieldsList) {
                    if (needTranslate(tbtskFields)) {
                        dto = convertFieldToDTO(tbtskFields);
                        if (!GutilCollection.isEmpty(existedFieldMappings)) {
                            for (TbTaskTranslateField existedField : existedFieldMappings) {
                                if (existedField.getTargetFieldId().equalsIgnoreCase(dto.getId())) {
                                    dto.setSourceFieldId(StringUtils.isNotBlank(existedField.getSourceFieldId()) ?
                                            existedField.getSourceFieldId() : "");
                                    dto.setSourceFieldName(StringUtils.isNotBlank(existedField.getSourceFieldName()) ?
                                            existedField.getSourceFieldName() : "");
                                    dto.setSourceFieldAlias(StringUtils.isNotBlank(existedField.getSourceFieldAlias()) ?
                                            existedField.getSourceFieldAlias() : "");
                                    dto.setTargetFieldId(StringUtils.isNotBlank(existedField.getTargetFieldId()) ?
                                            existedField.getTargetFieldId() : "");
                                }
                            }
                        }
                        retVal.add(dto);
                    }
                }
            }
        }
        return retVal;
    }

    private TaskTranslateFieldDTO convertFieldToDTO(TbtskFields tbtskFields) {
        TaskTranslateFieldDTO dto = new TaskTranslateFieldDTO();
        dto.setId(StringUtils.isNotBlank(tbtskFields.getfId()) ? tbtskFields.getfId() : "");
        dto.setFieldName(StringUtils.isNotBlank(tbtskFields.getfFieldname()) ? tbtskFields.getfFieldname() : "");
        dto.setFieldAlias(StringUtils.isNotBlank(tbtskFields.getfAlias()) ? tbtskFields.getfAlias() : "");
        dto.setFieldType(StringUtils.isNotBlank(tbtskFields.getfFieldtype()) ? tbtskFields.getfFieldtype() : "");
        dto.setPrecision(tbtskFields.getfPrecision() != null ? tbtskFields.getfPrecision() : null);
        dto.setLength(tbtskFields.getfLength() != null ? tbtskFields.getfLength() : null);
        dto.setEnumDicCode(StringUtils.isNotBlank(tbtskFields.getfCodetableid()) ? tbtskFields.getfCodetableid() : "");
        dto.setNullable(tbtskFields.getfNullable() != null ? tbtskFields.getfNullable().shortValue() : null);
        dto.setIsUnique(tbtskFields.getfUnique() != null ? tbtskFields.getfUnique().shortValue() : null);
        return dto;
    }

    /**
     * 判断字段是否需要转换
     *
     * @param field
     * @return
     */
    private boolean needTranslate(TbtskFields field) {

        if (field == null) {
            return false;
        }
        return !isSystemField(field);
    }

    private boolean isSystemField(TbtskFields field) {
        return SYSTEM_FIELD_MAP.containsKey(field.getfFieldname());
    }


    @Override
    public List<TbTaskTranslateField> queryFieldsByTemplateId(String templateId) {
        return tbTaskTranslateFieldMapper.queryByTemplateId(templateId);
    }

    @Override
    public List<TaskTranslateFieldDTO> queryFieldsByTemplateId(String templateId, long userId) {

        List<TaskTranslateFieldDTO> retVal = new ArrayList<>();
        List<TbTaskTranslateField> fieldList = tbTaskTranslateFieldMapper.queryByTemplateId(templateId);
        if (!GutilCollection.isEmpty(fieldList)) {
            TaskTranslateFieldDTO dto = null;
            for (TbTaskTranslateField field : fieldList) {
                dto = new TaskTranslateFieldDTO();
                BeanUtil.copyProperties(field, dto);
                retVal.add(dto);
            }
        }
        return retVal;
    }
}
