package com.geoway.landteam.landcloud.service.customtask.taskTranslate.impl;


import com.geoway.landteam.customtask.mapper.taskTranslate.TbTaskTranslateTaskMapper;
import com.geoway.landteam.customtask.servface.taskTranslate.TbTaskTranslateTaskService;
import com.geoway.landteam.customtask.taskTranslate.entity.TbTaskTranslateTask;

import com.geoway.landteam.landcloud.servface.customtask.taskTranslate.MTbTaskTranslateTaskService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;

@Service
public class MTbTaskTranslateTaskServiceImpl implements MTbTaskTranslateTaskService {

    @Autowired
    private TbTaskTranslateTaskMapper tbTaskTranslateTaskMapper;
    @Autowired
    private JdbcTemplate jdbcTemplate;

    @Override
    public void delete(String id) {
         tbTaskTranslateTaskMapper.gwDeleteByPK(id);
    }


    @Override
    public int insert(TbTaskTranslateTask task) {
        return tbTaskTranslateTaskMapper.insert(task);
    }

    @Override
    public TbTaskTranslateTask select(String id) {
        return tbTaskTranslateTaskMapper.gwSearchByPK(id);
    }

    @Override
    public TbTaskTranslateTask selectSimple(String id) {
        return tbTaskTranslateTaskMapper.selectSimple(id);
    }

    @Override
    public List<TbTaskTranslateTask> queryLatestN(String taskId, Integer top, String userId) {
        return tbTaskTranslateTaskMapper.findOrderByCreateTime(taskId,top,userId);
    }

    @Override
    public List<TbTaskTranslateTask> queryLatestNWithoutParam(String taskId, Integer top, String userId) {
        return tbTaskTranslateTaskMapper.findOrderByCreateTimeWithoutParam(taskId,top,userId);
    }

    @Override
    public boolean updateStatus(String id, Integer status) {
        return tbTaskTranslateTaskMapper.updateStatus(id,status)>0;
    }

    @Override
    public boolean update(String id, Integer status, Date startTime)
    {
        return tbTaskTranslateTaskMapper.update(id,status,startTime)>0;
    }

    @Override
    public boolean updateParam(String id,String param)
    {
        return tbTaskTranslateTaskMapper.updateParam(id,param)>0;
    }

    @Override
    public boolean updateUseCount(String id, Integer useCount) {
        return tbTaskTranslateTaskMapper.updateUseCount(id,useCount)>0;
    }

    @Override
    public boolean updateUseingCount(String id, Integer useingCount) {
        return tbTaskTranslateTaskMapper.updateUseingCount(id,useingCount)>0;
    }

    @Override
    public boolean updateUseingCountZz(String id) {
        return tbTaskTranslateTaskMapper.updateUseingCountZz(id)>0;
    }

    @Override
    public boolean setUse(String id) {
        return tbTaskTranslateTaskMapper.setUse(id)>0;
    }

    @Override
    public List<TbTaskTranslateTask> getDelete() {
        return tbTaskTranslateTaskMapper.getDelete();
    }

    @Override
    public List<TbTaskTranslateTask> getDeleteByShard(int total, int index) {
        return tbTaskTranslateTaskMapper.getDeleteByShard(total, index);
    }

    @Override
    public int setDelete(String id) {
        return tbTaskTranslateTaskMapper.setDelete(id);
    }
}
