package com.geoway.landteam.landcloud.service.customtask.taskTranslate.impl;


import com.geoway.landteam.customtask.mapper.taskTranslate.TbTaskTranslateTemplateMapper;
import com.geoway.landteam.customtask.taskTranslate.dto.TaskTranslateTemplateDTO;
import com.geoway.landteam.customtask.taskTranslate.entity.TbTaskTranslateTemplate;
import com.geoway.landteam.landcloud.core.servface.user.UserNameService;
import com.geoway.landteam.landcloud.servface.customtask.taskTranslate.MTbTaskTranslateTemplateService;
import com.github.pagehelper.PageHelper;
import com.gw.base.log.GwLoger;
import com.gw.base.log.GiLoger;
import com.gw.base.data.GwValidateException;
import com.gw.base.util.GutilAssert;
import com.gw.base.util.GutilCollection;
import com.geoway.landteam.landcloud.common.util.base.StringUtils;
import com.geoway.landteam.landcloud.common.util.bean.BeanUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;


@Service
public class MTbTaskTranslateTemplateServiceImpl implements MTbTaskTranslateTemplateService {
    private static final GiLoger log= GwLoger.getLoger();
    @Autowired
    private TbTaskTranslateTemplateMapper templateMapper;
    @Autowired
    UserNameService userNameService;

    @Override
    public int deleteByPrimaryKey(String id) {
        return templateMapper.deleteByPrimaryKey(id);
    }

    @Override
    public int insert(TbTaskTranslateTemplate record) {
        return templateMapper.insert(record);
    }

    @Override
    public int insertSelective(TbTaskTranslateTemplate record) {
        return templateMapper.insertSelective(record);
    }

    @Override
    public TbTaskTranslateTemplate selectByPrimaryKey(String id) {
        return templateMapper.selectByPrimaryKey(id);
    }

    @Override
    public int updateByPrimaryKeySelective(TbTaskTranslateTemplate record) {
        return templateMapper.updateByPrimaryKeySelective(record);
    }

    @Override
    public int updateByPrimaryKey(TbTaskTranslateTemplate record) {
        return templateMapper.updateByPrimaryKey(record);
    }

    @Override
    public List<TaskTranslateTemplateDTO> findListByPageNumSize(String templateName, String sourceTaskId, Integer pageNum, Integer pageSize, long userId, Integer templateType) {
        GutilAssert.notNull(pageNum, "pageNum must not be null.");
        GutilAssert.isTrue(pageSize != null && pageSize > 0, "PageSize must not be null and must be a positive number.");
        PageHelper.startPage(pageNum, pageSize);
        List<TbTaskTranslateTemplate> templateList = null;
            templateList = templateMapper.queryByNameLikeAndSourceTaskIdAndCreateUserIdOrScope(
                    StringUtils.isNotBlank(templateName) ? templateName : "",
                    StringUtils.isNotBlank(sourceTaskId) ? sourceTaskId : "",
                    String.valueOf(userId),"1", templateType);

        return convertEntityToDTO(templateList);
    }

    @Override
    public List<TbTaskTranslateTemplate> findListByPageNumAndSize(String templateName, Integer pageNum, Integer pageSize, long userId) {
        GutilAssert.notNull(pageNum, "pageNum must not be null.");
        GutilAssert.isTrue(pageSize != null && pageSize > 0, "PageSize must not be null and must be a positive number.");
        PageHelper.startPage(pageNum, pageSize);
        List<TbTaskTranslateTemplate> templateList = templateMapper.queryByNameLikeAndCreateUserId(StringUtils.isNotBlank(templateName) ? templateName : "", String.valueOf(userId));

        return templateList;
    }

    @Override
    public TaskTranslateTemplateDTO findOneByPrimaryKey(String templateId) {
        TbTaskTranslateTemplate template = templateMapper.selectByPrimaryKey(templateId);
        return convertEntityToDTO(template);
    }

    @Override
    public TbTaskTranslateTemplate findOneById(String templateId) {
        return templateMapper.selectByPrimaryKey(templateId);
    }

    @Override
    public String saveOne(TaskTranslateTemplateDTO dto, long userId) throws Exception {
        TbTaskTranslateTemplate template = convertDtoToEntity(dto);
        if (StringUtils.isEmpty(template.getId())) {
            template.setId(UUID.randomUUID().toString());
        }
        template.setCreateTime(new Date());
        template.setCreateUserId(String.valueOf(userId));
        template.setUpdateTime(new Date());
        template.setCreateUserId(String.valueOf(userId));

        String checkResult = checkDto(template, true);
        if (StringUtils.isNotBlank(checkResult)) {
            throw new GwValidateException(checkResult);
        }

        int count = templateMapper.countById(template.getId());
        if (count > 0) {
            templateMapper.updateByPrimaryKeySelective(template);
        } else {
            templateMapper.insertSelective(template);
        }
        return template.getId();
    }

    @Override
    public String updateOne(TaskTranslateTemplateDTO dto, long userId) throws Exception {
        TbTaskTranslateTemplate template = convertDtoToEntity(dto);
        template.setUpdateTime(new Date());
        template.setUpdateUserId(String.valueOf(userId));
        String checkResult = checkDto(template, true);
        if (StringUtils.isNotBlank(checkResult)) {
            throw new GwValidateException(checkResult);
        }
        templateMapper.updateByPrimaryKey(template);
        return template.getId();
    }

    @Override
    public void deleteOne(String templateId) throws Exception {
        GutilAssert.isTrue(StringUtils.isNotBlank(templateId), "parameter 'templateId' must not be null or empty.");

        int count = templateMapper.countById(templateId);
        if (count > 0) {
            templateMapper.deleteByPrimaryKey(templateId);
        } else {
            throw new GwValidateException("任务转换模板不存在");
        }
    }

    private String checkDto(TbTaskTranslateTemplate template, boolean checkPrimaryKey) {
        StringBuilder sb = new StringBuilder();
        if (checkPrimaryKey) {
            if (StringUtils.isEmpty(template.getId())) {
                sb.append(" 模板ID不能为空。 ");
            }
        }
        if (template.getTranslateType() == null) {
            sb.append(" 转换内容不能为空。 ");
        }
        if (template.getTranslateType() < 1 || template.getTranslateType() > 3) {
            sb.append(" 转换内容不正确据。 ");
        }
        if (StringUtils.isEmpty(template.getTargetTaskId())) {
            sb.append(" 目标任务编号不能为空。 ");
        }
//        if (StringUtils.isEmpty(template.getTargetTaskName())) {
//            sb.append(" 目标任务名称不能为空。 ");
//        }

        return sb.toString();
    }

    private List<TaskTranslateTemplateDTO> convertEntityToDTO(List<TbTaskTranslateTemplate> templateList) {
        List<TaskTranslateTemplateDTO> result = new ArrayList<>();
        if (!GutilCollection.isEmpty(templateList)) {
            TaskTranslateTemplateDTO dto = null;
            for (TbTaskTranslateTemplate template : templateList) {
                dto = convertEntityToDTO(template);
                result.add(dto);
            }
        }
        return result;
    }

    private TaskTranslateTemplateDTO convertEntityToDTO(TbTaskTranslateTemplate template) {
        TaskTranslateTemplateDTO result = new TaskTranslateTemplateDTO();
        BeanUtil.copyProperties(template, result);
        if (StringUtils.isNotBlank(template.getCreateUserId())) {
            result.setCreateUserName(userNameService.getUserRealNameByUserId(template.getCreateUserId()));
        }
        return result;
    }

    private TbTaskTranslateTemplate convertDtoToEntity(TaskTranslateTemplateDTO dto) {
        TbTaskTranslateTemplate result = new TbTaskTranslateTemplate();
        BeanUtil.copyProperties(dto, result);
        return result;
    }

    @Override
    public boolean exist(String templateId) {
        return templateMapper.countById(templateId) > 0;
    }

    @Override
    public Map isTemplateNameExist(String templateName, long userId) {
        Map resultMap = new HashMap();
        resultMap.put("result", false);
        resultMap.put("isExist", false);
        resultMap.put("error", "");
        try {
            if (templateMapper.countByName(templateName) > 0) {
                resultMap.put("isExist", true);
            } else {
                resultMap.put("isExist", false);
            }
            resultMap.put("result", true);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            resultMap.put("result", false);
            resultMap.put("error", e.getMessage());
        }
        return resultMap;
    }

    @Override
    public void updateTemplateFinishStatus(String templateId, Short finish, long userId) {
        templateMapper.updateFinish(finish, templateId);
    }

    @Override
    public List<TaskTranslateTemplateDTO> findListByTargetTaskId(String targetTaskId, Integer pageNum, Integer pageSize, long userId) {
        GutilAssert.isTrue(StringUtils.isNotBlank(targetTaskId), "targetTaskId must not be null or empty.");
        GutilAssert.notNull(pageNum, "pageNum must not be null.");
        GutilAssert.isTrue(pageSize != null && pageSize > 0, "PageSize must not be null and must be a positive number.");

        PageHelper.startPage(pageNum, pageSize);
        List<TbTaskTranslateTemplate> templateList = null;
        templateList = templateMapper.queryByTargetTaskIdAndCreateUserIdOrScope(targetTaskId, String.valueOf(userId), "1");

        return convertEntityToDTO(templateList);
    }

    @Override
    public List<TaskTranslateTemplateDTO> findListByTargetTaskId(String targetTaskId, Integer pageNum, Integer pageSize, long userId,Integer templateType) {
        GutilAssert.isTrue(StringUtils.isNotBlank(targetTaskId), "targetTaskId must not be null or empty.");
        GutilAssert.notNull(pageNum, "pageNum must not be null.");
        GutilAssert.isTrue(pageSize != null && pageSize > 0, "PageSize must not be null and must be a positive number.");

        PageHelper.startPage(pageNum, pageSize);
        List<TbTaskTranslateTemplate> templateList = null;
        templateList = templateMapper.queryByTargetTaskIdAndCreateUserIdOrScope2(targetTaskId, String.valueOf(userId), "1", templateType);

        return convertEntityToDTO(templateList);
    }

    @Override
    public List<TaskTranslateTemplateDTO> findListByTargetTaskId(String sourceTaskId,String targetTaskId,long userId,Integer templateType) {

        List<TbTaskTranslateTemplate> templateList = null;
        templateList = templateMapper.queryByTargetTaskIdAndCreateUserIdOrScope3(sourceTaskId,targetTaskId, String.valueOf(userId), "1", templateType);

        return convertEntityToDTO(templateList);
    }
}
