package com.geoway.landteam.landcloud.service.customtask.thirdData;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.customtask.dao.pub.TbExchangeFieldRelDao;
import com.geoway.landteam.customtask.pub.entity.TbExchangeFieldRel;
import com.geoway.landteam.customtask.repository.task.TbtskObjectinfoRepository;
import com.geoway.landteam.customtask.repository.task.TskTaskBizRepository;
import com.geoway.landteam.customtask.task.entity.TbtskApproveRecord;
import com.geoway.landteam.customtask.task.entity.TbtskObjectinfo;
import com.geoway.landteam.customtask.task.entity.TskTaskBiz;
import com.geoway.landteam.landcloud.common.util.base.FileUtil;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.core.model.pub.entity.SysConfig;
import com.geoway.landteam.landcloud.core.servface.base.SysConfigService;
import com.geoway.landteam.landcloud.servface.customtask.thirdData.WpzfService;
import com.geoway.landteam.landcloud.service.datatransfer.support.ExportDataUtils;
import com.geoway.landteam.landcloud.service.networkTransmission.utils.HttpUtil;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

import javax.json.JsonObject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * @Author Waves
 * @Date 2023/8/12
 * @Description
 **/
@Service
public class WpzfServiceImpl implements WpzfService {

    GiLoger logger = GwLoger.getLoger(WpzfServiceImpl.class);
    @Value("${project.uploadDir}")
    protected String uploadDir;
    @Autowired
    TbExchangeFieldRelDao tbExchangeFieldRelDao;
    @Autowired
    protected TskTaskBizRepository tskTaskBizRepository;
    @Autowired
    protected TbtskObjectinfoRepository tbtskObjectinfoRepository;
    @Autowired
    SysConfigService sysConfigService;
    @Autowired
    JdbcTemplate jdbcTemplate;
    @Override
    public void sendTask(List<String> idList) throws Exception {

        String tablename = Optional.ofNullable("wpzf")
                .map(sysConfigService::findOne)
                .map(SysConfig::getValue)
                .map(tskTaskBizRepository::findById)
                .map(e-> e.<RuntimeException>orElseThrow(RuntimeException::new))
                .map(TskTaskBiz::getTableId)
                .map(tbtskObjectinfoRepository::findById)
                .map(e-> e.<RuntimeException>orElseThrow(RuntimeException::new))
                .map(TbtskObjectinfo::getfTablename)
                .orElseThrow(()-> new RuntimeException("无效的任务表"));
        //改了好几次不想改了
        List<TbExchangeFieldRel> rels = tbExchangeFieldRelDao.getRelListByConfigid("ab002");
        String sql = "select * from " + tablename + " where f_id in ('"+String.join("','",idList)+"')";
        List<Map<String, Object>> tbs = jdbcTemplate.queryForList(sql);//.map(TbExchangeFieldRel::getOutFieldName)
        Map<String,String> fields = rels.stream().collect(Collectors.toMap(TbExchangeFieldRel::getInFieldName,TbExchangeFieldRel::getOutFieldName));
        String tempdb = createDbtemplate();
        File temp = new File(tempdb);
        SqlliteConnTool connTool = new SqlliteConnTool(tempdb);
        Connection conn = connTool.getConnection();
        conn.setAutoCommit(false);
        insert(conn,tbs,fields,"tbtsk_task");
        connTool.Dispose();
        JSONObject config = sysConfigService.findToJson("transferConfig");
        String appkey = config.getString("wpzfKey");
        String moudle = config.getString("taskMoudle");
        String url = config.getString("url");
        HttpUtil.sendRrquestByFile( appkey,moudle , temp, url);
        temp.delete();
    }
    @Override
    public void pushWpzfReject(TbtskApproveRecord record){
        String tempdb = null;
        File temp = null;
        PreparedStatement pre =null;
        SqlliteConnTool connTool = null;
        try {
            //非定制任务跳过
            String customid = Optional.ofNullable("wpzfCustomId")
                    .map(sysConfigService::findOne)
                    .map(SysConfig::getValue)
                    .orElse(null);
            if(StringUtils.isBlank(customid) || !customid.contains(record.getTaskid())){
                return;
            }
            //初始化参数
            tempdb = createApprovedDbtemplate();
            SimpleDateFormat sdf = new SimpleDateFormat("YYYY-MM-dd HH:mm:ss");

            String tableName = Optional.of(record.getTaskid())
                    .map(tskTaskBizRepository::findById)
                    .map(e-> e.<RuntimeException>orElseThrow(RuntimeException::new))
                    .map(TskTaskBiz::getTableId)
                    .map(tbtskObjectinfoRepository::findById)
                    .map(e-> e.<RuntimeException>orElseThrow(RuntimeException::new))
                    .map(TbtskObjectinfo::getfTablename)
                    .orElseThrow(()-> new RuntimeException("无效的任务表"));
            String wpzfid = Optional.ofNullable("wpzf")
                    .map(sysConfigService::findOne)
                    .map(SysConfig::getValue)
                    .orElse("");
            String shlx = "jcjgwtcz";
            String idField = "f_tbbsm";
            if(wpzfid.equals(record.getTaskid())){
                shlx = "jcjgdk_dktb";
                idField = "f_dkbsm";
            }
            Map<String,Object> data = null;
            try{
                String sql = String.format("select %s,f_gzly from %s where f_id = '%s';",idField,tableName,record.getTbid());
                data = jdbcTemplate.queryForMap(sql);
            }catch (Exception e){
                String sql = String.format("select %s,f_gzly from %s where f_id = '%s';",idField,tableName+"_child",record.getTbid());
                data = jdbcTemplate.queryForMap(sql);
            }
            String tbbsm = (String)data.get(idField);
            String gzly = (String)data.get("f_gzly");

            temp = new File(tempdb);
            connTool = new SqlliteConnTool(tempdb);
            Connection conn = connTool.getConnection();
            conn.setAutoCommit(false);
            String insertSql = "INSERT INTO approve_record(f_id, f_tbbsm, f_approvetime, f_content, f_stepname, f_approveuser, f_audittype, f_status, f_gzly) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?);";
            pre = conn.prepareStatement(insertSql);
            pre.setString(1,record.getTbid());
            pre.setString(2,tbbsm);
            pre.setString(3,sdf.format(new Date()));
            pre.setString(4,record.getRemark());
            pre.setString(5,"市级审核");
            pre.setString(6,record.getApproveUser());
            pre.setString(7,shlx);
            pre.setString(8,record.getOption() == 1?"通过":"不通过");
            pre.setString(9,gzly);
            pre.addBatch();
            pre.executeBatch();
            conn.commit();
            pre.clearBatch();
            pre.close();

            connTool.Dispose();

            JSONObject config = sysConfigService.findToJson("transferConfig");
            String appkey = config.getString("wpzfKey");
            String moudle = config.getString("approveMoudle");
            String url = config.getString("url");
            HttpUtil.sendRrquestByFile( appkey,moudle , temp, url);

        }catch (Exception e){
            logger.warn("审核推送失败",e);
        }finally {
            try {
                if(pre !=null){
                    pre.close();
                }
                if(connTool != null ){
                    connTool.Dispose();
                }
                if(temp != null && temp.exists()){
                    temp.delete();
                }
            }catch (Exception e){
                logger.warn(e);
            }
        }
    }
    @Override
    public void pushWpzfReject(String tbid, String taskid, String userName, String remark){
        String tempdb = null;
        File temp = null;
        PreparedStatement pre =null;
        SqlliteConnTool connTool = null;
        try {
            String customid = Optional.ofNullable("wpzfCustomId")
                    .map(sysConfigService::findOne)
                    .map(SysConfig::getValue)
                    .orElse(null);
            if(StringUtils.isBlank(customid) || !customid.contains(taskid)){
                return;
            }
            tempdb = createApprovedDbtemplate();
            SimpleDateFormat sdf = new SimpleDateFormat("YYYY-MM-dd HH:mm:ss");

            String tableName = Optional.of(taskid)
                    .map(tskTaskBizRepository::findById)
                    .map(e-> e.<RuntimeException>orElseThrow(RuntimeException::new))
                    .map(TskTaskBiz::getTableId)
                    .map(tbtskObjectinfoRepository::findById)
                    .map(e-> e.<RuntimeException>orElseThrow(RuntimeException::new))
                    .map(TbtskObjectinfo::getfTablename)
                    .orElseThrow(()-> new RuntimeException("无效的任务表"));

            String wpzfid = Optional.ofNullable("wpzf")
                    .map(sysConfigService::findOne)
                    .map(SysConfig::getValue)
                    .orElse("");
            String shlx = "jcjgwtcz";
            String idField = "f_tbbsm";
            if(wpzfid.equals(taskid)){
                shlx = "jcjgdk_dktb";
                idField = "f_dkbsm";
            }
            Map<String,Object> data = null;
            try{
                String sql = String.format("select %s,f_gzly from %s where f_id = '%s';",idField,tableName,tbid);
                data = jdbcTemplate.queryForMap(sql);
            }catch (Exception e){
                String sql = String.format("select %s,f_gzly from %s where f_id = '%s';",idField,tableName+"_child",tbid);
                data = jdbcTemplate.queryForMap(sql);
            }
            String tbbsm = (String)data.get(idField);
            String gzly = (String)data.get("f_gzly");
            temp = new File(tempdb);
            connTool = new SqlliteConnTool(tempdb);
            Connection conn = connTool.getConnection();
            conn.setAutoCommit(false);
            String insertSql = "INSERT INTO approve_record(f_id, f_tbbsm, f_approvetime, f_content, f_stepname, f_approveuser, f_audittype, f_status, f_gzly) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?);";
            pre = conn.prepareStatement(insertSql);
            pre.setString(1,tbid);
            pre.setString(2,tbbsm);
            pre.setString(3,sdf.format(new Date()));
            pre.setString(4,remark);
            pre.setString(5,"市级审核");
            pre.setString(6,userName);
            pre.setString(7,shlx);
            pre.setString(8,"不通过");
            pre.setString(9,gzly);
            pre.addBatch();
            pre.executeBatch();
            conn.commit();
            pre.clearBatch();
            pre.close();

            connTool.Dispose();

            JSONObject config = sysConfigService.findToJson("transferConfig");
            String appkey = config.getString("wpzfKey");
            String moudle = config.getString("approveMoudle");
            String url = config.getString("url");
            HttpUtil.sendRrquestByFile( appkey,moudle , temp, url);

        }catch (Exception e){
            logger.warn("审核推送失败",e);
        }finally {
            try {
                if(pre !=null){
                    pre.close();
                }
                if(connTool != null ){
                    connTool.Dispose();
                }
                if(temp != null && temp.exists()){
                    temp.delete();
                }
            }catch (Exception e){
                logger.warn(e);
            }
        }
    }

    private void insert(Connection conn,List<Map<String, Object>> mapList,Map<String,String> fields,String tablename) throws Exception{

        List<String> inFields = fields.entrySet().stream().map(Map.Entry::getKey).collect(Collectors.toList());
        List<String> outFields = fields.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toList());
        String insertSql = "INSERT INTO " + tablename + " (" +  getInsertFields(outFields) +") ";
        insertSql += " VALUES (" + getQuestionMark(outFields) + ")";
        PreparedStatement pre = conn.prepareStatement(insertSql);

        for (int i = 0; i < mapList.size(); i++) {
            Map<String, Object> map = mapList.get(i);
            for (int j = 0; j < fields.size(); j++) {
                ExportDataUtils.setStringData(pre, map, inFields.get(j), j + 1);
            }
            pre.addBatch();
        }
        pre.executeBatch();
        pre.clearBatch();
        conn.commit();
        pre.close();
    }

    private String createDbtemplate() throws IOException {

        String destFileName = "";
        String srcFileName = "";
        try {
            FileUtil.creatDirectoryIfNotExist(this.uploadDir);
            ClassPathResource meta = new ClassPathResource("/static/wpzftask.db");
            InputStream simheiinputStream = meta.getInputStream();
            File metaFile = File.createTempFile("wpzf"+System.currentTimeMillis(), ".db");
            FileUtils.copyInputStreamToFile(simheiinputStream, metaFile);

            destFileName = new StringBuilder()
                    .append(this.uploadDir)
                    .append(File.separator)
                    .append("wpzftask"+System.currentTimeMillis()+".db")
                    .toString();
            FileUtils.copyFile(metaFile, new File(destFileName));
        } catch (IOException e) {
            throw e;
        }
        return destFileName;
    }
    /**
     * 创建insert sql字段名String
     * @param fields
     * @return
     */
    public static String getInsertFields(List<String> fields) {
        String result = "";
        for (int i = 0; i < fields.size(); i++) {
            result += "'" + fields.get(i) + "'";
            if (i != fields.size() - 1) {
                result += ",";
            }
        }
        return result;
    }

    /**
     * 创建？
     * @param fields
     * @return
     */
    public static String getQuestionMark(List<String> fields) {
        String result = "";
        for (int i = 0; i < fields.size(); i++) {
            result += "?";
            if (i != fields.size() - 1) {
                result += ",";
            }
        }
        return result;
    }

    /**
     *
     * @param pre
     * @param map
     * @param key
     * @param index
     * @throws SQLException
     */
    public static void setStringData(PreparedStatement pre, Map<String, Object> map, String key, int index) throws SQLException {
        if (null == map.get(key)) {
            pre.setString(index, null);
        } else {
            pre.setString(index, map.get(key).toString());
        }
    }

    private String createApprovedDbtemplate() throws IOException {

        String destFileName = "";
        try {
            FileUtil.creatDirectoryIfNotExist(this.uploadDir);
            ClassPathResource meta = new ClassPathResource("/static/wpzfapprove.db");
            InputStream inputStream = meta.getInputStream();
            destFileName = new StringBuilder()
                    .append(this.uploadDir)
                    .append(File.separator)
                    .append("wpzfapprove"+System.currentTimeMillis()+".db")
                    .toString();
            FileUtils.copyInputStreamToFile(inputStream, new File(destFileName));

        } catch (IOException e) {
            throw e;
        }
        return destFileName;
    }
}
