package com.geoway.landteam.landcloud.service.customtask.thread;


import com.geoway.landteam.customtask.pub.dto.DataDownloadRecord;
import com.geoway.landteam.customtask.pub.dto.DownloadParameter;
import com.geoway.landteam.customtask.pub.entity.TaskRecord;

import com.geoway.landteam.customtask.servface.pub.DataDownloadDailyTaskService;
import com.geoway.landteam.landcloud.service.customtask.pub.impl.MDataDownloadTakeHandService;
import com.geoway.landteam.landcloud.service.customtask.task.MTaskRecordService;
import com.gw.base.log.GwLoger;
import com.gw.base.log.GiLoger;

import java.util.Date;

/**
 * @Author: zkn
 * @Date: 2020/7/2 14:26
 * @Description:
 */
public class MDownloadAttachThread implements Runnable {
    private static final String TAKE_HAND_TASK_ID = "ssp";
    String taskId;
    DownloadParameter downlaodParamter;
    DataDownloadRecord record;
    MDataDownloadTakeHandService dataDownloadTakeHandService;
    DataDownloadDailyTaskService dataDownloadDailyTaskService;
    MTaskRecordService taskRecordService;
    private final GiLoger logger = GwLoger.getLoger(MDownloadAttachThread.class);

    public MDownloadAttachThread(String taskId, DownloadParameter downlaodParamter, DataDownloadRecord record,
                                 MDataDownloadTakeHandService sspDownloadService, DataDownloadDailyTaskService dailyTaskDownloadService,
                                 MTaskRecordService taskRecordService) {
        this.taskId = taskId;
        this.downlaodParamter = downlaodParamter;
        this.record = record;
        this.dataDownloadTakeHandService = sspDownloadService;
        this.dataDownloadDailyTaskService = dailyTaskDownloadService;
        this.taskRecordService = taskRecordService;
    }

    @Override
    public void run() {
        try {
            TaskRecord taskRecord = taskRecordService.findOne(downlaodParamter.getRecordId());
            if (taskRecord != null) {
                taskRecord.setState(2);
                taskRecord.setThreadstarttime(new Date());
                taskRecordService.save(taskRecord);
            }
            doDownload();
            taskRecord = taskRecordService.findOne(downlaodParamter.getRecordId());
            if (taskRecord != null) {
                taskRecord.setState(3);
                taskRecord.setEndtime(new Date());
                taskRecordService.save(taskRecord);
            }
        } catch (Exception e) {
            logger.error(e);
        }
    }

    protected void doDownload() throws Exception {
        if (taskId.equalsIgnoreCase(TAKE_HAND_TASK_ID)) {
            logger.debug("随手拍下载数据开始处理");
            dataDownloadTakeHandService.downloadTakeHandAttach(downlaodParamter.getTbIds(), downlaodParamter.getTbNames(), downlaodParamter.getUserId(), record);
        } else {
            logger.debug("日常任务下载数据开始处理");
            dataDownloadDailyTaskService.downloadDailyTaskAttach(taskId, downlaodParamter.getTbIds(), downlaodParamter.getUserId(), record, downlaodParamter.getDownloadType());
        }
    }
}
