package com.geoway.landteam.landcloud.service.customtask.thread;


import com.geoway.landteam.customtask.pub.dto.DownloadParameter;
import com.geoway.landteam.customtask.pub.entity.TaskRecord;
import com.geoway.landteam.customtask.service.pub.DownloadGeometryService;

import com.geoway.landteam.landcloud.service.customtask.task.MTaskRecordService;

import java.util.Date;

/**
 * @Author: zkn
 * @Date: 2020/7/2 14:28
 * @Description:
 */
public class MDownloadGeometryThread implements Runnable {

    DownloadGeometryService downloadGeometryService;
    DownloadParameter downloadParam;
    MTaskRecordService taskRecordService;

    public MDownloadGeometryThread(DownloadGeometryService downloadGeometryService, DownloadParameter downloadParam, MTaskRecordService taskRecordService) {
        this.downloadGeometryService = downloadGeometryService;
        this.downloadParam = downloadParam;
        this.taskRecordService = taskRecordService;
    }

    @Override
    public void run() {
        TaskRecord taskRecord = taskRecordService.findOne(downloadParam.getRecordId());
        if (taskRecord != null) {
            taskRecord.setState(2);
            taskRecord.setThreadstarttime(new Date());
            taskRecordService.save(taskRecord);
        }
        try {
            doDownload();
        } catch (Exception e) {
            e.printStackTrace();
        }
        taskRecord = taskRecordService.findOne(downloadParam.getRecordId());
        if (taskRecord != null) {
            taskRecord.setState(3);
            taskRecord.setEndtime(new Date());
            taskRecordService.save(taskRecord);
        }
    }

    private void doDownload() throws Exception {
        boolean initSuccess = downloadGeometryService.init(downloadParam);
        if (initSuccess) {
            downloadGeometryService.doDownload();
        }
    }


}
