package com.geoway.landteam.landcloud.service.customtask.thread;

import com.geoway.landteam.customtask.pub.dto.DataDownloadRecord;
import com.geoway.landteam.customtask.pub.entity.TaskRecord;

import com.geoway.landteam.customtask.servface.pub.DataDownloadZjdService;
import com.geoway.landteam.landcloud.service.customtask.task.MTaskRecordService;
import com.gw.base.log.GwLoger;
import com.gw.base.log.GiLoger;

import java.util.Date;

/**
 * @Author: zkn
 * @Date: 2020/7/2 15:02
 * @Description:
 */
public class MDownloadZjdThread implements Runnable {
    DataDownloadZjdService dataDownloadZjdService;
    String taskId;
    String tbIds;
    Long userId;
    DataDownloadRecord record;
    Integer downloadType;
    MTaskRecordService taskRecordService;

    private final GiLoger logger = GwLoger.getLoger(MDownloadZjdThread.class);

    public MDownloadZjdThread(DataDownloadZjdService dataDownloadZjdService, String taskId, String tbIds, Long userId, DataDownloadRecord record, Integer downloadType,
                              MTaskRecordService taskRecordService) {
        this.dataDownloadZjdService = dataDownloadZjdService;
        this.taskId = taskId;
        this.tbIds = tbIds;
        this.userId = userId;
        this.record = record;
        this.downloadType = downloadType;
        this.taskRecordService = taskRecordService;

    }

    @Override
    public void run() {
        doDownload();
    }

    private void doDownload() {
        try {
            TaskRecord taskRecord = taskRecordService.findOne(record.getId());
            if (taskRecord != null) {
                taskRecord.setState(2);
                taskRecord.setThreadstarttime(new Date());
                taskRecordService.save(taskRecord);
            }
            dataDownloadZjdService.doDownloadData(taskId, tbIds, userId, record, downloadType);
            taskRecord = taskRecordService.findOne(record.getId());
            if (taskRecord != null) {
                taskRecord.setState(3);
                taskRecord.setEndtime(new Date());
                taskRecordService.save(taskRecord);
            }
        } catch (Exception e) {
            logger.error(e.getMessage());
        }

    }
}
