package com.geoway.landteam.landcloud.service.datacq;

import com.alibaba.fastjson.JSONObject;
import com.geoway.landteam.cloudquery.model.pub.entity.CloudQuery;
import com.geoway.landteam.cloudquery.model.pub.entity.CloudQueryNode;
import com.geoway.landteam.cloudquery.repository.pub.CloudQueryNodeRepository;
import com.geoway.landteam.cloudquery.repository.pub.CloudQueryRepository;
import com.geoway.landteam.cloudquery.servface.pub.CloudQueryService;
import com.geoway.landteam.landcloud.common.util.orm.SqlliteConnTool;
import com.geoway.landteam.landcloud.core.model.base.entity.Region;
import com.geoway.landteam.landcloud.core.model.base.entity.RegionCorrect;
import com.geoway.landteam.landcloud.core.repository.base.AppMediaRepository;
import com.geoway.landteam.landcloud.core.servface.region.RegionCorrectService;
import com.geoway.landteam.landcloud.core.servface.region.RegionService;
import com.geoway.landteam.landcloud.core.service.base.DefaultOssOperatorService;
import com.geoway.landteam.landcloud.core.service.base.TemporarySignedUrlService;
import com.geoway.landteam.landcloud.model.datacq.analyze.*;
import com.geoway.landteam.landcloud.service.thirddata.utils.PdfAnalyzeUtil;
import com.gw.base.log.GiLoger;
import com.gw.base.log.GwLoger;
import com.itextpdf.text.*;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.util.Constants;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.io.*;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.List;

/**
 * Created by licong on 2021/1/15.
 */
@Service("CloudAnalyzeCQService")
@Transactional(rollbackFor = Exception.class)
public class CloudAnalyzeCQService {
    private GiLoger logger = GwLoger.getLoger(CloudAnalyzeCQService.class);
    @Autowired
    protected CloudQueryNodeRepository nodeRepository;
   /* @Value("#{imeSettings['project.downloadDir']}")*/
    @Value("${project.downloadDir}")
    String downloadDir;
    @Autowired
    CloudQueryRepository cloudQueryDao;
    @Autowired
    RegionCorrectService regionCorrectService;
    @Autowired
    RegionService regionService;
    @Autowired
    AppMediaRepository appMediaDao;
    @Autowired
    TemporarySignedUrlService temporarySignedUrlService;
    @Autowired
    DefaultOssOperatorService ossOperatorService;

    @Autowired
    CloudQueryService cloudQueryService;
    Font titleFont;

    Font chapterFont;

    Font sectionFont;

    Font normalFont;

    Font roleFont;

    Font redFont;

    Font greenFont;

    Font redItalicFont;

    float pgSpace = 18;
    float lineSpace = 16;
    float firstLineIndent = 24;

    public CloudAnalyzeCQService() throws IOException, DocumentException {
        ClassPathResource STSONG = new ClassPathResource("/static/STSONG.TTF");
        ClassPathResource simhei = new ClassPathResource("/static/simhei.ttf");
        ClassPathResource simkai = new ClassPathResource("/static/simkai.ttf");
        String pathClassPath = Constants.class.getClassLoader().getResource("").getPath();
       /* String rootPath = pathClassPath.substring(0, pathClassPath.indexOf("WEB-INF"));*/
        if (STSONG.exists()) {
            InputStream STSONGinputStream = STSONG.getInputStream();
            InputStream simheiinputStream = simhei.getInputStream();
            InputStream simkaiinputStream = simkai.getInputStream();
            //生成目标文件
            File STSONGFile = File.createTempFile("template_STSONG_copy", ".TTF");
            File simheiFile = File.createTempFile("template_simhei_copy", ".ttf");
            File simkaiFile = File.createTempFile("template_simkai_copy", ".ttf");
            try {
                FileUtils.copyInputStreamToFile(STSONGinputStream, STSONGFile);
                FileUtils.copyInputStreamToFile(simheiinputStream, simheiFile);
                FileUtils.copyInputStreamToFile(simkaiinputStream, simkaiFile);

                titleFont = new Font(BaseFont.createFont(simheiFile.getAbsolutePath(), BaseFont.IDENTITY_H, BaseFont.NOT_EMBEDDED,  BaseFont.NOT_CACHED, null, null), 16);
                titleFont.setStyle(Font.BOLD);

                chapterFont = new Font(BaseFont.createFont(simheiFile.getAbsolutePath(), BaseFont.IDENTITY_H, BaseFont.NOT_EMBEDDED, BaseFont.NOT_CACHED, null, null), 14);
                chapterFont.setStyle(Font.BOLD);

                sectionFont = new Font(BaseFont.createFont( simkaiFile.getAbsolutePath(), BaseFont.IDENTITY_H, BaseFont.NOT_EMBEDDED, BaseFont.NOT_CACHED, null, null), 12);
                sectionFont.setStyle(Font.BOLD);

                normalFont = new Font(BaseFont.createFont(  STSONGFile.getAbsolutePath(), BaseFont.IDENTITY_H, BaseFont.NOT_EMBEDDED, BaseFont.NOT_CACHED, null, null), 12);

                roleFont = new Font(BaseFont.createFont( simkaiFile.getAbsolutePath(), BaseFont.IDENTITY_H, BaseFont.NOT_EMBEDDED, BaseFont.NOT_CACHED, null, null), 10);

                redFont = new Font(BaseFont.createFont( simkaiFile.getAbsolutePath(), BaseFont.IDENTITY_H, BaseFont.NOT_EMBEDDED, BaseFont.NOT_CACHED, null, null), 12);
                redFont.setColor(255, 0, 0);

                greenFont = new Font(BaseFont.createFont( simkaiFile.getAbsolutePath(), BaseFont.IDENTITY_H, BaseFont.NOT_EMBEDDED, BaseFont.NOT_CACHED, null, null), 12);
                greenFont.setColor(0, 255, 0);

                redItalicFont = new Font(BaseFont.createFont( simkaiFile.getAbsolutePath(), BaseFont.IDENTITY_H, BaseFont.NOT_EMBEDDED, BaseFont.NOT_CACHED, null, null), 12);
                redItalicFont.setColor(255, 0, 0);
                redItalicFont.setStyle(Font.ITALIC);
            } finally {
                IOUtils.closeQuietly(STSONGinputStream,simheiinputStream,simkaiinputStream);
            }
        }
    }


    public void destory() {
        titleFont = null;
        chapterFont = null;
        sectionFont = null;
        normalFont = null;
        roleFont = null;
        redFont = null;
        greenFont = null;
    }


    public List<ProjectInfo> Parse(String requestId, String tbid, String userName, int analyzeType, String tag) throws Exception {
        List<CloudQuery> cloudQueryList = cloudQueryDao.findByRequestIdTag(requestId, analyzeType, tag);
        List<CloudQuery> templist = new ArrayList<>();
        if (cloudQueryList == null || cloudQueryList.size() < 1) {
            throw new RuntimeException("无查询结果");
        } else if (cloudQueryList.size() >= 1) {
            for(CloudQuery cq:cloudQueryList) {
                if(cq.getState().equals(1)||cq.getState().equals(2)) {
                   cq.setResult(cloudQueryService.getDBUrl(cq.getId(),cq.getNodeId()));
                    templist.add(cq);
                }
            }
        }
        List<ProjectInfo> result = new ArrayList<>();
        for (CloudQuery query : templist) {
            ProjectInfo info = new ProjectInfo();
            info.nodeRegion = this.getRegionByNode(query.getNodeId());
            if (info.lontitude == null || info.lontitude.isEmpty()) {
                String param = query.getParam();
                JSONObject detail = JSONObject.parseObject(param);
                if (detail.containsKey("lon")) {
                    info.lontitude = detail.get("lon").toString();
                }
                if (detail.containsKey("lat")) {
                    info.latitude = detail.get("lat").toString();
                }
                if (detail.containsKey("mj")) {
                    String mj = detail.get("mj").toString();
                    info.area = Double.parseDouble(mj) * 666.6666;
                }
                String lonStr = info.lontitude;
                String latStr = info.latitude;
                double lon = Double.parseDouble(lonStr);
                double lat = Double.parseDouble(latStr);
                RegionCorrect regionCorrect = regionCorrectService.getOfCoord(lon, lat);
                if (regionCorrect != null) {
                    String countyCode = regionCorrect.getId();
                    if (countyCode.length() == 6) {
                        //根据县代码获取省市县名称
                        String cityCode = countyCode.substring(0, 4) + "00";
                        String provinceCode = countyCode.substring(0, 2) + "0000";
                        Region county = regionService.findRegionByCode(countyCode);
                        Region city = regionService.findRegionByCode(cityCode);
                        Region province = regionService.findRegionByCode(provinceCode);
                        info.provinceCode = provinceCode;
                        info.cityCode = cityCode;
                        info.countyCode = countyCode;
                        info.location = query.getName();
                        if (province != null) {
                            info.provinceName = province.getName();
                        }
                        if (city != null) {
                            info.cityName = city.getName();
                            if ("500000".equals(province.getCode())) {//去除市辖区
                                info.logicCity = true;
                            }
                        }
                        if (county != null) {
                            info.countyName = county.getName();
                        }
                    }
                }
            }

            String url = query.getResult();
            /*
            if (url.indexOf("%3D") > -1) {
                url = url.replace("%3D", "=");
                url = url.split("\\?")[0];
            }
            url = temporarySignedUrlService.getTemporarySignedUrl("", url, null);
            */
            String[] paths = url.split("/");
            String fileName = paths[paths.length - 1]; // 保存的文件名称

            if (fileName.indexOf("?") > -1) {
                fileName = fileName.substring(0, fileName.indexOf("?"));
            }

            File lsFile = new File(downloadDir, fileName);
            if (!lsFile.exists()) {
                FileUtils.copyURLToFile(new URL(url), lsFile);
            }
            SqlliteConnTool dbHelper = new SqlliteConnTool(lsFile.getAbsolutePath());
            ArrayList<String> tables = dbHelper.getTables();
            if (tables == null || tables.size() == 0) {
                continue;
            }
            if (analyzeType != 0) {
                for (String table : tables) {
                    if ("1".equals(info.nodeRegion)) {
                        PdfAnalyzeUtil.Parse(dbHelper, table, info);
                    } else if ("500000".equals(info.nodeRegion)) {
                        PdfAnalyzeUtil.ParseCQ(dbHelper, table, info);
                    }
                }
//                break;
            } else {
                if (tables.contains("Image_Analyze"))//时序查询结果，里面包含了地类分析数据等
                {
                    for (String table : tables) {
                        String tn = table.toLowerCase();
                        System.out.println("table:" + tn);
                        switch (tn) {
                            case "image_analyze":
                                info.ownershipImgMeta = PdfAnalyzeUtil.GetImageMeta(dbHelper,
                                        "Image_Analyze");
                                break;
                        }

                    }
                } else {
                    for (String table : tables) {
                        PdfAnalyzeUtil.Parse(dbHelper, table, info);
                    }
                }
            }
            dbHelper.Dispose();
            result.add(info);
        }
        return result;
    }

    public Document createPdf(ProjectInfo info) throws DocumentException, FileNotFoundException {
        File file = new File(info.outFile);
        file.getParentFile().mkdirs();

        // 生成PDF文档
        Rectangle size = PageSize.A4;
        if (info.narrow) {
            size = PageSize.A5;
        }
        Rectangle rectPageSize = new Rectangle(size);
        //创建一个文档对象，设置初始化大小和页边距
        Document document = new Document(rectPageSize, 40, 40, 40, 40);// 上、下、左、右间距

        PdfWriter pdfWriter = PdfWriter.getInstance(document, new FileOutputStream(info.outFile));
        //设置行间距
        pdfWriter.setInitialLeading(30);
        document.open();
        return document;
    }

    public boolean ExportReport(List<ProjectInfo> infoList) throws DocumentException, IOException {
        Document document = null;
        try {
            ProjectInfo info = infoList.get(0);
            document= this.createPdf(info);

            document.addTitle("建设用地选址云分析报告");
            Paragraph title = new Paragraph(info.projectName + "建设用地选址云分析报告", titleFont);
            title.setAlignment(Element.ALIGN_CENTER);
            document.add(title);
            String content = "按照您勾绘的项目范围，依据国土调查云后台数据，生成的建设用地选址云分析报告如下。受数据齐全性、时效性和精度限制，本分析报告仅用于辅助参考，不具有法律效应。";
            this.addContent(content,document);

            ResultInfo result = new ResultInfo();
            BaseInfo(infoList, result,document);

            LegalAnalysis(infoList, result,document);

            SuitableAnalysis(infoList, result,document);

            SummarizeAnalysis(info, result,document);

            AddSign(info,document);

            document.close();
            return true;
        } catch (Exception ex) {
            System.out.println(ex.getMessage());
            if (document != null && document.isOpen()) {
                document.close();
            }
            return false;
        }
    }


    /**
     * 一、基本情况
     *
     * @param infoList
     * @param result
     * @throws DocumentException
     * @throws IOException
     */
    protected void BaseInfo(List<ProjectInfo> infoList, ResultInfo result,Document document) throws DocumentException, IOException {
        ProjectInfo info = this.getCountryNode(infoList);
        this.addFirstTitle("一、基本情况",document);
        String content = "%s项目位于%s%s%s%s（东经：%s°，北纬：%s°），项目地块面积%s平方米。";
        content = String.format(content, info.projectName, info.provinceName, (info.logicCity ? "" : info.cityName), info.countyName, info.villageName, info.lontitude, info.latitude, String.valueOf(PdfAnalyzeUtil.Round(info.area, 2)));
        String dlinfo = "";
        int lengLy = 0;
        int lengOw = 0;
        if (info.landTypes != null && info.landTypes.size() > 0) {
            lengLy = info.landTypes.size();
        }
        if (info.ownerships != null && info.ownerships.size() > 0) {
            lengOw = info.ownerships.size();
        }
        if (lengLy > 0) {
            dlinfo = "土地利用现状：";
            double otherArea = 0;
            int count = 0;
            for (LandType item : info.landTypes) {
                count++;
                if (count > 2) {
                    otherArea += item.area;
                } else {
                    dlinfo += item.dlmc + PdfAnalyzeUtil.Round(item.area, 2) + "平方米";
                    if (count < lengLy) {
                        dlinfo += "、";
                    }
                }

            }
            if (otherArea > 0) {
                dlinfo += ("其他" + PdfAnalyzeUtil.Round(otherArea, 2) + "平方米");
            }
            if (lengOw > 0) {
                dlinfo += "；";
            } else {
                dlinfo += "。";
            }
        }
        if (lengOw > 0) {
            dlinfo += "土地权属为";
            HashMap<String, Double> dic = new HashMap<String, Double>();
            dic.put("国有", 0.0);
            dic.put("集体", 0.0);
            dic.put("其他", 0.0);
            for (Ownership item : info.ownerships) {
                if (item.detail != null) {
                    dic.put("国有", dic.get("国有") + item.detail.lx10);
                    dic.put("国有", dic.get("国有") + item.detail.lx20);
                    dic.put("集体", dic.get("集体") + item.detail.lx30);
                    dic.put("集体", dic.get("集体") + item.detail.lx40);
                    dic.put("其他", dic.get("其他") + item.detail.lx99);
                }
            }
            if (PdfAnalyzeUtil.Round(dic.get("国有"), 2) > 0) {
                dlinfo += "国有" + PdfAnalyzeUtil.Round(dic.get("国有"), 2) + "平方米、";
            }
            if (PdfAnalyzeUtil.Round(dic.get("集体"), 2) > 0) {
                dlinfo += "集体" + PdfAnalyzeUtil.Round(dic.get("集体"), 2) + "平方米、";
            }
            if (PdfAnalyzeUtil.Round(dic.get("其他"), 2) > 0) {
                dlinfo += "其他" + PdfAnalyzeUtil.Round(dic.get("其他"), 2) + "平方米、";
            }
            if (dlinfo.endsWith("、")) {
                dlinfo = dlinfo.substring(0, dlinfo.length() - 1) + "。";
            }
        }

        content += dlinfo;
        this.addContent(content,document);

        //document.newPage();
        AddBaseImg(infoList,document);
    }

    /**
     * 合法性分析
     *
     * @param infoList
     * @param result
     * @throws DocumentException
     */
    protected void LegalAnalysis(List<ProjectInfo> infoList, ResultInfo result,Document document) throws DocumentException {
        ProjectInfo info = this.getCountryNode(infoList);
        ProjectInfo other = this.getOtherNode(infoList);
        this.addFirstTitle("二、合法性分析",document);
        this.addJbntMessage(result, info, other,document);
        this.addJbntDescribe("政策解读",document);
        this.addTdghMessage(result, info,document);
        this.addSpbaMessage(result, info,document);
        this.addZrbhqMessage(result, info, other, "(四)自然保护地情况分析",document);
        this.addZrbhqDescribe("政策解读",document);
        this.addSthxMessage(result, info, other, "(五)生态保护红线情况分析",document);
        this.addSthxDescribe("政策解读",document);

        if (info.cityCode.startsWith("50")) {
            //重庆数据处理
            this.addJsydgzqMessage(result, other,document);
            this.addCzkfbjMessage(result, other, "(七)城镇开发边界情况分析",document);
            this.addCzkfbjDescribe("政策解读",document);
        }
//        if (info.countyCode.equals("500155")) {
//            //梁平数据处理
//            this.addLpCzkfbjMessage(result, other);
//        }
        this.BzInfo(document);
    }

    /**
     * 建设用地管制区情况分析
     *
     * @param result
     * @param info
     * @throws DocumentException
     */
    protected void addJsydgzqMessage(ResultInfo result, ProjectInfo info,Document document) throws DocumentException {
        this.addSencondTitle("(六)建设用地情况分析",document);

        this.addJsgzqElement(info.jsydgzqArea, info.jsydgzqImg, info.area, "基于重庆建设用地数据分析：", info.jsydInfos,document);
        if (info.jsydInfos != null) {
            result.passJsydgzq = EnumAnalyzeResult.AllPass;
            for (int i = 0; i < info.jsydInfos.size(); i++) {
                if ("040".equals(info.jsydInfos.get(i).type)) {
                    result.passJsydgzq = EnumAnalyzeResult.NoPass;
                    break;
                }
            }
        }
//        if (info.countyCode.startsWith("500155")) {
//            this.addJsgzqElement(info.lpjsydgzqArea, info.lpjsydgzqImg, info.area, "基于梁平建设用地数据分析：", info.lpjsydInfos);
//            if (info.lpjsydInfos != null) {
//                result.passJsydgzq = EnumAnalyzeResult.AllPass;
//                for (int i = 0; i < info.lpjsydInfos.size(); i++) {
//                    if (!"农村居民点".equals(info.lpjsydInfos.get(i).type) && !"城镇用地".equals(info.lpjsydInfos.get(i).type)) {
//                        result.passJsydgzq = EnumAnalyzeResult.NoPass;
//                        break;
//                    }
//                }
//            }
//        }
        AddRoleDesc("《土地利用总体规划管理办法》第三十三条 土地利用总体规划划定的城乡建设用地管制边界和管制区域，必须严格执行，未经依法批准，不得擅自突破。", "政策解读",document);
        AddRoleDesc("需要使用土地的城、镇、村和工矿建设项目，应当在允许建设区内安排建设用地。", null,document);
        AddRoleDesc("严禁在限制建设区和禁止建设区内安排城镇建设项目。交通、能源、水利、军事、国家安全、矿山和其他因生态环境保护要求确需在限制建设区和禁止建设区内单独选址的建设项目，必须经依法批准。", null,document);
    }

    protected void addJsgzqElement(Double area, Image img, Double allArea, String text, List<CommonInfoCQ> jsydInfos,Document document) throws DocumentException {
        String desc = text;
        if (area != null) {
            desc += "拟建设项目区涉及建设用地。";
        } else {
            desc += "拟建设项目区不涉及建设用地。";
        }
        this.addContent(desc,document);

        if (img != null) {
            String desc2 = "建设用地管制区：";
            for (int i = 0; i < jsydInfos.size(); i++) {
                String type = jsydInfos.get(i).type;
                Double typeArea = jsydInfos.get(i).area;
                desc2 += type + ":" + PdfAnalyzeUtil.Round(typeArea, 2) + "平方米，";
            }
            desc2 += "非建设用地管制区：" + PdfAnalyzeUtil.Round((allArea - area), 2) + "平方米";
            AddImg("建设用地管制区", img, desc2,document);
        }
    }

    /**
     * 梁平乡镇开发边界
     *
     * @param result
     * @param info
     * @throws DocumentException
     */
    protected void addCzkfbjMessage(ResultInfo result, ProjectInfo info, String title,Document document) throws DocumentException {
        if (null != title)
            this.addSencondTitle(title,document);

        String czkfDesc = "基于重庆城镇开发边界分析：";
        if (info.czkfImg != null) {
//            result.passCzkfbj = EnumAnalyzeResult.NoPass;
            czkfDesc += "拟建设项目区涉及城镇开发边界" + PdfAnalyzeUtil.Round(info.czkfArea, 2) + "平方米。";
        } else {
//            result.passCzkfbj =EnumAnalyzeResult.AllPass;
            czkfDesc += "拟建设项目区不涉及城镇开发边界。";
        }
        this.addContent(czkfDesc,document);

        if (info.czkfImg != null) {
            String desc = "涉及城镇开发边界：" + PdfAnalyzeUtil.Round(info.czkfArea, 2) + "平方米";
            AddImg("城镇开发边界", info.czkfImg, desc,document);
        }
    }

    protected void addCzkfbjDescribe(String role,Document document) throws DocumentException {
        AddRoleDesc("《关于在国土空间规划中统筹划定落实三条控制线的指导意见》第六条 按照集约适度、绿色发展要求划定城镇开发边界。" +
                "城镇开发边界是在一定时期内因城镇发展需要，可以集中进行城镇开发建设、以城镇功能为主的区域边界，涉及城市、建制镇以及各类开发区等。" +
                "城镇开发边界划定以城镇开发建设现状为基础，综合考虑资源承载能力、人口分布、经济布局、城乡统筹、城镇发展阶段和发展潜力，" +
                "框定总量，限定容量，防止城镇无序蔓延。科学预留一定比例的留白区，为未来发展留有开发空间。城镇建设和发展不得违法违规侵占河道、" +
                "湖面、滩地。", role,document);
    }

    /**
     * 添加生态红线数据
     *
     * @param result
     * @param info
     * @throws DocumentException
     */
    protected void addSthxMessage(ResultInfo result, ProjectInfo info, ProjectInfo other, String title,Document document) throws DocumentException {
        if (title != null)
            this.addSencondTitle(title,document);

        ProjectInfo temp = null;
        String zrbhqDesc = "";
        if (other.provinceCode.startsWith("50")) {
            temp = other;
            zrbhqDesc = "基于重庆生态保护红线数据分析：";
        } else {
            temp = info;
            zrbhqDesc = "基于国家生态保护红线数据分析：";
        }
        addSthxElement(temp.sthxArea, temp.sthxImg, temp.area, zrbhqDesc, result,document);
//        if (info.countyCode.startsWith("500155")) {
//            addSthxElement(info.lpsthxArea, info.lpsthxImg, info.area, "基于梁平生态保护红线数据分析：", result);
//        }
    }

    protected void addSthxDescribe(String role,Document document) throws DocumentException {
        AddRoleDesc("《关于划定并严守生态保护红线的若干意见》第八条 生态保护红线划定后，相关规划要符合生态保护红线空间管控要求，" +
                "不符合的要及时进行调整。空间规划编制要将生态保护红线作为重要基础，发挥生态保护红线对于国土空间开发的底线作用。", role,document);
        AddRoleDesc("《关于划定并严守生态保护红线的若干意见》第九条 生态保护红线原则上按禁止开发区域的要求进行管理。" +
                "严禁不符合主体功能定位的各类开发活动，严禁任意改变用途。生态保护红线划定后，只能增加、不能减少，" +
                "因国家重大基础设施、重大民生保障项目建设等需要调整的，由省级政府组织论证，提出调整方案，" +
                "经环境保护部、国家发展改革委会同有关部门提出审核意见后，报国务院批准。因国家重大战略资源勘查需要，" +
                "在不影响主体功能定位的前提下，经依法批准后予以安排勘查项目。", null,document);
    }

    protected void addSthxElement(Double area, Image img, Double allArea, String text, ResultInfo result,Document document) throws DocumentException {
        String desc1 = text;
        if (area != null && area > 0) {
            result.passSthx = EnumAnalyzeResult.NoPass;
            if (area < allArea) {
                result.passSthx = EnumAnalyzeResult.PartPass;
            }
            desc1 += "拟建设项目区涉及生态保护红线" + PdfAnalyzeUtil.Round(area, 2) + "平方米。";
        } else {
            result.passSthx = EnumAnalyzeResult.AllPass;
            desc1 += "拟建设项目区不涉及生态保护红线。";
        }
        this.addContent(desc1,document);
        if (img != null) {
            String desc = "生态保护红线：" + PdfAnalyzeUtil.Round(area, 2) + "平方米";
            AddImg("生态保护红线", img, desc,document);
        }
    }

    /**
     * 自然保护地情况分析
     *
     * @param result
     * @param info
     * @throws DocumentException
     */
    protected void addZrbhqMessage(ResultInfo result, ProjectInfo info, ProjectInfo other, String title,Document document) throws DocumentException {
        this.addSencondTitle(title,document);
        ProjectInfo temp = null;
        String zrbhqDesc = "";
        if (info.provinceCode.startsWith("50")) {
            temp = other;
            zrbhqDesc = "基于重庆自然保护地数据分析：";
        } else {
            temp = info;
            zrbhqDesc = "基于国家自然保护地数据分析：";
        }

        if (null != temp.zrbhqArea && temp.zrbhqArea > 0) {
            result.passZrbhq = EnumAnalyzeResult.NoPass;
            if (temp.zrbhqArea < temp.area) {
                result.passZrbhq = EnumAnalyzeResult.PartPass;
            }
            zrbhqDesc += "拟建设项目区涉及自然保护地，共 " + PdfAnalyzeUtil.Round(temp.zrbhqArea, 2) + "平方米";
        } else {
            result.passZrbhq = EnumAnalyzeResult.AllPass;
            zrbhqDesc += "拟建设项目区不涉及自然保护地。";
        }
        this.addContent(zrbhqDesc,document);

        if (temp.zrbhqImg != null) {
            String desc = "自然保护地：" + PdfAnalyzeUtil.Round(temp.zrbhqArea, 2) + "平方米，非自然保护地：" + PdfAnalyzeUtil.Round((temp.area - temp.zrbhqArea), 2) + "平方米";
            AddImg("自然保护用地", temp.zrbhqImg, desc,document);
        }
    }

    protected void addZrbhqDescribe(String role,Document document) throws DocumentException {
        AddRoleDesc("《自然保护区土地管理办法》第十五条 自然保护区内土地的使用，不得违反有关环境和资源保护法律的规定。", role,document);
        AddRoleDesc("依法使用自然保护区内土地的单位和个人必须严格按照土地登记和土地证书规定的用途使用土地，并严格遵守有关法律的规定。" +
                "改变用途时，需事先征求环境保护及有关自然保护区行政主管部门的意见，由县级以上人民政府土地管理行政主管部门审查，报县级以上人民政府批准。", null,document);

    }

    /**
     * 建设用地审批情况分析
     *
     * @param result
     * @param info
     * @throws DocumentException
     */
    protected void addSpbaMessage(ResultInfo result, ProjectInfo info,Document document) throws DocumentException {
        this.addSencondTitle("(三)建设用地审批情况分析",document);

        String spbaResult = "基于国家用地审批情况数据分析：";
        double spbaArea = 0;
        if (info.spbaInfos != null && info.spbaInfos.size() > 0) {
            String license = "";
            int count = 0;
            for (SpbaInfo sp : info.spbaInfos) {
                count++;
                spbaArea += sp.area;
                license += sp.license;
                if (count < info.spbaInfos.size()) {
                    license += "、";
                }
            }
            result.passSpba = EnumAnalyzeResult.NoPass;
            if (spbaArea > 0) {
                if (spbaArea < info.area) {
                    result.passSpba = EnumAnalyzeResult.PartPass;
                    spbaResult += "拟建设项目区有部分审批备案信息。";
                } else {
                    result.passSpba = EnumAnalyzeResult.AllPass;
                    spbaResult += "拟建设项目区有审批备案信息。";
                }
                if (license != null && !license.isEmpty()) {
                    spbaResult += "备案号为：" + license;
                }
            } else {
                result.passSpba = EnumAnalyzeResult.NoPass;
                spbaResult += "拟建设项目区无审批备案信息。";
            }
        } else {
            result.passSpba = EnumAnalyzeResult.NoPass;
            spbaResult += "拟建设项目区无审批备案信息。";
        }
        this.addContent(spbaResult,document);

        if (info.spbaImg != null) {
            String desc = "有审批：" + PdfAnalyzeUtil.Round(spbaArea, 2) + "平方米，无审批：" + PdfAnalyzeUtil.Round((info.area - spbaArea), 2) + "平方米";
            AddImg("用地审批", info.spbaImg, desc,document);
        }
        AddRoleDesc("《中华人民共和国土地管理法》第四十四条 建设占土地，涉及农用地转为建设用地的，应当办理农用地转用审批手续。", "政策解读",document);
        AddRoleDesc("永久基本农田转为建设用地的，由国务院审批。", null,document);
        AddRoleDesc("在土地利用总体规划确定的城市和村庄、集镇建设用地规模范围内，未实施该规定而将永久基本农田以外的农用地转为建设用地的，按土地利用年度计划分批次按照国务院规定由原审批土地利用总体规划的机关单位或者其授权的机关审批。在已批准的农用地转用范围内，具体建设项目用地可以由市、县人民政府批准。", null,document);
        AddRoleDesc("第四十六条 征收下列土地的，由国务院批准：", null,document);
        AddRoleDesc("（一）永久基本农田；", null,document);
        AddRoleDesc("（二）永久基本农田以外的耕地超过三十五公顷的；", null,document);
        AddRoleDesc("（三）其他土地超过七十公顷的。", null,document);
        AddRoleDesc("征收前款规定以外的土地的，由省、自治区、直辖市人民政府审批。", null,document);
        AddRoleDesc("征收农用地的，应当依照本法第四十四条的规定先行办理农用地转用审批。其中，经国务院批准农用地转用的，同时办理征地审批手续，不再另行办理征地审批；经省、自治区、直辖市人民政府在征地批准权限内批准农用地转用的，同时办理征地审批手续，不再另行办理征地审批，超过征地批准权限的，应当依照本条第一款的规定另行办理征地审批。", null,document);
    }

    /**
     * 土地利用总体规划情况分析
     *
     * @param result
     * @param info
     * @throws DocumentException
     */
    protected void addTdghMessage(ResultInfo result, ProjectInfo info,Document document) throws DocumentException {
        this.addSencondTitle("(二)土地利用总体规划情况分析",document);
        String tdghDesc = "";
        String tdghResult = "基于国家土地利用总体规划数据分析：";
        double cantJsArea = 0;
        if (info.tdghInfos != null) {
            int count = 0;
            int leng = info.tdghInfos.size();
            for (TdghInfo item : info.tdghInfos) {
                count++;
                tdghDesc += item.jsmc + "(" + item.jsbm + ")：" + PdfAnalyzeUtil.Round(item.area, 2) + "平方米";
                if (count < leng) {
                    tdghDesc += "/";
                }
                if ("040".equals(item.jsbm)) {
                    cantJsArea += item.area;
                }
                if ("030".equals(item.jsbm)) {
                    cantJsArea += item.area;
                }
            }
        }
        if (cantJsArea > 0) {
            result.passTdgh = EnumAnalyzeResult.NoPass;
            tdghResult += "拟建设项目区不符合土地利用总体规划。";
        } else {
            result.passTdgh = EnumAnalyzeResult.AllPass;
            tdghResult += "拟建设项目区符合土地利用总体规划。";
        }
        this.addContent(tdghResult,document);

        if (info.tdghImg != null) {
            AddImg("土地规划", info.tdghImg, tdghDesc,document);
        }
        this.addTdghDescribe("政策解读",document);
    }

    protected void addTdghDescribe(String role,Document document) throws DocumentException {
        AddRoleDesc("《中华人民共和国土地管理法》第二十五条 经批准的土地利用总体规划的修改，须经原审批机关批准；" +
                "未经批准，不得改变土地利用总体规划确定的土地用途。", role,document);
    }

    /**
     * 永久基本农田情况分析
     *
     * @param result
     * @param info
     * @param other
     * @throws DocumentException
     */
    protected void addJbntMessage(ResultInfo result, ProjectInfo info, ProjectInfo other,Document document) throws DocumentException {
        this.addSencondTitle("(一)永久基本农田情况分析",document);
        this.addJbntMessageContent(result, info, other,document);
    }

    protected void addJbntMessageContent(ResultInfo result, ProjectInfo info, ProjectInfo other,Document document) throws DocumentException {
        if (other.cityCode.startsWith("50")) {
            //重庆数据
            String jbntResult = "基于重庆基本农田数据分析：";
            if (null != other.jbntArea && other.jbntArea > 0) {
                result.passJbnt = EnumAnalyzeResult.NoPass;
                if (other.jbntArea < other.area) {
                    result.passJbnt = EnumAnalyzeResult.PartPass;
                }
                jbntResult += "拟建设项目区涉及永久基本农田，共" + PdfAnalyzeUtil.Round(other.jbntArea, 2) + "平方米。";
            } else {
                result.passJbnt = EnumAnalyzeResult.AllPass;
                jbntResult += "拟建设项目区不涉及永久基本农田。";
            }
            this.addContent(jbntResult,document);
            if (other.jbntImg != null) {
                String desc = "基本农田：" + PdfAnalyzeUtil.Round(other.jbntArea, 2) + "平方米";
                AddImg("永久基本农田", other.jbntImg, desc,document);
            }
        } else {
            String jbntResult = "基于国家基本农田数据分析：";
            if (info.jbntArea != null && info.jbntArea > 0) {
                result.passJbnt = EnumAnalyzeResult.NoPass;
                if (info.jbntArea < info.area) {
                    result.passJbnt = EnumAnalyzeResult.PartPass;
                }
                jbntResult += "拟建设项目区涉及永久基本农田，共" + PdfAnalyzeUtil.Round(info.jbntArea, 2) + "平方米。";
            } else {
                result.passJbnt = EnumAnalyzeResult.AllPass;
                jbntResult += "拟建设项目区不涉及永久基本农田。";
            }
            this.addContent(jbntResult,document);
            if (info.jbntImg != null) {
                String desc = "基本农田：" + PdfAnalyzeUtil.Round(info.jbntArea, 2) + "平方米，非基本农田：" + PdfAnalyzeUtil.Round((info.area - info.jbntArea), 2) + "平方米";
                AddImg("永久基本农田", info.jbntImg, desc,document);
            }
        }
    }

    protected void addJbntDescribe(String role,Document document) throws DocumentException {
        AddRoleDesc("《中华人民共和国土地管理法》第三十五条  基本农田经依法划定后，任何单位和个人不得擅自占用或者改变其用途。" +
                "国家能源、交通、水利、军事设施等重点建设项目选址确实难以避让永久基本农田，涉及农用地转用或者土地征收的，必须经国务院批准。", role,document);
    }

    protected void BzInfo(Document document) throws DocumentException {
        String content = "说明：由于我们不掌握环评信息和城乡规划数据等相关管理数据，云分析报告不涉及环评和城乡规划符合性等分析内容。";
        Paragraph contentPg = new Paragraph(content, redFont);
        contentPg.setFirstLineIndent(firstLineIndent);
        contentPg.setExtraParagraphSpace(30);
        contentPg.setSpacingBefore(pgSpace);
        contentPg.setLeading(lineSpace);
        document.add(contentPg);
    }

    protected void SuitableAnalysis(List<ProjectInfo> infoList, ResultInfo result,Document document) throws DocumentException {
        ProjectInfo info = this.getCountryNode(infoList);
        ProjectInfo other = this.getOtherNode(infoList);
        this.addFirstTitle("三、适宜性分析",document);
        this.addZdpqdjfzMessage(info,document);
        this.addDzzhMessage(info, result, "(二)地质灾害隐患分析",document);
        this.addDzzhDescribe("政策解读",document);
        this.addStydMessage(info, result,document);

        boolean hasGradeInfo = false;
        if (info.gradeInfos != null && info.gradeInfos.size() > 0) {
            hasGradeInfo = true;
            this.addZbphMessage(info,document);
        }
        this.addCghMessage(result, other, hasGradeInfo,document);
    }

    protected void addCghMessage(ResultInfo result, ProjectInfo info, boolean hasGradeInfo,Document document) throws DocumentException {
        String xh = hasGradeInfo ? "五" : "四";
        String title = "(" + xh + ")村规划情况分析";
        this.addSencondTitle(title,document);
        this.addCghContent(result, info,document);
        this.addCghDescribe("政策解读",document);
    }

    protected void addCghContent(ResultInfo result, ProjectInfo info,Document document) throws DocumentException {
        String resultMessage = "基于重庆村规划数据分析：";
        Boolean cantBuild = true;
        String desc = "";
        if (info.cghInfos != null) {
            resultMessage += "拟建项目区村规划中规划地类为";
            for (int i = 0; i < info.cghInfos.size(); i++) {
                CommonInfoCQ item = info.cghInfos.get(i);
                String type = item.type;
                Double typeArea = item.area;
                desc += type + ":" + PdfAnalyzeUtil.Round(typeArea, 2) + "平方米";
                if (i != info.cghInfos.size() - 1)
                    desc += "，";
                if (!("村居住用地").equals(type) && !"村居住用地(宅基地)".equals(type) && !"村居住用地（宅基地）".equals(type) && !"农村居民点用地".equals(type)
                        && !"宅基地".equals(type) && !"宅基地(村居住用地)".equals(type) && !"宅基地(村居住用地）".equals(type)
                        && !"宅基地（村居住用地）".equals(type) && !"宅基地（村居住用地)".equals(type) && typeArea > 0) {
                    cantBuild = false;
                }
            }
            resultMessage += desc + "。";
        } else {
            result.passCgh = EnumAnalyzeResult.AllPass;
            return;
        }
        if (!cantBuild) {
            result.passCgh = EnumAnalyzeResult.NoPass;
            resultMessage += "拟建设项目区不符合村庄规划。";
        } else {
            result.passCgh = EnumAnalyzeResult.AllPass;
            resultMessage += "拟建设项目区符合村庄规划。";
        }
        this.addContent(resultMessage,document);
        if (info.cghImg != null) {
            AddImg("村规划", info.cghImg, desc,document);
        }
    }

    protected void addCghDescribe(String role,Document document) throws DocumentException {
        AddRoleDesc("《自然资源部办公厅关于加强村庄规划促进乡村振兴的通知》 第十三条 优化调整用地布局。允许在不改变县级国土空间规划主要控制指标情况下，" +
                "优化调整村庄各类用地布局。涉及永久基本农田和生态保护红线调整的，严格按国家有关规定执行，调整结果依法落实到村庄规划中。", role,document);
    }

    protected void addZbphMessage(ProjectInfo info,Document document) throws DocumentException {
        this.addSencondTitle("(四)占补平衡情况分析",document);

        String zbphResult = "拟建设项目区";
        String first = "";
        double area = 0;
        String second = "";
        HashMap<String, Double> map = new HashMap<String, Double>();
        for (LandUseGrade g : info.gradeInfos) {
            if (map.containsKey(g.field2)) {
                double gradeArea = map.get(g.field2) + g.area;
                map.put(g.field2, gradeArea);

            } else {
                map.put(g.field2, g.area);
            }
            if (!first.equalsIgnoreCase(g.field1)) {
                if (second != null && !second.isEmpty()) {
                    zbphResult += "占" + first + PdfAnalyzeUtil.Round(area, 2) + "平方米，";
                    second = second.substring(0, second.length() - 1);
                    zbphResult += second + "；";
                }
                area = 0;
                second = "";
                first = g.field1;
            }

            area += g.area;
            if (g.field2 == null) {
                second += "耕地等别未知" + PdfAnalyzeUtil.Round(g.area, 2) + "平方米,";
            } else {
                second += "耕地等别为" + g.field2 + "等" + PdfAnalyzeUtil.Round(g.area, 2) + "平方米，";
            }
        }
        if (second != null && !second.isEmpty()) {
            zbphResult += "占" + first + PdfAnalyzeUtil.Round(area, 2) + "平方米，";
            second = second.substring(0, second.length() - 1);
            zbphResult += second + "。";
        }
        this.addContent(zbphResult,document);

        if (info.gradeImg != null) {
            String desc = "";
            for (Map.Entry m : map.entrySet()) {
                Object obj = m.getKey();
                String key = "";
                if (obj == null) {
                    key = "未知";
                } else {
                    key = obj.toString();
                    key += "等";
                }
                desc += key + PdfAnalyzeUtil.Round((double) m.getValue(), 2) + "平方米/";
            }
            desc = desc.substring(0, desc.length() - 1);
            AddImg("耕地等别", info.gradeImg, desc,document);
        }
        AddRoleDesc("《关于补足耕地数量与提升耕地质量相结合落实占补平衡的指导意见》提出，补改结合、提质改造必须坚持政府主导、因地制宜、维护农民权益和审慎稳妥推进的原则。", "政策解读",document);
        AddRoleDesc("《指导意见》明确了补改结合的适用范围，即对于单独选址建设项目受资源条件限制，无法落实占优补优、占水田补水田的，可通过补改结合落实；各类城市建设涉及占用耕地的，仍坚持先补后占和直接补充优质耕地，落实占优补优、占水田补水田。", null,document);
    }

    protected void addStydMessage(ProjectInfo info, ResultInfo result,Document document) throws DocumentException {
        this.addSencondTitle("(三)生态用地分析",document);

        String stydResult = "基于国家生态用地数据分析：";
        if (info.sdArea != null && info.sdArea > 0) {
            result.passSd = EnumAnalyzeResult.NoPass;
            if (info.sdArea < info.area) {
                result.passSd = EnumAnalyzeResult.PartPass;
            }
            stydResult += "拟建设项目区占用湿地，共" + PdfAnalyzeUtil.Round(info.sdArea, 2) + "平方米";
        } else {
            result.passSd = EnumAnalyzeResult.AllPass;
            stydResult += "拟建设项目区不占用湿地。";
        }

        this.addContent(stydResult,document);

        if (info.sdImg != null) {
            AddImg("生态用地", info.sdImg, "生态用地面积：" + PdfAnalyzeUtil.Round(info.sdArea, 2) + "平方米",document);
        }
        AddRoleDesc("《湿地保护管理规定》第十八条 因工程建设等造成国际重要湿地生态特征退化甚至消失的，省、自治区、直辖市人民政府林业主管部门应当会同同级人民政府有关部门督促、指导项目建设单位限期恢复，并向同级人民政府和国家林业局报告；对逾期不予恢复或者确实无法恢复的，由国家林业局会商所在地省、自治区、直辖市人民政府和国务院有关部门后，按照有关规定处理。", "政策解读",document);
        AddRoleDesc("《湿地保护管理规定》第三十条建设项目应当不占或者少占湿地，经批准确需征收、占用湿地并转为其他用途的，用地单位应当按照“先补后占、占补平衡”的原则，依法办理相关手续。", null,document);
        AddRoleDesc("临时占用湿地的，期限不得超过2年；临时占用期限届满，占用单位应当对所占湿地限期进行生态修复。", null,document);
    }

    protected void addDzzhMessage(ProjectInfo info, ResultInfo result, String title,Document document) throws DocumentException {
        this.addSencondTitle(title,document);
        this.addDzzhMessageContent(info, result,document);
    }

    protected void addDzzhMessageContent(ProjectInfo info, ResultInfo result,Document document) throws DocumentException {
        String dzzhResult = "基于国家地质灾害隐患数据分析：";
        double dzfxArea = 0;
        String dzfxDesc = "";
        if (info.dzfxInfos != null && info.dzfxInfos.size() > 0) {
            int count = 0;
            for (DzfxInfo dzfx : info.dzfxInfos) {
                count++;
                dzfxArea += dzfx.area;
                dzfxDesc += dzfx.level + PdfAnalyzeUtil.Round(dzfx.area, 2) + "平方米";
                if (count < info.dzfxInfos.size()) {
                    dzfxDesc += "/";
                }
            }
        }
        if (dzfxArea > 0) {
            result.passDzfx = EnumAnalyzeResult.NoPass;
            if (dzfxArea < info.area) {
                result.passDzfx = EnumAnalyzeResult.PartPass;
            }
            dzzhResult += "拟建设项目区存在地质灾害隐患。";
        } else {
            result.passDzfx = EnumAnalyzeResult.AllPass;
            if (info.provinceCode != null && info.provinceCode.startsWith("22")) {
                dzzhResult += "拟建设项目区不存在地质灾害隐患。";
            } else {
                dzzhResult += "拟建设项目区地质灾害隐患情况不详（无该区域地质灾害数据）。";
            }
        }
        this.addContent(dzzhResult,document);

        if (info.dzfxImg != null) {
            AddImg("地质灾害隐患", info.dzfxImg, dzfxDesc,document);
        }
    }

    protected void addDzzhDescribe(String role,Document document) throws DocumentException {
        AddRoleDesc("《地质灾害防治管理办法》第25条明确规定：“城市建设有可能导致地质灾害发生的工程项目建设和" +
                "地质灾害易发区内进行的工程建设在申请建设用地之前必须进行地质灾害风险性评估，评估结果由省级以上地质矿产行政主管部门认定。" +
                "不符合条件的，土地行政主管部门不予办理建设用地审批手续”。", role,document);
    }

    protected void addZdpqdjfzMessage(ProjectInfo info,Document document) throws DocumentException {
        this.addSencondTitle("(一)征地区片地价分析",document);

        String jzdjResult = "基于国家征地区片地价数据分析：";
        if (info.landPrice != null && info.landPrice > 0) {
            jzdjResult += "拟建设项目区征地区片地价为：" + PdfAnalyzeUtil.Round(info.landPrice, 2) + "元/平方米";
        } else {
            jzdjResult += "拟建设项目区征地区片地价未知 ";
        }
        this.addContent(jzdjResult,document);

        if (info.landPriceImg != null) {
            AddImg("征地区片地价", info.landPriceImg, PdfAnalyzeUtil.Round(info.landPrice, 2) + "元/平方米",document);
        }
        AddRoleDesc("《自然保护区土地管理办法》第四十八条第三款  征收农用地的土地补偿费、安置补助费标准由省、自治区、直辖市通过制定公布区片综合地价确定。制定区片综合地价应当综合考虑土地原用途、土地资源条件、土地产值、土地区位、土地供求关系、人口以及经济社会发展水平等因素，并至少每三年调整或者重新公布一次。", "政策解读",document);
    }

    protected void SummarizeAnalysis(ProjectInfo info, ResultInfo result,Document document) throws DocumentException {
        this.addFirstTitle("四、总体分析",document);
        String content = "根据已有数据分析结果，拟建设项目区";
        boolean legal = result.passJbnt == EnumAnalyzeResult.AllPass && result.passTdgh == EnumAnalyzeResult.AllPass
                && result.passSpba == EnumAnalyzeResult.AllPass && result.passZrbhq == EnumAnalyzeResult.AllPass
                && result.passSthx == EnumAnalyzeResult.AllPass && result.passJsydgzq == EnumAnalyzeResult.AllPass;
        boolean suitable = result.passDzfx == EnumAnalyzeResult.AllPass && result.passSd == EnumAnalyzeResult.AllPass;
        boolean unlegal = result.passJbnt == EnumAnalyzeResult.NoPass || result.passTdgh == EnumAnalyzeResult.NoPass
                || result.passSpba == EnumAnalyzeResult.NoPass || result.passZrbhq == EnumAnalyzeResult.NoPass
                || result.passSthx == EnumAnalyzeResult.NoPass || result.passJsydgzq == EnumAnalyzeResult.NoPass;
        boolean unsuitable = result.passDzfx == EnumAnalyzeResult.NoPass || result.passSd == EnumAnalyzeResult.NoPass;

        boolean allPass = legal && suitable;
        if (allPass) {
            content += "合法、适宜。";
            content += "不涉及占用永久基本农田、";
            content += "符合土地利用总体规划、";
            content += "有合法建设用地审批手续、";
            content += "不涉及占用自然保护地、";
            content += "不涉及生态红线";
            content += "涉及建设用地合法";
            content += "不存在地质灾害隐患、";
            content += "不占用湿地。";
        } else if (unlegal) {
            content += "不合法、不适宜。";
            switch (result.passJbnt) {
                case NoPass:
                    content += "涉及占用永久基本农田、";
                    break;
                case PartPass:
                    content += "部分区域涉及占用永久基本农田、";
                    break;
            }
            switch (result.passTdgh) {
                case NoPass:
                    content += "不符合土地利用总体规划、";
                    break;
                case PartPass:
                    content += "部分区域不符合土地利用总体规划、";
                    break;
            }
            switch (result.passSpba) {
                case NoPass:
                    content += "没有合法建设用地审批手续、";
                    break;
                case PartPass:
                    content += "部分区域没有合法建设用地审批手续、";
                    break;
            }
            switch (result.passZrbhq) {
                case NoPass:
                    content += "涉及占用自然保护地、";
                    break;
                case PartPass:
                    content += "部分区域涉及占用自然保护地、";
                    break;
            }
            switch (result.passSthx) {
                case NoPass:
                    content += "涉及生态红线、";
                    break;
                case PartPass:
                    content += "部分区域涉及生态红线、";
                    break;
            }
            switch (result.passJsydgzq) {
                case NoPass:
                    content += "涉及建设用地不合法、";
                    break;
                case PartPass:
                    content += "部分区域涉及建设用地不合法、";
                    break;
            }
            switch (result.passDzfx) {
                case NoPass:
                    content += "存在地质灾害隐患、";
                    break;
                case PartPass:
                    content += "部分区域存在地质灾害隐患、";
                    break;
            }
            switch (result.passSd) {
                case NoPass:
                    content += "占用湿地、";
                    break;
                case PartPass:
                    content += "部分区域占用湿地、";
                    break;
            }
            content = content.substring(0, content.length() - 1) + "。";
        } else if (unsuitable) {
            content += "不适宜。";
            switch (result.passDzfx) {
                case NoPass:
                    content += "存在地质灾害隐患、";
                    break;
                case PartPass:
                    content += "部分区域存在地质灾害隐患、";
                    break;
            }
            switch (result.passSd) {
                case NoPass:
                    content += "占用湿地、";
                    break;
                case PartPass:
                    content += "部分区域占用湿地、";
                    break;
            }
            content = content.substring(0, content.length() - 1) + "。";
        } else {
            boolean partlegal = false;
            boolean partsuitable = false;
            String tmp = "";
            if (result.passJbnt == EnumAnalyzeResult.PartPass) {
                tmp += "涉及占用永久基本农田、";
                partlegal = true;
            }
            if (result.passTdgh == EnumAnalyzeResult.PartPass) {
                tmp += "不符合土地利用总体规划、";
                partlegal = true;
            }
            if (result.passSpba == EnumAnalyzeResult.PartPass) {
                tmp += "没有合法建设用地审批手续、";
                partlegal = true;
            }
            if (result.passZrbhq == EnumAnalyzeResult.PartPass) {
                tmp += "涉及占用自然保护地、";
                partlegal = true;
            }
            if (result.passSthx == EnumAnalyzeResult.PartPass) {
                tmp += "涉及生态红线、";
                partlegal = true;
            }
            if (result.passDzfx == EnumAnalyzeResult.PartPass) {
                tmp += "存在地质灾害隐患、";
                partsuitable = true;
            }
            if (result.passSd == EnumAnalyzeResult.PartPass) {
                tmp += "占用湿地、";
                partsuitable = true;
            }
            if (!StringUtils.isEmpty(tmp))
                tmp = tmp.substring(0, tmp.length() - 1) + "。";
            if (partlegal && partsuitable) {
                content += "存在不符合法律法规、不适宜的情况。比如部分地区";
            } else if (partlegal) {
                content += "存在不符合法律法规的情况。比如部分地区";
            } else if (partsuitable) {
                content += "存在不适宜的情况。比如部分地区";
            }
            content += tmp;
        }

        this.addContent(content,document);
    }

    /**
     * 写入基本情况
     *
     * @param infoList
     * @throws DocumentException
     */
    protected void AddBaseImg(List<ProjectInfo> infoList,Document document) throws DocumentException {
        ProjectInfo info = this.getCountryNode(infoList);
        ProjectInfo otherInfo = this.getOtherNode(infoList);

        PdfPCell c1 = this.createImgTitle("项目区位置");
        PdfPCell c2 = this.createImgTitle("土地利用现状图");

        PdfPCell cimg1 = null;
        PdfPCell meta1 = null;
        if (null != otherInfo.ownershipImg) {//项目区位置图
            cimg1 = this.creaeteImgCell(otherInfo.ownershipImg);
            meta1 = this.createImgRoot(otherInfo.ownershipImgMeta);
        } else {
            cimg1 = this.creaeteImgCell(info.ownershipImg);
            meta1 = this.createImgRoot(info.ownershipImgMeta);
        }
        PdfPCell cimg2 = this.creaeteImgCell(info.landtypeImg);


        PdfPCell meta2 = this.createImgRoot(info.landtypeImgMeta);

        int col = 2;
        if (info.narrow) {
            col = 1;
            PdfPTable t1 = new PdfPTable(col);//创建一个1列表格对象
            t1.setSpacingBefore(pgSpace);//设置上边距
            t1.setSpacingAfter(pgSpace);//设置下边距
            t1.setWidthPercentage(80);

            PdfPTable t2 = new PdfPTable(col);//创建一个1列表格对象
            t2.setSpacingBefore(pgSpace);//设置上边距
            t2.setSpacingAfter(pgSpace);//设置下边距
            t2.setWidthPercentage(80);

            if (info.ownershipImg != null) {
                t1.addCell(c1);
                t1.addCell(cimg1);
                t1.addCell(meta1);
            }
            if (info.landtypeImg != null) {
                t2.addCell(c2);
                t2.addCell(cimg2);
                t2.addCell(meta2);
            }

            if (info.photo1 != null || info.photo2 != null) {//添加照片，暂时不可用
                this.addPhoto(info, t2);
            }

            document.add(t1);
            document.newPage();
            document.add(t2);
        } else {
            PdfPTable t = new PdfPTable(col);//创建一个2列表格对象
            t.setSpacingBefore(pgSpace);//设置上边距
            t.setSpacingAfter(pgSpace);//设置下边距
            t.setWidthPercentage(100);

            t.addCell(c1);
            t.addCell(c2);
            t.addCell(cimg1);
            t.addCell(cimg2);
            t.addCell(meta1);
            t.addCell(meta2);

            if (info.photo1 != null || info.photo2 != null) {
                this.addPhoto(info, t);
            }
            document.add(t);
        }
    }

    protected void AddImg(String title, Image img, String desc,Document document) throws DocumentException {
        PdfPTable t = new PdfPTable(1);
        t.setKeepTogether(true);
        t.setSpacingBefore(pgSpace);//设置上边距
        t.setSpacingAfter(pgSpace);//设置下边距
        t.setWidthPercentage(80);
        if (!StringUtils.isEmpty(title)) {
            PdfPCell titleCell = this.createImgTitle(title);
            t.addCell(titleCell);
        }
        PdfPCell cimg1 = this.creaeteImgCell(img);
        t.addCell(cimg1);
        PdfPCell descCell = this.createImgRoot(desc);
        t.addCell(descCell);

        document.add(t);
    }

    /**
     * 添加文字
     *
     * @param desc
     * @param role
     * @throws DocumentException
     */
    protected void AddRoleDesc(String desc, String role,Document document) throws DocumentException {
        float spaceBefore = 0;
        if (role != null && !role.isEmpty()) {
            String roleInfo = role + "：";
            Paragraph rolePg = new Paragraph(roleInfo, roleFont);
            rolePg.setFirstLineIndent(firstLineIndent);
            rolePg.setExtraParagraphSpace(30);
            rolePg.setSpacingBefore(7);
            rolePg.setLeading(lineSpace);
            document.add(rolePg);
            spaceBefore = 5;
        }
        Paragraph descPg = new Paragraph(desc, roleFont);
        descPg.setFirstLineIndent(firstLineIndent);
        descPg.setExtraParagraphSpace(30);
        descPg.setSpacingBefore(spaceBefore);
        descPg.setLeading(lineSpace);
        document.add(descPg);
    }

    protected void AddSign(ProjectInfo info,Document document) throws DocumentException {
        String sign = "报告人： " + info.userName;
        this.addSignContent(info.narrow, sign,document);
        String timeStr = "时  间： " + new SimpleDateFormat("yyyy-MM-dd").format(new Date()).toString();
        this.addSignContent(info.narrow, timeStr,document);
    }

    protected String getRegionByNode(String nodeid) {
        Optional<CloudQueryNode> node = this.nodeRepository.findById(nodeid);
        return node.isPresent()?node.get().getRegioncode():"";
    }

    /**
     * 获取国家节点数据
     *
     * @param list
     * @return
     */
    protected ProjectInfo getCountryNode(List<ProjectInfo> list) {
        for (int i = 0; i < list.size(); i++) {
            if (list.get(i).nodeRegion.equals("1"))
                return list.get(i);
        }
        return null;
    }

    /**
     * 获取省级节点数据
     *
     * @param list
     * @return
     */
    protected ProjectInfo getOtherNode(List<ProjectInfo> list) {
        for (int i = 0; i < list.size(); i++) {
            if (!list.get(i).nodeRegion.equals("1"))
                return list.get(i);
        }
        return null;
    }

    protected void addTitle(String txt, Font font,Document document) throws DocumentException {
        Paragraph title = new Paragraph(txt, font);
        title.setAlignment(Element.ALIGN_CENTER);
        document.add(title);
    }

    /**
     * 添加一级标题
     *
     * @param title
     * @return
     */
    protected void addFirstTitle(String title,Document document) throws DocumentException {
        Paragraph paragraph = new Paragraph(title, chapterFont);
        this.addContentTxtFormat(paragraph,document);
    }

    /**
     * 添加二级标题
     *
     * @param title
     * @return
     */
    protected void addSencondTitle(String title,Document document) throws DocumentException {
        Paragraph paragraph = new Paragraph(title, sectionFont);
        this.addContentTxtFormat(paragraph,document);
    }

    /**
     * 添加正文
     *
     * @param content
     * @return
     */
    protected void addContent(String content,Document document) throws DocumentException {
        this.addContent(content, 30,document);
    }

    protected void addContent(String content, Integer paragraphSpace,Document document) throws DocumentException {
        Paragraph paragraph = new Paragraph(content, normalFont);
        paragraph.setFirstLineIndent(firstLineIndent);
        this.addContentTxtFormat(paragraph, paragraphSpace,document);
    }

    protected void addContentItalicRed(String content,Document document) throws DocumentException {
        this.addContentItalicRed(content, 30,document);
    }

    protected void addContentItalicRed(String content, Integer paragraphSpace,Document document) throws DocumentException {
        Paragraph paragraph = new Paragraph(content, this.redItalicFont);
        paragraph.setFirstLineIndent(firstLineIndent);
        this.addContentTxtFormat(paragraph, paragraphSpace,document);
    }

    protected void addContentTxtFormat(Paragraph paragraph,Document document) throws DocumentException {
        this.addContentTxtFormat(paragraph, 30,document);
    }

    protected void addContentTxtFormat(Paragraph paragraph, Integer paragraphSpace,Document document) throws DocumentException {
        paragraph.setExtraParagraphSpace(paragraphSpace);
        paragraph.setSpacingBefore(pgSpace);
        paragraph.setLeading(lineSpace);
        document.add(paragraph);
    }

    /**
     * 添加图片名称
     *
     * @param title
     * @return
     */
    protected PdfPCell createImgTitle(String title) {
        if (StringUtils.isEmpty(title))
            return null;
        PdfPCell cell = new PdfPCell(new Phrase(title, normalFont));
        this.addImgTxtFormat(cell);
        return cell;
    }

    protected PdfPCell createContent(String title, Font font) {
        PdfPCell cell = new PdfPCell(new Phrase(title, font));
        this.addImgTxtFormat(cell);
        return cell;
    }

    /**
     * 添加图片
     *
     * @param img
     * @return
     */
    protected PdfPCell creaeteImgCell(Image img) {
        PdfPCell cimg = null;
        if (null == img) {
            cimg = new PdfPCell();
        } else {
            float width = 250;
            float heigth = img.getHeight() / (img.getWidth() / width);
            img.scaleToFit(width, heigth);
            cimg = new PdfPCell(img);
        }
        cimg.setVerticalAlignment(Element.ALIGN_CENTER);
        cimg.setHorizontalAlignment(Element.ALIGN_CENTER);
        cimg.setPaddingTop(5);
        cimg.setPaddingBottom(5);
        cimg.setPaddingLeft(5);
        cimg.setPaddingRight(5);
        return cimg;
    }

    /**
     * 添加图片底部文字
     *
     * @param text
     * @return
     */
    protected PdfPCell createImgRoot(String text) {
        PdfPCell meta = new PdfPCell(new Phrase(text, roleFont));
        this.addImgTxtFormat(meta);
        return meta;
    }

    void addImgTxtFormat(PdfPCell cell) {
        cell.setVerticalAlignment(Element.ALIGN_CENTER);
        cell.setHorizontalAlignment(Element.ALIGN_CENTER);
        cell.setPaddingTop(5);
        cell.setPaddingBottom(5);
    }

    protected void addPhoto(ProjectInfo info, PdfPTable t) {
        PdfPCell photo1 = this.createImgTitle("实地照片1");
        PdfPCell photo2 = this.createImgTitle("实地照片2");

        PdfPCell cp1 = null;
        if (info.photo1 != null) {
            Image img1 = Image.getInstance(info.photo1);
            cp1 = this.creaeteImgCell(img1);
        } else {
            cp1 = this.creaeteImgCell(null);
        }
        PdfPCell cp2 = null;
        if (info.photo2 != null) {
            Image img2 = Image.getInstance(info.photo2);
            cp2 = this.creaeteImgCell(img2);
        } else {
            cp2 = this.creaeteImgCell(null);
        }

        PdfPCell pmeta1 = this.createImgRoot(info.photoMeta1);
        PdfPCell pmeta2 = this.createImgRoot(info.photoMeta2);

        t.addCell(photo1);
        t.addCell(photo2);
        t.addCell(cp1);
        t.addCell(cp2);
        t.addCell(pmeta1);
        t.addCell(pmeta2);
    }

    protected void addSignContent(boolean narrow, String sign,Document document) throws DocumentException {
        Paragraph signPg = new Paragraph(sign, normalFont);
        signPg.setAlignment(Element.ALIGN_LEFT);
        if (narrow) {
            signPg.setFirstLineIndent(200);
        } else {
            signPg.setFirstLineIndent(300);
        }
        signPg.setExtraParagraphSpace(30);
        signPg.setSpacingBefore(24);
        signPg.setLeading(22);
        document.add(signPg);
    }
}
